/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.tests;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDIFunctionLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILineLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDILocator;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIFunctionBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.testplugin.CDebugHelper;
import org.eclipse.cdt.debug.testplugin.CProjectHelper;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class BreakpointTests
extends TestCase {
    IWorkspace workspace = ResourcesPlugin.getWorkspace();
    IWorkspaceRoot root = this.workspace.getRoot();
    static ICProject testProject = null;
    NullProgressMonitor monitor = new NullProgressMonitor();
    static ICDISession session = null;
    static ICDITarget[] targets = null;
    static /* synthetic */ Class class$0;

    public BreakpointTests(String string) {
        super(string);
        if (this.workspace == null) {
            Assert.fail((String)"Workspace was not setup");
        }
        if (this.root == null) {
            Assert.fail((String)"Workspace root was not setup");
        }
    }

    protected static void oneTimeSetUp() throws CoreException, InvocationTargetException, IOException {
        ResourcesPlugin.getWorkspace().getDescription().setAutoBuilding(false);
        Path path = new Path("resources/debugTest.zip");
        testProject = CProjectHelper.createCProjectWithImport("filetest", (IPath)path);
        if (testProject == null) {
            Assert.fail((String)"Unable to create project");
        }
        testProject.getProject().build(6, null);
    }

    protected void tearDown() throws CoreException {
        if (targets != null) {
            try {
                targets[0].terminate();
                targets = null;
            }
            catch (CDIException cDIException) {}
        }
        if (session != null) {
            try {
                session.terminate();
                session = null;
            }
            catch (CDIException cDIException) {}
        }
    }

    protected static void oneTimeTearDown() throws CoreException {
        if (targets != null) {
            try {
                targets[0].terminate();
            }
            catch (CDIException cDIException) {}
        }
        if (session != null) {
            try {
                session.terminate();
            }
            catch (CDIException cDIException) {}
        }
        CProjectHelper.delete(testProject);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.tests.BreakpointTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite((Class)clazz);
        TestSetup testSetup = new TestSetup((Test)testSuite){

            protected void setUp() throws FileNotFoundException, IOException, InterruptedException, InvocationTargetException, CoreException {
                BreakpointTests.oneTimeSetUp();
            }

            protected void tearDown() throws FileNotFoundException, IOException, CoreException {
                BreakpointTests.oneTimeTearDown();
            }
        };
        return testSetup;
    }

    public void testFunctionBreak() throws CoreException, MIException, IOException, CDIException, InterruptedException {
        boolean bl = false;
        ICDISession iCDISession = CDebugHelper.createSession("main", testProject);
        Assert.assertNotNull((Object)iCDISession);
        ICDITarget[] iCDITargetArray = iCDISession.getTargets();
        Assert.assertNotNull((Object)iCDITargetArray);
        Assert.assertTrue((iCDITargetArray.length > 0 ? 1 : 0) != 0);
        ICDITarget iCDITarget = iCDITargetArray[0];
        Assert.assertNotNull((Object)iCDITarget);
        ICDIFunctionLocation iCDIFunctionLocation = iCDITarget.createFunctionLocation(null, "func1");
        Assert.assertNotNull((Object)iCDIFunctionLocation);
        iCDITarget.setFunctionBreakpoint(0, iCDIFunctionLocation, null, false);
        iCDIFunctionLocation = iCDITarget.createFunctionLocation(null, "main");
        Assert.assertNotNull((Object)iCDIFunctionLocation);
        iCDITarget.setFunctionBreakpoint(0, iCDIFunctionLocation, null, false);
        iCDIFunctionLocation = iCDITarget.createFunctionLocation(null, "badname");
        Assert.assertNotNull((Object)iCDIFunctionLocation);
        try {
            iCDITarget.setFunctionBreakpoint(0, iCDIFunctionLocation, null, false);
        }
        catch (CDIException cDIException) {
            bl = true;
        }
        Assert.assertTrue((boolean)bl);
        iCDITarget.deleteAllBreakpoints();
        iCDIFunctionLocation = iCDITarget.createFunctionLocation(null, "func1");
        Assert.assertNotNull((Object)iCDIFunctionLocation);
        iCDITarget.setFunctionBreakpoint(0, iCDIFunctionLocation, null, false);
        iCDITargetArray = iCDISession.getTargets();
        Assert.assertTrue((iCDITargetArray.length == 1 ? 1 : 0) != 0);
        iCDITargetArray[0].resume();
        int n = 0;
        while (n < 100) {
            if (iCDITargetArray[0].isTerminated() || iCDITargetArray[0].isSuspended()) break;
            Thread.sleep(100L);
            ++n;
        }
        Assert.assertTrue((boolean)iCDITargetArray[0].isSuspended());
        ICDILocator iCDILocator = iCDITargetArray[0].getCurrentThread().getStackFrames()[0].getLocator();
        Assert.assertTrue((iCDILocator.getLineNumber() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iCDILocator.getFunction().equals("func1"));
        Assert.assertTrue((boolean)iCDILocator.getFile().equals("main.c"));
        iCDITargetArray[0].terminate();
        int n2 = 0;
        while (!iCDITargetArray[0].isTerminated() && n2 < 30) {
            Thread.sleep(100L);
        }
        if (!iCDITargetArray[0].isTerminated()) {
            iCDITargetArray[0].terminate();
        }
        iCDISession.terminate();
        iCDISession = null;
        iCDITargetArray = null;
    }

    public void testLineBreak() throws CoreException, MIException, IOException, CDIException, InterruptedException {
        boolean bl = false;
        session = CDebugHelper.createSession("main", testProject);
        Assert.assertNotNull((Object)session);
        ICDITarget[] iCDITargetArray = session.getTargets();
        Assert.assertNotNull((Object)iCDITargetArray);
        Assert.assertTrue((iCDITargetArray.length > 0 ? 1 : 0) != 0);
        ICDITarget iCDITarget = iCDITargetArray[0];
        Assert.assertNotNull((Object)iCDITarget);
        ICDILineLocation iCDILineLocation = iCDITarget.createLineLocation("main.c", 7);
        Assert.assertNotNull((Object)iCDILineLocation);
        iCDITarget.setLineBreakpoint(0, iCDILineLocation, null, false);
        iCDILineLocation = iCDITarget.createLineLocation("main.c", 18);
        Assert.assertNotNull((Object)iCDILineLocation);
        iCDITarget.setLineBreakpoint(0, iCDILineLocation, null, false);
        iCDILineLocation = iCDITarget.createLineLocation("main.c", 30);
        Assert.assertNotNull((Object)iCDILineLocation);
        try {
            iCDITarget.setLineBreakpoint(0, iCDILineLocation, null, false);
        }
        catch (CDIException cDIException) {
            bl = true;
        }
        Assert.assertTrue((boolean)bl);
        bl = false;
        iCDILineLocation = iCDITarget.createLineLocation("main.c", 11);
        Assert.assertNotNull((Object)iCDILineLocation);
        iCDITarget.setLineBreakpoint(0, iCDILineLocation, null, false);
        iCDILineLocation = iCDITarget.createLineLocation(null, 7);
        Assert.assertNotNull((Object)iCDILineLocation);
        iCDITarget.setLineBreakpoint(0, iCDILineLocation, null, false);
        bl = false;
        iCDILineLocation = iCDITarget.createLineLocation(null, 30);
        Assert.assertNotNull((Object)iCDILineLocation);
        try {
            iCDITarget.setLineBreakpoint(0, iCDILineLocation, null, false);
        }
        catch (CDIException cDIException) {
            bl = true;
        }
        Assert.assertTrue((String)"Ignoring line numbers with no file specified?", (boolean)bl);
        iCDITarget.deleteAllBreakpoints();
        iCDILineLocation = iCDITarget.createLineLocation(null, 7);
        Assert.assertNotNull((Object)iCDILineLocation);
        iCDITarget.setLineBreakpoint(0, iCDILineLocation, null, false);
        iCDITargetArray = session.getTargets();
        Assert.assertTrue((iCDITargetArray.length == 1 ? 1 : 0) != 0);
        iCDITargetArray[0].resume();
        int n = 0;
        while (n < 100) {
            if (iCDITargetArray[0].isSuspended() || iCDITargetArray[0].isTerminated()) break;
            Thread.sleep(100L);
            ++n;
        }
        Assert.assertTrue((String)("Suspended: " + iCDITargetArray[0].isSuspended() + " Termiunated: " + iCDITargetArray[0].isTerminated()), (boolean)iCDITargetArray[0].isSuspended());
        ICDILocator iCDILocator = iCDITargetArray[0].getCurrentThread().getStackFrames()[0].getLocator();
        Assert.assertTrue((iCDILocator.getLineNumber() == 7 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iCDILocator.getFunction().equals("func1"));
        Assert.assertTrue((boolean)iCDILocator.getFile().equals("main.c"));
        session.terminate();
        session = null;
        iCDITargetArray = null;
    }

    public void testGetBreak() throws CoreException, MIException, IOException, CDIException {
        session = CDebugHelper.createSession("main", testProject);
        Assert.assertNotNull((Object)session);
        ICDITarget[] iCDITargetArray = session.getTargets();
        Assert.assertNotNull((Object)iCDITargetArray);
        Assert.assertTrue((iCDITargetArray.length > 0 ? 1 : 0) != 0);
        ICDITarget iCDITarget = iCDITargetArray[0];
        Assert.assertNotNull((Object)iCDITarget);
        ICDIBreakpoint[] iCDIBreakpointArray = iCDITarget.getBreakpoints();
        Assert.assertNotNull((Object)iCDIBreakpointArray);
        Assert.assertTrue((iCDIBreakpointArray.length == 0 ? 1 : 0) != 0);
        ICDIFunctionLocation iCDIFunctionLocation = iCDITarget.createFunctionLocation("main.c", "func1");
        Assert.assertNotNull((Object)iCDIFunctionLocation);
        iCDITarget.setFunctionBreakpoint(0, iCDIFunctionLocation, null, false);
        iCDIBreakpointArray = iCDITarget.getBreakpoints();
        Assert.assertNotNull((Object)iCDIBreakpointArray);
        Assert.assertTrue((iCDIBreakpointArray.length == 1 ? 1 : 0) != 0);
        Object object = iCDIBreakpointArray[0] instanceof ICDILocationBreakpoint ? (ICDILocationBreakpoint)iCDIBreakpointArray[0] : null;
        Assert.assertNotNull(object);
        ICDILocator iCDILocator = object.getLocator();
        String string = iCDILocator.getFile();
        String string2 = iCDILocator.getFunction();
        Assert.assertTrue((boolean)"main.c".equals(string));
        Assert.assertTrue((boolean)"func1".equals(string2));
        iCDIFunctionLocation = iCDITarget.createFunctionLocation("main.c", "main");
        Assert.assertNotNull((Object)iCDIFunctionLocation);
        iCDITarget.setFunctionBreakpoint(0, iCDIFunctionLocation, null, false);
        iCDIBreakpointArray = iCDITarget.getBreakpoints();
        Assert.assertNotNull((Object)iCDIBreakpointArray);
        Assert.assertTrue((iCDIBreakpointArray.length == 2 ? 1 : 0) != 0);
        object = iCDIBreakpointArray[1] instanceof ICDILocationBreakpoint ? (ICDILocationBreakpoint)iCDIBreakpointArray[1] : null;
        Assert.assertNotNull((Object)object);
        iCDILocator = object.getLocator();
        string = iCDILocator.getFile();
        string2 = iCDILocator.getFunction();
        Assert.assertTrue((boolean)"main.c".equals(string));
        Assert.assertTrue((boolean)"main".equals(string2));
        iCDITarget.deleteAllBreakpoints();
        session.terminate();
        session = null;
    }

    public void testDelBreak() throws CoreException, MIException, IOException, CDIException {
        ICDILineLocation iCDILineLocation;
        session = CDebugHelper.createSession("main", testProject);
        Assert.assertNotNull((Object)session);
        ICDITarget[] iCDITargetArray = session.getTargets();
        Assert.assertNotNull((Object)iCDITargetArray);
        Assert.assertTrue((iCDITargetArray.length > 0 ? 1 : 0) != 0);
        ICDITarget iCDITarget = iCDITargetArray[0];
        Assert.assertNotNull((Object)iCDITarget);
        ICDIBreakpoint[] iCDIBreakpointArray = iCDITarget.getBreakpoints();
        Assert.assertNotNull((Object)iCDIBreakpointArray);
        Assert.assertTrue((iCDIBreakpointArray.length == 0 ? 1 : 0) != 0);
        ICDIFunctionLocation iCDIFunctionLocation = iCDITarget.createFunctionLocation("main.c", "func1");
        Assert.assertNotNull((Object)iCDIFunctionLocation);
        ICDIFunctionBreakpoint iCDIFunctionBreakpoint = iCDITarget.setFunctionBreakpoint(0, iCDIFunctionLocation, null, false);
        iCDITarget.deleteBreakpoints(new ICDIBreakpoint[]{iCDIFunctionBreakpoint});
        this.pause();
        iCDIBreakpointArray = iCDITarget.getBreakpoints();
        Assert.assertTrue((iCDIBreakpointArray.length == 0 ? 1 : 0) != 0);
        iCDIFunctionLocation = iCDITarget.createFunctionLocation("main.c", "func1");
        Assert.assertNotNull((Object)iCDIFunctionLocation);
        iCDIFunctionBreakpoint = iCDITarget.setFunctionBreakpoint(0, iCDIFunctionLocation, null, false);
        ICDILocator iCDILocator = iCDIFunctionBreakpoint.getLocator();
        iCDIFunctionLocation = iCDITarget.createFunctionLocation("main.c", "main");
        Assert.assertNotNull((Object)iCDIFunctionLocation);
        iCDIFunctionBreakpoint = iCDITarget.setFunctionBreakpoint(0, iCDIFunctionLocation, null, false);
        iCDITarget.deleteBreakpoints(new ICDIBreakpoint[]{iCDIFunctionBreakpoint});
        this.pause();
        iCDIBreakpointArray = iCDITarget.getBreakpoints();
        Assert.assertTrue((iCDIBreakpointArray.length == 1 ? 1 : 0) != 0);
        iCDIFunctionBreakpoint = (ICDILocationBreakpoint)iCDIBreakpointArray[0];
        Assert.assertNotNull((Object)iCDIFunctionBreakpoint);
        Assert.assertTrue((boolean)iCDIFunctionBreakpoint.getLocator().equals((ICDILocation)iCDILocator));
        iCDITarget.deleteBreakpoints(new ICDIBreakpoint[]{iCDIFunctionBreakpoint});
        this.pause();
        iCDIBreakpointArray = iCDITarget.getBreakpoints();
        Assert.assertTrue((iCDIBreakpointArray.length == 0 ? 1 : 0) != 0);
        ICDIBreakpoint[] iCDIBreakpointArray2 = new ICDIBreakpoint[1];
        int n = 0;
        while (n < 10) {
            iCDILineLocation = iCDITarget.createLineLocation("main.c", n + 1);
            iCDIBreakpointArray2[0] = iCDITarget.setLineBreakpoint(0, iCDILineLocation, null, false);
            Assert.assertNotNull((Object)iCDIBreakpointArray2[0]);
            ++n;
        }
        iCDITarget.deleteBreakpoints(iCDIBreakpointArray2);
        this.pause();
        iCDIBreakpointArray = iCDITarget.getBreakpoints();
        Assert.assertTrue((iCDIBreakpointArray.length == 9 ? 1 : 0) != 0);
        n = 0;
        while (n < iCDIBreakpointArray.length) {
            iCDIFunctionBreakpoint = (ICDILocationBreakpoint)iCDIBreakpointArray[n];
            Assert.assertTrue((iCDIFunctionBreakpoint.getLocator().getLineNumber() == n + 1 ? 1 : 0) != 0);
            ++n;
        }
        iCDITarget.deleteAllBreakpoints();
        this.pause();
        Assert.assertTrue((iCDITarget.getBreakpoints().length == 0 ? 1 : 0) != 0);
        iCDIBreakpointArray2 = new ICDIBreakpoint[4];
        n = 0;
        while (n < 10) {
            iCDILineLocation = iCDITarget.createLineLocation("main.c", n + 1);
            iCDIBreakpointArray2[n % 4] = iCDITarget.setLineBreakpoint(0, iCDILineLocation, null, false);
            Assert.assertNotNull((Object)iCDIBreakpointArray2[n % 4]);
            ++n;
        }
        iCDITarget.deleteBreakpoints(iCDIBreakpointArray2);
        this.pause();
        iCDIBreakpointArray = iCDITarget.getBreakpoints();
        Assert.assertTrue((iCDIBreakpointArray.length == 6 ? 1 : 0) != 0);
        n = 0;
        while (n < iCDIBreakpointArray.length) {
            iCDIFunctionBreakpoint = (ICDILocationBreakpoint)iCDIBreakpointArray[n];
            Assert.assertTrue((iCDIFunctionBreakpoint.getLocator().getLineNumber() == n + 1 ? 1 : 0) != 0);
            ++n;
        }
        iCDITarget.deleteAllBreakpoints();
        this.pause();
        Assert.assertTrue((iCDITarget.getBreakpoints().length == 0 ? 1 : 0) != 0);
        iCDIBreakpointArray2 = new ICDIBreakpoint[10];
        n = 0;
        while (n < 10) {
            iCDILineLocation = iCDITarget.createLineLocation("main.c", n + 1);
            iCDIBreakpointArray2[n] = iCDITarget.setLineBreakpoint(0, iCDILineLocation, null, false);
            Assert.assertNotNull((Object)iCDIBreakpointArray2[n]);
            ++n;
        }
        iCDITarget.deleteBreakpoints(iCDIBreakpointArray2);
        this.pause();
        iCDIBreakpointArray = iCDITarget.getBreakpoints();
        Assert.assertTrue((iCDIBreakpointArray.length == 0 ? 1 : 0) != 0);
        n = 0;
        while (n < 10) {
            iCDILineLocation = iCDITarget.createLineLocation("main.c", n + 1);
            iCDIFunctionBreakpoint = iCDITarget.setLineBreakpoint(0, iCDILineLocation, null, false);
            Assert.assertNotNull((Object)iCDIFunctionBreakpoint);
            ++n;
        }
        iCDITarget.deleteAllBreakpoints();
        this.pause();
        iCDIBreakpointArray = iCDITarget.getBreakpoints();
        Assert.assertTrue((iCDIBreakpointArray.length == 0 ? 1 : 0) != 0);
        session.terminate();
        session = null;
    }

    public void testCondBreak() throws CoreException, MIException, IOException, CDIException, InterruptedException {
        boolean bl = false;
        session = CDebugHelper.createSession("main", testProject);
        Assert.assertNotNull((Object)session);
        ICDITarget[] iCDITargetArray = session.getTargets();
        Assert.assertNotNull((Object)iCDITargetArray);
        Assert.assertTrue((iCDITargetArray.length > 0 ? 1 : 0) != 0);
        ICDITarget iCDITarget = iCDITargetArray[0];
        Assert.assertNotNull((Object)iCDITarget);
        ICDICondition iCDICondition = iCDITarget.createCondition(0, "");
        ICDIFunctionLocation iCDIFunctionLocation = iCDITarget.createFunctionLocation(null, "func1");
        Assert.assertNotNull((Object)iCDIFunctionLocation);
        iCDITarget.setFunctionBreakpoint(0, iCDIFunctionLocation, iCDICondition, false);
        iCDICondition = iCDITarget.createCondition(0, "x<10");
        iCDIFunctionLocation = iCDITarget.createFunctionLocation(null, "func1");
        Assert.assertNotNull((Object)iCDIFunctionLocation);
        iCDITarget.setFunctionBreakpoint(0, iCDIFunctionLocation, iCDICondition, false);
        iCDICondition = iCDITarget.createCondition(0, "nonexist<10");
        iCDIFunctionLocation = iCDITarget.createFunctionLocation(null, "func1");
        Assert.assertNotNull((Object)iCDIFunctionLocation);
        try {
            iCDITarget.setFunctionBreakpoint(0, iCDIFunctionLocation, iCDICondition, false);
        }
        catch (CDIException cDIException) {
            bl = true;
        }
        Assert.assertTrue((boolean)bl);
        iCDITarget.deleteAllBreakpoints();
        ICDILineLocation iCDILineLocation = iCDITarget.createLineLocation(null, 23);
        Assert.assertNotNull((Object)iCDIFunctionLocation);
        iCDICondition = iCDITarget.createCondition(0, "a>10");
        iCDITarget.setLineBreakpoint(0, iCDILineLocation, iCDICondition, false);
        iCDITargetArray = session.getTargets();
        Assert.assertTrue((iCDITargetArray.length == 1 ? 1 : 0) != 0);
        iCDITargetArray[0].resume();
        int n = 0;
        while (n < 100) {
            if (iCDITargetArray[0].isSuspended() || iCDITargetArray[0].isTerminated()) break;
            Thread.sleep(100L);
            ++n;
        }
        Assert.assertTrue((String)("Suspended: " + iCDITargetArray[0].isSuspended() + " Termiunated: " + iCDITargetArray[0].isTerminated()), (boolean)iCDITargetArray[0].isSuspended());
        ICDIStackFrame iCDIStackFrame = iCDITargetArray[0].getCurrentThread().getStackFrames()[0];
        ICDILocator iCDILocator = iCDIStackFrame.getLocator();
        Assert.assertTrue((iCDILocator.getLineNumber() == 23 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iCDILocator.getFunction().equals("main"));
        Assert.assertTrue((boolean)iCDILocator.getFile().equals("main.c"));
        Assert.assertTrue((String)iCDITargetArray[0].evaluateExpressionToString(iCDIStackFrame, "a"), (boolean)iCDITargetArray[0].evaluateExpressionToString(iCDIStackFrame, "a").equals("11"));
        session.terminate();
        session = null;
        iCDITargetArray = null;
    }

    void pause() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
    }
}

