/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class ManagedBuildCoreTests20
extends TestCase {
    private static final boolean boolVal = true;
    private static final String testConfigId = "test.config.override";
    private static final String testConfigName = "Tester";
    private static final String enumVal = "Another Enum";
    private static final String[] listVal = new String[]{"_DEBUG", "/usr/include", "libglade.a"};
    private static final String newExt = "wen";
    private static final String projectName = "ManagedBuildTest";
    private static final String projectName2 = "ManagedBuildTest2";
    private static final String projectRename = "ManagedBuildRedux";
    private static final String rootExt = "toor";
    private static final String stringVal = "-c -Wall";
    private static final String anotherStringVal = "thevalue";
    private static final String subExt = "bus";
    static /* synthetic */ Class class$0;

    public ManagedBuildCoreTests20(String string) {
        super(string);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.ManagedBuildCoreTests20");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new ManagedBuildCoreTests20("testExtensions"));
        testSuite.addTest((Test)new ManagedBuildCoreTests20("testProjectCreation"));
        testSuite.addTest((Test)new ManagedBuildCoreTests20("testConfigurations"));
        testSuite.addTest((Test)new ManagedBuildCoreTests20("testConfigurationReset"));
        testSuite.addTest((Test)new ManagedBuildCoreTests20("testConfigBuildArtifact"));
        testSuite.addTest((Test)new ManagedBuildCoreTests20("testMakeCommandManipulation"));
        testSuite.addTest((Test)new ManagedBuildCoreTests20("testScannerInfoInterface"));
        testSuite.addTest((Test)new ManagedBuildCoreTests20("testBug43450"));
        testSuite.addTest((Test)new ManagedBuildCoreTests20("testProjectRename"));
        testSuite.addTest((Test)new ManagedBuildCoreTests20("testErrorParsers"));
        testSuite.addTest((Test)new ManagedBuildCoreTests20("cleanup"));
        return testSuite;
    }

    public void testExtensions() throws Exception {
        IProjectType iProjectType = null;
        IProjectType iProjectType2 = null;
        IProjectType iProjectType3 = null;
        IProjectType iProjectType4 = null;
        IProjectType iProjectType5 = null;
        IProjectType iProjectType6 = null;
        int n = 0;
        IProjectType[] iProjectTypeArray = ManagedBuildManager.getDefinedProjectTypes();
        int n2 = 0;
        while (n2 < iProjectTypeArray.length) {
            IProjectType iProjectType7 = iProjectTypeArray[n2];
            if (iProjectType7.getName().equals("Test Root")) {
                iProjectType = iProjectType7;
                this.checkRootProjectType(iProjectType);
            } else if (iProjectType7.getName().equals("Test Sub")) {
                iProjectType2 = iProjectType7;
                this.checkSubProjectType(iProjectType2);
            } else if (iProjectType7.getName().equals("Test Sub Sub")) {
                iProjectType3 = iProjectType7;
                this.checkSubSubProjectType(iProjectType3);
            } else if (iProjectType7.getName().equals("Forward Child")) {
                iProjectType4 = iProjectType7;
            } else if (iProjectType7.getName().equals("Forward Parent")) {
                iProjectType5 = iProjectType7;
            } else if (iProjectType7.getName().equals("Forward Grandchild")) {
                iProjectType6 = iProjectType7;
            } else if (iProjectType7.getId().startsWith("test.provider.Test_")) {
                ++n;
                this.checkProviderProjectType(iProjectType7);
            }
            ++n2;
        }
        Assert.assertNotNull(iProjectType4);
        Assert.assertNotNull(iProjectType5);
        Assert.assertNotNull(iProjectType6);
        this.checkForwardProjectTypes(iProjectType5, iProjectType4, iProjectType6);
        Assert.assertEquals((int)3, (int)n);
        Assert.assertNotNull((Object)iProjectType);
        Assert.assertNotNull((Object)iProjectType2);
        Assert.assertNotNull(iProjectType3);
    }

    public void testMakeCommandManipulation() {
        IProjectDescription iProjectDescription;
        String string = "make";
        String string2 = "Ant";
        IProject iProject = null;
        try {
            iProject = this.createProject(projectName);
            iProjectDescription = iProject.getDescription();
            if (iProjectDescription != null) {
                Assert.assertTrue((boolean)iProjectDescription.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to open project in 'testMakeCommandManipulation': " + coreException.getLocalizedMessage()));
        }
        Assert.assertNotNull((Object)iProject);
        iProjectDescription = ManagedBuildManager.getBuildInfo((IResource)iProject);
        Assert.assertNotNull((Object)iProjectDescription);
        IManagedProject iManagedProject = iProjectDescription.getManagedProject();
        Assert.assertNotNull((Object)iManagedProject);
        IConfiguration iConfiguration = iProjectDescription.getDefaultConfiguration();
        Assert.assertNotNull((Object)iConfiguration);
        Assert.assertFalse((boolean)iConfiguration.hasOverriddenBuildCommand());
        Assert.assertEquals((String)string, (String)iConfiguration.getBuildCommand());
        iConfiguration.setBuildCommand(string2);
        Assert.assertEquals((String)string2, (String)iConfiguration.getBuildCommand());
        Assert.assertTrue((boolean)iConfiguration.hasOverriddenBuildCommand());
        iConfiguration.setBuildCommand(null);
        Assert.assertFalse((boolean)iConfiguration.hasOverriddenBuildCommand());
        Assert.assertEquals((String)string, (String)iConfiguration.getBuildCommand());
        ManagedBuildManager.saveBuildInfo((IProject)iProject, (boolean)false);
    }

    public void testScannerInfoInterface() {
        IOption[] iOptionArray;
        Path path;
        Object[] objectArray;
        IProject iProject = null;
        try {
            iProject = this.createProject(projectName);
            objectArray = iProject.getDescription();
            if (objectArray != null) {
                Assert.assertTrue((boolean)objectArray.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to open project in 'testScannerInfoInterface': " + coreException.getLocalizedMessage()));
        }
        objectArray = new String[]{new Path("/usr/include").toString(), new Path("/opt/gnome/include").toString(), (path = new Path("C:\\home\\tester/include")).isAbsolute() ? path.toString() : iProject.getLocation().append("Sub Config").append((IPath)path).toString(), iProject.getLocation().append("includes").toString(), new Path("/usr/gnu/include").toString()};
        IProjectType iProjectType = ManagedBuildManager.getExtensionProjectType((String)"test.sub");
        Assert.assertNotNull((Object)iProjectType);
        IManagedProject iManagedProject = null;
        try {
            iManagedProject = ManagedBuildManager.createManagedProject((IResource)iProject, (IProjectType)iProjectType);
        }
        catch (BuildException buildException) {
            Assert.fail((String)("Failed creating new project: " + buildException.getLocalizedMessage()));
        }
        Assert.assertNotNull((Object)iManagedProject);
        ManagedBuildManager.setNewProjectVersion((IProject)iProject);
        IConfiguration[] iConfigurationArray = iProjectType.getConfigurations();
        int n = 0;
        while (n < iConfigurationArray.length) {
            iManagedProject.createConfiguration(iConfigurationArray[n], String.valueOf(iConfigurationArray[n].getId()) + "." + n);
            ++n;
        }
        IConfiguration[] iConfigurationArray2 = iManagedProject.getConfigurations();
        Assert.assertEquals((int)4, (int)iConfigurationArray2.length);
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        iManagedBuildInfo.setDefaultConfiguration(iManagedProject.getConfiguration(iConfigurationArray2[0].getId()));
        ManagedBuildManager.saveBuildInfo((IProject)iProject, (boolean)true);
        ManagedBuildManager.removeBuildInfo((IResource)iProject);
        try {
            iProject.close(null);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed on project close: " + coreException.getLocalizedMessage()));
        }
        try {
            iProject.open(null);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed on project open: " + coreException.getLocalizedMessage()));
        }
        iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core.ScannerInfoProvider");
        if (iExtensionPoint == null) {
            Assert.fail((String)"Failed to retrieve the extension point ScannerInfoProvider.");
        }
        IScannerInfoProvider iScannerInfoProvider = CCorePlugin.getDefault().getScannerInfoProvider(iProject);
        Assert.assertNotNull((Object)iScannerInfoProvider);
        iScannerInfoProvider.subscribe((IResource)iProject, new IScannerInfoChangeListener((String[])objectArray){
            private final /* synthetic */ String[] val$expectedPaths;
            {
                this.val$expectedPaths = stringArray;
            }

            public void changeNotification(IResource iResource, IScannerInfo iScannerInfo) {
                Map map = iScannerInfo.getDefinedSymbols();
                Assert.assertTrue((boolean)map.containsKey("BUILTIN"));
                Assert.assertTrue((boolean)map.containsKey("DEBUG"));
                Assert.assertTrue((boolean)map.containsKey("GNOME"));
                Assert.assertTrue((boolean)map.containsValue("ME"));
                Assert.assertEquals((String)((String)map.get("BUILTIN")), (String)"");
                Assert.assertEquals((String)((String)map.get("DEBUG")), (String)"");
                Assert.assertEquals((String)((String)map.get("GNOME")), (String)"ME");
                Object[] objectArray = iScannerInfo.getIncludePaths();
                Assert.assertTrue((boolean)Arrays.equals(this.val$expectedPaths, objectArray));
            }
        });
        IScannerInfo iScannerInfo = iScannerInfoProvider.getScannerInformation((IResource)iProject);
        Map map = iScannerInfo.getDefinedSymbols();
        Assert.assertTrue((boolean)map.containsKey("BUILTIN"));
        Assert.assertEquals((String)((String)map.get("BUILTIN")), (String)"");
        Object[] objectArray2 = iScannerInfo.getIncludePaths();
        Assert.assertTrue((boolean)Arrays.equals(objectArray, objectArray2));
        String[] stringArray = new String[]{"DEBUG", "GNOME = ME "};
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
        ITool[] iToolArray = iConfiguration.getTools();
        IOption[] iOptionArray2 = null;
        int n2 = 0;
        while (n2 < iToolArray.length) {
            iOptionArray = iToolArray[n2];
            if ("tool.sub".equalsIgnoreCase(iOptionArray.getSuperClass().getId())) {
                iOptionArray2 = iOptionArray;
                break;
            }
            ++n2;
        }
        Assert.assertNotNull(iOptionArray2);
        IOption iOption = null;
        iOptionArray = iOptionArray2.getOptions();
        int n3 = 0;
        while (n3 < iOptionArray.length) {
            IOption iOption2 = iOptionArray[n3];
            try {
                if (iOption2.getValueType() == 5) {
                    iOption = iOption2;
                    break;
                }
            }
            catch (BuildException buildException) {
                Assert.fail((String)("Failed getting option value-type: " + buildException.getLocalizedMessage()));
            }
            ++n3;
        }
        Assert.assertNotNull(iOption);
        IManagedBuildInfo iManagedBuildInfo2 = ManagedBuildManager.getBuildInfo((IResource)iProject);
        Assert.assertFalse((boolean)iManagedBuildInfo2.isDirty());
        ManagedBuildManager.setOption((IConfiguration)iConfiguration, (IHoldsOptions)iOptionArray2, (IOption)iOption, (String[])stringArray);
        Assert.assertTrue((boolean)iManagedBuildInfo2.isDirty());
        iManagedBuildInfo2.setDirty(false);
        Assert.assertFalse((boolean)iManagedBuildInfo2.isDirty());
    }

    public void testConfigurations() throws CoreException, BuildException {
        IProject iProject = this.createProject(projectName);
        IProjectDescription iProjectDescription = iProject.getDescription();
        if (iProjectDescription != null) {
            Assert.assertTrue((boolean)iProjectDescription.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
        }
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        IConfiguration[] iConfigurationArray = iManagedProject.getConfigurations();
        Assert.assertEquals((int)3, (int)iConfigurationArray.length);
        IConfiguration iConfiguration = iConfigurationArray[0];
        Assert.assertEquals((String)iConfigurationArray[0].getName(), (String)"Root Config");
        Assert.assertEquals((String)iConfigurationArray[1].getName(), (String)"Root Override Config");
        Assert.assertEquals((String)iConfigurationArray[2].getName(), (String)"Complete Override Config");
        IConfiguration iConfiguration2 = iManagedProject.createConfigurationClone(iConfiguration, testConfigId);
        Assert.assertEquals((int)4, (int)iManagedProject.getConfigurations().length);
        iConfiguration2.setName(testConfigName);
        Assert.assertEquals((String)iConfiguration2.getId(), (String)testConfigId);
        Assert.assertEquals((String)iConfiguration2.getName(), (String)testConfigName);
        ITool[] iToolArray = iConfiguration2.getTools();
        Assert.assertEquals((int)1, (int)iToolArray.length);
        ITool iTool = iToolArray[0];
        Assert.assertEquals((String)iTool.getToolCommand(), (String)"doIt");
        iConfiguration2.setToolCommand(iTool, "never");
        Assert.assertEquals((String)iTool.getToolCommand(), (String)"never");
        IOptionCategory iOptionCategory = iTool.getTopOptionCategory();
        Assert.assertEquals((String)"Root Tool", (String)iOptionCategory.getName());
        Object[][] objectArray = iOptionCategory.getOptions(iConfiguration2);
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)2, (int)n);
        ITool iTool2 = (ITool)objectArray[0][0];
        IOption iOption = (IOption)objectArray[0][1];
        ManagedBuildManager.setOption((IConfiguration)iConfiguration2, (IHoldsOptions)iTool2, (IOption)iOption, (String[])listVal);
        iOption = (IOption)objectArray[1][1];
        ManagedBuildManager.setOption((IConfiguration)iConfiguration2, (IHoldsOptions)iTool2, (IOption)iOption, (boolean)true);
        IOptionCategory[] iOptionCategoryArray = iOptionCategory.getChildCategories();
        Assert.assertEquals((int)1, (int)iOptionCategoryArray.length);
        objectArray = iOptionCategoryArray[0].getOptions(iConfiguration2);
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)4, (int)n);
        iTool2 = (ITool)objectArray[0][0];
        iOption = (IOption)objectArray[0][1];
        ManagedBuildManager.setOption((IConfiguration)iConfiguration2, (IHoldsOptions)iTool2, (IOption)iOption, (String)stringVal);
        iOption = (IOption)objectArray[1][1];
        ManagedBuildManager.setOption((IConfiguration)iConfiguration2, (IHoldsOptions)iTool2, (IOption)iOption, (String)anotherStringVal);
        iOption = (IOption)objectArray[2][1];
        ManagedBuildManager.setOption((IConfiguration)iConfiguration2, (IHoldsOptions)iTool2, (IOption)iOption, (String)enumVal);
        iOption = (IOption)objectArray[3][1];
        ManagedBuildManager.setOption((IConfiguration)iConfiguration2, (IHoldsOptions)iTool2, (IOption)iOption, (String)"False");
        ManagedBuildManager.saveBuildInfo((IProject)iProject, (boolean)false);
        ManagedBuildManager.removeBuildInfo((IResource)iProject);
        iProject.close(null);
        iProject.open(null);
        this.checkOptionReferences(iProject);
        iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        iManagedProject = iManagedBuildInfo.getManagedProject();
        iConfigurationArray = iManagedProject.getConfigurations();
        Assert.assertEquals((int)4, (int)iConfigurationArray.length);
        iManagedProject.removeConfiguration(testConfigId);
        iConfigurationArray = iManagedProject.getConfigurations();
        Assert.assertEquals((int)3, (int)iConfigurationArray.length);
        Assert.assertEquals((String)iConfigurationArray[0].getName(), (String)"Root Config");
        Assert.assertEquals((String)iConfigurationArray[1].getName(), (String)"Root Override Config");
        ManagedBuildManager.saveBuildInfo((IProject)iProject, (boolean)false);
    }

    public void testConfigurationReset() {
        IProjectDescription iProjectDescription;
        IProject iProject = null;
        try {
            iProject = this.createProject(projectName);
            iProjectDescription = iProject.getDescription();
            if (iProjectDescription != null) {
                Assert.assertTrue((boolean)iProjectDescription.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to open project: " + coreException.getLocalizedMessage()));
        }
        iProjectDescription = ManagedBuildManager.getBuildInfo((IResource)iProject);
        Assert.assertNotNull((Object)iProjectDescription);
        IManagedProject iManagedProject = iProjectDescription.getManagedProject();
        Assert.assertNotNull((Object)iManagedProject);
        IConfiguration iConfiguration = iProjectDescription.getDefaultConfiguration();
        Assert.assertNotNull((Object)iConfiguration);
        try {
            this.checkRootManagedProject(iManagedProject, "z");
        }
        catch (BuildException buildException) {
            Assert.fail((String)("Overridden root managed project check failed: " + buildException.getLocalizedMessage()));
        }
        ManagedBuildManager.resetConfiguration((IProject)iProject, (IConfiguration)iConfiguration);
        ManagedBuildManager.saveBuildInfo((IProject)iProject, (boolean)false);
        try {
            this.checkRootManagedProject(iManagedProject, "x");
        }
        catch (BuildException buildException) {
            Assert.fail((String)("Reset root managed project check failed: " + buildException.getLocalizedMessage()));
        }
    }

    public void testProjectCreation() throws BuildException {
        IProjectDescription iProjectDescription;
        IProject iProject = null;
        try {
            iProject = this.createProject(projectName);
            ManagedBuildTestHelper.addManagedBuildNature(iProject);
            iProjectDescription = iProject.getDescription();
            if (iProjectDescription != null) {
                Assert.assertTrue((boolean)iProjectDescription.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Test failed on project creation: " + coreException.getLocalizedMessage()));
        }
        iProjectDescription = ManagedBuildManager.getExtensionProjectType((String)"test.root");
        Assert.assertNotNull((Object)iProjectDescription);
        IManagedProject iManagedProject = ManagedBuildManager.createManagedProject((IResource)iProject, (IProjectType)iProjectDescription);
        Assert.assertEquals((String)iManagedProject.getName(), (String)iProjectDescription.getName());
        Assert.assertFalse((boolean)iManagedProject.equals(iProjectDescription));
        ManagedBuildManager.setNewProjectVersion((IProject)iProject);
        IConfiguration iConfiguration = null;
        IConfiguration[] iConfigurationArray = iProjectDescription.getConfigurations();
        int n = 0;
        while (n < iConfigurationArray.length) {
            if (n == 0) {
                iConfiguration = iManagedProject.createConfiguration(iConfigurationArray[n], String.valueOf(iProjectDescription.getId()) + "." + n);
            } else {
                iManagedProject.createConfiguration(iConfigurationArray[n], String.valueOf(iProjectDescription.getId()) + "." + n);
            }
            ++n;
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)iProject, iConfiguration);
        String string = projectName;
        iConfiguration.setArtifactName(string);
        iConfiguration.setArtifactExtension(newExt);
        IStatus iStatus = ManagedBuildManager.initBuildInfoContainer((IResource)iProject);
        if (iStatus.getCode() != 0) {
            Assert.fail((String)("Initializing build information failed for: " + iProject.getName() + " because: " + iStatus.getMessage()));
        }
        this.checkRootManagedProject(iManagedProject, "x");
        iConfigurationArray = iManagedProject.getConfigurations();
        ITool[] iToolArray = iConfigurationArray[0].getTools();
        IOptionCategory iOptionCategory = iToolArray[0].getTopOptionCategory();
        IOptionCategory[] iOptionCategoryArray = iOptionCategory.getChildCategories();
        Object[][] objectArray = iOptionCategoryArray[0].getOptions(iConfigurationArray[0]);
        ITool iTool = (ITool)objectArray[0][0];
        IOption iOption = (IOption)objectArray[0][1];
        iConfigurationArray[0].setOption((IHoldsOptions)iTool, iOption, "z");
        objectArray = iOptionCategoryArray[0].getOptions(null);
        iTool = (ITool)objectArray[0][0];
        iOption = (IOption)objectArray[0][1];
        Assert.assertEquals((String)"x", (String)iOption.getStringValue());
        objectArray = iOptionCategoryArray[0].getOptions(iConfigurationArray[0]);
        iTool = (ITool)objectArray[0][0];
        iOption = (IOption)objectArray[0][1];
        Assert.assertEquals((String)"z", (String)iOption.getStringValue());
        ManagedBuildManager.saveBuildInfo((IProject)iProject, (boolean)true);
        ManagedBuildManager.removeBuildInfo((IResource)iProject);
        try {
            iProject.close(null);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed on project close: " + coreException.getLocalizedMessage()));
        }
        try {
            iProject.open(null);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed on project open: " + coreException.getLocalizedMessage()));
        }
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        Assert.assertEquals((String)iConfiguration.getId(), (String)iManagedBuildInfo.getDefaultConfiguration().getId());
        this.checkRootManagedProject(iManagedProject, "z");
        this.checkBuildTestSettings(iManagedBuildInfo);
        ManagedBuildManager.removeBuildInfo((IResource)iProject);
    }

    public void testProjectRename() {
        IResource iResource;
        IProjectDescription iProjectDescription;
        IProject iProject = null;
        try {
            iProject = this.createProject(projectName);
            iProjectDescription = iProject.getDescription();
            if (iProjectDescription != null) {
                Assert.assertTrue((boolean)iProjectDescription.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to open project: " + coreException.getLocalizedMessage()));
        }
        if ((iResource = (iProjectDescription = ResourcesPlugin.getWorkspace().getRoot()).findMember(projectRename)) != null) {
            try {
                iResource.delete(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                Assert.fail((String)("Failed to delete old project ManagedBuildRedux: " + coreException.getLocalizedMessage()));
            }
        }
        IProjectDescription iProjectDescription2 = null;
        try {
            iProjectDescription2 = iProject.getDescription();
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to find project descriptor for ManagedBuildTest: " + coreException.getLocalizedMessage()));
        }
        iProjectDescription2.setName(projectRename);
        try {
            iProject.move(iProjectDescription2, 33, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to rename project: " + coreException.getLocalizedMessage()));
        }
        try {
            iProject = this.createProject(projectRename);
            iProjectDescription2 = iProject.getDescription();
            if (iProjectDescription2 != null) {
                Assert.assertTrue((boolean)iProjectDescription2.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to open renamed project: " + coreException.getLocalizedMessage()));
        }
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        IConfiguration[] iConfigurationArray = iManagedProject.getConfigurations();
        Assert.assertEquals((int)4, (int)iConfigurationArray.length);
        IConfiguration iConfiguration = iConfigurationArray[1];
        ITool[] iToolArray = iConfiguration.getTools();
        Assert.assertEquals((int)1, (int)iToolArray.length);
        ITool iTool = iToolArray[0];
        IOptionCategory iOptionCategory = iTool.getTopOptionCategory();
        Assert.assertEquals((String)"Root Tool", (String)iOptionCategory.getName());
        Object[][] objectArray = iOptionCategory.getOptions(iConfiguration);
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)2, (int)n);
        IOptionCategory[] iOptionCategoryArray = iOptionCategory.getChildCategories();
        Assert.assertEquals((int)1, (int)iOptionCategoryArray.length);
        objectArray = iOptionCategoryArray[0].getOptions(iConfiguration);
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)4, (int)n);
        iResource = iProjectDescription.findMember(projectName);
        if (iResource != null) {
            try {
                iResource.delete(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                Assert.fail((String)("Failed to delete old project ManagedBuildTest: " + coreException.getLocalizedMessage()));
            }
        }
        try {
            iProjectDescription2 = iProject.getDescription();
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to find project descriptor for ManagedBuildRedux: " + coreException.getLocalizedMessage()));
        }
        iProjectDescription2.setName(projectName);
        try {
            iProject.move(iProjectDescription2, 33, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to re-rename project: " + coreException.getLocalizedMessage()));
        }
        try {
            iProject = this.createProject(projectName);
            iProjectDescription2 = iProject.getDescription();
            if (iProjectDescription2 != null) {
                Assert.assertTrue((boolean)iProjectDescription2.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed to open re-renamed project: " + coreException.getLocalizedMessage()));
        }
        iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        iManagedProject = iManagedBuildInfo.getManagedProject();
        iConfigurationArray = iManagedProject.getConfigurations();
        Assert.assertEquals((int)4, (int)iConfigurationArray.length);
        iConfiguration = iConfigurationArray[1];
        iToolArray = iConfiguration.getTools();
        Assert.assertEquals((int)1, (int)iToolArray.length);
        iTool = iToolArray[0];
        iOptionCategory = iTool.getTopOptionCategory();
        Assert.assertEquals((String)"Root Tool", (String)iOptionCategory.getName());
        objectArray = iOptionCategory.getOptions(iConfiguration);
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)2, (int)n);
        iOptionCategoryArray = iOptionCategory.getChildCategories();
        Assert.assertEquals((int)1, (int)iOptionCategoryArray.length);
        objectArray = iOptionCategoryArray[0].getOptions(iConfiguration);
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)4, (int)n);
    }

    private void checkBuildTestSettings(IManagedBuildInfo iManagedBuildInfo) {
        String string = "foo";
        String string2 = "bar";
        String string3 = "cpp";
        String string4 = rootExt;
        String string5 = "doIt";
        Assert.assertNotNull((Object)iManagedBuildInfo);
        Assert.assertEquals((String)iManagedBuildInfo.getBuildArtifactName(), (String)projectName);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        Assert.assertNotNull((Object)iManagedProject);
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
        Assert.assertNotNull((Object)iConfiguration);
        Assert.assertEquals((String)iManagedBuildInfo.getOutputExtension(string), (String)string4);
        Assert.assertEquals((String)iManagedBuildInfo.getOutputExtension(string2), (String)string4);
        Assert.assertNull((Object)iManagedBuildInfo.getOutputExtension(string3));
        Assert.assertEquals((String)iManagedBuildInfo.getToolForSource(string), (String)string5);
        Assert.assertEquals((String)iManagedBuildInfo.getToolForSource(string2), (String)string5);
        Assert.assertNull((Object)iManagedBuildInfo.getToolForConfiguration(string));
        Assert.assertNull((Object)iManagedBuildInfo.getToolForConfiguration(string2));
        Assert.assertNull((Object)iManagedBuildInfo.getToolForSource(string4));
        Assert.assertEquals((String)iManagedBuildInfo.getToolForConfiguration(string4), (String)string5);
        Assert.assertEquals((String)iManagedBuildInfo.getFlagsForSource(string), (String)"-La -Lb z -e1 -nob");
        Assert.assertEquals((String)iManagedBuildInfo.getFlagsForSource(string), (String)iManagedBuildInfo.getFlagsForSource(string2));
    }

    private void checkOptionReferences(IProject iProject) throws BuildException {
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        IConfiguration[] iConfigurationArray = iManagedProject.getConfigurations();
        Assert.assertEquals((int)4, (int)iConfigurationArray.length);
        IConfiguration iConfiguration = iManagedProject.getConfiguration(testConfigId);
        Assert.assertNotNull((Object)iConfiguration);
        ITool[] iToolArray = iConfiguration.getTools();
        Assert.assertEquals((int)1, (int)iToolArray.length);
        ITool iTool = iToolArray[0];
        IOption[] iOptionArray = iTool.getOptions();
        Assert.assertEquals((int)6, (int)iOptionArray.length);
        Assert.assertEquals((String)"List Option in Top", (String)iOptionArray[0].getName());
        Assert.assertEquals((int)3, (int)iOptionArray[0].getValueType());
        Object[] objectArray = iOptionArray[0].getStringListValue();
        Assert.assertEquals((int)3, (int)objectArray.length);
        Assert.assertTrue((boolean)Arrays.equals(listVal, objectArray));
        Assert.assertEquals((String)iOptionArray[0].getCommand(), (String)"-L");
        Assert.assertEquals((String)"Boolean Option in Top", (String)iOptionArray[1].getName());
        Assert.assertEquals((int)0, (int)iOptionArray[1].getValueType());
        Assert.assertEquals((boolean)true, (boolean)iOptionArray[1].getBooleanValue());
        Assert.assertEquals((String)"-b", (String)iOptionArray[1].getCommand());
        Assert.assertEquals((String)"String Option in Category", (String)iOptionArray[2].getName());
        Assert.assertEquals((int)2, (int)iOptionArray[2].getValueType());
        Assert.assertEquals((String)stringVal, (String)iOptionArray[2].getStringValue());
        Assert.assertEquals((String)"Another String Option in Category", (String)iOptionArray[3].getName());
        Assert.assertEquals((int)2, (int)iOptionArray[3].getValueType());
        Assert.assertEquals((String)anotherStringVal, (String)iOptionArray[3].getStringValue());
        Assert.assertEquals((String)"-str", (String)iOptionArray[3].getCommand());
        Assert.assertEquals((String)"Enumerated Option in Category", (String)iOptionArray[4].getName());
        Assert.assertEquals((int)1, (int)iOptionArray[4].getValueType());
        String string = iOptionArray[4].getSelectedEnum();
        Assert.assertEquals((String)enumVal, (String)string);
        String[] stringArray = iOptionArray[4].getApplicableValues();
        Assert.assertEquals((int)2, (int)stringArray.length);
        Assert.assertEquals((String)"Default Enum", (String)stringArray[0]);
        Assert.assertEquals((String)enumVal, (String)stringArray[1]);
        Assert.assertEquals((String)"-e1", (String)iOptionArray[4].getEnumCommand(stringArray[0]));
        Assert.assertEquals((String)"-e2", (String)iOptionArray[4].getEnumCommand(stringArray[1]));
        Assert.assertEquals((String)"-e2", (String)iOptionArray[4].getEnumCommand(string));
        Assert.assertEquals((String)"Boolean Option in Category", (String)iOptionArray[5].getName());
        Assert.assertEquals((int)0, (int)iOptionArray[5].getValueType());
        Assert.assertEquals((boolean)false, (boolean)iOptionArray[5].getBooleanValue());
        Assert.assertEquals((String)"-nob", (String)iOptionArray[5].getCommandFalse());
    }

    private void checkRootProjectType(IProjectType iProjectType) throws BuildException {
        String string = "del /myworld";
        String string2 = "org.eclipse.cdt.core.PE";
        Object[] objectArray = new String[]{"win32"};
        Object[] objectArray2 = new String[]{"all"};
        Assert.assertTrue((boolean)iProjectType.isTestProjectType());
        IConfiguration[] iConfigurationArray = iProjectType.getConfigurations();
        if (iConfigurationArray[0].getArtifactName().equals(projectName)) {
            Assert.assertEquals((String)iConfigurationArray[0].getArtifactExtension(), (String)newExt);
        } else {
            Assert.assertEquals((String)iConfigurationArray[0].getArtifactExtension(), (String)rootExt);
        }
        Assert.assertEquals((String)string, (String)iConfigurationArray[0].getCleanCommand());
        Assert.assertEquals((String)"make", (String)iConfigurationArray[0].getBuildCommand());
        IToolChain iToolChain = iConfigurationArray[0].getToolChain();
        ITargetPlatform iTargetPlatform = iToolChain.getTargetPlatform();
        String[] stringArray = iTargetPlatform.getBinaryParserList();
        Assert.assertEquals((int)stringArray.length, (int)1);
        Assert.assertEquals((String)stringArray[0], (String)string2);
        Assert.assertTrue((boolean)Arrays.equals(objectArray, iToolChain.getOSList()));
        Assert.assertTrue((boolean)Arrays.equals(objectArray2, iToolChain.getArchList()));
        Assert.assertNull((Object)iConfigurationArray[0].getErrorParserIds());
        Assert.assertTrue((boolean)Arrays.equals(iConfigurationArray[0].getErrorParserList(), CCorePlugin.getDefault().getAllErrorParsersIDs()));
        ITool[] iToolArray = iToolChain.getTools();
        ITool iTool = iToolArray[0];
        Assert.assertEquals((String)"Root Tool", (String)iTool.getName());
        IOption[] iOptionArray = iTool.getOptions();
        Assert.assertEquals((int)6, (int)iOptionArray.length);
        Assert.assertEquals((String)"List Option in Top", (String)iOptionArray[0].getName());
        Assert.assertEquals((int)3, (int)iOptionArray[0].getValueType());
        String[] stringArray2 = iOptionArray[0].getStringListValue();
        Assert.assertEquals((int)2, (int)stringArray2.length);
        Assert.assertEquals((String)"a", (String)stringArray2[0]);
        Assert.assertEquals((String)"b", (String)stringArray2[1]);
        String[] stringArray3 = iOptionArray[0].getBuiltIns();
        Assert.assertEquals((int)1, (int)stringArray3.length);
        Assert.assertEquals((String)"c", (String)stringArray3[0]);
        Assert.assertEquals((String)iOptionArray[0].getCommand(), (String)"-L");
        Assert.assertEquals((String)"Boolean Option in Top", (String)iOptionArray[1].getName());
        Assert.assertEquals((int)0, (int)iOptionArray[1].getValueType());
        Assert.assertEquals((boolean)false, (boolean)iOptionArray[1].getBooleanValue());
        Assert.assertEquals((String)"-b", (String)iOptionArray[1].getCommand());
        Assert.assertEquals((String)"String Option in Category", (String)iOptionArray[2].getName());
        Assert.assertEquals((int)2, (int)iOptionArray[2].getValueType());
        Assert.assertEquals((String)"x", (String)iOptionArray[2].getStringValue());
        Assert.assertEquals((String)"Another String Option in Category", (String)iOptionArray[3].getName());
        Assert.assertEquals((int)2, (int)iOptionArray[3].getValueType());
        Assert.assertEquals((String)"", (String)iOptionArray[3].getStringValue());
        Assert.assertEquals((String)"-str", (String)iOptionArray[3].getCommand());
        Assert.assertEquals((String)"Enumerated Option in Category", (String)iOptionArray[4].getName());
        Assert.assertEquals((int)1, (int)iOptionArray[4].getValueType());
        Assert.assertEquals((String)"default.enum.option", (String)iOptionArray[4].getSelectedEnum());
        Assert.assertEquals((String)"-e1", (String)iOptionArray[4].getEnumCommand("default.enum.option"));
        stringArray2 = iOptionArray[4].getApplicableValues();
        Assert.assertEquals((int)2, (int)stringArray2.length);
        Assert.assertEquals((String)"Default Enum", (String)stringArray2[0]);
        Assert.assertEquals((String)enumVal, (String)stringArray2[1]);
        Assert.assertEquals((String)"-e1", (String)iOptionArray[4].getEnumCommand(stringArray2[0]));
        Assert.assertEquals((String)"-e2", (String)iOptionArray[4].getEnumCommand(stringArray2[1]));
        Assert.assertEquals((String)"Boolean Option in Category", (String)iOptionArray[5].getName());
        Assert.assertEquals((int)0, (int)iOptionArray[5].getValueType());
        Assert.assertEquals((boolean)false, (boolean)iOptionArray[5].getBooleanValue());
        Assert.assertEquals((String)"", (String)iOptionArray[5].getCommand());
        Assert.assertEquals((String)"-nob", (String)iOptionArray[5].getCommandFalse());
        IOptionCategory iOptionCategory = iTool.getTopOptionCategory();
        Assert.assertEquals((String)"Root Tool", (String)iOptionCategory.getName());
        Object[][] objectArray3 = iOptionCategory.getOptions(iConfigurationArray[0]);
        int n = 0;
        while (n < objectArray3.length) {
            if (objectArray3[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)2, (int)n);
        Assert.assertEquals((String)"List Option in Top", (String)((IOption)objectArray3[0][1]).getName());
        Assert.assertEquals((String)"Boolean Option in Top", (String)((IOption)objectArray3[1][1]).getName());
        IOptionCategory[] iOptionCategoryArray = iOptionCategory.getChildCategories();
        Assert.assertEquals((int)1, (int)iOptionCategoryArray.length);
        Assert.assertEquals((String)"Category", (String)iOptionCategoryArray[0].getName());
        objectArray3 = iOptionCategoryArray[0].getOptions(iConfigurationArray[0]);
        n = 0;
        while (n < objectArray3.length) {
            if (objectArray3[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)4, (int)n);
        Assert.assertEquals((String)"String Option in Category", (String)((IOption)objectArray3[0][1]).getName());
        Assert.assertEquals((String)"Another String Option in Category", (String)((IOption)objectArray3[1][1]).getName());
        Assert.assertEquals((String)"Enumerated Option in Category", (String)((IOption)objectArray3[2][1]).getName());
        Assert.assertEquals((String)"Boolean Option in Category", (String)((IOption)objectArray3[3][1]).getName());
        iConfigurationArray = iProjectType.getConfigurations();
        Assert.assertEquals((int)3, (int)iConfigurationArray.length);
        IConfiguration iConfiguration = iConfigurationArray[0];
        Assert.assertEquals((String)"Root Config", (String)iConfiguration.getName());
        iToolArray = iConfiguration.getTools();
        Assert.assertEquals((int)1, (int)iToolArray.length);
        Assert.assertEquals((String)"Root Tool", (String)iToolArray[0].getName());
        Assert.assertEquals((String)"-r", (String)iToolArray[0].getOutputFlag());
        Assert.assertTrue((boolean)iToolArray[0].buildsFileType("foo"));
        Assert.assertTrue((boolean)iToolArray[0].buildsFileType("bar"));
        Assert.assertTrue((boolean)iToolArray[0].producesFileType(rootExt));
        Assert.assertEquals((String)"doIt", (String)iToolArray[0].getToolCommand());
        Assert.assertEquals((String)"", (String)iToolArray[0].getOutputPrefix());
        Assert.assertTrue((boolean)iTool.isHeaderFile("baz"));
        Assert.assertTrue((boolean)iToolArray[0].isHeaderFile("baz"));
        Assert.assertEquals((int)0, (int)iTool.getNatureFilter());
        Assert.assertEquals((String)"Root Override Config", (String)iConfigurationArray[1].getName());
        iToolArray = iConfigurationArray[1].getTools();
        Assert.assertEquals((int)1, (int)iToolArray.length);
        Assert.assertEquals((String)"Root Tool", (String)iToolArray[0].getName());
        iOptionCategory = iToolArray[0].getTopOptionCategory();
        objectArray3 = iOptionCategory.getOptions(iConfigurationArray[1]);
        n = 0;
        while (n < objectArray3.length) {
            if (objectArray3[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)2, (int)n);
        Assert.assertEquals((String)"List Option in Top", (String)((IOption)objectArray3[0][1]).getName());
        stringArray2 = ((IOption)objectArray3[0][1]).getStringListValue();
        Assert.assertEquals((String)"a", (String)stringArray2[0]);
        Assert.assertEquals((String)"b", (String)stringArray2[1]);
        Assert.assertEquals((String)"Boolean Option in Top", (String)((IOption)objectArray3[1][1]).getName());
        Assert.assertEquals((boolean)true, (boolean)((IOption)objectArray3[1][1]).getBooleanValue());
        Assert.assertEquals((String)"-b", (String)((IOption)objectArray3[1][1]).getCommand());
        iOptionCategoryArray = iOptionCategory.getChildCategories();
        objectArray3 = iOptionCategoryArray[0].getOptions(iConfigurationArray[1]);
        n = 0;
        while (n < objectArray3.length) {
            if (objectArray3[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)4, (int)n);
        Assert.assertEquals((String)"String Option in Category", (String)((IOption)objectArray3[0][1]).getName());
        Assert.assertEquals((String)"y", (String)((IOption)objectArray3[0][1]).getStringValue());
        Assert.assertEquals((String)"Another String Option in Category", (String)((IOption)objectArray3[1][1]).getName());
        Assert.assertEquals((String)"", (String)((IOption)objectArray3[1][1]).getStringValue());
        Assert.assertEquals((String)"Enumerated Option in Category", (String)((IOption)objectArray3[2][1]).getName());
        stringArray2 = ((IOption)objectArray3[2][1]).getApplicableValues();
        Assert.assertEquals((int)2, (int)stringArray2.length);
        Assert.assertEquals((String)"Default Enum", (String)stringArray2[0]);
        Assert.assertEquals((String)enumVal, (String)stringArray2[1]);
        Assert.assertEquals((String)"-e1", (String)((IOption)objectArray3[2][1]).getEnumCommand(stringArray2[0]));
        Assert.assertEquals((String)"-e2", (String)((IOption)objectArray3[2][1]).getEnumCommand(stringArray2[1]));
        Assert.assertEquals((int)1, (int)iToolArray.length);
        Assert.assertEquals((String)"Boolean Option in Category", (String)((IOption)objectArray3[3][1]).getName());
        Assert.assertEquals((boolean)false, (boolean)((IOption)objectArray3[3][1]).getBooleanValue());
        Assert.assertEquals((String)"", (String)((IOption)objectArray3[3][1]).getCommand());
        Assert.assertEquals((String)"-nob", (String)((IOption)objectArray3[3][1]).getCommandFalse());
        Assert.assertEquals((int)1, (int)iToolArray.length);
        ITool iTool2 = iToolArray[0];
        Assert.assertNotNull((Object)iTool2);
        Assert.assertEquals((String)"Root Tool", (String)iTool2.getName());
        Assert.assertEquals((String)"-r", (String)iTool2.getOutputFlag());
        Assert.assertTrue((boolean)iTool2.buildsFileType("foo"));
        Assert.assertTrue((boolean)iTool2.buildsFileType("bar"));
        Assert.assertTrue((boolean)iTool2.producesFileType(rootExt));
        Assert.assertTrue((boolean)iTool2.isHeaderFile("baz"));
        Assert.assertEquals((String)"doIt", (String)iTool2.getToolCommand());
        Assert.assertEquals((String)"-La -Lb -b y -e1 -nob", (String)iTool2.getToolFlags());
        Assert.assertEquals((String)"Complete Override Config", (String)iConfigurationArray[2].getName());
        iToolArray = iConfigurationArray[2].getTools();
        Assert.assertEquals((int)1, (int)iToolArray.length);
        Assert.assertEquals((String)"Root Tool", (String)iToolArray[0].getName());
        iOptionCategory = iToolArray[0].getTopOptionCategory();
        objectArray3 = iOptionCategory.getOptions(iConfigurationArray[2]);
        n = 0;
        while (n < objectArray3.length) {
            if (objectArray3[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)2, (int)n);
        Assert.assertEquals((String)"List Option in Top", (String)((IOption)objectArray3[0][1]).getName());
        Assert.assertEquals((int)3, (int)((IOption)objectArray3[0][1]).getValueType());
        stringArray2 = ((IOption)objectArray3[0][1]).getStringListValue();
        Assert.assertTrue((stringArray2.length == 3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"d", (String)stringArray2[0]);
        Assert.assertEquals((String)"e", (String)stringArray2[1]);
        Assert.assertEquals((String)"f", (String)stringArray2[2]);
        Assert.assertEquals((String)"-L", (String)((IOption)objectArray3[0][1]).getCommand());
        Assert.assertEquals((String)"Boolean Option in Top", (String)((IOption)objectArray3[1][1]).getName());
        Assert.assertEquals((int)0, (int)((IOption)objectArray3[1][1]).getValueType());
        Assert.assertEquals((boolean)true, (boolean)((IOption)objectArray3[1][1]).getBooleanValue());
        Assert.assertEquals((String)"-b", (String)((IOption)objectArray3[1][1]).getCommand());
        iOptionCategoryArray = iOptionCategory.getChildCategories();
        objectArray3 = iOptionCategoryArray[0].getOptions(iConfigurationArray[2]);
        n = 0;
        while (n < objectArray3.length) {
            if (objectArray3[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)4, (int)n);
        Assert.assertEquals((String)"String Option in Category", (String)((IOption)objectArray3[0][1]).getName());
        Assert.assertEquals((int)2, (int)((IOption)objectArray3[0][1]).getValueType());
        Assert.assertEquals((String)"overridden", (String)((IOption)objectArray3[0][1]).getStringValue());
        Assert.assertEquals((String)"Another String Option in Category", (String)((IOption)objectArray3[1][1]).getName());
        Assert.assertEquals((int)2, (int)((IOption)objectArray3[1][1]).getValueType());
        Assert.assertEquals((String)"alsooverridden", (String)((IOption)objectArray3[1][1]).getStringValue());
        Assert.assertEquals((String)"Enumerated Option in Category", (String)((IOption)objectArray3[2][1]).getName());
        Assert.assertEquals((int)1, (int)((IOption)objectArray3[2][1]).getValueType());
        Assert.assertEquals((String)"another.enum.option", (String)((IOption)objectArray3[2][1]).getSelectedEnum());
        Assert.assertEquals((String)"Boolean Option in Category", (String)((IOption)objectArray3[3][1]).getName());
        Assert.assertEquals((int)0, (int)((IOption)objectArray3[3][1]).getValueType());
        Assert.assertEquals((boolean)true, (boolean)((IOption)objectArray3[3][1]).getBooleanValue());
        iTool2 = iToolArray[0];
        Assert.assertEquals((String)"-Ld -Le -Lf -b overridden -stralsooverridden -e2", (String)iTool2.getToolFlags());
        Assert.assertNotNull((Object)ManagedBuildManager.getBuildfileGenerator((IConfiguration)iConfigurationArray[0]));
    }

    private void checkRootManagedProject(IManagedProject iManagedProject, String string) throws BuildException {
        String string2 = "del /myworld";
        String string3 = "org.eclipse.cdt.core.PE";
        Object[] objectArray = new String[]{"win32"};
        Object[] objectArray2 = new String[]{"all"};
        Assert.assertTrue((boolean)iManagedProject.getProjectType().isTestProjectType());
        IConfiguration[] iConfigurationArray = iManagedProject.getConfigurations();
        if (iConfigurationArray[0].getArtifactName().equals(projectName)) {
            Assert.assertEquals((String)iConfigurationArray[0].getArtifactExtension(), (String)newExt);
        } else {
            Assert.assertEquals((String)iConfigurationArray[0].getArtifactExtension(), (String)rootExt);
        }
        Assert.assertEquals((String)string2, (String)iConfigurationArray[0].getCleanCommand());
        Assert.assertEquals((String)"make", (String)iConfigurationArray[0].getBuildCommand());
        IToolChain iToolChain = iConfigurationArray[0].getToolChain();
        ITargetPlatform iTargetPlatform = iToolChain.getTargetPlatform();
        String[] stringArray = iTargetPlatform.getBinaryParserList();
        Assert.assertEquals((int)stringArray.length, (int)1);
        Assert.assertEquals((String)stringArray[0], (String)string3);
        Assert.assertTrue((boolean)Arrays.equals(objectArray, iToolChain.getOSList()));
        Assert.assertTrue((boolean)Arrays.equals(objectArray2, iToolChain.getArchList()));
        Assert.assertNull((Object)iConfigurationArray[0].getErrorParserIds());
        Assert.assertTrue((boolean)Arrays.equals(iConfigurationArray[0].getErrorParserList(), CCorePlugin.getDefault().getAllErrorParsersIDs()));
        ITool[] iToolArray = iConfigurationArray[0].getTools();
        ITool iTool = iToolArray[0];
        Assert.assertEquals((String)"Root Tool", (String)iTool.getName());
        IOption[] iOptionArray = iTool.getOptions();
        Assert.assertEquals((int)6, (int)iOptionArray.length);
        Assert.assertEquals((String)"List Option in Top", (String)iOptionArray[0].getName());
        Assert.assertEquals((int)3, (int)iOptionArray[0].getValueType());
        String[] stringArray2 = iOptionArray[0].getStringListValue();
        Assert.assertEquals((int)2, (int)stringArray2.length);
        Assert.assertEquals((String)"a", (String)stringArray2[0]);
        Assert.assertEquals((String)"b", (String)stringArray2[1]);
        String[] stringArray3 = iOptionArray[0].getBuiltIns();
        Assert.assertEquals((int)1, (int)stringArray3.length);
        Assert.assertEquals((String)"c", (String)stringArray3[0]);
        Assert.assertEquals((String)iOptionArray[0].getCommand(), (String)"-L");
        Assert.assertEquals((String)"Boolean Option in Top", (String)iOptionArray[1].getName());
        Assert.assertEquals((int)0, (int)iOptionArray[1].getValueType());
        Assert.assertEquals((boolean)false, (boolean)iOptionArray[1].getBooleanValue());
        Assert.assertEquals((String)"-b", (String)iOptionArray[1].getCommand());
        Assert.assertEquals((String)"String Option in Category", (String)iOptionArray[2].getName());
        Assert.assertEquals((int)2, (int)iOptionArray[2].getValueType());
        Assert.assertEquals((String)string, (String)iOptionArray[2].getStringValue());
        Assert.assertEquals((String)"Another String Option in Category", (String)iOptionArray[3].getName());
        Assert.assertEquals((int)2, (int)iOptionArray[3].getValueType());
        Assert.assertEquals((String)"", (String)iOptionArray[3].getStringValue());
        Assert.assertEquals((String)"-str", (String)iOptionArray[3].getCommand());
        Assert.assertEquals((String)"Enumerated Option in Category", (String)iOptionArray[4].getName());
        Assert.assertEquals((int)1, (int)iOptionArray[4].getValueType());
        Assert.assertEquals((String)"default.enum.option", (String)iOptionArray[4].getSelectedEnum());
        Assert.assertEquals((String)"-e1", (String)iOptionArray[4].getEnumCommand("default.enum.option"));
        stringArray2 = iOptionArray[4].getApplicableValues();
        Assert.assertEquals((int)2, (int)stringArray2.length);
        Assert.assertEquals((String)"Default Enum", (String)stringArray2[0]);
        Assert.assertEquals((String)enumVal, (String)stringArray2[1]);
        Assert.assertEquals((String)"-e1", (String)iOptionArray[4].getEnumCommand(stringArray2[0]));
        Assert.assertEquals((String)"-e2", (String)iOptionArray[4].getEnumCommand(stringArray2[1]));
        Assert.assertEquals((String)"Boolean Option in Category", (String)iOptionArray[5].getName());
        Assert.assertEquals((int)0, (int)iOptionArray[5].getValueType());
        Assert.assertEquals((boolean)false, (boolean)iOptionArray[5].getBooleanValue());
        Assert.assertEquals((String)"", (String)iOptionArray[5].getCommand());
        Assert.assertEquals((String)"-nob", (String)iOptionArray[5].getCommandFalse());
        IOptionCategory iOptionCategory = iTool.getTopOptionCategory();
        Assert.assertEquals((String)"Root Tool", (String)iOptionCategory.getName());
        Object[][] objectArray3 = iOptionCategory.getOptions(iConfigurationArray[0]);
        int n = 0;
        while (n < objectArray3.length) {
            if (objectArray3[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)2, (int)n);
        IOption iOption = (IOption)objectArray3[0][1];
        Assert.assertEquals((String)"List Option in Top", (String)iOption.getName());
        iOption = (IOption)objectArray3[1][1];
        Assert.assertEquals((String)"Boolean Option in Top", (String)iOption.getName());
        IOptionCategory[] iOptionCategoryArray = iOptionCategory.getChildCategories();
        Assert.assertEquals((int)1, (int)iOptionCategoryArray.length);
        Assert.assertEquals((String)"Category", (String)iOptionCategoryArray[0].getName());
        objectArray3 = iOptionCategoryArray[0].getOptions(iConfigurationArray[0]);
        n = 0;
        while (n < objectArray3.length) {
            if (objectArray3[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)4, (int)n);
        iOption = (IOption)objectArray3[0][1];
        Assert.assertEquals((String)"String Option in Category", (String)iOption.getName());
        iOption = (IOption)objectArray3[1][1];
        Assert.assertEquals((String)"Another String Option in Category", (String)iOption.getName());
        iOption = (IOption)objectArray3[2][1];
        Assert.assertEquals((String)"Enumerated Option in Category", (String)iOption.getName());
        iOption = (IOption)objectArray3[3][1];
        Assert.assertEquals((String)"Boolean Option in Category", (String)iOption.getName());
        Assert.assertEquals((int)3, (int)iConfigurationArray.length);
        IConfiguration iConfiguration = iConfigurationArray[0];
        Assert.assertEquals((String)"Root Config", (String)iConfiguration.getName());
        iToolArray = iConfiguration.getTools();
        Assert.assertEquals((int)1, (int)iToolArray.length);
        Assert.assertEquals((String)"Root Tool", (String)iToolArray[0].getName());
        Assert.assertEquals((String)"-r", (String)iToolArray[0].getOutputFlag());
        Assert.assertTrue((boolean)iToolArray[0].buildsFileType("foo"));
        Assert.assertTrue((boolean)iToolArray[0].buildsFileType("bar"));
        Assert.assertTrue((boolean)iToolArray[0].producesFileType(rootExt));
        Assert.assertEquals((String)"doIt", (String)iToolArray[0].getToolCommand());
        Assert.assertEquals((String)"", (String)iToolArray[0].getOutputPrefix());
        Assert.assertTrue((boolean)iTool.isHeaderFile("baz"));
        Assert.assertTrue((boolean)iToolArray[0].isHeaderFile("baz"));
        Assert.assertEquals((int)0, (int)iTool.getNatureFilter());
        Assert.assertEquals((String)"Root Override Config", (String)iConfigurationArray[1].getName());
        iToolArray = iConfigurationArray[1].getTools();
        Assert.assertEquals((int)1, (int)iToolArray.length);
        Assert.assertEquals((String)"Root Tool", (String)iToolArray[0].getName());
        iOptionCategory = iToolArray[0].getTopOptionCategory();
        objectArray3 = iOptionCategory.getOptions(iConfigurationArray[1]);
        n = 0;
        while (n < objectArray3.length) {
            if (objectArray3[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)2, (int)n);
        iOption = (IOption)objectArray3[0][1];
        Assert.assertEquals((String)"List Option in Top", (String)iOption.getName());
        stringArray2 = iOption.getStringListValue();
        Assert.assertEquals((String)"a", (String)stringArray2[0]);
        Assert.assertEquals((String)"b", (String)stringArray2[1]);
        iOption = (IOption)objectArray3[1][1];
        Assert.assertEquals((String)"Boolean Option in Top", (String)iOption.getName());
        Assert.assertEquals((boolean)true, (boolean)iOption.getBooleanValue());
        Assert.assertEquals((String)"-b", (String)iOption.getCommand());
        iOptionCategoryArray = iOptionCategory.getChildCategories();
        objectArray3 = iOptionCategoryArray[0].getOptions(iConfigurationArray[1]);
        n = 0;
        while (n < objectArray3.length) {
            if (objectArray3[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)4, (int)n);
        iOption = (IOption)objectArray3[0][1];
        Assert.assertEquals((String)"String Option in Category", (String)iOption.getName());
        Assert.assertEquals((String)"y", (String)iOption.getStringValue());
        iOption = (IOption)objectArray3[1][1];
        Assert.assertEquals((String)"Another String Option in Category", (String)iOption.getName());
        Assert.assertEquals((String)"", (String)iOption.getStringValue());
        iOption = (IOption)objectArray3[2][1];
        Assert.assertEquals((String)"Enumerated Option in Category", (String)iOption.getName());
        stringArray2 = iOption.getApplicableValues();
        Assert.assertEquals((int)2, (int)stringArray2.length);
        Assert.assertEquals((String)"Default Enum", (String)stringArray2[0]);
        Assert.assertEquals((String)enumVal, (String)stringArray2[1]);
        iOption = (IOption)objectArray3[2][1];
        Assert.assertEquals((String)"-e1", (String)iOption.getEnumCommand(stringArray2[0]));
        Assert.assertEquals((String)"-e2", (String)iOption.getEnumCommand(stringArray2[1]));
        Assert.assertEquals((int)1, (int)iToolArray.length);
        iOption = (IOption)objectArray3[3][1];
        Assert.assertEquals((String)"Boolean Option in Category", (String)iOption.getName());
        Assert.assertEquals((boolean)false, (boolean)iOption.getBooleanValue());
        Assert.assertEquals((String)"", (String)iOption.getCommand());
        Assert.assertEquals((String)"-nob", (String)iOption.getCommandFalse());
        Assert.assertEquals((int)1, (int)iToolArray.length);
        ITool iTool2 = iToolArray[0];
        Assert.assertNotNull((Object)iTool2);
        Assert.assertEquals((String)"Root Tool", (String)iTool2.getName());
        Assert.assertEquals((String)"-r", (String)iTool2.getOutputFlag());
        Assert.assertTrue((boolean)iTool2.buildsFileType("foo"));
        Assert.assertTrue((boolean)iTool2.buildsFileType("bar"));
        Assert.assertTrue((boolean)iTool2.producesFileType(rootExt));
        Assert.assertTrue((boolean)iTool2.isHeaderFile("baz"));
        Assert.assertEquals((String)"doIt", (String)iTool2.getToolCommand());
        Assert.assertEquals((String)"-La -Lb -b y -e1 -nob", (String)iTool2.getToolFlags());
        Assert.assertEquals((String)"Complete Override Config", (String)iConfigurationArray[2].getName());
        iToolArray = iConfigurationArray[2].getTools();
        Assert.assertEquals((int)1, (int)iToolArray.length);
        Assert.assertEquals((String)"Root Tool", (String)iToolArray[0].getName());
        iOptionCategory = iToolArray[0].getTopOptionCategory();
        objectArray3 = iOptionCategory.getOptions(iConfigurationArray[2]);
        n = 0;
        while (n < objectArray3.length) {
            if (objectArray3[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)2, (int)n);
        iOption = (IOption)objectArray3[0][1];
        Assert.assertEquals((String)"List Option in Top", (String)iOption.getName());
        Assert.assertEquals((int)3, (int)iOption.getValueType());
        stringArray2 = iOption.getStringListValue();
        Assert.assertTrue((stringArray2.length == 3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"d", (String)stringArray2[0]);
        Assert.assertEquals((String)"e", (String)stringArray2[1]);
        Assert.assertEquals((String)"f", (String)stringArray2[2]);
        Assert.assertEquals((String)"-L", (String)iOption.getCommand());
        iOption = (IOption)objectArray3[1][1];
        Assert.assertEquals((String)"Boolean Option in Top", (String)iOption.getName());
        Assert.assertEquals((int)0, (int)iOption.getValueType());
        Assert.assertEquals((boolean)true, (boolean)iOption.getBooleanValue());
        Assert.assertEquals((String)"-b", (String)iOption.getCommand());
        iOptionCategoryArray = iOptionCategory.getChildCategories();
        objectArray3 = iOptionCategoryArray[0].getOptions(iConfigurationArray[2]);
        n = 0;
        while (n < objectArray3.length) {
            if (objectArray3[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)4, (int)n);
        iOption = (IOption)objectArray3[0][1];
        Assert.assertEquals((String)"String Option in Category", (String)iOption.getName());
        Assert.assertEquals((int)2, (int)iOption.getValueType());
        Assert.assertEquals((String)"overridden", (String)iOption.getStringValue());
        iOption = (IOption)objectArray3[1][1];
        Assert.assertEquals((String)"Another String Option in Category", (String)iOption.getName());
        Assert.assertEquals((int)2, (int)iOption.getValueType());
        Assert.assertEquals((String)"alsooverridden", (String)iOption.getStringValue());
        iOption = (IOption)objectArray3[2][1];
        Assert.assertEquals((String)"Enumerated Option in Category", (String)iOption.getName());
        Assert.assertEquals((int)1, (int)iOption.getValueType());
        Assert.assertEquals((String)"another.enum.option", (String)iOption.getSelectedEnum());
        iOption = (IOption)objectArray3[3][1];
        Assert.assertEquals((String)"Boolean Option in Category", (String)iOption.getName());
        Assert.assertEquals((int)0, (int)iOption.getValueType());
        Assert.assertEquals((boolean)true, (boolean)iOption.getBooleanValue());
        iTool2 = iToolArray[0];
        Assert.assertEquals((String)"-Ld -Le -Lf -b overridden -stralsooverridden -e2", (String)iTool2.getToolFlags());
        Assert.assertNotNull((Object)ManagedBuildManager.getBuildfileGenerator((IConfiguration)iConfigurationArray[0]));
    }

    private void checkSubSubProjectType(IProjectType iProjectType) {
        Object[][] objectArray;
        IConfiguration[] iConfigurationArray = iProjectType.getConfigurations();
        Assert.assertEquals((String)"rm -yourworld", (String)iConfigurationArray[0].getCleanCommand());
        Assert.assertEquals((String)"nmake", (String)iConfigurationArray[0].getBuildCommand());
        IToolChain iToolChain = iConfigurationArray[0].getToolChain();
        ITargetPlatform iTargetPlatform = iToolChain.getTargetPlatform();
        Assert.assertEquals((String)"org.eclipse.cdt.core.ELF", (String)iTargetPlatform.getBinaryParserList()[0]);
        Object[] objectArray2 = new String[]{"win32", "linux", "solaris"};
        Assert.assertTrue((boolean)Arrays.equals(objectArray2, iToolChain.getOSList()));
        Object[] objectArray3 = new String[]{"x86", "ppc"};
        Assert.assertTrue((boolean)Arrays.equals(objectArray3, iToolChain.getArchList()));
        Assert.assertEquals((int)5, (int)iConfigurationArray.length);
        ITool[] iToolArray = iConfigurationArray[0].getTools();
        Assert.assertEquals((int)3, (int)iToolArray.length);
        ITool iTool = iToolArray[0];
        Assert.assertEquals((String)iTool.getName(), (String)"Target Independent Tool");
        Assert.assertEquals((String)iTool.getToolCommand(), (String)"RC.EXE");
        Assert.assertTrue((boolean)iTool.buildsFileType("rc"));
        Assert.assertEquals((String)iTool.getOutputExtension("rc"), (String)"free");
        Assert.assertEquals((String)iTool.getOutputFlag(), (String)"/fo");
        Assert.assertTrue((boolean)iTool.isHeaderFile("h"));
        Assert.assertFalse((boolean)iTool.isHeaderFile("j"));
        Assert.assertEquals((int)iTool.getNatureFilter(), (int)2);
        IOptionCategory iOptionCategory = iTool.getTopOptionCategory();
        IOptionCategory[] iOptionCategoryArray = iOptionCategory.getChildCategories();
        Assert.assertEquals((int)1, (int)iOptionCategoryArray.length);
        Assert.assertEquals((String)iOptionCategoryArray[0].getName(), (String)"Free");
        IOptionCategory[] iOptionCategoryArray2 = iOptionCategoryArray[0].getChildCategories();
        Assert.assertEquals((int)1, (int)iOptionCategoryArray2.length);
        Assert.assertEquals((String)iOptionCategoryArray2[0].getName(), (String)"Chained");
        Object[][] objectArray4 = iOptionCategoryArray[0].getOptions(iConfigurationArray[0]);
        int n = 0;
        while (n < objectArray4.length) {
            if (objectArray4[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)1, (int)n);
        IOption iOption = (IOption)objectArray4[0][1];
        Assert.assertEquals((String)"String in Free", (String)iOption.getName());
        try {
            Assert.assertEquals((int)2, (int)iOption.getValueType());
            objectArray = iTool.getOptionById(iOption.getId());
            Assert.assertTrue((boolean)(objectArray instanceof Option));
            Assert.assertEquals((String)"Live free or die", (String)objectArray.getStringValue());
        }
        catch (BuildException buildException) {
            Assert.fail((String)("Failed getting string value in subsub :" + buildException.getLocalizedMessage()));
        }
        objectArray = iOptionCategoryArray2[0].getOptions(iConfigurationArray[0]);
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)1, (int)n);
        IOption iOption2 = iTool.getOptionById(((IOption)objectArray[0][1]).getId());
        Assert.assertEquals((String)"Boolean in Chained", (String)iOption2.getName());
        try {
            Assert.assertEquals((int)0, (int)iOption2.getValueType());
            Assert.assertTrue((boolean)iOption2.getBooleanValue());
        }
        catch (BuildException buildException) {
            Assert.fail((String)("Failure getting boolean value in subsub: " + buildException.getLocalizedMessage()));
        }
        iTool.setToolCommand("Let the Wookie win");
        Assert.assertEquals((String)iTool.getToolCommand(), (String)"Let the Wookie win");
        IConfiguration iConfiguration = iProjectType.getConfiguration("sub.sub.config");
        Assert.assertNotNull((Object)iConfiguration);
        ITool[] iToolArray2 = iConfiguration.getTools();
        ITool iTool2 = iToolArray2[0];
        Assert.assertNotNull((Object)iTool2);
        iOption = (IOption)objectArray4[0][1];
        IOption iOption3 = iTool2.getOptionById(iOption.getId());
        Assert.assertNotNull((Object)iOption3);
        try {
            iConfiguration.setOption((IHoldsOptions)iTool2, iOption3, "The future language of slaves");
        }
        catch (BuildException buildException) {
            Assert.fail((String)("Failure setting string value in subsubconfiguration: " + buildException.getLocalizedMessage()));
        }
        iToolArray2 = iConfiguration.getTools();
        iTool2 = iToolArray2[0];
        Assert.assertNotNull((Object)iTool2);
        objectArray4 = iOptionCategoryArray[0].getOptions(iConfigurationArray[0]);
        n = 0;
        while (n < objectArray4.length) {
            if (objectArray4[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)1, (int)n);
        iOption = (IOption)objectArray4[0][1];
        Assert.assertEquals((String)"String in Free", (String)iOption.getName());
        iOption3 = iTool2.getOptionById(iOption.getId());
        try {
            Assert.assertEquals((String)"The future language of slaves", (String)iOption3.getStringValue());
        }
        catch (BuildException buildException) {
            Assert.fail((String)("Failure getting string value in subsubconfiguration: " + buildException.getLocalizedMessage()));
        }
        IOption iOption4 = (IOption)objectArray[0][1];
        IOption iOption5 = iTool2.getOptionById(iOption4.getId());
        Assert.assertNotNull((Object)iOption5);
        try {
            Assert.assertTrue((boolean)iOption5.getBooleanValue());
        }
        catch (BuildException buildException) {
            Assert.fail((String)("Failure getting boolean value in subsubconfiguration: " + buildException.getLocalizedMessage()));
        }
        try {
            iConfiguration.setOption((IHoldsOptions)iTool2, iOption5, false);
        }
        catch (BuildException buildException) {
            Assert.fail((String)("Failure setting boolean value in subsubconfiguration: " + buildException.getLocalizedMessage()));
        }
        objectArray = iOptionCategoryArray2[0].getOptions(iConfigurationArray[0]);
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)1, (int)n);
        iOption5 = iTool2.getOptionById(((IOption)objectArray[0][1]).getId());
        Assert.assertEquals((String)"Boolean in Chained", (String)iOption2.getName());
        try {
            Assert.assertFalse((boolean)iOption5.getBooleanValue());
        }
        catch (BuildException buildException) {
            Assert.fail((String)("Failure getting boolean value in subsubconfiguration: " + buildException.getLocalizedMessage()));
        }
    }

    private void checkSubProjectType(IProjectType iProjectType) throws BuildException {
        IConfiguration[] iConfigurationArray = iProjectType.getConfigurations();
        Assert.assertEquals((String)"rm -yourworld", (String)iConfigurationArray[0].getCleanCommand());
        Assert.assertEquals((String)"make", (String)iConfigurationArray[0].getBuildCommand());
        IToolChain iToolChain = iConfigurationArray[0].getToolChain();
        ITargetPlatform iTargetPlatform = iToolChain.getTargetPlatform();
        Assert.assertEquals((String)"org.eclipse.cdt.core.PE", (String)iTargetPlatform.getBinaryParserList()[0]);
        Object[] objectArray = new String[]{"win32", "linux", "solaris"};
        Assert.assertTrue((boolean)Arrays.equals(objectArray, iToolChain.getOSList()));
        Object[] objectArray2 = new String[]{"x86", "ppc"};
        Assert.assertTrue((boolean)Arrays.equals(objectArray2, iToolChain.getArchList()));
        Assert.assertTrue((boolean)iProjectType.isTestProjectType());
        Assert.assertEquals((String)iConfigurationArray[0].getArtifactExtension(), (String)subExt);
        ITool[] iToolArray = iConfigurationArray[0].getTools();
        ITool iTool = iToolArray[0];
        Assert.assertEquals((String)"Root Tool", (String)iTool.getName());
        ITool iTool2 = iToolArray[1];
        Assert.assertEquals((String)"Sub Tool", (String)iTool2.getName());
        IOption[] iOptionArray = iTool2.getOptions();
        Assert.assertEquals((int)5, (int)iOptionArray.length);
        Assert.assertEquals((String)"", (String)iTool2.getOutputFlag());
        Assert.assertTrue((boolean)iTool2.buildsFileType("yarf"));
        Assert.assertTrue((boolean)iTool2.producesFileType(subExt));
        Assert.assertEquals((String)"", (String)iTool2.getToolCommand());
        Assert.assertEquals((String)"lib", (String)iTool2.getOutputPrefix());
        Assert.assertTrue((boolean)iTool2.isHeaderFile("arf"));
        Assert.assertTrue((boolean)iTool2.isHeaderFile("barf"));
        Assert.assertEquals((int)2, (int)iTool2.getNatureFilter());
        Assert.assertEquals((String)"Include Paths", (String)iOptionArray[0].getName());
        Assert.assertEquals((int)4, (int)iOptionArray[0].getValueType());
        String[] stringArray = iOptionArray[0].getIncludePaths();
        Assert.assertEquals((int)2, (int)stringArray.length);
        Assert.assertEquals((String)"/usr/include", (String)stringArray[0]);
        Assert.assertEquals((String)"/opt/gnome/include", (String)stringArray[1]);
        String[] stringArray2 = iOptionArray[0].getBuiltIns();
        Assert.assertEquals((int)1, (int)stringArray2.length);
        Assert.assertEquals((String)"/usr/gnu/include", (String)stringArray2[0]);
        Assert.assertEquals((String)"-I", (String)iOptionArray[0].getCommand());
        Assert.assertEquals((int)2, (int)iOptionArray[0].getBrowseType());
        Assert.assertEquals((String)"Defined Symbols", (String)iOptionArray[1].getName());
        Assert.assertEquals((int)5, (int)iOptionArray[1].getValueType());
        String[] stringArray3 = iOptionArray[1].getDefinedSymbols();
        Assert.assertEquals((int)0, (int)stringArray3.length);
        Assert.assertEquals((String)"-D", (String)iOptionArray[1].getCommand());
        String[] stringArray4 = iOptionArray[1].getBuiltIns();
        Assert.assertEquals((int)1, (int)stringArray4.length);
        Assert.assertEquals((String)"BUILTIN", (String)stringArray4[0]);
        Assert.assertEquals((int)0, (int)iOptionArray[1].getBrowseType());
        Assert.assertEquals((String)"More Includes", (String)iOptionArray[2].getName());
        Assert.assertEquals((int)4, (int)iOptionArray[2].getValueType());
        String[] stringArray5 = iOptionArray[2].getIncludePaths();
        Assert.assertEquals((int)2, (int)stringArray5.length);
        Assert.assertEquals((String)"C:\\home\\tester/include", (String)stringArray5[0]);
        Assert.assertEquals((String)"-I", (String)iOptionArray[2].getCommand());
        Assert.assertEquals((int)2, (int)iOptionArray[2].getBrowseType());
        Assert.assertEquals((String)"User Objects", (String)iOptionArray[3].getName());
        Assert.assertEquals((int)7, (int)iOptionArray[3].getValueType());
        String[] stringArray6 = iOptionArray[3].getUserObjects();
        Assert.assertEquals((int)2, (int)stringArray6.length);
        Assert.assertEquals((String)"obj1.o", (String)stringArray6[0]);
        Assert.assertEquals((String)"obj2.o", (String)stringArray6[1]);
        Assert.assertEquals((int)1, (int)iOptionArray[3].getBrowseType());
        Assert.assertEquals((String)"", (String)iOptionArray[3].getCommand());
        Assert.assertEquals((String)"No Command StringList", (String)iOptionArray[4].getName());
        Assert.assertEquals((int)3, (int)iOptionArray[4].getValueType());
        Assert.assertEquals((String)iTool2.getToolFlags(), (String)"-I/usr/include -I/opt/gnome/include -IC:\\home\\tester/include -I\"../includes\" x y z");
        Assert.assertEquals((int)4, (int)iConfigurationArray.length);
        Assert.assertEquals((String)"Sub Config", (String)iConfigurationArray[0].getName());
        Assert.assertEquals((String)"Root Config", (String)iConfigurationArray[1].getName());
        Assert.assertEquals((String)"Root Override Config", (String)iConfigurationArray[2].getName());
        Assert.assertEquals((String)"Complete Override Config", (String)iConfigurationArray[3].getName());
    }

    private void checkForwardProjectTypes(IProjectType iProjectType, IProjectType iProjectType2, IProjectType iProjectType3) {
        Assert.assertEquals((Object)iProjectType, (Object)iProjectType2.getSuperClass());
        Assert.assertEquals((Object)iProjectType2, (Object)iProjectType3.getSuperClass());
        IConfiguration[] iConfigurationArray = iProjectType.getConfigurations();
        ITool[] iToolArray = iConfigurationArray[0].getTools();
        Assert.assertEquals((int)1, (int)iToolArray.length);
        ITool iTool = iToolArray[0];
        Assert.assertNotNull((Object)iTool);
        IOption iOption = iTool.getOptionById("test.forward.option");
        Assert.assertNotNull((Object)iOption);
        IOptionCategory[] iOptionCategoryArray = iTool.getTopOptionCategory().getChildCategories();
        Assert.assertEquals((int)1, (int)iOptionCategoryArray.length);
        IOptionCategory[] iOptionCategoryArray2 = iOptionCategoryArray[0].getChildCategories();
        Assert.assertEquals((int)1, (int)iOptionCategoryArray2.length);
        Assert.assertEquals((int)0, (int)iOptionCategoryArray2[0].getChildCategories().length);
        Object[][] objectArray = iOptionCategoryArray2[0].getOptions(iConfigurationArray[0]);
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n][0] == null) break;
            ++n;
        }
        Assert.assertEquals((int)1, (int)n);
        Assert.assertEquals((Object)iOption, (Object)objectArray[0][1]);
        IConfiguration[] iConfigurationArray2 = iProjectType2.getConfigurations();
        ITool[] iToolArray2 = iConfigurationArray2[0].getTools();
        Assert.assertEquals((int)1, (int)iToolArray2.length);
        ITool iTool2 = iToolArray2[0];
        Assert.assertEquals((Object)iTool.getSuperClass(), (Object)iTool2.getSuperClass());
        IOption iOption2 = iTool2.getOptionById("test.forward.option");
        Assert.assertEquals((Object)iOption, (Object)iOption2);
        IConfiguration[] iConfigurationArray3 = iProjectType3.getConfigurations();
        ITool[] iToolArray3 = iConfigurationArray3[0].getTools();
        Assert.assertEquals((int)1, (int)iToolArray3.length);
        ITool iTool3 = iToolArray3[0];
        Assert.assertEquals((Object)iTool.getSuperClass(), (Object)iTool3.getSuperClass());
    }

    public void checkProviderProjectType(IProjectType iProjectType) throws Exception {
        Properties properties = new Properties();
        properties.load(((Object)((Object)this)).getClass().getResourceAsStream("test_commands"));
        String string = properties.getProperty(iProjectType.getId());
        Assert.assertNotNull((Object)string);
        IProjectType iProjectType2 = iProjectType.getSuperClass();
        Assert.assertNotNull((Object)iProjectType2);
        Assert.assertEquals((String)"test.forward.parent.target", (String)iProjectType2.getId());
        IConfiguration[] iConfigurationArray = iProjectType.getConfigurations();
        ITool iTool = iConfigurationArray[0].getFilteredTools()[0];
        Assert.assertEquals((String)string, (String)iTool.getToolCommand());
    }

    public void cleanup() {
        this.removeProject(projectName);
        this.removeProject(projectName2);
    }

    private IProject createProject(String string) throws CoreException {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        final IProject iProject = iWorkspaceRoot.getProject(string);
        IProject iProject2 = null;
        if (!iProject.exists()) {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription iWorkspaceDescription = iWorkspace.getDescription();
            iWorkspaceDescription.setAutoBuilding(false);
            iWorkspace.setDescription(iWorkspaceDescription);
            IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(iProject.getName());
            iProject2 = CCorePlugin.getDefault().createCProject(iProjectDescription, iProject, (IProgressMonitor)new NullProgressMonitor(), ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID);
            ManagedBuildTestHelper.addManagedBuildNature(iProject2);
        } else {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    iProject.refreshLocal(2, iProgressMonitor);
                }
            };
            NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
            iWorkspace.run(iWorkspaceRunnable, (ISchedulingRule)iWorkspaceRoot, 1, (IProgressMonitor)nullProgressMonitor);
            iProject2 = iProject;
        }
        if (!iProject2.isOpen()) {
            iProject2.open((IProgressMonitor)new NullProgressMonitor());
        }
        return iProject2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeProject(String string) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string);
        if (!iProject.exists()) return;
        try {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                System.gc();
                System.runFinalization();
                iProject.delete(true, true, null);
                throw throwable;
            }
            catch (CoreException coreException) {
                Assert.assertTrue((boolean)false);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (CoreException coreException) {
            Assert.assertTrue((boolean)false);
            return;
        }
        System.gc();
        System.runFinalization();
        iProject.delete(true, true, null);
    }

    public void testErrorParsers() throws BuildException {
        IProjectDescription iProjectDescription;
        IProject iProject = null;
        try {
            iProject = this.createProject(projectName2);
            ManagedBuildTestHelper.addManagedBuildNature(iProject);
            iProjectDescription = iProject.getDescription();
            if (iProjectDescription != null) {
                Assert.assertTrue((boolean)iProjectDescription.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Test failed on error parser project creation: " + coreException.getLocalizedMessage()));
        }
        iProjectDescription = ManagedBuildManager.getProjectType((String)"test.error.parsers");
        Assert.assertNotNull((Object)iProjectDescription);
        IManagedProject iManagedProject = ManagedBuildManager.createManagedProject((IResource)iProject, (IProjectType)iProjectDescription);
        Assert.assertEquals((String)iManagedProject.getName(), (String)iProjectDescription.getName());
        ManagedBuildManager.setNewProjectVersion((IProject)iProject);
        IStatus iStatus = ManagedBuildManager.initBuildInfoContainer((IResource)iProject);
        if (iStatus.getCode() != 0) {
            Assert.fail((String)("Initializing build information failed for: " + iProject.getName() + " because: " + iStatus.getMessage()));
        }
        IConfiguration[] iConfigurationArray = iProjectDescription.getConfigurations();
        int n = 0;
        while (n < iConfigurationArray.length) {
            iManagedProject.createConfiguration(iConfigurationArray[n], String.valueOf(iConfigurationArray[n].getId()) + "." + n);
            ++n;
        }
        this.checkErrorParsersProject(iManagedProject);
        ManagedBuildManager.saveBuildInfo((IProject)iProject, (boolean)true);
        ManagedBuildManager.removeBuildInfo((IResource)iProject);
        try {
            iProject.close(null);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed on error parser project close: " + coreException.getLocalizedMessage()));
        }
        try {
            iProject.open(null);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed on error parser project open: " + coreException.getLocalizedMessage()));
        }
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        this.checkErrorParsersProject(iManagedBuildInfo.getManagedProject());
        ManagedBuildManager.removeBuildInfo((IResource)iProject);
    }

    private void checkErrorParsersProject(IManagedProject iManagedProject) throws BuildException {
        String string = "org.eclipse.cdt.core.PE";
        IConfiguration[] iConfigurationArray = iManagedProject.getConfigurations();
        IToolChain iToolChain = iConfigurationArray[0].getToolChain();
        ITargetPlatform iTargetPlatform = iToolChain.getTargetPlatform();
        Assert.assertEquals((String)string, (String)iTargetPlatform.getBinaryParserList()[0]);
        Assert.assertEquals((String)"org.eclipse.cdt.core.MakeErrorParser;org.eclipse.cdt.core.GCCErrorParser;org.eclipse.cdt.core.GLDErrorParser", (String)iConfigurationArray[0].getErrorParserIds());
        ITool[] iToolArray = iConfigurationArray[0].getTools();
        ITool iTool = iToolArray[0];
        Assert.assertEquals((int)1, (int)iToolArray.length);
        Assert.assertEquals((String)"EP Tool", (String)iToolArray[0].getName());
        Assert.assertEquals((String)"-o", (String)iToolArray[0].getOutputFlag());
        Assert.assertTrue((boolean)iToolArray[0].buildsFileType("y"));
        Assert.assertTrue((boolean)iToolArray[0].buildsFileType("x"));
        Assert.assertTrue((boolean)iToolArray[0].producesFileType("xy"));
        Assert.assertEquals((String)"EP", (String)iToolArray[0].getToolCommand());
        Assert.assertEquals((int)0, (int)iTool.getNatureFilter());
        Assert.assertEquals((int)1, (int)iConfigurationArray.length);
    }

    public void testConfigBuildArtifact() throws CoreException {
        IProject iProject = this.createProject(projectName);
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        Assert.assertNotNull((Object)iManagedBuildInfo);
        IManagedProject iManagedProject = iManagedBuildInfo.getManagedProject();
        Assert.assertNotNull((Object)iManagedProject);
        IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
        Assert.assertNotNull((Object)iConfiguration);
        String string = iConfiguration.getArtifactExtension();
        String string2 = String.valueOf(iProject.getName()) + "." + string;
        iConfiguration.setArtifactName(string2);
        ManagedBuildManager.saveBuildInfo((IProject)iProject, (boolean)false);
        ManagedBuildManager.removeBuildInfo((IResource)iProject);
        iProject.close(null);
        iProject.open(null);
        iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        Assert.assertNotNull((Object)iManagedBuildInfo);
        iManagedProject = iManagedBuildInfo.getManagedProject();
        Assert.assertNotNull((Object)iManagedProject);
        iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
        Assert.assertNotNull((Object)iConfiguration);
        Assert.assertEquals((String)string2, (String)iConfiguration.getArtifactName());
    }

    public void testThatAlwaysFails() {
        Assert.assertTrue((boolean)false);
    }

    public void testBug43450() throws Exception {
        IFile iFile;
        IProject iProject = this.createProject(projectName);
        IFolder iFolder = iProject.getProject().getFolder("includes");
        if (!iFolder.exists()) {
            iFolder.create(false, true, null);
        }
        if (!(iFile = iProject.getProject().getFile("includes/header.h")).exists()) {
            iFile.create((InputStream)new ByteArrayInputStream("class A { public : static int i; };".getBytes()), false, null);
        }
        IScannerInfoProvider iScannerInfoProvider = CCorePlugin.getDefault().getScannerInfoProvider(iProject);
        IScannerInfo iScannerInfo = iScannerInfoProvider.getScannerInformation((IResource)iProject);
        NullSourceElementRequestor nullSourceElementRequestor = new NullSourceElementRequestor();
        IScanner iScanner = ParserFactory.createScanner((CodeReader)new CodeReader("#include <header.h>\n int A::i = 1;".toCharArray()), (IScannerInfo)iScannerInfo, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)nullSourceElementRequestor, (IParserLogService)new NullLogService(), null);
        IParser iParser = ParserFactory.createParser((IScanner)iScanner, (ISourceElementRequestor)nullSourceElementRequestor, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)ParserLanguage.CPP, null);
        Assert.assertTrue((boolean)iParser.parse());
    }
}

