/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.tests.ManagedBuildMacrosTests;
import org.eclipse.cdt.managedbuilder.core.tests.TestMacro;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentBuildPathsChangeListener;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.internal.envvar.UserDefinedEnvironmentSupplier;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;

public class ManagedBuildEnvironmentTests
extends TestCase {
    private final String REQUIRED_TYPE = "cdt.managedbuild.target.testgnu.exe";
    private final String NAME_CWD = "CWD";
    private final String NAME_PWD = "PWD";
    private final String NAME_CMN = "COMMON";
    private final String NAME_WSP = "WSP";
    private final String NAME_PRJI = "PRJI";
    private final String NAME_PRJL = "PRJL";
    private final String NAME_CFGI = "CFGI";
    private final String NAME_CFGL = "CFGL";
    private final String NAME_CFGX = "CFGX";
    private final String NAME_CFG = "CFG";
    private final String NAME_REM1 = "REMTST1";
    private final String NAME_REM2 = "REMTST2";
    private final String VAL_CWDPWD = "CWD_&_PWD_should not be changed";
    private final String VAL_DUMMY1 = "/a/b/c";
    private final String VAL_DUMMY2 = "/d/e/f";
    private final String VAL_PRO_INC = "/project/inc";
    private final String VAL_PRO_LIB = "/project/lib";
    private final String LISTENER_DATA = "O1T1O1O2T2T1O1T1O2T2";
    private final String DEL_WIN = ";";
    private final String DEL_UNIX = ":";
    IEnvironmentVariableProvider envProvider = null;
    IWorkspace worksp = null;
    IProject proj = null;
    IManagedProject mproj = null;
    String listenerResult = "";
    IEnvironmentBuildPathsChangeListener listener = new IEnvironmentBuildPathsChangeListener(){

        public void buildPathsChanged(IConfiguration iConfiguration, int n) {
            ManagedBuildEnvironmentTests.this.listenerResult = String.valueOf(ManagedBuildEnvironmentTests.this.listenerResult) + iConfiguration.getName().charAt(0) + n;
        }
    };
    static /* synthetic */ Class class$0;

    public ManagedBuildEnvironmentTests() {
    }

    public ManagedBuildEnvironmentTests(String string) {
        super(string);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.ManagedBuildEnvironmentTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new ManagedBuildEnvironmentTests("testEnvNotDef"));
        testSuite.addTest((Test)new ManagedBuildEnvironmentTests("testEnvUpper"));
        testSuite.addTest((Test)new ManagedBuildEnvironmentTests("testEnvAppend"));
        testSuite.addTest((Test)new ManagedBuildEnvironmentTests("testEnvCWDPWD"));
        testSuite.addTest((Test)new ManagedBuildEnvironmentTests("testEnvSuppliers"));
        testSuite.addTest((Test)new ManagedBuildEnvironmentTests("testEnvGetPath"));
        testSuite.addTest((Test)new ManagedBuildEnvironmentTests("testEnvSubscribe"));
        testSuite.addTest((Test)new ManagedBuildEnvironmentTests("testEnvGetParams"));
        testSuite.addTest((Test)new ManagedBuildEnvironmentTests("testEnvRemove"));
        testSuite.addTest((Test)new ManagedBuildEnvironmentTests("testEnvProvider"));
        return testSuite;
    }

    public void testEnvNotDef() {
        this.doInit();
        Assert.assertNotNull((String)"System  vars", (Object)this.envProvider.getVariables(null, true, false));
        Assert.assertNotNull((String)"Worksp. vars", (Object)this.envProvider.getVariables((Object)this.worksp, true, false));
        Assert.assertNotNull((String)"Project vars", (Object)this.envProvider.getVariables((Object)this.mproj, true, false));
        IConfiguration[] iConfigurationArray = this.mproj.getConfigurations();
        int n = 0;
        while (n < iConfigurationArray.length) {
            Assert.assertNotNull((String)("Project vars[" + n + "]"), (Object)this.envProvider.getVariables((Object)iConfigurationArray[n], true, false));
            ++n;
        }
    }

    public void testEnvUpper() {
        this.doInit();
        this.addTestVariables();
        IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray = this.envProvider.getVariables(null, true, false);
        IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray2 = this.envProvider.getVariables((Object)this.worksp, true, false);
        Assert.assertTrue((boolean)this.varListContainNames(iBuildEnvironmentVariableArray, iBuildEnvironmentVariableArray2));
        IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray3 = this.envProvider.getVariables((Object)this.mproj, true, false);
        Assert.assertTrue((boolean)this.varListContainNames(iBuildEnvironmentVariableArray2, iBuildEnvironmentVariableArray3));
        IConfiguration[] iConfigurationArray = this.mproj.getConfigurations();
        int n = 0;
        while (n < iConfigurationArray.length) {
            IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray4 = this.envProvider.getVariables((Object)iConfigurationArray[n], true, false);
            Assert.assertTrue((boolean)this.varListContainNames(iBuildEnvironmentVariableArray3, iBuildEnvironmentVariableArray4));
            ++n;
        }
    }

    public void testEnvAppend() {
        this.doInit();
        IBuildEnvironmentVariable iBuildEnvironmentVariable = this.envProvider.getVariable("COMMON", (Object)this.worksp, true, false);
        Assert.assertEquals((String)"WSP", (String)iBuildEnvironmentVariable.getValue());
        iBuildEnvironmentVariable = this.envProvider.getVariable("COMMON", (Object)this.mproj, true, false);
        Assert.assertNotNull((Object)iBuildEnvironmentVariable);
        Assert.assertEquals((String)"WSP:PRJI", (String)iBuildEnvironmentVariable.getValue());
        IConfiguration iConfiguration = this.mproj.getConfigurations()[0];
        iBuildEnvironmentVariable = this.envProvider.getVariable("COMMON", (Object)iConfiguration, true, false);
        Assert.assertNotNull((Object)iBuildEnvironmentVariable);
        Assert.assertEquals((String)"WSP:PRJI:CFGI", (String)iBuildEnvironmentVariable.getValue());
    }

    public void testEnvCWDPWD() {
        this.doInit();
        IConfiguration iConfiguration = this.mproj.getConfigurations()[0];
        IBuildEnvironmentVariable iBuildEnvironmentVariable = this.envProvider.getVariable("CWD", (Object)iConfiguration, true, false);
        Assert.assertNotNull((Object)iBuildEnvironmentVariable);
        if ("CWD_&_PWD_should not be changed".equals(iBuildEnvironmentVariable.getValue())) {
            Assert.fail((String)"CWD should not be rewritten !");
        }
        iBuildEnvironmentVariable = this.envProvider.getVariable("PWD", (Object)iConfiguration, true, false);
        Assert.assertNotNull((Object)iBuildEnvironmentVariable);
        if ("CWD_&_PWD_should not be changed".equals(iBuildEnvironmentVariable.getValue())) {
            Assert.fail((String)"PWD should not be rewritten !");
        }
        UserDefinedEnvironmentSupplier userDefinedEnvironmentSupplier = ManagedBuildEnvironmentTests.getSupplier(iConfiguration, iConfiguration.getName());
        Assert.assertNull((Object)userDefinedEnvironmentSupplier.deleteVariable("CWD", (Object)iConfiguration));
        Assert.assertNull((Object)userDefinedEnvironmentSupplier.deleteVariable("PWD", (Object)iConfiguration));
        Assert.assertNotNull((Object)this.envProvider.getVariable("CWD", (Object)iConfiguration, true, false));
        Assert.assertNotNull((Object)this.envProvider.getVariable("PWD", (Object)iConfiguration, true, false));
    }

    public void testEnvSuppliers() {
        this.doInit();
        IEnvironmentVariableSupplier[] iEnvironmentVariableSupplierArray = this.envProvider.getSuppliers(null);
        Assert.assertEquals((String)"System suppliers count not equal to 1", (int)iEnvironmentVariableSupplierArray.length, (int)1);
        IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray = iEnvironmentVariableSupplierArray[0].getVariables(null);
        Assert.assertNotNull((Object)iBuildEnvironmentVariableArray);
        IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray2 = this.envProvider.getVariables(null, false, false);
        Assert.assertTrue((boolean)this.varListContainNames(iBuildEnvironmentVariableArray, iBuildEnvironmentVariableArray2));
        Assert.assertTrue((boolean)this.varListContainNames(iBuildEnvironmentVariableArray2, iBuildEnvironmentVariableArray));
        IEnvironmentVariableSupplier[] iEnvironmentVariableSupplierArray2 = this.envProvider.getSuppliers((Object)this.worksp);
        Assert.assertEquals((String)"Workspace suppliers count not equal to 1", (int)iEnvironmentVariableSupplierArray2.length, (int)1);
        iBuildEnvironmentVariableArray = iEnvironmentVariableSupplierArray2[0].getVariables((Object)this.worksp);
        Assert.assertNotNull((Object)iBuildEnvironmentVariableArray);
        iBuildEnvironmentVariableArray2 = this.envProvider.getVariables((Object)this.worksp, false, false);
        Assert.assertTrue((boolean)this.varListContainNames(iBuildEnvironmentVariableArray, iBuildEnvironmentVariableArray2));
        Assert.assertTrue((boolean)this.varListContainNames(iBuildEnvironmentVariableArray2, iBuildEnvironmentVariableArray));
        IEnvironmentVariableSupplier[] iEnvironmentVariableSupplierArray3 = this.envProvider.getSuppliers((Object)this.mproj);
        Assert.assertEquals((String)"Project suppliers count not equal to 2", (int)iEnvironmentVariableSupplierArray3.length, (int)2);
        iBuildEnvironmentVariableArray2 = this.envProvider.getVariables((Object)this.mproj, false, false);
        int n = 0;
        while (n < iEnvironmentVariableSupplierArray3.length) {
            Assert.assertTrue((boolean)this.varListContainNames(iEnvironmentVariableSupplierArray3[n].getVariables((Object)this.mproj), iBuildEnvironmentVariableArray2));
            ++n;
        }
        IConfiguration[] iConfigurationArray = this.mproj.getConfigurations();
        int n2 = 0;
        while (n2 < iConfigurationArray.length) {
            iBuildEnvironmentVariableArray2 = this.envProvider.getVariables((Object)iConfigurationArray[n2], false, false);
            IEnvironmentVariableSupplier[] iEnvironmentVariableSupplierArray4 = this.envProvider.getSuppliers((Object)iConfigurationArray[n2]);
            Assert.assertEquals((String)"Configuration suppliers count not equal to 3", (int)iEnvironmentVariableSupplierArray4.length, (int)3);
            int n3 = 0;
            while (n3 < iEnvironmentVariableSupplierArray4.length) {
                Assert.assertTrue((boolean)this.varListContainNames(iEnvironmentVariableSupplierArray4[n3].getVariables((Object)iConfigurationArray[n2]), iBuildEnvironmentVariableArray2));
                ++n3;
            }
            ++n2;
        }
    }

    public void testEnvGetPath() {
        this.doInit();
        IConfiguration[] iConfigurationArray = this.mproj.getConfigurations();
        int n = 0;
        while (n < 2) {
            String[] stringArray = new String[]{"/config/include/" + n, "/config" + n + "/include", "/project/inc"};
            String[] stringArray2 = new String[]{"/config/lib/" + n, "/project/lib"};
            String[] stringArray3 = this.envProvider.getBuildPaths(iConfigurationArray[n], 1);
            String[] stringArray4 = this.envProvider.getBuildPaths(iConfigurationArray[n], 2);
            String[] stringArray5 = this.envProvider.getBuildPaths(iConfigurationArray[n], 0);
            Assert.assertNotNull((String)"Include path is null", (Object)stringArray3);
            Assert.assertNotNull((String)"Library path is null", (Object)stringArray4);
            Assert.assertNotNull((String)"Bad path type returns null", (Object)stringArray5);
            Assert.assertEquals((String)"Include path should contain 3 entries !", (int)stringArray3.length, (int)3);
            Assert.assertEquals((String)"Library path should contain 2 entries !", (int)stringArray4.length, (int)2);
            Assert.assertEquals((String)"Request with bad path type should return 0 entries !", (int)stringArray5.length, (int)0);
            this.compareStringLists(String.valueOf(iConfigurationArray[n].getName()) + "-include", stringArray3, stringArray);
            this.compareStringLists(String.valueOf(iConfigurationArray[n].getName()) + "-library", stringArray4, stringArray2);
            ++n;
        }
    }

    public void testEnvSubscribe() {
        this.doInit();
        IConfiguration[] iConfigurationArray = this.mproj.getConfigurations();
        IConfiguration iConfiguration = iConfigurationArray[0];
        UserDefinedEnvironmentSupplier userDefinedEnvironmentSupplier = ManagedBuildEnvironmentTests.getSupplier(iConfiguration, iConfiguration.getName());
        Assert.assertNotNull((Object)userDefinedEnvironmentSupplier);
        try {
            userDefinedEnvironmentSupplier.deleteVariable("CFGI", (Object)iConfigurationArray[0]);
            userDefinedEnvironmentSupplier.deleteVariable("CFGI", (Object)iConfigurationArray[1]);
            userDefinedEnvironmentSupplier.deleteVariable("CFG0", (Object)iConfigurationArray[0]);
            userDefinedEnvironmentSupplier.deleteVariable("CFG1", (Object)iConfigurationArray[0]);
            userDefinedEnvironmentSupplier.deleteVariable("CFG0", (Object)iConfigurationArray[1]);
            userDefinedEnvironmentSupplier.deleteVariable("CFG1", (Object)iConfigurationArray[1]);
            userDefinedEnvironmentSupplier.deleteVariable("CFGL", (Object)iConfigurationArray[0]);
            userDefinedEnvironmentSupplier.deleteVariable("CFGL", (Object)iConfigurationArray[1]);
            userDefinedEnvironmentSupplier.deleteVariable("PRJI", (Object)this.mproj);
            userDefinedEnvironmentSupplier.deleteVariable("PRJL", (Object)this.mproj);
            userDefinedEnvironmentSupplier.deleteVariable("CFGX", (Object)this.mproj);
            this.listenerResult = "";
            this.envProvider.subscribe(this.listener);
            userDefinedEnvironmentSupplier.createVariable("CFGI", "/d/e/f", 1, ":", (Object)iConfigurationArray[0]);
            Assert.assertEquals((String)"Step 1", (String)this.listenerResult, (String)"O1T1O1O2T2T1O1T1O2T2".substring(0, 2));
            userDefinedEnvironmentSupplier.createVariable("CFGI", "/d/e/f", 1, ":", (Object)iConfigurationArray[1]);
            Assert.assertEquals((String)"Step 2", (String)this.listenerResult, (String)"O1T1O1O2T2T1O1T1O2T2".substring(0, 4));
            userDefinedEnvironmentSupplier.createVariable("CFG0", "/d/e/f", 1, ":", (Object)iConfigurationArray[0]);
            Assert.assertEquals((String)"Step 3", (String)this.listenerResult, (String)"O1T1O1O2T2T1O1T1O2T2".substring(0, 6));
            userDefinedEnvironmentSupplier.createVariable("CFG1", "/d/e/f", 1, ":", (Object)iConfigurationArray[0]);
            Assert.assertEquals((String)"Step 4", (String)this.listenerResult, (String)"O1T1O1O2T2T1O1T1O2T2".substring(0, 6));
            userDefinedEnvironmentSupplier.createVariable("CFGL", "/d/e/f", 1, ":", (Object)iConfigurationArray[0]);
            Assert.assertEquals((String)"Step 5", (String)this.listenerResult, (String)"O1T1O1O2T2T1O1T1O2T2".substring(0, 8));
            userDefinedEnvironmentSupplier.createVariable("CFGL", "/d/e/f", 1, ":", (Object)iConfigurationArray[1]);
            Assert.assertEquals((String)"Step 6", (String)this.listenerResult, (String)"O1T1O1O2T2T1O1T1O2T2".substring(0, 10));
            userDefinedEnvironmentSupplier.createVariable("CFG0", "/d/e/f", 1, ":", (Object)iConfigurationArray[1]);
            Assert.assertEquals((String)"Step 7", (String)this.listenerResult, (String)"O1T1O1O2T2T1O1T1O2T2".substring(0, 10));
            userDefinedEnvironmentSupplier.createVariable("CFG1", "/d/e/f", 1, ":", (Object)iConfigurationArray[1]);
            Assert.assertEquals((String)"Step 8", (String)this.listenerResult, (String)"O1T1O1O2T2T1O1T1O2T2".substring(0, 12));
            userDefinedEnvironmentSupplier.createVariable("PRJI", "/d/e/f", 1, ":", (Object)this.mproj);
            Assert.assertEquals((String)"Step 9", (String)this.listenerResult, (String)"O1T1O1O2T2T1O1T1O2T2".substring(0, 16));
            userDefinedEnvironmentSupplier.createVariable("PRJL", "/d/e/f", 1, ":", (Object)this.mproj);
            Assert.assertEquals((String)"Step 10", (String)this.listenerResult, (String)"O1T1O1O2T2T1O1T1O2T2");
            userDefinedEnvironmentSupplier.createVariable("PRJL", "/d/e/f", 1, ":", (Object)this.mproj);
            Assert.assertEquals((String)"Step 11", (String)this.listenerResult, (String)"O1T1O1O2T2T1O1T1O2T2");
            userDefinedEnvironmentSupplier.createVariable("CFGX", "/d/e/f", 1, ":", (Object)this.mproj);
            Assert.assertEquals((String)"Step 12", (String)this.listenerResult, (String)"O1T1O1O2T2T1O1T1O2T2");
            this.envProvider.unsubscribe(this.listener);
            userDefinedEnvironmentSupplier.createVariable("PRJI", "/a/b/c", 1, ":", (Object)this.mproj);
            userDefinedEnvironmentSupplier.createVariable("CFGI", "/a/b/c", 1, ":", (Object)iConfigurationArray[0]);
            userDefinedEnvironmentSupplier.createVariable("CFGI", "/a/b/c", 1, ":", (Object)iConfigurationArray[1]);
            Assert.assertEquals((String)"Step 13", (String)this.listenerResult, (String)"O1T1O1O2T2T1O1T1O2T2");
        }
        catch (Exception exception) {
            Assert.fail((String)"Failed to create configuration vars !");
        }
    }

    public void testEnvGetParams() {
        this.doInit();
        IEnvironmentVariableProvider iEnvironmentVariableProvider = ManagedBuildManager.getEnvironmentVariableProvider();
        IBuildEnvironmentVariable iBuildEnvironmentVariable = null;
        IBuildEnvironmentVariable iBuildEnvironmentVariable2 = null;
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            Assert.assertEquals((String)iEnvironmentVariableProvider.getDefaultDelimiter(), (String)";");
            Assert.assertFalse((boolean)iEnvironmentVariableProvider.isVariableCaseSensitive());
            iBuildEnvironmentVariable = iEnvironmentVariableProvider.getVariable("PATH", (Object)this.mproj, true, false);
            Assert.assertNotNull((Object)iBuildEnvironmentVariable);
            iBuildEnvironmentVariable2 = iEnvironmentVariableProvider.getVariable("path", (Object)this.mproj, true, false);
            Assert.assertNotNull((Object)iBuildEnvironmentVariable2);
            Assert.assertEquals((String)iBuildEnvironmentVariable.getName(), (String)iBuildEnvironmentVariable2.getName());
            Assert.assertEquals((String)iBuildEnvironmentVariable.getValue(), (String)iBuildEnvironmentVariable2.getValue());
        } else {
            Assert.assertEquals((String)iEnvironmentVariableProvider.getDefaultDelimiter(), (String)":");
            Assert.assertTrue((boolean)iEnvironmentVariableProvider.isVariableCaseSensitive());
            iBuildEnvironmentVariable = iEnvironmentVariableProvider.getVariable("PATH", (Object)this.mproj, true, false);
            Assert.assertNotNull((Object)iBuildEnvironmentVariable);
            iBuildEnvironmentVariable2 = iEnvironmentVariableProvider.getVariable("path", (Object)this.mproj, true, false);
            if (iBuildEnvironmentVariable2 != null) {
                Assert.assertFalse((boolean)iBuildEnvironmentVariable.getName().equals(iBuildEnvironmentVariable2.getName()));
            }
        }
    }

    public void testEnvRemove() {
        this.doInit();
        IEnvironmentVariableProvider iEnvironmentVariableProvider = ManagedBuildManager.getEnvironmentVariableProvider();
        UserDefinedEnvironmentSupplier userDefinedEnvironmentSupplier = null;
        userDefinedEnvironmentSupplier = ManagedBuildEnvironmentTests.getSupplier(this.worksp, "Workspace");
        Assert.assertNotNull((Object)userDefinedEnvironmentSupplier);
        try {
            Assert.assertNotNull((Object)userDefinedEnvironmentSupplier.createVariable("REMTST1", "/a/b/c", 1, ":", (Object)this.worksp));
            Assert.assertNotNull((Object)userDefinedEnvironmentSupplier.createVariable("REMTST2", "/a/b/c", 1, ":", (Object)this.worksp));
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getLocalizedMessage());
        }
        userDefinedEnvironmentSupplier = ManagedBuildEnvironmentTests.getSupplier(this.mproj, "Project");
        Assert.assertNotNull((Object)userDefinedEnvironmentSupplier);
        try {
            Assert.assertNotNull((Object)userDefinedEnvironmentSupplier.createVariable("REMTST1", "/d/e/f", 2, ":", (Object)this.mproj));
            Assert.assertNotNull((Object)userDefinedEnvironmentSupplier.createVariable("REMTST2", "/d/e/f", 4, ":", (Object)this.mproj));
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getLocalizedMessage());
        }
        IConfiguration iConfiguration = this.mproj.getConfigurations()[0];
        userDefinedEnvironmentSupplier = ManagedBuildEnvironmentTests.getSupplier(iConfiguration, "Configuration 0");
        Assert.assertNotNull((Object)userDefinedEnvironmentSupplier);
        try {
            Assert.assertNotNull((Object)userDefinedEnvironmentSupplier.createVariable("REMTST1", "CWD_&_PWD_should not be changed", 2, ":", (Object)iConfiguration));
            Assert.assertNotNull((Object)userDefinedEnvironmentSupplier.createVariable("REMTST2", "CWD_&_PWD_should not be changed", 2, ":", (Object)iConfiguration));
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getLocalizedMessage());
        }
        IBuildEnvironmentVariable iBuildEnvironmentVariable = iEnvironmentVariableProvider.getVariable("REMTST1", (Object)this.worksp, true, false);
        IBuildEnvironmentVariable iBuildEnvironmentVariable2 = iEnvironmentVariableProvider.getVariable("REMTST2", (Object)this.worksp, true, false);
        Assert.assertNotNull((Object)iBuildEnvironmentVariable);
        Assert.assertNotNull((Object)iBuildEnvironmentVariable2);
        iBuildEnvironmentVariable = iEnvironmentVariableProvider.getVariable("REMTST1", (Object)this.mproj, true, false);
        iBuildEnvironmentVariable2 = iEnvironmentVariableProvider.getVariable("REMTST2", (Object)this.mproj, true, false);
        Assert.assertNull((Object)iBuildEnvironmentVariable);
        Assert.assertNotNull((Object)iBuildEnvironmentVariable2);
        Assert.assertEquals((String)iBuildEnvironmentVariable2.getValue(), (String)"/a/b/c:/d/e/f");
        iBuildEnvironmentVariable = iEnvironmentVariableProvider.getVariable("REMTST1", (Object)iConfiguration, true, false);
        iBuildEnvironmentVariable2 = iEnvironmentVariableProvider.getVariable("REMTST2", (Object)iConfiguration, true, false);
        Assert.assertNull((Object)iBuildEnvironmentVariable);
        Assert.assertNull((Object)iBuildEnvironmentVariable2);
    }

    public void testEnvProvider() {
        this.doInit();
        IBuildEnvironmentVariable iBuildEnvironmentVariable = this.envProvider.getVariable(TestMacro.PRJ_VAR, (Object)this.mproj, true, false);
        Assert.assertNotNull((Object)iBuildEnvironmentVariable);
        Assert.assertEquals((String)(String.valueOf(TestMacro.PRJ_VAR) + this.mproj.getName()), (String)iBuildEnvironmentVariable.getValue());
        IConfiguration[] iConfigurationArray = this.mproj.getConfigurations();
        iBuildEnvironmentVariable = this.envProvider.getVariable(TestMacro.CFG_VAR, (Object)iConfigurationArray[0], true, false);
        Assert.assertNotNull((Object)iBuildEnvironmentVariable);
        Assert.assertEquals((String)(String.valueOf(TestMacro.CFG_VAR) + iConfigurationArray[0].getName()), (String)iBuildEnvironmentVariable.getValue());
        iBuildEnvironmentVariable = this.envProvider.getVariable(TestMacro.CFG_VAR, (Object)iConfigurationArray[1], true, false);
        Assert.assertNull((Object)iBuildEnvironmentVariable);
        UserDefinedEnvironmentSupplier userDefinedEnvironmentSupplier = ManagedBuildEnvironmentTests.getSupplier(iConfigurationArray[0], iConfigurationArray[0].getName());
        userDefinedEnvironmentSupplier.createVariable(TestMacro.PRJ_VAR, "/a/b/c", 3, ":", (Object)iConfigurationArray[0]);
        iBuildEnvironmentVariable = this.envProvider.getVariable(TestMacro.PRJ_VAR, (Object)iConfigurationArray[0], true, false);
        Assert.assertNotNull((Object)iBuildEnvironmentVariable);
        Assert.assertEquals((String)("/a/b/c:" + TestMacro.PRJ_VAR + this.mproj.getName()), (String)iBuildEnvironmentVariable.getValue());
    }

    public void testEnvPrint() {
        this.doInit();
        this.printVar("s-Var", this.envProvider.getVariables(null, false, false));
        this.printVar("w-Var", this.envProvider.getVariables((Object)this.worksp, false, false));
        this.printVar("p-Var", this.envProvider.getVariables((Object)this.mproj, false, false));
        IConfiguration[] iConfigurationArray = this.mproj.getConfigurations();
        int n = 0;
        while (n < iConfigurationArray.length) {
            this.printVar("c[" + n + "]-Var", this.envProvider.getVariables((Object)iConfigurationArray[n], false, false));
            ++n;
        }
    }

    public static UserDefinedEnvironmentSupplier getSupplier(Object object, String string) {
        IEnvironmentVariableSupplier[] iEnvironmentVariableSupplierArray = null;
        iEnvironmentVariableSupplierArray = ManagedBuildManager.getEnvironmentVariableProvider().getSuppliers(object);
        int n = 0;
        while (n < iEnvironmentVariableSupplierArray.length) {
            if (iEnvironmentVariableSupplierArray[n] instanceof UserDefinedEnvironmentSupplier) {
                return (UserDefinedEnvironmentSupplier)iEnvironmentVariableSupplierArray[n];
            }
            ++n;
        }
        Assert.fail((String)("Cannot access user variable supplier for " + string));
        return null;
    }

    private void addTestVariables() {
        UserDefinedEnvironmentSupplier userDefinedEnvironmentSupplier = null;
        userDefinedEnvironmentSupplier = ManagedBuildEnvironmentTests.getSupplier(this.worksp, "Workspace");
        try {
            if (userDefinedEnvironmentSupplier != null) {
                Assert.assertNotNull((Object)userDefinedEnvironmentSupplier.createVariable("COMMON", "WSP", 4, ":", (Object)this.worksp));
                Assert.assertNotNull((Object)userDefinedEnvironmentSupplier.createVariable("WSP", "/a/b/c", 1, ":", (Object)this.worksp));
                Assert.assertNull((Object)userDefinedEnvironmentSupplier.createVariable("CWD", "CWD_&_PWD_should not be changed", 1, ":", (Object)this.worksp));
                Assert.assertNull((Object)userDefinedEnvironmentSupplier.createVariable("PWD", "CWD_&_PWD_should not be changed", 1, ":", (Object)this.worksp));
            }
        }
        catch (Exception exception) {
            Assert.fail((String)("Failed to create workspace vars " + exception.getLocalizedMessage()));
        }
        userDefinedEnvironmentSupplier = ManagedBuildEnvironmentTests.getSupplier(this.mproj, "Project");
        try {
            if (userDefinedEnvironmentSupplier != null) {
                Assert.assertNotNull((Object)userDefinedEnvironmentSupplier.createVariable("COMMON", "PRJI", 4, ":", (Object)this.mproj));
                Assert.assertNotNull((Object)userDefinedEnvironmentSupplier.createVariable("PRJI", "/project/inc", 1, ":", (Object)this.mproj));
                Assert.assertNotNull((Object)userDefinedEnvironmentSupplier.createVariable("PRJL", "/project/lib", 1, ":", (Object)this.mproj));
                Assert.assertNull((Object)userDefinedEnvironmentSupplier.createVariable("CWD", "CWD_&_PWD_should not be changed", 1, ":", (Object)this.mproj));
                Assert.assertNull((Object)userDefinedEnvironmentSupplier.createVariable("PWD", "CWD_&_PWD_should not be changed", 1, ":", (Object)this.mproj));
            }
        }
        catch (Exception exception) {
            Assert.fail((String)("Failed to create project vars " + exception.getLocalizedMessage()));
        }
        IConfiguration[] iConfigurationArray = this.mproj.getConfigurations();
        int n = 0;
        while (n < 2) {
            IConfiguration iConfiguration = iConfigurationArray[n];
            userDefinedEnvironmentSupplier = ManagedBuildEnvironmentTests.getSupplier(iConfiguration, "Configuration " + iConfiguration.getName());
            try {
                if (userDefinedEnvironmentSupplier != null) {
                    Assert.assertNotNull((Object)userDefinedEnvironmentSupplier.createVariable("COMMON", "CFGI", 4, ":", (Object)iConfiguration));
                    Assert.assertNotNull((Object)userDefinedEnvironmentSupplier.createVariable("CFGI", "/config/include/" + n, 1, ":", (Object)iConfiguration));
                    Assert.assertNotNull((Object)userDefinedEnvironmentSupplier.createVariable("CFG" + n, "/config" + n + "/include", 1, ":", (Object)iConfiguration));
                    Assert.assertNotNull((Object)userDefinedEnvironmentSupplier.createVariable("CFGL", "/config/lib/" + n, 1, ":", (Object)iConfiguration));
                    Assert.assertNotNull((Object)userDefinedEnvironmentSupplier.createVariable("CFGX", "/config/unused", 1, ":", (Object)iConfiguration));
                    Assert.assertNull((Object)userDefinedEnvironmentSupplier.createVariable("CWD", "CWD_&_PWD_should not be changed", 1, ":", (Object)iConfiguration));
                    Assert.assertNull((Object)userDefinedEnvironmentSupplier.createVariable("PWD", "CWD_&_PWD_should not be changed", 1, ":", (Object)iConfiguration));
                }
            }
            catch (Exception exception) {
                Assert.fail((String)("Failed to create configuration vars for <" + iConfiguration.getName() + "> - " + exception.getLocalizedMessage()));
            }
            ++n;
        }
        try {
            this.proj.build(6, null);
        }
        catch (Exception exception) {}
    }

    private void doInit() {
        this.envProvider = ManagedBuildManager.getEnvironmentVariableProvider();
        Assert.assertNotNull((Object)this.envProvider);
        ManagedBuildMacrosTests.createManagedProject("Merde");
        this.proj = ManagedBuildMacrosTests.proj;
        Assert.assertNotNull((Object)this.proj);
        this.mproj = ManagedBuildMacrosTests.mproj;
        Assert.assertNotNull((Object)this.mproj);
        this.worksp = this.proj.getWorkspace();
        Assert.assertNotNull((Object)this.worksp);
    }

    private void printVar(String string, IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray) {
        if (iBuildEnvironmentVariableArray != null) {
            if (iBuildEnvironmentVariableArray.length > 0) {
                int n = 0;
                while (n < iBuildEnvironmentVariableArray.length) {
                    System.out.println(String.valueOf(string) + "[" + n + "] " + iBuildEnvironmentVariableArray[n].getName() + " = " + iBuildEnvironmentVariableArray[n].getValue() + " / " + iBuildEnvironmentVariableArray[n].getOperation() + iBuildEnvironmentVariableArray[n].getDelimiter());
                    ++n;
                }
            } else {
                System.out.println(String.valueOf(string) + ": array is empty");
            }
        } else {
            System.out.println(String.valueOf(string) + ": array is null");
        }
    }

    private boolean varListContainNames(IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray, IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray2) {
        if (iBuildEnvironmentVariableArray == null) {
            return true;
        }
        if (iBuildEnvironmentVariableArray.length == 0) {
            return true;
        }
        if (iBuildEnvironmentVariableArray2 == null) {
            return false;
        }
        int n = 0;
        while (n < iBuildEnvironmentVariableArray.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < iBuildEnvironmentVariableArray2.length) {
                if (iBuildEnvironmentVariableArray[n].getName().equals(iBuildEnvironmentVariableArray2[n2].getName())) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void compareStringLists(String string, String[] stringArray, String[] stringArray2) {
        long l = 0L;
        long l2 = Math.round(Math.pow(2.0, stringArray2.length) - 1.0);
        int n = 0;
        while (n < stringArray.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (stringArray[n].equals(stringArray2[n2])) {
                    l |= (long)(1 << n2);
                    bl = true;
                    break;
                }
                ++n2;
            }
            Assert.assertTrue((boolean)bl);
            ++n;
        }
        Assert.assertEquals((long)l, (long)l2);
    }
}

