/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProjectManager;
import org.eclipse.cdt.managedbuilder.testplugin.CTestPlugin;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class ManagedProject21MakefileTests
extends TestCase {
    public static final String MBS_TEMP_DIR = "MBSTemp";
    static boolean pathVariableCreated = false;
    static /* synthetic */ Class class$0;

    public ManagedProject21MakefileTests(String string) {
        super(string);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.ManagedProject21MakefileTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new ManagedProject21MakefileTests("testSingleFileExe"));
        testSuite.addTest((Test)new ManagedProject21MakefileTests("testTwoFileSO"));
        testSuite.addTest((Test)new ManagedProject21MakefileTests("testMultiResConfig"));
        testSuite.addTest((Test)new ManagedProject21MakefileTests("testLinkedLib"));
        return testSuite;
    }

    private IProject[] createProject(String string, IPath iPath, String string2, boolean bl) {
        File file = CTestPlugin.getFileInPlugin((IPath)new Path("resources/test21Projects/" + string));
        if (file == null) {
            Assert.fail((String)("Test project directory " + file.getName() + " is missing."));
            return null;
        }
        ArrayList<IProject> arrayList = null;
        if (bl) {
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return !file.isDirectory();
                }
            });
            arrayList = new ArrayList<IProject>(fileArray.length);
            int n = 0;
            while (n < fileArray.length) {
                try {
                    IProject iProject;
                    String string3 = fileArray[n].getName();
                    if (string3.endsWith(".zip") && (string3 = string3.substring(0, string3.length() - ".zip".length())).length() != 0 && (iProject = ManagedBuildTestHelper.createProject(string3, fileArray[n], iPath, string2)) != null) {
                        arrayList.add(iProject);
                    }
                }
                catch (Exception exception) {}
                ++n;
            }
            if (arrayList.size() == 0) {
                Assert.fail((String)("No projects found in test project directory " + file.getName() + ".  The .zip file may be missing or corrupt."));
                return null;
            }
        } else {
            try {
                IProject iProject = ManagedBuildTestHelper.createProject(string, null, iPath, string2);
                if (iProject != null) {
                    arrayList = new ArrayList(1);
                }
                arrayList.add(iProject);
            }
            catch (Exception exception) {}
        }
        return arrayList.toArray(new IProject[arrayList.size()]);
    }

    private IProject[] createProjects(String string, IPath iPath, String string2, boolean bl) {
        IOverwriteQuery iOverwriteQuery = new IOverwriteQuery(){

            public String queryOverwrite(String string) {
                return "ALL";
            }
        };
        new IOverwriteQuery(){

            public String queryOverwrite(String string) {
                return "NOALL";
            }
        };
        UpdateManagedProjectManager.setBackupFileOverwriteQuery((IOverwriteQuery)iOverwriteQuery);
        UpdateManagedProjectManager.setUpdateProjectQuery((IOverwriteQuery)iOverwriteQuery);
        IProject[] iProjectArray = this.createProject(string, iPath, string2, bl);
        return iProjectArray;
    }

    private boolean buildProjects(IProject[] iProjectArray, IPath[] iPathArray) {
        if (iProjectArray == null || iProjectArray.length == 0) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
            boolean bl2 = UpdateManagedProjectManager.isCompatibleProject((IManagedBuildInfo)iManagedBuildInfo);
            Assert.assertTrue((boolean)bl2);
            if (bl2) {
                try {
                    iProject.build(10, null);
                }
                catch (CoreException coreException) {
                    Assert.fail((String)coreException.getStatus().getMessage());
                }
                catch (OperationCanceledException operationCanceledException) {
                    Assert.fail((String)("the project \"" + iProject.getName() + "\" build was cancelled, exception message: " + operationCanceledException.getMessage()));
                }
                if (iPathArray != null && iPathArray.length > 0 && n == 0) {
                    String string = iManagedBuildInfo.getDefaultConfiguration().getName();
                    IPath iPath = Path.fromOSString((String)string);
                    bl = ManagedBuildTestHelper.compareBenchmarks(iProject, iPath, iPathArray);
                }
            }
            ++n;
        }
        if (bl) {
            n = 0;
            while (n < iProjectArray.length) {
                ManagedBuildTestHelper.removeProject(iProjectArray[n].getName());
                ++n;
            }
        }
        return bl;
    }

    private void createPathVariable(IPath iPath) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        iWorkspace = ResourcesPlugin.getWorkspace();
        IPathVariableManager iPathVariableManager = iWorkspace.getPathVariableManager();
        String string = MBS_TEMP_DIR;
        try {
            if (iPathVariableManager.validateName(string).isOK() && iPathVariableManager.validateValue(iPath).isOK()) {
                iPathVariableManager.setValue(string, iPath);
                Assert.assertTrue((boolean)iPathVariableManager.isDefined(string));
            } else {
                Assert.fail((String)("could not create the path variable " + string));
            }
        }
        catch (Exception exception) {
            Assert.fail((String)("could not create the path variable " + string));
        }
    }

    private void createFileLink(IProject iProject, IPath iPath, String string, String string2) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        String string3 = MBS_TEMP_DIR;
        if (!pathVariableCreated) {
            this.createPathVariable(iPath);
            pathVariableCreated = true;
        }
        try {
            IFile iFile = iProject.getFile(string);
            Path path = new Path("MBSTemp/" + string2);
            if (iWorkspace.validateLinkLocation((IResource)iFile, (IPath)path).isOK()) {
                iFile.createLink((IPath)path, 0, null);
            } else {
                Assert.fail((String)("could not create the link to " + string3));
            }
        }
        catch (Exception exception) {
            Assert.fail((String)("could not create the link to " + string3));
        }
    }

    public void testSingleFileExe() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        IProject[] iProjectArray = this.createProjects("singleFileExe", null, null, true);
        this.buildProjects(iProjectArray, iPathArray);
    }

    public void testTwoFileSO() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        IProject[] iProjectArray = this.createProjects("twoFileSO", null, null, true);
        this.buildProjects(iProjectArray, iPathArray);
    }

    public void testMultiResConfig() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"source1/subdir.mk"), Path.fromOSString((String)"source2/subdir.mk"), Path.fromOSString((String)"source2/source21/subdir.mk")};
        IProject[] iProjectArray = this.createProjects("multiResConfig", null, null, true);
        this.buildProjects(iProjectArray, iPathArray);
    }

    /*
     * Exception decompiling
     */
    public void testLinkedLib() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 204->208)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testLinkedFolder() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 227->231)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

