/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProjectManager;
import org.eclipse.cdt.managedbuilder.testplugin.CTestPlugin;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class MultiVersionSupportTests
extends TestCase {
    static IProject proj = null;
    static IManagedProject mproj = null;
    IConfiguration[] cfgs = null;
    private IWorkspace worksp;
    private boolean windows;
    static /* synthetic */ Class class$0;

    public MultiVersionSupportTests() {
    }

    public MultiVersionSupportTests(String string) {
        super(string);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.MultiVersionSupportTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new MultiVersionSupportTests("testProjectConverterConvenienceRoutines"));
        testSuite.addTest((Test)new MultiVersionSupportTests("testConfigurationNameProvider"));
        testSuite.addTest((Test)new MultiVersionSupportTests("testConfigurationDescription"));
        testSuite.addTest((Test)new MultiVersionSupportTests("testVersionInfo"));
        testSuite.addTest((Test)new MultiVersionSupportTests("testVersionsSupportedAttribute"));
        testSuite.addTest((Test)new MultiVersionSupportTests("testToolChainConversion_CDT20"));
        testSuite.addTest((Test)new MultiVersionSupportTests("testToolChainConversion_CDT21"));
        return testSuite;
    }

    public void testProjectConverterConvenienceRoutines() throws Exception {
        String string = "TestProjectConverterConvenienceRoutines";
        String string2 = "testProjectConverterConvenienceRoutines.exe";
        this.doInit(string, string2);
        Assert.assertEquals((int)this.cfgs.length, (int)1);
        IToolChain iToolChain = this.cfgs[0].getToolChain();
        boolean bl = ManagedBuildManager.hasTargetConversionElements((IBuildObject)iToolChain);
        Assert.assertEquals((boolean)bl, (boolean)true);
        Map map = ManagedBuildManager.getConversionElements((IBuildObject)iToolChain);
        Assert.assertEquals((int)map.size(), (int)1);
    }

    public void testConfigurationNameProvider() throws Exception {
        String[] stringArray = new String[]{"Debug", "Release", "Debug_ia64", "Release_ia64"};
        String[] stringArray2 = new String[4];
        String string = "TestConfigurationNameProvider";
        String string2 = "cdt.managedbuild.target.testMultipleVersions.exe";
        this.doInit(string, string2);
        this.cfgs = mproj.getConfigurations();
        int n = 0;
        while (n < this.cfgs.length) {
            stringArray2[n] = this.cfgs[n].getName();
            ++n;
        }
        n = 0;
        while (n < stringArray.length) {
            Assert.assertTrue((boolean)this.isArrayContains(stringArray2, stringArray[n]));
            ++n;
        }
    }

    public void testConfigurationDescription() throws Exception {
        String[] stringArray = new String[]{"debug configuration for IA32 windows", "release configuration for IA32 windows", "debug configuration for IA64 windows", "release configuration for IA64 windows"};
        String[] stringArray2 = new String[4];
        String string = "TestConfigurationDescription";
        String string2 = "cdt.managedbuild.target.testMultipleVersions.exe";
        this.doInit(string, string2);
        this.cfgs = mproj.getConfigurations();
        int n = 0;
        while (n < this.cfgs.length) {
            stringArray2[n] = this.cfgs[n].getDescription();
            ++n;
        }
        n = 0;
        while (n < stringArray.length) {
            Assert.assertTrue((boolean)this.isArrayContains(stringArray2, stringArray[n]));
            ++n;
        }
    }

    public void testVersionInfo() throws Exception {
        ITool iTool;
        String string = "TestVersionInfo";
        String string2 = "cdt.managedbuild.target.testMultipleVersions.exe";
        this.doInit(string, string2);
        this.cfgs = mproj.getConfigurations();
        IConfiguration iConfiguration = mproj.getConfiguration("cdt.managedbuild.config.testMultipleVersions.exe.release.1");
        Assert.assertEquals((String)iConfiguration.getToolChain().getVersion().toString(), (String)"0.0.4");
        ITool[] iToolArray = iConfiguration.getToolChain().getTools();
        int n = 0;
        while (n < iToolArray.length) {
            iTool = iToolArray[n];
            Assert.assertEquals((String)iTool.getVersion().toString(), (String)"0.0.4");
            ++n;
        }
        IBuilder iBuilder = iConfiguration.getToolChain().getBuilder();
        Assert.assertEquals((String)iBuilder.getVersion().toString(), (String)"0.0.4");
        iTool = mproj.getConfiguration("cdt.managedbuild.config.testMultipleVersions.exe.debug.0");
        Assert.assertEquals((String)iTool.getToolChain().getVersion().toString(), (String)"1.1.0");
        iToolArray = iTool.getToolChain().getTools();
        int n2 = 0;
        while (n2 < iToolArray.length) {
            ITool iTool2 = iToolArray[n2];
            Assert.assertEquals((String)iTool2.getVersion().toString(), (String)"1.1.0");
            ++n2;
        }
        iBuilder = iTool.getToolChain().getBuilder();
        Assert.assertEquals((String)iBuilder.getVersion().toString(), (String)"1.1.0");
        IConfiguration iConfiguration2 = mproj.getConfiguration("cdt.managedbuild.config.testMultipleVersions.exe.debug64.2");
        Assert.assertEquals((String)iConfiguration2.getToolChain().getVersion().toString(), (String)"2.2.0");
        iToolArray = iConfiguration2.getToolChain().getTools();
        int n3 = 0;
        while (n3 < iToolArray.length) {
            ITool iTool3 = iToolArray[n3];
            Assert.assertEquals((String)iTool3.getVersion().toString(), (String)"5.0.9");
            ++n3;
        }
        iBuilder = iConfiguration2.getToolChain().getBuilder();
        Assert.assertEquals((String)iBuilder.getVersion().toString(), (String)"3.2.1");
    }

    public void testVersionsSupportedAttribute() throws Exception {
        String string = "TestVersionSupportAttribute";
        String string2 = "cdt.managedbuild.target.testMultipleVersions.exe";
        this.doInit(string, string2);
        this.cfgs = mproj.getConfigurations();
        IConfiguration iConfiguration = mproj.getConfiguration("cdt.managedbuild.config.testMultipleVersions.exe.release64.3");
        IToolChain iToolChain = iConfiguration.getToolChain();
        String string3 = iToolChain.getVersionsSupported();
        Assert.assertEquals((String)string3, (String)"1.2.0,2.0.0,2.1.3");
        IBuilder iBuilder = iConfiguration.getToolChain().getBuilder();
        String string4 = iBuilder.getVersionsSupported();
        Assert.assertEquals((String)string4, (String)"2.0.0,2.1.1,3.0.3");
    }

    static void createManagedProject(String string, String string2) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        proj = iWorkspaceRoot.getProject(string);
        if (proj.exists()) {
            mproj = ManagedBuildManager.getBuildInfo((IResource)proj).getManagedProject();
        } else {
            ICDescriptor iCDescriptor;
            IProjectType iProjectType;
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription iWorkspaceDescription = iWorkspace.getDescription();
            iWorkspaceDescription.setAutoBuilding(false);
            try {
                iWorkspace.setDescription(iWorkspaceDescription);
                proj = CCorePlugin.getDefault().createCProject(iWorkspace.newProjectDescription(proj.getName()), proj, (IProgressMonitor)new NullProgressMonitor(), MakeCorePlugin.MAKE_PROJECT_ID);
                iProjectType = ManagedBuildManager.createBuildInfo((IResource)proj);
                iProjectType.setValid(true);
                ManagedCProjectNature.addManagedNature((IProject)proj, null);
                ManagedCProjectNature.addManagedBuilder((IProject)proj, null);
                iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(proj, true);
                iCDescriptor.remove("org.eclipse.cdt.core.ScannerInfoProvider");
                iCDescriptor.create("org.eclipse.cdt.core.ScannerInfoProvider", ManagedBuildManager.INTERFACE_IDENTITY);
                iCDescriptor.saveProjectData();
            }
            catch (CoreException coreException) {
                Assert.fail((String)("Cannot create project: " + coreException.getLocalizedMessage()));
            }
            ManagedBuildManager.getDefinedProjectTypes();
            iProjectType = ManagedBuildManager.getProjectType((String)string2);
            Assert.assertNotNull((Object)iProjectType);
            try {
                mproj = ManagedBuildManager.createManagedProject((IResource)proj, (IProjectType)iProjectType);
            }
            catch (BuildException buildException) {}
            ManagedBuildManager.setNewProjectVersion((IProject)proj);
            iCDescriptor = iProjectType.getConfigurations();
            int n = 0;
            while (n < ((ICDescriptor)iCDescriptor).length) {
                mproj.createConfiguration((IConfiguration)iCDescriptor[n], String.valueOf(iCDescriptor[n].getId()) + "." + n);
                ++n;
            }
            if (((ICDescriptor)iCDescriptor).length > 0) {
                ManagedBuildManager.setDefaultConfiguration((IProject)proj, (IConfiguration)iCDescriptor[0]);
            } else {
                ManagedBuildManager.setDefaultConfiguration((IProject)proj, null);
            }
        }
        try {
            proj.open(null);
        }
        catch (CoreException coreException) {}
    }

    private boolean isArrayContains(String[] stringArray, String string) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null && stringArray[n].equals(string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private void doInit(String string, String string2) {
        MultiVersionSupportTests.createManagedProject(string, string2);
        Assert.assertNotNull((Object)proj);
        Assert.assertNotNull((Object)mproj);
        this.worksp = proj.getWorkspace();
        Assert.assertNotNull((Object)this.worksp);
        this.cfgs = mproj.getConfigurations();
        Assert.assertNotNull((Object)this.cfgs);
    }

    public void testToolChainConversion_CDT20() throws Exception {
        this.doTestProjectUpdate("2.0", true);
        String string = System.getProperty("java.io.tmpdir");
        File file = new File(String.valueOf(string) + "/converterOutput20.txt");
        try {
            Assert.assertTrue((boolean)file.exists());
            String string2 = "Converter for CDT 2.0 Project is invoked";
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string3 = bufferedReader.readLine();
            if (string3 != null) {
                Assert.assertEquals((String)string3, (String)string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void testToolChainConversion_CDT21() throws Exception {
        this.doTestProjectUpdate("2.1", true);
        String string = System.getProperty("java.io.tmpdir");
        File file = new File(String.valueOf(string) + "/converterOutput21.txt");
        try {
            Assert.assertTrue((boolean)file.exists());
            String string2 = "Converter for CDT 2.1 Project is invoked";
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string3 = bufferedReader.readLine();
            if (string3 != null) {
                Assert.assertEquals((String)string3, (String)string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private IProject getCDT_TestProject(String string) {
        IProject iProject = null;
        File file = null;
        if (string.equalsIgnoreCase("2.0")) {
            file = CTestPlugin.getFileInPlugin((IPath)new Path("resources/toolChainConversionProjects/test20"));
        } else if (string.equals("2.1")) {
            file = CTestPlugin.getFileInPlugin((IPath)new Path("resources/toolChainConversionProjects/test21"));
        }
        if (file == null) {
            Assert.fail((String)("Test project directory " + file.getName() + " is missing."));
            return null;
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return !file.isDirectory();
            }
        });
        ArrayList<IProject> arrayList = new ArrayList<IProject>(fileArray.length);
        Assert.assertEquals((int)fileArray.length, (int)1);
        try {
            String string2 = fileArray[0].getName();
            if (!string2.endsWith(".zip")) {
                Assert.fail((String)("No projects found in test 'toolChainConversionProjects' project directory " + file.getName() + ".  The .zip file may be missing or corrupt."));
            }
            if ((string2 = string2.substring(0, string2.length() - ".zip".length())).length() == 0) {
                Assert.fail((String)("No projects found in test 'toolChainConversionProjects' project directory " + file.getName() + ".  The .zip file may be missing or corrupt."));
            }
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            new Path(iWorkspaceRoot.getLocation().toString());
            iProject = ManagedBuildTestHelper.createProject(string2, fileArray[0], null, null);
            if (iProject != null) {
                arrayList.add(iProject);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception Occured.");
        }
        if (arrayList.size() == 0) {
            Assert.fail((String)("No projects found in test project directory " + file.getName() + ".  The .zip file may be missing or corrupt."));
            return null;
        }
        return iProject;
    }

    private void doTestProjectUpdate(String string, boolean bl) {
        IOverwriteQuery iOverwriteQuery = new IOverwriteQuery(){

            public String queryOverwrite(String string) {
                return "ALL";
            }
        };
        IOverwriteQuery iOverwriteQuery2 = new IOverwriteQuery(){

            public String queryOverwrite(String string) {
                return "NOALL";
            }
        };
        UpdateManagedProjectManager.setUpdateProjectQuery((IOverwriteQuery)(bl ? iOverwriteQuery : iOverwriteQuery2));
        IProject iProject = this.getCDT_TestProject(string);
        if (iProject == null) {
            return;
        }
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        boolean bl2 = UpdateManagedProjectManager.isCompatibleProject((IManagedBuildInfo)iManagedBuildInfo);
        Assert.assertTrue((boolean)bl2);
        if (bl2 && bl && (iManagedBuildInfo == null || iManagedBuildInfo.getManagedProject() == null || !iManagedBuildInfo.getManagedProject().isValid())) {
            Assert.fail((String)("the project \"" + iProject.getName() + "\" was not properly converted"));
        }
        ManagedBuildTestHelper.removeProject(iProject.getName());
    }
}

