/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class RegressionTest {
    PrintStream output;
    String oldFilename;
    String newFilename;
    String outFilename;
    public static final String NOTHING_CHANGED_MSG = "All tests unchanged.";

    public RegressionTest(String string, String string2, String string3) {
        this.oldFilename = string;
        this.newFilename = string2;
        this.outFilename = string3;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            System.err.println("Error: too few arguments");
            System.err.println("Usage: (progname) oldfile newfile outfile");
        } else {
            RegressionTest regressionTest = new RegressionTest(stringArray[0], stringArray[1], stringArray[2]);
            regressionTest.testRegressions();
        }
    }

    public void testRegressions() {
        String string = "";
        String string2 = "";
        try {
            string = RegressionTest.readFile(this.oldFilename);
            string2 = RegressionTest.readFile(this.newFilename);
        }
        catch (Exception exception) {
            System.err.println("Error opening input file");
            System.err.println(exception.getMessage());
            System.exit(-1);
        }
        try {
            this.output = new PrintStream(new BufferedOutputStream(new FileOutputStream(new File(this.outFilename))));
        }
        catch (Exception exception) {
            System.err.println("Error opening output file");
            System.err.println(exception.getMessage());
            System.exit(-1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
        String[] stringArray = RegressionTest.nextTest(stringTokenizer);
        String[] stringArray2 = RegressionTest.nextTest(stringTokenizer2);
        boolean bl = true;
        while (stringArray != null && stringArray2 != null) {
            int n = stringArray[0].compareTo(stringArray2[0]);
            if (n == 0) {
                int n2 = stringArray[1].compareTo(stringArray2[1]);
                if (n2 != 0) {
                    bl = false;
                    this.output.println(RegressionTest.testChanged(stringArray2));
                }
                stringArray = RegressionTest.nextTest(stringTokenizer);
                stringArray2 = RegressionTest.nextTest(stringTokenizer2);
                continue;
            }
            if (n < 0) {
                this.output.println(RegressionTest.testNotRun(stringArray));
                stringArray = RegressionTest.nextTest(stringTokenizer);
                bl = false;
                continue;
            }
            this.output.println(RegressionTest.testAdded(stringArray2));
            stringArray2 = RegressionTest.nextTest(stringTokenizer2);
            bl = false;
        }
        while (stringArray != null) {
            this.output.println(RegressionTest.testNotRun(stringArray));
            stringArray = RegressionTest.nextTest(stringTokenizer);
            bl = false;
        }
        while (stringArray2 != null) {
            this.output.println(RegressionTest.testAdded(stringArray2));
            stringArray2 = RegressionTest.nextTest(stringTokenizer2);
            bl = false;
        }
        if (bl) {
            this.output.println(NOTHING_CHANGED_MSG);
        }
        this.output.close();
    }

    static String testNotRun(String[] stringArray) {
        return "Not run: " + stringArray[0];
    }

    static String testChanged(String[] stringArray) {
        return "Changed: " + stringArray[0] + ", " + stringArray[1];
    }

    static String testAdded(String[] stringArray) {
        return "New test: " + stringArray[0] + ", Status: " + stringArray[1];
    }

    static String readFile(String string) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        FileInputStream fileInputStream = new FileInputStream(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = fileInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        return byteArrayOutputStream.toString();
    }

    static String[] nextTest(StringTokenizer stringTokenizer) {
        String[] stringArray = new String[2];
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        stringArray[0] = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        stringArray[1] = stringTokenizer.nextToken();
        return stringArray;
    }
}

