/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.io.IOException;
import junit.framework.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.test.EclipseTestRunner;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.testing.ITestHarness;
import org.eclipse.ui.testing.TestableObject;

public class UITestApplication
implements IPlatformRunnable,
ITestHarness {
    private static final String DEFAULT_APP_3_0 = "org.eclipse.ui.ide.workbench";
    private static final String DEFAULT_APP_PRE_3_0 = "org.eclipse.ui.workbench";
    private boolean fInDeprecatedMode = false;
    private TestableObject fTestableObject;
    private int fTestRunnerResult = -1;

    public Object run(Object object) throws Exception {
        IPlatformRunnable iPlatformRunnable = this.getApplication((String[])object);
        Assert.assertNotNull((Object)iPlatformRunnable);
        Object object2 = this.fInDeprecatedMode ? this.runDeprecatedApplication(iPlatformRunnable, object) : this.runApplication(iPlatformRunnable, object);
        if (!IPlatformRunnable.EXIT_OK.equals(object2)) {
            System.err.println("UITestRunner: Unexpected result from running application " + iPlatformRunnable + ": " + object2);
        }
        return new Integer(this.fTestRunnerResult);
    }

    private IPlatformRunnable getApplication(String[] stringArray) throws CoreException {
        Object object;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension iExtension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.runtime", "applications", this.getApplicationToRun(stringArray));
        if (iExtension == null) {
            iExtension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.runtime", "applications", DEFAULT_APP_PRE_3_0);
            this.fInDeprecatedMode = true;
        }
        Assert.assertNotNull((Object)iExtension);
        IConfigurationElement[] iConfigurationElementArray2 = iExtension.getConfigurationElements();
        if (iConfigurationElementArray2.length > 0 && (iConfigurationElementArray = iConfigurationElementArray2[0].getChildren("run")).length > 0 && (object = iConfigurationElementArray[0].createExecutableExtension("class")) instanceof IPlatformRunnable) {
            return (IPlatformRunnable)object;
        }
        return null;
    }

    private String getApplicationToRun(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-testApplication") && n < stringArray.length - 1) {
                return stringArray[n + 1];
            }
            ++n;
        }
        return DEFAULT_APP_3_0;
    }

    private Object runApplication(IPlatformRunnable iPlatformRunnable, Object object) throws Exception {
        this.fTestableObject = PlatformUI.getTestableObject();
        this.fTestableObject.setTestHarness((ITestHarness)this);
        return iPlatformRunnable.run(object);
    }

    private Object runDeprecatedApplication(IPlatformRunnable iPlatformRunnable, final Object object) throws Exception {
        Assert.assertTrue((boolean)(iPlatformRunnable instanceof IWorkbench));
        final IWorkbench iWorkbench = (IWorkbench)iPlatformRunnable;
        final boolean[] blArray = new boolean[1];
        iWorkbench.addWindowListener(new IWindowListener(){

            public void windowOpened(IWorkbenchWindow iWorkbenchWindow) {
                if (blArray[0]) {
                    return;
                }
                iWorkbenchWindow.getShell().getDisplay().asyncExec(new Runnable(this, blArray, object, iWorkbench){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ boolean[] val$started;
                    private final /* synthetic */ Object val$args;
                    private final /* synthetic */ IWorkbench val$workbench;
                    {
                        this.this$1 = var1_1;
                        this.val$started = blArray;
                        this.val$args = object;
                        this.val$workbench = iWorkbench;
                    }

                    public void run() {
                        this.val$started[0] = true;
                        try {
                            UITestApplication.access$0(1.access$0(this.this$1), EclipseTestRunner.run((String[])this.val$args));
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        this.val$workbench.close();
                    }
                });
            }

            public void windowActivated(IWorkbenchWindow iWorkbenchWindow) {
            }

            public void windowDeactivated(IWorkbenchWindow iWorkbenchWindow) {
            }

            public void windowClosed(IWorkbenchWindow iWorkbenchWindow) {
            }

            static /* synthetic */ UITestApplication access$0(1 var0) {
                return var0.UITestApplication.this;
            }
        });
        return ((IPlatformRunnable)iWorkbench).run(object);
    }

    public void runTests() {
        this.fTestableObject.testingStarting();
        this.fTestableObject.runTest(new Runnable(){

            public void run() {
                try {
                    UITestApplication.this.fTestRunnerResult = EclipseTestRunner.run(Platform.getCommandLineArgs());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
        this.fTestableObject.testingFinished();
    }
}

