/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.refactoring.tests;

import java.io.StringWriter;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.refactoring.tests.RefactoringTests;
import org.eclipse.cdt.refactoring.tests.RenameTests;
import org.eclipse.core.resources.IFile;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RenameTypeTests
extends RenameTests {
    static /* synthetic */ Class class$0;

    public RenameTypeTests(String string) {
        super(string);
    }

    public static Test suite() {
        return RenameTypeTests.suite(true);
    }

    public static Test suite(boolean bl) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.refactoring.tests.RenameTypeTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite((Class)clazz);
        if (bl) {
            testSuite.addTest((Test)new RefactoringTests("cleanupProject"));
        }
        return testSuite;
    }

    public void testClassNameConflicts() throws Exception {
        this.createCppFwdDecls("cpp_fwd.hh");
        this.createCppDefs("cpp_def.hh");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"cpp_fwd.hh\"   \n");
        stringWriter.write("#include \"cpp_def.hh\"   \n");
        stringWriter.write("class v1 {                \n");
        stringWriter.write(" int v;                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("class v2 {                \n");
        stringWriter.write(" int v;                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("class v3 {                \n");
        stringWriter.write(" int v;                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("class v4 {                \n");
        stringWriter.write(" int function();          \n");
        stringWriter.write("};                        \n");
        stringWriter.write("int v4::function(){}      \n");
        stringWriter.write("void f(int par1){         \n");
        stringWriter.write("  {                       \n");
        stringWriter.write("     int w1; v1::v++;    \n");
        stringWriter.write("  }                       \n");
        stringWriter.write("}                         \n");
        stringWriter.write("void class_def::method(int par2) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w2; v2::v++;     \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        stringWriter.write("static void class_def::static_method(int par3) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w3; v3::v++;     \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("v1");
        int n2 = string.indexOf("v2");
        int n3 = string.indexOf("v3");
        int n4 = string.indexOf("v4");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, string.indexOf("par1"), "v1");
        this.assertRefactoringError(refactoringStatus, "'v1' will shadow a constructor.");
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "w2");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "par2");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "w3");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "par3");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n2, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n3, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n4, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "un_member");
        this.assertRefactoringOk(refactoringStatus);
    }

    public void testNamespaceNameConflicts() throws Exception {
        this.createCppFwdDecls("cpp_fwd.hh");
        this.createCppDefs("cpp_def.hh");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"cpp_fwd.hh\"   \n");
        stringWriter.write("#include \"cpp_def.hh\"   \n");
        stringWriter.write("namespace v4 {            \n");
        stringWriter.write(" int function();          \n");
        stringWriter.write("};                        \n");
        stringWriter.write("namespace v1 {            \n");
        stringWriter.write(" int v;                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("namespace v2 {            \n");
        stringWriter.write(" int v;                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("namespace v3 {            \n");
        stringWriter.write(" int v;                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("int v4::function(){}      \n");
        stringWriter.write("void f(int par1){         \n");
        stringWriter.write("  {                       \n");
        stringWriter.write("     int w1; v1::v++;    \n");
        stringWriter.write("  }                       \n");
        stringWriter.write("}                         \n");
        stringWriter.write("void class_def::method(int par2) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w2; v2::v++;     \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        stringWriter.write("static void class_def::static_method(int par3) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w3; v3::v++;     \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("v1");
        int n2 = string.indexOf("v2");
        int n3 = string.indexOf("v3");
        int n4 = string.indexOf("v4");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, string.indexOf("par1"), "v1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "w2");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "par2");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "w3");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "par3");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n2, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n3, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n4, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "un_member");
        this.assertRefactoringOk(refactoringStatus);
    }

    public void testStructNameConflicts() throws Exception {
        this.createCppFwdDecls("cpp_fwd.hh");
        this.createCppDefs("cpp_def.hh");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"cpp_fwd.hh\"   \n");
        stringWriter.write("#include \"cpp_def.hh\"   \n");
        stringWriter.write("struct v4 {               \n");
        stringWriter.write(" int function();          \n");
        stringWriter.write("};                        \n");
        stringWriter.write("struct v1 {               \n");
        stringWriter.write(" int v;                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("struct v2 {               \n");
        stringWriter.write(" int v;                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("struct v3 {               \n");
        stringWriter.write(" int v;                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("int v4::function(){}      \n");
        stringWriter.write("void f(int par1){         \n");
        stringWriter.write("  {                       \n");
        stringWriter.write("     int w1; v1::v++;    \n");
        stringWriter.write("  }                       \n");
        stringWriter.write("}                         \n");
        stringWriter.write("void class_def::method(int par2) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w2; v2::v++;     \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        stringWriter.write("static void class_def::static_method(int par3) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w3; v3::v++;     \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("v1");
        int n2 = string.indexOf("v2");
        int n3 = string.indexOf("v3");
        int n4 = string.indexOf("v4");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, string.indexOf("par1"), "v1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "w2");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "par2");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "w3");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "par3");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n2, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n3, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n4, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "un_member");
        this.assertRefactoringOk(refactoringStatus);
    }

    public void testStructNameConflictsPlainC() throws Exception {
        this.createCFwdDecls("c_fwd.h");
        this.createCDefs("c_def.h");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"c_fwd.h\"   \n");
        stringWriter.write("#include \"c_def.h\"   \n");
        stringWriter.write("struct v1 {               \n");
        stringWriter.write(" int v;                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("struct v2 {               \n");
        stringWriter.write(" int v;                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("struct v3 {               \n");
        stringWriter.write(" int v;                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("void f(int par1){         \n");
        stringWriter.write("  {                       \n");
        stringWriter.write("     int w1; v1::v++;    \n");
        stringWriter.write("  }                       \n");
        stringWriter.write("}                         \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("v1");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, string.indexOf("par1"), "v1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "un_member");
        this.assertRefactoringOk(refactoringStatus);
    }

    public void testUnionNameConflicts() throws Exception {
        this.createCppFwdDecls("cpp_fwd.hh");
        this.createCppDefs("cpp_def.hh");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"cpp_fwd.hh\"   \n");
        stringWriter.write("#include \"cpp_def.hh\"   \n");
        stringWriter.write("union v4 {                \n");
        stringWriter.write(" int function();          \n");
        stringWriter.write("};                        \n");
        stringWriter.write("union v1 {                \n");
        stringWriter.write(" int v;                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("union v2 {                \n");
        stringWriter.write(" int v;                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("union v3 {                \n");
        stringWriter.write(" int v;                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("int v4::function(){}      \n");
        stringWriter.write("void f(int par1){         \n");
        stringWriter.write("  {                       \n");
        stringWriter.write("     int w1; v1::v++;    \n");
        stringWriter.write("  }                       \n");
        stringWriter.write("}                         \n");
        stringWriter.write("void class_def::method(int par2) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w2; v2::v++;     \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        stringWriter.write("static void class_def::static_method(int par3) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w3; v3::v++;     \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("v1");
        int n2 = string.indexOf("v2");
        int n3 = string.indexOf("v3");
        int n4 = string.indexOf("v4");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, string.indexOf("par1"), "v1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "w2");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "par2");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "w3");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "par3");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n2, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n3, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n4, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "un_member");
        this.assertRefactoringOk(refactoringStatus);
    }

    public void testUnionNameConflictsPlainC() throws Exception {
        this.createCppFwdDecls("c_fwd.h");
        this.createCppDefs("c_def.h");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"c_fwd.h\"   \n");
        stringWriter.write("#include \"c_def.h\"   \n");
        stringWriter.write("union v1 {                \n");
        stringWriter.write(" int v;                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("void f(int par1){         \n");
        stringWriter.write("     int w1; v1::v++;    \n");
        stringWriter.write("}                         \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.c", string);
        int n = string.indexOf("v1");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, string.indexOf("par1"), "v1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "un_member");
        this.assertRefactoringOk(refactoringStatus);
    }

    public void testEnumNameConflicts() throws Exception {
        this.createCppFwdDecls("cpp_fwd.hh");
        this.createCppDefs("cpp_def.hh");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"cpp_fwd.hh\"   \n");
        stringWriter.write("#include \"cpp_def.hh\"   \n");
        stringWriter.write("enum v1 {                 \n");
        stringWriter.write("    v11                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("enum v2 {                 \n");
        stringWriter.write("    v22                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("enum v3 {                 \n");
        stringWriter.write("     v33                  \n");
        stringWriter.write("};                        \n");
        stringWriter.write("void f(int par1){         \n");
        stringWriter.write("     int w1; v1 v;        \n");
        stringWriter.write("}                         \n");
        stringWriter.write("void class_def::method(int par2) { \n");
        stringWriter.write("     int w2; v2 v;         \n");
        stringWriter.write("}                          \n");
        stringWriter.write("static void class_def::static_method(int par3) { \n");
        stringWriter.write("     int w3; v3 v;         \n");
        stringWriter.write("}                          \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("v1");
        int n2 = string.indexOf("v2");
        int n3 = string.indexOf("v3");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, string.indexOf("par1"), "v1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "w2");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "par2");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "w3");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "par3");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n2, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n3, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "un_member");
        this.assertRefactoringOk(refactoringStatus);
    }

    public void testEnumNameConflictsPlainC() throws Exception {
        this.createCppFwdDecls("c_fwd.h");
        this.createCppDefs("c_def.h");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"c_fwd.h\"   \n");
        stringWriter.write("#include \"c_def.h\"   \n");
        stringWriter.write("enum v1 {                 \n");
        stringWriter.write("    v11                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("enum v2 {                 \n");
        stringWriter.write("    v22                   \n");
        stringWriter.write("};                        \n");
        stringWriter.write("enum v3 {                 \n");
        stringWriter.write("     v33                  \n");
        stringWriter.write("};                        \n");
        stringWriter.write("void f(int par1){         \n");
        stringWriter.write("     int w1; enum v1 v;   \n");
        stringWriter.write("}                         \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.c", string);
        int n = string.indexOf("v1");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, string.indexOf("par1"), "v1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "un_member");
        this.assertRefactoringOk(refactoringStatus);
    }

    public void testTypedefNameConflicts() throws Exception {
        this.createCppFwdDecls("cpp_fwd.hh");
        this.createCppDefs("cpp_def.hh");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"cpp_fwd.hh\"   \n");
        stringWriter.write("#include \"cpp_def.hh\"   \n");
        stringWriter.write("typedef int v1;           \n");
        stringWriter.write("typedef long v2;          \n");
        stringWriter.write("typedef struct {int a;} v3; \n");
        stringWriter.write("void f(int par1){         \n");
        stringWriter.write("     int w1; v1 v;        \n");
        stringWriter.write("}                         \n");
        stringWriter.write("void class_def::method(int par2) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w2; v2 v;         \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        stringWriter.write("static void class_def::static_method(int par3) { \n");
        stringWriter.write("  {                        \n");
        stringWriter.write("     int w3; v3 v;         \n");
        stringWriter.write("  }                        \n");
        stringWriter.write("}                          \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("v1");
        int n2 = string.indexOf("v2");
        int n3 = string.indexOf("v3");
        int n4 = string.indexOf("v4");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, string.indexOf("par1"), "v1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "w2");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "par2");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "w3");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "par3");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n2, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n2, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n2, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n3, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n3, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n3, "un_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "class_fwd");
        this.assertRefactoringError(refactoringStatus, "'class_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "class_def");
        this.assertRefactoringError(refactoringStatus, "'class_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n4, "namespace_def");
        this.assertRefactoringWarning(refactoringStatus, "'namespace_def' will redeclare a namespace.");
        refactoringStatus = this.checkConditions(iFile, n4, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n4, "un_member");
        this.assertRefactoringOk(refactoringStatus);
    }

    public void testTypedefNameConflictsPlainC() throws Exception {
        this.createCFwdDecls("c_fwd.h");
        this.createCDefs("c_def.h");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#include \"c_fwd.h\"   \n");
        stringWriter.write("#include \"c_def.h\"   \n");
        stringWriter.write("typedef int v1;           \n");
        stringWriter.write("typedef long v2;          \n");
        stringWriter.write("typedef struct {int a;} v3; \n");
        stringWriter.write("void f(int par1){         \n");
        stringWriter.write("     int w1; v1 v;        \n");
        stringWriter.write("}                         \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.c", string);
        int n = string.indexOf("v1");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "w1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, string.indexOf("par1"), "v1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "par1");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "extern_var");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "var_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "enum_item");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "static_method");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_proto_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "func_def_ov");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "struct_fwd");
        this.assertRefactoringError(refactoringStatus, "'struct_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_fwd");
        this.assertRefactoringError(refactoringStatus, "'union_fwd' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "struct_def");
        this.assertRefactoringError(refactoringStatus, "'struct_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "union_def");
        this.assertRefactoringError(refactoringStatus, "'union_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "enum_def");
        this.assertRefactoringError(refactoringStatus, "'enum_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "typedef_def");
        this.assertRefactoringError(refactoringStatus, "'typedef_def' will redeclare a type.");
        refactoringStatus = this.checkConditions(iFile, n, "st_member");
        this.assertRefactoringOk(refactoringStatus);
        refactoringStatus = this.checkConditions(iFile, n, "un_member");
        this.assertRefactoringOk(refactoringStatus);
    }

    public void testRenameClass() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class String              \n");
        stringWriter.write("{                         \n");
        stringWriter.write("public:                   \n");
        stringWriter.write("  String();               \n");
        stringWriter.write("  String(const String &other); \n");
        stringWriter.write("  ~String();                   \n");
        stringWriter.write("  String &operator=( const String &other ); \n");
        stringWriter.write("};                        \n");
        stringWriter.write("  String::String(){}      \n");
        stringWriter.write("  String::String(const String &other){}; \n");
        stringWriter.write("  String::~String(){};                   \n");
        stringWriter.write("  String& String::operator=( const String &other ) \n");
        stringWriter.write("     {return *this;}                        \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("String");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "CString");
        this.assertRefactoringOk(refactoringStatus);
        Change change = this.getRefactorChanges(iFile, n, "CString");
        this.assertTotalChanges(this.countOccurrences(string, "String"), change);
    }

    public void testBug72888() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class MyEx {};            \n");
        stringWriter.write("void someFunc() {         \n");
        stringWriter.write("  throw MyEx();          \n");
        stringWriter.write("};                        \n");
        stringWriter.write("int main(){               \n");
        stringWriter.write("   try{                   \n");
        stringWriter.write("      someFunc();         \n");
        stringWriter.write("   } catch(MyEx &e) {}    \n");
        stringWriter.write("   return 0;              \n");
        stringWriter.write("}                         \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("test.cpp", string);
        int n = string.indexOf("MyEx");
        Change change = this.getRefactorChanges(iFile, n, "xx");
        this.assertTotalChanges(3, change);
    }
}

