/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.tests;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.core.testplugin.CTestPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public abstract class IntegratedCModelTest
extends TestCase {
    private ICProject fCProject;
    private IFile sourceFile;
    private NullProgressMonitor monitor;
    private boolean structuralParse = false;

    public IntegratedCModelTest() {
    }

    public IntegratedCModelTest(String string) {
        super(string);
    }

    public abstract String getSourcefileSubdir();

    public abstract String getSourcefileResource();

    public void setUp() throws Exception {
        this.monitor = new NullProgressMonitor();
        this.fCProject = CProjectHelper.createCCProject("TestProject1", "bin");
        this.sourceFile = this.fCProject.getProject().getFile(this.getSourcefileResource());
        if (!this.sourceFile.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path(String.valueOf(this.getSourcefileSubdir()) + this.getSourcefileResource())));
                this.sourceFile.create((InputStream)fileInputStream, false, (IProgressMonitor)this.monitor);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }

    protected void tearDown() {
        CProjectHelper.delete(this.fCProject);
    }

    protected ITranslationUnit getTU() {
        ITranslationUnit iTranslationUnit = (ITranslationUnit)CoreModel.getDefault().create(this.sourceFile);
        if (this.isStructuralParse()) {
            CCorePlugin.getDefault().setStructuralParseMode(true);
        } else {
            CCorePlugin.getDefault().setStructuralParseMode(false);
        }
        iTranslationUnit.parse();
        CCorePlugin.getDefault().setStructuralParseMode(false);
        return iTranslationUnit;
    }

    public boolean isStructuralParse() {
        return this.structuralParse;
    }

    public void setStructuralParse(boolean bl) {
        this.structuralParse = bl;
    }
}

