/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayPool;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;

public class CharArrayUtilsTest
extends TestCase {
    public void testPoolAdd() {
        CharArrayPool charArrayPool = new CharArrayPool(1);
        char[] cArray = new char[]{'h', 'e', 'l', 'l', 'o'};
        char[] cArray2 = charArrayPool.add(cArray);
        Assert.assertTrue((boolean)CharArrayUtils.equals((char[])cArray, (char[])cArray2));
        Assert.assertNotSame((Object)cArray, (Object)cArray2);
        char[] cArray3 = charArrayPool.add(cArray);
        Assert.assertSame((Object)cArray2, (Object)cArray3);
        char[] cArray4 = new char[]{'w', 'o', 'r', 'l', 'd'};
        char[] cArray5 = charArrayPool.add(cArray4, 0, cArray4.length);
        Assert.assertTrue((boolean)CharArrayUtils.equals((char[])cArray4, (char[])cArray5));
        Assert.assertNotSame((Object)cArray4, (Object)cArray5);
        char[] cArray6 = charArrayPool.add(cArray4);
        Assert.assertSame((Object)cArray5, (Object)cArray6);
        char[] cArray7 = charArrayPool.add(cArray, 0, cArray.length);
        Assert.assertTrue((boolean)CharArrayUtils.equals((char[])cArray, (char[])cArray7));
        Assert.assertNotSame((Object)cArray, (Object)cArray7);
        char[] cArray8 = charArrayPool.add(cArray);
        Assert.assertSame((Object)cArray7, (Object)cArray8);
    }

    public void testPoolConflict() {
        CharArrayPool charArrayPool = new CharArrayPool(2);
        char[] cArray = new char[]{'h', 'e', 'l', 'l', 'o'};
        char[] cArray2 = charArrayPool.add(cArray);
        char[] cArray3 = new char[]{'h', 'o', 'l', 'l', 'e'};
        char[] cArray4 = charArrayPool.add(cArray3);
        Assert.assertNotSame((Object)cArray2, (Object)cArray4);
        char[] cArray5 = charArrayPool.add(cArray);
        Assert.assertTrue((boolean)CharArrayUtils.equals((char[])cArray, (char[])cArray5));
        char[] cArray6 = new char[]{'w', 'o', 'r', 'l', 'd'};
        char[] cArray7 = charArrayPool.add(cArray6);
        Assert.assertTrue((boolean)CharArrayUtils.equals((char[])cArray6, (char[])cArray7));
        char[] cArray8 = charArrayPool.add(cArray3);
        Assert.assertSame((Object)cArray4, (Object)cArray8);
        char[] cArray9 = charArrayPool.add(cArray);
        Assert.assertNotSame((Object)cArray2, (Object)cArray9);
        char[] cArray10 = charArrayPool.add(cArray6);
        Assert.assertSame((Object)cArray7, (Object)cArray10);
    }

    public void testMapAdd() {
        CharArrayObjectMap charArrayObjectMap = new CharArrayObjectMap(4);
        char[] cArray = "key1".toCharArray();
        Integer n = new Integer(43);
        charArrayObjectMap.put(cArray, (Object)n);
        char[] cArray2 = "key1".toCharArray();
        Object object = charArrayObjectMap.get(cArray2);
        Assert.assertEquals((Object)n, (Object)object);
        int n2 = 0;
        while (n2 < 5) {
            charArrayObjectMap.put(("ikey" + n2).toCharArray(), (Object)new Integer(n2));
            ++n2;
        }
        Object object2 = charArrayObjectMap.get("ikey1".toCharArray());
        Assert.assertEquals((Object)object2, (Object)new Integer(1));
        Object object3 = charArrayObjectMap.get("ikey4".toCharArray());
        Assert.assertEquals((Object)object3, (Object)new Integer(4));
    }
}

