/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import junit.framework.Assert;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTBaseSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IASTTemplateSpecialization;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.tests.CompleteParseBaseTest;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class CompleteParseASTTemplateTest
extends CompleteParseBaseTest {
    public CompleteParseASTTemplateTest(String string) {
        super(string);
    }

    public void testTemplateClassDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < class T > class A {  T t;  }; ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        Iterator iterator2 = iASTTemplateDeclaration.getTemplateParameters();
        IASTTemplateParameter iASTTemplateParameter = (IASTTemplateParameter)iterator2.next();
        Assert.assertEquals((String)iASTTemplateParameter.getIdentifier(), (String)"T");
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.getDeclarations((IASTScope)iASTTemplateDeclaration);
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertEquals((String)iASTClassSpecifier.getName(), (String)"A");
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTField iASTField = (IASTField)iterator.next();
        Assert.assertEquals((String)iASTField.getName(), (String)"t");
        IASTSimpleTypeSpecifier iASTSimpleTypeSpecifier = (IASTSimpleTypeSpecifier)iASTField.getAbstractDeclaration().getTypeSpecifier();
        Assert.assertEquals((String)iASTSimpleTypeSpecifier.getTypename(), (String)"T");
    }

    public void testTemplateFunction() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < class T > void f( T t ){} ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        Iterator iterator2 = iASTTemplateDeclaration.getTemplateParameters();
        IASTTemplateParameter iASTTemplateParameter = (IASTTemplateParameter)iterator2.next();
        Assert.assertEquals((String)iASTTemplateParameter.getIdentifier(), (String)"T");
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.getDeclarations((IASTScope)iASTTemplateDeclaration);
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"f");
        iterator2 = iASTFunction.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"t");
        IASTSimpleTypeSpecifier iASTSimpleTypeSpecifier = (IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier();
        Assert.assertEquals((String)iASTSimpleTypeSpecifier.getTypename(), (String)"T");
    }

    public void testTemplateFunctionDefinition() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <class T> void f( T t );");
        ((Writer)stringWriter).write("template <class U> void f( U u ) { }");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        Iterator iterator2 = iASTTemplateDeclaration.getTemplateParameters();
        IASTTemplateParameter iASTTemplateParameter = (IASTTemplateParameter)iterator2.next();
        Assert.assertEquals((String)iASTTemplateParameter.getIdentifier(), (String)"T");
        Assert.assertFalse((boolean)iterator2.hasNext());
        Iterator iterator3 = this.getDeclarations((IASTScope)iASTTemplateDeclaration);
        IASTFunction iASTFunction = (IASTFunction)iterator3.next();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"f");
        Assert.assertFalse((boolean)iASTFunction.hasFunctionBody());
        Assert.assertFalse((boolean)iterator3.hasNext());
        iterator2 = iASTFunction.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"t");
        IASTSimpleTypeSpecifier iASTSimpleTypeSpecifier = (IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier();
        Assert.assertEquals((String)iASTSimpleTypeSpecifier.getTypename(), (String)"T");
        IASTTemplateDeclaration iASTTemplateDeclaration2 = (IASTTemplateDeclaration)iterator.next();
        iterator2 = iASTTemplateDeclaration2.getTemplateParameters();
        IASTTemplateParameter iASTTemplateParameter2 = (IASTTemplateParameter)iterator2.next();
        Assert.assertEquals((String)iASTTemplateParameter2.getIdentifier(), (String)"U");
        Assert.assertFalse((boolean)iterator2.hasNext());
        iterator3 = this.getDeclarations((IASTScope)iASTTemplateDeclaration2);
        IASTFunction iASTFunction2 = (IASTFunction)iterator3.next();
        Assert.assertEquals((String)iASTFunction2.getName(), (String)"f");
        Assert.assertTrue((boolean)iASTFunction2.previouslyDeclared());
        iterator2 = iASTFunction2.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration2 = (IASTParameterDeclaration)iterator2.next();
        Assert.assertEquals((String)iASTParameterDeclaration2.getName(), (String)"u");
        iASTSimpleTypeSpecifier = (IASTSimpleTypeSpecifier)iASTParameterDeclaration2.getTypeSpecifier();
        Assert.assertEquals((String)iASTSimpleTypeSpecifier.getTypename(), (String)"U");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testClassMemberTemplate() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N { ");
        ((Writer)stringWriter).write("   class A { ");
        ((Writer)stringWriter).write("      template < class T > T f();");
        ((Writer)stringWriter).write("   }; ");
        ((Writer)stringWriter).write("}");
        ((Writer)stringWriter).write("template <class U> U N::A::f() {} ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTNamespaceDefinition);
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator2.next()).getTypeSpecifier();
        Assert.assertFalse((boolean)iterator2.hasNext());
        iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator2.next();
        Iterator iterator3 = iASTTemplateDeclaration.getTemplateParameters();
        IASTTemplateParameter cfr_ignored_0 = (IASTTemplateParameter)iterator3.next();
        Assert.assertFalse((boolean)iterator3.hasNext());
        Assert.assertFalse((boolean)iterator2.hasNext());
        iterator2 = this.getDeclarations((IASTScope)iASTTemplateDeclaration);
        IASTMethod iASTMethod = (IASTMethod)iterator2.next();
        Assert.assertEquals((String)((IASTSimpleTypeSpecifier)iASTMethod.getReturnType().getTypeSpecifier()).getTypename(), (String)"T");
        Assert.assertFalse((boolean)iterator2.hasNext());
        IASTTemplateDeclaration iASTTemplateDeclaration2 = (IASTTemplateDeclaration)iterator.next();
        iterator3 = iASTTemplateDeclaration.getTemplateParameters();
        IASTTemplateParameter cfr_ignored_1 = (IASTTemplateParameter)iterator3.next();
        Assert.assertFalse((boolean)iterator3.hasNext());
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator2 = this.getDeclarations((IASTScope)iASTTemplateDeclaration2);
        IASTMethod iASTMethod2 = (IASTMethod)iterator2.next();
        Assert.assertEquals((String)((IASTSimpleTypeSpecifier)iASTMethod2.getReturnType().getTypeSpecifier()).getTypename(), (String)"U");
        this.assertQualifiedName(iASTMethod2.getFullyQualifiedName(), new String[]{"N", "A", "f"});
        Assert.assertTrue((boolean)iASTMethod2.previouslyDeclared());
        Assert.assertFalse((boolean)iterator2.hasNext());
    }

    public void testOverloadedFunctionTemplates() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" template < class T > void f ( T )   {} ");
        ((Writer)stringWriter).write(" template < class T > void f ( T * ) {} ");
        ((Writer)stringWriter).write(" int * p;");
        ((Writer)stringWriter).write(" void main () {");
        ((Writer)stringWriter).write("    f( p );");
        ((Writer)stringWriter).write("    f( *p );");
        ((Writer)stringWriter).write(" }");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateParameter iASTTemplateParameter = (IASTTemplateParameter)iASTTemplateDeclaration.getTemplateParameters().next();
        IASTFunction iASTFunction = (IASTFunction)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTTemplateDeclaration iASTTemplateDeclaration2 = (IASTTemplateDeclaration)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iASTTemplateDeclaration2.getOwnedDeclaration();
        IASTTemplateParameter iASTTemplateParameter2 = (IASTTemplateParameter)iASTTemplateDeclaration2.getTemplateParameters().next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(6, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTemplateParameter), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTemplateParameter2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction, 1, false, false), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction2, 1, false, false)));
    }

    public void testOverloadedFunctionTemplates_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template< class T > struct A {  };                 \n");
        ((Writer)stringWriter).write("template< class T > void h( const T & );\t//#1     \n");
        ((Writer)stringWriter).write("template< class T > void h( A<T>& );\t\t//#2     \n");
        ((Writer)stringWriter).write("void foo() {                                       \n");
        ((Writer)stringWriter).write("   A<int> z;                                       \n");
        ((Writer)stringWriter).write("   h( z );  //calls 2                              \n");
        ((Writer)stringWriter).write("   const A<int> z2;                                \n");
        ((Writer)stringWriter).write("   h( z2 ); //calls 1 because 2 is not callable.   \n");
        ((Writer)stringWriter).write("}                                                 \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration2 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration3 = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTFunction iASTFunction = (IASTFunction)iASTTemplateDeclaration2.getOwnedDeclaration();
        IASTFunction iASTFunction2 = (IASTFunction)iASTTemplateDeclaration3.getOwnedDeclaration();
        IASTTemplateParameter cfr_ignored_0 = (IASTTemplateParameter)iASTTemplateDeclaration.getTemplateParameters().next();
        IASTTemplateParameter iASTTemplateParameter = (IASTTemplateParameter)iASTTemplateDeclaration2.getTemplateParameters().next();
        IASTTemplateParameter iASTTemplateParameter2 = (IASTTemplateParameter)iASTTemplateDeclaration3.getTemplateParameters().next();
        IASTFunction iASTFunction3 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.getDeclarations((IASTScope)iASTFunction3);
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTClassSpecifier);
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable2.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTClassSpecifier);
        this.assertAllReferences(9, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTemplateParameter), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTemplateParameter2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction, 1, false, false), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction2, 1, false, false)));
    }

    public void testTemplateClassPartialSpecialization() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < class T1, class T2, int I > class A {};  //#1\n");
        ((Writer)stringWriter).write("template < class T, int I >            class A < T, T*, I >   {};  //#2\n");
        ((Writer)stringWriter).write("template < class T1, class T2, int I > class A < T1*, T2, I > {};  //#3\n");
        ((Writer)stringWriter).write("template < class T >                   class A < int, T*, 5 > {};  //#4\n");
        ((Writer)stringWriter).write("template < class T1, class T2, int I > class A < T1, T2*, I > {};  //#5\n");
        ((Writer)stringWriter).write("A <int, int, 1>   a1;\t\t//uses #1 \n");
        ((Writer)stringWriter).write("A <int, int*, 1>  a2;\t\t//uses #2, T is int, I is 1 \n");
        ((Writer)stringWriter).write("A <int, char*, 5> a4;\t\t//uses #4, T is char \n");
        ((Writer)stringWriter).write("A <int, char*, 1> a5;\t\t//uses #5, T is int, T2 is char, I is1 \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        ((Writer)stringWriter).write("  A <int*, int*, 2> amgiguous; //ambiguous, matches #3 & #5 \n");
        try {
            this.parse(((Object)stringWriter).toString());
            Assert.assertFalse((boolean)true);
        }
        catch (ParserException parserException) {
            Assert.assertEquals((String)parserException.getMessage(), (String)"FAILURE");
        }
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration2 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration3 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration4 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration5 = (IASTTemplateDeclaration)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable4 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)iASTTemplateDeclaration2.getOwnedDeclaration();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)iASTTemplateDeclaration3.getOwnedDeclaration();
        IASTClassSpecifier iASTClassSpecifier3 = (IASTClassSpecifier)iASTTemplateDeclaration4.getOwnedDeclaration();
        IASTClassSpecifier iASTClassSpecifier4 = (IASTClassSpecifier)iASTTemplateDeclaration5.getOwnedDeclaration();
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTClassSpecifier);
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable2.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTClassSpecifier2);
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable3.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTClassSpecifier3);
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable4.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTClassSpecifier4);
    }

    public void testTemplateInstanceAsBaseClause() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template< class T > class A { T t; };  \n");
        ((Writer)stringWriter).write("class B : public A< int > {};          \n");
        ((Writer)stringWriter).write("void f( int );                         \n");
        ((Writer)stringWriter).write("void main(){                           \n");
        ((Writer)stringWriter).write("   B b;                                \n");
        ((Writer)stringWriter).write("   f( b.t );                           \n");
        ((Writer)stringWriter).write("}                                      \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateParameter iASTTemplateParameter = (IASTTemplateParameter)iASTTemplateDeclaration.getTemplateParameters().next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        iterator = this.getDeclarations((IASTScope)iASTClassSpecifier2);
        IASTField iASTField = (IASTField)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.getDeclarations((IASTScope)iASTFunction2);
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(6, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTemplateParameter), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testTemplateParameterAsBaseClause() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < class T > class A : public T {};  \n");
        ((Writer)stringWriter).write("class B { int i; };                           \n");
        ((Writer)stringWriter).write("void main() {                                \n");
        ((Writer)stringWriter).write("   A<B> a;                                   \n");
        ((Writer)stringWriter).write("   a.i;                                      \n");
        ((Writer)stringWriter).write("}                                            \n");
        ((Writer)stringWriter).write("\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateParameter iASTTemplateParameter = (IASTTemplateParameter)iASTTemplateDeclaration.getTemplateParameters().next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        iterator = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        iterator = this.getDeclarations((IASTScope)iASTFunction);
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        this.assertAllReferences(5, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTemplateParameter), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
    }

    public void testTypedefedTemplate() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < class T > class _A{ int x; }; \n");
        ((Writer)stringWriter).write("typedef _A < char >  A;                  \n");
        ((Writer)stringWriter).write("void foo() {                             \n");
        ((Writer)stringWriter).write("   A a;                                  \n");
        ((Writer)stringWriter).write("   a.x;                                  \n");
        ((Writer)stringWriter).write("}                                        \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTVariable iASTVariable = (IASTVariable)this.getDeclarations((IASTScope)iASTClassSpecifier).next();
        IASTVariable iASTVariable2 = (IASTVariable)this.getDeclarations((IASTScope)iASTFunction).next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTypedefDeclaration), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
    }

    public void testTypedefedTemplate_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < class T > struct A { T x; };      \n");
        ((Writer)stringWriter).write("template < class U > struct B {              \n");
        ((Writer)stringWriter).write("   typedef A< U > AU;                        \n");
        ((Writer)stringWriter).write("   void f( U );                              \n");
        ((Writer)stringWriter).write("   void f( char );                           \n");
        ((Writer)stringWriter).write("   void g(){                                 \n");
        ((Writer)stringWriter).write("      AU au;                                 \n");
        ((Writer)stringWriter).write("      f( au.x );                             \n");
        ((Writer)stringWriter).write("   }                                         \n");
        ((Writer)stringWriter).write("};                                           \n");
        ((Writer)stringWriter).write("void f2( int );                              \n");
        ((Writer)stringWriter).write("void f2( char );                             \n");
        ((Writer)stringWriter).write("void h(){                                    \n");
        ((Writer)stringWriter).write("   B< int >::AU b;                           \n");
        ((Writer)stringWriter).write("   f2( b.x );                                \n");
        ((Writer)stringWriter).write("}                                            \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateParameter iASTTemplateParameter = (IASTTemplateParameter)iASTTemplateDeclaration.getTemplateParameters().next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTField iASTField = (IASTField)this.getDeclarations((IASTScope)iASTClassSpecifier).next();
        IASTTemplateDeclaration iASTTemplateDeclaration2 = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)iASTTemplateDeclaration2.getOwnedDeclaration();
        IASTTemplateParameter iASTTemplateParameter2 = (IASTTemplateParameter)iASTTemplateDeclaration2.getTemplateParameters().next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        iterator = this.getDeclarations((IASTScope)iASTClassSpecifier2);
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        IASTMethod cfr_ignored_1 = (IASTMethod)iterator.next();
        IASTMethod iASTMethod2 = (IASTMethod)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)this.getDeclarations((IASTScope)iASTMethod2).next();
        IASTVariable iASTVariable2 = (IASTVariable)this.getDeclarations((IASTScope)iASTFunction2).next();
        this.assertAllReferences(13, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTemplateParameter), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTemplateParameter2, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTypedefDeclaration, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTMethod, 1, false, false), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction, 1, false, false)));
    }

    public void testInstantiatingDeferredInstances() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < class T > struct A { A < T > next; };  \n");
        ((Writer)stringWriter).write("A< int > a; \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateParameter iASTTemplateParameter = (IASTTemplateParameter)iASTTemplateDeclaration.getTemplateParameters().next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTField cfr_ignored_0 = (IASTField)this.getDeclarations((IASTScope)iASTClassSpecifier).next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTemplateParameter)));
    }

    public void testTemplateArgumentDeduction() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template< class T > struct B {};                   \n");
        ((Writer)stringWriter).write("template< class T > struct D : public B < T > {};  \n");
        ((Writer)stringWriter).write("struct D2 : public B< int > {};                    \n");
        ((Writer)stringWriter).write("template< class T > T f( B<T> & ) {}               \n");
        ((Writer)stringWriter).write("void test( int );                                  \n");
        ((Writer)stringWriter).write("void test( char );                                 \n");
        ((Writer)stringWriter).write("void main() {                                      \n");
        ((Writer)stringWriter).write("   D<int> d;                                       \n");
        ((Writer)stringWriter).write("   D2     d2;                                      \n");
        ((Writer)stringWriter).write("   test( f( d ) );                                 \n");
        ((Writer)stringWriter).write("   test( f( d2 ) );                                \n");
        ((Writer)stringWriter).write("}                                                  \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration cfr_ignored_0 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration cfr_ignored_1 = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier cfr_ignored_2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTTemplateDeclaration cfr_ignored_3 = (IASTTemplateDeclaration)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_4 = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_5 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction, 2, false, false));
    }

    public void testClassTemplateStaticMemberDefinition() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template< class T > class A{                      \n");
        ((Writer)stringWriter).write("   typedef T * PT;                                \n");
        ((Writer)stringWriter).write("   static T * member;                             \n");
        ((Writer)stringWriter).write("};                                                \n");
        ((Writer)stringWriter).write("template< class T> A<T>::PT A<T>::member = null;  \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateParameter iASTTemplateParameter = (IASTTemplateParameter)iASTTemplateDeclaration.getTemplateParameters().next();
        IASTTemplateDeclaration iASTTemplateDeclaration2 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateParameter iASTTemplateParameter2 = (IASTTemplateParameter)iASTTemplateDeclaration2.getTemplateParameters().next();
        IASTField iASTField = (IASTField)this.getDeclarations((IASTScope)iASTTemplateDeclaration2).next();
        Assert.assertEquals((String)iASTField.getName(), (String)"member");
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTemplateParameter, 2, false, false));
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTemplateParameter2, 2, false, false));
    }

    public void testTemplateTemplateParameter() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" template< class T > class A {                    ");
        ((Writer)stringWriter).write("    int x;                                        ");
        ((Writer)stringWriter).write(" };                                               ");
        ((Writer)stringWriter).write(" template < class T > class A < T * > {           ");
        ((Writer)stringWriter).write("    long x;                                       ");
        ((Writer)stringWriter).write(" };                                               ");
        ((Writer)stringWriter).write(" template< template< class U > class V > class C{ ");
        ((Writer)stringWriter).write("    V< int > y;                                   ");
        ((Writer)stringWriter).write("    V< int * > z;                                 ");
        ((Writer)stringWriter).write(" };                                               ");
        ((Writer)stringWriter).write(" void f( int );                                   ");
        ((Writer)stringWriter).write(" void f( long );                                  ");
        ((Writer)stringWriter).write(" void main() {                                    ");
        ((Writer)stringWriter).write("    C< A > c;                                     ");
        ((Writer)stringWriter).write("    f( c.y.x );                                   ");
        ((Writer)stringWriter).write("    f( c.z.x );                                   ");
        ((Writer)stringWriter).write(" }                                                ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration cfr_ignored_0 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration cfr_ignored_1 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration cfr_ignored_2 = (IASTTemplateDeclaration)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction3 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)this.getDeclarations((IASTScope)iASTFunction3).next();
        IASTSimpleTypeSpecifier iASTSimpleTypeSpecifier = (IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier();
        IASTClassSpecifier cfr_ignored_3 = (IASTClassSpecifier)iASTSimpleTypeSpecifier.getTypeSpecifier();
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction, 1, false, false));
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction2, 1, false, false));
    }

    public void testBug56834() throws Exception {
        Iterator iterator = this.parse("template < class T, class U = T > class A;").getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = iASTTemplateDeclaration.getTemplateParameters();
        IASTTemplateParameter cfr_ignored_0 = (IASTTemplateParameter)iterator.next();
        IASTTemplateParameter cfr_ignored_1 = (IASTTemplateParameter)iterator.next();
    }

    public void testDefaultTemplateParameters() throws Exception {
        Iterator iterator = this.parse("template < class T = int > class A{};  A<> a;").getDeclarations();
        IASTTemplateDeclaration cfr_ignored_0 = (IASTTemplateDeclaration)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
    }

    public void testBug56834WithInstantiation() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template< class T, class U = T > class A {};");
        ((Writer)stringWriter).write("A< char > a;");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration cfr_ignored_0 = (IASTTemplateDeclaration)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
    }

    public void testDefaultTemplateParameterWithDeferedInstance() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < class T > class A;  \n");
        ((Writer)stringWriter).write("template < class U, class V = A< U > > class B; \n");
        ((Writer)stringWriter).write("B< int > b;");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration cfr_ignored_0 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration cfr_ignored_1 = (IASTTemplateDeclaration)iterator.next();
        IASTVariable cfr_ignored_2 = (IASTVariable)iterator.next();
    }

    public void testExplicitInstantiation() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < class T > class A { }; ");
        ((Writer)stringWriter).write("template class A< int >; ");
        ((Writer)stringWriter).write("A< int > a; ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTTemplateInstantiation cfr_ignored_0 = (IASTTemplateInstantiation)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2)));
    }

    public void testTemplateParametersInExpressions() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < typename _Tp > power( _Tp, unsigned int );     \n");
        ((Writer)stringWriter).write("template < typename _Tp > _Tp helper( _Tp __x, int _n )   \n");
        ((Writer)stringWriter).write("{ ");
        ((Writer)stringWriter).write("   return n < 0 ? _Tp( 1 ) / power( __x, -__n )           \n");
        ((Writer)stringWriter).write("                : power( __x, __n );                      \n");
        ((Writer)stringWriter).write("} ");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug44338() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < bool T > class A {   ");
        ((Writer)stringWriter).write("   void foo( bool b = T );      ");
        ((Writer)stringWriter).write("};                              ");
        ((Writer)stringWriter).write("typedef A< 1 < 2 > A_TRUE;      ");
        ((Writer)stringWriter).write("typedef A< ( 1 > 2 ) > A_FALSE; ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration cfr_ignored_0 = (IASTTemplateDeclaration)iterator.next();
        IASTTypedefDeclaration cfr_ignored_1 = (IASTTypedefDeclaration)iterator.next();
        IASTTypedefDeclaration cfr_ignored_2 = (IASTTypedefDeclaration)iterator.next();
    }

    public void testBug44338_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < int i > class X {};   ");
        ((Writer)stringWriter).write("template < class T > class Y {}; ");
        ((Writer)stringWriter).write("Y< X < 1 > > y1;                 ");
        ((Writer)stringWriter).write("Y< X < 6 >> 1 > > y2;            ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration cfr_ignored_0 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration cfr_ignored_1 = (IASTTemplateDeclaration)iterator.next();
        IASTVariable cfr_ignored_2 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_3 = (IASTVariable)iterator.next();
    }

    public void testBug4338_3() throws Exception {
        try {
            this.parse("template < int i > class X {};  X< 1 > 2 > x; ");
            Assert.assertTrue((boolean)false);
        }
        catch (ParserException parserException) {
            Assert.assertTrue((boolean)parserException.getMessage().equals("FAILURE"));
        }
    }

    public void testBug57754() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < class T > class A{                      ");
        ((Writer)stringWriter).write("   typedef int _type;                              ");
        ((Writer)stringWriter).write("   void f( _type, T );                             ");
        ((Writer)stringWriter).write("};                                                 ");
        ((Writer)stringWriter).write("template < class T > void A< T >::f( _type, T ) {} ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        iterator = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTypedefDeclaration, 2));
    }

    public void testContructorsAndExplicitSpecialization() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < class T > class A {  ");
        ((Writer)stringWriter).write("   A();                         ");
        ((Writer)stringWriter).write("   A( int );                    ");
        ((Writer)stringWriter).write("   ~A();                        ");
        ((Writer)stringWriter).write("};                              ");
        ((Writer)stringWriter).write("template <> A< char >::~A();    ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration cfr_ignored_0 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateSpecialization cfr_ignored_1 = (IASTTemplateSpecialization)iterator.next();
    }

    public void testTemplateMemberTemplateDefinition() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template< typename _Tp >  \t\t\t\t\t\t");
        ((Writer)stringWriter).write("class list\t\t\t\t\t\t\t\t\t\t");
        ((Writer)stringWriter).write("{\t\t\t\t\t\t\t\t\t\t\t\t");
        ((Writer)stringWriter).write("   template<typename _S> void merge(list&, _S);  ");
        ((Writer)stringWriter).write("};\t\t\t\t\t\t\t\t\t\t\t\t");
        ((Writer)stringWriter).write("template < typename _Tp >\t\t\t\t\t\t");
        ((Writer)stringWriter).write("template < typename _S  >\t\t\t\t\t\t");
        ((Writer)stringWriter).write("void list<_Tp>::merge(list<_Tp>& __x, _S __comp)\t");
        ((Writer)stringWriter).write("{}\t\t\t\t\t\t\t\t\t\t\t\t");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration cfr_ignored_0 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration cfr_ignored_1 = (IASTTemplateDeclaration)iterator.next();
    }

    public void test_14_7_3__5_ExplicitSpecialization() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template< class T > struct A {  ");
        ((Writer)stringWriter).write("   void f( T ) {}               ");
        ((Writer)stringWriter).write("};                              ");
        ((Writer)stringWriter).write("template <> struct A< int >{    ");
        ((Writer)stringWriter).write("   void f( int );               ");
        ((Writer)stringWriter).write("};                               ");
        ((Writer)stringWriter).write("void A< int >::f( int ){ }      ");
        ((Writer)stringWriter).write("void main(){                    ");
        ((Writer)stringWriter).write("   A<int> a;                    ");
        ((Writer)stringWriter).write("   a.f( 1 );                    ");
        ((Writer)stringWriter).write("}                               ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateParameter iASTTemplateParameter = (IASTTemplateParameter)iASTTemplateDeclaration.getTemplateParameters().next();
        IASTTemplateSpecialization iASTTemplateSpecialization = (IASTTemplateSpecialization)iterator.next();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateSpecialization.getOwnedDeclaration();
        iterator = this.getDeclarations((IASTScope)iASTFunction);
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        this.assertAllReferences(5, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTemplateParameter), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTMethod)));
    }

    public void test_14_7_3__11_ExplicitSpecializationArgumentDeduction() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < class T > class Array { };             ");
        ((Writer)stringWriter).write("template < class T > void sort( Array< T > & );   ");
        ((Writer)stringWriter).write("template<> void sort( Array< int > & ){}          ");
        ((Writer)stringWriter).write("void f(){                                         ");
        ((Writer)stringWriter).write("   Array<int> a1;                                 ");
        ((Writer)stringWriter).write("   Array<char> a2;                                ");
        ((Writer)stringWriter).write("   sort( a1 );                                    ");
        ((Writer)stringWriter).write("   sort( a2 );                                    ");
        ((Writer)stringWriter).write("}                                                 ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration cfr_ignored_0 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration2 = (IASTTemplateDeclaration)iterator.next();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTFunction iASTFunction2 = (IASTFunction)iASTTemplateDeclaration2.getOwnedDeclaration();
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction, 1, false, false));
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction2, 1, false, false));
    }

    public void test_14_8_1__2_ExplicitArgumentSpecification() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void f( int ){}                    //#1   \n");
        ((Writer)stringWriter).write("template < class T > void f( T ){} //#2   \n");
        ((Writer)stringWriter).write("int main(){                               \n");
        ((Writer)stringWriter).write("    f( 1 );      //calls #1               \n");
        ((Writer)stringWriter).write("    f<int>( 1 ); //calls #2               \n");
        ((Writer)stringWriter).write("    f<>   ( 1 ); //calls #2               \n");
        ((Writer)stringWriter).write("}                                         \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction, 1, false, false));
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction2, 2, false, false));
    }

    public void test_14_7_3__12_ExplicitSpecializationOverloadedFunction() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template< class T > void f( T );   ");
        ((Writer)stringWriter).write("template< class T > void f( T * ); ");
        ((Writer)stringWriter).write("template <> void f< int*>( int * );");
        ((Writer)stringWriter).write("template <> void f< int >( int * );");
        ((Writer)stringWriter).write("template <> void f( char );        ");
        this.parse(((Object)stringWriter).toString());
    }

    public void testPartialSpecializationDefinitions() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < class T1, class T2 > class A  { void f(); };");
        ((Writer)stringWriter).write("template < class T > class A < T, T >    { void f(); };");
        ((Writer)stringWriter).write("template < class T > class A < char, T > { void f(); };");
        ((Writer)stringWriter).write("template < class U, class V > void A<U, V>::f(){}      ");
        ((Writer)stringWriter).write("template < class W > void A < W, W >::f(){}            ");
        ((Writer)stringWriter).write("template < class X > void A < char, X >::f(){}         ");
        ((Writer)stringWriter).write("void main(){                                           ");
        ((Writer)stringWriter).write("   A< int, char > a1;                                  ");
        ((Writer)stringWriter).write("   a1.f();                                             ");
        ((Writer)stringWriter).write("   A< int, int > a2;                                   ");
        ((Writer)stringWriter).write("   a2.f();                                             ");
        ((Writer)stringWriter).write("   A< char, int > a3;                                  ");
        ((Writer)stringWriter).write("   a3.f();                                             ");
        ((Writer)stringWriter).write("}                                                      ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration cfr_ignored_0 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration cfr_ignored_1 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration cfr_ignored_2 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration2 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration3 = (IASTTemplateDeclaration)iterator.next();
        IASTFunction cfr_ignored_3 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        IASTMethod iASTMethod = (IASTMethod)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTMethod iASTMethod2 = (IASTMethod)iASTTemplateDeclaration2.getOwnedDeclaration();
        IASTMethod iASTMethod3 = (IASTMethod)iASTTemplateDeclaration3.getOwnedDeclaration();
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTMethod, 1, false, false));
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTMethod2, 1, false, false));
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTMethod3, 1, false, false));
    }

    public void test_14_5_2__2_MemberFunctionTemplates() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < class T > struct A {                                        ");
        ((Writer)stringWriter).write("   void f( int );                                                      ");
        ((Writer)stringWriter).write("   template < class T2 > void f( T2 );                                 ");
        ((Writer)stringWriter).write("};                                                                     ");
        ((Writer)stringWriter).write("template <> void A<int>::f(int) {}  //non-template member            \n");
        ((Writer)stringWriter).write("template <> template<> void A<int>::f<>( int ) {} //template member  \n");
        ((Writer)stringWriter).write("int main(){                                                            ");
        ((Writer)stringWriter).write("   A< int > ac;                                                        ");
        ((Writer)stringWriter).write("   ac.f( 1 );   //non-template                                       \n");
        ((Writer)stringWriter).write("   ac.f( 'c' ); //template                                           \n");
        ((Writer)stringWriter).write("   ac.f<>(1);   //template                                           \n");
        ((Writer)stringWriter).write("}                                                                      ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration cfr_ignored_0 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration2 = (IASTTemplateDeclaration)iterator.next();
        IASTMethod iASTMethod = (IASTMethod)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTMethod cfr_ignored_1 = (IASTMethod)iASTTemplateDeclaration2.getOwnedDeclaration();
        IASTFunction cfr_ignored_2 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTMethod, 1, false, false));
    }

    public void testBug64753() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < class _T > void foo () {  \n");
        ((Writer)stringWriter).write("   if( 1 ) {                         \n");
        ((Writer)stringWriter).write("      _T p1, p2;                     \n");
        ((Writer)stringWriter).write("      int n = p1 - p2;               \n");
        ((Writer)stringWriter).write("   }                                 \n");
        ((Writer)stringWriter).write("}                                    \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration cfr_ignored_0 = (IASTTemplateDeclaration)iterator.next();
    }

    public void testBug64919() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Foo{};                                                   ");
        ((Writer)stringWriter).write("class Bar{};                                                   ");
        ((Writer)stringWriter).write("template <class T, class U> class A {};                        ");
        ((Writer)stringWriter).write("template < class X > class A < X, X > : public A< X, Bar>      ");
        ((Writer)stringWriter).write("{   typedef int TYPE;   };                                     ");
        ((Writer)stringWriter).write("template < class X > class A < X, Foo > : public A< X, X >     ");
        ((Writer)stringWriter).write("{   void f ( TYPE );  };                                       ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTClassSpecifier cfr_ignored_1 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration2 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration3 = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)iASTTemplateDeclaration2.getOwnedDeclaration();
        IASTClassSpecifier iASTClassSpecifier3 = (IASTClassSpecifier)iASTTemplateDeclaration3.getOwnedDeclaration();
        IASTBaseSpecifier iASTBaseSpecifier = (IASTBaseSpecifier)iASTClassSpecifier2.getBaseClauses().next();
        Assert.assertEquals((Object)iASTBaseSpecifier.getParentClassSpecifier(), (Object)iASTClassSpecifier);
        iASTBaseSpecifier = (IASTBaseSpecifier)iASTClassSpecifier3.getBaseClauses().next();
        Assert.assertEquals((Object)iASTBaseSpecifier.getParentClassSpecifier(), (Object)iASTClassSpecifier2);
    }

    public void testBug64939() throws Exception {
        try {
            this.parse("template < class T > class A : public A< T * > {}; A<int> a;").getDeclarations();
            Assert.assertTrue((boolean)false);
        }
        catch (ParserException parserException) {
            Assert.assertTrue((boolean)parserException.getMessage().equals("FAILURE"));
        }
        try {
            this.parse("template < class T > class A { A<T*> f(); }; A< int > a;").getDeclarations();
            Assert.assertTrue((boolean)false);
        }
        catch (ParserException parserException) {
            Assert.assertTrue((boolean)parserException.getMessage().equals("FAILURE"));
        }
    }

    public void testBug65114() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < typename _Tp, typename _Alloc > class _simple_alloc {};    \n");
        ((Writer)stringWriter).write("template < int _inst > class __malloc_alloc {};                       \n");
        ((Writer)stringWriter).write("template < typename _Tp, int __inst>                                  \n");
        ((Writer)stringWriter).write("struct _Alloc_traits {                                                \n");
        ((Writer)stringWriter).write("   typedef _simple_alloc< _Tp, __malloc_alloc<__inst> > _Alloc_type;  \n");
        ((Writer)stringWriter).write("};                                                                    \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration2 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration3 = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)iASTTemplateDeclaration3.getOwnedDeclaration();
        iterator = iASTTemplateDeclaration3.getTemplateParameters();
        IASTTemplateParameter iASTTemplateParameter = (IASTTemplateParameter)iterator.next();
        IASTTemplateParameter iASTTemplateParameter2 = (IASTTemplateParameter)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)iASTTemplateDeclaration2.getOwnedDeclaration();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTemplateParameter), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTemplateParameter2)));
    }

    public void testBug655114_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < typename _Alloc > class base_allocator { int _Tp; };             \n");
        ((Writer)stringWriter).write("template < class T > class B {};                                            \n");
        ((Writer)stringWriter).write("template <> class B < int > {};                                             \n");
        ((Writer)stringWriter).write("template < typename _Alloc > class allocator;                               \n");
        ((Writer)stringWriter).write("template < typename _Tp > class allocator : base_allocator<_Tp>, B<_Tp> {}; \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTTemplateDeclaration iASTTemplateDeclaration2 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration3 = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)iASTTemplateDeclaration2.getOwnedDeclaration();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)iASTTemplateDeclaration3.getOwnedDeclaration();
        IASTTemplateDeclaration cfr_ignored_1 = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration4 = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier3 = (IASTClassSpecifier)iASTTemplateDeclaration4.getOwnedDeclaration();
        iterator = iASTClassSpecifier3.getBaseClauses();
        IASTBaseSpecifier iASTBaseSpecifier = (IASTBaseSpecifier)iterator.next();
        Assert.assertEquals((Object)iASTBaseSpecifier.getParentClassSpecifier(), (Object)iASTClassSpecifier);
        iASTBaseSpecifier = (IASTBaseSpecifier)iterator.next();
        Assert.assertEquals((Object)iASTBaseSpecifier.getParentClassSpecifier(), (Object)iASTClassSpecifier2);
    }

    public void testInheritsFromTemplateParameter_bug71410() throws Exception {
        Iterator iterator = this.parse("template <typename T, class U> \n class A { \n struct B : U { T* mT; }; \n B mB; \n T* getVal() { return mB.mT; } \n }; \n").getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        Iterator iterator2 = iASTClassSpecifier.getDeclarations();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)iterator2.next();
        IASTField cfr_ignored_1 = (IASTField)iterator2.next();
        IASTMethod cfr_ignored_2 = (IASTMethod)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
    }

    public void testThisInTemplatedMemberFunction_bug71331() throws Exception {
        Iterator iterator = this.parse("class A { \n int f() {return 0;} \n template<typename T> int g(T*) { return this->f(); } \n }; \n").getDeclarations();
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier();
        Iterator iterator2 = iASTClassSpecifier.getDeclarations();
        IASTMethod cfr_ignored_0 = (IASTMethod)iterator2.next();
        IASTTemplateDeclaration cfr_ignored_1 = (IASTTemplateDeclaration)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
    }

    public void testTemplateFunctionInsideTemplateType_bug71588() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("template <typename T, typename U> \r\n");
        stringWriter.write("class A { \n");
        stringWriter.write("template <typename V> \n");
        stringWriter.write("T* foo(V); \n");
        stringWriter.write("}; \n");
        stringWriter.write("template <typename T, typename U> \n");
        stringWriter.write("template <typename V> \n");
        stringWriter.write("T* A<T, U>::foo(V) { return (T*)0; } \n");
        Iterator iterator = this.parse(stringWriter.toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        Iterator iterator2 = iASTClassSpecifier.getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration2 = (IASTTemplateDeclaration)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        IASTMethod cfr_ignored_0 = (IASTMethod)iASTTemplateDeclaration2.getOwnedDeclaration();
        IASTTemplateDeclaration iASTTemplateDeclaration3 = (IASTTemplateDeclaration)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        IASTMethod cfr_ignored_1 = (IASTMethod)iASTTemplateDeclaration3.getOwnedDeclaration();
    }

    public void testParametrizedTypeDefinition_bug69751() throws Exception {
        Iterator iterator = this.parse("template <typename T> \n class A { \n typedef typename T::size_type size_type; \n void foo() { size_type i; } \n }; \n").getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        Iterator iterator2 = iASTClassSpecifier.getDeclarations();
        IASTTypedefDeclaration cfr_ignored_0 = (IASTTypedefDeclaration)iterator2.next();
        IASTMethod iASTMethod = (IASTMethod)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        Iterator iterator3 = iASTMethod.getDeclarations();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator3.next();
        Assert.assertFalse((boolean)iterator3.hasNext());
    }

    public void testParametrizedTypeDefinition_bug69751_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <typename T> class A { \n");
        ((Writer)stringWriter).write("void foo(); };\n");
        ((Writer)stringWriter).write("template <typename T> \n");
        ((Writer)stringWriter).write("void A<T>::foo() { \n");
        ((Writer)stringWriter).write("typedef typename T::B<char*>::s_type l_type; \n");
        ((Writer)stringWriter).write("typedef typename T::B<T>::s2_type l2_type; \n");
        ((Writer)stringWriter).write("l_type i; \n");
        ((Writer)stringWriter).write("l2_type j; } \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTTemplateDeclaration iASTTemplateDeclaration2 = (IASTTemplateDeclaration)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        Iterator iterator2 = iASTClassSpecifier.getDeclarations();
        IASTMethod cfr_ignored_0 = (IASTMethod)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        IASTMethod iASTMethod = (IASTMethod)iASTTemplateDeclaration2.getOwnedDeclaration();
        Iterator iterator3 = iASTMethod.getDeclarations();
        IASTTypedefDeclaration cfr_ignored_1 = (IASTTypedefDeclaration)iterator3.next();
        IASTTypedefDeclaration cfr_ignored_2 = (IASTTypedefDeclaration)iterator3.next();
        IASTVariable cfr_ignored_3 = (IASTVariable)iterator3.next();
        IASTVariable cfr_ignored_4 = (IASTVariable)iterator3.next();
        Assert.assertFalse((boolean)iterator3.hasNext());
    }

    public void testParametrizedTypeDefinition_bug69751_3() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <typename T, typename U> class A { \n");
        ((Writer)stringWriter).write("typedef typename T::U::s_type l_type; \n");
        ((Writer)stringWriter).write("l_type m_l; \n");
        ((Writer)stringWriter).write("typename U::s_type m_s; } \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = iASTTemplateDeclaration.getTemplateParameters();
        IASTTemplateParameter iASTTemplateParameter = (IASTTemplateParameter)iterator2.next();
        IASTTemplateParameter iASTTemplateParameter2 = (IASTTemplateParameter)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        Iterator iterator3 = iASTClassSpecifier.getDeclarations();
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator3.next();
        IASTField cfr_ignored_0 = (IASTField)iterator3.next();
        IASTField cfr_ignored_1 = (IASTField)iterator3.next();
        Assert.assertFalse((boolean)iterator3.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTemplateParameter), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTemplateParameter2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTypedefDeclaration)));
    }

    public void testParametrizedTypeDefinition_bug69751_4() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class B { typedef char size_type; };");
        ((Writer)stringWriter).write("template <typename T> class A { \n");
        ((Writer)stringWriter).write("typedef typename T::size_type size_type; };\n");
        ((Writer)stringWriter).write("A<B>::size_type c; \n");
        ((Writer)stringWriter).write("void f(char) {} \n");
        ((Writer)stringWriter).write("void f(int) {} \n");
        ((Writer)stringWriter).write("void main() { f(c); } \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTAbstractTypeSpecifierDeclaration cfr_ignored_0 = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        IASTTemplateDeclaration cfr_ignored_1 = (IASTTemplateDeclaration)iterator.next();
        IASTVariable cfr_ignored_2 = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_3 = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_4 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction, 1, true, false));
    }

    public void testTemplateParametersInExpressions_bug72546() throws Exception {
        Iterator iterator = this.parse("template <class T> \n int add(T * x, T * y) { \n  return x->value + y->value; }; \n").getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = iASTTemplateDeclaration.getTemplateParameters();
        IASTTemplateParameter iASTTemplateParameter = (IASTTemplateParameter)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        IASTFunction iASTFunction = (IASTFunction)iASTTemplateDeclaration.getOwnedDeclaration();
        Iterator iterator3 = iASTFunction.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator3.next();
        IASTParameterDeclaration iASTParameterDeclaration2 = (IASTParameterDeclaration)iterator3.next();
        Assert.assertFalse((boolean)iterator3.hasNext());
        IASTAbstractDeclaration iASTAbstractDeclaration = iASTFunction.getReturnType();
        Assert.assertTrue((iASTAbstractDeclaration != null ? 1 : 0) != 0);
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTemplateParameter, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTParameterDeclaration), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTParameterDeclaration2)));
    }

    public void testInstantiatingTemplateWithDTI_bug69604() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <typename T> class A {}; \n");
        ((Writer)stringWriter).write("template <typename U> class B {}; \n");
        ((Writer)stringWriter).write("template <typename V, typename W = B< A<V> > > class C {}; \n");
        ((Writer)stringWriter).write("C<int> c_int;\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTTemplateDeclaration iASTTemplateDeclaration2 = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)iASTTemplateDeclaration2.getOwnedDeclaration();
        IASTTemplateDeclaration iASTTemplateDeclaration3 = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)iASTTemplateDeclaration3.getOwnedDeclaration();
        Iterator iterator2 = iASTTemplateDeclaration3.getTemplateParameters();
        IASTTemplateParameter cfr_ignored_1 = (IASTTemplateParameter)iterator2.next();
        IASTTemplateParameter cfr_ignored_2 = (IASTTemplateParameter)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        IASTVariable cfr_ignored_3 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 1));
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2, 1));
    }

    public void testTemplatedBaseClass_bug74359() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <typename T> class A {}; \n");
        ((Writer)stringWriter).write("template <typename U> class B {}; \n");
        ((Writer)stringWriter).write("template <typename V> class C : public B<A<V> > {}; \n");
        ((Writer)stringWriter).write("C<int> c_int;\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTTemplateDeclaration iASTTemplateDeclaration2 = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)iASTTemplateDeclaration2.getOwnedDeclaration();
        IASTTemplateDeclaration iASTTemplateDeclaration3 = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier3 = (IASTClassSpecifier)iASTTemplateDeclaration3.getOwnedDeclaration();
        Iterator iterator2 = iASTClassSpecifier3.getBaseClauses();
        IASTBaseSpecifier cfr_ignored_0 = (IASTBaseSpecifier)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 1));
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2, 1));
    }
}

