/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import junit.framework.Assert;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.ASTUtil;
import org.eclipse.cdt.core.parser.ast.IASTASMDefinition;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTBaseSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTClassReference;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTExceptionSpecification;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IASTVariableReference;
import org.eclipse.cdt.core.parser.tests.CompleteParseBaseTest;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class CompleteParseASTTest
extends CompleteParseBaseTest {
    public CompleteParseASTTest(String string) {
        super(string);
    }

    public void testEmptyCompilationUnit() throws Exception {
        IASTScope iASTScope = this.parse("// no real code ");
        Assert.assertNotNull((Object)iASTScope);
        Assert.assertFalse((boolean)iASTScope.getDeclarations().hasNext());
    }

    public void testSimpleNamespace() throws Exception {
        Iterator iterator = this.parse("namespace A { }").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        Assert.assertEquals((String)iASTNamespaceDefinition.getName(), (String)"A");
        Assert.assertFalse((boolean)this.getDeclarations((IASTScope)iASTNamespaceDefinition).hasNext());
    }

    public void testMultipleNamespaceDefinitions() throws Exception {
        Iterator iterator = this.parse("namespace A { } namespace A { }").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        Assert.assertEquals((String)iASTNamespaceDefinition.getName(), (String)"A");
        iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        Assert.assertEquals((String)iASTNamespaceDefinition.getName(), (String)"A");
        Assert.assertFalse((boolean)this.getDeclarations((IASTScope)iASTNamespaceDefinition).hasNext());
    }

    public void testNestedNamespaceDefinitions() throws Exception {
        Iterator iterator = this.parse("namespace A { namespace B { } }").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        Assert.assertEquals((String)iASTNamespaceDefinition.getName(), (String)"A");
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTNamespaceDefinition);
        IASTNamespaceDefinition iASTNamespaceDefinition2 = (IASTNamespaceDefinition)iterator2.next();
        Assert.assertEquals((String)iASTNamespaceDefinition2.getName(), (String)"B");
        Assert.assertFalse((boolean)iterator2.hasNext());
    }

    public void testEmptyClassDeclaration() throws Exception {
        Iterator iterator = this.parse("class A { };").getDeclarations();
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier();
        Assert.assertEquals((String)iASTClassSpecifier.getName(), (String)"A");
        Assert.assertFalse((boolean)this.getDeclarations((IASTScope)iASTClassSpecifier).hasNext());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testSimpleSubclass() throws Exception {
        Iterator iterator = this.parse("class A { };  class B : public A { };").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = iASTClassSpecifier2.getBaseClauses();
        IASTBaseSpecifier iASTBaseSpecifier = (IASTBaseSpecifier)iterator2.next();
        Assert.assertEquals((Object)iASTClassSpecifier, (Object)iASTBaseSpecifier.getParentClassSpecifier());
        Assert.assertEquals((String)iASTBaseSpecifier.getParentClassName(), (String)"A");
        Assert.assertEquals((Object)iASTBaseSpecifier.getAccess(), (Object)ASTAccessVisibility.PUBLIC);
        Assert.assertFalse((boolean)iASTBaseSpecifier.isVirtual());
    }

    public void testNestedSubclass() throws Exception {
        Iterator iterator = this.parse("namespace N { class A { }; } class B : protected virtual N::A { };").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)this.getDeclarations((IASTScope)iASTNamespaceDefinition).next()).getTypeSpecifier();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = iASTClassSpecifier2.getBaseClauses();
        IASTBaseSpecifier iASTBaseSpecifier = (IASTBaseSpecifier)iterator2.next();
        Assert.assertEquals((Object)iASTClassSpecifier, (Object)iASTBaseSpecifier.getParentClassSpecifier());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
    }

    public void testSimpleVariable() throws Exception {
        Iterator iterator = this.parse("int x;").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"x");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.INT);
    }

    public void testSimpleClassReferenceVariable() throws Exception {
        Iterator iterator = this.parse("class A { }; A x;").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"x");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTClassSpecifier);
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier)));
    }

    public void testNestedClassReferenceVariable() throws Exception {
        Iterator iterator = this.parse("namespace N { class A { }; } N::A x;").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTNamespaceDefinition);
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator2.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"x");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTClassSpecifier);
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
    }

    public void testMultipleDeclaratorsVariable() throws Exception {
        Iterator iterator = this.parse("class A { }; A x, y, z;").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"x");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTClassSpecifier);
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)3);
        Iterator iterator2 = this.callback.getReferences().iterator();
        while (iterator2.hasNext()) {
            Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTClassSpecifier);
        }
    }

    public void testSimpleField() throws Exception {
        Iterator iterator = this.parse("class A { double x; };").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTField iASTField = (IASTField)iterator2.next();
        Assert.assertEquals((String)iASTField.getName(), (String)"x");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTField.getAbstractDeclaration().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.DOUBLE);
    }

    public void testUsingClauses() throws Exception {
        Iterator iterator = this.parse("namespace A { namespace B { int x;  class C { static int y = 5; }; } } \n using namespace A::B;\n using A::B::x;using A::B::C;using A::B::C::y;").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        IASTNamespaceDefinition iASTNamespaceDefinition2 = (IASTNamespaceDefinition)this.getDeclarations((IASTScope)iASTNamespaceDefinition).next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTNamespaceDefinition2);
        IASTVariable iASTVariable = (IASTVariable)iterator2.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator2.next()).getTypeSpecifier();
        IASTField iASTField = (IASTField)this.getDeclarations((IASTScope)iASTClassSpecifier).next();
        this.assertQualifiedName(iASTField.getFullyQualifiedName(), new String[]{"A", "B", "C", "y"});
        IASTUsingDirective iASTUsingDirective = (IASTUsingDirective)iterator.next();
        Assert.assertEquals((Object)iASTUsingDirective.getNamespaceDefinition(), (Object)iASTNamespaceDefinition2);
        Assert.assertEquals((String)iASTUsingDirective.getNamespaceName(), (String)"A::B");
        IASTUsingDeclaration iASTUsingDeclaration = (IASTUsingDeclaration)iterator.next();
        Assert.assertEquals(iASTUsingDeclaration.getUsingTypes().next(), (Object)iASTVariable);
        iASTUsingDeclaration = (IASTUsingDeclaration)iterator.next();
        Assert.assertEquals(iASTUsingDeclaration.getUsingTypes().next(), (Object)iASTClassSpecifier);
        iASTUsingDeclaration = (IASTUsingDeclaration)iterator.next();
        Assert.assertEquals(iASTUsingDeclaration.getUsingTypes().next(), (Object)iASTField);
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)12);
    }

    public void testEnumerations() throws Exception {
        Iterator iterator = this.parse("namespace A { enum E { e1, e2, e3 }; E varE;}").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTNamespaceDefinition);
        IASTEnumerationSpecifier iASTEnumerationSpecifier = (IASTEnumerationSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator2.next()).getTypeSpecifier();
        Assert.assertEquals((String)iASTEnumerationSpecifier.getName(), (String)"E");
        this.assertQualifiedName(iASTEnumerationSpecifier.getFullyQualifiedName(), new String[]{"A", "E"});
        Iterator iterator3 = iASTEnumerationSpecifier.getEnumerators();
        IASTEnumerator iASTEnumerator = (IASTEnumerator)iterator3.next();
        IASTEnumerator iASTEnumerator2 = (IASTEnumerator)iterator3.next();
        IASTEnumerator iASTEnumerator3 = (IASTEnumerator)iterator3.next();
        Assert.assertFalse((boolean)iterator3.hasNext());
        Assert.assertEquals((String)iASTEnumerator.getName(), (String)"e1");
        Assert.assertEquals((String)iASTEnumerator2.getName(), (String)"e2");
        Assert.assertEquals((String)iASTEnumerator3.getName(), (String)"e3");
        IASTVariable iASTVariable = (IASTVariable)iterator2.next();
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTEnumerationSpecifier);
    }

    public void testSimpleFunction() throws Exception {
        Iterator iterator = this.parse("void foo( void );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"foo");
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)0);
    }

    public void testSimpleFunctionWithTypes() throws Exception {
        Iterator iterator = this.parse("class A { public: \n class B { }; }; const A::B &  foo( A * myParam );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator2.next()).getTypeSpecifier();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2)));
    }

    public void testSimpleMethod() throws Exception {
        Iterator iterator = this.parse("class A { void foo(); };").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTMethod iASTMethod = (IASTMethod)this.getDeclarations((IASTScope)iASTClassSpecifier).next();
        Assert.assertEquals((String)iASTMethod.getName(), (String)"foo");
    }

    public void testSimpleMethodWithTypes() throws Exception {
        Iterator iterator = this.parse("class U { }; class A { U foo( U areDumb ); };").getDeclarations();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTMethod iASTMethod = (IASTMethod)this.getDeclarations((IASTScope)iASTClassSpecifier).next();
        Assert.assertEquals((String)iASTMethod.getName(), (String)"foo");
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
    }

    public void testUsingDeclarationWithFunctionsAndMethods() throws Exception {
        Iterator iterator = this.parse("namespace N { int foo(void); } class A { static int bar(void); }; using N::foo; using ::A::bar;").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)this.getDeclarations((IASTScope)iASTNamespaceDefinition).next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTMethod iASTMethod = (IASTMethod)this.getDeclarations((IASTScope)iASTClassSpecifier).next();
        IASTUsingDeclaration cfr_ignored_0 = (IASTUsingDeclaration)iterator.next();
        IASTUsingDeclaration cfr_ignored_1 = (IASTUsingDeclaration)iterator.next();
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)4);
        Iterator iterator2 = this.callback.getReferences().iterator();
        Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTNamespaceDefinition);
        Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTFunction);
        Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTClassSpecifier);
        Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTMethod);
    }

    public void testLinkageSpec() throws Exception {
        IASTLinkageSpecification iASTLinkageSpecification = (IASTLinkageSpecification)this.parse("extern \"C\" { int foo(); }").getDeclarations().next();
        Iterator iterator = this.getDeclarations((IASTScope)iASTLinkageSpecification);
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"foo");
    }

    public void testBogdansExample() throws Exception {
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)this.parse("namespace A { namespace B {\tenum e1{e_1,e_2};\tint x;\tclass C\t{\tstatic int y = 5;\t}; }} ").getDeclarations().next();
        IASTNamespaceDefinition iASTNamespaceDefinition2 = (IASTNamespaceDefinition)this.getDeclarations((IASTScope)iASTNamespaceDefinition).next();
        Iterator iterator = this.getDeclarations((IASTScope)iASTNamespaceDefinition2);
        IASTEnumerationSpecifier iASTEnumerationSpecifier = (IASTEnumerationSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = iASTEnumerationSpecifier.getEnumerators();
        IASTEnumerator iASTEnumerator = (IASTEnumerator)iterator2.next();
        Assert.assertEquals((Object)iASTEnumerator.getOwnerEnumerationSpecifier(), (Object)iASTEnumerationSpecifier);
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTClassSpecifier cfr_ignored_1 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
    }

    public void testAndrewsExample() throws Exception {
        Iterator iterator = this.parse("namespace N{ class A {}; }\tusing namespace N;\tclass B: public A{};").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)this.getDeclarations((IASTScope)iASTNamespaceDefinition).next()).getTypeSpecifier();
        IASTUsingDirective cfr_ignored_0 = (IASTUsingDirective)iterator.next();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTBaseSpecifier iASTBaseSpecifier = (IASTBaseSpecifier)iASTClassSpecifier2.getBaseClauses().next();
        Assert.assertEquals((Object)iASTBaseSpecifier.getParentClassSpecifier(), (Object)iASTClassSpecifier);
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
    }

    public void testSimpleTypedef() throws Exception {
        Iterator iterator = this.parse("typedef int myInt;\n myInt var;").getDeclarations();
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        Assert.assertEquals((String)iASTTypedefDeclaration.getName(), (String)"myInt");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTTypedefDeclaration.getAbstractDeclarator().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.INT);
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"var");
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
    }

    public void testComplexTypedef() throws Exception {
        Iterator iterator = this.parse("class A{ }; typedef A ** A_DOUBLEPTR;").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTTypedefDeclaration.getAbstractDeclarator().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTClassSpecifier);
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
    }

    protected void assertQualifiedName(String[] stringArray, String[] stringArray2) {
        Assert.assertNotNull((Object)stringArray);
        Assert.assertNotNull((Object)stringArray2);
        Assert.assertEquals((int)stringArray.length, (int)stringArray2.length);
        int n = 0;
        while (n < stringArray.length) {
            Assert.assertEquals((String)stringArray[n], (String)stringArray2[n]);
            ++n;
        }
    }

    public void testBug40842() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A {} a;\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)0);
    }

    public void testNestedClassname() throws Exception {
        Iterator iterator = this.parse("namespace A { } \n class A::B { };").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertEquals((Object)iASTClassSpecifier.getOwnerScope(), (Object)iASTNamespaceDefinition);
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
    }

    public void testForwardDeclaration() throws Exception {
        Iterator iterator = this.parse("class forward;").getDeclarations();
        Assert.assertTrue((boolean)iterator.hasNext());
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier();
        Assert.assertEquals((String)iASTElaboratedTypeSpecifier.getName(), (String)"forward");
        Assert.assertEquals((Object)iASTElaboratedTypeSpecifier.getClassKind(), (Object)ASTClassKind.CLASS);
    }

    public void testElaboratedType() throws Exception {
        Iterator iterator = this.parse("class A; class A * a;").getDeclarations();
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertEquals((String)iASTElaboratedTypeSpecifier.getName(), (String)"A");
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"a");
        Assert.assertEquals((Object)iASTVariable.getAbstractDeclaration().getTypeSpecifier(), (Object)iASTElaboratedTypeSpecifier);
    }

    public void testForewardDeclarationWithUsage() throws Exception {
        Iterator iterator = this.parse("class A; A * anA;class A { };").getDeclarations();
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration2 = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTAbstractTypeSpecifierDeclaration2.getTypeSpecifier();
        Assert.assertEquals((String)iASTElaboratedTypeSpecifier.getName(), (String)iASTClassSpecifier.getName());
        String[] stringArray = iASTClassSpecifier.getFullyQualifiedName();
        String[] stringArray2 = iASTElaboratedTypeSpecifier.getFullyQualifiedName();
        Assert.assertEquals((int)stringArray.length, (int)stringArray2.length);
        int n = 0;
        while (n < stringArray.length) {
            Assert.assertEquals((String)stringArray[n], (String)stringArray2[n]);
            ++n;
        }
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
        Assert.assertEquals((int)this.callback.getForewardDecls().size(), (int)1);
        IASTClassReference iASTClassReference = (IASTClassReference)this.callback.getReferences().get(0);
        Assert.assertTrue((boolean)(iASTClassReference.getReferencedElement() instanceof IASTElaboratedTypeSpecifier));
        Assert.assertEquals((Object)iASTClassReference.getReferencedElement(), (Object)iASTElaboratedTypeSpecifier);
    }

    public void testASM() throws Exception {
        IASTASMDefinition iASTASMDefinition = (IASTASMDefinition)this.parse("asm ( \"blah blah blah\" );").getDeclarations().next();
        Assert.assertEquals((String)iASTASMDefinition.getBody(), (String)"blah blah blah");
    }

    public void testOverride() throws Exception {
        Iterator iterator = this.parse("void foo();\n void foo( int );\n").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testSimpleExpression() throws Exception {
        Iterator iterator = this.parse("int x; int y = x;").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
    }

    public void testParameterExpressions() throws Exception {
        Iterator iterator = this.parse("int x = 5; void foo( int sub = x ) { }").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
    }

    public void testNestedNamespaceExpression() throws Exception {
        Iterator iterator = this.parse("namespace A { int x = 666; } int y  = A::x;").getDeclarations();
        IASTNamespaceDefinition cfr_ignored_0 = (IASTNamespaceDefinition)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
    }

    public void testConstructorChain() throws Exception {
        Iterator iterator = this.parse("int x = 5;\n class A \n{ public : \n int a; \n A() : a( x ) { } };").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTField iASTField = (IASTField)iterator2.next();
        IASTMethod cfr_ignored_0 = (IASTMethod)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
    }

    public void testArrayModExpression() throws Exception {
        Iterator iterator = this.parse("const int x = 5; int y [ x ]; ").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
    }

    public void testPointerVariable() throws Exception {
        Iterator iterator = this.parse("class A { }; A * anA;").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
        IASTClassReference iASTClassReference = (IASTClassReference)this.callback.getReferences().get(0);
        Assert.assertEquals((Object)iASTClassReference.getReferencedElement(), (Object)iASTClassSpecifier);
    }

    public void testExceptionSpecification() throws Exception {
        Iterator iterator = this.parse("class A { }; void foo( void ) throw ( A );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
        IASTClassReference iASTClassReference = (IASTClassReference)this.callback.getReferences().get(0);
        Assert.assertEquals((Object)iASTClassReference.getReferencedElement(), (Object)iASTClassSpecifier);
    }

    public void testNewExpressions() throws Exception {
        Iterator iterator = this.parse("int A; int B; int C; int D; int P; int*p = new  (P) (A)[B][C][D];").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable4 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable5 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)5);
        Iterator iterator2 = this.callback.getReferences().iterator();
        Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTVariable);
        Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTVariable5);
        Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTVariable2);
        Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTVariable3);
        Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTVariable4);
    }

    public void testBug41520() throws Exception {
        Iterator iterator = this.parse("const int x = 666; const int y( x );").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testNewXReferences() throws Exception {
        Iterator iterator = this.parse("const int max = 5;\n int * x = new int[max];").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
        IASTVariableReference iASTVariableReference = (IASTVariableReference)this.callback.getReferences().get(0);
        Assert.assertEquals((Object)iASTVariableReference.getReferencedElement(), (Object)iASTVariable);
    }

    public void testQualifiedNameReferences() throws Exception {
        Iterator iterator = this.parse("class A{ class B{ class C { public: int cMethod(); }; }; }; \n  int A::B::C::cMethod() {}; \n").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator2.next()).getTypeSpecifier();
        Iterator iterator3 = this.getDeclarations((IASTScope)iASTClassSpecifier2);
        IASTClassSpecifier iASTClassSpecifier3 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator3.next()).getTypeSpecifier();
        IASTMethod cfr_ignored_0 = (IASTMethod)iterator.next();
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier3)));
    }

    public void testIsConstructor() throws Exception {
        Iterator iterator = this.parse("class A{ public: A(); }; \n  A::A() {}; \n").getDeclarations();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        Assert.assertTrue((boolean)iASTMethod.isConstructor());
    }

    public void testIsDestructor() throws Exception {
        Iterator iterator = this.parse("class A{ public: ~A(); }; \n  A::~A() {}; \n").getDeclarations();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        Assert.assertTrue((boolean)iASTMethod.isDestructor());
    }

    public void testBug41445() throws Exception {
        Iterator iterator = this.parse("class A { }; namespace N { class B : public A { struct A {}; }; }").getDeclarations();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTNamespaceDefinition);
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator2.next()).getTypeSpecifier();
        IASTClassSpecifier cfr_ignored_1 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)this.getDeclarations((IASTScope)iASTClassSpecifier).next()).getTypeSpecifier();
    }

    public void testSimpleFunctionBody() throws Exception {
        Iterator iterator = this.parse("class A { int f1(); }; const int x = 4; int f() { return x; } int A::f1() { return x; }").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTMethod iASTMethod = (IASTMethod)this.getDeclarations((IASTScope)iASTClassSpecifier).next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTMethod iASTMethod2 = (IASTMethod)iterator.next();
        Assert.assertEquals((String)iASTMethod2.getName(), (String)iASTMethod.getName());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)3);
        IASTVariableReference iASTVariableReference = (IASTVariableReference)this.callback.getReferences().get(0);
        Assert.assertEquals((Object)iASTVariableReference.getReferencedElement(), (Object)iASTVariable);
        IASTClassReference iASTClassReference = (IASTClassReference)this.callback.getReferences().get(1);
        Assert.assertEquals((Object)iASTClassReference.getReferencedElement(), (Object)iASTClassSpecifier);
        iASTVariableReference = (IASTVariableReference)this.callback.getReferences().get(2);
        Assert.assertEquals((Object)iASTVariableReference.getReferencedElement(), (Object)iASTVariable);
    }

    public void testSimpleForLoop() throws Exception {
        Iterator iterator = this.parse("const int FIVE = 5;  void f() {  int x = 0; for( int i = 0; i < FIVE; ++i ) { x += i; }  }").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)5);
        iterator = this.parse("const int FIVE = 5;  void f() {  int x = 0; for( int i = 0; i < FIVE; ++i )  x += i;  }").getDeclarations();
        IASTVariable cfr_ignored_2 = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_3 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)5);
        iterator = this.parse("class A { }; void f() {  for( int i = 0; i < (A*)0; ++i ) { A anA; } }").getDeclarations();
        IASTClassSpecifier cfr_ignored_4 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction cfr_ignored_5 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)4);
    }

    public void testBug42541() throws Exception {
        Iterator iterator = this.parse("union{ int v; char a; } id;").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTField cfr_ignored_0 = (IASTField)iterator2.next();
        IASTField cfr_ignored_1 = (IASTField)iterator2.next();
    }

    public void testSimpleIfStatement() throws Exception {
        Iterator iterator = this.parse("const bool T = true; int foo() { if( T ) { return 5; } else if( ! T ) return 20; else { return 10; } }").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
    }

    public void testSimpleWhileStatement() throws Exception {
        Iterator iterator = this.parse("const bool T = true; void foo() { int x = 0; while( T ) {  ++x;  if( x == 100 ) break; } }").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)3);
    }

    public void testSimpleSwitchStatement() throws Exception {
        Iterator iterator = this.parse("const int x = 5; const int y = 10; void foo() { switch( x ) { case 1: break; case 2: goto blah; case y: continue; default: break;} }").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_2 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
    }

    public void testSimpleDoStatement() throws Exception {
        Iterator iterator = this.parse("const int x = 3; int counter = 0; void foo() { do { ++counter; } while( counter != x ); } ").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_2 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)3);
    }

    public void testThrowStatement() throws Exception {
        Iterator iterator = this.parse("class A { }; void foo() throw ( A ) { throw A; throw; } ").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
        int n = 0;
        while (n < 2) {
            Assert.assertEquals((Object)((IASTReference)this.callback.getReferences().get(n)).getReferencedElement(), (Object)iASTClassSpecifier);
            ++n;
        }
    }

    public void testScoping() throws Exception {
        Iterator iterator = this.parse("void foo() { int x = 3; if( x == 1 ) { int x = 4; } else int x = 2; }").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTFunction);
        IASTVariable iASTVariable = (IASTVariable)iterator2.next();
        Assert.assertEquals((String)iASTVariable.getInitializerClause().getAssigmentExpression().getLiteralString(), (String)"3");
        Assert.assertEquals((String)iASTVariable.getName(), (String)"x");
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
        Assert.assertEquals((Object)((IASTReference)this.callback.getReferences().get(0)).getReferencedElement(), (Object)iASTVariable);
        Iterator iterator3 = this.getNestedScopes((IASTCodeScope)iASTFunction);
        IASTCodeScope iASTCodeScope = (IASTCodeScope)iterator3.next();
        Iterator iterator4 = this.getDeclarations((IASTScope)iASTCodeScope);
        IASTVariable iASTVariable2 = (IASTVariable)iterator4.next();
        Assert.assertEquals((String)iASTVariable2.getInitializerClause().getAssigmentExpression().getLiteralString(), (String)"4");
        iASTCodeScope = (IASTCodeScope)iterator3.next();
        Assert.assertFalse((boolean)iterator3.hasNext());
        iterator4 = this.getDeclarations((IASTScope)iASTCodeScope);
        IASTVariable iASTVariable3 = (IASTVariable)iterator4.next();
        Assert.assertEquals((String)iASTVariable3.getInitializerClause().getAssigmentExpression().getLiteralString(), (String)"2");
    }

    public void testEnumeratorReferences() throws Exception {
        Iterator iterator = this.parse("enum E { e1, e2, e3 }; E anE = e1;").getDeclarations();
        IASTEnumerationSpecifier iASTEnumerationSpecifier = (IASTEnumerationSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTEnumerator iASTEnumerator = (IASTEnumerator)iASTEnumerationSpecifier.getEnumerators().next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
        Assert.assertEquals((Object)((IASTReference)this.callback.getReferences().get(0)).getReferencedElement(), (Object)iASTEnumerationSpecifier);
        Assert.assertEquals((Object)((IASTReference)this.callback.getReferences().get(1)).getReferencedElement(), (Object)iASTEnumerator);
    }

    public void testBug42840() throws Exception {
        Iterator iterator = this.parse("void foo(); void foo() { } class SearchMe { };").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)this.callback.getReferences().isEmpty());
        iterator = this.parse("class A { void f ( A );\t};\tvoid A::f( A ){ return; }").getDeclarations();
        iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTMethod cfr_ignored_2 = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTMethod cfr_ignored_3 = (IASTMethod)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        this.callback.getReferences().iterator();
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)3);
        int n = 0;
        while (n < 3) {
            Assert.assertEquals((Object)((IASTReference)this.callback.getReferences().get(n)).getReferencedElement(), (Object)iASTClassSpecifier);
            ++n;
        }
    }

    public void testBug42872() throws Exception {
        Iterator iterator = this.parse("struct B {}; struct D : B {}; void foo(D* dp) { B* bp = dynamic_cast<B*>(dp); }").getDeclarations();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTClassSpecifier cfr_ignored_1 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_2 = (IASTVariable)this.getDeclarations((IASTScope)iASTFunction).next();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug43503A() throws Exception {
        Iterator iterator = this.parse("class SD_01 { void f_SD_01() {}}; int main(){ SD_01 * a = new SD_01(); a->f_SD_01();\t} ").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTMethod cfr_ignored_0 = (IASTMethod)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator3 = this.getDeclarations((IASTScope)iASTFunction);
        Assert.assertTrue((boolean)iterator3.hasNext());
    }

    public void testBug42979() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class OperatorOverload{\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("  bool operator==( const class OperatorOverload& that )\n");
        ((Writer)stringWriter).write("  { return true; }\n");
        ((Writer)stringWriter).write("  bool operator!=( const class OperatorOverload& that );\n");
        ((Writer)stringWriter).write("}; \n");
        ((Writer)stringWriter).write("bool OperatorOverload::operator!=( const class OperatorOverload& that )\n");
        ((Writer)stringWriter).write("{ return false; }\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTMethod cfr_ignored_0 = (IASTMethod)iterator2.next();
        IASTMethod iASTMethod = (IASTMethod)iterator2.next();
        IASTMethod iASTMethod2 = (IASTMethod)iterator.next();
        Assert.assertEquals((String)iASTMethod2.getName(), (String)iASTMethod.getName());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)4);
        int n = 0;
        while (n < 4) {
            Assert.assertFalse((iASTClassSpecifier.getNameOffset() == ((IASTReference)this.callback.getReferences().get(n)).getOffset() ? 1 : 0) != 0);
            ++n;
        }
    }

    public void testBug43373() throws Exception {
        Iterator iterator = this.parse("class A { static int x; }; int A::x = 5;").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTField iASTField = (IASTField)iterator2.next();
        IASTField iASTField2 = (IASTField)iterator.next();
        Assert.assertTrue((iASTField.getVisiblity() == iASTField2.getVisiblity() ? 1 : 0) != 0);
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier)));
    }

    public void testBug39504() throws Exception {
        Iterator iterator = this.parse("const int w = 2; int x[ 5 ]; int y = sizeof (x[w]);").getDeclarations();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_2 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
    }

    public void testBug43375() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.parse("extern int x;").getDeclarations().next();
        Assert.assertTrue((boolean)iASTVariable.isExtern());
    }

    public void testBug43503() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class SD_02 {");
        stringBuffer.append("\tpublic:");
        stringBuffer.append(" void f_SD_02();");
        stringBuffer.append(" };");
        stringBuffer.append("class SD_01 {\n");
        stringBuffer.append("\tpublic:\n");
        stringBuffer.append("\t\tSD_02 *next;");
        stringBuffer.append("\t\tvoid f_SD_01();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int main(){\n");
        stringBuffer.append("\tSD_01 a = new SD_01();\n");
        stringBuffer.append("\ta->f_SD_01();\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void SD_01::f_SD_01()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("   next->f_SD_02();\n");
        stringBuffer.append("}\n");
        Iterator iterator = this.parse(stringBuffer.toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTMethod iASTMethod = (IASTMethod)this.getDeclarations((IASTScope)iASTClassSpecifier).next();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTField iASTField = (IASTField)this.getDeclarations((IASTScope)iASTClassSpecifier2).next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)this.getDeclarations((IASTScope)iASTFunction).next();
        IASTMethod iASTMethod2 = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(8, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2, 3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTMethod2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTMethod), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField)));
    }

    public void testBug43679_A() throws Exception {
        try {
            Iterator iterator = this.parse("struct Sample { int size() const; }; extern const Sample * getSample(); int trouble() {  return getSample()->size(); } ", false).getDeclarations();
            IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
            Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
            IASTMethod iASTMethod = (IASTMethod)iterator2.next();
            Assert.assertFalse((boolean)iterator2.hasNext());
            IASTFunction iASTFunction = (IASTFunction)iterator.next();
            IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
            Assert.assertFalse((boolean)iterator.hasNext());
            this.callback.getReferences().iterator();
            this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTMethod), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }

    public void testBug43679_B() throws Exception {
        try {
            Iterator iterator = this.parse("struct Sample{int size() const; }; struct Sample; ", false).getDeclarations();
            IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
            Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
            IASTMethod cfr_ignored_0 = (IASTMethod)iterator2.next();
            Assert.assertFalse((boolean)iterator2.hasNext());
            IASTAbstractTypeSpecifierDeclaration cfr_ignored_1 = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
            Assert.assertFalse((boolean)iterator.hasNext());
            Iterator iterator3 = this.callback.getReferences().iterator();
            Assert.assertFalse((boolean)iterator3.hasNext());
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }

    public void testBug43951() throws Exception {
        Iterator iterator = this.parse("class B{ B(); ~B(); }; B::B(){} B::~B(){}", false).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertEquals((String)iASTClassSpecifier.getName(), (String)"B");
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        Assert.assertEquals((String)iASTMethod.getName(), (String)"B");
        Assert.assertTrue((boolean)iASTMethod.previouslyDeclared());
    }

    public void testBug44342() throws Exception {
        try {
            IASTScope iASTScope = this.parse("class A { void f(){} void f(int){} }; int main(){ A * a = new A(); a->f();} ");
            Iterator iterator = iASTScope.getDeclarations();
            IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
            Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
            IASTMethod iASTMethod = (IASTMethod)iterator2.next();
            IASTMethod cfr_ignored_0 = (IASTMethod)iterator2.next();
            Assert.assertFalse((boolean)iterator2.hasNext());
            IASTFunction iASTFunction = (IASTFunction)iterator.next();
            Assert.assertFalse((boolean)iterator.hasNext());
            Iterator iterator3 = this.getDeclarations((IASTScope)iASTFunction);
            Assert.assertTrue((boolean)iterator3.hasNext());
            IASTVariable iASTVariable = (IASTVariable)iterator3.next();
            this.callback.getReferences().iterator();
            this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTMethod)));
        }
        catch (ParserException parserException) {
            Assert.fail();
        }
    }

    public void testCDesignatedInitializers() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct Inner { int a,b,c; };");
        stringBuffer.append("struct A { int x; int y[]; struct Inner innerArray[]; int z []; };");
        stringBuffer.append("struct A myA = { .x = 4, .y[3] = 4, .y[4] = 3, .innerArray[0].a = 3, .innerArray[1].b = 5, .innerArray[2].c=6, .z = { 1,4,5} };");
        Iterator iterator = this.parse(stringBuffer.toString(), true, ParserLanguage.C).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTField iASTField = (IASTField)iterator2.next();
        IASTField iASTField2 = (IASTField)iterator2.next();
        IASTField iASTField3 = (IASTField)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier2);
        IASTField iASTField4 = (IASTField)iterator2.next();
        IASTField iASTField5 = (IASTField)iterator2.next();
        IASTField iASTField6 = (IASTField)iterator2.next();
        IASTField iASTField7 = (IASTField)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(12, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField4), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField5, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField6, 3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField7)));
    }

    public void testBug39551A() throws Exception {
        IASTFunction iASTFunction = (IASTFunction)this.parse("extern float _Complex conjf (float _Complex);", true, ParserLanguage.C).getDeclarations().next();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"conjf");
        Assert.assertTrue((boolean)((IASTSimpleTypeSpecifier)iASTFunction.getReturnType().getTypeSpecifier()).isComplex());
    }

    public void testCBool() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.parse("_Bool x;", true, ParserLanguage.C).getDeclarations().next();
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type._BOOL);
    }

    public void testCBoolAsParameter() throws Exception {
        Iterator iterator = this.parse("void f( _Bool b ) {} _Bool g( _Bool b ) {} void main(){   _Bool b;     f(b);\tf( g( (_Bool) 1 )  );}", true, ParserLanguage.C).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction3 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)this.getDeclarations((IASTScope)iASTFunction3).next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction2)));
    }

    public void testBug44510() throws Exception {
        Iterator iterator = this.parse("int initialize(); int initialize( char ){} int initialize(){ return 1; } void main(){ int i = initialize(); }").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertEquals((boolean)iASTFunction.previouslyDeclared(), (boolean)false);
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Assert.assertEquals((boolean)iASTFunction2.previouslyDeclared(), (boolean)false);
        IASTFunction iASTFunction3 = (IASTFunction)iterator.next();
        Assert.assertEquals((boolean)iASTFunction3.previouslyDeclared(), (boolean)true);
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction3)));
    }

    public void testBug44925() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class MyClass { };");
        stringBuffer.append("class MyClass myObj1;");
        stringBuffer.append("enum MyEnum { Item1 };");
        stringBuffer.append("enum MyEnum myObj2;");
        Iterator iterator = this.parse(stringBuffer.toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTEnumerationSpecifier iASTEnumerationSpecifier = (IASTEnumerationSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTEnumerationSpecifier)));
    }

    public void testBug44838() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A { int myX; A( int x ); };\n");
        stringBuffer.append("A::A( int x ) : myX( x ) { if( x == 5 ) myX++; }\n");
        Iterator iterator = this.parse(stringBuffer.toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTField cfr_ignored_0 = (IASTField)this.getDeclarations((IASTScope)iASTClassSpecifier).next();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        IASTParameterDeclaration cfr_ignored_1 = (IASTParameterDeclaration)iASTMethod.getParameters().next();
        Assert.assertTrue((boolean)iASTMethod.isConstructor());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug46165() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A { int myX; A( int x ); };\n");
        stringBuffer.append("A::A( int x ) : myX( x ) { if( x == 5 ) myX++; }\n");
        Iterator iterator = this.parse(stringBuffer.toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTField iASTField = (IASTField)this.getDeclarations((IASTScope)iASTClassSpecifier).next();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iASTMethod.getParameters().next();
        Assert.assertTrue((boolean)iASTMethod.isConstructor());
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTParameterDeclaration)));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug47624() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct s { }; \n");
        stringBuffer.append("void f ( int s ) { \n");
        stringBuffer.append("   struct s sInstance; \n");
        stringBuffer.append("}\n");
        Iterator iterator = this.parse(stringBuffer.toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTFunction);
        IASTVariable iASTVariable = (IASTVariable)iterator2.next();
        IASTElaboratedTypeSpecifier cfr_ignored_0 = (IASTElaboratedTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier();
        Assert.assertFalse((boolean)iterator2.hasNext());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier)));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testQualifiedLookup() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace N {");
        stringBuffer.append("   void f () {} \n");
        stringBuffer.append("   class A { }; \n");
        stringBuffer.append("}");
        stringBuffer.append("void main() { N::A * a = new N::A();  a->f(); } ");
        Iterator iterator = this.parse(stringBuffer.toString()).getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTNamespaceDefinition);
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator2.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator2.next()).getTypeSpecifier();
        Assert.assertFalse((boolean)iterator2.hasNext());
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Iterator iterator3 = this.getDeclarations((IASTScope)iASTFunction);
        IASTVariable iASTVariable = (IASTVariable)iterator3.next();
        this.assertAllReferences(5, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTNamespaceDefinition, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
    }

    public void testBug43110() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void x( int y, ... );\n");
        stringBuffer.append("void y( int x... );\n");
        stringBuffer.append("void z(...);");
        Iterator iterator = this.parse(stringBuffer.toString()).getDeclarations();
        while (iterator.hasNext()) {
            Assert.assertTrue((boolean)((IASTFunction)iterator.next()).takesVarArgs());
        }
    }

    public void testBug43110_XRef() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void foo( ... ) {}\n");
        stringBuffer.append("void main( ){ foo( 1 ); }\n");
        Iterator iterator = this.parse(stringBuffer.toString()).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertTrue((boolean)iASTFunction.takesVarArgs());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        stringBuffer = new StringBuffer();
        stringBuffer.append("void foo( ... )   {}\n");
        stringBuffer.append("void foo( int x ) {}\n");
        stringBuffer.append("void main( ){ foo( 1 ); }\n");
        iterator = this.parse(stringBuffer.toString()).getDeclarations();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction3 = (IASTFunction)iterator.next();
        Assert.assertTrue((boolean)iASTFunction2.takesVarArgs());
        Assert.assertFalse((boolean)iASTFunction3.takesVarArgs());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction3)));
        stringBuffer = new StringBuffer();
        stringBuffer.append("void foo( ... )      {}\n");
        stringBuffer.append("void foo( int x = 1) {}\n");
        stringBuffer.append("void main( ){ foo(); }\n");
        iterator = this.parse(stringBuffer.toString()).getDeclarations();
        iASTFunction2 = (IASTFunction)iterator.next();
        iASTFunction3 = (IASTFunction)iterator.next();
        Assert.assertTrue((boolean)iASTFunction2.takesVarArgs());
        Assert.assertFalse((boolean)iASTFunction3.takesVarArgs());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction3)));
        stringBuffer = new StringBuffer();
        stringBuffer.append("void foo( int x ... ) {}\n");
        stringBuffer.append("void main( ){ foo( 1, 2, 'a' ); }\n");
        iterator = this.parse(stringBuffer.toString()).getDeclarations();
        iASTFunction = (IASTFunction)iterator.next();
        Assert.assertTrue((boolean)iASTFunction.takesVarArgs());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testErrorHandling_1() throws Exception {
        Iterator iterator = this.parse("A anA; int x = c; class A {}; A * anotherA = &anA; int b;", false).getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"x");
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertEquals((String)iASTClassSpecifier.getName(), (String)"A");
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable2.getName(), (String)"anotherA");
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable3.getName(), (String)"b");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug44340() throws Exception {
        IASTScope iASTScope = this.parse("class A{ int getX() {return x[1];} int x[10];};", false);
        Iterator iterator = iASTScope.getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTMethod cfr_ignored_0 = (IASTMethod)iterator2.next();
        IASTField iASTField = (IASTField)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField)));
    }

    public void testBug47628() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void h(char) { }\n");
        ((Writer)stringWriter).write("void h(unsigned char) { }\n");
        ((Writer)stringWriter).write("void h(signed char) { }  // not shown in outline, parsed as char\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"h");
        Iterator iterator2 = iASTFunction.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertTrue((boolean)(iASTParameterDeclaration.getTypeSpecifier() instanceof IASTSimpleTypeSpecifier));
        Assert.assertEquals((String)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getTypename(), (String)"char");
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction2.getName(), (String)"h");
        iterator2 = iASTFunction2.getParameters();
        iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertTrue((boolean)(iASTParameterDeclaration.getTypeSpecifier() instanceof IASTSimpleTypeSpecifier));
        Assert.assertEquals((String)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getTypename(), (String)"unsigned char");
        IASTFunction iASTFunction3 = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction3.getName(), (String)"h");
        iterator2 = iASTFunction3.getParameters();
        iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertTrue((boolean)(iASTParameterDeclaration.getTypeSpecifier() instanceof IASTSimpleTypeSpecifier));
        Assert.assertEquals((String)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getTypename(), (String)"signed char");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug47636() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void f( char [] ); \n");
        ((Writer)stringWriter).write("void f( char * ){} \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"f");
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction2.getName(), (String)"f");
        Assert.assertTrue((boolean)iASTFunction2.previouslyDeclared());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug45697() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" int f( bool ); \n");
        ((Writer)stringWriter).write(" int f( char ){ } ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"f");
        Iterator iterator2 = iASTFunction.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertTrue((boolean)(iASTParameterDeclaration.getTypeSpecifier() instanceof IASTSimpleTypeSpecifier));
        Assert.assertEquals((String)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getTypename(), (String)"bool");
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction2.getName(), (String)"f");
        iterator2 = iASTFunction2.getParameters();
        iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertTrue((boolean)(iASTParameterDeclaration.getTypeSpecifier() instanceof IASTSimpleTypeSpecifier));
        Assert.assertEquals((String)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getTypename(), (String)"char");
        Assert.assertFalse((boolean)iASTFunction2.previouslyDeclared());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug54639() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("typedef enum _A { } A, *pA; ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        Assert.assertEquals((String)iASTTypedefDeclaration.getName(), (String)"A");
        IASTEnumerationSpecifier iASTEnumerationSpecifier = (IASTEnumerationSpecifier)iASTTypedefDeclaration.getAbstractDeclarator().getTypeSpecifier();
        Assert.assertEquals((String)iASTEnumerationSpecifier.getName(), (String)"_A");
        IASTTypedefDeclaration iASTTypedefDeclaration2 = (IASTTypedefDeclaration)iterator.next();
        Assert.assertEquals((String)iASTTypedefDeclaration2.getName(), (String)"pA");
        Assert.assertEquals(iASTTypedefDeclaration2.getAbstractDeclarator().getPointerOperators().next(), (Object)ASTPointerOperator.POINTER);
        iASTEnumerationSpecifier = (IASTEnumerationSpecifier)iASTTypedefDeclaration2.getAbstractDeclarator().getTypeSpecifier();
        Assert.assertEquals((String)iASTEnumerationSpecifier.getName(), (String)"_A");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug55163() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void foo() { \n");
        ((Writer)stringWriter).write("   int i, n; \n");
        ((Writer)stringWriter).write("   double di; \n");
        ((Writer)stringWriter).write("   for( i = n - 1, di = (double)( i + i ); i > 0; i-- ){ } \n");
        ((Writer)stringWriter).write("}\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.getDeclarations((IASTScope)iASTFunction);
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        this.assertAllReferences(7, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable, 5), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable3)));
    }

    public void testBug55673() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct Example { int i;  int ( * pfi ) ( int ); }; ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTField cfr_ignored_0 = (IASTField)iterator.next();
        IASTField cfr_ignored_1 = (IASTField)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug54531() throws Exception {
        Iterator iterator = this.parse("typedef enum _A {} A, *pA;").getDeclarations();
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        Assert.assertEquals((String)iASTTypedefDeclaration.getName(), (String)"A");
        IASTTypedefDeclaration iASTTypedefDeclaration2 = (IASTTypedefDeclaration)iterator.next();
        Assert.assertEquals((String)iASTTypedefDeclaration2.getName(), (String)"pA");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug56516() throws Exception {
        Iterator iterator = this.parse("typedef struct blah sb;").getDeclarations();
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        Assert.assertEquals((String)iASTTypedefDeclaration.getName(), (String)"sb");
        Assert.assertFalse((boolean)iterator.hasNext());
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTTypedefDeclaration.getAbstractDeclarator().getTypeSpecifier();
        Assert.assertEquals((String)iASTElaboratedTypeSpecifier.getName(), (String)"blah");
        Assert.assertEquals((Object)iASTElaboratedTypeSpecifier.getClassKind(), (Object)ASTClassKind.STRUCT);
    }

    public void testBug53786() throws Exception {
        Iterator iterator = this.parse("struct Example {  struct Data * data; };").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTClassSpecifier.getName(), (String)"Example");
        Assert.assertEquals((Object)iASTClassSpecifier.getClassKind(), (Object)ASTClassKind.STRUCT);
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTField iASTField = (IASTField)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertEquals((String)iASTField.getName(), (String)"data");
    }

    public void testBug54029() throws Exception {
        Iterator iterator = this.parse("typedef int T; T i;").getDeclarations();
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        Assert.assertEquals((String)iASTTypedefDeclaration.getName(), (String)"T");
        Assert.assertTrue((boolean)(iASTTypedefDeclaration.getAbstractDeclarator().getTypeSpecifier() instanceof IASTSimpleTypeSpecifier));
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTTypedefDeclaration.getAbstractDeclarator().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.INT);
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTVariable.getName(), (String)"i");
        Assert.assertEquals((String)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getTypename(), (String)"T");
        Assert.assertNotNull((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier());
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTTypedefDeclaration);
    }

    public void testBug47625() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct s { int num; }; ");
        ((Writer)stringWriter).write("namespace ns{ ");
        ((Writer)stringWriter).write("   struct s { double num; };");
        ((Writer)stringWriter).write("   s inner = { 3.14 };");
        ((Writer)stringWriter).write("   ::s outer = { 42 };");
        ((Writer)stringWriter).write("}");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        iterator = this.getDeclarations((IASTScope)iASTNamespaceDefinition);
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2)));
    }

    public void testBug57754() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct X {          ");
        ((Writer)stringWriter).write("   typedef int T;   ");
        ((Writer)stringWriter).write("   void f( T );     ");
        ((Writer)stringWriter).write("};                  ");
        ((Writer)stringWriter).write("void X::f( T ) { }  ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        Assert.assertTrue((boolean)iASTMethod.previouslyDeclared());
        iterator = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTTypedefDeclaration, 2)));
    }

    public void testBug57800() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class G2 { int j; };");
        ((Writer)stringWriter).write("typedef G2 AltG2;");
        ((Writer)stringWriter).write("class AltG3 : AltG2 {  int x;};");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = iASTClassSpecifier.getBaseClauses();
        IASTBaseSpecifier iASTBaseSpecifier = (IASTBaseSpecifier)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertEquals((Object)iASTBaseSpecifier.getParentClassSpecifier(), (Object)iASTTypedefDeclaration);
    }

    public void testBug46246() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct A {                 ");
        ((Writer)stringWriter).write("   struct B { int ab; } b; ");
        ((Writer)stringWriter).write("   int a;                  ");
        ((Writer)stringWriter).write("};                         ");
        ((Writer)stringWriter).write("struct A a1;               ");
        ((Writer)stringWriter).write("struct B b1;               ");
        Iterator iterator = this.parse(((Object)stringWriter).toString(), true, ParserLanguage.C).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        iterator = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTField iASTField = (IASTField)iterator.next();
        IASTField cfr_ignored_2 = (IASTField)iterator.next();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)iASTField.getAbstractDeclaration().getTypeSpecifier();
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2)));
    }

    public void testBug45235() throws Exception {
        Iterator iterator = this.parse("class A { friend class B; friend void f(); }; ").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        iterator = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertTrue((boolean)iASTAbstractTypeSpecifierDeclaration.isFriendDeclaration());
        Assert.assertTrue((boolean)iASTFunction.isFriend());
    }

    public void testBug57791() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" void f() {                  ");
        ((Writer)stringWriter).write("    struct astruct astruct;  ");
        ((Writer)stringWriter).write("    astruct.foo++;           ");
        ((Writer)stringWriter).write(" }");
        this.parse(((Object)stringWriter).toString(), true, ParserLanguage.C);
    }

    public void testBug44249() throws Exception {
        Iterator iterator = this.parse("class SD_01 { public:\n\tvoid SD_01::f_SD_01();};").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTMethod.getName(), (String)"f_SD_01");
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier)));
    }

    public void testBug59149() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{ friend class B; friend class B; };");
        ((Writer)stringWriter).write("class B{ };");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTClassSpecifier cfr_ignored_1 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
    }

    public void testBug59302() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A { class N{}; };         ");
        ((Writer)stringWriter).write("class B { friend class A::N; }; ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        iterator = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTClassSpecifier iASTClassSpecifier3 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertFalse((boolean)iASTClassSpecifier.getFriends().hasNext());
        Assert.assertEquals(iASTClassSpecifier2.getFriends().next(), (Object)iASTClassSpecifier3);
    }

    public void testULong() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#ifndef ASMINCLUDE\n");
        ((Writer)stringWriter).write("typedef unsigned short         ushort;\n");
        ((Writer)stringWriter).write("typedef volatile unsigned long semaphore;\n");
        ((Writer)stringWriter).write("typedef unsigned long          ulong;\n");
        ((Writer)stringWriter).write("#ifndef _NO_LONGLONG\n");
        ((Writer)stringWriter).write("typedef long long              longlong;\n");
        ((Writer)stringWriter).write("typedef unsigned long long     ulonglong;\n");
        ((Writer)stringWriter).write("#endif  /* _NO_LONGLONG */\n");
        ((Writer)stringWriter).write("#endif  /*  ASMINCLUDE  */\n");
        ((Writer)stringWriter).write("typedef struct section_type_ {\n");
        ((Writer)stringWriter).write("ulong source;\n");
        ((Writer)stringWriter).write("ulong dest;\n");
        ((Writer)stringWriter).write("ulong bytes;\n");
        ((Writer)stringWriter).write("} section_type;\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTypedefDeclaration cfr_ignored_0 = (IASTTypedefDeclaration)iterator.next();
        IASTTypedefDeclaration cfr_ignored_1 = (IASTTypedefDeclaration)iterator.next();
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        IASTTypedefDeclaration cfr_ignored_2 = (IASTTypedefDeclaration)iterator.next();
        IASTTypedefDeclaration cfr_ignored_3 = (IASTTypedefDeclaration)iterator.next();
        IASTTypedefDeclaration iASTTypedefDeclaration2 = (IASTTypedefDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTypedefDeclaration2.getAbstractDeclarator().getTypeSpecifier();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTField iASTField = (IASTField)iterator2.next();
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTField.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTTypedefDeclaration);
        IASTField iASTField2 = (IASTField)iterator2.next();
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTField2.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTTypedefDeclaration);
        IASTField iASTField3 = (IASTField)iterator2.next();
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTField3.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTTypedefDeclaration);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug47926() throws Exception {
        Iterator iterator = this.parse("void f() {} class A {}; void main() { A * a = new A(); a->f();\t}", false).getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.getDeclarations((IASTScope)iASTFunction);
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
    }

    public void testBug50984_ASTMethod_getOwnerClassSpecifier_ClassCastException() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < typename _OutIter >                                 ");
        ((Writer)stringWriter).write("class num_put {                                                ");
        ((Writer)stringWriter).write("   typedef _OutIter iter_type;                                 ");
        ((Writer)stringWriter).write("   template< typename _ValueT >                                ");
        ((Writer)stringWriter).write("    iter_type _M_convert_float( iter_type );                   ");
        ((Writer)stringWriter).write("};                                                             ");
        ((Writer)stringWriter).write("template < typename _OutIter >                                 ");
        ((Writer)stringWriter).write("template < typename _ValueT  >                                 ");
        ((Writer)stringWriter).write("_OutIter num_put<_OutIter>::_M_convert_float( _OutIter ) { }   ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTTemplateDeclaration iASTTemplateDeclaration2 = (IASTTemplateDeclaration)iterator.next();
        IASTMethod iASTMethod = (IASTMethod)iASTTemplateDeclaration2.getOwnedDeclaration();
        Assert.assertEquals((Object)iASTMethod.getOwnerClassSpecifier(), (Object)iASTClassSpecifier);
    }

    public void testGloballyQualifiedUsingDeclaration() throws Exception {
        Iterator iterator = this.parse("int iii; namespace N { using ::iii; }").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        IASTUsingDeclaration cfr_ignored_0 = (IASTUsingDeclaration)this.getDeclarations((IASTScope)iASTNamespaceDefinition).next();
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
        Iterator iterator2 = this.callback.getReferences().iterator();
        Assert.assertEquals((Object)((IASTReference)iterator2.next()).getReferencedElement(), (Object)iASTVariable);
    }

    public void test57513_new() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{ A(); A( int ); };   \n");
        ((Writer)stringWriter).write(" void f() {                  \n");
        ((Writer)stringWriter).write("    A * a1 = new A;          \n");
        ((Writer)stringWriter).write("    A * a2 = new(1)A();      \n");
        ((Writer)stringWriter).write("    A * a3 = new A( 1 );     \n");
        ((Writer)stringWriter).write("}                            \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        IASTMethod iASTMethod2 = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTMethod, 2, false, false));
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTMethod2, 1, false, false));
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 3, false, false));
    }

    public void test57513_NoConstructor() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{  };   \n");
        ((Writer)stringWriter).write(" void f() {                  \n");
        ((Writer)stringWriter).write("    A * a1 = new A;          \n");
        ((Writer)stringWriter).write("}                            \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2, false, false));
    }

    public void test57513_ctorinit() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{ A(); A( A * ); };   \n");
        ((Writer)stringWriter).write("class B : public A { B(); }; \n");
        ((Writer)stringWriter).write("B::B():A( new A ){}          \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTMethod cfr_ignored_1 = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        IASTMethod iASTMethod2 = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTMethod, 1, false, false));
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTMethod2, 1, false, false));
        this.assertReferenceTask(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2, false, false));
    }

    public void test575513_qualified() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace Foo{                     ");
        ((Writer)stringWriter).write("   class Bar{ public : Bar(); };   ");
        ((Writer)stringWriter).write("}                                  ");
        ((Writer)stringWriter).write("void main(){                       ");
        ((Writer)stringWriter).write("  Foo::Bar * bar = new Foo::Bar(); ");
        ((Writer)stringWriter).write("}                                  ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        iterator = this.getDeclarations((IASTScope)iASTNamespaceDefinition);
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        iterator = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTNamespaceDefinition, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 1), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTMethod, 1)));
    }

    public void testBug60944() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("typedef int OurInt;\n");
        ((Writer)stringWriter).write("class A { int x; };\n");
        ((Writer)stringWriter).write("typedef A AnotherA;\n");
        ((Writer)stringWriter).write("typedef AnotherA SecondA;\n");
        ((Writer)stringWriter).write("typedef OurInt AnotherInt;\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        Assert.assertTrue((boolean)(iASTTypedefDeclaration.getFinalTypeSpecifier() instanceof IASTSimpleTypeSpecifier));
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTTypedefDeclaration.getFinalTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.INT);
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTTypedefDeclaration iASTTypedefDeclaration2 = (IASTTypedefDeclaration)iterator.next();
        Assert.assertEquals((Object)iASTTypedefDeclaration2.getFinalTypeSpecifier(), (Object)iASTClassSpecifier);
        IASTTypedefDeclaration iASTTypedefDeclaration3 = (IASTTypedefDeclaration)iterator.next();
        Assert.assertEquals((Object)iASTTypedefDeclaration3.getFinalTypeSpecifier(), (Object)iASTClassSpecifier);
        IASTTypedefDeclaration iASTTypedefDeclaration4 = (IASTTypedefDeclaration)iterator.next();
        Assert.assertTrue((boolean)(iASTTypedefDeclaration4.getFinalTypeSpecifier() instanceof IASTSimpleTypeSpecifier));
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTTypedefDeclaration4.getFinalTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.INT);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testDestructorReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class ABC {\n");
        ((Writer)stringWriter).write(" public:\n");
        ((Writer)stringWriter).write(" ~ABC(){ }\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("int main() { ABC * abc = new ABC();\n");
        ((Writer)stringWriter).write("abc->~ABC();\n");
        ((Writer)stringWriter).write("}\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTFunction iASTFunction2 = (IASTFunction)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        Iterator iterator3 = this.getDeclarations((IASTScope)iASTFunction);
        IASTVariable iASTVariable = (IASTVariable)iterator3.next();
        Assert.assertFalse((boolean)iterator3.hasNext());
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction2)));
    }

    public void testBug39676_tough() throws Exception {
        this.parse("int widths[] = { [0 ... 9] = 1, [10 ... 99] = 2, [100] = 3 };", true, ParserLanguage.C);
    }

    public void testBug60939() throws Exception {
        int n = 0;
        while (n < 2) {
            StringWriter stringWriter = new StringWriter();
            ((Writer)stringWriter).write("namespace ABC { class DEF { }; }\n");
            if (n == 0) {
                ((Writer)stringWriter).write("using namespace ABC;\n");
            } else {
                ((Writer)stringWriter).write("using ABC::DEF;\n");
            }
            ((Writer)stringWriter).write("class GHI : public DEF { };");
            Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
            IASTNamespaceDefinition cfr_ignored_0 = (IASTNamespaceDefinition)iterator.next();
            if (n == 0) {
                Assert.assertTrue((boolean)(iterator.next() instanceof IASTUsingDirective));
            } else {
                Assert.assertTrue((boolean)(iterator.next() instanceof IASTUsingDeclaration));
            }
            IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
            Iterator iterator2 = iASTClassSpecifier.getBaseClauses();
            IASTBaseSpecifier iASTBaseSpecifier = (IASTBaseSpecifier)iterator2.next();
            IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)iASTBaseSpecifier.getParentClassSpecifier();
            String[] stringArray = new String[]{"ABC", "DEF"};
            this.qualifiedNamesEquals(iASTClassSpecifier2.getFullyQualifiedName(), stringArray);
            ++n;
        }
    }

    public void testBug64010() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" #define ONE\telse if (0) { } \n");
        ((Writer)stringWriter).write(" #define TEN\tONE ONE ONE ONE ONE ONE ONE ONE ONE ONE \n ");
        ((Writer)stringWriter).write(" #define HUN\tTEN TEN TEN TEN TEN TEN TEN TEN TEN TEN \n ");
        ((Writer)stringWriter).write(" #define THOU\tHUN HUN HUN HUN HUN HUN HUN HUN HUN HUN \n");
        ((Writer)stringWriter).write("void foo()                                                ");
        ((Writer)stringWriter).write("{                                                         ");
        ((Writer)stringWriter).write("   if (0) { }                                             ");
        ((Writer)stringWriter).write("   /* 11,000 else if's.  */                               ");
        ((Writer)stringWriter).write("   THOU THOU THOU THOU THOU THOU THOU THOU THOU THOU THOU ");
        ((Writer)stringWriter).write("}                                                         ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
    }

    public void testBug64271() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("typedef int DWORD;\n");
        ((Writer)stringWriter).write("typedef char BYTE;\n");
        ((Writer)stringWriter).write("#define MAKEFOURCC(ch0, ch1, ch2, ch3)                              \\\n");
        ((Writer)stringWriter).write("((DWORD)(BYTE)(ch0) | ((DWORD)(BYTE)(ch1) << 8) |       \\\n");
        ((Writer)stringWriter).write("((DWORD)(BYTE)(ch2) << 16) | ((DWORD)(BYTE)(ch3) << 24 ))\n");
        ((Writer)stringWriter).write("enum e {\n");
        ((Writer)stringWriter).write("blah1 = 5,\n");
        ((Writer)stringWriter).write("blah2 = MAKEFOURCC('a', 'b', 'c', 'd'),\n");
        ((Writer)stringWriter).write("blah3\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("e mye = blah;\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug47752() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class BBC\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("int x;\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("void func( BBC bar )\n");
        ((Writer)stringWriter).write("try\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("}\n");
        ((Writer)stringWriter).write("catch ( BBC error )\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("\t\t  //... error handling code ...\n");
        ((Writer)stringWriter).write("}\n");
        this.parse(((Object)stringWriter).toString());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)2);
    }

    public void testBug61972() throws Exception {
        this.parse("#define DEF1(A1) A1\n#define DEF2     DEF1(DEF2)\nDEF2;", false);
    }

    public void testBug65569() throws Exception {
        this.parse("class Sample;\nstruct Sample { /* ... */ };");
    }

    public void testBug64268() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define BODY \\\n");
        ((Writer)stringWriter).write("for (;;) {\t \\\n");
        ((Writer)stringWriter).write("/* this multi-line comment messes \\\n");
        ((Writer)stringWriter).write("up the parser.  */ }\n");
        ((Writer)stringWriter).write("\tvoid abc() {\n");
        ((Writer)stringWriter).write("BODY\n");
        ((Writer)stringWriter).write("}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug67622() throws Exception {
        this.parse("const char * x = __FILE__;");
    }

    public void testBug67680() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template < class T> class Base {};                  \n");
        ((Writer)stringWriter).write("class Derived : public Base, Base<int>, foo {};     \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString(), false).getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        iterator = iASTClassSpecifier2.getBaseClauses();
        IASTBaseSpecifier iASTBaseSpecifier = (IASTBaseSpecifier)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((Object)iASTBaseSpecifier.getParentClassSpecifier(), (Object)iASTClassSpecifier);
    }

    public void testTypeIDSignature() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.parse("int * v = (int*)0;").getDeclarations().next();
        IASTTypeId iASTTypeId = iASTVariable.getInitializerClause().getAssigmentExpression().getTypeId();
        Assert.assertEquals((String)iASTTypeId.getFullSignature(), (String)"int *");
    }

    public void testUnaryAmperCast() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void f( char * );              \r\n ");
        ((Writer)stringWriter).write("void f( char   );              \n ");
        ((Writer)stringWriter).write("void main() {                  \n ");
        ((Writer)stringWriter).write("   char * t = new char [ 5 ];  \n ");
        ((Writer)stringWriter).write("   f( &t[1] );                 \n ");
        ((Writer)stringWriter).write("}                              \n ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)this.getDeclarations((IASTScope)iASTFunction2).next();
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction, 1, false, false), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
    }

    public void testBug68235() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" struct xTag { int x; };               ");
        ((Writer)stringWriter).write(" typedef xTag xType;                   ");
        ((Writer)stringWriter).write(" typedef struct yTag { int x; } yType; ");
        ((Writer)stringWriter).write(" class C1 { xType x; yType y; };       ");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        IASTSimpleTypeSpecifier iASTSimpleTypeSpecifier = (IASTSimpleTypeSpecifier)iASTTypedefDeclaration.getAbstractDeclarator().getTypeSpecifier();
        Assert.assertEquals((Object)iASTSimpleTypeSpecifier.getTypeSpecifier(), (Object)iASTClassSpecifier);
        IASTTypedefDeclaration iASTTypedefDeclaration2 = (IASTTypedefDeclaration)iterator.next();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)iASTTypedefDeclaration2.getAbstractDeclarator().getTypeSpecifier();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.getDeclarations((IASTScope)iASTClassSpecifier2);
        IASTField iASTField = (IASTField)iterator.next();
        IASTField iASTField2 = (IASTField)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        IASTSimpleTypeSpecifier iASTSimpleTypeSpecifier2 = (IASTSimpleTypeSpecifier)iASTField.getAbstractDeclaration().getTypeSpecifier();
        Assert.assertEquals((Object)iASTSimpleTypeSpecifier2.getTypeSpecifier(), (Object)iASTTypedefDeclaration);
        iASTSimpleTypeSpecifier2 = (IASTSimpleTypeSpecifier)iASTField2.getAbstractDeclaration().getTypeSpecifier();
        Assert.assertEquals((Object)iASTSimpleTypeSpecifier2.getTypeSpecifier(), (Object)iASTTypedefDeclaration2);
    }

    public void testBug60407() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct ZZZ { int x, y, z; };\r\n");
        ((Writer)stringWriter).write("typedef struct ZZZ _FILE;\n");
        ((Writer)stringWriter).write("typedef _FILE FILE;\n");
        ((Writer)stringWriter).write("static void static_function(FILE * lcd){}\n");
        ((Writer)stringWriter).write("int\tmain(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("FILE * file = 0;\n");
        ((Writer)stringWriter).write("static_function( file );\n");
        ((Writer)stringWriter).write("return 0;\n");
        ((Writer)stringWriter).write("}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug68623() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A {                         \n");
        ((Writer)stringWriter).write("   A();                           \n");
        ((Writer)stringWriter).write("   class sub{};                   \n");
        ((Writer)stringWriter).write("   sub * x;                       \n");
        ((Writer)stringWriter).write("};                                \n");
        ((Writer)stringWriter).write("A::A() : x( (sub *) 0 ) {}        \n");
        this.parse(((Object)stringWriter).toString());
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A {                         \n");
        ((Writer)stringWriter).write("   A() : x (0) {}                 \n");
        ((Writer)stringWriter).write("   int x;                         \n");
        ((Writer)stringWriter).write("};                                \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        iterator = iASTClassSpecifier.getDeclarations();
        IASTMethod cfr_ignored_0 = (IASTMethod)iterator.next();
        IASTField iASTField = (IASTField)iterator.next();
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField)));
    }

    public void testBug69798() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("enum Flags { FLAG1, FLAG2 };                          \n");
        ((Writer)stringWriter).write("int f() { int a, b;  b = ( a ? FLAG1 : 0 ) | FLAG2; } \n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug69662() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A { operator float * (); };  \n");
        ((Writer)stringWriter).write("A::operator float * () { }         \n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug68528() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N526026\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("template <typename T>\n");
        ((Writer)stringWriter).write("class T526026\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("typedef int diff;\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("\n");
        ((Writer)stringWriter).write("template<typename T>\n");
        ((Writer)stringWriter).write("inline T526026< T >\n");
        ((Writer)stringWriter).write("operator+(typename T526026<T>::diff d, const T526026<T> & x )\n");
        ((Writer)stringWriter).write("{ return T526026< T >(); }\n");
        ((Writer)stringWriter).write("}\n");
        this.parse(((Object)stringWriter).toString(), false);
    }

    public void testBug71094() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("using namespace DOESNOTEXIST;\n");
        ((Writer)stringWriter).write("class A { int x; };\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString(), false).getDeclarations();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)(iterator.next() instanceof IASTAbstractTypeSpecifierDeclaration));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testPredefinedSymbol_bug70928() throws Exception {
        Iterator iterator = this.parse("typedef int size_t; \n int __cdecl foo(); \n").getDeclarations();
        IASTTypedefDeclaration cfr_ignored_0 = (IASTTypedefDeclaration)iterator.next();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug73652() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define DoSuperMethodA IDoSuperMethodA\n");
        stringWriter.write("#define IDoSuperMethodA(a,b,c) IIntuition->IDoSuperMethodA(a,b,c)\n");
        stringWriter.write("void hang(void)\n");
        stringWriter.write("{\n");
        stringWriter.write("DoSuperMethodA(0,0,0);\n");
        stringWriter.write("}\n");
        this.parse(stringWriter.toString(), false);
    }

    public void testBug73428() throws Exception {
        this.parse("namespace {  }");
        Assert.assertTrue((boolean)this.callback.problems.isEmpty());
        this.parse("namespace {  };");
        Assert.assertTrue((boolean)this.callback.problems.isEmpty());
        this.parse("namespace {  int abc; };");
        Assert.assertTrue((boolean)this.callback.problems.isEmpty());
        this.parse("namespace {  int abc; }");
        Assert.assertTrue((boolean)this.callback.problems.isEmpty());
    }

    public void testBug73615() throws Exception {
        int n = 0;
        while (n < 2) {
            StringWriter stringWriter = new StringWriter();
            if (n == 0) {
                stringWriter.write("class B;\n");
            }
            stringWriter.write("class A { A( B * ); };\n");
            if (n == 0) {
                this.parse(stringWriter.toString());
            } else {
                this.parse(stringWriter.toString(), false);
            }
            ++n;
        }
    }

    public void testBug74180() throws Exception {
        this.parse("enum DHCPFOBoolean { false, true } additionalHB, more_payload; \n", true, ParserLanguage.C);
        Assert.assertTrue((boolean)this.callback.problems.isEmpty());
    }

    public void testBug72691() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("typedef int * PINT; \n");
        stringWriter.write("typedef int * PINT; \n");
        stringWriter.write("PINT pint;          \n");
        Iterator iterator = this.parse(stringWriter.toString()).getDeclarations();
        Assert.assertTrue((boolean)(iterator.next() instanceof IASTTypedefDeclaration));
        Assert.assertTrue((boolean)(iterator.next() instanceof IASTTypedefDeclaration));
        Assert.assertTrue((boolean)(iterator.next() instanceof IASTVariable));
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)this.callback.problems.isEmpty());
    }

    public void testBug72691_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("typedef int * PINT;    \n");
        stringWriter.write("namespace N {          \n");
        stringWriter.write("   typedef int * PINT; \n");
        stringWriter.write("}                      \n");
        stringWriter.write("using namespace N;     \n");
        stringWriter.write("PINT pint;             \n");
        this.parse(stringWriter.toString());
    }

    public void testBug74328() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int\n");
        ((Writer)stringWriter).write("main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("\tchar *sign;\n");
        ((Writer)stringWriter).write("sign = \"\"; // IProblem generated here, syntax error\n");
        ((Writer)stringWriter).write("return argc;\n");
        ((Writer)stringWriter).write("}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug71733() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void foo( int );\n");
        ((Writer)stringWriter).write("#define BLAH() \\\n");
        ((Writer)stringWriter).write("  foo ( /*  slash / is misinterpreted as end of comment */ \\\n");
        ((Writer)stringWriter).write("    4 );\n");
        ((Writer)stringWriter).write("int f() { BLAH() }\n");
        this.parse(((Object)stringWriter).toString());
        Assert.assertEquals((int)this.callback.getReferences().size(), (int)1);
    }

    public void testBug69526() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("unsigned inkernel;\n");
        ((Writer)stringWriter).write("#define lock_kernel() (inkernel |= 0x01)");
        ((Writer)stringWriter).write("int main(int argc, char **argv) {");
        ((Writer)stringWriter).write("lock_kernel();");
        ((Writer)stringWriter).write("}");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug69454() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define CATCH_ALL_EXCEPTIONS()                         \\\n");
        ((Writer)stringWriter).write("   catch( Exception &ex ) { handleException( ex ); }   \\\n");
        ((Writer)stringWriter).write("   catch( ... )           { handleException();    }      \n");
        ((Writer)stringWriter).write("class Exception;                                         \n");
        ((Writer)stringWriter).write("void handleException( Exception & ex ) {}                \n");
        ((Writer)stringWriter).write("void handleException() {}                                \n");
        ((Writer)stringWriter).write("void f() {                                               \n");
        ((Writer)stringWriter).write("   try { int i; }                                        \n");
        ((Writer)stringWriter).write("   CATCH_ALL_EXCEPTIONS();                               \n");
        ((Writer)stringWriter).write("}                                                        \n");
        this.parse(((Object)stringWriter).toString());
        Assert.assertFalse((boolean)this.callback.getProblems().hasNext());
    }

    public void testBug72692A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("extern double pow(double, double);\n");
        ((Writer)stringWriter).write("extern double pow2(double, double){}\n");
        ((Writer)stringWriter).write("namespace DS {\n");
        ((Writer)stringWriter).write("using ::pow;\n");
        ((Writer)stringWriter).write("using ::pow2;\n");
        ((Writer)stringWriter).write("}\n");
        ((Writer)stringWriter).write("using DS::pow;\n");
        ((Writer)stringWriter).write("using DS::pow2;\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug72692B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("extern double pow(double, double);\n");
        ((Writer)stringWriter).write("namespace DS {\n");
        ((Writer)stringWriter).write("using ::pow;\n");
        ((Writer)stringWriter).write("inline float pow(float __x, float __y)\n");
        ((Writer)stringWriter).write("{ return ::pow(static_cast<double>(__x), static_cast<double>(__y)); }\n");
        ((Writer)stringWriter).write("}\n");
        ((Writer)stringWriter).write("using namespace DS;\n");
        ((Writer)stringWriter).write("float foo() { double d1 = 3.0, d2 = 4.0; return pow(d1, d2); }");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug72692C() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("extern double pow(double, double){}\n");
        ((Writer)stringWriter).write("namespace DS {\n");
        ((Writer)stringWriter).write("using ::pow;\n");
        ((Writer)stringWriter).write("}\n");
        ((Writer)stringWriter).write("using DS::pow;\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug74575A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("double pow(double, double);\n");
        ((Writer)stringWriter).write("float pow(float __x, float __y)\n");
        ((Writer)stringWriter).write("{ return 0; }\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTFunction2.getName(), (String)"pow");
        Assert.assertEquals((String)iASTFunction.getName(), (String)"pow");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTFunction.getReturnType().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.DOUBLE);
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTFunction2.getReturnType().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.FLOAT);
        Assert.assertFalse((boolean)iASTFunction.hasFunctionBody());
        Assert.assertTrue((boolean)iASTFunction2.hasFunctionBody());
    }

    public void testBug75338() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Thrown { };\n");
        ((Writer)stringWriter).write("void foo() throw( Thrown );");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        Assert.assertTrue((boolean)(iterator.next() instanceof IASTAbstractTypeSpecifierDeclaration));
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        IASTExceptionSpecification iASTExceptionSpecification = iASTFunction.getExceptionSpec();
        Assert.assertNotNull((Object)iASTExceptionSpecification);
        Iterator iterator2 = iASTExceptionSpecification.getTypeIds();
        Assert.assertTrue((boolean)iterator2.hasNext());
        IASTTypeId iASTTypeId = (IASTTypeId)iterator2.next();
        Assert.assertEquals((String)iASTTypeId.getTypeOrClassName(), (String)"Thrown");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug75532() throws Exception {
        Iterator iterator;
        try {
            try {
                StringWriter stringWriter = new StringWriter();
                ((Writer)stringWriter).write("#if 2147483647 == 0x7fffffff\n");
                ((Writer)stringWriter).write("#error This was equal, but not for the eclipse.\n");
                ((Writer)stringWriter).write("#endif\n");
                ((Writer)stringWriter).write("#if 010 == 8\n");
                ((Writer)stringWriter).write("#error octal test\n");
                ((Writer)stringWriter).write("#endif\n");
                this.parse(((Object)stringWriter).toString());
                Assert.assertTrue((boolean)false);
            }
            catch (ParserException parserException) {}
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            Iterator iterator2 = this.callback.getProblems();
            Assert.assertTrue((boolean)iterator2.hasNext());
            Object e = iterator2.next();
            Assert.assertTrue((boolean)(e instanceof IProblem));
            IProblem iProblem = (IProblem)e;
            Assert.assertTrue((iProblem.getArguments().indexOf("This was equal, but not for the eclipse") >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)iterator2.hasNext());
            e = iterator2.next();
            Assert.assertTrue((boolean)(e instanceof IProblem));
            iProblem = (IProblem)e;
            Assert.assertTrue((iProblem.getArguments().indexOf("octal test") >= 0 ? 1 : 0) != 0);
            throw throwable;
        }
        {
            Object var2_4 = null;
            iterator = this.callback.getProblems();
        }
        Assert.assertTrue((boolean)iterator.hasNext());
        Object e = iterator.next();
        Assert.assertTrue((boolean)(e instanceof IProblem));
        IProblem iProblem = (IProblem)e;
        Assert.assertTrue((iProblem.getArguments().indexOf("This was equal, but not for the eclipse") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iterator.hasNext());
        e = iterator.next();
        Assert.assertTrue((boolean)(e instanceof IProblem));
        iProblem = (IProblem)e;
        Assert.assertTrue((iProblem.getArguments().indexOf("octal test") >= 0 ? 1 : 0) != 0);
    }

    public void testBug74847() throws Exception {
        String string = "class A : public FOO {};";
        Iterator iterator = this.parse(string, false).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertFalse((boolean)iASTClassSpecifier.getBaseClauses().hasNext());
        iterator = this.callback.getProblems();
        IProblem iProblem = (IProblem)iterator.next();
        Assert.assertEquals((int)iProblem.getID(), (int)0x8000002);
        Assert.assertEquals((int)iProblem.getSourceStart(), (int)string.indexOf("FOO"));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug76696() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" void f(){       \n");
        ((Writer)stringWriter).write("    if( A a) {   \n");
        ((Writer)stringWriter).write("    } else {     \n");
        ((Writer)stringWriter).write("    }\t           \n");
        ((Writer)stringWriter).write(" }               \n");
        this.parse(((Object)stringWriter).toString(), false);
        Iterator iterator = this.callback.getProblems();
        IProblem iProblem = (IProblem)iterator.next();
        Assert.assertEquals((int)0x4000001, (int)iProblem.getID());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug74069() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int f() {                \n");
        ((Writer)stringWriter).write("   int a, b, c;          \n");
        ((Writer)stringWriter).write("   if( a < b )           \n");
        ((Writer)stringWriter).write("      if( b < c )        \n");
        ((Writer)stringWriter).write("         return b;       \n");
        ((Writer)stringWriter).write("      else if ( a < c )  \n");
        ((Writer)stringWriter).write("         return c;       \n");
        ((Writer)stringWriter).write("      else               \n");
        ((Writer)stringWriter).write("         return a;       \n");
        ((Writer)stringWriter).write("   else if( a < c )      \n");
        ((Writer)stringWriter).write("      return a;          \n");
        ((Writer)stringWriter).write("   else if( b < c )      \n");
        ((Writer)stringWriter).write("      return c;          \n");
        ((Writer)stringWriter).write("   else                  \n");
        ((Writer)stringWriter).write("      return b;          \n");
        ((Writer)stringWriter).write("}                        \n");
        this.parse(((Object)stringWriter).toString());
        Iterator iterator = this.callback.getProblems();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug77805() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#if X // Do something only if X is true\n");
        ((Writer)stringWriter).write("/* some statements */\n");
        ((Writer)stringWriter).write("#endif\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug77821() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("typedef struct { /* ... */ }TYPE;\n");
        ((Writer)stringWriter).write("void ptrArith(const TYPE* pType) {\n");
        ((Writer)stringWriter).write("TYPE *temp = 0;\n");
        ((Writer)stringWriter).write("temp = (TYPE*)(pType + 1); /* Parser error is here */\n}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug77009() throws Exception {
        Iterator iterator = this.parse("int foo(volatile int &);\n").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Iterator iterator2 = iASTFunction.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertEquals((String)ASTUtil.getType((IASTAbstractDeclaration)iASTParameterDeclaration), (String)"volatile int&");
    }

    public void testBug77281() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void fun2(float a, float b) {}\n");
        ((Writer)stringWriter).write("int main() { fun2(0.24f, 0.25f); }\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug77921() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void f()\n{\n");
        ((Writer)stringWriter).write("static float v0[] = { -1.0f, -1.0f,  1.0f };\n}\n");
        this.parse(((Object)stringWriter).toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug76763() throws Exception {
        Iterator iterator;
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#error oops!");
        try {
            try {
                this.parse(((Object)stringWriter).toString());
            }
            catch (ParserException parserException) {}
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            Iterator iterator2 = this.callback.getProblems();
            Assert.assertTrue((boolean)iterator2.hasNext());
            Object e = iterator2.next();
            Assert.assertTrue((boolean)(e instanceof IProblem));
            IProblem iProblem = (IProblem)e;
            Assert.assertTrue((boolean)new String(iProblem.getArguments()).equals("oops!"));
            Assert.assertFalse((boolean)iterator2.hasNext());
            throw throwable;
        }
        {
            Object var2_4 = null;
            iterator = this.callback.getProblems();
        }
        Assert.assertTrue((boolean)iterator.hasNext());
        Object e = iterator.next();
        Assert.assertTrue((boolean)(e instanceof IProblem));
        IProblem iProblem = (IProblem)e;
        Assert.assertTrue((boolean)new String(iProblem.getArguments()).equals("oops!"));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug71317A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void f();\n");
        ((Writer)stringWriter).write("namespace NS {\n");
        ((Writer)stringWriter).write("using ::f;\n");
        ((Writer)stringWriter).write("using ::f;\n}");
        this.parse(((Object)stringWriter).toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug71317B() throws Exception {
        Iterator iterator;
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void f();\n");
        ((Writer)stringWriter).write("namespace NS {\n");
        ((Writer)stringWriter).write("void f();\n");
        ((Writer)stringWriter).write("using ::f;\n}");
        try {
            try {
                this.parse(((Object)stringWriter).toString());
                Assert.assertTrue((boolean)false);
            }
            catch (ParserException parserException) {}
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            Iterator iterator2 = this.callback.getProblems();
            Assert.assertTrue((boolean)iterator2.hasNext());
            Object e = iterator2.next();
            Assert.assertTrue((boolean)(e instanceof IProblem));
            IProblem iProblem = (IProblem)e;
            Assert.assertEquals((int)iProblem.getSourceLineNumber(), (int)4);
            throw throwable;
        }
        {
            Object var2_4 = null;
            iterator = this.callback.getProblems();
        }
        Assert.assertTrue((boolean)iterator.hasNext());
        Object e = iterator.next();
        Assert.assertTrue((boolean)(e instanceof IProblem));
        IProblem iProblem = (IProblem)e;
        Assert.assertEquals((int)iProblem.getSourceLineNumber(), (int)4);
    }

    public void testBug77097() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define SOME_MACRO() { \\\r\n");
        ((Writer)stringWriter).write("printf(\"Hello World\"); \\\r\n");
        ((Writer)stringWriter).write("printf(\"Good morning\"); \\\r\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug77276() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#if (!defined(OS_LIBMODE_R) && !defined(OS_LIBMODE_RP) && \\\r\n");
        ((Writer)stringWriter).write("!defined(OS_LIBMODE_T))\r\n");
        ((Writer)stringWriter).write("#define OS_LIBMODE_DP\r\n");
        ((Writer)stringWriter).write("#endif\r\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug78165() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct Node {\n");
        ((Writer)stringWriter).write("struct Node* Next; // OK: Refers to Node at global scope\n");
        ((Writer)stringWriter).write("struct Data* Data; // OK: Declares type Data at global scope and member Data\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("struct Data {\n");
        ((Writer)stringWriter).write("struct Node* Node; // OK: Refers to Node at global scope\n");
        ((Writer)stringWriter).write("friend struct Glob; // OK: Refers to (as yet) undeclared Glob at global scope.\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("struct Base {\n");
        ((Writer)stringWriter).write("struct Data; // OK: Declares nested Data\n");
        ((Writer)stringWriter).write("struct ::Data* thatData; // OK: Refers to ::Data\n");
        ((Writer)stringWriter).write("struct Base::Data* thisData; // OK: Refers to nested Data\n");
        ((Writer)stringWriter).write("friend class ::Data; // OK: global Data is a friend\n");
        ((Writer)stringWriter).write("friend class Data; // OK: nested Data is a friend\n");
        ((Writer)stringWriter).write("struct Data { /* ... */ }; // Defines nested Data\n");
        ((Writer)stringWriter).write("struct Data; // OK: Redeclares nested Data\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("struct Data; // OK: Redeclares Data at global scope\n");
        ((Writer)stringWriter).write("struct Base::Data* pBase; // OK: refers to nested Data\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        Assert.assertEquals((int)iASTAbstractTypeSpecifierDeclaration.getStartingLine(), (int)1);
        Assert.assertTrue((boolean)(iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier() instanceof IASTClassSpecifier));
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier();
        Assert.assertEquals((String)iASTClassSpecifier.getName(), (String)"Node");
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration2 = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        Assert.assertEquals((int)iASTAbstractTypeSpecifierDeclaration2.getStartingLine(), (int)5);
        Assert.assertTrue((boolean)(iASTAbstractTypeSpecifierDeclaration2.getTypeSpecifier() instanceof IASTClassSpecifier));
        iASTClassSpecifier = (IASTClassSpecifier)iASTAbstractTypeSpecifierDeclaration2.getTypeSpecifier();
        Assert.assertEquals((String)iASTClassSpecifier.getName(), (String)"Data");
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration3 = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        Assert.assertEquals((int)iASTAbstractTypeSpecifierDeclaration3.getStartingLine(), (int)9);
        Assert.assertTrue((boolean)(iASTAbstractTypeSpecifierDeclaration3.getTypeSpecifier() instanceof IASTClassSpecifier));
        iASTClassSpecifier = (IASTClassSpecifier)iASTAbstractTypeSpecifierDeclaration3.getTypeSpecifier();
        Assert.assertEquals((String)iASTClassSpecifier.getName(), (String)"Base");
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration4 = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        Assert.assertEquals((int)iASTAbstractTypeSpecifierDeclaration4.getStartingLine(), (int)18);
        Assert.assertTrue((boolean)(iASTAbstractTypeSpecifierDeclaration4.getTypeSpecifier() instanceof IASTElaboratedTypeSpecifier));
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTAbstractTypeSpecifierDeclaration4.getTypeSpecifier();
        Assert.assertEquals((String)iASTElaboratedTypeSpecifier.getName(), (String)"Data");
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((int)iASTVariable.getStartingLine(), (int)19);
    }

    public void testBug79471() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void testFloatAccess(float * fp) {\n");
        ((Writer)stringWriter).write("#define VAL 2.0f\n");
        ((Writer)stringWriter).write("if(*fp > VAL) { /* Syntax error is here */\n}\n}\n");
        this.parse(((Object)stringWriter).toString());
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void testFloatAccess(float * fp) {\n");
        ((Writer)stringWriter).write("#define VAL 2.0l\n");
        ((Writer)stringWriter).write("if(*fp > VAL) { /* Syntax error is here */\n}\n}\n");
        this.parse(((Object)stringWriter).toString());
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void testFloatAccess(float * fp) {\n");
        ((Writer)stringWriter).write("#define VAL 2.0f\n");
        ((Writer)stringWriter).write("if(VAL > VAL) { /* Syntax error is here */\n}\n}\n");
        this.parse(((Object)stringWriter).toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug79787() throws Exception {
        Iterator iterator;
        try {
            try {
                this.parse("#error what?\r\n");
            }
            catch (ParserException parserException) {}
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            Iterator iterator2 = this.callback.getProblems();
            Assert.assertTrue((boolean)iterator2.hasNext());
            Object e = iterator2.next();
            Assert.assertTrue((boolean)(e instanceof IProblem));
            IProblem iProblem = (IProblem)e;
            Assert.assertEquals((String)iProblem.getArguments(), (String)"what?");
            throw throwable;
        }
        {
            Object var1_3 = null;
            iterator = this.callback.getProblems();
        }
        Assert.assertTrue((boolean)iterator.hasNext());
        Object e = iterator.next();
        Assert.assertTrue((boolean)(e instanceof IProblem));
        IProblem iProblem = (IProblem)e;
        Assert.assertEquals((String)iProblem.getArguments(), (String)"what?");
    }

    public void testBug79810A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void foo() {\n");
        ((Writer)stringWriter).write("int test;\n");
        ((Writer)stringWriter).write("if ((__extension__ ({ union { int __in; int __i; } __u; __u.__in = (test); __u.__i; })) & 0x7f) {}\n}\n");
        this.parse(((Object)stringWriter).toString());
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define __WTERMSIG(status) ((status) & 0x7f)\n");
        ((Writer)stringWriter).write("#define __WIFEXITED(status) (__WTERMSIG(status) == 0)\n");
        ((Writer)stringWriter).write("#define __WAIT_INT(status) (__extension__ ({ union { int __in; int __i; } __u; \\\n");
        ((Writer)stringWriter).write("           __u.__in = (test); __u.__i; }))\n");
        ((Writer)stringWriter).write("#define WIFEXITED(status)\t__WIFEXITED(__WAIT_INT(status))\n");
        ((Writer)stringWriter).write("void foo() {\n");
        ((Writer)stringWriter).write("int test;\n");
        ((Writer)stringWriter).write("if (WIFEXITED(test)) {}\n}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug79921_79227() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("/* some\n* commented\n* code\n*/\n");
        ((Writer)stringWriter).write("#define g_message(...) g_log (1, 2, __VA_ARGS__);\n");
        ((Writer)stringWriter).write("int g_log (int a, int b, ...) { return 0; }\n");
        ((Writer)stringWriter).write("int foo2() {\n");
        ((Writer)stringWriter).write("g_message(\"a string [as] f%2.2x (%2)\")               \\\n");
        ((Writer)stringWriter).write("//    \t                                       ^ the culprit\n}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug100992() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class String { public: String(); ~String(); };");
        ((Writer)stringWriter).write("String::String(){}");
        ((Writer)stringWriter).write("String::~String(){}");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        Iterator iterator2 = ((IASTClassSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier()).getDeclarations();
        IASTMethod iASTMethod = (IASTMethod)iterator2.next();
        Assert.assertTrue((boolean)iASTMethod.isConstructor());
        IASTMethod iASTMethod2 = (IASTMethod)iterator2.next();
        Assert.assertTrue((boolean)iASTMethod2.isDestructor());
        Assert.assertFalse((boolean)iterator2.hasNext());
        IASTMethod iASTMethod3 = (IASTMethod)iterator.next();
        Assert.assertTrue((boolean)iASTMethod3.isConstructor());
        IASTMethod iASTMethod4 = (IASTMethod)iterator.next();
        Assert.assertTrue((boolean)iASTMethod4.isDestructor());
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

