/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.tests.CompleteParseBaseTest;
import org.eclipse.cdt.core.parser.tests.CompleteParsePluginTest;
import org.eclipse.cdt.core.parser.tests.FileBasePluginTest;
import org.eclipse.cdt.internal.core.parser.Parser;
import org.eclipse.cdt.internal.core.parser.ParserException;
import org.eclipse.core.resources.IFile;

public class IScannerInfoPluginTest
extends FileBasePluginTest {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    CompleteParseBaseTest.FullParseCallback c;
    static /* synthetic */ Class class$0;

    public IScannerInfoPluginTest(String string) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.parser.tests.IScannerInfoPluginTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(string, clazz);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.parser.tests.IScannerInfoPluginTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite((Class)clazz);
        testSuite.addTest((Test)new CompleteParsePluginTest("cleanupProject"));
        return testSuite;
    }

    protected Iterator getDeclarations(IASTScope iASTScope) {
        CompleteParseBaseTest.Scope scope = this.c.lookup(iASTScope);
        if (scope != null) {
            return scope.getDeclarations();
        }
        return null;
    }

    protected IASTScope parse(IFile iFile, ParserLanguage parserLanguage, IScannerInfo iScannerInfo) throws Exception {
        this.c = new CompleteParseBaseTest.FullParseCallback();
        InputStream inputStream = iFile.getContents();
        IParser iParser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((CodeReader)new CodeReader(iFile.getLocation().toOSString(), inputStream), (IScannerInfo)iScannerInfo, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)parserLanguage, (ISourceElementRequestor)this.c, (IParserLogService)new NullLogService(), null), (ISourceElementRequestor)this.c, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)parserLanguage, null);
        inputStream.close();
        boolean bl = iParser.parse();
        if (!bl) {
            throw new ParserException("FAILURE");
        }
        Assert.assertTrue((boolean)((Parser)iParser).validateCaches());
        return this.c.getCompilationUnit();
    }

    public void testMacroFileLoading() throws Exception {
        String string = "#define ONE 1\n";
        IFile iFile = this.importFile("imacros.h", string);
        String string2 = "int x = ONE;\n";
        IFile iFile2 = this.importFile("source.cpp", string2);
        String[] stringArray = new String[]{iFile.getFullPath().toOSString()};
        ExtendedScannerInfo extendedScannerInfo = new ExtendedScannerInfo(Collections.EMPTY_MAP, EMPTY_STRING_ARRAY, stringArray, EMPTY_STRING_ARRAY);
        Iterator iterator = this.parse(iFile2, ParserLanguage.C, (IScannerInfo)extendedScannerInfo).getDeclarations();
        Assert.assertTrue((boolean)iterator.hasNext());
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTVariable.getName(), (String)"x");
        Assert.assertNotNull((Object)iASTVariable.getInitializerClause());
        Assert.assertNotNull((Object)iASTVariable.getInitializerClause().getAssigmentExpression());
        Assert.assertEquals((String)iASTVariable.getInitializerClause().getAssigmentExpression().toString(), (String)"1");
    }

    public void testIncludeFileLoading() throws Exception {
        String string = "int x = 4;\n\n";
        IFile iFile = this.importFile("includeMe.h", string);
        String string2 = "int y = x;\n";
        IFile iFile2 = this.importFile("source.cpp", string2);
        String[] stringArray = new String[]{iFile.getFullPath().toOSString()};
        ExtendedScannerInfo extendedScannerInfo = new ExtendedScannerInfo(Collections.EMPTY_MAP, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, stringArray);
        Iterator iterator = this.parse(iFile2, ParserLanguage.C, (IScannerInfo)extendedScannerInfo).getDeclarations();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)(iterator.next() instanceof IASTVariable));
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTVariable.getName(), (String)"y");
        Assert.assertNotNull((Object)iASTVariable.getInitializerClause());
        Assert.assertNotNull((Object)iASTVariable.getInitializerClause().getAssigmentExpression());
        Assert.assertEquals((String)iASTVariable.getInitializerClause().getAssigmentExpression().toString(), (String)"x");
    }
}

