/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.tests.scanner2.BaseScanner2Test;

public class PreprocessorConditionalTest
extends BaseScanner2Test {
    private ISourceElementRequestor nullSourceElementRequestor = new NullSourceElementRequestor();

    protected void initializeScanner(String string, Map map) throws Exception {
        this.scanner = ParserFactory.createScanner((CodeReader)new CodeReader(string.toCharArray()), (IScannerInfo)new ScannerInfo(map), (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)this.nullSourceElementRequestor, null, null);
    }

    protected void evaluateConditionalsPositive(String string, Map map) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#if ");
        stringBuffer.append(string);
        stringBuffer.append("\n int x;\n#else\n#error NEVER\n#endif\n");
        this.initializeScanner(stringBuffer.toString(), map);
        this.evaluate();
    }

    protected void evaluateConditionalsNegative(String string, Map map) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#if ");
        stringBuffer.append(string);
        stringBuffer.append("\n#error NEVER\n#else\n int x;\n#endif\n");
        this.initializeScanner(stringBuffer.toString(), map);
        this.evaluate();
    }

    private void evaluate() throws Exception {
        try {
            this.validateToken(88);
            this.validateIdentifier("x");
            this.validateToken(5);
            this.scanner.nextToken();
            Assert.fail((String)"Should have hit EOF by now");
        }
        catch (EndOfFileException endOfFileException) {}
    }

    public PreprocessorConditionalTest(String string) {
        super(string);
    }

    public void testConditionals() throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("DEFED", "");
        hashMap.put("VALUE", "30 ");
        this.evaluateConditionalsPositive("defined( DEFED )", hashMap);
        this.evaluateConditionalsNegative("defined( NOTDEFED )", hashMap);
        this.evaluateConditionalsNegative("! defined( DEFED )", hashMap);
        this.evaluateConditionalsPositive("! defined( NOTDEFED )", hashMap);
        this.evaluateConditionalsPositive("defined( VALUE ) && VALUE == 30", hashMap);
        this.evaluateConditionalsNegative("defined( VALUE ) && VALUE == 40", hashMap);
    }
}

