/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import junit.framework.Assert;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.IASTASMDefinition;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTArrayModifier;
import org.eclipse.cdt.core.parser.ast.IASTBaseSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTInitializerClause;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceAlias;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IASTTemplateSpecialization;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.tests.BaseASTTest;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class QuickParseASTTests
extends BaseASTTest {
    public QuickParseASTTests(String string) {
        super(string);
    }

    public void testIntGlobal() throws Exception {
        IASTCompilationUnit iASTCompilationUnit = this.parse("int x = 5;");
        Iterator iterator = iASTCompilationUnit.getDeclarations();
        Assert.assertTrue((boolean)iterator.hasNext());
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertTrue((boolean)(iASTVariable.getAbstractDeclaration().getTypeSpecifier() instanceof IASTSimpleTypeSpecifier));
        Assert.assertTrue((((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getType() == IASTSimpleTypeSpecifier.Type.INT ? 1 : 0) != 0);
        Assert.assertEquals((String)iASTVariable.getName(), (String)"x");
        Assert.assertNull((Object)iASTVariable.getInitializerClause());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testEmptyClass() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A { } a;");
        IASTCompilationUnit iASTCompilationUnit = this.parse(((Object)stringWriter).toString());
        Iterator iterator = iASTCompilationUnit.getDeclarations();
        Assert.assertTrue((boolean)iterator.hasNext());
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"a");
        Assert.assertTrue((boolean)(iASTVariable.getAbstractDeclaration().getTypeSpecifier() instanceof IASTClassSpecifier));
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier();
        Assert.assertEquals((String)iASTClassSpecifier.getName(), (String)"A");
        Assert.assertFalse((boolean)iASTClassSpecifier.getDeclarations().hasNext());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testSimpleClassMember() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A { public: int x; };");
        IASTCompilationUnit iASTCompilationUnit = this.parse(((Object)stringWriter).toString());
        Iterator iterator = iASTCompilationUnit.getDeclarations();
        Assert.assertTrue((boolean)iterator.hasNext());
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)(iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier() instanceof IASTClassSpecifier));
        Assert.assertTrue((((IASTClassSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier()).getClassKind() == ASTClassKind.CLASS ? 1 : 0) != 0);
        Iterator iterator2 = ((IASTClassSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier()).getDeclarations();
        Assert.assertTrue((boolean)iterator2.hasNext());
        IASTField iASTField = (IASTField)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertTrue((boolean)iASTField.getName().equals("x"));
        Assert.assertTrue((boolean)(iASTField.getAbstractDeclaration().getTypeSpecifier() instanceof IASTSimpleTypeSpecifier));
        Assert.assertTrue((((IASTSimpleTypeSpecifier)iASTField.getAbstractDeclaration().getTypeSpecifier()).getType() == IASTSimpleTypeSpecifier.Type.INT ? 1 : 0) != 0);
    }

    public void testNamespaceDefinition() throws Exception {
        int n = 0;
        while (n < 2) {
            IASTCompilationUnit iASTCompilationUnit = n == 0 ? this.parse("namespace KingJohn { int x; }") : this.parse("namespace { int x; }");
            Iterator iterator = iASTCompilationUnit.getDeclarations();
            Assert.assertTrue((boolean)iterator.hasNext());
            IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
            Assert.assertFalse((boolean)iterator.hasNext());
            if (n == 0) {
                Assert.assertTrue((boolean)iASTNamespaceDefinition.getName().equals("KingJohn"));
            } else {
                Assert.assertEquals((String)iASTNamespaceDefinition.getName(), (String)"");
            }
            Iterator iterator2 = iASTNamespaceDefinition.getDeclarations();
            Assert.assertTrue((boolean)iterator2.hasNext());
            IASTVariable iASTVariable = (IASTVariable)iterator2.next();
            Assert.assertFalse((boolean)iterator2.hasNext());
            Assert.assertTrue((boolean)(iASTVariable.getAbstractDeclaration().getTypeSpecifier() instanceof IASTSimpleTypeSpecifier));
            Assert.assertTrue((((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getType() == IASTSimpleTypeSpecifier.Type.INT ? 1 : 0) != 0);
            Assert.assertEquals((String)iASTVariable.getName(), (String)"x");
            ++n;
        }
    }

    public void testLinkageSpecification() throws Exception {
        int n = 0;
        while (n < 2) {
            IASTCompilationUnit iASTCompilationUnit = n == 0 ? this.parse("extern \"C\" { int x(void); }") : this.parse("extern \"ADA\" int x(void);");
            Iterator iterator = iASTCompilationUnit.getDeclarations();
            Assert.assertTrue((boolean)iterator.hasNext());
            IASTLinkageSpecification iASTLinkageSpecification = (IASTLinkageSpecification)iterator.next();
            Assert.assertFalse((boolean)iterator.hasNext());
            if (n == 0) {
                Assert.assertEquals((String)"C", (String)iASTLinkageSpecification.getLinkageString());
            } else {
                Assert.assertEquals((String)"ADA", (String)iASTLinkageSpecification.getLinkageString());
            }
            Iterator iterator2 = iASTLinkageSpecification.getDeclarations();
            Assert.assertTrue((boolean)iterator2.hasNext());
            IASTFunction iASTFunction = (IASTFunction)iterator2.next();
            Assert.assertFalse((boolean)iterator2.hasNext());
            Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTFunction.getReturnType().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.INT);
            Assert.assertEquals((String)iASTFunction.getName(), (String)"x");
            Iterator iterator3 = iASTFunction.getParameters();
            Assert.assertTrue((boolean)iterator3.hasNext());
            IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator3.next();
            Assert.assertFalse((boolean)iterator3.hasNext());
            Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.VOID);
            Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"");
            ++n;
        }
    }

    public void testEnumSpecifier() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("enum { yo, go = 3, away };\n");
        ((Writer)stringWriter).write("enum hasAString { last = 666 };");
        IASTCompilationUnit iASTCompilationUnit = this.parse(((Object)stringWriter).toString());
        Iterator iterator = iASTCompilationUnit.getDeclarations();
        int n = 0;
        while (n < 2) {
            IASTEnumerator iASTEnumerator;
            Assert.assertTrue((boolean)iterator.hasNext());
            IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
            IASTEnumerationSpecifier iASTEnumerationSpecifier = (IASTEnumerationSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier();
            if (n == 0) {
                Assert.assertEquals((String)iASTEnumerationSpecifier.getName(), (String)"");
            } else {
                Assert.assertEquals((String)iASTEnumerationSpecifier.getName(), (String)"hasAString");
            }
            Iterator iterator2 = iASTEnumerationSpecifier.getEnumerators();
            if (n == 0) {
                iASTEnumerator = (IASTEnumerator)iterator2.next();
                Assert.assertEquals((String)iASTEnumerator.getName(), (String)"yo");
                Assert.assertNull((Object)iASTEnumerator.getInitialValue());
                IASTEnumerator iASTEnumerator2 = (IASTEnumerator)iterator2.next();
                Assert.assertNotNull((Object)iASTEnumerator2.getInitialValue());
                Assert.assertEquals((String)iASTEnumerator2.getInitialValue().getLiteralString(), (String)"3");
                Assert.assertEquals((Object)iASTEnumerator2.getInitialValue().getExpressionKind(), (Object)IASTExpression.Kind.PRIMARY_INTEGER_LITERAL);
                Assert.assertEquals((String)iASTEnumerator2.getName(), (String)"go");
                IASTEnumerator iASTEnumerator3 = (IASTEnumerator)iterator2.next();
                Assert.assertEquals((String)iASTEnumerator3.getName(), (String)"away");
                Assert.assertNull((Object)iASTEnumerator3.getInitialValue());
                Assert.assertFalse((boolean)iterator2.hasNext());
            } else {
                iASTEnumerator = (IASTEnumerator)iterator2.next();
                Assert.assertNotNull((Object)iASTEnumerator.getInitialValue());
                Assert.assertEquals((String)iASTEnumerator.getInitialValue().getLiteralString(), (String)"666");
                Assert.assertEquals((Object)iASTEnumerator.getInitialValue().getExpressionKind(), (Object)IASTExpression.Kind.PRIMARY_INTEGER_LITERAL);
                Assert.assertEquals((String)iASTEnumerator.getName(), (String)"last");
                Assert.assertFalse((boolean)iterator2.hasNext());
            }
            ++n;
        }
    }

    public void testTypedef() throws Exception {
        Iterator iterator = this.parse("typedef const struct A * const cpStructA;").getDeclarations();
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iASTTypedefDeclaration.getAbstractDeclarator().isConst());
        Assert.assertTrue((boolean)(iASTTypedefDeclaration.getAbstractDeclarator().getTypeSpecifier() instanceof IASTElaboratedTypeSpecifier));
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTTypedefDeclaration.getAbstractDeclarator().getTypeSpecifier();
        Assert.assertEquals((String)iASTElaboratedTypeSpecifier.getName(), (String)"A");
        Assert.assertEquals((Object)iASTElaboratedTypeSpecifier.getClassKind(), (Object)ASTClassKind.STRUCT);
        Assert.assertTrue((boolean)iASTTypedefDeclaration.getAbstractDeclarator().getPointerOperators().hasNext());
        Iterator iterator2 = iASTTypedefDeclaration.getAbstractDeclarator().getPointerOperators();
        ASTPointerOperator aSTPointerOperator = (ASTPointerOperator)iterator2.next();
        Assert.assertEquals((Object)aSTPointerOperator, (Object)ASTPointerOperator.CONST_POINTER);
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertEquals((String)iASTTypedefDeclaration.getName(), (String)"cpStructA");
    }

    public void testUsingClauses() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("using namespace A::B::C;\n");
        ((Writer)stringWriter).write("using namespace C;\n");
        ((Writer)stringWriter).write("using B::f;\n");
        ((Writer)stringWriter).write("using ::f;\n");
        ((Writer)stringWriter).write("using typename crap::de::crap;");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTUsingDirective iASTUsingDirective = (IASTUsingDirective)iterator.next();
        Assert.assertEquals((String)iASTUsingDirective.getNamespaceName(), (String)"A::B::C");
        iASTUsingDirective = (IASTUsingDirective)iterator.next();
        Assert.assertEquals((String)iASTUsingDirective.getNamespaceName(), (String)"C");
        IASTUsingDeclaration iASTUsingDeclaration = (IASTUsingDeclaration)iterator.next();
        Assert.assertEquals((String)iASTUsingDeclaration.usingTypeName(), (String)"B::f");
        iASTUsingDeclaration = (IASTUsingDeclaration)iterator.next();
        Assert.assertEquals((String)iASTUsingDeclaration.usingTypeName(), (String)"::f");
        iASTUsingDeclaration = (IASTUsingDeclaration)iterator.next();
        Assert.assertEquals((String)iASTUsingDeclaration.usingTypeName(), (String)"crap::de::crap");
        Assert.assertTrue((boolean)iASTUsingDeclaration.isTypename());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testSimpleClassMembers() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A : public B, private C, virtual protected D { public: int x, y; float a,b,c; };");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = iASTClassSpecifier.getBaseClauses();
        IASTBaseSpecifier iASTBaseSpecifier = (IASTBaseSpecifier)iterator2.next();
        Assert.assertEquals((String)iASTBaseSpecifier.getParentClassName(), (String)"B");
        Assert.assertEquals((Object)iASTBaseSpecifier.getAccess(), (Object)ASTAccessVisibility.PUBLIC);
        iASTBaseSpecifier = (IASTBaseSpecifier)iterator2.next();
        Assert.assertEquals((String)iASTBaseSpecifier.getParentClassName(), (String)"C");
        Assert.assertEquals((Object)iASTBaseSpecifier.getAccess(), (Object)ASTAccessVisibility.PRIVATE);
        iASTBaseSpecifier = (IASTBaseSpecifier)iterator2.next();
        Assert.assertEquals((Object)iASTBaseSpecifier.getAccess(), (Object)ASTAccessVisibility.PROTECTED);
        Assert.assertTrue((boolean)iASTBaseSpecifier.isVirtual());
        Assert.assertEquals((String)iASTBaseSpecifier.getParentClassName(), (String)"D");
        Assert.assertFalse((boolean)iterator2.hasNext());
        Iterator iterator3 = iASTClassSpecifier.getDeclarations();
        IASTField iASTField = (IASTField)iterator3.next();
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTField.getAbstractDeclaration().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.INT);
        Assert.assertEquals((String)iASTField.getName(), (String)"x");
        iASTField = (IASTField)iterator3.next();
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTField.getAbstractDeclaration().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.INT);
        Assert.assertEquals((String)iASTField.getName(), (String)"y");
        iASTField = (IASTField)iterator3.next();
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTField.getAbstractDeclaration().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.FLOAT);
        Assert.assertEquals((String)iASTField.getName(), (String)"a");
        iASTField = (IASTField)iterator3.next();
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTField.getAbstractDeclaration().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.FLOAT);
        Assert.assertEquals((String)iASTField.getName(), (String)"b");
        iASTField = (IASTField)iterator3.next();
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTField.getAbstractDeclaration().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.FLOAT);
        Assert.assertEquals((String)iASTField.getName(), (String)"c");
        Assert.assertFalse((boolean)iterator3.hasNext());
    }

    public void testSimpleFunctionDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void myFunction( void );");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTFunction.getName(), (String)"myFunction");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTFunction.getReturnType().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.VOID);
        Iterator iterator2 = iASTFunction.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.VOID);
    }

    public void testFunctionDeclarationWithParameters() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("bool myFunction( int parm1 = 3 * 4, double parm2 );");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTFunction.getName(), (String)"myFunction");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTFunction.getReturnType().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.BOOL);
        Iterator iterator2 = iASTFunction.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"parm1");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.INT);
        Assert.assertEquals((Object)iASTParameterDeclaration.getDefaultValue().getAssigmentExpression().getExpressionKind(), (Object)IASTExpression.Kind.MULTIPLICATIVE_MULTIPLY);
        iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"parm2");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.DOUBLE);
        Assert.assertNull((Object)iASTParameterDeclaration.getDefaultValue());
        Assert.assertFalse((boolean)iterator2.hasNext());
    }

    public void testAssignmentExpressions() throws Exception {
        this.parse("int x = y = z = 5;");
    }

    public void testBug39348() throws Exception {
        this.parse("unsigned char a[sizeof (struct sss)];");
    }

    public void testBug39501() throws Exception {
        this.parse("struct A { A() throw (int); };");
    }

    public void testBug39349() throws Exception {
        this.parse("enum foo {  foo1   = 0,  foo2   = 0xffffffffffffffffULL,  foo3   = 0xf0fffffffffffffeLLU };");
    }

    public void testBug39544() throws Exception {
        this.parse("wchar_t wc = L'X';");
    }

    public void testBug36290() throws Exception {
        this.parse("typedef void ( A:: * pMethod ) ( void ); ");
        this.parse("typedef void (boo) ( void ); ");
        this.parse("typedef void boo (void); ");
    }

    public void testBug36769B() throws Exception {
        this.parse("class X { operator int(); } \n");
        this.parse("class X { operator int*(); } \n");
        this.parse("class X { operator int&(); } \n");
        this.parse("class X { operator A(); } \n");
        this.parse("class X { operator A*(); } \n");
        this.parse("class X { operator A&(); } \n");
        this.parse("X::operator int() { } \n");
        this.parse("X::operator int*() { } \n");
        this.parse("X::operator int&() { } \n");
        this.parse("X::operator A() { } \n");
        this.parse("X::operator A*() { } \n");
        this.parse("X::operator A&() { } \n");
        this.parse("template <class A,B> class X<A,C> { operator int(); } \n");
        this.parse("template <class A,B> class X<A,C> { operator int*(); } \n");
        this.parse("template <class A,B> class X<A,C> { operator int&(); } \n");
        this.parse("template <class A,B> class X<A,C> { operator A(); } \n");
        this.parse("template <class A,B> class X<A,C> { operator A*(); } \n");
        this.parse("template <class A,B> class X<A,C> { operator A&(); } \n");
        this.parse("template <class A,B> X<A,C>::operator int() { } \n");
        this.parse("template <class A,B> X<A,C>::operator int*() { } \n");
        this.parse("template <class A,B> X<A,C>::operator int&() { } \n");
        this.parse("template <class A,B> X<A,C>::operator A() { } \n");
        this.parse("template <class A,B> X<A,C>::operator A*() { } \n");
        this.parse("template <class A,B> X<A,C>::operator A&() { } \n");
    }

    public void testBug36932C() throws Exception {
        this.parse("X::X( ) : var( new int ) {}");
        this.parse("X::X( ) : var( new int(5) ) {}");
        this.parse("X::X( ) : var( new int(B) ) {}");
        this.parse("X::X( ) : var( new int(B,C) ) {}");
        this.parse("X::X( ) : var( new int[5] ) {}");
        this.parse("X::X( ) : var( new int[5][10] ) {}");
        this.parse("X::X( ) : var( new int[B] ) {}");
        this.parse("X::X( ) : var( new int[B][C][D] ) {}");
        this.parse("X::X( ) : var( new A ) {}");
        this.parse("X::X( ) : var( new A(5) ) {}");
        this.parse("X::X( ) : var( new A(B) ) {}");
        this.parse("X::X( ) : var( new A(B,C) ) {}");
        this.parse("X::X( ) : var( new A[5] ) {}");
        this.parse("X::X( ) : var( new A[5][10] ) {}");
        this.parse("X::X( ) : var( new A[B] ) {}");
        this.parse("X::X( ) : var( new A[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (int) ) {}");
        this.parse("X::X( ) : var( new (int)(5) ) {}");
        this.parse("X::X( ) : var( new (int)(B) ) {}");
        this.parse("X::X( ) : var( new (int)(B,C) ) {}");
        this.parse("X::X( ) : var( new (int)[5] ) {}");
        this.parse("X::X( ) : var( new (int)[5][10] ) {}");
        this.parse("X::X( ) : var( new (int)[B] ) {}");
        this.parse("X::X( ) : var( new (int)[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (A) ) {}");
        this.parse("X::X( ) : var( new (A)(5) ) {}");
        this.parse("X::X( ) : var( new (A)(B) ) {}");
        this.parse("X::X( ) : var( new (A)(B,C) ) {}");
        this.parse("X::X( ) : var( new (A)[5] ) {}");
        this.parse("X::X( ) : var( new (A)[5][10] ) {}");
        this.parse("X::X( ) : var( new (A)[B] ) {}");
        this.parse("X::X( ) : var( new (A)[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (0) int ) {}");
        this.parse("X::X( ) : var( new (0) int(5) ) {}");
        this.parse("X::X( ) : var( new (0) int(B) ) {}");
        this.parse("X::X( ) : var( new (0) int(B,C) ) {}");
        this.parse("X::X( ) : var( new (0) int[5] ) {}");
        this.parse("X::X( ) : var( new (0) int[5][10] ) {}");
        this.parse("X::X( ) : var( new (0) int[B] ) {}");
        this.parse("X::X( ) : var( new (0) int[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (0) A ) {}");
        this.parse("X::X( ) : var( new (0) A(5) ) {}");
        this.parse("X::X( ) : var( new (0) A(B) ) {}");
        this.parse("X::X( ) : var( new (0) A(B,C) ) {}");
        this.parse("X::X( ) : var( new (0) A[5] ) {}");
        this.parse("X::X( ) : var( new (0) A[5][10] ) {}");
        this.parse("X::X( ) : var( new (0) A[B] ) {}");
        this.parse("X::X( ) : var( new (0) A[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (0) (int) ) {}");
        this.parse("X::X( ) : var( new (0) (int)(5) ) {}");
        this.parse("X::X( ) : var( new (0) (int)(B) ) {}");
        this.parse("X::X( ) : var( new (0) (int)(B,C) ) {}");
        this.parse("X::X( ) : var( new (0) (int)[5] ) {}");
        this.parse("X::X( ) : var( new (0) (int)[5][10] ) {}");
        this.parse("X::X( ) : var( new (0) (int)[B] ) {}");
        this.parse("X::X( ) : var( new (0) (int)[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (0) (A) ) {}");
        this.parse("X::X( ) : var( new (0) (A)(5) ) {}");
        this.parse("X::X( ) : var( new (0) (A)(B) ) {}");
        this.parse("X::X( ) : var( new (0) (A)(B,C) ) {}");
        this.parse("X::X( ) : var( new (0) (A)[5] ) {}");
        this.parse("X::X( ) : var( new (0) (A)[5][10] ) {}");
        this.parse("X::X( ) : var( new (0) (A)[B] ) {}");
        this.parse("X::X( ) : var( new (0) (A)[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (P) int ) {}");
        this.parse("X::X( ) : var( new (P) int(5) ) {}");
        this.parse("X::X( ) : var( new (P) int(B) ) {}");
        this.parse("X::X( ) : var( new (P) int(B,C) ) {}");
        this.parse("X::X( ) : var( new (P) int[5] ) {}");
        this.parse("X::X( ) : var( new (P) int[5][10] ) {}");
        this.parse("X::X( ) : var( new (P) int[B] ) {}");
        this.parse("X::X( ) : var( new (P) int[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (P) A ) {}");
        this.parse("X::X( ) : var( new (P) A(5) ) {}");
        this.parse("X::X( ) : var( new (P) A(B) ) {}");
        this.parse("X::X( ) : var( new (P) A(B,C) ) {}");
        this.parse("X::X( ) : var( new (P) A[5] ) {}");
        this.parse("X::X( ) : var( new (P) A[5][10] ) {}");
        this.parse("X::X( ) : var( new (P) A[B] ) {}");
        this.parse("X::X( ) : var( new (P) A[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (P) (int) ) {}");
        this.parse("X::X( ) : var( new (P) (int)(5) ) {}");
        this.parse("X::X( ) : var( new (P) (int)(B) ) {}");
        this.parse("X::X( ) : var( new (P) (int)(B,C) ) {}");
        this.parse("X::X( ) : var( new (P) (int)[5] ) {}");
        this.parse("X::X( ) : var( new (P) (int)[5][10] ) {}");
        this.parse("X::X( ) : var( new (P) (int)[B] ) {}");
        this.parse("X::X( ) : var( new (P) (int)[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (P) (A) ) {}");
        this.parse("X::X( ) : var( new (P) (A)(5) ) {}");
        this.parse("X::X( ) : var( new (P) (A)(B) ) {}");
        this.parse("X::X( ) : var( new (P) (A)(B,C) ) {}");
        this.parse("X::X( ) : var( new (P) (A)[5] ) {}");
        this.parse("X::X( ) : var( new (P) (A)[5][10] ) {}");
        this.parse("X::X( ) : var( new (P) (A)[B] ) {}");
        this.parse("X::X( ) : var( new (P) (A)[B][C][D] ) {}");
    }

    public void testBugSingleton192() throws Exception {
        this.parse("int Test::* pMember_;");
    }

    public void testBug36931() throws Exception {
        this.parse("A::nested::nested(){}; ");
        this.parse("int A::nested::foo() {} ");
        this.parse("int A::nested::operator+() {} ");
        this.parse("A::nested::operator int() {} ");
        this.parse("static const int A::nested::i = 1; ");
        this.parse("template <class B,C> A<B>::nested::nested(){}; ");
        this.parse("template <class B,C> int A::nested<B,D>::foo() {} ");
        this.parse("template <class B,C> int A<B,C>::nested<C,B>::operator+() {} ");
        this.parse("template <class B,C> A::nested::operator int() {} ");
    }

    public void testBug37019() throws Exception {
        this.parse("static const A a( 1, 0 );");
    }

    public void testBug36766and36769A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <class _CharT, class _Alloc>\n");
        ((Writer)stringWriter).write("rope<_CharT, _Alloc>::rope(size_t __n, _CharT __c,\n");
        ((Writer)stringWriter).write("const allocator_type& __a): _Base(__a)\n");
        ((Writer)stringWriter).write("{}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36766and36769B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template<class _CharT>\n");
        ((Writer)stringWriter).write("bool _Rope_insert_char_consumer<_CharT>::operator()\n");
        ((Writer)stringWriter).write("(const _CharT* __leaf, size_t __n)\n");
        ((Writer)stringWriter).write("{}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36766and36769C() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <class _CharT, class _Alloc>\n");
        ((Writer)stringWriter).write("_Rope_char_ref_proxy<_CharT, _Alloc>&\n");
        ((Writer)stringWriter).write("_Rope_char_ref_proxy<_CharT, _Alloc>::operator= (_CharT __c)\n");
        ((Writer)stringWriter).write("{}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36766and36769D() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <class _CharT, class _Alloc>\n");
        ((Writer)stringWriter).write("rope<_CharT, _Alloc>::~rope()\n");
        ((Writer)stringWriter).write("{}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36932A() throws Exception {
        this.parse("A::A( ) : var( new char [ (unsigned)bufSize ] ) {}");
    }

    public void testBug36932B() throws Exception {
        this.parse(" p = new int; ");
        this.parse(" p = new int(5); ");
        this.parse(" p = new int(B); ");
        this.parse(" p = new int(B,C); ");
        this.parse(" p = new int[5]; ");
        this.parse(" p = new int[5][10]; ");
        this.parse(" p = new int[B]; ");
        this.parse(" p = new int[B][C][D]; ");
        this.parse(" p = new A; ");
        this.parse(" p = new A(5); ");
        this.parse(" p = new A(B); ");
        this.parse(" p = new A(B,C); ");
        this.parse(" p = new A[5]; ");
        this.parse(" p = new A[5][10]; ");
        this.parse(" p = new A[B]; ");
        this.parse(" p = new A[B][C][D]; ");
        this.parse(" p = new (int); ");
        this.parse(" p = new (int)(5); ");
        this.parse(" p = new (int)(B); ");
        this.parse(" p = new (int)(B,C); ");
        this.parse(" p = new (int)[5]; ");
        this.parse(" p = new (int)[5][10]; ");
        this.parse(" p = new (int)[B]; ");
        this.parse(" p = new (int)[B][C][D]; ");
        this.parse(" p = new (A); ");
        this.parse(" p = new (A)(5); ");
        this.parse(" p = new (A)(B); ");
        this.parse(" p = new (A)(B,C); ");
        this.parse(" p = new (A)[5]; ");
        this.parse(" p = new (A)[5][10]; ");
        this.parse(" p = new (A)[B]; ");
        this.parse(" p = new (A)[B][C][D]; ");
        this.parse(" p = new (0) int; ");
        this.parse(" p = new (0) int(5); ");
        this.parse(" p = new (0) int(B); ");
        this.parse(" p = new (0) int(B,C); ");
        this.parse(" p = new (0) int[5]; ");
        this.parse(" p = new (0) int[5][10]; ");
        this.parse(" p = new (0) int[B]; ");
        this.parse(" p = new (0) int[B][C][D]; ");
        this.parse(" p = new (0) A; ");
        this.parse(" p = new (0) A(5); ");
        this.parse(" p = new (0) A(B); ");
        this.parse(" p = new (0) A(B,C); ");
        this.parse(" p = new (0) A[5]; ");
        this.parse(" p = new (0) A[5][10]; ");
        this.parse(" p = new (0) A[B]; ");
        this.parse(" p = new (0) A[B][C][D]; ");
        this.parse(" p = new (0) (int); ");
        this.parse(" p = new (0) (int)(5); ");
        this.parse(" p = new (0) (int)(B); ");
        this.parse(" p = new (0) (int)(B,C); ");
        this.parse(" p = new (0) (int)[5]; ");
        this.parse(" p = new (0) (int)[5][10]; ");
        this.parse(" p = new (0) (int)[B]; ");
        this.parse(" p = new (0) (int)[B][C][D]; ");
        this.parse(" p = new (0) (A); ");
        this.parse(" p = new (0) (A)(5); ");
        this.parse(" p = new (0) (A)(B); ");
        this.parse(" p = new (0) (A)(B,C); ");
        this.parse(" p = new (0) (A)[5]; ");
        this.parse(" p = new (0) (A)[5][10]; ");
        this.parse(" p = new (0) (A)[B]; ");
        this.parse(" p = new (0) (A)[B][C][D]; ");
        this.parse(" p = new (P) int; ");
        this.parse(" p = new (P) int(5); ");
        this.parse(" p = new (P) int(B); ");
        this.parse(" p = new (P) int(B,C); ");
        this.parse(" p = new (P) int[5]; ");
        this.parse(" p = new (P) int[5][10]; ");
        this.parse(" p = new (P) int[B]; ");
        this.parse(" p = new (P) int[B][C][D]; ");
        this.parse(" p = new (P) A; ");
        this.parse(" p = new (P) A(5); ");
        this.parse(" p = new (P) A(B); ");
        this.parse(" p = new (P) A(B,C); ");
        this.parse(" p = new (P) A[5]; ");
        this.parse(" p = new (P) A[5][10]; ");
        this.parse(" p = new (P) A[B]; ");
        this.parse(" p = new (P) A[B][C][D]; ");
        this.parse(" p = new (P) (int); ");
        this.parse(" p = new (P) (int)(5); ");
        this.parse(" p = new (P) (int)(B); ");
        this.parse(" p = new (P) (int)(B,C); ");
        this.parse(" p = new (P) (int)[5]; ");
        this.parse(" p = new (P) (int)[5][10]; ");
        this.parse(" p = new (P) (int)[B]; ");
        this.parse(" p = new (P) (int)[B][C][D]; ");
        this.parse(" p = new (P) (A); ");
        this.parse(" p = new (P) (A)(5); ");
        this.parse(" p = new (P) (A)(B); ");
        this.parse(" p = new (P) (A)(B,C); ");
        this.parse(" p = new (P) (A)[5]; ");
        this.parse(" p = new (P) (A)[5][10]; ");
        this.parse(" p = new (P) (A)[B]; ");
        this.parse(" p = new (P) (A)[B][C][D]; ");
    }

    public void testBug36769A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <class A, B> cls<A, C>::operator op &() const {}\n");
        ((Writer)stringWriter).write("template <class A, B> cls<A, C>::cls() {}\n");
        ((Writer)stringWriter).write("template <class A, B> cls<A, C>::~cls() {}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36714() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("unsigned long a = 0UL;\n");
        ((Writer)stringWriter).write("unsigned long a2 = 0L; \n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBugFunctor758() throws Exception {
        this.parse("template <typename Fun> Functor(Fun fun) : spImpl_(new FunctorHandler<Functor, Fun>(fun)){}");
    }

    public void testBug36932() throws Exception {
        this.parse("A::A(): b( new int( 5 ) ), b( new B ), c( new int ) {}");
    }

    public void testBug36704() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <class T, class U>\n");
        ((Writer)stringWriter).write("struct Length< Typelist<T, U> >\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("enum { value = 1 + Length<U>::value };\n");
        ((Writer)stringWriter).write("};\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36699() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <\ttemplate <class> class ThreadingModel = DEFAULT_THREADING,\n");
        ((Writer)stringWriter).write("std::size_t chunkSize = DEFAULT_CHUNK_SIZE,\n");
        ((Writer)stringWriter).write("std::size_t maxSmallObjectSize = MAX_SMALL_OBJECT_SIZE\t>\n");
        ((Writer)stringWriter).write("class SmallObject : public ThreadingModel<\n");
        ((Writer)stringWriter).write("SmallObject<ThreadingModel, chunkSize, maxSmallObjectSize> >\n");
        ((Writer)stringWriter).write("{};\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36691() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <class T, class H>\n");
        ((Writer)stringWriter).write("typename H::template Rebind<T>::Result& Field(H& obj)\n");
        ((Writer)stringWriter).write("{\treturn obj;\t}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36702() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void mad_decoder_init(struct mad_decoder *, void *,\n");
        ((Writer)stringWriter).write("\t\t\t  enum mad_flow (*)(void *, struct mad_stream *),\n");
        ((Writer)stringWriter).write("\t\t\t  enum mad_flow (*)(void *, struct mad_header const *),\n");
        ((Writer)stringWriter).write("\t\t\t  enum mad_flow (*)(void *,\n");
        ((Writer)stringWriter).write("\t\t\t\t\tstruct mad_stream const *,\n");
        ((Writer)stringWriter).write("\t\t\t\t\tstruct mad_frame *),\n");
        ((Writer)stringWriter).write("\t\t\t  enum mad_flow (*)(void *,\n");
        ((Writer)stringWriter).write("\t\t\t\t\tstruct mad_header const *,\n");
        ((Writer)stringWriter).write("\t\t\t\t\tstruct mad_pcm *),\n");
        ((Writer)stringWriter).write("\t\t\t  enum mad_flow (*)(void *,\n");
        ((Writer)stringWriter).write("\t\t\t\t\tstruct mad_stream *,\n");
        ((Writer)stringWriter).write("\t\t\t\t\tstruct mad_frame *),\n");
        ((Writer)stringWriter).write("\t\t\t  enum mad_flow (*)(void *, void *, unsigned int *)\n");
        ((Writer)stringWriter).write(");\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36852() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int CBT::senseToAllRect( double id_standardQuot = DOSE, double id_minToleranz =15.0,\n");
        ((Writer)stringWriter).write("double id_maxToleranz = 15.0, unsigned int iui_minY = 0, \n");
        ((Writer)stringWriter).write("unsigned int iui_maxY = HEIGHT );\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36689() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template\n");
        ((Writer)stringWriter).write("<\n");
        ((Writer)stringWriter).write("class AbstractFact,\n");
        ((Writer)stringWriter).write("template <class, class> class Creator = OpNewFactoryUnit,\n");
        ((Writer)stringWriter).write("class TList = typename AbstractFact::ProductList\n");
        ((Writer)stringWriter).write(">\n");
        ((Writer)stringWriter).write("class ConcreteFactory\n");
        ((Writer)stringWriter).write(": public GenLinearHierarchy<\n");
        ((Writer)stringWriter).write("typename TL::Reverse<TList>::Result, Creator, AbstractFact>\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("typedef typename AbstractFact::ProductList ProductList;\n");
        ((Writer)stringWriter).write("typedef TList ConcreteProductList;\n");
        ((Writer)stringWriter).write("};\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36707() throws Exception {
        this.parse("enum { exists = sizeof(typename H::Small) == sizeof((H::Test(H::MakeT()))) };");
    }

    public void testBug36717() throws Exception {
        this.parse("enum { eA = A::b };");
    }

    public void testBug36693() throws Exception {
        this.parse("FixedAllocator::Chunk* FixedAllocator::VicinityFind(void* p){}");
    }

    public void testWeirdExpression() throws Exception {
        this.parse("int x = rhs.spImpl_.get();");
    }

    public void testBug36696() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <typename P1> RefCounted(const RefCounted<P1>& rhs)\n");
        ((Writer)stringWriter).write(": pCount_(reinterpret_cast<const RefCounted&>(rhs).pCount_) {}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testArrayOfPointerToFunctions() throws Exception {
        this.parse("unsigned char (*main_data)[MAD_BUFFER_MDLEN];");
    }

    public void testBug36073() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A{\n");
        stringWriter.write("int x;\n");
        stringWriter.write("public:\n");
        stringWriter.write("A(const A&);\n");
        stringWriter.write("};\n");
        stringWriter.write("A::A(const A&v) : x(v.x) { }\n");
        this.parse(stringWriter.toString());
    }

    public void testTemplateSpecialization() throws Exception {
        Iterator iterator = this.parse("template<> class stream<char> { /* ... */ };").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)((IASTTemplateSpecialization)iterator.next()).getOwnedDeclaration()).getTypeSpecifier();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTClassSpecifier.getName(), (String)"stream<char>");
        Assert.assertFalse((boolean)iASTClassSpecifier.getDeclarations().hasNext());
    }

    public void testTemplateInstantiation() throws Exception {
        Iterator iterator = this.parse("template class Array<char>;").getDeclarations();
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)((IASTAbstractTypeSpecifierDeclaration)((IASTTemplateInstantiation)iterator.next()).getOwnedDeclaration()).getTypeSpecifier();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTElaboratedTypeSpecifier.getName(), (String)"Array<char>");
        Assert.assertEquals((Object)iASTElaboratedTypeSpecifier.getClassKind(), (Object)ASTClassKind.CLASS);
    }

    public void testMultipleDeclarators() throws Exception {
        Iterator iterator = this.parse("class A { int floor( double input ), someInt; };").getDeclarations();
        Iterator iterator2 = ((IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier()).getDeclarations();
        Assert.assertFalse((boolean)iterator.hasNext());
        IASTMethod iASTMethod = (IASTMethod)iterator2.next();
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTMethod.getReturnType().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.INT);
        Iterator iterator3 = iASTMethod.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator3.next();
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.DOUBLE);
        Assert.assertFalse((boolean)iterator3.hasNext());
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"input");
        IASTField iASTField = (IASTField)iterator2.next();
        Assert.assertEquals((String)iASTField.getName(), (String)"someInt");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTField.getAbstractDeclaration().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.INT);
        Assert.assertFalse((boolean)iterator2.hasNext());
    }

    public void testFunctionModifiers() throws Exception {
        Iterator iterator = this.parse("class A {virtual void foo( void ) const throw ( yay, nay, we::dont::care ) = 0;};").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = iASTClassSpecifier.getDeclarations();
        IASTMethod iASTMethod = (IASTMethod)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertTrue((boolean)iASTMethod.isVirtual());
        Assert.assertEquals((String)iASTMethod.getName(), (String)"foo");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTMethod.getReturnType().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.VOID);
        Iterator iterator3 = iASTMethod.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator3.next();
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.VOID);
        Assert.assertFalse((boolean)iterator3.hasNext());
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"");
        Assert.assertTrue((boolean)iASTMethod.isConst());
        Assert.assertTrue((boolean)iASTMethod.isPureVirtual());
        Assert.assertNotNull((Object)iASTMethod.getExceptionSpec());
        Iterator iterator4 = iASTMethod.getExceptionSpec().getTypeIds();
        Assert.assertEquals((String)((String)iterator4.next()), (String)"yay");
        Assert.assertEquals((String)((String)iterator4.next()), (String)"nay");
        Assert.assertEquals((String)((String)iterator4.next()), (String)"we::dont::care");
        Assert.assertFalse((boolean)iterator4.hasNext());
    }

    public void testArrays() throws Exception {
        Iterator iterator = this.parse("int x [5][];").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.INT);
        Assert.assertEquals((String)iASTVariable.getName(), (String)"x");
        Iterator iterator2 = iASTVariable.getAbstractDeclaration().getArrayModifiers();
        IASTArrayModifier iASTArrayModifier = (IASTArrayModifier)iterator2.next();
        Assert.assertEquals((Object)iASTArrayModifier.getExpression().getExpressionKind(), (Object)IASTExpression.Kind.PRIMARY_INTEGER_LITERAL);
        Assert.assertEquals((String)iASTArrayModifier.getExpression().getLiteralString(), (String)"5");
        iASTArrayModifier = (IASTArrayModifier)iterator2.next();
        Assert.assertNull((Object)iASTArrayModifier.getExpression());
        Assert.assertFalse((boolean)iterator2.hasNext());
    }

    public void testElaboratedParms() throws Exception {
        Iterator iterator = this.parse("int x( struct A myA ) { /* junk */ }").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        this.assertSimpleReturnType(iASTFunction, IASTSimpleTypeSpecifier.Type.INT);
        Iterator iterator2 = iASTFunction.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"myA");
        Assert.assertEquals((String)((IASTElaboratedTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getName(), (String)"A");
        Assert.assertEquals((Object)((IASTElaboratedTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getClassKind(), (Object)ASTClassKind.STRUCT);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testMemberDeclarations() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A {\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write(" int is0;\n");
        ((Writer)stringWriter).write("private:\n");
        ((Writer)stringWriter).write(" int is1;\n");
        ((Writer)stringWriter).write("protected:\n");
        ((Writer)stringWriter).write(" int is2;\n");
        ((Writer)stringWriter).write("};");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = iASTClassSpecifier.getDeclarations();
        int n = 0;
        while (n < 3) {
            IASTField iASTField = (IASTField)iterator2.next();
            Assert.assertEquals((String)iASTField.getName(), (String)("is" + new Integer(n).toString()));
            ASTAccessVisibility aSTAccessVisibility = null;
            switch (n) {
                case 0: {
                    aSTAccessVisibility = ASTAccessVisibility.PUBLIC;
                    break;
                }
                case 1: {
                    aSTAccessVisibility = ASTAccessVisibility.PRIVATE;
                    break;
                }
                default: {
                    aSTAccessVisibility = ASTAccessVisibility.PROTECTED;
                }
            }
            Assert.assertEquals((Object)iASTField.getVisiblity(), (Object)aSTAccessVisibility);
            ++n;
        }
        Assert.assertFalse((boolean)iterator2.hasNext());
    }

    public void testPointerOperators() throws Exception {
        Iterator iterator = this.parse("int * x = 0, & y, * const * volatile * z;").getDeclarations();
        int n = 0;
        while (n < 3) {
            IASTVariable iASTVariable = (IASTVariable)iterator.next();
            this.assertSimpleType(iASTVariable, IASTSimpleTypeSpecifier.Type.INT);
            Iterator iterator2 = iASTVariable.getAbstractDeclaration().getPointerOperators();
            ASTPointerOperator aSTPointerOperator = (ASTPointerOperator)iterator2.next();
            switch (n) {
                case 0: {
                    Assert.assertEquals((String)iASTVariable.getName(), (String)"x");
                    Assert.assertEquals((Object)aSTPointerOperator, (Object)ASTPointerOperator.POINTER);
                    Assert.assertFalse((boolean)iterator2.hasNext());
                    break;
                }
                case 1: {
                    Assert.assertEquals((String)iASTVariable.getName(), (String)"y");
                    Assert.assertEquals((Object)aSTPointerOperator, (Object)ASTPointerOperator.REFERENCE);
                    Assert.assertFalse((boolean)iterator2.hasNext());
                    break;
                }
                case 2: {
                    Assert.assertEquals((String)iASTVariable.getName(), (String)"z");
                    Assert.assertEquals((Object)aSTPointerOperator, (Object)ASTPointerOperator.CONST_POINTER);
                    Assert.assertEquals(iterator2.next(), (Object)ASTPointerOperator.VOLATILE_POINTER);
                    Assert.assertEquals(iterator2.next(), (Object)ASTPointerOperator.POINTER);
                    Assert.assertFalse((boolean)iterator2.hasNext());
                }
            }
            ++n;
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug26467() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("struct foo { int fooInt; char fooChar;\t};\n");
        stringWriter.write("typedef struct foo fooStruct;\n");
        stringWriter.write("typedef struct { int anonInt; char anonChar; } anonStruct;\n");
        Iterator iterator = this.parse(stringWriter.toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertEquals((Object)iASTClassSpecifier.getClassKind(), (Object)ASTClassKind.STRUCT);
        Assert.assertEquals((String)iASTClassSpecifier.getName(), (String)"foo");
        Iterator iterator2 = iASTClassSpecifier.getDeclarations();
        IASTField iASTField = (IASTField)iterator2.next();
        this.assertSimpleType((IASTVariable)iASTField, IASTSimpleTypeSpecifier.Type.INT);
        Assert.assertEquals((String)iASTField.getName(), (String)"fooInt");
        iASTField = (IASTField)iterator2.next();
        this.assertSimpleType((IASTVariable)iASTField, IASTSimpleTypeSpecifier.Type.CHAR);
        Assert.assertEquals((String)iASTField.getName(), (String)"fooChar");
        Assert.assertFalse((boolean)iterator2.hasNext());
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        Assert.assertEquals((Object)((IASTElaboratedTypeSpecifier)iASTTypedefDeclaration.getAbstractDeclarator().getTypeSpecifier()).getClassKind(), (Object)ASTClassKind.STRUCT);
        Assert.assertEquals((String)((IASTElaboratedTypeSpecifier)iASTTypedefDeclaration.getAbstractDeclarator().getTypeSpecifier()).getName(), (String)"foo");
        Assert.assertEquals((String)iASTTypedefDeclaration.getName(), (String)"fooStruct");
        IASTTypedefDeclaration iASTTypedefDeclaration2 = (IASTTypedefDeclaration)iterator.next();
        iASTClassSpecifier = (IASTClassSpecifier)iASTTypedefDeclaration2.getAbstractDeclarator().getTypeSpecifier();
        Assert.assertEquals((Object)iASTClassSpecifier.getClassKind(), (Object)ASTClassKind.STRUCT);
        Assert.assertEquals((String)iASTClassSpecifier.getName(), (String)"");
        iterator2 = iASTClassSpecifier.getDeclarations();
        iASTField = (IASTField)iterator2.next();
        this.assertSimpleType((IASTVariable)iASTField, IASTSimpleTypeSpecifier.Type.INT);
        Assert.assertEquals((String)iASTField.getName(), (String)"anonInt");
        iASTField = (IASTField)iterator2.next();
        this.assertSimpleType((IASTVariable)iASTField, IASTSimpleTypeSpecifier.Type.CHAR);
        Assert.assertEquals((String)iASTField.getName(), (String)"anonChar");
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertEquals((String)iASTTypedefDeclaration2.getName(), (String)"anonStruct");
    }

    public void testASMDefinition() throws Exception {
        Iterator iterator = this.parse("asm( \"mov ep1 ds2\");").getDeclarations();
        IASTASMDefinition iASTASMDefinition = (IASTASMDefinition)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTASMDefinition.getBody(), (String)"mov ep1 ds2");
    }

    public void testConstructorChain() throws Exception {
        Iterator iterator = this.parse("TrafficLight_Actor::TrafficLight_Actor( RTController * rtg_rts, RTActorRef * rtg_ref )\t: RTActor( rtg_rts, rtg_ref ), myId( 0 ) {}").getDeclarations();
        iterator.next();
    }

    public void testBug36237() throws Exception {
        this.parse("A::A():B( (char *)0 ){}");
    }

    public void testBug36532() throws Exception {
        try {
            this.parse("template<int f() {\n");
            Assert.fail((String)"We should not make it this far");
        }
        catch (ParserException parserException) {
        }
        catch (Exception exception) {
            Assert.fail((String)("We should have gotten a ParserException rather than" + exception));
        }
    }

    public void testPreprocessor() throws Exception {
        String string = "#include <stdio.h>\n#define DEF VALUE\n";
        IASTCompilationUnit iASTCompilationUnit = this.parse(string.toString());
        Assert.assertFalse((boolean)iASTCompilationUnit.getDeclarations().hasNext());
        Iterator iterator = this.quickParseCallback.getInclusions();
        Iterator iterator2 = this.quickParseCallback.getMacros();
        IASTInclusion iASTInclusion = (IASTInclusion)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTInclusion.getName(), (String)"stdio.h");
        Assert.assertEquals((int)iASTInclusion.getStartingOffset(), (int)0);
        Assert.assertEquals((int)iASTInclusion.getNameOffset(), (int)string.indexOf("stdio.h"));
        Assert.assertEquals((int)iASTInclusion.getEndingOffset(), (int)(string.indexOf(">") + 1));
        IASTMacro iASTMacro = (IASTMacro)iterator2.next();
        Assert.assertEquals((String)iASTMacro.getName(), (String)"DEF");
        Assert.assertEquals((int)iASTMacro.getStartingOffset(), (int)string.indexOf("#define"));
        Assert.assertEquals((int)iASTMacro.getNameOffset(), (int)string.indexOf("DEF"));
        Assert.assertEquals((int)iASTMacro.getEndingOffset(), (int)(string.indexOf("VALUE") + 5));
    }

    public void testTemplateDeclarationOfFunction() throws Exception {
        Iterator iterator = this.parse("template<class A, typename B=C> A aTemplatedFunction( B bInstance );").getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = iASTTemplateDeclaration.getTemplateParameters();
        IASTTemplateParameter iASTTemplateParameter = (IASTTemplateParameter)iterator2.next();
        Assert.assertEquals((Object)iASTTemplateParameter.getTemplateParameterKind(), (Object)IASTTemplateParameter.ParamKind.CLASS);
        Assert.assertEquals((String)iASTTemplateParameter.getIdentifier(), (String)"A");
        iASTTemplateParameter = (IASTTemplateParameter)iterator2.next();
        Assert.assertEquals((Object)iASTTemplateParameter.getTemplateParameterKind(), (Object)IASTTemplateParameter.ParamKind.TYPENAME);
        Assert.assertEquals((String)iASTTemplateParameter.getIdentifier(), (String)"B");
        Assert.assertEquals((String)iASTTemplateParameter.getDefaultValueIdExpression(), (String)"C");
        IASTFunction iASTFunction = (IASTFunction)iASTTemplateDeclaration.getOwnedDeclaration();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"aTemplatedFunction");
        this.assertSimpleReturnType(iASTFunction, IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME);
        Assert.assertEquals((String)((IASTSimpleTypeSpecifier)iASTFunction.getReturnType().getTypeSpecifier()).getTypename(), (String)"A");
        Iterator iterator3 = iASTFunction.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator3.next();
        Assert.assertFalse((boolean)iterator3.hasNext());
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"bInstance");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME);
        Assert.assertEquals((String)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getTypename(), (String)"B");
    }

    public void testTemplateDeclarationOfClass() throws Exception {
        Iterator iterator = this.parse("template<class T, typename Tibor = junk, class, typename, int x, float y,template <class Y> class, template<class A> class AClass> class myarray { /* ... */ };").getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = iASTTemplateDeclaration.getTemplateParameters();
        IASTTemplateParameter iASTTemplateParameter = (IASTTemplateParameter)iterator2.next();
        Assert.assertEquals((Object)iASTTemplateParameter.getTemplateParameterKind(), (Object)IASTTemplateParameter.ParamKind.CLASS);
        Assert.assertEquals((String)iASTTemplateParameter.getIdentifier(), (String)"T");
        iASTTemplateParameter = (IASTTemplateParameter)iterator2.next();
        Assert.assertEquals((Object)iASTTemplateParameter.getTemplateParameterKind(), (Object)IASTTemplateParameter.ParamKind.TYPENAME);
        Assert.assertEquals((String)iASTTemplateParameter.getIdentifier(), (String)"Tibor");
        Assert.assertEquals((String)iASTTemplateParameter.getDefaultValueIdExpression(), (String)"junk");
        iASTTemplateParameter = (IASTTemplateParameter)iterator2.next();
        Assert.assertEquals((Object)iASTTemplateParameter.getTemplateParameterKind(), (Object)IASTTemplateParameter.ParamKind.CLASS);
        Assert.assertEquals((String)iASTTemplateParameter.getIdentifier(), (String)"");
        iASTTemplateParameter = (IASTTemplateParameter)iterator2.next();
        Assert.assertEquals((Object)iASTTemplateParameter.getTemplateParameterKind(), (Object)IASTTemplateParameter.ParamKind.TYPENAME);
        Assert.assertEquals((String)iASTTemplateParameter.getIdentifier(), (String)"");
        iASTTemplateParameter = (IASTTemplateParameter)iterator2.next();
        Assert.assertEquals((Object)iASTTemplateParameter.getTemplateParameterKind(), (Object)IASTTemplateParameter.ParamKind.PARAMETER);
        Assert.assertEquals((String)iASTTemplateParameter.getParameterDeclaration().getName(), (String)"x");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTTemplateParameter.getParameterDeclaration().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.INT);
        iASTTemplateParameter = (IASTTemplateParameter)iterator2.next();
        Assert.assertEquals((Object)iASTTemplateParameter.getTemplateParameterKind(), (Object)IASTTemplateParameter.ParamKind.PARAMETER);
        Assert.assertEquals((String)iASTTemplateParameter.getParameterDeclaration().getName(), (String)"y");
        Assert.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTTemplateParameter.getParameterDeclaration().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.FLOAT);
        iASTTemplateParameter = (IASTTemplateParameter)iterator2.next();
        Assert.assertEquals((Object)iASTTemplateParameter.getTemplateParameterKind(), (Object)IASTTemplateParameter.ParamKind.TEMPLATE_LIST);
        Assert.assertEquals((String)iASTTemplateParameter.getIdentifier(), (String)"");
        Iterator iterator3 = iASTTemplateParameter.getTemplateParameters();
        iASTTemplateParameter = (IASTTemplateParameter)iterator3.next();
        Assert.assertFalse((boolean)iterator3.hasNext());
        Assert.assertEquals((Object)iASTTemplateParameter.getTemplateParameterKind(), (Object)IASTTemplateParameter.ParamKind.CLASS);
        Assert.assertEquals((String)iASTTemplateParameter.getIdentifier(), (String)"Y");
        iASTTemplateParameter = (IASTTemplateParameter)iterator2.next();
        Assert.assertEquals((Object)iASTTemplateParameter.getTemplateParameterKind(), (Object)IASTTemplateParameter.ParamKind.TEMPLATE_LIST);
        Assert.assertEquals((String)iASTTemplateParameter.getIdentifier(), (String)"AClass");
        iterator3 = iASTTemplateParameter.getTemplateParameters();
        iASTTemplateParameter = (IASTTemplateParameter)iterator3.next();
        Assert.assertFalse((boolean)iterator3.hasNext());
        Assert.assertEquals((Object)iASTTemplateParameter.getTemplateParameterKind(), (Object)IASTTemplateParameter.ParamKind.CLASS);
        Assert.assertEquals((String)iASTTemplateParameter.getIdentifier(), (String)"A");
        Assert.assertFalse((boolean)iterator2.hasNext());
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iASTTemplateDeclaration.getOwnedDeclaration()).getTypeSpecifier();
        Assert.assertEquals((String)iASTClassSpecifier.getName(), (String)"myarray");
        Assert.assertFalse((boolean)iASTClassSpecifier.getDeclarations().hasNext());
    }

    public void testBug35906() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("void TTest::MTest() {}\n");
        stringWriter.write("struct TTest::STest *TTest::FTest (int i) {}\n");
        Iterator iterator = this.parse(stringWriter.toString()).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"TTest::MTest");
        this.assertSimpleReturnType(iASTFunction, IASTSimpleTypeSpecifier.Type.VOID);
        iASTFunction = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)iASTFunction.getName(), (String)"TTest::FTest");
        Assert.assertEquals((Object)((IASTElaboratedTypeSpecifier)iASTFunction.getReturnType().getTypeSpecifier()).getClassKind(), (Object)ASTClassKind.STRUCT);
        Assert.assertEquals((String)((IASTElaboratedTypeSpecifier)iASTFunction.getReturnType().getTypeSpecifier()).getName(), (String)"TTest::STest");
        Iterator iterator2 = iASTFunction.getReturnType().getPointerOperators();
        Assert.assertEquals(iterator2.next(), (Object)ASTPointerOperator.POINTER);
        Assert.assertFalse((boolean)iterator2.hasNext());
        Iterator iterator3 = iASTFunction.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator3.next();
        Assert.assertFalse((boolean)iterator3.hasNext());
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"i");
        this.assertParameterSimpleType(iASTParameterDeclaration, IASTSimpleTypeSpecifier.Type.INT);
    }

    public void testBug36288() throws Exception {
        Iterator iterator = this.parse("int foo() {}\nlong foo2(){}").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        this.assertSimpleReturnType(iASTFunction, IASTSimpleTypeSpecifier.Type.INT);
        Assert.assertEquals((String)iASTFunction.getName(), (String)"foo");
        iASTFunction = (IASTFunction)iterator.next();
        this.assertSimpleReturnType(iASTFunction, IASTSimpleTypeSpecifier.Type.INT);
        Assert.assertTrue((boolean)((IASTSimpleTypeSpecifier)iASTFunction.getReturnType().getTypeSpecifier()).isLong());
        Assert.assertEquals((String)iASTFunction.getName(), (String)"foo2");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug36250() throws Exception {
        Iterator iterator = this.parse("int f( int = 0 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertSimpleReturnType(iASTFunction, IASTSimpleTypeSpecifier.Type.INT);
        Assert.assertEquals((String)iASTFunction.getName(), (String)"f");
        Iterator iterator2 = iASTFunction.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        this.assertParameterSimpleType(iASTParameterDeclaration, IASTSimpleTypeSpecifier.Type.INT);
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"");
        Assert.assertEquals((Object)iASTParameterDeclaration.getDefaultValue().getKind(), (Object)IASTInitializerClause.Kind.ASSIGNMENT_EXPRESSION);
        Assert.assertEquals((Object)iASTParameterDeclaration.getDefaultValue().getAssigmentExpression().getExpressionKind(), (Object)IASTExpression.Kind.PRIMARY_INTEGER_LITERAL);
        Assert.assertEquals((String)iASTParameterDeclaration.getDefaultValue().getAssigmentExpression().getLiteralString(), (String)"0");
    }

    public void testBug36240() throws Exception {
        Iterator iterator = this.parse("A & A::operator=( A ){}").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTSimpleTypeSpecifier iASTSimpleTypeSpecifier = (IASTSimpleTypeSpecifier)iASTFunction.getReturnType().getTypeSpecifier();
        Assert.assertEquals((Object)iASTSimpleTypeSpecifier.getType(), (Object)IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME);
        Assert.assertEquals((String)iASTSimpleTypeSpecifier.getTypename(), (String)"A");
        Iterator iterator2 = iASTFunction.getReturnType().getPointerOperators();
        Assert.assertEquals(iterator2.next(), (Object)ASTPointerOperator.REFERENCE);
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertEquals((String)iASTFunction.getName(), (String)"A::operator =");
        Iterator iterator3 = iASTFunction.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator3.next();
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"");
        iASTSimpleTypeSpecifier = (IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier();
        Assert.assertEquals((Object)iASTSimpleTypeSpecifier.getType(), (Object)IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME);
        Assert.assertEquals((String)iASTSimpleTypeSpecifier.getTypename(), (String)"A");
    }

    public void testBug36254() throws Exception {
        Iterator iterator = this.parse("unsigned i;\nvoid f( unsigned p1 = 0 );").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        this.assertSimpleType(iASTVariable, IASTSimpleTypeSpecifier.Type.INT);
        Assert.assertTrue((boolean)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).isUnsigned());
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        this.assertSimpleReturnType(iASTFunction, IASTSimpleTypeSpecifier.Type.VOID);
        Assert.assertEquals((String)iASTFunction.getName(), (String)"f");
        Iterator iterator2 = iASTFunction.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"p1");
        this.assertParameterSimpleType(iASTParameterDeclaration, IASTSimpleTypeSpecifier.Type.INT);
        Assert.assertTrue((boolean)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).isUnsigned());
        Assert.assertEquals((Object)iASTParameterDeclaration.getDefaultValue().getKind(), (Object)IASTInitializerClause.Kind.ASSIGNMENT_EXPRESSION);
        Assert.assertEquals((Object)iASTParameterDeclaration.getDefaultValue().getAssigmentExpression().getExpressionKind(), (Object)IASTExpression.Kind.PRIMARY_INTEGER_LITERAL);
        Assert.assertEquals((String)iASTParameterDeclaration.getDefaultValue().getAssigmentExpression().getLiteralString(), (String)"0");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug36432() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define CMD_GET\t\t\"g\"\n");
        ((Writer)stringWriter).write("#define CMD_ACTION   \t\"a\"\n");
        ((Writer)stringWriter).write("#define CMD_QUIT\t\t\"q\"\n");
        ((Writer)stringWriter).write("static const memevent_cmd_func memevent_cmd_funcs[sizeof memevent_cmds - 1] = {\n");
        ((Writer)stringWriter).write("memevent_get,\n");
        ((Writer)stringWriter).write("memevent_action,\n");
        ((Writer)stringWriter).write("memevent_quit,\n");
        ((Writer)stringWriter).write("};\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36594() throws Exception {
        this.parse("const int n = sizeof(A) / sizeof(B);");
    }

    public void testBug36794() throws Exception {
        this.parse("template<> class allocator<void> {};");
        Iterator iterator = this.quickParseCallback.iterateOffsetableElements();
        while (iterator.hasNext()) {
            Assert.assertNotNull(iterator.next());
        }
    }

    public void testBug36799() throws Exception {
        this.parse("static const int __WORD_BIT = int(CHAR_BIT*sizeof(unsigned int));");
    }

    public void testBug36764() throws Exception {
        this.parse("struct{ int x : 4; int y : 8; };");
    }

    public void testOrder() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define __SGI_STL_INTERNAL_ALGOBASE_H\n");
        ((Writer)stringWriter).write("#include <string.h>\n");
        ((Writer)stringWriter).write("template <class _Tp>\n");
        ((Writer)stringWriter).write("inline void swap(_Tp& __a, _Tp& __b) {\n");
        ((Writer)stringWriter).write("__STL_REQUIRES(_Tp, _Assignable);\n");
        ((Writer)stringWriter).write("_Tp __tmp = __a;\n");
        ((Writer)stringWriter).write("__a = __b;\n");
        ((Writer)stringWriter).write("__b = __tmp;\n");
        ((Writer)stringWriter).write("}\n");
        this.parse(((Object)stringWriter).toString());
        Iterator iterator = this.quickParseCallback.iterateOffsetableElements();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)(iterator.next() instanceof IASTMacro));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)(iterator.next() instanceof IASTInclusion));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)(iterator.next() instanceof IASTDeclaration));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug36771() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include /**/ \"foo.h\"\n");
        this.parse(((Object)stringWriter).toString());
        Iterator iterator = this.quickParseCallback.getInclusions();
        IASTInclusion iASTInclusion = (IASTInclusion)iterator.next();
        Assert.assertTrue((boolean)iASTInclusion.getName().equals("foo.h"));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug36811() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("using namespace std;\n");
        ((Writer)stringWriter).write("class Test {};");
        this.parse(((Object)stringWriter).toString());
        Iterator iterator = this.quickParseCallback.iterateOffsetableElements();
        while (iterator.hasNext()) {
            Assert.assertNotNull(iterator.next());
        }
    }

    public void testBug36708() throws Exception {
        Iterator iterator = this.parse("enum { isPointer = PointerTraits<T>::result };").getDeclarations();
        IASTEnumerationSpecifier iASTEnumerationSpecifier = (IASTEnumerationSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = iASTEnumerationSpecifier.getEnumerators();
        IASTEnumerator iASTEnumerator = (IASTEnumerator)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertEquals((String)iASTEnumerator.getName(), (String)"isPointer");
        Assert.assertEquals((Object)iASTEnumerator.getInitialValue().getExpressionKind(), (Object)IASTExpression.Kind.ID_EXPRESSION);
        Assert.assertEquals((String)iASTEnumerator.getInitialValue().getIdExpression(), (String)"PointerTraits<T>::result");
    }

    public void testBug36690() throws Exception {
        this.parse("Functor(const Functor& rhs) : spImpl_(Impl::Clone(rhs.spImpl_.get())){}").getDeclarations();
    }

    public void testBug36703() throws Exception {
        this.parse("const std::type_info& Get() const;");
    }

    public void testBug36692() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <typename T, typename Destroyer>\n");
        ((Writer)stringWriter).write("void SetLongevity(T* pDynObject, unsigned int longevity,\n");
        ((Writer)stringWriter).write("Destroyer d = Private::Deleter<T>::Delete){}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36551() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class TextFrame {\n");
        ((Writer)stringWriter).write("BAD_MACRO()\n");
        ((Writer)stringWriter).write("};");
        this.parse(((Object)stringWriter).toString(), true, false);
    }

    public void testBug36247() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A {\n");
        ((Writer)stringWriter).write("INLINE_DEF int f ();\n");
        ((Writer)stringWriter).write("INLINE_DEF A   g ();");
        ((Writer)stringWriter).write("INLINE_DEF A * h ();");
        ((Writer)stringWriter).write("INLINE_DEF A & unlock( void );");
        ((Writer)stringWriter).write("};");
        this.parse(((Object)stringWriter).toString());
    }

    public void testStruct() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("struct mad_bitptr { unsigned char const *byte;\n");
        stringWriter.write("unsigned short cache;\n unsigned short left;};");
        this.parse(stringWriter.toString());
    }

    public void testBug36559() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace myNameSpace {\n");
        ((Writer)stringWriter).write("template<typename T=short> class B {};\n");
        ((Writer)stringWriter).write("template<> class B<int> {};\n");
        ((Writer)stringWriter).write("}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testPointersToFunctions() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void (*name)( void );\n");
        ((Writer)stringWriter).write("static void * (* const orig_malloc_hook)(const char *file, int line, size_t size);\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        this.assertSimpleType(iASTVariable, IASTSimpleTypeSpecifier.Type.VOID);
        Assert.assertEquals((String)iASTVariable.getName(), (String)"name");
        Iterator iterator2 = iASTVariable.getAbstractDeclaration().getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        this.assertParameterSimpleType(iASTParameterDeclaration, IASTSimpleTypeSpecifier.Type.VOID);
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"");
        iASTVariable = (IASTVariable)iterator.next();
        this.assertSimpleType(iASTVariable, IASTSimpleTypeSpecifier.Type.VOID);
        Assert.assertTrue((boolean)iASTVariable.isStatic());
        Iterator iterator3 = iASTVariable.getAbstractDeclaration().getPointerOperators();
        Assert.assertEquals(iterator3.next(), (Object)ASTPointerOperator.POINTER);
        Assert.assertFalse((boolean)iterator3.hasNext());
        iterator2 = iASTVariable.getAbstractDeclaration().getParameters();
        iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        this.assertParameterSimpleType(iASTParameterDeclaration, IASTSimpleTypeSpecifier.Type.CHAR);
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"file");
        Assert.assertTrue((boolean)iASTParameterDeclaration.isConst());
        Assert.assertTrue((boolean)iASTParameterDeclaration.getPointerOperators().hasNext());
        iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        this.assertParameterSimpleType(iASTParameterDeclaration, IASTSimpleTypeSpecifier.Type.INT);
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"line");
        iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        this.assertParameterSimpleType(iASTParameterDeclaration, IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME);
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"size");
        Assert.assertFalse((boolean)iterator2.hasNext());
    }

    public void testBug36600() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.parse("enum mad_flow (*input_func)(void *, struct mad_stream *);").getDeclarations().next();
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier();
        Assert.assertEquals((String)iASTElaboratedTypeSpecifier.getName(), (String)"mad_flow");
        Assert.assertEquals((Object)iASTElaboratedTypeSpecifier.getClassKind(), (Object)ASTClassKind.ENUM);
        Assert.assertEquals((String)iASTVariable.getName(), (String)"input_func");
        Iterator iterator = iASTVariable.getAbstractDeclaration().getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator.next();
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"");
        Assert.assertEquals(iASTParameterDeclaration.getPointerOperators().next(), (Object)ASTPointerOperator.POINTER);
        this.assertParameterSimpleType(iASTParameterDeclaration, IASTSimpleTypeSpecifier.Type.VOID);
        iASTParameterDeclaration = (IASTParameterDeclaration)iterator.next();
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"");
        Assert.assertEquals(iASTParameterDeclaration.getPointerOperators().next(), (Object)ASTPointerOperator.POINTER);
        iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier();
        Assert.assertEquals((String)iASTElaboratedTypeSpecifier.getName(), (String)"mad_stream");
        Assert.assertEquals((Object)iASTElaboratedTypeSpecifier.getClassKind(), (Object)ASTClassKind.STRUCT);
    }

    public void testBug36713() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("A ( * const fPtr) (void *); \n");
        ((Writer)stringWriter).write("A (* const fPtr2) ( A * ); \n");
        this.parse(((Object)stringWriter).toString()).getDeclarations();
    }

    public void testPointersToMemberFunctions() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.parse("void (A::*name)(void);").getDeclarations().next();
        this.assertSimpleType(iASTVariable, IASTSimpleTypeSpecifier.Type.VOID);
        Assert.assertEquals((String)iASTVariable.getName(), (String)"A::* name");
        Assert.assertEquals((Object)iASTVariable.getAbstractDeclaration().getPointerToFunctionOperator(), (Object)ASTPointerOperator.POINTER);
        Iterator iterator = iASTVariable.getAbstractDeclaration().getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        this.assertParameterSimpleType(iASTParameterDeclaration, IASTSimpleTypeSpecifier.Type.VOID);
        Assert.assertEquals((String)iASTParameterDeclaration.getName(), (String)"");
    }

    public void testBug39550() throws Exception {
        this.parse("double x = 0x1.fp1;").getDeclarations().next();
    }

    public void testBug39552A(int n) throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("%:define glue(x, y) x %:%: y\t/* #define glue(x, y) x ## y. */\n");
        ((Writer)stringWriter).write("#ifndef glue\n");
        ((Writer)stringWriter).write("#error glue not defined!\n");
        ((Writer)stringWriter).write("#endif\n");
        ((Writer)stringWriter).write("%:define str(x) %:x\t\t/* #define str(x) #x */\n");
        ((Writer)stringWriter).write("int main (int argc, char *argv<::>) /* argv[] */\n");
        ((Writer)stringWriter).write("glue (<, %) /* { */\n");
        ((Writer)stringWriter).write("\t\t\t /* di_str[] = */\n");
        ((Writer)stringWriter).write("  const char di_str glue(<, :)glue(:, >) = str(%:%:<::><%%>%:);\n");
        ((Writer)stringWriter).write("  /* Check the glue macro actually pastes, and that the spelling of\n");
        ((Writer)stringWriter).write("\t all digraphs is preserved.  */\n");
        ((Writer)stringWriter).write("  if (glue(strc, mp) (di_str, \"%:%:<::><%%>%:\"))\n");
        ((Writer)stringWriter).write("\terr (\"Digraph spelling not preserved!\");\n");
        ((Writer)stringWriter).write("  return 0;\n");
        ((Writer)stringWriter).write("glue (%, >) /* } */\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug39552B(int n) throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("??=include <stdio.h>\n");
        ((Writer)stringWriter).write("??=define TWELVE 1??/\n");
        ((Writer)stringWriter).write("2\n");
        ((Writer)stringWriter).write("static const char str??(??) = \"0123456789??/n\";\n");
        ((Writer)stringWriter).write("int\n");
        ((Writer)stringWriter).write("main(void)\n");
        ((Writer)stringWriter).write("??<\n");
        ((Writer)stringWriter).write("  unsigned char x = 5;\n");
        ((Writer)stringWriter).write("  if (sizeof str != TWELVE)\n");
        ((Writer)stringWriter).write("\tabort ();\n");
        ((Writer)stringWriter).write("  /* Test ^=, the only multi-character token to come from trigraphs.  */\n");
        ((Writer)stringWriter).write("  x ??'= 3;\n");
        ((Writer)stringWriter).write("  if (x != 6)\n");
        ((Writer)stringWriter).write("\tabort ();\n");
        ((Writer)stringWriter).write("  if ((5 ??! 3) != 7)\n");
        ((Writer)stringWriter).write("\tabort ();\n");
        ((Writer)stringWriter).write("  return 0;\n");
        ((Writer)stringWriter).write("??>\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug39553() throws Exception {
        this.parse("#define COMP_INC \"foobar.h\"  \n#include COMP_INC\n");
        Assert.assertTrue((boolean)this.quickParseCallback.getInclusions().hasNext());
    }

    public void testBug39537() throws Exception {
        this.parse("typedef foo<(U::id > 0)> foobar;");
        Assert.assertTrue((boolean)this.quickParseCallback.getCompilationUnit().getDeclarations().hasNext());
    }

    public void testBug39546() throws Exception {
        this.parse("signed char c = (signed char) 0xffffffff;");
        Assert.assertTrue((boolean)this.quickParseCallback.getCompilationUnit().getDeclarations().hasNext());
    }

    public void testIndirectDeclarators() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.parse("void (*x)( int );").getDeclarations().next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"x");
        this.assertSimpleType(iASTVariable, IASTSimpleTypeSpecifier.Type.VOID);
        this.assertParameterSimpleType((IASTParameterDeclaration)iASTVariable.getAbstractDeclaration().getParameters().next(), IASTSimpleTypeSpecifier.Type.INT);
        Assert.assertEquals((Object)iASTVariable.getAbstractDeclaration().getPointerToFunctionOperator(), (Object)ASTPointerOperator.POINTER);
        iASTVariable = (IASTVariable)this.parse("const int * (* const something)( const int * const * const  );").getDeclarations().next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"something");
        Assert.assertEquals((Object)iASTVariable.getAbstractDeclaration().getPointerToFunctionOperator(), (Object)ASTPointerOperator.CONST_POINTER);
        Assert.assertTrue((boolean)iASTVariable.getAbstractDeclaration().isConst());
        this.assertSimpleType(iASTVariable, IASTSimpleTypeSpecifier.Type.INT);
        Assert.assertEquals(iASTVariable.getAbstractDeclaration().getPointerOperators().next(), (Object)ASTPointerOperator.POINTER);
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iASTVariable.getAbstractDeclaration().getParameters().next();
        this.assertParameterSimpleType(iASTParameterDeclaration, IASTSimpleTypeSpecifier.Type.INT);
        Iterator iterator = iASTParameterDeclaration.getPointerOperators();
        Assert.assertEquals(iterator.next(), (Object)ASTPointerOperator.CONST_POINTER);
        Assert.assertEquals(iterator.next(), (Object)ASTPointerOperator.CONST_POINTER);
        Assert.assertFalse((boolean)iterator.hasNext());
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)this.parse("typedef void (*life)(int);").getDeclarations().next();
        Assert.assertEquals((String)iASTTypedefDeclaration.getName(), (String)"life");
        this.assertSimpleType(iASTTypedefDeclaration, IASTSimpleTypeSpecifier.Type.VOID);
        this.assertParameterSimpleType((IASTParameterDeclaration)iASTTypedefDeclaration.getAbstractDeclarator().getParameters().next(), IASTSimpleTypeSpecifier.Type.INT);
        IASTFunction iASTFunction = (IASTFunction)this.parse("void (f)(void);").getDeclarations().next();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"f");
        iASTTypedefDeclaration = (IASTTypedefDeclaration)this.parse("typedef void (life)(int);").getDeclarations().next();
        Assert.assertEquals((String)iASTTypedefDeclaration.getName(), (String)"life");
    }

    public void testBug39532() throws Exception {
        this.parse("class N1::N2::B : public A {};");
        Assert.assertTrue((boolean)this.quickParseCallback.getCompilationUnit().getDeclarations().hasNext());
    }

    public void testBug39540() throws Exception {
        this.parse("class {} const null;");
        Assert.assertTrue((boolean)this.quickParseCallback.getCompilationUnit().getDeclarations().hasNext());
    }

    public void testBug39530() throws Exception {
        this.parse("X sPassed(-1)");
    }

    public void testBug39526() throws Exception {
        this.parse("UnitList unit_list (String(\"keV\"));");
    }

    public void testBug39535() throws Exception {
        this.parse("namespace bar = foo;");
    }

    public void testBug39504B() throws Exception {
        this.parse("int y = sizeof (int*);");
    }

    public void testBug39505A() throws Exception {
        this.parse("int AD::* gp_down = static_cast<int AD::*>(gp_stat);");
    }

    public void testBug39505B() throws Exception {
        this.parse("int* gp_down = static_cast<int*>(gp_stat);");
    }

    public void testBug42985() throws Exception {
        this.parse("const int x = 4; int y = ::x;");
    }

    public void testBug40419() throws Exception {
        StringWriter stringWriter = new StringWriter();
        try {
            ((Writer)stringWriter).write("template <class T, class U>\tstruct SuperSubclass {\n");
            ((Writer)stringWriter).write("enum { value = (::Loki::Conversion<const volatile U*, const volatile T*>::exists && \n");
            ((Writer)stringWriter).write("!::Loki::Conversion<const volatile T*, const volatile void*>::sameType) };\t};");
        }
        catch (IOException iOException) {}
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug39556() throws Exception {
        this.parse("int *restrict ip_fn (void);", true, true, ParserLanguage.C).getDeclarations().next();
    }

    public void testBug43371() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct Example { Example(); Example(int); ~Example();};");
        IASTCompilationUnit iASTCompilationUnit = this.parse(((Object)stringWriter).toString());
        Iterator iterator = iASTCompilationUnit.getDeclarations();
        Assert.assertTrue((boolean)iterator.hasNext());
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)(iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier() instanceof IASTClassSpecifier));
        Assert.assertTrue((((IASTClassSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier()).getClassKind() == ASTClassKind.STRUCT ? 1 : 0) != 0);
        Iterator iterator2 = ((IASTClassSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier()).getDeclarations();
        Assert.assertTrue((boolean)iterator2.hasNext());
        IASTMethod iASTMethod = (IASTMethod)iterator2.next();
        IASTMethod iASTMethod2 = (IASTMethod)iterator2.next();
        IASTMethod iASTMethod3 = (IASTMethod)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertTrue((iASTMethod.getVisiblity() == ASTAccessVisibility.PUBLIC ? 1 : 0) != 0);
        Assert.assertTrue((iASTMethod2.getVisiblity() == ASTAccessVisibility.PUBLIC ? 1 : 0) != 0);
        Assert.assertTrue((iASTMethod3.getVisiblity() == ASTAccessVisibility.PUBLIC ? 1 : 0) != 0);
    }

    public void testBug43644() throws Exception {
        Iterator iterator = this.parse("void foo();{ int x; }", true, false).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"foo");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug43062() throws Exception {
        Iterator iterator = this.parse("class X { operator short  (); \toperator int unsigned(); operator int signed(); };").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = iASTClassSpecifier.getDeclarations();
        IASTMethod iASTMethod = (IASTMethod)iterator2.next();
        IASTMethod iASTMethod2 = (IASTMethod)iterator2.next();
        IASTMethod iASTMethod3 = (IASTMethod)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        Assert.assertEquals((String)iASTMethod.getName(), (String)"operator short");
        Assert.assertEquals((String)iASTMethod2.getName(), (String)"operator int unsigned");
        Assert.assertEquals((String)iASTMethod3.getName(), (String)"operator int signed");
    }

    public void testBug39531() throws Exception {
        this.parse("class AString { operator char const *() const; };");
    }

    public void testBug40007() throws Exception {
        this.assertCodeFailsParse("int y = #;");
    }

    public void testBug40759() throws Exception {
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)this.assertSoleDeclaration("#define X SomeName \n class X {};")).getTypeSpecifier();
        Assert.assertEquals((int)(iASTClassSpecifier.getNameOffset() + 1), (int)iASTClassSpecifier.getNameEndOffset());
        Assert.assertEquals((String)iASTClassSpecifier.getName(), (String)"SomeName");
    }

    public void testBug44633() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <typename T> class A {};\n");
        ((Writer)stringWriter).write("class B {  template <typename T> friend class A;\n");
        ((Writer)stringWriter).write("void method();\n");
        ((Writer)stringWriter).write("};\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        Assert.assertTrue((boolean)(iterator.next() instanceof IASTTemplateDeclaration));
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = iASTClassSpecifier.getDeclarations();
        Assert.assertTrue((boolean)(iterator2.next() instanceof IASTTemplateDeclaration));
        Assert.assertTrue((boolean)(iterator2.next() instanceof IASTMethod));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug39525() throws Exception {
        this.parse("C &(C::*DD)(const C &x) = &C::operator=;");
    }

    public void testBug41935() throws Exception {
        Iterator iterator = this.parse("namespace A\t{  int x; } namespace B = A;").getDeclarations();
        Assert.assertTrue((boolean)(iterator.next() instanceof IASTNamespaceDefinition));
        IASTNamespaceAlias iASTNamespaceAlias = (IASTNamespaceAlias)iterator.next();
        Assert.assertEquals((String)iASTNamespaceAlias.getName(), (String)"B");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug39528() throws Exception {
        StringWriter stringWriter = new StringWriter();
        try {
            ((Writer)stringWriter).write("struct B: public A {\n");
            ((Writer)stringWriter).write("  A a;\n");
            ((Writer)stringWriter).write("  B() try : A(1), a(2)\n");
            ((Writer)stringWriter).write("\t{ throw 1; }\n");
            ((Writer)stringWriter).write("  catch (...)\n");
            ((Writer)stringWriter).write("\t{ if (c != 3) r |= 1; }\n");
            ((Writer)stringWriter).write("};\n");
        }
        catch (IOException iOException) {}
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)this.assertSoleDeclaration(((Object)stringWriter).toString())).getTypeSpecifier();
        Iterator iterator = iASTClassSpecifier.getDeclarations();
        Assert.assertTrue((boolean)(iterator.next() instanceof IASTField));
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iASTMethod.hasFunctionTryBlock());
    }

    public void testBug39538() throws Exception {
        this.parse("template C::operator int<float> ();");
    }

    public void testBug39536() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template<class E>\n");
        ((Writer)stringWriter).write("class X {\n");
        ((Writer)stringWriter).write("X<E>();  // This fails \n");
        ((Writer)stringWriter).write("inline X<E>(int); // This also fails \n");
        ((Writer)stringWriter).write("inline ~X<E>(); // This works fine \n");
        ((Writer)stringWriter).write("};\n");
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)this.assertSoleDeclaration(((Object)stringWriter).toString());
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iASTTemplateDeclaration.getOwnedDeclaration()).getTypeSpecifier();
        Iterator iterator = iASTClassSpecifier.getDeclarations();
        int n = 0;
        while (n < 3) {
            Assert.assertTrue((boolean)(iterator.next() instanceof IASTMethod));
            ++n;
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug39536A() throws Exception {
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)this.parse("template<class E> class X { X<E>(); };").getDeclarations().next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iASTTemplateDeclaration.getOwnedDeclaration()).getTypeSpecifier();
        IASTDeclaration iASTDeclaration = (IASTDeclaration)iASTClassSpecifier.getDeclarations().next();
        Assert.assertTrue((boolean)(iASTDeclaration instanceof IASTMethod));
    }

    public void testBug39536B() throws Exception {
        this.parse("template<class E> class X { inline X<E>(int); };");
    }

    public void testBug39542() throws Exception {
        this.parse("void f(int a, struct {int b[a];} c) {}");
    }

    public void testBug39549() throws Exception {
        this.parse("struct X x = { .b = 40, .z = { sizeof(X), 42 }, .t[3] = 2, .t.f[3].x = A * B };", true, true, ParserLanguage.C);
        this.parse("struct X x = { .b = 40, .z = { sizeof(X), 42,}, .t[3] = 2, .t.f[3].x = A * B  ,};", true, true, ParserLanguage.C);
    }

    public void testBug39551A() throws Exception {
        IASTFunction iASTFunction = (IASTFunction)this.parse("extern float _Complex conjf (float _Complex);", true, true, ParserLanguage.C).getDeclarations().next();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"conjf");
        Assert.assertTrue((boolean)((IASTSimpleTypeSpecifier)iASTFunction.getReturnType().getTypeSpecifier()).isComplex());
    }

    public void testBug39551B() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.parse("_Imaginary double id = 99.99 * __I__;", true, true, ParserLanguage.C).getDeclarations().next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"id");
        Assert.assertTrue((boolean)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).isImaginary());
    }

    public void testCBool() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.assertSoleDeclaration("_Bool x;", ParserLanguage.C);
        this.assertSimpleType(iASTVariable, IASTSimpleTypeSpecifier.Type._BOOL);
    }

    public void testBug39678() throws Exception {
        IASTVariable cfr_ignored_0 = (IASTVariable)this.assertSoleDeclaration("char *s = L\"a\" \"b\";");
    }

    public void testBug43110() throws Exception {
        IASTFunction iASTFunction = (IASTFunction)this.assertSoleDeclaration("void x( int y, ... );");
        Assert.assertTrue((boolean)iASTFunction.takesVarArgs());
        iASTFunction = (IASTFunction)this.assertSoleDeclaration("void x( int y... );");
        Assert.assertTrue((boolean)iASTFunction.takesVarArgs());
    }

    public void testBug47752() throws Exception {
        this.parse("void func( cFoo bar ) try {\t} catch ( const char * error ){\t}");
    }

    public void testBug47628() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void h(char) { }\n");
        ((Writer)stringWriter).write("void h(unsigned char) { }\n");
        ((Writer)stringWriter).write("void h(signed char) { }  // not shown in outline, parsed as char\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction.getName(), (String)"h");
        Iterator iterator2 = iASTFunction.getParameters();
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertTrue((boolean)(iASTParameterDeclaration.getTypeSpecifier() instanceof IASTSimpleTypeSpecifier));
        Assert.assertEquals((String)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getTypename(), (String)"char");
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction2.getName(), (String)"h");
        iterator2 = iASTFunction2.getParameters();
        iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertTrue((boolean)(iASTParameterDeclaration.getTypeSpecifier() instanceof IASTSimpleTypeSpecifier));
        Assert.assertEquals((String)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getTypename(), (String)"unsigned char");
        IASTFunction iASTFunction3 = (IASTFunction)iterator.next();
        Assert.assertEquals((String)iASTFunction3.getName(), (String)"h");
        iterator2 = iASTFunction3.getParameters();
        iASTParameterDeclaration = (IASTParameterDeclaration)iterator2.next();
        Assert.assertTrue((boolean)(iASTParameterDeclaration.getTypeSpecifier() instanceof IASTSimpleTypeSpecifier));
        Assert.assertEquals((String)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getTypename(), (String)"signed char");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug44336() throws Exception {
        Iterator iterator = this.parse("class A {};  typedef typename A foo;").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Assert.assertEquals((Object)iASTClassSpecifier.getClassKind(), (Object)ASTClassKind.CLASS);
        Assert.assertEquals((String)iASTClassSpecifier.getName(), (String)"A");
        IASTTypedefDeclaration cfr_ignored_0 = (IASTTypedefDeclaration)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug39705() throws Exception {
        this.parse("#ident \"@(#)filename.c   1.3 90/02/12\"");
    }

    public void testBug45235() throws Exception {
        Iterator iterator = this.parse("class A { friend class B; friend void f(); }; ").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        iterator = iASTClassSpecifier.getDeclarations();
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertTrue((boolean)iASTAbstractTypeSpecifierDeclaration.isFriendDeclaration());
        Assert.assertTrue((boolean)iASTFunction.isFriend());
    }

    public void testBug59179() throws Exception {
        Iterator iterator = this.parse("class __decl  main{  int main; };", true, false).getDeclarations();
        Assert.assertTrue((boolean)iterator.hasNext());
    }

    public void testBug57652() throws Exception {
        this.parse("struct file_operations driver_fops = {  open: device_open, release: device_release\t};", true, true, ParserLanguage.C).getDeclarations();
    }

    public void testBug60142() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.assertSoleDeclaration("unsigned long var;");
        Assert.assertEquals((String)iASTVariable.getName(), (String)"var");
        IASTSimpleTypeSpecifier iASTSimpleTypeSpecifier = (IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier();
        Assert.assertEquals((String)iASTSimpleTypeSpecifier.getTypename(), (String)"unsigned long");
        Assert.assertTrue((boolean)iASTSimpleTypeSpecifier.isLong());
        Assert.assertTrue((boolean)iASTSimpleTypeSpecifier.isUnsigned());
        Assert.assertEquals((Object)iASTSimpleTypeSpecifier.getType(), (Object)IASTSimpleTypeSpecifier.Type.INT);
    }

    public void testBug61431() throws Exception {
        int n = 0;
        while (n < 2) {
            ParserLanguage parserLanguage = n == 0 ? ParserLanguage.C : ParserLanguage.CPP;
            Iterator iterator = this.parse("int k[][] = { {0, {1}, {2,3}};", true, false, parserLanguage).getDeclarations();
            Assert.assertFalse((boolean)iterator.hasNext());
            ++n;
        }
    }

    public void testBadIdentifier() throws Exception {
        this.parse("class 0302 { private: int stinks; };", true, false);
    }

    public void testBug67622() throws Exception {
        this.parse("const char * x = __FILE__;");
    }

    public void testBug68116() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("char dummy[] = \"0123456789");
        int n = 0;
        while (n < 5000) {
            stringBuffer.append("0123456789");
            ++n;
        }
        stringBuffer.append("\";");
        this.parse(stringBuffer.toString());
    }

    public void testBug69161() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define MACRO(s) s\n ");
        ((Writer)stringWriter).write("char *testQueries[] =\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("MACRO(\",\"),\n");
        ((Writer)stringWriter).write("MACRO(\"(\"),\n");
        ((Writer)stringWriter).write("MACRO(\")\")\n");
        ((Writer)stringWriter).write("};\n");
        IASTVariable iASTVariable = (IASTVariable)this.assertSoleDeclaration(((Object)stringWriter).toString());
        Assert.assertTrue((boolean)this.quickParseCallback.problems.isEmpty());
        Assert.assertEquals((String)iASTVariable.getName(), (String)"testQueries");
    }

    public void testBug73524() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("static char fmt_1002[] = \"(/,\\002At iterate\\002,i5,4x,\\002f= \\002,1p,d12\\\r\n");
        ((Writer)stringWriter).write(".5,4x,\\002|proj g|= \\002,1p,d12.5)\";");
        IASTVariable cfr_ignored_0 = (IASTVariable)this.assertSoleDeclaration(((Object)stringWriter).toString(), ParserLanguage.C);
    }

    public void testBug100992() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class String { public: String(); ~String(); };");
        ((Writer)stringWriter).write("String::String(){}");
        ((Writer)stringWriter).write("String::~String(){}");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        Iterator iterator2 = ((IASTClassSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier()).getDeclarations();
        IASTMethod cfr_ignored_0 = (IASTMethod)iterator2.next();
        IASTMethod cfr_ignored_1 = (IASTMethod)iterator2.next();
        Assert.assertFalse((boolean)iterator2.hasNext());
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)(iASTFunction instanceof IASTMethod));
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Assert.assertFalse((boolean)(iASTFunction2 instanceof IASTMethod));
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

