/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import java.util.Iterator;
import junit.framework.Assert;
import org.eclipse.cdt.core.dom.ast.ASTSignatureUtil;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCastExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConversionName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTOperatorName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPointerToMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPPointerType;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.AST2BaseTest;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class AST2CPPTests
extends AST2BaseTest {
    public void testBug102825() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("#define CURLOPTTYPE_OBJECTPOINT   10000\n");
        stringBuffer.append("#define CINIT(name,type,number) CURLOPT_ ## name = CURLOPTTYPE_ ## type + number\n");
        stringBuffer.append("typedef enum {\n");
        stringBuffer.append("CINIT(FILE, OBJECTPOINT, 1),\n");
        stringBuffer.append("    CINIT(URL,  OBJECTPOINT, 2)\n");
        stringBuffer.append("} CURLoption ;\n");
        this.parseAndCheckBindings(stringBuffer.toString());
    }

    public void testBug78883() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("class B {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("B( int t );\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class A : public B {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("A( int t );\n");
        stringBuffer.append("};\n");
        stringBuffer.append("A::A( int t ) : B( t - 1 ){}\n");
        this.parseAndCheckBindings(stringBuffer.toString());
    }

    public void testBug77967() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("enum type {A};\n");
        stringBuffer.append("enum type a, b;\n");
        stringBuffer.append("type c; \n");
        stringBuffer.append("enum type2 {A, B};\n");
        stringBuffer.append("enum type2 d, e; \n");
        this.parseAndCheckBindings(stringBuffer.toString());
    }

    public void testBug75189() throws Exception {
        this.parseAndCheckBindings("struct A{};typedef int (*F) (A*);");
    }

    public void testBug75340() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parseAndCheckBindings("void f(int i = 0, int * p = 0);");
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        Assert.assertEquals((String)ASTSignatureUtil.getParameterSignature((IASTDeclarator)iASTSimpleDeclaration.getDeclarators()[0]), (String)"(int, int *)");
    }

    public void testBug79540() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("#define REF_WRAP(e) class A { public: A (){ } A& foo2(e& v) { return *this; } }\n");
        stringBuffer.append("class B\n");
        stringBuffer.append("{\n");
        stringBuffer.append("REF_WRAP(B);\n");
        stringBuffer.append("B();\n");
        stringBuffer.append("void foo();\n");
        stringBuffer.append("};\n");
        this.parseAndCheckBindings(stringBuffer.toString());
    }

    public void testBug103578() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("template <class T, int someConst=0>\n");
        stringBuffer.append("class WithTemplate {};\n");
        stringBuffer.append("int main ()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("WithTemplate <int, 10> normalInstance;\n");
        stringBuffer.append("const int localConst=10;\n");
        stringBuffer.append("WithTemplate <int, localConst> brokenInstance;\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("}\n");
        this.parseAndCheckBindings(stringBuffer.toString());
    }

    public void testBug78103() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("int *p1; int *p2;\n");
        stringBuffer.append("union {\n");
        stringBuffer.append("struct {int a; int b;} A;\n");
        stringBuffer.append("struct {int a; int b;};\n");
        stringBuffer.append("} MyStruct;\n");
        stringBuffer.append("void test (void) {\n");
        stringBuffer.append("p1 = &MyStruct.A.a;\n");
        stringBuffer.append("p2 = &MyStruct.b;\n");
        stringBuffer.append("        MyStruct.b = 1;\n");
        stringBuffer.append("}\n");
        this.parseAndCheckBindings(stringBuffer.toString());
    }

    public void testBug43579() throws Exception {
        this.parseAndCheckBindings("class A { int m; }; \n A * a; int A::*pm; \n int f(){} \n int f(int); \n int x = f(a->*pm);");
        this.parseAndCheckBindings("class A { int m; }; \n A * a; int A::*pm; \n int f(){} \n int f(int); \n int x = f(a->*pm);");
    }

    public void testBug43242() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("class A { int m(int); };\n");
        stringBuffer.append("A a; \n");
        stringBuffer.append("int (A::*pm)(int) = &A::m;\n");
        stringBuffer.append("int f(){} \n");
        stringBuffer.append("int f(int); \n");
        stringBuffer.append("int x = f((a.*pm)(5));\n");
        this.parseAndCheckBindings(stringBuffer.toString());
    }

    public void testBug43241() throws Exception {
        this.parseAndCheckBindings("int m(int); int (*pm)(int) = &m; int f(){} int f(int); int x = f((*pm)(5));");
    }

    public void testBug40768() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("int *zzz1 (char);\n");
        stringBuffer.append("int (*zzz2) (char); \n");
        stringBuffer.append("int ((*zzz3)) (char); \n");
        stringBuffer.append("int (*(zzz4)) (char); \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        this.assertNoProblemBindings(cPPNameCollector);
    }

    protected IASTTranslationUnit parseAndCheckBindings(String string) throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse(string, ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        this.assertNoProblemBindings(cPPNameCollector);
        return iASTTranslationUnit;
    }

    public void testBug40422() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A { int y; }; int A::* x = 0;", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        this.assertNoProblemBindings(cPPNameCollector);
    }

    public void testBug86282() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("void foo() { int (* f[])() = new (int (*[10])());  }", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        this.assertNoProblemBindings(cPPNameCollector);
    }

    public void testBug75858() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("bool f() {\n");
        stringBuffer.append("    int first, last;\n");
        stringBuffer.append("if(first < 1 || last > 99 )\n");
        stringBuffer.append("return false;\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        this.assertNoProblemBindings(cPPNameCollector);
    }

    public void testBug95424() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("void f(){ traits_type::copy(__r->_M_refdata(), __buf, __i); }", ParserLanguage.CPP, true, true);
        iASTTranslationUnit = this.parse("void f(){ traits_type::copy(__r->_M_refdata(), __buf, __i); }", ParserLanguage.CPP, false, true);
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        IASTExpressionStatement iASTExpressionStatement = (IASTExpressionStatement)iASTCompoundStatement.getStatements()[0];
        Assert.assertTrue((boolean)(iASTExpressionStatement.getExpression() instanceof IASTFunctionCallExpression));
    }

    public void testSimpleClass() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("class A { } a;");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTCompositeTypeSpecifier iASTCompositeTypeSpecifier = (IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        IASTName iASTName = iASTCompositeTypeSpecifier.getName();
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
        IASTName iASTName2 = iASTDeclarator.getName();
        ICompositeType iCompositeType = (ICompositeType)iASTName.resolveBinding();
        IVariable iVariable = (IVariable)iASTName2.resolveBinding();
        ICompositeType iCompositeType2 = (ICompositeType)iVariable.getType();
        Assert.assertNotNull((Object)iCompositeType);
        Assert.assertNotNull((Object)iVariable);
        Assert.assertSame((Object)iCompositeType, (Object)iCompositeType2);
    }

    public void testBug95411() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {\n");
        stringBuffer.append("    public:");
        stringBuffer.append("int x;");
        stringBuffer.append("A * next;");
        stringBuffer.append("};");
        stringBuffer.append("A * start;");
        stringBuffer.append("void test() {");
        stringBuffer.append("for(A *y = start; y->x != 0;  y = y->next) {");
        stringBuffer.append("42;");
        stringBuffer.append("}");
        stringBuffer.append("for(int x = 0 ; x < 10; x++ ) {");
        stringBuffer.append("}");
        stringBuffer.append("}");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        this.assertNoProblemBindings(cPPNameCollector);
    }

    public void testClassForwardDecl() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("class A; class A {};");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        Assert.assertEquals((int)iASTSimpleDeclaration.getDeclarators().length, (int)0);
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        IASTName iASTName = iASTElaboratedTypeSpecifier.getName();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[1];
        Assert.assertEquals((int)iASTSimpleDeclaration.getDeclarators().length, (int)0);
        IASTCompositeTypeSpecifier iASTCompositeTypeSpecifier = (IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        IASTName iASTName2 = iASTCompositeTypeSpecifier.getName();
        ICompositeType iCompositeType = (ICompositeType)iASTName.resolveBinding();
        ICompositeType iCompositeType2 = (ICompositeType)iASTName2.resolveBinding();
        Assert.assertNotNull((Object)iCompositeType);
        Assert.assertSame((Object)iCompositeType, (Object)iCompositeType2);
    }

    public void testVariable() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("class A {};  A a;");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        Assert.assertEquals((int)iASTSimpleDeclaration.getDeclarators().length, (int)0);
        IASTCompositeTypeSpecifier iASTCompositeTypeSpecifier = (IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        IASTName iASTName = iASTCompositeTypeSpecifier.getName();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[1];
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
        IASTName iASTName2 = iASTDeclarator.getName();
        IASTNamedTypeSpecifier iASTNamedTypeSpecifier = (IASTNamedTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        IASTName iASTName3 = iASTNamedTypeSpecifier.getName();
        IVariable iVariable = (IVariable)iASTName2.resolveBinding();
        ICompositeType iCompositeType = (ICompositeType)iVariable.getType();
        ICompositeType iCompositeType2 = (ICompositeType)iASTName3.resolveBinding();
        ICompositeType iCompositeType3 = (ICompositeType)iASTName.resolveBinding();
        Assert.assertNotNull((Object)iVariable);
        Assert.assertNotNull((Object)iCompositeType3);
        Assert.assertSame((Object)iCompositeType3, (Object)iCompositeType);
        Assert.assertSame((Object)iCompositeType, (Object)iCompositeType2);
    }

    public void testField() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("class A {  int f; };");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        Assert.assertEquals((int)iASTSimpleDeclaration.getDeclarators().length, (int)0);
        ICPPASTCompositeTypeSpecifier iCPPASTCompositeTypeSpecifier = (ICPPASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        IASTName iASTName = iCPPASTCompositeTypeSpecifier.getName();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iCPPASTCompositeTypeSpecifier.getMembers()[0];
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
        IASTName iASTName2 = iASTDeclarator.getName();
        ICPPClassType iCPPClassType = (ICPPClassType)iASTName.resolveBinding();
        IField iField = (IField)iASTName2.resolveBinding();
        Assert.assertNotNull((Object)iCPPClassType);
        Assert.assertNotNull((Object)iField);
        Assert.assertSame((Object)iField.getScope(), (Object)iCPPClassType.getCompositeScope());
    }

    public void testMethodDeclaration() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("class A { int f(); };");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        Assert.assertEquals((int)iASTSimpleDeclaration.getDeclarators().length, (int)0);
        IASTCompositeTypeSpecifier iASTCompositeTypeSpecifier = (IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        IASTName iASTName = iASTCompositeTypeSpecifier.getName();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTCompositeTypeSpecifier.getMembers()[0];
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
        IASTName iASTName2 = iASTDeclarator.getName();
        ICPPClassType iCPPClassType = (ICPPClassType)iASTName.resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)iASTName2.resolveBinding();
        Assert.assertNotNull((Object)iCPPClassType);
        Assert.assertNotNull((Object)iCPPMethod);
        Assert.assertSame((Object)iCPPMethod.getScope(), (Object)iCPPClassType.getCompositeScope());
    }

    public void testMethodDefinition() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" class A { void f();  };      \n");
        stringBuffer.append(" void A::f() { }              \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        Assert.assertEquals((int)iASTSimpleDeclaration.getDeclarators().length, (int)0);
        IASTCompositeTypeSpecifier iASTCompositeTypeSpecifier = (IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        IASTName iASTName = iASTCompositeTypeSpecifier.getName();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTCompositeTypeSpecifier.getMembers()[0];
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
        IASTName iASTName2 = iASTDeclarator.getName();
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1];
        IASTFunctionDeclarator iASTFunctionDeclarator = iASTFunctionDefinition.getDeclarator();
        ICPPASTQualifiedName iCPPASTQualifiedName = (ICPPASTQualifiedName)iASTFunctionDeclarator.getName();
        ICPPClassType iCPPClassType = (ICPPClassType)iASTName.resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)iASTName2.resolveBinding();
        ICPPMethod iCPPMethod2 = (ICPPMethod)iCPPASTQualifiedName.resolveBinding();
        IASTName[] iASTNameArray = iCPPASTQualifiedName.getNames();
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        IASTName iASTName3 = iASTNameArray[0];
        IASTName iASTName4 = iASTNameArray[1];
        ICPPClassType iCPPClassType2 = (ICPPClassType)iASTName3.resolveBinding();
        ICPPMethod iCPPMethod3 = (ICPPMethod)iASTName4.resolveBinding();
        Assert.assertNotNull((Object)iCPPClassType);
        Assert.assertNotNull((Object)iCPPMethod);
        Assert.assertSame((Object)iCPPMethod, (Object)iCPPMethod2);
        Assert.assertSame((Object)iCPPMethod2, (Object)iCPPMethod3);
        Assert.assertSame((Object)iCPPClassType, (Object)iCPPClassType2);
    }

    public void testMemberReference() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A { void f(); int i;    };   \n");
        stringBuffer.append("void A::f() { i; }                 \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        Assert.assertEquals((int)iASTSimpleDeclaration.getDeclarators().length, (int)0);
        IASTCompositeTypeSpecifier iASTCompositeTypeSpecifier = (IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        IASTName iASTName = iASTCompositeTypeSpecifier.getName();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTCompositeTypeSpecifier.getMembers()[0];
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
        IASTName iASTName2 = iASTDeclarator.getName();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTCompositeTypeSpecifier.getMembers()[1];
        iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
        IASTName iASTName3 = iASTDeclarator.getName();
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1];
        IASTFunctionDeclarator iASTFunctionDeclarator = iASTFunctionDefinition.getDeclarator();
        ICPPASTQualifiedName iCPPASTQualifiedName = (ICPPASTQualifiedName)iASTFunctionDeclarator.getName();
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        IASTExpressionStatement iASTExpressionStatement = (IASTExpressionStatement)iASTCompoundStatement.getStatements()[0];
        IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTExpressionStatement.getExpression();
        IASTName iASTName4 = iASTIdExpression.getName();
        ICPPClassType iCPPClassType = (ICPPClassType)iASTName.resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)iASTName2.resolveBinding();
        ICPPMethod iCPPMethod2 = (ICPPMethod)iCPPASTQualifiedName.resolveBinding();
        ICPPField iCPPField = (ICPPField)iASTName3.resolveBinding();
        ICPPField iCPPField2 = (ICPPField)iASTName4.resolveBinding();
        IASTName[] iASTNameArray = iCPPASTQualifiedName.getNames();
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        IASTName iASTName5 = iASTNameArray[0];
        IASTName iASTName6 = iASTNameArray[1];
        ICPPClassType iCPPClassType2 = (ICPPClassType)iASTName5.resolveBinding();
        ICPPMethod iCPPMethod3 = (ICPPMethod)iASTName6.resolveBinding();
        Assert.assertNotNull((Object)iCPPClassType);
        Assert.assertNotNull((Object)iCPPMethod);
        Assert.assertNotNull((Object)iCPPField);
        Assert.assertSame((Object)iCPPMethod, (Object)iCPPMethod2);
        Assert.assertSame((Object)iCPPMethod2, (Object)iCPPMethod3);
        Assert.assertSame((Object)iCPPClassType, (Object)iCPPClassType2);
        Assert.assertSame((Object)iCPPField, (Object)iCPPField2);
    }

    public void testBasicInheritance() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A { int i; };               \n");
        stringBuffer.append("class B : public A { void f(); }; \n");
        stringBuffer.append("void B::f() { i; }                \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        ICPPASTCompositeTypeSpecifier iCPPASTCompositeTypeSpecifier = (ICPPASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        IASTName iASTName = iCPPASTCompositeTypeSpecifier.getName();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iCPPASTCompositeTypeSpecifier.getMembers()[0];
        IASTName iASTName2 = iASTSimpleDeclaration.getDeclarators()[0].getName();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[1];
        iCPPASTCompositeTypeSpecifier = (ICPPASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        IASTName iASTName3 = iCPPASTCompositeTypeSpecifier.getName();
        ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier iCPPASTBaseSpecifier = iCPPASTCompositeTypeSpecifier.getBaseSpecifiers()[0];
        IASTName iASTName4 = iCPPASTBaseSpecifier.getName();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iCPPASTCompositeTypeSpecifier.getMembers()[0];
        IASTName iASTName5 = iASTSimpleDeclaration.getDeclarators()[0].getName();
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[2];
        ICPPASTQualifiedName iCPPASTQualifiedName = (ICPPASTQualifiedName)iASTFunctionDefinition.getDeclarator().getName();
        IASTName iASTName6 = iCPPASTQualifiedName.getNames()[0];
        IASTName iASTName7 = iCPPASTQualifiedName.getNames()[1];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        IASTExpressionStatement iASTExpressionStatement = (IASTExpressionStatement)iASTCompoundStatement.getStatements()[0];
        IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTExpressionStatement.getExpression();
        IASTName iASTName8 = iASTIdExpression.getName();
        ICPPField iCPPField = (ICPPField)iASTName8.resolveBinding();
        ICPPField iCPPField2 = (ICPPField)iASTName2.resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)iASTName4.resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)iASTName.resolveBinding();
        ICPPClassType iCPPClassType3 = (ICPPClassType)iASTName6.resolveBinding();
        ICPPClassType iCPPClassType4 = (ICPPClassType)iASTName3.resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)iASTName7.resolveBinding();
        ICPPMethod iCPPMethod2 = (ICPPMethod)iCPPASTQualifiedName.resolveBinding();
        ICPPMethod iCPPMethod3 = (ICPPMethod)iASTName5.resolveBinding();
        Assert.assertNotNull((Object)iCPPClassType2);
        Assert.assertNotNull((Object)iCPPClassType4);
        Assert.assertNotNull((Object)iCPPField2);
        Assert.assertNotNull((Object)iCPPMethod3);
        Assert.assertSame((Object)iCPPClassType2, (Object)iCPPClassType);
        Assert.assertSame((Object)iCPPClassType4, (Object)iCPPClassType3);
        Assert.assertSame((Object)iCPPField2, (Object)iCPPField);
        Assert.assertSame((Object)iCPPMethod3, (Object)iCPPMethod2);
        Assert.assertSame((Object)iCPPMethod2, (Object)iCPPMethod);
    }

    public void testNamespaces() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A{            \n");
        stringBuffer.append("   int a;               \n");
        stringBuffer.append("}                       \n");
        stringBuffer.append("namespace B{            \n");
        stringBuffer.append("   using namespace A;   \n");
        stringBuffer.append("}                       \n");
        stringBuffer.append("namespace C{            \n");
        stringBuffer.append("   using namespace A;   \n");
        stringBuffer.append("}                       \n");
        stringBuffer.append("                        \n");
        stringBuffer.append("namespace BC{           \n");
        stringBuffer.append("   using namespace B;   \n");
        stringBuffer.append("   using namespace C;   \n");
        stringBuffer.append("}                       \n");
        stringBuffer.append("                        \n");
        stringBuffer.append("void f(){               \n");
        stringBuffer.append("   BC::a++; //ok        \n");
        stringBuffer.append("}                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)13);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        ICPPNamespace iCPPNamespace2 = (ICPPNamespace)cPPNameCollector.getName(2).resolveBinding();
        ICPPNamespace iCPPNamespace3 = (ICPPNamespace)cPPNameCollector.getName(4).resolveBinding();
        ICPPNamespace iCPPNamespace4 = (ICPPNamespace)cPPNameCollector.getName(6).resolveBinding();
        IFunction iFunction = (IFunction)cPPNameCollector.getName(9).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace2, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace3, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace4, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 1);
    }

    public void testNameHiding() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int A;                       \n");
        stringBuffer.append("class A {};                  \n");
        stringBuffer.append("void f() {                   \n");
        stringBuffer.append("   A++;                      \n");
        stringBuffer.append("   class A a;                \n");
        stringBuffer.append("}                            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)6);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(0).resolveBinding();
        ICompositeType iCompositeType = (ICompositeType)cPPNameCollector.getName(1).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(5).resolveBinding();
        Assert.assertSame((Object)iVariable2.getType(), (Object)iCompositeType);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCompositeType, 2);
        iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        iCompositeType = (ICompositeType)cPPNameCollector.getName(1).resolveBinding();
        IBinding iBinding = cPPNameCollector.getName(3).resolveBinding();
        iVariable = (IVariable)cPPNameCollector.getName(0).resolveBinding();
        Assert.assertSame((Object)iVariable, (Object)iBinding);
    }

    public void testBlockTraversal() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A { void f(); };            \n");
        stringBuffer.append("class B;                          \n");
        stringBuffer.append("void A::f() {                     \n");
        stringBuffer.append("   B b;                           \n");
        stringBuffer.append("}                                 \n");
        stringBuffer.append("int B;                            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)9);
        ICompositeType iCompositeType = (ICompositeType)cPPNameCollector.getName(0).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(1).resolveBinding();
        ICompositeType iCompositeType2 = (ICompositeType)cPPNameCollector.getName(2).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(7).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(8).resolveBinding();
        Assert.assertSame((Object)iVariable.getType(), (Object)iCompositeType2);
        this.assertInstances(cPPNameCollector, (IBinding)iCompositeType, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iCompositeType2, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable2, 1);
    }

    public void testFunctionResolution() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f( int i );                      \n");
        stringBuffer.append("void f( char c );                     \n");
        stringBuffer.append("void main() {                         \n");
        stringBuffer.append("   f( 1 );\t\t//calls f( int );     \n");
        stringBuffer.append("   f( 'b' );                          \n");
        stringBuffer.append("}                                     \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(2).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction2, 2);
    }

    public void testSimpleStruct() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef struct {  \n");
        stringBuffer.append("    int x;        \n");
        stringBuffer.append("} S;              \n");
        stringBuffer.append("void f() {        \n");
        stringBuffer.append("    S myS;        \n");
        stringBuffer.append("    myS.x = 5;    \n");
        stringBuffer.append("}                 \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(1).resolveBinding();
        ITypedef iTypedef = (ITypedef)cPPNameCollector.getName(2).resolveBinding();
        IFunction iFunction = (IFunction)cPPNameCollector.getName(3).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(5).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPField, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iTypedef, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
    }

    public void testStructureTags_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A;             \n");
        stringBuffer.append("void f(){             \n");
        stringBuffer.append("   struct A;          \n");
        stringBuffer.append("   struct A * a;      \n");
        stringBuffer.append("}                     \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(4).resolveBinding();
        Assert.assertNotNull((Object)iVariable);
        Assert.assertNotNull((Object)iCPPClassType);
        Assert.assertNotNull((Object)iCPPClassType2);
        Assert.assertNotSame((Object)iCPPClassType, (Object)iCPPClassType2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType2, 2);
    }

    public void testStructureTags_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A;             \n");
        stringBuffer.append("void f(){             \n");
        stringBuffer.append("   struct A * a;      \n");
        stringBuffer.append("}                     \r\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(3).resolveBinding();
        Assert.assertNotNull((Object)iVariable);
        Assert.assertNotNull((Object)iCPPClassType);
        Assert.assertNotNull((Object)iCPPClassType2);
        Assert.assertSame((Object)iCPPClassType, (Object)iCPPClassType2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
    }

    public void testStructureDef() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A;                \r\n");
        stringBuffer.append("struct A * a;            \n");
        stringBuffer.append("struct A { int i; };     \n");
        stringBuffer.append("void f() {               \n");
        stringBuffer.append("   a->i;                 \n");
        stringBuffer.append("}                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(2).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(4).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPField, 2);
    }

    public void testStructureNamespace() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct x {};        \n");
        stringBuffer.append("void f( int x ) {   \n");
        stringBuffer.append("   struct x i;      \n");
        stringBuffer.append("}                   \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
    }

    public void testFunctionDef() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f( int a );        \n");
        stringBuffer.append("void f( int b ){        \n");
        stringBuffer.append("   b;                   \n");
        stringBuffer.append("}                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        IParameter iParameter = (IParameter)cPPNameCollector.getName(1).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iParameter, 3);
        IScope iScope = iParameter.getScope();
        Assert.assertNotNull((Object)iScope);
        Assert.assertSame((Object)iScope.getParent(), (Object)iFunction.getScope());
    }

    public void testSimpleFunctionCall() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f();              \n");
        stringBuffer.append("void g() {             \n");
        stringBuffer.append("   f();                \n");
        stringBuffer.append("}                      \n");
        stringBuffer.append("void f(){ }            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(1).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction2, 1);
    }

    public void testForLoop() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f() {                         \n");
        stringBuffer.append("   for( int i = 0; i < 5; i++ ) {  \n");
        stringBuffer.append("      i;                           \n");
        stringBuffer.append("   }                               \n");
        stringBuffer.append("}                                  \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 4);
    }

    public void testExpressionFieldReference() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A { int x; };    \n");
        stringBuffer.append("void f(){               \n");
        stringBuffer.append("   ((struct A *) 1)->x; \n");
        stringBuffer.append("}                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        IField iField = (IField)cPPNameCollector.getName(1).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iField, 2);
    }

    public void testEnumerations() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("enum hue { red, blue, green };     \n");
        stringBuffer.append("enum hue col, *cp;                 \n");
        stringBuffer.append("void f() {                         \n");
        stringBuffer.append("   col = blue;                     \n");
        stringBuffer.append("   cp = &col;                      \n");
        stringBuffer.append("   if( *cp != red )                \n");
        stringBuffer.append("      return;                      \n");
        stringBuffer.append("}                                  \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IEnumeration iEnumeration = (IEnumeration)cPPNameCollector.getName(0).resolveBinding();
        IEnumerator iEnumerator = (IEnumerator)cPPNameCollector.getName(1).resolveBinding();
        IEnumerator iEnumerator2 = (IEnumerator)cPPNameCollector.getName(2).resolveBinding();
        IEnumerator iEnumerator3 = (IEnumerator)cPPNameCollector.getName(3).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(5).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(6).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iEnumeration, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iEnumerator, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iEnumerator2, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iEnumerator3, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable2, 3);
        Assert.assertTrue((boolean)(iVariable2.getType() instanceof IPointerType));
        IPointerType iPointerType = (IPointerType)iVariable2.getType();
        Assert.assertSame((Object)iPointerType.getType(), (Object)iEnumeration);
    }

    public void testPointerToFunction() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int (*pfi)();", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(0).resolveBinding();
        IPointerType iPointerType = (IPointerType)iVariable.getType();
        Assert.assertTrue((boolean)(iPointerType.getType() instanceof IFunctionType));
        iASTTranslationUnit = this.parse("struct A; int (*pfi)( int, struct A * );", ParserLanguage.CPP);
        cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        iVariable = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        iPointerType = (IPointerType)iVariable.getType();
        Assert.assertTrue((boolean)(iPointerType.getType() instanceof IFunctionType));
        IFunctionType iFunctionType = (IFunctionType)iPointerType.getType();
        IType[] iTypeArray = iFunctionType.getParameterTypes();
        Assert.assertTrue((boolean)(iTypeArray[0] instanceof IBasicType));
        Assert.assertTrue((boolean)(iTypeArray[1] instanceof IPointerType));
        iPointerType = (IPointerType)iTypeArray[1];
        Assert.assertSame((Object)iPointerType.getType(), (Object)iCPPClassType);
    }

    public void testFunctionTypes() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A;                           \n");
        stringBuffer.append("int * f( int i, char c );           \n");
        stringBuffer.append("void ( *g ) ( A * );         \n");
        stringBuffer.append("void (* (*h)(A**) ) ( int ); \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        ICompositeType iCompositeType = (ICompositeType)iASTElaboratedTypeSpecifier.getName().resolveBinding();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[1];
        IFunction iFunction = (IFunction)iASTSimpleDeclaration.getDeclarators()[0].getName().resolveBinding();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[2];
        IVariable iVariable = (IVariable)iASTSimpleDeclaration.getDeclarators()[0].getNestedDeclarator().getName().resolveBinding();
        iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[3];
        IVariable iVariable2 = (IVariable)iASTSimpleDeclaration.getDeclarators()[0].getNestedDeclarator().getNestedDeclarator().getName().resolveBinding();
        IFunctionType iFunctionType = iFunction.getType();
        IType iType = iFunctionType.getReturnType();
        Assert.assertTrue((boolean)(iType instanceof IPointerType));
        Assert.assertTrue((boolean)(((IPointerType)iType).getType() instanceof IBasicType));
        IType[] iTypeArray = iFunctionType.getParameterTypes();
        Assert.assertEquals((int)iTypeArray.length, (int)2);
        Assert.assertTrue((boolean)(iTypeArray[0] instanceof IBasicType));
        Assert.assertTrue((boolean)(iTypeArray[1] instanceof IBasicType));
        IType iType2 = iVariable.getType();
        Assert.assertTrue((boolean)(iType2 instanceof IPointerType));
        Assert.assertTrue((boolean)(((IPointerType)iType2).getType() instanceof IFunctionType));
        IFunctionType iFunctionType2 = (IFunctionType)((IPointerType)iType2).getType();
        IType iType3 = iFunctionType2.getReturnType();
        Assert.assertTrue((boolean)(iType3 instanceof IBasicType));
        IType[] iTypeArray2 = iFunctionType2.getParameterTypes();
        Assert.assertEquals((int)iTypeArray2.length, (int)1);
        IType iType4 = iTypeArray2[0];
        Assert.assertTrue((boolean)(iType4 instanceof IPointerType));
        Assert.assertSame((Object)((IPointerType)iType4).getType(), (Object)iCompositeType);
        IType iType5 = iVariable2.getType();
        Assert.assertTrue((boolean)(iType5 instanceof IPointerType));
        Assert.assertTrue((boolean)(((IPointerType)iType5).getType() instanceof IFunctionType));
        IFunctionType iFunctionType3 = (IFunctionType)((IPointerType)iType5).getType();
        IType iType6 = iFunctionType3.getReturnType();
        IType[] iTypeArray3 = iFunctionType3.getParameterTypes();
        Assert.assertEquals((int)iTypeArray3.length, (int)1);
        IType iType7 = iTypeArray3[0];
        Assert.assertTrue((boolean)(iType7 instanceof IPointerType));
        Assert.assertTrue((boolean)(((IPointerType)iType7).getType() instanceof IPointerType));
        Assert.assertSame((Object)((IPointerType)((IPointerType)iType7).getType()).getType(), (Object)iCompositeType);
        Assert.assertTrue((boolean)(iType6 instanceof IPointerType));
        IFunctionType iFunctionType4 = (IFunctionType)((IPointerType)iType6).getType();
        IType iType8 = iFunctionType4.getReturnType();
        IType[] iTypeArray4 = iFunctionType4.getParameterTypes();
        Assert.assertTrue((boolean)(iType8 instanceof IBasicType));
        Assert.assertEquals((int)iTypeArray4.length, (int)1);
        Assert.assertTrue((boolean)(iTypeArray4[0] instanceof IBasicType));
    }

    public void testFnReturningPtrToFn() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("void ( * f( int ) )(){}", ParserLanguage.CPP);
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0];
        IFunction iFunction = (IFunction)iASTFunctionDefinition.getDeclarator().getNestedDeclarator().getName().resolveBinding();
        IFunctionType iFunctionType = iFunction.getType();
        Assert.assertTrue((boolean)(iFunctionType.getReturnType() instanceof IPointerType));
        Assert.assertTrue((boolean)(((IPointerType)iFunctionType.getReturnType()).getType() instanceof IFunctionType));
        Assert.assertEquals((int)iFunctionType.getParameterTypes().length, (int)1);
    }

    public void testUsingDeclaration_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f();                  \n");
        stringBuffer.append("namespace A {              \n");
        stringBuffer.append("   void g();               \n");
        stringBuffer.append("}                          \n");
        stringBuffer.append("namespace X {              \n");
        stringBuffer.append("   using ::f;              \n");
        stringBuffer.append("   using A::g;             \n");
        stringBuffer.append("}                          \n");
        stringBuffer.append("void h() {                 \n");
        stringBuffer.append("   X::f();                 \n");
        stringBuffer.append("   X::g();                 \n");
        stringBuffer.append("}                          \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(1).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(2).resolveBinding();
        ICPPNamespace iCPPNamespace2 = (ICPPNamespace)cPPNameCollector.getName(3).resolveBinding();
        ICPPUsingDeclaration iCPPUsingDeclaration = (ICPPUsingDeclaration)cPPNameCollector.getName(5).resolveBinding();
        ICPPDelegate[] iCPPDelegateArray = iCPPUsingDeclaration.getDelegates();
        Assert.assertEquals((int)iCPPDelegateArray.length, (int)1);
        Assert.assertSame((Object)iCPPDelegateArray[0].getBinding(), (Object)iFunction);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPDelegateArray[0], 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace2, 3);
        ICPPUsingDeclaration iCPPUsingDeclaration2 = (ICPPUsingDeclaration)cPPNameCollector.getName(8).resolveBinding();
        Assert.assertSame((Object)iCPPUsingDeclaration2.getDelegates()[0].getBinding(), (Object)iFunction2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPUsingDeclaration2.getDelegates()[0], 2);
    }

    public void testFunctionDeclarations() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int Int;      \n");
        stringBuffer.append("void f( int i );      \n");
        stringBuffer.append("void f( const int );  \n");
        stringBuffer.append("void f( Int i );      \n");
        stringBuffer.append("void g( char * );     \n");
        stringBuffer.append("void g( char [] );    \n");
        stringBuffer.append("void h( int()() );    \n");
        stringBuffer.append("void h( int (*) () ); \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(1).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(8).resolveBinding();
        IFunction iFunction3 = (IFunction)cPPNameCollector.getName(12).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction2, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction3, 2);
    }

    public void testProblem_AmbiguousInParent() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class P1 { public: int x; };        \n");
        stringBuffer.append("class P2 { public: int x; };        \n");
        stringBuffer.append("class B : public P1, public P2 {};  \n");
        stringBuffer.append("void main() {                       \n");
        stringBuffer.append("   B * b = new B();                 \n");
        stringBuffer.append("   b->x;                            \n");
        stringBuffer.append("}                                   \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IProblemBinding iProblemBinding = (IProblemBinding)cPPNameCollector.getName(12).resolveBinding();
        Assert.assertEquals((int)iProblemBinding.getID(), (int)4);
    }

    public void testVirtualParentLookup() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class D { public: int x; };       \n");
        stringBuffer.append("class C : public virtual D {};    \n");
        stringBuffer.append("class B : public virtual D {};    \n");
        stringBuffer.append("class A : public B, public C {};  \n");
        stringBuffer.append("void main() {                     \n");
        stringBuffer.append("   A * a = new A();               \n");
        stringBuffer.append("   a->x;                          \n");
        stringBuffer.append("}                                 \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)15);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        ICPPClassType iCPPClassType3 = (ICPPClassType)cPPNameCollector.getName(4).resolveBinding();
        ICPPClassType iCPPClassType4 = (ICPPClassType)cPPNameCollector.getName(6).resolveBinding();
        ICPPConstructor iCPPConstructor = iCPPClassType4.getConstructors()[0];
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType2, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType3, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType4, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPConstructor, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPField, 2);
    }

    public void testAmbiguousVirtualParentLookup() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class D { public: int x; };        \n");
        stringBuffer.append("class C : public D {};             \n");
        stringBuffer.append("class B : public D {};             \n");
        stringBuffer.append("class A : public B, public C {};   \n");
        stringBuffer.append("void main() {                      \n");
        stringBuffer.append("   A * a = new A();                \n");
        stringBuffer.append("   a->x;                           \n");
        stringBuffer.append("}                                  \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)15);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        ICPPClassType iCPPClassType3 = (ICPPClassType)cPPNameCollector.getName(4).resolveBinding();
        ICPPClassType iCPPClassType4 = (ICPPClassType)cPPNameCollector.getName(6).resolveBinding();
        ICPPConstructor iCPPConstructor = iCPPClassType4.getConstructors()[0];
        IProblemBinding iProblemBinding = (IProblemBinding)cPPNameCollector.getName(14).resolveBinding();
        Assert.assertEquals((int)iProblemBinding.getID(), (int)4);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType2, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType3, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType4, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPConstructor, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPField, 1);
    }

    public void testExtendedNamespaces() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {                      \n");
        stringBuffer.append("   int x;                          \n");
        stringBuffer.append("}                                  \n");
        stringBuffer.append("int x;                             \n");
        stringBuffer.append("namespace A {                      \n");
        stringBuffer.append("   void f() { x; }                 \n");
        stringBuffer.append("}                                  \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)6);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(2).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable2, 1);
    }

    public void testImplicitConstructors() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A { }; ");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTCompositeTypeSpecifier iASTCompositeTypeSpecifier = (IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        ICPPClassType iCPPClassType = (ICPPClassType)iASTCompositeTypeSpecifier.getName().resolveBinding();
        ICPPConstructor[] iCPPConstructorArray = iCPPClassType.getConstructors();
        Assert.assertNotNull((Object)iCPPConstructorArray);
        Assert.assertEquals((int)iCPPConstructorArray.length, (int)2);
        Assert.assertEquals((int)iCPPConstructorArray[0].getParameters().length, (int)1);
        IType iType = iCPPConstructorArray[0].getParameters()[0].getType();
        Assert.assertTrue((boolean)(iType instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iType).getType(), (int)1);
        Assert.assertEquals((int)iCPPConstructorArray[1].getParameters().length, (int)1);
        iType = iCPPConstructorArray[1].getParameters()[0].getType();
        Assert.assertTrue((boolean)(iType instanceof ICPPReferenceType));
        Assert.assertTrue((boolean)(((ICPPReferenceType)iType).getType() instanceof IQualifierType));
        IQualifierType iQualifierType = (IQualifierType)((ICPPReferenceType)iType).getType();
        Assert.assertTrue((boolean)iQualifierType.isConst());
        Assert.assertSame((Object)iQualifierType.getType(), (Object)iCPPClassType);
    }

    public void testConstructors() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A { A();  A( const A & ); }; ");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTCompositeTypeSpecifier iASTCompositeTypeSpecifier = (IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        ICPPClassType iCPPClassType = (ICPPClassType)iASTCompositeTypeSpecifier.getName().resolveBinding();
        ICPPConstructor[] iCPPConstructorArray = iCPPClassType.getConstructors();
        Assert.assertNotNull((Object)iCPPConstructorArray);
        Assert.assertEquals((int)iCPPConstructorArray.length, (int)2);
        Assert.assertEquals((int)iCPPConstructorArray[0].getParameters().length, (int)1);
        Assert.assertEquals((int)iCPPConstructorArray[1].getParameters().length, (int)1);
        IType iType = iCPPConstructorArray[1].getParameters()[0].getType();
        Assert.assertTrue((boolean)(iType instanceof ICPPReferenceType));
        Assert.assertTrue((boolean)(((ICPPReferenceType)iType).getType() instanceof IQualifierType));
        IQualifierType iQualifierType = (IQualifierType)((ICPPReferenceType)iType).getType();
        Assert.assertTrue((boolean)iQualifierType.isConst());
        Assert.assertSame((Object)iQualifierType.getType(), (Object)iCPPClassType);
    }

    public void testNamespaceAlias() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A { int x; }   \n");
        stringBuffer.append("namespace B = A;         \n");
        stringBuffer.append("int f(){ B::x;  }        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)8);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        ICPPNamespace iCPPNamespace2 = (ICPPNamespace)cPPNameCollector.getName(2).resolveBinding();
        Assert.assertTrue((boolean)(iCPPNamespace2 instanceof ICPPDelegate));
        Assert.assertSame((Object)((ICPPDelegate)iCPPNamespace2).getBinding(), (Object)iCPPNamespace);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace2, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 3);
    }

    public void testBug84250() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f() {                 \n");
        stringBuffer.append("   int ( *p ) [2];         \n");
        stringBuffer.append("   (&p)[0] = 1;            \n");
        stringBuffer.append("}                          \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)3);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        Assert.assertTrue((boolean)(iVariable.getType() instanceof IPointerType));
        Assert.assertTrue((boolean)(((IPointerType)iVariable.getType()).getType() instanceof IArrayType));
        IArrayType iArrayType = (IArrayType)((IPointerType)iVariable.getType()).getType();
        Assert.assertTrue((boolean)(iArrayType.getType() instanceof IBasicType));
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
    }

    public void testBug84250_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f() {                 \n");
        stringBuffer.append("   int ( *p ) [2];         \n");
        stringBuffer.append("   (&p)[0] = 1;            \n");
        stringBuffer.append("}                          \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)3);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(2).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        Assert.assertSame((Object)iVariable, (Object)iVariable2);
    }

    public void testBug84266() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct s { double i; } f(void);  \n");
        stringBuffer.append("struct s f(void){}               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)7);
        ICompositeType iCompositeType = (ICompositeType)cPPNameCollector.getName(4).resolveBinding();
        ICompositeType iCompositeType2 = (ICompositeType)cPPNameCollector.getName(0).resolveBinding();
        Assert.assertSame((Object)iCompositeType, (Object)iCompositeType2);
    }

    public void testBug84266_2() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("struct s f(void);", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)3);
        ICompositeType iCompositeType = (ICompositeType)cPPNameCollector.getName(0).resolveBinding();
        Assert.assertNotNull((Object)iCompositeType);
        iASTTranslationUnit = this.parse("struct s f(void){}", ParserLanguage.CPP);
        cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)3);
        iCompositeType = (ICompositeType)cPPNameCollector.getName(0).resolveBinding();
        Assert.assertNotNull((Object)iCompositeType);
    }

    public void testBug84228() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f( int m, int c[m][m] );        \n");
        stringBuffer.append("void f( int m, int c[m][m] ){        \n");
        stringBuffer.append("   int x;                            \n");
        stringBuffer.append("   { int x = x; }                    \n");
        stringBuffer.append("}                                    \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)13);
        IParameter iParameter = (IParameter)cPPNameCollector.getName(3).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(12).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(11).resolveBinding();
        IVariable iVariable3 = (IVariable)cPPNameCollector.getName(10).resolveBinding();
        Assert.assertSame((Object)iVariable2, (Object)iVariable);
        Assert.assertNotSame((Object)iVariable3, (Object)iVariable2);
        this.assertInstances(cPPNameCollector, (IBinding)iParameter, 6);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable3, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable2, 2);
    }

    public void testBug84615() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A { public : static int n; };  \n");
        stringBuffer.append("int main() {                         \n");
        stringBuffer.append("   int A;                            \n");
        stringBuffer.append("   A::n = 42;                        \n");
        stringBuffer.append("   A b;                              \n");
        stringBuffer.append("}                                    \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)9);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(1).resolveBinding();
        IBinding iBinding = cPPNameCollector.getName(5).resolveBinding();
        IBinding iBinding2 = cPPNameCollector.getName(6).resolveBinding();
        IProblemBinding iProblemBinding = (IProblemBinding)cPPNameCollector.getName(7).resolveBinding();
        Assert.assertSame((Object)iCPPClassType, (Object)iBinding);
        Assert.assertSame((Object)iCPPField, (Object)iBinding2);
        Assert.assertNotNull((Object)iProblemBinding);
    }

    public void testBug84371() throws Exception {
        String string = "int x = ::ABC::DEF::ghi;";
        IASTTranslationUnit iASTTranslationUnit = this.parse(string, ParserLanguage.CPP);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTInitializerExpression iASTInitializerExpression = (IASTInitializerExpression)iASTSimpleDeclaration.getDeclarators()[0].getInitializer();
        IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTInitializerExpression.getExpression();
        ICPPASTQualifiedName iCPPASTQualifiedName = (ICPPASTQualifiedName)iASTIdExpression.getName();
        Assert.assertTrue((boolean)iCPPASTQualifiedName.isFullyQualified());
        Assert.assertEquals((int)iCPPASTQualifiedName.getNames().length, (int)3);
        Assert.assertEquals((String)iCPPASTQualifiedName.getNames()[0].toString(), (String)"ABC");
        Assert.assertEquals((String)iCPPASTQualifiedName.getNames()[1].toString(), (String)"DEF");
        Assert.assertEquals((String)iCPPASTQualifiedName.getNames()[2].toString(), (String)"ghi");
    }

    public void testBug84679() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace Y { void f(float); }                         \n");
        stringBuffer.append("namespace A { using namespace Y; f(int); }             \n");
        stringBuffer.append("namespace B { void f(char);  }                         \n");
        stringBuffer.append("namespace AB { using namespace A; using namespace B; } \n");
        stringBuffer.append("void h(){         \n");
        stringBuffer.append("   AB::f(1);      \n");
        stringBuffer.append("   AB::f(`c`);    \n");
        stringBuffer.append("}                 \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, false);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        ICPPNamespace iCPPNamespace2 = (ICPPNamespace)cPPNameCollector.getName(3).resolveBinding();
        ICPPNamespace iCPPNamespace3 = (ICPPNamespace)cPPNameCollector.getName(7).resolveBinding();
        ICPPNamespace iCPPNamespace4 = (ICPPNamespace)cPPNameCollector.getName(10).resolveBinding();
        IFunction iFunction = (IFunction)cPPNameCollector.getName(16).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(5).resolveBinding();
        Assert.assertTrue((boolean)(cPPNameCollector.getName(19).resolveBinding() instanceof IProblemBinding));
        Assert.assertSame((Object)iFunction, (Object)iFunction2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace2, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace3, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace4, 3);
    }

    public void testBug84692() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct Node {          \n");
        stringBuffer.append("   struct Node* Next;  \n");
        stringBuffer.append("   struct Data* Data;  \n");
        stringBuffer.append("};                     \n");
        stringBuffer.append("struct Data {          \n");
        stringBuffer.append("   struct Node * node; \n");
        stringBuffer.append("   friend struct Glob; \n");
        stringBuffer.append("};                     \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)9);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(3).resolveBinding();
        Assert.assertSame((Object)iCPPClassType2.getScope(), (Object)iASTTranslationUnit.getScope());
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType2, 2);
    }

    public void testBug84686() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace B { int b; }                        \n");
        stringBuffer.append("namespace A { using namespace B;  int a;  }   \n");
        stringBuffer.append("namespace B { using namespace A; }            \n");
        stringBuffer.append("void f() { B::a++;  }                         \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)11);
        ICPPVariable iCPPVariable = (ICPPVariable)cPPNameCollector.getName(4).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(10).resolveBinding();
        Assert.assertSame((Object)iCPPVariable, (Object)iVariable);
    }

    public void testBug84705() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct C {                               \n");
        stringBuffer.append("   void f();                             \n");
        stringBuffer.append("   const C& operator=( const C& );       \n");
        stringBuffer.append("};                                       \n");
        stringBuffer.append("const C& C::operator=( const C& other) { \n");
        stringBuffer.append("   if( this != &other ) {                \n");
        stringBuffer.append("      this->~C();                        \n");
        stringBuffer.append("      new (this) C(other );              \n");
        stringBuffer.append("      f();                               \n");
        stringBuffer.append("   }                                     \n");
        stringBuffer.append("   return *this;                         \n");
        stringBuffer.append("}                                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)17);
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(1).resolveBinding();
        IASTName[] iASTNameArray = iASTTranslationUnit.getReferences((IBinding)iCPPMethod);
        Assert.assertEquals((int)1, (int)iASTNameArray.length);
        Assert.assertSame((Object)iCPPMethod, (Object)iASTNameArray[0].resolveBinding());
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPMethod iCPPMethod2 = (ICPPMethod)cPPNameCollector.getName(3).resolveBinding();
        IParameter iParameter = (IParameter)cPPNameCollector.getName(11).resolveBinding();
        ICPPMethod iCPPMethod3 = (ICPPMethod)cPPNameCollector.getName(13).resolveBinding();
        Assert.assertNotNull((Object)iCPPMethod3);
        Assert.assertEquals((String)iCPPMethod3.getName(), (String)"~C");
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 6);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod2, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iParameter, 4);
    }

    public void testThis() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A { void f(); void g() const; };   \n");
        stringBuffer.append("void A::f(){ this; }                     \n");
        stringBuffer.append("void A::g() const { *this; }             \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        ICPPClassType iCPPClassType = (ICPPClassType)((IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier()).getName().resolveBinding();
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1];
        IASTExpressionStatement iASTExpressionStatement = (IASTExpressionStatement)((IASTCompoundStatement)iASTFunctionDefinition.getBody()).getStatements()[0];
        Assert.assertTrue((boolean)(iASTExpressionStatement.getExpression() instanceof IASTLiteralExpression));
        IType iType = CPPVisitor.getExpressionType((IASTExpression)iASTExpressionStatement.getExpression());
        Assert.assertTrue((boolean)(iType instanceof IPointerType));
        Assert.assertSame((Object)((IPointerType)iType).getType(), (Object)iCPPClassType);
        iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[2];
        iASTExpressionStatement = (IASTExpressionStatement)((IASTCompoundStatement)iASTFunctionDefinition.getBody()).getStatements()[0];
        IASTUnaryExpression iASTUnaryExpression = (IASTUnaryExpression)iASTExpressionStatement.getExpression();
        iType = CPPVisitor.getExpressionType((IASTExpression)iASTUnaryExpression);
        Assert.assertTrue((boolean)(iType instanceof IQualifierType));
        Assert.assertSame((Object)((IQualifierType)iType).getType(), (Object)iCPPClassType);
        Assert.assertTrue((boolean)((IQualifierType)iType).isConst());
    }

    public void testBug84710() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class T { T(); };", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPConstructor iCPPConstructor = (ICPPConstructor)cPPNameCollector.getName(1).resolveBinding();
        Assert.assertTrue((boolean)CharArrayUtils.equals((char[])iCPPConstructor.getNameCharArray(), (char[])"T".toCharArray()));
        Assert.assertEquals((String)iCPPConstructor.getName(), (String)"T");
    }

    public void testArgumentDependantLookup() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace NS {                \n");
        stringBuffer.append("   class T {};                \n");
        stringBuffer.append("   void f( T );               \n");
        stringBuffer.append("}                             \n");
        stringBuffer.append("NS::T parm;                   \n");
        stringBuffer.append("int main() {                  \n");
        stringBuffer.append("   f( parm );                 \n");
        stringBuffer.append("}                             \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(1).resolveBinding();
        IFunction iFunction = (IFunction)cPPNameCollector.getName(2).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(8).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 4);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
    }

    public void testArgumentDependantLookup_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace NS1{                       \n");
        stringBuffer.append("   void f( void * );                 \n");
        stringBuffer.append("}                                    \n");
        stringBuffer.append("namespace NS2{                       \n");
        stringBuffer.append("   using namespace NS1;              \n");
        stringBuffer.append("   class B {};                       \n");
        stringBuffer.append("   void f( void * );                 \n");
        stringBuffer.append("}                                    \n");
        stringBuffer.append("class A : public NS2::B {} *a;       \n");
        stringBuffer.append("int main() {                         \n");
        stringBuffer.append("   f( a );                           \n");
        stringBuffer.append("}                                    \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(14).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(1).resolveBinding();
        IFunction iFunction3 = (IFunction)cPPNameCollector.getName(6).resolveBinding();
        Assert.assertSame((Object)iFunction3, (Object)iFunction);
        Assert.assertNotNull((Object)iFunction2);
        Assert.assertNotNull((Object)iFunction3);
    }

    public void testBug84610() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace { int i; } //1\n");
        stringBuffer.append("void f(){ i; }          \n");
        stringBuffer.append("namespace A {           \n");
        stringBuffer.append("   namespace {          \n");
        stringBuffer.append("      int i;    //2     \n");
        stringBuffer.append("      int j;            \n");
        stringBuffer.append("   }                    \n");
        stringBuffer.append("   void g(){ i; }       \n");
        stringBuffer.append("}                       \n");
        stringBuffer.append("using namespace A;      \n");
        stringBuffer.append("void h() {              \n");
        stringBuffer.append("   i;    //ambiguous    \n");
        stringBuffer.append("   A::i; //i2           \n");
        stringBuffer.append("   j;                   \n");
        stringBuffer.append("}                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)17, (int)cPPNameCollector.size());
        IVariable iVariable = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(6).resolveBinding();
        IVariable iVariable3 = (IVariable)cPPNameCollector.getName(7).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable2, 4);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable3, 2);
        IProblemBinding iProblemBinding = (IProblemBinding)cPPNameCollector.getName(12).resolveBinding();
        Assert.assertEquals((int)4, (int)iProblemBinding.getID());
    }

    public void testBug84703() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct B {          \n");
        stringBuffer.append("   void mutate();   \n");
        stringBuffer.append("};                  \n");
        stringBuffer.append("void g() {          \n");
        stringBuffer.append("   B* pb = new B(); \n");
        stringBuffer.append("   pb->mutate();    \n");
        stringBuffer.append("}                   \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)8, (int)cPPNameCollector.size());
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(4).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
    }

    public void testBug84469() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct S { int i; };        \n");
        stringBuffer.append("void f() {         ;        \n");
        stringBuffer.append("   int S::* pm = &S::i;      \n");
        stringBuffer.append("}                           \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)9, (int)cPPNameCollector.size());
    }

    public void testPointerToMemberType() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("struct S; int S::* pm;", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)4, (int)cPPNameCollector.size());
        IVariable iVariable = (IVariable)cPPNameCollector.getName(3).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        IType iType = iVariable.getType();
        Assert.assertNotNull((Object)iType);
        Assert.assertTrue((boolean)(iType instanceof ICPPPointerToMemberType));
        ICPPClassType iCPPClassType2 = ((ICPPPointerToMemberType)iType).getMemberOfClass();
        Assert.assertSame((Object)iCPPClassType, (Object)iCPPClassType2);
        Assert.assertTrue((boolean)(((ICPPPointerToMemberType)iType).getType() instanceof IBasicType));
    }

    public void testBug_PM_() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct S { int i ; } *s; \n");
        stringBuffer.append("int S::* pm = &S::i;     \n");
        stringBuffer.append("void f() {               \n");
        stringBuffer.append("   s->*pm = 1;           \n");
        stringBuffer.append("}                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IBinding iBinding = cPPNameCollector.getName(11).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(5).resolveBinding();
        Assert.assertSame((Object)iVariable, (Object)iBinding);
    }

    public void testBug_PM_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct S {               \n");
        stringBuffer.append("   int i;                \n");
        stringBuffer.append("   S* f();               \n");
        stringBuffer.append("} *s;                    \n");
        stringBuffer.append("S* (S::* pm) () = &S::f; \n");
        stringBuffer.append("void foo() {             \n");
        stringBuffer.append("   (s->*pm)()->i;        \n");
        stringBuffer.append("}                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(8).resolveBinding();
        IField iField = (IField)cPPNameCollector.getName(1).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(3).resolveBinding();
        IType iType = iVariable.getType();
        Assert.assertTrue((boolean)(iType instanceof ICPPPointerToMemberType));
        IFunctionType iFunctionType = (IFunctionType)((ICPPPointerToMemberType)iType).getType();
        ICPPClassType iCPPClassType2 = ((ICPPPointerToMemberType)iType).getMemberOfClass();
        Assert.assertTrue((boolean)(iFunctionType.getReturnType() instanceof IPointerType));
        Assert.assertSame((Object)iCPPClassType2, (Object)((IPointerType)iFunctionType.getReturnType()).getType());
        Assert.assertSame((Object)iCPPClassType, (Object)iCPPClassType2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 5);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iField, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod, 3);
    }

    public void _testBug84469() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct S { int i; };        \n");
        stringBuffer.append("void f() {         ;        \n");
        stringBuffer.append("   int S::* pm = &S::i;      \n");
        stringBuffer.append("}                           \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
    }

    public void testBug85049() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("struct B { };\n");
        stringBuffer.append("void g() {\n");
        stringBuffer.append("B * bp;  //1\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        Assert.assertTrue((boolean)(iASTCompoundStatement.getStatements()[0] instanceof IASTDeclarationStatement));
    }

    public void testPMConversions() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A { public: int i; };             \n");
        stringBuffer.append("class B : public A {};                  \n");
        stringBuffer.append("void f( int B::* );                     \n");
        stringBuffer.append("void g() {                              \n");
        stringBuffer.append("   int A::* pm = &A::i;                 \n");
        stringBuffer.append("   f( pm );                             \n");
        stringBuffer.append("}                                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(15).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(11).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 4);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPField, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType2, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
    }

    public void testPMKoenig() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace N {                            \n");
        stringBuffer.append("   class A { public: int i; };           \n");
        stringBuffer.append("   void f( int A::* );                   \n");
        stringBuffer.append("}                                        \n");
        stringBuffer.append("int N::A::* pm = &N::A::i;               \n");
        stringBuffer.append("void g() {                               \n");
        stringBuffer.append("   f( pm );                              \n");
        stringBuffer.append("}                                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(16).resolveBinding();
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(1).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 4);
    }

    public void testPMKoenig_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace M {                            \n");
        stringBuffer.append("   class B { };                          \n");
        stringBuffer.append("   void f( B* );                         \n");
        stringBuffer.append("}                                        \n");
        stringBuffer.append("namespace N {                            \n");
        stringBuffer.append("   class A { public: M::B * b; };        \n");
        stringBuffer.append("}                                        \n");
        stringBuffer.append("M::B* N::A::* pm = &N::A::b;             \n");
        stringBuffer.append("void g() {                               \n");
        stringBuffer.append("   N::A * a;                             \n");
        stringBuffer.append("   f( a->*pm );                          \n");
        stringBuffer.append("}                                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(27).resolveBinding();
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(1).resolveBinding();
        ICPPNamespace iCPPNamespace2 = (ICPPNamespace)cPPNameCollector.getName(5).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(6).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(17).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 6);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace2, 4);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType2, 5);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
    }

    public void testFriend_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {                       \n");
        stringBuffer.append("   friend void set();           \n");
        stringBuffer.append("   friend class B;              \n");
        stringBuffer.append("};                              \n");
        stringBuffer.append("void set();                     \n");
        stringBuffer.append("class B{};                      \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        IFunction iFunction = (IFunction)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType2, 2);
        IBinding[] iBindingArray = iCPPClassType.getFriends();
        Assert.assertEquals((int)2, (int)iBindingArray.length);
        Assert.assertSame((Object)iBindingArray[0], (Object)iFunction);
        Assert.assertSame((Object)iBindingArray[1], (Object)iCPPClassType2);
    }

    public void testBug59149() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A { friend class B; friend class B; }; \n");
        stringBuffer.append("class B{};                                   \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 3);
        IBinding[] iBindingArray = iCPPClassType2.getFriends();
        Assert.assertEquals((int)iBindingArray.length, (int)1);
        Assert.assertSame((Object)iBindingArray[0], (Object)iCPPClassType);
    }

    public void testBug59302() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {                      \n");
        stringBuffer.append("   public: class N {};         \n");
        stringBuffer.append("};                             \n");
        stringBuffer.append("class B {                      \n");
        stringBuffer.append("   friend class A::N;          \n");
        stringBuffer.append("};                             \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(5).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType3 = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 3);
        IBinding[] iBindingArray = iCPPClassType3.getFriends();
        Assert.assertEquals((int)iBindingArray.length, (int)1);
        Assert.assertSame((Object)iBindingArray[0], (Object)iCPPClassType);
        Assert.assertEquals((int)iCPPClassType2.getFriends().length, (int)0);
        Assert.assertEquals((int)iCPPClassType.getFriends().length, (int)0);
    }

    public void testBug75482() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {                      \n");
        stringBuffer.append("   friend class B *helper();   \n");
        stringBuffer.append("};                             \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(2).resolveBinding();
        Assert.assertSame((Object)iFunction.getScope(), (Object)iASTTranslationUnit.getScope());
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(1).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        Assert.assertSame((Object)iCPPClassType.getScope(), (Object)iCPPClassType2.getScope());
        IBinding[] iBindingArray = iCPPClassType2.getFriends();
        Assert.assertEquals((int)iBindingArray.length, (int)1);
        Assert.assertSame((Object)iBindingArray[0], (Object)iFunction);
    }

    public void testBug45763_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f( int );                         \n");
        stringBuffer.append("void f( char );                        \n");
        stringBuffer.append("void (*pf) (int) = &f;                 \n");
        stringBuffer.append("void foo() {                           \n");
        stringBuffer.append("   pf = &f;                            \n");
        stringBuffer.append("}                                      \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(2).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(4).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction2, 1);
    }

    public void testBug45763_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f( char );                        \n");
        stringBuffer.append("void f( int  );                        \n");
        stringBuffer.append("void g( void (*)( int ) ) {}           \n");
        stringBuffer.append("void (*pg)( void(*)(int) );            \n");
        stringBuffer.append("void foo() {                           \n");
        stringBuffer.append("   g( &f );                            \n");
        stringBuffer.append("   (*pg)( &f );                        \n");
        stringBuffer.append("}                                      \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(2).resolveBinding();
        IFunction iFunction3 = (IFunction)cPPNameCollector.getName(4).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(7).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction2, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction3, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
    }

    public void testBug45763_3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f( int );                  \n");
        stringBuffer.append("void f( char );                 \n");
        stringBuffer.append("void (* bar () ) ( int ) {      \n");
        stringBuffer.append("   return &f;                   \n");
        stringBuffer.append("}                               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(2).resolveBinding();
        IFunction iFunction3 = (IFunction)cPPNameCollector.getName(4).resolveBinding();
        Assert.assertNotNull((Object)iFunction3);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction2, 1);
    }

    public void _testBug45763_4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f( int );                  \n");
        stringBuffer.append("void f( char );                 \n");
        stringBuffer.append("void foo () {                   \n");
        stringBuffer.append("   ( void (*)(int) ) &f;        \n");
        stringBuffer.append("}                               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(2).resolveBinding();
        IFunction iFunction3 = (IFunction)cPPNameCollector.getName(4).resolveBinding();
        Assert.assertNotNull((Object)iFunction3);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction2, 1);
    }

    public void testBug85824() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern int g;       \n ");
        stringBuffer.append("int g;              \n ");
        stringBuffer.append("void f() {  g = 1; }\n ");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(3).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 3);
    }

    public void testPrefixLookup() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {            \n");
        stringBuffer.append("    int a2;           \n");
        stringBuffer.append("};                    \n");
        stringBuffer.append("struct B : public A { \n");
        stringBuffer.append("    int a1;           \n");
        stringBuffer.append("    void f();         \n");
        stringBuffer.append("}                     \n");
        stringBuffer.append("int a3;               \n");
        stringBuffer.append("void B::f(){          \n");
        stringBuffer.append("   int a4;            \n");
        stringBuffer.append("   a;                 \n");
        stringBuffer.append("}                     \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IASTName iASTName = cPPNameCollector.getName(11);
        IBinding[] iBindingArray = CPPSemantics.prefixLookup((IASTName)iASTName);
        Assert.assertEquals((int)4, (int)iBindingArray.length);
    }

    public void testIsStatic() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("static void f();    \n");
        stringBuffer.append("void f() {}         \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(1).resolveBinding();
        Assert.assertTrue((boolean)iFunction.isStatic());
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 2);
    }

    public void testBug86267() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct B { void mutate(); };     \n");
        stringBuffer.append("struct D1 : B {};                \n");
        stringBuffer.append("struct D2 : B {};                \n");
        stringBuffer.append("void B::mutate() {               \n");
        stringBuffer.append("   new (this) D2;                \n");
        stringBuffer.append("}                                \n");
        stringBuffer.append("void g() {                       \n");
        stringBuffer.append("   B* pb = new (p) D1;           \n");
        stringBuffer.append("}                                \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(4).resolveBinding();
        ICPPConstructor[] iCPPConstructorArray = iCPPClassType.getConstructors();
        ICPPConstructor iCPPConstructor = iCPPConstructorArray[0];
        iCPPConstructorArray = iCPPClassType2.getConstructors();
        ICPPConstructor iCPPConstructor2 = iCPPConstructorArray[0];
        this.assertInstances(cPPNameCollector, (IBinding)iCPPConstructor, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPConstructor2, 1);
    }

    public void testBug86269() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct C {                                  \n");
        stringBuffer.append("   void f();                                \n");
        stringBuffer.append("   const C& operator =( const C& );         \n");
        stringBuffer.append("};                                          \n");
        stringBuffer.append("const C& C::operator = ( const C& other ) { \n");
        stringBuffer.append("   if( this != &other ) {                   \n");
        stringBuffer.append("      this->~C();                           \n");
        stringBuffer.append("      new (this) C(other);                  \n");
        stringBuffer.append("      f();                                  \n");
        stringBuffer.append("   }                                        \n");
        stringBuffer.append("   return *this;                            \n");
        stringBuffer.append("}                                           \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(1).resolveBinding();
        ICPPMethod iCPPMethod2 = (ICPPMethod)cPPNameCollector.getName(3).resolveBinding();
        IParameter iParameter = (IParameter)cPPNameCollector.getName(5).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 6);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod2, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iParameter, 4);
        Assert.assertEquals((String)iParameter.getName(), (String)"other");
    }

    public void testBug86279() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern \"C\" {                               \n");
        stringBuffer.append("   void printf( const char * );              \n");
        stringBuffer.append("   void sprintf( const char * );             \n");
        stringBuffer.append("}                                            \n");
        stringBuffer.append("void foo(){                                  \n");
        stringBuffer.append("   char *p;                                  \n");
        stringBuffer.append("   printf( p );                              \n");
        stringBuffer.append("   printf( \"abc\" );                        \n");
        stringBuffer.append("}                                            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(6).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(8).resolveBinding();
        IFunction iFunction3 = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        Assert.assertSame((Object)iFunction3, (Object)iFunction);
        Assert.assertSame((Object)iFunction3, (Object)iFunction2);
    }

    public void testBug86346() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct S;            \n");
        stringBuffer.append("extern S a;          \n");
        stringBuffer.append("void g( S );         \n");
        stringBuffer.append("void h() {           \n");
        stringBuffer.append("   g( a );           \n");
        stringBuffer.append("}                    \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        IFunction iFunction = (IFunction)cPPNameCollector.getName(3).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 2);
    }

    public void testBug86288() throws Exception {
        String string = "int *foo( int *b ) { return (int *)(b); }";
        IASTTranslationUnit iASTTranslationUnit = this.parse(string, ParserLanguage.CPP);
        IASTReturnStatement iASTReturnStatement = (IASTReturnStatement)((IASTCompoundStatement)((IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0]).getBody()).getStatements()[0];
        Assert.assertTrue((boolean)(iASTReturnStatement.getReturnValue() instanceof IASTCastExpression));
    }

    public void testBug84476() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void foo() {\n");
        stringBuffer.append("struct B {\n");
        stringBuffer.append("int f();\n");
        stringBuffer.append("};    \t\t\t\n");
        stringBuffer.append("int (B::*pb)() = &B::f;\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)this.parse(string, ParserLanguage.CPP).getDeclarations()[0];
        IASTDeclarationStatement iASTDeclarationStatement = (IASTDeclarationStatement)((IASTCompoundStatement)iASTFunctionDefinition.getBody()).getStatements()[1];
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTDeclarationStatement.getDeclaration();
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
        Assert.assertEquals((int)iASTDeclarator.getNestedDeclarator().getPointerOperators().length, (int)1);
        Assert.assertEquals((String)iASTDeclarator.getNestedDeclarator().getName().toString(), (String)"pb");
        Assert.assertTrue((boolean)(iASTDeclarator.getNestedDeclarator().getPointerOperators()[0] instanceof ICPPASTPointerToMember));
    }

    public void testBug86336() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct T1 {                   \n");
        stringBuffer.append("   T1 operator() ( int x ) {  \n");
        stringBuffer.append("      return T1(x);           \n");
        stringBuffer.append("   }                          \n");
        stringBuffer.append("   T1( int ) {}               \n");
        stringBuffer.append("};                            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPConstructor iCPPConstructor = (ICPPConstructor)cPPNameCollector.getName(6).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPConstructor, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 2);
    }

    public void testBug86306() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct S { int i; };    \n");
        stringBuffer.append("void foo() {            \n");
        stringBuffer.append("   int S::* pm = &S::i; \n");
        stringBuffer.append("}                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 3);
        IASTName[] iASTNameArray = iASTTranslationUnit.getReferences((IBinding)iCPPClassType);
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertSame((Object)iASTNameArray[0], (Object)cPPNameCollector.getName(4));
        Assert.assertSame((Object)iASTNameArray[1], (Object)cPPNameCollector.getName(7));
    }

    public void testBug86372() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {                           \n");
        stringBuffer.append("\tpublic:                            \n");
        stringBuffer.append("   template <class T> void f(T);    \n");
        stringBuffer.append("   template <class T> struct X { }; \n");
        stringBuffer.append("};                                  \n");
        stringBuffer.append("class B : public A {                \n");
        stringBuffer.append(" public:                            \n");
        stringBuffer.append("   using A::f<double>; // illformed \n");
        stringBuffer.append("   using A::X<int>; // illformed    \n");
        stringBuffer.append("};                                  \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
    }

    public void testBug86319() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void foo() {                    \n");
        stringBuffer.append("   int i = 42;                  \n");
        stringBuffer.append("   int a[10];                   \n");
        stringBuffer.append("   for( int i = 0; i < 10; i++ )\n");
        stringBuffer.append("      a[i] = 1;                 \n");
        stringBuffer.append("   int j = i;                   \n");
        stringBuffer.append("}                               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(3).resolveBinding();
        Assert.assertNotSame((Object)iVariable, (Object)iVariable2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable2, 4);
    }

    public void testBug86350() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X { int i, j; };           \n");
        stringBuffer.append("class Y { X x; };                \n");
        stringBuffer.append("void foo() {                     \n");
        stringBuffer.append("   const Y y;                    \n");
        stringBuffer.append("   y.x.i++;                      \n");
        stringBuffer.append("   y.x.j++;                      \n");
        stringBuffer.append("   Y* p = const_cast<Y*>(&y);    \n");
        stringBuffer.append("   p->x.i;                       \n");
        stringBuffer.append("   p->x.j;                       \n");
        stringBuffer.append("}                                \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(1).resolveBinding();
        ICPPField iCPPField2 = (ICPPField)cPPNameCollector.getName(2).resolveBinding();
        ICPPField iCPPField3 = (ICPPField)cPPNameCollector.getName(5).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPField, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPField2, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPField3, 5);
    }

    public void testBug84478() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void foo() {\n");
        stringBuffer.append("  struct A {\n");
        stringBuffer.append("    int val;\n");
        stringBuffer.append("    A(int i) : val(i) { }\n");
        stringBuffer.append("    ~A() { }\n");
        stringBuffer.append("    operator bool() { return val != 0; }\n");
        stringBuffer.append("  };\n");
        stringBuffer.append("  int i = 1;\n");
        stringBuffer.append("  while (A a = i) {\n");
        stringBuffer.append("    i = 0;\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("}\n");
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)this.parse(stringBuffer.toString(), ParserLanguage.CPP).getDeclarations()[0];
        ICPPASTWhileStatement iCPPASTWhileStatement = (ICPPASTWhileStatement)((IASTCompoundStatement)iASTFunctionDefinition.getBody()).getStatements()[2];
        Assert.assertNull((Object)iCPPASTWhileStatement.getCondition());
        Assert.assertNotNull((Object)iCPPASTWhileStatement.getConditionDeclaration());
    }

    public void testBug86353() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void foo() {                      \n");
        stringBuffer.append("   const int x = 12;              \n");
        stringBuffer.append("   {   enum { x = x };  }         \n");
        stringBuffer.append("}                                 \n");
        stringBuffer.append("enum { RED };                     \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IEnumerator iEnumerator = (IEnumerator)cPPNameCollector.getName(3).resolveBinding();
        IBinding iBinding = cPPNameCollector.getName(4).resolveBinding();
        IEnumerator iEnumerator2 = (IEnumerator)cPPNameCollector.getName(6).resolveBinding();
        String[] stringArray = ((ICPPBinding)iEnumerator2).getQualifiedName();
        Assert.assertEquals((String)stringArray[0], (String)"RED");
        Assert.assertTrue((boolean)((ICPPBinding)iEnumerator2).isGloballyQualified());
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations((IBinding)iEnumerator);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertSame((Object)iASTNameArray[0], (Object)cPPNameCollector.getName(3));
        iASTNameArray = iASTTranslationUnit.getDeclarations(iBinding);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertSame((Object)iASTNameArray[0], (Object)cPPNameCollector.getName(1));
        iASTNameArray = iASTTranslationUnit.getDeclarations((IBinding)iEnumerator2);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertSame((Object)iASTNameArray[0], (Object)cPPNameCollector.getName(6));
    }

    public void _testBug86274() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class D {};                   \n");
        stringBuffer.append("D d1;                         \n");
        stringBuffer.append("const D d2;                   \n");
        stringBuffer.append("void foo() {                  \n");
        stringBuffer.append("   typeid(d1) == typeid(d2);  \n");
        stringBuffer.append("   typeid( D ) == typeid(d2); \n");
        stringBuffer.append("}                             \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)10);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(6).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(7).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(8).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 4);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable2, 3);
    }

    public void testBug86546() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void point ( int = 3, int = 4 );        \n");
        stringBuffer.append("void foo() {                            \n");
        stringBuffer.append("   point( 1, 2 );                       \n");
        stringBuffer.append("   point( 1 );                          \n");
        stringBuffer.append("   point( );                            \n");
        stringBuffer.append("}                                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 4);
    }

    public void testBug86358_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace Outer{                   \n");
        stringBuffer.append("   int i;                          \n");
        stringBuffer.append("   namespace Inner {               \n");
        stringBuffer.append("      void f() {  i++;  }          \n");
        stringBuffer.append("      int i;                       \n");
        stringBuffer.append("      void g() {  i++;  }          \n");
        stringBuffer.append("   }                               \n");
        stringBuffer.append("}                                  \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(4).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(7).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iVariable2, 2);
    }

    public void testBug86358_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace Q {                    \n");
        stringBuffer.append("   namespace V {                 \n");
        stringBuffer.append("      void f();                  \n");
        stringBuffer.append("   }                             \n");
        stringBuffer.append("   void V::f() {}                \n");
        stringBuffer.append("   namespace V {                 \n");
        stringBuffer.append("   }                             \n");
        stringBuffer.append("}                                \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(2).resolveBinding();
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(5).resolveBinding();
        Assert.assertSame((Object)iFunction, (Object)iCPPFunction);
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations((IBinding)iCPPFunction);
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertSame((Object)iASTNameArray[0], (Object)cPPNameCollector.getName(2));
        Assert.assertSame((Object)iASTNameArray[1], (Object)cPPNameCollector.getName(5));
        String[] stringArray = iCPPFunction.getQualifiedName();
        Assert.assertEquals((String)stringArray[0], (String)"Q");
        Assert.assertEquals((String)stringArray[1], (String)"V");
        Assert.assertEquals((String)stringArray[2], (String)"f");
        Assert.assertTrue((boolean)iCPPFunction.isGloballyQualified());
    }

    public void test86371() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct B {                          \n");
        stringBuffer.append("   void f ( char );                 \n");
        stringBuffer.append("   void g ( char );                 \n");
        stringBuffer.append("};                                  \n");
        stringBuffer.append("struct D : B {                      \n");
        stringBuffer.append("   using B::f;                      \n");
        stringBuffer.append("   void f( int ) { f('c'); }        \n");
        stringBuffer.append("   void g( int ) { g('c'); }        \n");
        stringBuffer.append("};                                  \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(12).resolveBinding();
        Assert.assertTrue((boolean)(iCPPFunction instanceof ICPPDelegate));
        IFunction iFunction = (IFunction)cPPNameCollector.getName(15).resolveBinding();
        ICPPFunction iCPPFunction2 = (ICPPFunction)cPPNameCollector.getName(1).resolveBinding();
        Assert.assertSame((Object)((ICPPDelegate)iCPPFunction).getBinding(), (Object)iCPPFunction2);
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(13).resolveBinding();
        Assert.assertSame((Object)iFunction2, (Object)iFunction);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPFunction, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 2);
        String[] stringArray = iCPPFunction.getQualifiedName();
        Assert.assertEquals((String)stringArray[0], (String)"D");
        Assert.assertEquals((String)stringArray[1], (String)"f");
        Assert.assertTrue((boolean)iCPPFunction.isGloballyQualified());
        stringArray = iCPPFunction2.getQualifiedName();
        Assert.assertEquals((String)stringArray[0], (String)"B");
        Assert.assertEquals((String)stringArray[1], (String)"f");
        Assert.assertTrue((boolean)iCPPFunction2.isGloballyQualified());
    }

    public void testBug86369() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace Company_with_veryblahblah {}       \n");
        stringBuffer.append("namespace CWVLN = Company_with_veryblahblah; \n");
        stringBuffer.append("namespace CWVLN = Company_with_veryblahblah; \n");
        stringBuffer.append("namespace CWVLN = CWVLN;                     \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        ICPPNamespace iCPPNamespace2 = (ICPPNamespace)cPPNameCollector.getName(1).resolveBinding();
        String[] stringArray = iCPPNamespace.getQualifiedName();
        Assert.assertEquals((String)stringArray[0], (String)"Company_with_veryblahblah");
        stringArray = iCPPNamespace2.getQualifiedName();
        Assert.assertEquals((String)stringArray[0], (String)"CWVLN");
        Assert.assertTrue((boolean)(iCPPNamespace2 instanceof ICPPDelegate));
        Assert.assertSame((Object)((ICPPDelegate)iCPPNamespace2).getBinding(), (Object)iCPPNamespace);
        IASTName[] iASTNameArray = iASTTranslationUnit.getReferences((IBinding)iCPPNamespace);
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertSame((Object)iASTNameArray[0], (Object)cPPNameCollector.getName(2));
        Assert.assertSame((Object)iASTNameArray[1], (Object)cPPNameCollector.getName(4));
        IASTName[] iASTNameArray2 = iASTTranslationUnit.getDeclarations((IBinding)iCPPNamespace);
        Assert.assertEquals((int)iASTNameArray2.length, (int)1);
        Assert.assertSame((Object)iASTNameArray2[0], (Object)cPPNameCollector.getName(0));
        iASTNameArray = iASTTranslationUnit.getReferences((IBinding)iCPPNamespace2);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertSame((Object)iASTNameArray[0], (Object)cPPNameCollector.getName(6));
        iASTNameArray2 = iASTTranslationUnit.getDeclarations((IBinding)iCPPNamespace2);
        Assert.assertEquals((int)iASTNameArray2.length, (int)3);
        Assert.assertSame((Object)iASTNameArray2[0], (Object)cPPNameCollector.getName(1));
        Assert.assertSame((Object)iASTNameArray2[1], (Object)cPPNameCollector.getName(3));
        Assert.assertSame((Object)iASTNameArray2[2], (Object)cPPNameCollector.getName(5));
    }

    public void testBug86470_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {                  \n");
        stringBuffer.append("   void f( char );             \n");
        stringBuffer.append("   void f( int );              \n");
        stringBuffer.append("}                              \n");
        stringBuffer.append("using A::f;                    \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPUsingDeclaration iCPPUsingDeclaration = (ICPPUsingDeclaration)cPPNameCollector.getName(7).resolveBinding();
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations((IBinding)iCPPUsingDeclaration);
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertSame((Object)iASTNameArray[0], (Object)cPPNameCollector.getName(1));
        Assert.assertSame((Object)iASTNameArray[1], (Object)cPPNameCollector.getName(3));
        ICPPDelegate[] iCPPDelegateArray = iCPPUsingDeclaration.getDelegates();
        Assert.assertEquals((int)iCPPDelegateArray.length, (int)2);
        iASTNameArray = iASTTranslationUnit.getDeclarations((IBinding)iCPPDelegateArray[0]);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertSame((Object)iASTNameArray[0], (Object)cPPNameCollector.getName(7));
        iASTNameArray = iASTTranslationUnit.getDeclarations(iCPPDelegateArray[0].getBinding());
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertSame((Object)iASTNameArray[0], (Object)cPPNameCollector.getName(1));
    }

    public void testBug86470_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {                  \n");
        stringBuffer.append("   void f( int );              \n");
        stringBuffer.append("   void f( double );           \n");
        stringBuffer.append("}                              \n");
        stringBuffer.append("namespace B {                  \n");
        stringBuffer.append("   void f( int );              \n");
        stringBuffer.append("   void f( double );           \n");
        stringBuffer.append("   void f( char );             \n");
        stringBuffer.append("}                              \n");
        stringBuffer.append("void g() {                     \n");
        stringBuffer.append("   using A::f;                 \n");
        stringBuffer.append("   using B::f;                 \n");
        stringBuffer.append("   f( 'c' );                   \n");
        stringBuffer.append("}                              \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(10).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(19).resolveBinding();
        Assert.assertTrue((boolean)(iFunction2 instanceof ICPPDelegate));
        Assert.assertSame((Object)iFunction, (Object)((ICPPDelegate)iFunction2).getBinding());
    }

    public void testBug86470_3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {                       \n");
        stringBuffer.append("   struct g {};                     \n");
        stringBuffer.append("   void g ( char );                 \n");
        stringBuffer.append("}                                   \n");
        stringBuffer.append("void f() {                          \n");
        stringBuffer.append("   using A::g;                      \n");
        stringBuffer.append("   g('a');                          \n");
        stringBuffer.append("   struct g gg;                     \n");
        stringBuffer.append("}                                   \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IBinding iBinding = cPPNameCollector.getName(8).resolveBinding();
        IBinding iBinding2 = cPPNameCollector.getName(9).resolveBinding();
        Assert.assertTrue((boolean)(iBinding instanceof ICPPDelegate));
        Assert.assertTrue((boolean)(iBinding2 instanceof ICPPDelegate));
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(1).resolveBinding();
        IFunction iFunction = (IFunction)cPPNameCollector.getName(2).resolveBinding();
        Assert.assertSame((Object)iCPPClassType, (Object)((ICPPDelegate)iBinding2).getBinding());
        Assert.assertSame((Object)iFunction, (Object)((ICPPDelegate)iBinding).getBinding());
        ICPPUsingDeclaration iCPPUsingDeclaration = (ICPPUsingDeclaration)cPPNameCollector.getName(7).resolveBinding();
        IASTName[] iASTNameArray = iASTTranslationUnit.getDeclarations((IBinding)iCPPUsingDeclaration);
        Assert.assertEquals((int)iASTNameArray.length, (int)2);
        Assert.assertSame((Object)iASTNameArray[0], (Object)cPPNameCollector.getName(1));
        Assert.assertSame((Object)iASTNameArray[1], (Object)cPPNameCollector.getName(2));
    }

    public void testBug86470_4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {                       \n");
        stringBuffer.append("   int x;                           \n");
        stringBuffer.append("}                                   \n");
        stringBuffer.append("namespace B {                       \n");
        stringBuffer.append("   struct x {};                     \n");
        stringBuffer.append("}                                   \n");
        stringBuffer.append("void f() {                          \n");
        stringBuffer.append("   using A::x;                      \n");
        stringBuffer.append("   using B::x;                      \n");
        stringBuffer.append("   x = 1;                           \n");
        stringBuffer.append("   struct x xx;                     \n");
        stringBuffer.append("}                                   \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPBinding iCPPBinding = (ICPPBinding)cPPNameCollector.getName(11).resolveBinding();
        ICPPBinding iCPPBinding2 = (ICPPBinding)cPPNameCollector.getName(12).resolveBinding();
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(3).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        Assert.assertTrue((boolean)(iCPPBinding instanceof ICPPDelegate));
        Assert.assertTrue((boolean)(iCPPBinding2 instanceof ICPPDelegate));
        Assert.assertSame((Object)iCPPClassType, (Object)((ICPPDelegate)iCPPBinding2).getBinding());
        Assert.assertSame((Object)iVariable, (Object)((ICPPDelegate)iCPPBinding).getBinding());
        IASTName[] iASTNameArray = iASTTranslationUnit.getReferences((IBinding)iCPPClassType);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertSame((Object)iASTNameArray[0], (Object)cPPNameCollector.getName(10));
        String[] stringArray = iCPPBinding2.getQualifiedName();
        Assert.assertEquals((String)stringArray[0], (String)"x");
        Assert.assertFalse((boolean)iCPPBinding2.isGloballyQualified());
        stringArray = iCPPClassType.getQualifiedName();
        Assert.assertEquals((String)stringArray[0], (String)"B");
        Assert.assertEquals((String)stringArray[1], (String)"x");
        Assert.assertTrue((boolean)iCPPClassType.isGloballyQualified());
    }

    public void testBug86470_5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {                       \n");
        stringBuffer.append("   void f( int );                   \n");
        stringBuffer.append("   void f( double );                \n");
        stringBuffer.append("}                                   \n");
        stringBuffer.append("void g() {                          \n");
        stringBuffer.append("   void f( char );                  \n");
        stringBuffer.append("   using A::f;                      \n");
        stringBuffer.append("   f( 3.5 );                        \n");
        stringBuffer.append("}                                   \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(3).resolveBinding();
        ICPPFunction iCPPFunction2 = (ICPPFunction)cPPNameCollector.getName(11).resolveBinding();
        Assert.assertTrue((boolean)(iCPPFunction2 instanceof ICPPDelegate));
        Assert.assertSame((Object)((ICPPDelegate)iCPPFunction2).getBinding(), (Object)iCPPFunction);
        String[] stringArray = iCPPFunction2.getQualifiedName();
        Assert.assertEquals((String)stringArray[0], (String)"f");
        Assert.assertFalse((boolean)iCPPFunction2.isGloballyQualified());
        stringArray = iCPPFunction.getQualifiedName();
        Assert.assertEquals((String)stringArray[0], (String)"A");
        Assert.assertEquals((String)stringArray[1], (String)"f");
        Assert.assertTrue((boolean)iCPPFunction.isGloballyQualified());
    }

    public void testBug86678() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class B;                                 \n");
        stringBuffer.append("class A {                                \n");
        stringBuffer.append("   int i;                                \n");
        stringBuffer.append("   friend void f( B * );                 \n");
        stringBuffer.append("};                                       \n");
        stringBuffer.append("class B : public A {};                   \n");
        stringBuffer.append("void f( B* p ) {                         \n");
        stringBuffer.append("   p->i = 1;                             \n");
        stringBuffer.append("}                                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(6).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(12).resolveBinding();
        IParameter iParameter = (IParameter)cPPNameCollector.getName(10).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 4);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPField, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iParameter, 3);
    }

    public void testBug86543() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int printf( const char *, ... );             \n");
        stringBuffer.append("void foo(){                                  \n");
        stringBuffer.append("   int a, b;                                 \n");
        stringBuffer.append("   printf( \"hello\" );                      \n");
        stringBuffer.append("   printf(\"a=%d b=%d\", a, b );             \n");
        stringBuffer.append("}                                            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(6).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 3);
    }

    public void testBug86554() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int max( int a, int b, int c ) {                  \n");
        stringBuffer.append("   int m = ( a > b ) ? a : b;                     \n");
        stringBuffer.append("   return ( m > c ) ? m : c;                      \n");
        stringBuffer.append("}                                                 \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(11).resolveBinding();
        IParameter iParameter = (IParameter)cPPNameCollector.getName(1).resolveBinding();
        IParameter iParameter2 = (IParameter)cPPNameCollector.getName(2).resolveBinding();
        IParameter iParameter3 = (IParameter)cPPNameCollector.getName(3).resolveBinding();
        String[] stringArray = ((ICPPBinding)iParameter).getQualifiedName();
        Assert.assertEquals((String)stringArray[0], (String)"a");
        Assert.assertFalse((boolean)((ICPPBinding)iParameter).isGloballyQualified());
        this.assertInstances(cPPNameCollector, (IBinding)iVariable, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iParameter, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iParameter2, 3);
        this.assertInstances(cPPNameCollector, (IBinding)iParameter3, 3);
    }

    public void testBug86621() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int g();                               \n");
        stringBuffer.append("struct X { static int g(); };          \n");
        stringBuffer.append("struct Y : X { static int i ; };       \n");
        stringBuffer.append("int Y::i = g();                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(0).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(9).resolveBinding();
        String[] stringArray = iCPPFunction.getQualifiedName();
        Assert.assertEquals((String)stringArray[0], (String)"g");
        Assert.assertTrue((boolean)iCPPFunction.isGloballyQualified());
        stringArray = iCPPMethod.getQualifiedName();
        Assert.assertEquals((String)stringArray[0], (String)"X");
        Assert.assertEquals((String)stringArray[1], (String)"g");
        Assert.assertTrue((boolean)iCPPMethod.isGloballyQualified());
        this.assertInstances(cPPNameCollector, (IBinding)iCPPFunction, 1);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod, 2);
    }

    public void testBug86649() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class V { int f(); int x; };                 \n");
        stringBuffer.append("class W { int g(); int y; };                 \n");
        stringBuffer.append("class B : public virtual V, public W {       \n");
        stringBuffer.append("   int f();  int x;                          \n");
        stringBuffer.append("   int g();  int y;                          \n");
        stringBuffer.append("};                                           \n");
        stringBuffer.append("class C : public virtual V, public W {};     \n");
        stringBuffer.append("class D : public B, public C {               \n");
        stringBuffer.append("   void foo();                               \n");
        stringBuffer.append("};                                           \n");
        stringBuffer.append("void D::foo(){                               \n");
        stringBuffer.append("   x++;                                      \n");
        stringBuffer.append("   f();                                      \n");
        stringBuffer.append("   y++;                                      \n");
        stringBuffer.append("   g();                                      \n");
        stringBuffer.append("}                                            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(23).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(24).resolveBinding();
        String[] stringArray = iCPPMethod.getQualifiedName();
        Assert.assertEquals((String)stringArray[0], (String)"B");
        Assert.assertEquals((String)stringArray[1], (String)"f");
        Assert.assertTrue((boolean)iCPPMethod.isGloballyQualified());
        stringArray = iCPPField.getQualifiedName();
        Assert.assertEquals((String)stringArray[0], (String)"B");
        Assert.assertEquals((String)stringArray[1], (String)"x");
        Assert.assertTrue((boolean)iCPPField.isGloballyQualified());
        IProblemBinding iProblemBinding = (IProblemBinding)cPPNameCollector.getName(25).resolveBinding();
        IProblemBinding iProblemBinding2 = (IProblemBinding)cPPNameCollector.getName(26).resolveBinding();
        Assert.assertEquals((int)iProblemBinding.getID(), (int)4);
        Assert.assertEquals((int)iProblemBinding2.getID(), (int)4);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPField, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPMethod, 2);
    }

    public void testBug86827() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct C {                    \n");
        stringBuffer.append("   int c;                     \n");
        stringBuffer.append("   C() : c(0) { }             \n");
        stringBuffer.append("};                            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPVariable iCPPVariable = (ICPPVariable)cPPNameCollector.getName(1).resolveBinding();
        String[] stringArray = iCPPVariable.getQualifiedName();
        Assert.assertEquals((int)stringArray.length, (int)2);
        Assert.assertEquals((String)stringArray[0], (String)"C");
        Assert.assertEquals((String)stringArray[1], (String)"c");
        Assert.assertTrue((boolean)iCPPVariable.isGloballyQualified());
        IASTName[] iASTNameArray = iASTTranslationUnit.getReferences((IBinding)iCPPVariable);
        Assert.assertEquals((int)iASTNameArray.length, (int)1);
        Assert.assertSame((Object)iASTNameArray[0], (Object)cPPNameCollector.getName(3));
    }

    public void testFind_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f( int par ) {            \n");
        stringBuffer.append("   int v1;                     \n");
        stringBuffer.append("   {                           \n");
        stringBuffer.append("      int v2;                  \n");
        stringBuffer.append("   }                           \n");
        stringBuffer.append("}                              \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPVariable iCPPVariable = (ICPPVariable)cPPNameCollector.getName(2).resolveBinding();
        ICPPVariable iCPPVariable2 = (ICPPVariable)cPPNameCollector.getName(3).resolveBinding();
        String[] stringArray = iCPPVariable.getQualifiedName();
        Assert.assertEquals((String)stringArray[0], (String)"v1");
        Assert.assertFalse((boolean)iCPPVariable.isGloballyQualified());
        stringArray = iCPPVariable2.getQualifiedName();
        Assert.assertEquals((String)stringArray[0], (String)"v2");
        Assert.assertFalse((boolean)iCPPVariable2.isGloballyQualified());
        ICPPBlockScope iCPPBlockScope = (ICPPBlockScope)iCPPVariable2.getScope();
        IBinding[] iBindingArray = iCPPBlockScope.find("v1");
        Assert.assertEquals((int)iBindingArray.length, (int)1);
        Assert.assertSame((Object)iBindingArray[0], (Object)iCPPVariable);
    }

    public void testFind_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A { int a; };            \n");
        stringBuffer.append("class B : public A {           \n");
        stringBuffer.append("   void f();                   \n");
        stringBuffer.append("};                             \n");
        stringBuffer.append("void B::f() {                  \n");
        stringBuffer.append("}                              \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(1).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(7).resolveBinding();
        IScope iScope = iCPPMethod.getFunctionScope();
        IBinding[] iBindingArray = iScope.find("a");
        Assert.assertEquals((int)iBindingArray.length, (int)1);
        Assert.assertSame((Object)iBindingArray[0], (Object)iCPPField);
        iBindingArray = iScope.find("~B");
        Assert.assertEquals((int)iBindingArray.length, (int)1);
        Assert.assertTrue((boolean)(iBindingArray[0] instanceof ICPPMethod));
        Assert.assertTrue((boolean)iBindingArray[0].getName().equals("~B"));
        iBindingArray = iScope.find("A");
        Assert.assertEquals((int)iBindingArray.length, (int)1);
        Assert.assertSame((Object)iBindingArray[0], (Object)iCPPClassType);
    }

    public void testFind_3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {                       \n");
        stringBuffer.append("   void f( int );                   \n");
        stringBuffer.append("   void f( double );                \n");
        stringBuffer.append("}                                   \n");
        stringBuffer.append("void g() {                          \n");
        stringBuffer.append("   void f( char );                  \n");
        stringBuffer.append("   using A::f;                      \n");
        stringBuffer.append("}                                   \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(1).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(3).resolveBinding();
        IFunction iFunction3 = (IFunction)cPPNameCollector.getName(6).resolveBinding();
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)cPPNameCollector.getName(5).getParent().getParent();
        IScope iScope = ((IASTCompoundStatement)iASTFunctionDefinition.getBody()).getScope();
        IBinding[] iBindingArray = iScope.find("f");
        Assert.assertEquals((int)iBindingArray.length, (int)3);
        Assert.assertSame((Object)iBindingArray[0], (Object)iFunction3);
        Assert.assertSame((Object)((ICPPDelegate)iBindingArray[1]).getBinding(), (Object)iFunction);
        Assert.assertSame((Object)((ICPPDelegate)iBindingArray[2]).getBinding(), (Object)iFunction2);
        String[] stringArray = ((ICPPDelegate)iBindingArray[1]).getQualifiedName();
        Assert.assertEquals((int)stringArray.length, (int)1);
        Assert.assertEquals((String)stringArray[0], (String)"f");
        Assert.assertFalse((boolean)((ICPPDelegate)iBindingArray[1]).isGloballyQualified());
        stringArray = ((ICPPBinding)((ICPPDelegate)iBindingArray[1]).getBinding()).getQualifiedName();
        Assert.assertEquals((int)stringArray.length, (int)2);
        Assert.assertEquals((String)stringArray[0], (String)"A");
        Assert.assertEquals((String)stringArray[1], (String)"f");
        Assert.assertTrue((boolean)((ICPPBinding)((ICPPDelegate)iBindingArray[1]).getBinding()).isGloballyQualified());
    }

    public void testFind_4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {                                  \n");
        stringBuffer.append("   struct f;                                   \n");
        stringBuffer.append("   void f();                                   \n");
        stringBuffer.append("}                                              \n");
        stringBuffer.append("namespace B {                                  \n");
        stringBuffer.append("   void f( int );                              \n");
        stringBuffer.append("}                                              \n");
        stringBuffer.append("namespace C {                                  \n");
        stringBuffer.append("   using namespace B;                          \n");
        stringBuffer.append("}                                              \n");
        stringBuffer.append("void g(){                                      \n");
        stringBuffer.append("   using namespace A;                          \n");
        stringBuffer.append("   using namespace C;                          \n");
        stringBuffer.append("}                                              \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(1).resolveBinding();
        IFunction iFunction = (IFunction)cPPNameCollector.getName(2).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(4).resolveBinding();
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)cPPNameCollector.getName(8).getParent().getParent();
        IScope iScope = ((IASTCompoundStatement)iASTFunctionDefinition.getBody()).getScope();
        IBinding[] iBindingArray = iScope.find("f");
        Assert.assertEquals((int)iBindingArray.length, (int)3);
        Assert.assertSame((Object)iBindingArray[0], (Object)iCPPClassType);
        Assert.assertSame((Object)iBindingArray[1], (Object)iFunction);
        Assert.assertSame((Object)iBindingArray[2], (Object)iFunction2);
    }

    public void testGets() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {                                 \n");
        stringBuffer.append("   int a;                                 \n");
        stringBuffer.append("   void fa();                             \n");
        stringBuffer.append("};                                        \n");
        stringBuffer.append("class B : public A {                      \n");
        stringBuffer.append("   int b;                                 \n");
        stringBuffer.append("   void fb();                             \n");
        stringBuffer.append("};                                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(3).resolveBinding();
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(1).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(2).resolveBinding();
        ICPPField iCPPField2 = (ICPPField)cPPNameCollector.getName(5).resolveBinding();
        ICPPMethod iCPPMethod2 = (ICPPMethod)cPPNameCollector.getName(6).resolveBinding();
        ICPPField[] iCPPFieldArray = iCPPClassType2.getDeclaredFields();
        Assert.assertEquals((int)iCPPFieldArray.length, (int)1);
        Assert.assertSame((Object)iCPPFieldArray[0], (Object)iCPPField2);
        iCPPFieldArray = iCPPClassType2.getFields();
        Assert.assertEquals((int)iCPPFieldArray.length, (int)2);
        Assert.assertSame((Object)iCPPFieldArray[0], (Object)iCPPField2);
        Assert.assertSame((Object)iCPPFieldArray[1], (Object)iCPPField);
        iCPPFieldArray = iCPPClassType2.getDeclaredMethods();
        Assert.assertEquals((int)iCPPFieldArray.length, (int)1);
        Assert.assertSame((Object)iCPPFieldArray[0], (Object)iCPPMethod2);
        iCPPFieldArray = iCPPClassType2.getAllDeclaredMethods();
        Assert.assertEquals((int)iCPPFieldArray.length, (int)2);
        Assert.assertSame((Object)iCPPFieldArray[0], (Object)iCPPMethod2);
        Assert.assertSame((Object)iCPPFieldArray[1], (Object)iCPPMethod);
        ICPPMethod[] iCPPMethodArray = ((ICPPClassScope)iCPPClassType2.getCompositeScope()).getImplicitMethods();
        Assert.assertEquals((int)iCPPMethodArray.length, (int)4);
        Assert.assertTrue((boolean)iCPPMethodArray[0].getName().equals("B"));
        Assert.assertTrue((boolean)iCPPMethodArray[1].getName().equals("B"));
        Assert.assertTrue((boolean)iCPPMethodArray[2].getName().equals("operator ="));
        Assert.assertTrue((boolean)iCPPMethodArray[3].getName().equals("~B"));
        ICPPMethod[] iCPPMethodArray2 = ((ICPPClassScope)iCPPClassType.getCompositeScope()).getImplicitMethods();
        Assert.assertEquals((int)iCPPMethodArray2.length, (int)4);
        Assert.assertTrue((boolean)iCPPMethodArray2[0].getName().equals("A"));
        Assert.assertTrue((boolean)iCPPMethodArray2[1].getName().equals("A"));
        Assert.assertTrue((boolean)iCPPMethodArray2[2].getName().equals("operator ="));
        Assert.assertTrue((boolean)iCPPMethodArray2[3].getName().equals("~A"));
        iCPPFieldArray = iCPPClassType2.getMethods();
        Assert.assertEquals((int)iCPPFieldArray.length, (int)10);
        Assert.assertSame((Object)iCPPFieldArray[0], (Object)iCPPMethod2);
        Assert.assertSame((Object)iCPPFieldArray[1], (Object)iCPPMethodArray[0]);
        Assert.assertSame((Object)iCPPFieldArray[2], (Object)iCPPMethodArray[1]);
        Assert.assertSame((Object)iCPPFieldArray[3], (Object)iCPPMethodArray[2]);
        Assert.assertSame((Object)iCPPFieldArray[4], (Object)iCPPMethodArray[3]);
        Assert.assertSame((Object)iCPPFieldArray[5], (Object)iCPPMethod);
        Assert.assertSame((Object)iCPPFieldArray[6], (Object)iCPPMethodArray2[0]);
        Assert.assertSame((Object)iCPPFieldArray[7], (Object)iCPPMethodArray2[1]);
        Assert.assertSame((Object)iCPPFieldArray[8], (Object)iCPPMethodArray2[2]);
        Assert.assertSame((Object)iCPPFieldArray[9], (Object)iCPPMethodArray2[3]);
    }

    public void testBug87424() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int * restrict x;", ParserLanguage.CPP, true);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(0).resolveBinding();
        IType iType = iVariable.getType();
        Assert.assertTrue((boolean)(iType instanceof IGPPPointerType));
        Assert.assertTrue((boolean)((IGPPPointerType)iType).isRestrict());
        iASTTranslationUnit = this.parse("class A {}; int A::* restrict x;", ParserLanguage.CPP, true);
        cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        iVariable = (IVariable)cPPNameCollector.getName(3).resolveBinding();
        iType = iVariable.getType();
        Assert.assertTrue((boolean)(iType instanceof IGPPPointerToMemberType));
        Assert.assertTrue((boolean)((IGPPPointerToMemberType)iType).isRestrict());
    }

    public void testBug87705() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A { friend class B::C; };", ParserLanguage.CPP, true);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IProblemBinding iProblemBinding = (IProblemBinding)cPPNameCollector.getName(2).resolveBinding();
        Assert.assertEquals((int)iProblemBinding.getID(), (int)1);
        IProblemBinding iProblemBinding2 = (IProblemBinding)cPPNameCollector.getName(3).resolveBinding();
        Assert.assertEquals((int)iProblemBinding2.getID(), (int)10);
    }

    public void testBug88459() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int f(); ", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        Assert.assertFalse((boolean)iFunction.isStatic());
    }

    public void testBug88501_1() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("void f(); void f( int ); struct f;", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertTrue((boolean)(cPPNameCollector.getName(0).resolveBinding() instanceof IFunction));
        Assert.assertTrue((boolean)(cPPNameCollector.getName(1).resolveBinding() instanceof IFunction));
        Assert.assertTrue((boolean)(cPPNameCollector.getName(3).resolveBinding() instanceof ICPPClassType));
    }

    public void testBug8342_2() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("extern int a; extern char a;", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertTrue((boolean)(cPPNameCollector.getName(0).resolveBinding() instanceof IVariable));
        IProblemBinding iProblemBinding = (IProblemBinding)cPPNameCollector.getName(1).resolveBinding();
        Assert.assertEquals((int)iProblemBinding.getID(), (int)12);
    }

    public void testNamespaceAlias_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A { int i; }      \n");
        stringBuffer.append("namespace B = A;            \n");
        stringBuffer.append("void f() {                  \n");
        stringBuffer.append("   B::i;                    \n");
        stringBuffer.append("}                           \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        ICPPNamespaceAlias iCPPNamespaceAlias = (ICPPNamespaceAlias)cPPNameCollector.getName(6).resolveBinding();
        ICPPVariable iCPPVariable = (ICPPVariable)cPPNameCollector.getName(7).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespace, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPNamespaceAlias, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPVariable, 3);
        String[] stringArray = iCPPVariable.getQualifiedName();
        Assert.assertEquals((String)stringArray[0], (String)"A");
        Assert.assertEquals((String)stringArray[1], (String)"i");
        Assert.assertTrue((boolean)iCPPVariable.isGloballyQualified());
        stringArray = iCPPNamespaceAlias.getQualifiedName();
        Assert.assertEquals((String)stringArray[0], (String)"B");
        Assert.assertTrue((boolean)iCPPNamespaceAlias.isGloballyQualified());
    }

    public void testBug89539() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A{};              \n");
        stringBuffer.append("class B : public A {    \n");
        stringBuffer.append("   B () : A() {}        \n");
        stringBuffer.append("};                      \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        Assert.assertSame((Object)iCPPClassType, (Object)iCPPClassType2);
        ICPPConstructor iCPPConstructor = (ICPPConstructor)cPPNameCollector.getName(4).resolveBinding();
        Assert.assertSame((Object)iCPPConstructor.getScope(), (Object)iCPPClassType.getCompositeScope());
        iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertTrue((boolean)(cPPNameCollector.getName(4).resolveBinding() instanceof ICPPConstructor));
    }

    public void testBug89851() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class B * b;            \n");
        stringBuffer.append("class A {               \n");
        stringBuffer.append("   A * a;               \n");
        stringBuffer.append("};                      \n");
        stringBuffer.append("class A;                \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertTrue((boolean)(cPPNameCollector.getName(0).resolveBinding() instanceof ICPPClassType));
        Assert.assertTrue((boolean)(cPPNameCollector.getName(1).resolveBinding() instanceof ICPPVariable));
        Assert.assertTrue((boolean)(cPPNameCollector.getName(2).resolveBinding() instanceof ICPPClassType));
        Assert.assertTrue((boolean)(cPPNameCollector.getName(3).resolveBinding() instanceof ICPPClassType));
    }

    public void testBug89828() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class B * b; void f();  void f( int );", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertTrue((boolean)(cPPNameCollector.getName(0).resolveBinding() instanceof ICPPClassType));
        Assert.assertTrue((boolean)(cPPNameCollector.getName(1).resolveBinding() instanceof ICPPVariable));
        IFunction iFunction = (IFunction)cPPNameCollector.getName(2).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(3).resolveBinding();
        IScope iScope = iASTTranslationUnit.getScope();
        IBinding[] iBindingArray = iScope.find("f");
        Assert.assertEquals((int)iBindingArray.length, (int)2);
        Assert.assertSame((Object)iBindingArray[0], (Object)iFunction);
        Assert.assertSame((Object)iBindingArray[1], (Object)iFunction2);
    }

    public void testBug90039() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {                  \n");
        stringBuffer.append("   enum type { t1, t2 };   \n");
        stringBuffer.append("   void f( type t );       \n");
        stringBuffer.append("};                         \n");
        stringBuffer.append("class B : public A {       \n");
        stringBuffer.append("   void g() {              \n");
        stringBuffer.append("      f( A::t1 );          \n");
        stringBuffer.append("   }                       \n");
        stringBuffer.append("};                         \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(10).resolveBinding();
        IEnumerator iEnumerator = (IEnumerator)cPPNameCollector.getName(13).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 2);
        this.assertInstances(cPPNameCollector, (IBinding)iEnumerator, 3);
    }

    public void testBug90039_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f( void ) {                 \n");
        stringBuffer.append("   enum { one };                 \n");
        stringBuffer.append("}                                \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertTrue((boolean)(cPPNameCollector.getName(0).resolveBinding() instanceof IFunction));
        Assert.assertTrue((boolean)(cPPNameCollector.getName(1).resolveBinding() instanceof IParameter));
        IEnumeration iEnumeration = (IEnumeration)cPPNameCollector.getName(2).resolveBinding();
        IEnumerator iEnumerator = (IEnumerator)cPPNameCollector.getName(3).resolveBinding();
        Assert.assertSame((Object)iEnumerator.getType(), (Object)iEnumeration);
    }

    public void testOperatorConversionNames() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class Foo {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("operator int();\n");
        stringBuffer.append("char& operator[](unsigned int);\n");
        stringBuffer.append("};\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IASTName iASTName = cPPNameCollector.getName(1);
        IASTName iASTName2 = cPPNameCollector.getName(2);
        Assert.assertNotNull((Object)iASTName);
        Assert.assertNotNull((Object)iASTName2);
        Assert.assertTrue((boolean)(iASTName instanceof ICPPASTConversionName));
        Assert.assertTrue((boolean)(iASTName2 instanceof ICPPASTOperatorName));
        IASTTypeId iASTTypeId = ((ICPPASTConversionName)iASTName).getTypeId();
        Assert.assertNotNull((Object)iASTTypeId);
        Assert.assertEquals((int)((IASTSimpleDeclSpecifier)iASTTypeId.getDeclSpecifier()).getType(), (int)3);
    }

    public void testBug36769B() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X { operator int(); }; \n");
        stringBuffer.append("X::operator int() { } \n");
        stringBuffer.append("template <class A,B> class X<A,C> { operator int(); }; \n");
        stringBuffer.append("template <class A,B> X<A,C>::operator int() { } \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)22);
        Assert.assertNotNull((Object)cPPNameCollector.getName(1));
        Assert.assertNotNull((Object)cPPNameCollector.getName(4));
        Assert.assertNotNull((Object)cPPNameCollector.getName(12));
        Assert.assertNotNull((Object)cPPNameCollector.getName(21));
        Assert.assertNotNull((Object)cPPNameCollector.getName(2));
        Assert.assertNotNull((Object)cPPNameCollector.getName(16));
        Assert.assertTrue((boolean)(cPPNameCollector.getName(1) instanceof ICPPASTConversionName));
        Assert.assertTrue((boolean)(cPPNameCollector.getName(4) instanceof ICPPASTConversionName));
        Assert.assertTrue((boolean)(cPPNameCollector.getName(12) instanceof ICPPASTConversionName));
        Assert.assertTrue((boolean)(cPPNameCollector.getName(21) instanceof ICPPASTConversionName));
        Assert.assertNotNull((Object)((ICPPASTConversionName)cPPNameCollector.getName(1)).getTypeId());
        Assert.assertNotNull((Object)((ICPPASTConversionName)cPPNameCollector.getName(4)).getTypeId());
        Assert.assertNotNull((Object)((ICPPASTConversionName)cPPNameCollector.getName(12)).getTypeId());
        Assert.assertNotNull((Object)((ICPPASTConversionName)cPPNameCollector.getName(21)).getTypeId());
        Assert.assertTrue((boolean)(cPPNameCollector.getName(2) instanceof ICPPASTQualifiedName));
        Assert.assertTrue((boolean)(cPPNameCollector.getName(16) instanceof ICPPASTQualifiedName));
        Assert.assertTrue((boolean)((ICPPASTQualifiedName)cPPNameCollector.getName(2)).isConversionOrOperator());
        Assert.assertTrue((boolean)((ICPPASTQualifiedName)cPPNameCollector.getName(16)).isConversionOrOperator());
    }

    public void testBug88662() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int foo() {  return int();}", ParserLanguage.CPP);
        IASTReturnStatement iASTReturnStatement = (IASTReturnStatement)((IASTCompoundStatement)((IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0]).getBody()).getStatements()[0];
        ICPPASTSimpleTypeConstructorExpression iCPPASTSimpleTypeConstructorExpression = (ICPPASTSimpleTypeConstructorExpression)iASTReturnStatement.getReturnValue();
        Assert.assertEquals((Object)iCPPASTSimpleTypeConstructorExpression.getInitialValue(), null);
        Assert.assertEquals((int)iCPPASTSimpleTypeConstructorExpression.getSimpleType(), (int)3);
    }

    public void testBug90498_1() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("typedef int INT;\ntypedef INT ( FOO ) (INT);", ParserLanguage.CPP);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[1];
        IASTDeclSpecifier iASTDeclSpecifier = iASTSimpleDeclaration.getDeclSpecifier();
        Assert.assertTrue((boolean)(iASTDeclSpecifier instanceof ICPPASTNamedTypeSpecifier));
        Assert.assertEquals((String)((ICPPASTNamedTypeSpecifier)iASTDeclSpecifier).getName().toString(), (String)"INT");
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
        Assert.assertTrue((boolean)(iASTDeclarator instanceof IASTFunctionDeclarator));
        Assert.assertNotNull((Object)iASTDeclarator.getNestedDeclarator());
        IASTDeclarator iASTDeclarator2 = iASTDeclarator.getNestedDeclarator();
        Assert.assertEquals((String)iASTDeclarator2.getName().toString(), (String)"FOO");
    }

    public void testBug90498_2() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int (* foo) (int) (0);", ParserLanguage.CPP);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTDeclSpecifier iASTDeclSpecifier = iASTSimpleDeclaration.getDeclSpecifier();
        Assert.assertTrue((boolean)(iASTDeclSpecifier instanceof IASTSimpleDeclSpecifier));
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
        Assert.assertTrue((boolean)(iASTDeclarator instanceof IASTFunctionDeclarator));
        Assert.assertNotNull((Object)iASTDeclarator.getNestedDeclarator());
        IASTDeclarator iASTDeclarator2 = iASTDeclarator.getNestedDeclarator();
        Assert.assertEquals((String)iASTDeclarator2.getName().toString(), (String)"foo");
        Assert.assertNotNull((Object)iASTDeclarator.getInitializer());
    }

    public void testBug866274() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("class D { /* ... */ };\n");
        stringBuffer.append("D d1;\n");
        stringBuffer.append("const D d2;\n");
        stringBuffer.append("void foo() {\n");
        stringBuffer.append("    typeid(d1) == typeid(d2);\n");
        stringBuffer.append("    typeid(D) == typeid(d2);\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[3];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        IASTStatement[] iASTStatementArray = iASTCompoundStatement.getStatements();
        int n = 0;
        while (n < iASTStatementArray.length) {
            IASTTypeId iASTTypeId;
            IASTTypeIdExpression iASTTypeIdExpression;
            IASTBinaryExpression iASTBinaryExpression = (IASTBinaryExpression)((IASTExpressionStatement)iASTStatementArray[n]).getExpression();
            if (n == 1) {
                iASTTypeIdExpression = (IASTTypeIdExpression)iASTBinaryExpression.getOperand1();
                iASTTypeId = iASTTypeIdExpression.getTypeId();
                Assert.assertTrue((boolean)(((IASTNamedTypeSpecifier)iASTTypeId.getDeclSpecifier()).getName().resolveBinding() instanceof IType));
            } else {
                iASTTypeIdExpression = (IASTUnaryExpression)iASTBinaryExpression.getOperand1();
                iASTTypeId = (IASTIdExpression)iASTTypeIdExpression.getOperand();
                Assert.assertTrue((boolean)(iASTTypeId.getName().resolveBinding() instanceof IVariable));
            }
            iASTTypeIdExpression = (IASTUnaryExpression)iASTBinaryExpression.getOperand2();
            iASTTypeId = (IASTIdExpression)iASTTypeIdExpression.getOperand();
            Assert.assertTrue((boolean)(iASTTypeId.getName().resolveBinding() instanceof IVariable));
            ++n;
        }
    }

    public void testTypedefFunction() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("typedef int foo (int);", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IBinding iBinding = cPPNameCollector.getName(0).resolveBinding();
        Assert.assertTrue((boolean)(iBinding instanceof ITypedef));
        Assert.assertTrue((boolean)(((ITypedef)iBinding).getType() instanceof IFunctionType));
    }

    public void testBug90616() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f( int );          \n");
        stringBuffer.append("void foo(){             \n");
        stringBuffer.append("   f( ( 1, 2 ) );       \n");
        stringBuffer.append("}                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(3).resolveBinding();
        Assert.assertSame((Object)iFunction, (Object)iFunction2);
    }

    public void testBug90603() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class X { void f(){} };", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(1).resolveBinding();
        Assert.assertFalse((boolean)iCPPMethod.isStatic());
        String[] stringArray = iCPPMethod.getQualifiedName();
        Assert.assertEquals((int)stringArray.length, (int)2);
        Assert.assertEquals((String)stringArray[0], (String)"X");
        Assert.assertEquals((String)stringArray[1], (String)"f");
        Assert.assertTrue((boolean)iCPPMethod.isGloballyQualified());
        Assert.assertEquals((int)iCPPMethod.getVisibility(), (int)3);
        Assert.assertSame((Object)iCPPMethod.getScope(), (Object)iCPPClassType.getCompositeScope());
    }

    public void testBug90662() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {   };           \n");
        stringBuffer.append("X x;                     \n");
        stringBuffer.append("class X {   };           \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(2).resolveBinding();
        IProblemBinding iProblemBinding = (IProblemBinding)cPPNameCollector.getName(3).resolveBinding();
        Assert.assertSame((Object)iVariable.getType(), (Object)iCPPClassType);
        Assert.assertEquals((int)iProblemBinding.getID(), (int)11);
    }

    public void testOperatorNames() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct C {                               \n");
        stringBuffer.append("   void* operator new [ ] (unsigned int);\n");
        stringBuffer.append("   void* operator new (unsigned int);\n");
        stringBuffer.append("   void operator delete [ ] ( void * );       \n");
        stringBuffer.append("   void operator delete (void *);\n");
        stringBuffer.append("   const C& operator+=(const C&);\n");
        stringBuffer.append("   const C& operator -= (const C&);\n");
        stringBuffer.append("   const C& operator *=   (const C&);\n");
        stringBuffer.append("   const C& operator /= (const C&);\n");
        stringBuffer.append("   const C& operator %= (const C&);\n");
        stringBuffer.append("   const C& operator^=(const C&);\n");
        stringBuffer.append("   const C& operator&= (const C&);\n");
        stringBuffer.append("   const C& operator |= (const C&);\n");
        stringBuffer.append("   const C& operator >>=(const C&);\n");
        stringBuffer.append("   const C& operator<<= (const C&);\n");
        stringBuffer.append("   const C& operator<<(const C&);\n");
        stringBuffer.append("   const C& operator>>(const C&);\n");
        stringBuffer.append("   const C& operator /**/   == /**/  (const C&);\n");
        stringBuffer.append("   const C& operator != /**/ (const C&);\n");
        stringBuffer.append("   const C& operator <= (const C&);\n");
        stringBuffer.append("   const C& operator /**/ >=(const C&);\n");
        stringBuffer.append("   const C& operator =(const C&);\n");
        stringBuffer.append("   const C& operator&& (const C&);\n");
        stringBuffer.append("   const C& operator ||(const C&);\n");
        stringBuffer.append("   const C& operator ++(const C&);\n");
        stringBuffer.append("   const C& operator-- (const C&);\n");
        stringBuffer.append("   const C& operator/**/,/**/(const C&);\n");
        stringBuffer.append("   const C& operator->*\n(const C&);\n");
        stringBuffer.append("   const C& operator -> (const C&);\n");
        stringBuffer.append("   const C& operator /**/ ( /**/ ) /**/ (const C&);\n");
        stringBuffer.append("   const C& operator /**/ [ /**/ ] /**/ (const C&);\n");
        stringBuffer.append("   const C& operator + (const C&);\n");
        stringBuffer.append("   const C& operator- (const C&);\n");
        stringBuffer.append("   const C& operator *(const C&);\n");
        stringBuffer.append("   const C& operator /(const C&);\n");
        stringBuffer.append("   const C& operator % /**/(const C&);\n");
        stringBuffer.append("   const C& operator ^(const C&);\n");
        stringBuffer.append("   const C& operator &(const C&);\n");
        stringBuffer.append("   const C& operator |(const C&);\n");
        stringBuffer.append("   const C& operator   ~ (const C&);\n");
        stringBuffer.append("   const C& operator \t\r\n ! /**/ (const C&);\n");
        stringBuffer.append("   const C& operator <(const C&);\n");
        stringBuffer.append("   const C& operator>(const C&);\n");
        stringBuffer.append("};                                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)161);
        Assert.assertEquals((String)cPPNameCollector.getName(1).toString(), (String)"operator new[]");
        Assert.assertEquals((String)cPPNameCollector.getName(3).toString(), (String)"operator new");
        Assert.assertEquals((String)cPPNameCollector.getName(5).toString(), (String)"operator delete[]");
        Assert.assertEquals((String)cPPNameCollector.getName(7).toString(), (String)"operator delete");
        Assert.assertEquals((String)cPPNameCollector.getName(10).toString(), (String)"operator +=");
        Assert.assertEquals((String)cPPNameCollector.getName(14).toString(), (String)"operator -=");
        Assert.assertEquals((String)cPPNameCollector.getName(18).toString(), (String)"operator *=");
        Assert.assertEquals((String)cPPNameCollector.getName(22).toString(), (String)"operator /=");
        Assert.assertEquals((String)cPPNameCollector.getName(26).toString(), (String)"operator %=");
        Assert.assertEquals((String)cPPNameCollector.getName(30).toString(), (String)"operator ^=");
        Assert.assertEquals((String)cPPNameCollector.getName(34).toString(), (String)"operator &=");
        Assert.assertEquals((String)cPPNameCollector.getName(38).toString(), (String)"operator |=");
        Assert.assertEquals((String)cPPNameCollector.getName(42).toString(), (String)"operator >>=");
        Assert.assertEquals((String)cPPNameCollector.getName(46).toString(), (String)"operator <<=");
        Assert.assertEquals((String)cPPNameCollector.getName(50).toString(), (String)"operator <<");
        Assert.assertEquals((String)cPPNameCollector.getName(54).toString(), (String)"operator >>");
        Assert.assertEquals((String)cPPNameCollector.getName(58).toString(), (String)"operator ==");
        Assert.assertEquals((String)cPPNameCollector.getName(62).toString(), (String)"operator !=");
        Assert.assertEquals((String)cPPNameCollector.getName(66).toString(), (String)"operator <=");
        Assert.assertEquals((String)cPPNameCollector.getName(70).toString(), (String)"operator >=");
        Assert.assertEquals((String)cPPNameCollector.getName(74).toString(), (String)"operator =");
        Assert.assertEquals((String)cPPNameCollector.getName(78).toString(), (String)"operator &&");
        Assert.assertEquals((String)cPPNameCollector.getName(82).toString(), (String)"operator ||");
        Assert.assertEquals((String)cPPNameCollector.getName(86).toString(), (String)"operator ++");
        Assert.assertEquals((String)cPPNameCollector.getName(90).toString(), (String)"operator --");
        Assert.assertEquals((String)cPPNameCollector.getName(94).toString(), (String)"operator ,");
        Assert.assertEquals((String)cPPNameCollector.getName(98).toString(), (String)"operator ->*");
        Assert.assertEquals((String)cPPNameCollector.getName(102).toString(), (String)"operator ->");
        Assert.assertEquals((String)cPPNameCollector.getName(106).toString(), (String)"operator ()");
        Assert.assertEquals((String)cPPNameCollector.getName(110).toString(), (String)"operator []");
        Assert.assertEquals((String)cPPNameCollector.getName(114).toString(), (String)"operator +");
        Assert.assertEquals((String)cPPNameCollector.getName(118).toString(), (String)"operator -");
        Assert.assertEquals((String)cPPNameCollector.getName(122).toString(), (String)"operator *");
        Assert.assertEquals((String)cPPNameCollector.getName(126).toString(), (String)"operator /");
        Assert.assertEquals((String)cPPNameCollector.getName(130).toString(), (String)"operator %");
        Assert.assertEquals((String)cPPNameCollector.getName(134).toString(), (String)"operator ^");
        Assert.assertEquals((String)cPPNameCollector.getName(138).toString(), (String)"operator &");
        Assert.assertEquals((String)cPPNameCollector.getName(142).toString(), (String)"operator |");
        Assert.assertEquals((String)cPPNameCollector.getName(146).toString(), (String)"operator ~");
        Assert.assertEquals((String)cPPNameCollector.getName(150).toString(), (String)"operator !");
        Assert.assertEquals((String)cPPNameCollector.getName(154).toString(), (String)"operator <");
        Assert.assertEquals((String)cPPNameCollector.getName(158).toString(), (String)"operator >");
    }

    public void testBug90623() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int I;             \n");
        stringBuffer.append("typedef int I;             \n");
        stringBuffer.append("typedef I I;               \n");
        stringBuffer.append("class A {                  \n");
        stringBuffer.append("   typedef char I;         \n");
        stringBuffer.append("   typedef char I;         \n");
        stringBuffer.append("   typedef I I;            \n");
        stringBuffer.append("};                         \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ITypedef iTypedef = (ITypedef)cPPNameCollector.getName(0).resolveBinding();
        ITypedef iTypedef2 = (ITypedef)cPPNameCollector.getName(1).resolveBinding();
        ITypedef iTypedef3 = (ITypedef)cPPNameCollector.getName(2).resolveBinding();
        ITypedef iTypedef4 = (ITypedef)cPPNameCollector.getName(3).resolveBinding();
        ITypedef iTypedef5 = (ITypedef)cPPNameCollector.getName(5).resolveBinding();
        ITypedef iTypedef6 = (ITypedef)cPPNameCollector.getName(8).resolveBinding();
        ITypedef iTypedef7 = (ITypedef)cPPNameCollector.getName(7).resolveBinding();
        ITypedef iTypedef8 = (ITypedef)cPPNameCollector.getName(6).resolveBinding();
        Assert.assertSame((Object)iTypedef, (Object)iTypedef2);
        Assert.assertSame((Object)iTypedef2, (Object)iTypedef3);
        Assert.assertSame((Object)iTypedef3, (Object)iTypedef4);
        Assert.assertNotSame((Object)iTypedef4, (Object)iTypedef6);
        Assert.assertSame((Object)iTypedef6, (Object)iTypedef7);
        Assert.assertSame((Object)iTypedef7, (Object)iTypedef8);
        Assert.assertSame((Object)iTypedef8, (Object)iTypedef5);
        Assert.assertTrue((boolean)(iTypedef.getType() instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iTypedef.getType()).getType(), (int)3);
        Assert.assertTrue((boolean)(iTypedef5.getType() instanceof IBasicType));
        Assert.assertEquals((int)((IBasicType)iTypedef5.getType()).getType(), (int)2);
    }

    public void testBug90623_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int I;             \n");
        stringBuffer.append("void f11( I i );           \n");
        stringBuffer.append("void main(){ f a; }          \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IASTName iASTName = cPPNameCollector.getName(5);
        iASTName.resolvePrefix();
    }

    public void testBug90654_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {            \n");
        stringBuffer.append("   X( const X & );   \n");
        stringBuffer.append("};                   \n");
        stringBuffer.append("class Y {            \n");
        stringBuffer.append("   operator X ();    \n");
        stringBuffer.append("};                   \n");
        stringBuffer.append("Y y;                 \n");
        stringBuffer.append("X x = new X( y );    \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPConstructor iCPPConstructor = (ICPPConstructor)cPPNameCollector.getName(1).resolveBinding();
        ICPPConstructor iCPPConstructor2 = (ICPPConstructor)cPPNameCollector.getName(11).resolveBinding();
        Assert.assertSame((Object)iCPPConstructor2, (Object)iCPPConstructor);
    }

    public void testBug90654_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {                \n");
        stringBuffer.append("   operator short();      \n");
        stringBuffer.append("} a;                      \n");
        stringBuffer.append("int f( int );             \n");
        stringBuffer.append("int f( float );           \n");
        stringBuffer.append("int x = f(a);             \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(3).resolveBinding();
        IFunction iFunction2 = (IFunction)cPPNameCollector.getName(8).resolveBinding();
        Assert.assertSame((Object)iFunction, (Object)iFunction2);
    }

    public void testBug90653() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {};                    \n");
        stringBuffer.append("struct B : public A {           \n");
        stringBuffer.append("   B& operator = (const B & );  \n");
        stringBuffer.append("};                              \n");
        stringBuffer.append("B& B::operator = (const B & s){ \n");
        stringBuffer.append("   this->A::operator=(s);       \n");
        stringBuffer.append("   return *this;                \n");
        stringBuffer.append("}                               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPMethod iCPPMethod = iCPPClassType.getMethods()[2];
        ICPPMethod iCPPMethod2 = (ICPPMethod)cPPNameCollector.getName(4).resolveBinding();
        ICPPMethod iCPPMethod3 = (ICPPMethod)cPPNameCollector.getName(10).resolveBinding();
        ICPPMethod iCPPMethod4 = (ICPPMethod)cPPNameCollector.getName(15).resolveBinding();
        Assert.assertSame((Object)iCPPMethod2, (Object)iCPPMethod3);
        Assert.assertSame((Object)iCPPMethod4, (Object)iCPPMethod);
    }

    public void testBug86618() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f( char * );            \n");
        stringBuffer.append("void foo() {                 \n");
        stringBuffer.append("   f( \"test\" );            \n");
        stringBuffer.append("}                            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 2);
    }

    public void testBug45129() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f( int (*pf) (char) );       \n");
        stringBuffer.append("int g( char );                    \n");
        stringBuffer.append("void foo () {                     \n");
        stringBuffer.append("   f( g ) ;                       \n");
        stringBuffer.append("}                                 \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(0).resolveBinding();
        ICPPFunction iCPPFunction2 = (ICPPFunction)cPPNameCollector.getName(3).resolveBinding();
        IBinding iBinding = cPPNameCollector.getName(6).resolveBinding();
        IBinding iBinding2 = cPPNameCollector.getName(7).resolveBinding();
        Assert.assertSame((Object)iCPPFunction, (Object)iBinding);
        Assert.assertSame((Object)iCPPFunction2, (Object)iBinding2);
    }

    public void testAmbiguousStatements() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class ABC { \n");
        stringBuffer.append("   class DEF { };\n");
        stringBuffer.append("   static int GHI;\n");
        stringBuffer.append("}; \n");
        stringBuffer.append("int ABC::GHI = 77; // ray bourque\n");
        stringBuffer.append("int f() { \n");
        stringBuffer.append("  int value;\n");
        stringBuffer.append("  ABC::DEF * var;\n");
        stringBuffer.append("  ABC::GHI * value;\n");
        stringBuffer.append("}");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        Assert.assertEquals((int)3, (int)iASTDeclarationArray.length);
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)((IASTFunctionDefinition)iASTDeclarationArray[2]).getBody();
        Assert.assertTrue((boolean)(iASTCompoundStatement.getStatements()[1] instanceof IASTDeclarationStatement));
        Assert.assertTrue((boolean)(iASTCompoundStatement.getStatements()[2] instanceof IASTExpressionStatement));
    }

    public void testBug86639() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f(){                              \n");
        stringBuffer.append("   union { int a; char* p; };          \n");
        stringBuffer.append("   a = 1;                              \n");
        stringBuffer.append("}                                      \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(2).resolveBinding();
        ICPPField iCPPField2 = (ICPPField)cPPNameCollector.getName(4).resolveBinding();
        Assert.assertSame((Object)iCPPField, (Object)iCPPField2);
    }

    public void testBug80940() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f () {                     \n");
        stringBuffer.append("   int aa1, aa2;                \n");
        stringBuffer.append("   a;                           \n");
        stringBuffer.append("}                               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(2).resolveBinding();
        IBinding[] iBindingArray = cPPNameCollector.getName(3).resolvePrefix();
        Assert.assertEquals((int)iBindingArray.length, (int)2);
        Assert.assertSame((Object)iBindingArray[0], (Object)iVariable);
        Assert.assertSame((Object)iBindingArray[1], (Object)iVariable2);
    }

    public void testBug77024() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct Ex {                            \n");
        stringBuffer.append("   int d();                            \n");
        stringBuffer.append("   int d() const;                      \n");
        stringBuffer.append("};                                     \n");
        stringBuffer.append("int Ex::d() {}                         \n");
        stringBuffer.append("int Ex::d() const {}                   \n");
        stringBuffer.append("void f() {                             \n");
        stringBuffer.append("   const Ex * e;                       \n");
        stringBuffer.append("   e->d();                             \n");
        stringBuffer.append("}                                      \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(1).resolveBinding();
        ICPPFunction iCPPFunction2 = (ICPPFunction)cPPNameCollector.getName(2).resolveBinding();
        Assert.assertNotSame((Object)iCPPFunction, (Object)iCPPFunction2);
        Assert.assertFalse((boolean)((ICPPFunctionType)iCPPFunction.getType()).isConst());
        Assert.assertTrue((boolean)((ICPPFunctionType)iCPPFunction2.getType()).isConst());
        ICPPFunction iCPPFunction3 = (ICPPFunction)cPPNameCollector.getName(5).resolveBinding();
        ICPPFunction iCPPFunction4 = (ICPPFunction)cPPNameCollector.getName(8).resolveBinding();
        Assert.assertSame((Object)iCPPFunction, (Object)iCPPFunction3);
        Assert.assertSame((Object)iCPPFunction2, (Object)iCPPFunction4);
        IBinding iBinding = cPPNameCollector.getName(13).resolveBinding();
        Assert.assertSame((Object)iCPPFunction2, (Object)iBinding);
    }

    public void testBug91773() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class P {                    \n");
        stringBuffer.append("   Point() : xCoord(0) {}    \n");
        stringBuffer.append("   int xCoord;               \n");
        stringBuffer.append("};                           \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(2).resolveBinding();
        ICPPField iCPPField2 = (ICPPField)cPPNameCollector.getName(3).resolveBinding();
        Assert.assertSame((Object)iCPPField, (Object)iCPPField2);
    }

    public void testBug90648() throws ParserException {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int f() { int (&ra)[3] = a; }", ParserLanguage.CPP);
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        IASTDeclarationStatement iASTDeclarationStatement = (IASTDeclarationStatement)iASTCompoundStatement.getStatements()[0];
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTDeclarationStatement.getDeclaration();
        IASTSimpleDeclSpecifier iASTSimpleDeclSpecifier = (IASTSimpleDeclSpecifier)iASTSimpleDeclaration.getDeclSpecifier();
        Assert.assertEquals((int)3, (int)iASTSimpleDeclSpecifier.getType());
        IASTDeclarator[] iASTDeclaratorArray = iASTSimpleDeclaration.getDeclarators();
        Assert.assertEquals((int)iASTDeclaratorArray.length, (int)1);
        Assert.assertTrue((boolean)(iASTDeclaratorArray[0] instanceof IASTArrayDeclarator));
    }

    public void testBug92980() throws Exception {
        String string = "struct A { A(); A(const A&) throw(1); ~A() throw(X); };";
        this.parse(string, ParserLanguage.CPP, true, false);
    }

    public void testBug92882() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class Dummy { int v(); int d; };                \n");
        stringBuffer.append("void Dummy::v( int ){ d++; }                    \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertTrue((boolean)(cPPNameCollector.getName(5).resolveBinding() instanceof IProblemBinding));
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(2).resolveBinding();
        ICPPField iCPPField2 = (ICPPField)cPPNameCollector.getName(7).resolveBinding();
        Assert.assertSame((Object)iCPPField, (Object)iCPPField2);
    }

    public void testBug86547() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f( int, int );                    \n");
        stringBuffer.append("void f( int, int = 3);                 \n");
        stringBuffer.append("void f( int = 2, int );                \n");
        stringBuffer.append("void g() {                             \n");
        stringBuffer.append("   f( 3 );                             \n");
        stringBuffer.append("   f( );                               \n");
        stringBuffer.append("}                                      \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        this.assertInstances(cPPNameCollector, (IBinding)iFunction, 5);
    }

    public void testBug90647() throws Exception {
        this.parse("char msg[] = \"Syntax error on line %s\\n\";", ParserLanguage.CPP);
    }

    public void testBug82766() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int main(int argc, char **argv)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int sum=0;\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("for (i = 0; i < 10; ++i)\n");
        stringBuffer.append("for (int j = 0; j < 3; ++j)\n");
        stringBuffer.append("sum += j;\n");
        stringBuffer.append("for (i = 0; i < 10; ++i)\n");
        stringBuffer.append("for (int j = 0; j < 3; ++j) // line X\n");
        stringBuffer.append("sum += j;  // line Y\n");
        stringBuffer.append("int k;\n");
        stringBuffer.append("k = sum;\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        this.assertNoProblemBindings(cPPNameCollector);
    }

    public void testBug77385() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("int main(int argc, char *argv[])\n");
        stringBuffer.append("{\n");
        stringBuffer.append("    unsigned long l = 0;\n");
        stringBuffer.append("char *c;\n");
        stringBuffer.append("l |= ((unsigned long)(*((c)++)))<<24;\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        this.assertNoProblemBindings(cPPNameCollector);
    }

    public void testBug83997() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("namespace { int x; }", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        this.assertNoProblemBindings(cPPNameCollector);
    }

    protected void assertNoProblemBindings(AST2BaseTest.CPPNameCollector cPPNameCollector) {
        Iterator iterator = cPPNameCollector.nameList.iterator();
        while (iterator.hasNext()) {
            IASTName iASTName = (IASTName)iterator.next();
            Assert.assertFalse((boolean)(iASTName.resolveBinding() instanceof IProblemBinding));
        }
    }

    protected void assertProblemBindings(AST2BaseTest.CPPNameCollector cPPNameCollector, int n) {
        Iterator iterator = cPPNameCollector.nameList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            IASTName iASTName = (IASTName)iterator.next();
            Assert.assertNotNull((Object)iASTName.resolveBinding());
            if (!(iASTName.getBinding() instanceof IProblemBinding)) continue;
            ++n2;
        }
        Assert.assertEquals((int)n, (int)n2);
    }

    public void testBug85786() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("void f( int ); void foo () { void * p = &f; ( (void (*) (int)) p ) ( 1 ); }", ParserLanguage.C);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        this.assertNoProblemBindings(cPPNameCollector);
    }

    public void testBug90610() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class C {                   \n");
        stringBuffer.append("   static const int n = 1;  \n");
        stringBuffer.append("   static int arr[ n ];     \n");
        stringBuffer.append("};                          \n");
        stringBuffer.append("int C::arr[n];              \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(1).resolveBinding();
        Assert.assertTrue((boolean)iCPPField.isStatic());
        this.assertInstances(cPPNameCollector, (IBinding)iCPPField, 3);
    }

    public void testDeclDefn() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int a;                \n");
        stringBuffer.append("extern int b;         \n");
        stringBuffer.append("extern int c = 1;     \n");
        stringBuffer.append("int f( );             \n");
        stringBuffer.append("int f( int p ){}      \n");
        stringBuffer.append("struct S;             \n");
        stringBuffer.append("struct S { int d; };  \n");
        stringBuffer.append("struct X {            \n");
        stringBuffer.append("   static int y;      \n");
        stringBuffer.append("};                    \n");
        stringBuffer.append("namespace N {}        \n");
        stringBuffer.append("int X::y = 1;         \n");
        stringBuffer.append("int ( *g(int) )(int); \n");
        stringBuffer.append("int ( *pf)(int);      \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertTrue((boolean)cPPNameCollector.getName(0).isDefinition());
        Assert.assertFalse((boolean)cPPNameCollector.getName(1).isDefinition());
        Assert.assertTrue((boolean)cPPNameCollector.getName(2).isDefinition());
        Assert.assertFalse((boolean)cPPNameCollector.getName(3).isDefinition());
        Assert.assertTrue((boolean)cPPNameCollector.getName(4).isDefinition());
        Assert.assertTrue((boolean)cPPNameCollector.getName(5).isDefinition());
        Assert.assertFalse((boolean)cPPNameCollector.getName(6).isDefinition());
        Assert.assertTrue((boolean)cPPNameCollector.getName(7).isDefinition());
        Assert.assertTrue((boolean)cPPNameCollector.getName(8).isDefinition());
        Assert.assertTrue((boolean)cPPNameCollector.getName(9).isDefinition());
        Assert.assertFalse((boolean)cPPNameCollector.getName(10).isDefinition());
        Assert.assertTrue((boolean)cPPNameCollector.getName(11).isDefinition());
        Assert.assertTrue((boolean)cPPNameCollector.getName(12).isDefinition());
        Assert.assertFalse((boolean)cPPNameCollector.getName(15).isDefinition());
        Assert.assertTrue((boolean)cPPNameCollector.getName(18).isDefinition());
    }

    public void testBug95200() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f(double);                    \n");
        stringBuffer.append("int f(int);                       \n");
        stringBuffer.append("int (&rfi)(int) = f;              \n");
        stringBuffer.append("int (&rfd)(double) = f;           \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(0).resolveBinding();
        ICPPFunction iCPPFunction2 = (ICPPFunction)cPPNameCollector.getName(2).resolveBinding();
        Assert.assertSame((Object)cPPNameCollector.getName(6).resolveBinding(), (Object)iCPPFunction2);
        Assert.assertSame((Object)cPPNameCollector.getName(9).resolveBinding(), (Object)iCPPFunction);
    }

    public void testBug95425() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A { A(); };", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPConstructor iCPPConstructor = (ICPPConstructor)cPPNameCollector.getName(1).resolveBinding();
        ICPPConstructor[] iCPPConstructorArray = iCPPClassType.getConstructors();
        Assert.assertEquals((int)iCPPConstructorArray.length, (int)2);
        Assert.assertSame((Object)iCPPConstructor, (Object)iCPPConstructorArray[0]);
        iASTTranslationUnit = this.parse("class A { A( void ); };", ParserLanguage.CPP);
        cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        iCPPConstructor = (ICPPConstructor)cPPNameCollector.getName(1).resolveBinding();
        iCPPConstructorArray = iCPPClassType.getConstructors();
        Assert.assertEquals((int)iCPPConstructorArray.length, (int)2);
        Assert.assertSame((Object)iCPPConstructor, (Object)iCPPConstructorArray[0]);
    }

    public void testBug95461() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f( char * );                 \n");
        stringBuffer.append("void g(){                         \n");
        stringBuffer.append("   char x[100];                   \n");
        stringBuffer.append("   f( x );                        \n");
        stringBuffer.append("}                                 \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(0).resolveBinding();
        Assert.assertSame((Object)iCPPFunction, (Object)cPPNameCollector.getName(4).resolveBinding());
    }

    public void testAmbiguity() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A { };\n");
        stringBuffer.append("int f() { \n");
        stringBuffer.append("  A * b = 0;\n");
        stringBuffer.append("  A & c = 0;\n");
        stringBuffer.append("}");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        int n = 0;
        while (n < 2) {
            IASTDeclarationStatement iASTDeclarationStatement = (IASTDeclarationStatement)iASTCompoundStatement.getStatements()[n];
            String string = ((IASTNamedTypeSpecifier)((IASTSimpleDeclaration)iASTDeclarationStatement.getDeclaration()).getDeclSpecifier()).getName().toString();
            String string2 = ((IASTCompositeTypeSpecifier)iASTSimpleDeclaration.getDeclSpecifier()).getName().toString();
            Assert.assertEquals((String)string, (String)string2);
            ++n;
        }
    }

    public void testBug84696() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n int a; \n};\n");
        stringBuffer.append("struct B: virtual A { };\n");
        stringBuffer.append("struct C: B { };\n");
        stringBuffer.append("struct D: B { };\n");
        stringBuffer.append("struct E: public C, public D { };\n");
        stringBuffer.append("struct F: public A { };\n");
        stringBuffer.append("void f() {\n");
        stringBuffer.append("E e;\n");
        stringBuffer.append("e.B::a = 0;\n");
        stringBuffer.append("F f;\n");
        stringBuffer.append("f.A::a = 1;\n}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertEquals((int)cPPNameCollector.size(), (int)26);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        Assert.assertNotNull((Object)iCPPClassType);
        Assert.assertNotNull((Object)iCPPClassType2);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType, 4);
        this.assertInstances(cPPNameCollector, (IBinding)iCPPClassType2, 4);
    }

    public void testBasicPointerToMember() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("class X {\n");
        stringBuffer.append("  public:\n");
        stringBuffer.append("  void f(int);\n");
        stringBuffer.append("  int a;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int X:: * pmi = &X::a;\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        Assert.assertEquals((int)iASTTranslationUnit.getDeclarations().length, (int)2);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[1];
        IASTDeclarator iASTDeclarator = iASTSimpleDeclaration.getDeclarators()[0];
        ICPPASTPointerToMember iCPPASTPointerToMember = (ICPPASTPointerToMember)iASTDeclarator.getPointerOperators()[0];
        Assert.assertEquals((String)iCPPASTPointerToMember.getName().toString(), (String)"X::");
    }

    public void testBug84466() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct B {};\n");
        stringBuffer.append("struct D : B {};\n");
        stringBuffer.append("void foo(D* dp)\n{\n");
        stringBuffer.append("B* bp = dynamic_cast<B*>(dp);\n}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        ICPPASTCastExpression iCPPASTCastExpression = (ICPPASTCastExpression)((IASTInitializerExpression)((IASTSimpleDeclaration)((IASTDeclarationStatement)((IASTCompoundStatement)((IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[2]).getBody()).getStatements()[0]).getDeclaration()).getDeclarators()[0].getInitializer()).getExpression();
        Assert.assertEquals((int)iCPPASTCastExpression.getOperator(), (int)1);
    }

    public void testBug88338_CPP() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("struct A; struct A* a;", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertTrue((boolean)cPPNameCollector.getName(0).isDeclaration());
        Assert.assertFalse((boolean)cPPNameCollector.getName(0).isReference());
        Assert.assertTrue((boolean)cPPNameCollector.getName(1).isReference());
        Assert.assertFalse((boolean)cPPNameCollector.getName(1).isDeclaration());
        iASTTranslationUnit = this.parse("struct A* a;", ParserLanguage.CPP);
        cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertTrue((boolean)cPPNameCollector.getName(0).isDeclaration());
        Assert.assertFalse((boolean)cPPNameCollector.getName(0).isReference());
    }

    public void testPointerToFunction_CPP() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int (*pfi)();", ParserLanguage.CPP);
        Assert.assertEquals((int)iASTTranslationUnit.getDeclarations().length, (int)1);
        IASTSimpleDeclaration iASTSimpleDeclaration = (IASTSimpleDeclaration)iASTTranslationUnit.getDeclarations()[0];
        Assert.assertEquals((int)iASTSimpleDeclaration.getDeclarators().length, (int)1);
        IASTStandardFunctionDeclarator iASTStandardFunctionDeclarator = (IASTStandardFunctionDeclarator)iASTSimpleDeclaration.getDeclarators()[0];
        Assert.assertEquals((String)iASTStandardFunctionDeclarator.getName().toString(), (String)"");
        Assert.assertNotNull((Object)iASTStandardFunctionDeclarator.getNestedDeclarator());
        Assert.assertEquals((String)iASTStandardFunctionDeclarator.getNestedDeclarator().getName().toString(), (String)"pfi");
    }

    public void testBug95484() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X { public: int bar; };   \n");
        stringBuffer.append("void f(){                       \n");
        stringBuffer.append("   X a[10];                     \n");
        stringBuffer.append("   a[0].bar;                    \n");
        stringBuffer.append("}                               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(1).resolveBinding();
        Assert.assertSame((Object)iCPPField, (Object)cPPNameCollector.getName(6).resolveBinding());
    }

    public void testBug95419() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int strcmp( const char * );          \n");
        stringBuffer.append("void f( const char * const * argv ){ \n");
        stringBuffer.append("   strcmp( *argv );                  \n");
        stringBuffer.append("}                                    \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(0).resolveBinding();
        Assert.assertSame((Object)iCPPFunction, (Object)cPPNameCollector.getName(4).resolveBinding());
    }

    public void testBug95673() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class Other;                            \n");
        stringBuffer.append("class Base {                            \n");
        stringBuffer.append("   public: Base( Other * );             \n");
        stringBuffer.append("};                                      \n");
        stringBuffer.append("class Sub : public Base {               \n");
        stringBuffer.append("   public: Sub( Other * );              \n");
        stringBuffer.append("};                                      \n");
        stringBuffer.append("Sub::Sub( Other * b ) : Base(b) {}      \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPConstructor iCPPConstructor = (ICPPConstructor)cPPNameCollector.getName(2).resolveBinding();
        Assert.assertSame((Object)iCPPConstructor, (Object)cPPNameCollector.getName(15).resolveBinding());
    }

    public void testBug95768() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void mem( void *, const void * );                       \n");
        stringBuffer.append("void f() {                                              \n");
        stringBuffer.append("   char *x;  int offset;                                \n");
        stringBuffer.append("   mem( x, \"FUNC\" );                                  \n");
        stringBuffer.append("   mem( x + offset, \"FUNC2\" );                        \n");
        stringBuffer.append("}                                                       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(0).resolveBinding();
        Assert.assertSame((Object)iCPPFunction, (Object)cPPNameCollector.getName(6).resolveBinding());
        Assert.assertSame((Object)iCPPFunction, (Object)cPPNameCollector.getName(8).resolveBinding());
    }

    public void testBug95741() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void trace( const void * );                     \n");
        stringBuffer.append("class Foo {                                     \n");
        stringBuffer.append("   public: int import();                        \n");
        stringBuffer.append("};                                              \n");
        stringBuffer.append("int Foo::import(){                              \n");
        stringBuffer.append("   trace( this );                               \n");
        stringBuffer.append("}                                               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(0).resolveBinding();
        Assert.assertSame((Object)iCPPFunction, (Object)cPPNameCollector.getName(7).resolveBinding());
    }

    public void testBug95692() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class RTCharacter {                        \n");
        stringBuffer.append("   char value;                             \n");
        stringBuffer.append("   public: operator char (void) const;     \n");
        stringBuffer.append("};                                         \n");
        stringBuffer.append("RTCharacter::operator char( void )const {  \n");
        stringBuffer.append("   return value;                           \n");
        stringBuffer.append("}                                          \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(2).resolveBinding();
        Assert.assertSame((Object)iCPPMethod, (Object)cPPNameCollector.getName(6).resolveBinding());
    }

    public void testBug95734() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int str( const char * );               \n");
        stringBuffer.append("void f(){                              \n");
        stringBuffer.append("   str( 0 );                           \n");
        stringBuffer.append("   str( 00 );  str( 0x0 );             \n");
        stringBuffer.append("}                                      \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(0).resolveBinding();
        Assert.assertSame((Object)iCPPFunction, (Object)cPPNameCollector.getName(3).resolveBinding());
        Assert.assertSame((Object)iCPPFunction, (Object)cPPNameCollector.getName(4).resolveBinding());
        Assert.assertSame((Object)iCPPFunction, (Object)cPPNameCollector.getName(5).resolveBinding());
    }

    public void testBug95734_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int str( bool );                       \n");
        stringBuffer.append("enum { ONE };                          \n");
        stringBuffer.append("void f( char * p ){                    \n");
        stringBuffer.append("   str( 1.2 );                         \n");
        stringBuffer.append("   str( ONE );  str( p );              \n");
        stringBuffer.append("}                                      \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(0).resolveBinding();
        Assert.assertSame((Object)iCPPFunction, (Object)cPPNameCollector.getName(6).resolveBinding());
        Assert.assertSame((Object)iCPPFunction, (Object)cPPNameCollector.getName(7).resolveBinding());
        Assert.assertSame((Object)iCPPFunction, (Object)cPPNameCollector.getName(9).resolveBinding());
    }

    public void testBug95786() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f() {\n");
        stringBuffer.append("char * value;\n");
        stringBuffer.append("::operator delete(value);\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertFalse((boolean)(cPPNameCollector.getName(2).resolveBinding() instanceof IProblemBinding));
    }

    public void testBug86868() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo()\n");
        stringBuffer.append("try\n");
        stringBuffer.append("{\n");
        stringBuffer.append("// function body\n");
        stringBuffer.append("}\n");
        stringBuffer.append("catch (...)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        Assert.assertEquals((int)iASTTranslationUnit.getDeclarations().length, (int)1);
    }

    public void testBug94779() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f( int t ){\n");
        stringBuffer.append("int s ( t );\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        IASTDeclarationStatement iASTDeclarationStatement = (IASTDeclarationStatement)((IASTCompoundStatement)((IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0]).getBody()).getStatements()[0];
        IASTDeclarator iASTDeclarator = ((IASTSimpleDeclaration)iASTDeclarationStatement.getDeclaration()).getDeclarators()[0];
        Assert.assertTrue((boolean)(iASTDeclarator.getName().resolveBinding() instanceof IVariable));
    }

    public void testBug95714() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef struct xs {           \n");
        stringBuffer.append("   int state;                 \n");
        stringBuffer.append("} xs;                         \n");
        stringBuffer.append("void f( xs *ci ) {            \n");
        stringBuffer.append("   ci->state;                 \n");
        stringBuffer.append("   (ci - 1)->state;           \n");
        stringBuffer.append("}                             \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(1).resolveBinding();
        Assert.assertSame((Object)iCPPField, (Object)cPPNameCollector.getName(7).resolveBinding());
        Assert.assertSame((Object)iCPPField, (Object)cPPNameCollector.getName(9).resolveBinding());
    }

    public void testBug95757() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("float _Complex x;\n");
        stringBuffer.append("double _Complex y;\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, true);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        Assert.assertTrue((boolean)((IGPPASTSimpleDeclSpecifier)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclSpecifier()).isComplex());
        Assert.assertEquals((int)((IGPPASTSimpleDeclSpecifier)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclSpecifier()).getType(), (int)4);
        Assert.assertTrue((boolean)((IGPPASTSimpleDeclSpecifier)((IASTSimpleDeclaration)iASTDeclarationArray[1]).getDeclSpecifier()).isComplex());
        Assert.assertEquals((int)((IGPPASTSimpleDeclSpecifier)((IASTSimpleDeclaration)iASTDeclarationArray[1]).getDeclSpecifier()).getType(), (int)5);
    }

    public void testTypedefQualified() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class _A {                         \n");
        stringBuffer.append("   static int i;                   \n");
        stringBuffer.append("};                                 \n");
        stringBuffer.append("typedef _A A;                      \n");
        stringBuffer.append("void f(){                          \n");
        stringBuffer.append("   A::i++;                         \n");
        stringBuffer.append("}                                  \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(1).resolveBinding();
        Assert.assertSame((Object)iCPPField, (Object)cPPNameCollector.getName(7).resolveBinding());
    }

    public void testBug86849() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("    return 5;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("int main() {\n");
        stringBuffer.append("int a( 5 );\n");
        stringBuffer.append("int b( f() );\n");
        stringBuffer.append("return a+b;\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        this.assertNoProblemBindings(cPPNameCollector);
    }

    public void testBug96655() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void copy( void * );                   \n");
        stringBuffer.append("typedef struct {} A;                   \n");
        stringBuffer.append("void f( A * a ) {                      \n");
        stringBuffer.append("   copy( a );                          \n");
        stringBuffer.append("}                                      \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(0).resolveBinding();
        Assert.assertSame((Object)iCPPFunction, (Object)cPPNameCollector.getName(7).resolveBinding());
    }

    public void testBug96678() throws Exception {
        this.parse("int x; // comment \r\n", ParserLanguage.CPP, false, true);
    }

    public void testNewExpressionType() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {};                      \n");
        stringBuffer.append("void copy( A * );                 \n");
        stringBuffer.append("void f( ) {                       \n");
        stringBuffer.append("   copy( new A() );               \n");
        stringBuffer.append("}                                 \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPFunction iCPPFunction = (ICPPFunction)cPPNameCollector.getName(1).resolveBinding();
        Assert.assertSame((Object)iCPPFunction, (Object)cPPNameCollector.getName(5).resolveBinding());
    }

    public void testDefaultConstructor() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {                        \n");
        stringBuffer.append("   A( int i = 0 );               \n");
        stringBuffer.append("};                               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPConstructor iCPPConstructor = (ICPPConstructor)cPPNameCollector.getName(1).resolveBinding();
        ICPPConstructor[] iCPPConstructorArray = iCPPClassType.getConstructors();
        Assert.assertTrue((iCPPConstructorArray.length == 2 ? 1 : 0) != 0);
        Assert.assertSame((Object)iCPPConstructorArray[1], (Object)iCPPConstructor);
    }

    public void testBug91707() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class C { public: int foo; };                 \n");
        stringBuffer.append("class B {                                     \n");
        stringBuffer.append("   C* operator ->();                          \n");
        stringBuffer.append("   C& operator [] ( int );                    \n");
        stringBuffer.append("};                                            \n");
        stringBuffer.append("void f(){                                     \n");
        stringBuffer.append("   B b;                                       \n");
        stringBuffer.append("   b->foo;                                    \n");
        stringBuffer.append("   b[0].foo;                                  \n");
        stringBuffer.append("}                                             \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(1).resolveBinding();
        Assert.assertSame((Object)iCPPField, (Object)cPPNameCollector.getName(12).resolveBinding());
        Assert.assertSame((Object)iCPPField, (Object)cPPNameCollector.getName(14).resolveBinding());
    }

    public void testBug92425() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A;                    \n");
        stringBuffer.append("class A {                   \n");
        stringBuffer.append("   class B;                 \n");
        stringBuffer.append("   class C {};              \n");
        stringBuffer.append("};                          \n");
        stringBuffer.append("class A::B{};               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        ICPPClassType iCPPClassType2 = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        ICPPClassType iCPPClassType3 = (ICPPClassType)cPPNameCollector.getName(3).resolveBinding();
        ICPPClassType[] iCPPClassTypeArray = iCPPClassType.getNestedClasses();
        Assert.assertEquals((int)iCPPClassTypeArray.length, (int)2);
        Assert.assertSame((Object)iCPPClassTypeArray[0], (Object)iCPPClassType2);
        Assert.assertSame((Object)iCPPClassTypeArray[1], (Object)iCPPClassType3);
    }

    public void testBug92425_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {                                  \n");
        stringBuffer.append("   struct F {} f;                              \n");
        stringBuffer.append("   void f( int a) {}                           \n");
        stringBuffer.append("}                                              \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        IBinding[] iBindingArray = iCPPNamespace.getMemberBindings();
        Assert.assertEquals((int)iBindingArray.length, (int)3);
        Assert.assertSame((Object)iBindingArray[0], (Object)cPPNameCollector.getName(1).resolveBinding());
        Assert.assertSame((Object)iBindingArray[1], (Object)cPPNameCollector.getName(2).resolveBinding());
        Assert.assertSame((Object)iBindingArray[2], (Object)cPPNameCollector.getName(3).resolveBinding());
    }

    public void testBug98704() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("A< B< C< D< E< F< G< H<int> > > > > > > > a;  \n");
        stringBuffer.append("int A::B<int>::* b;                           \n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP);
    }

    public void testBug_AIOOBE() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f();          \n");
        stringBuffer.append("void f( void ) {}  \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        Assert.assertSame((Object)iFunction, (Object)cPPNameCollector.getName(1).resolveBinding());
        IParameter iParameter = (IParameter)cPPNameCollector.getName(2).resolveBinding();
        Assert.assertNotNull((Object)iParameter);
    }

    public void testRankingQualificationConversions() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f( const int );     \n");
        stringBuffer.append("void f( int );           \n");
        stringBuffer.append("void g() { f(1); }       \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertSame((Object)cPPNameCollector.getName(2).resolveBinding(), (Object)cPPNameCollector.getName(5).resolveBinding());
        stringBuffer = new StringBuffer();
        stringBuffer.append("void f( const volatile int );     \n");
        stringBuffer.append("void f( const int );              \n");
        stringBuffer.append("void g() { f(1); }                \n");
        iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        Assert.assertSame((Object)cPPNameCollector.getName(2).resolveBinding(), (Object)cPPNameCollector.getName(5).resolveBinding());
    }

    public void testBug98818() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace n {                   \n");
        stringBuffer.append("   namespace m {                \n");
        stringBuffer.append("      class A;                  \n");
        stringBuffer.append("   }                            \n");
        stringBuffer.append("}                               \n");
        stringBuffer.append("namespace n {                   \n");
        stringBuffer.append("   namespace m {                \n");
        stringBuffer.append("      class A { void f(); };    \n");
        stringBuffer.append("   }                            \n");
        stringBuffer.append("}                               \n");
        stringBuffer.append("namespace n {                   \n");
        stringBuffer.append("   namespace m {                \n");
        stringBuffer.append("      void A::f(){}             \n");
        stringBuffer.append("   }                            \n");
        stringBuffer.append("}                               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPNamespace iCPPNamespace = (ICPPNamespace)cPPNameCollector.getName(0).resolveBinding();
        ICPPNamespace iCPPNamespace2 = (ICPPNamespace)cPPNameCollector.getName(1).resolveBinding();
        Assert.assertSame((Object)iCPPNamespace, (Object)cPPNameCollector.getName(3).resolveBinding());
        Assert.assertSame((Object)iCPPNamespace, (Object)cPPNameCollector.getName(7).resolveBinding());
        Assert.assertSame((Object)iCPPNamespace2, (Object)cPPNameCollector.getName(4).resolveBinding());
        Assert.assertSame((Object)iCPPNamespace2, (Object)cPPNameCollector.getName(8).resolveBinding());
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(2).resolveBinding();
        Assert.assertSame((Object)iCPPClassType, (Object)cPPNameCollector.getName(5).resolveBinding());
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(9).resolveBinding();
        Assert.assertSame((Object)iCPPMethod, (Object)cPPNameCollector.getName(11).resolveBinding());
    }

    public void testAnonymousStructures() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {               \n");
        stringBuffer.append("   struct { int i; } B;  \n");
        stringBuffer.append("   struct { int j; } C;  \n");
        stringBuffer.append("};                       \n");
        stringBuffer.append("void f(){                \n");
        stringBuffer.append("   A a;                  \n");
        stringBuffer.append("   a.B.i; a.C.j;         \n");
        stringBuffer.append("}                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(12).resolveBinding();
        ICPPField iCPPField2 = (ICPPField)cPPNameCollector.getName(15).resolveBinding();
        Assert.assertSame((Object)iCPPField, (Object)cPPNameCollector.getName(2).resolveBinding());
        Assert.assertSame((Object)iCPPField2, (Object)cPPNameCollector.getName(5).resolveBinding());
    }

    public void testBug99262() throws Exception {
        this.parse("void foo() {void *f; f=__null;}", ParserLanguage.CPP, true, true);
    }

    public void testBug99262B() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo2(void *) {\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("int foo3() {\n");
        stringBuffer.append("return foo2(__null);\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, true);
        Assert.assertTrue((boolean)(((IASTIdExpression)((IASTFunctionCallExpression)((IASTReturnStatement)((IASTCompoundStatement)((IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[1]).getBody()).getStatements()[0]).getReturnValue()).getFunctionNameExpression()).getName().resolveBinding() instanceof IFunction));
    }

    public void testBug100408() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int foo() { int x=1; (x)*3; }", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        this.assertNoProblemBindings(cPPNameCollector);
    }

    public void testBug84478_3() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("void foo() { switch( int x = 4 ) { case 4: x++; break; default: break;} }", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        this.assertNoProblemBindings(cPPNameCollector);
        Assert.assertSame((Object)cPPNameCollector.getName(1).resolveBinding(), (Object)cPPNameCollector.getName(2).resolveBinding());
    }

    public void testBug84478_4() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("void foo() { for( int i = 0; int j = 0; ++i) {} }", ParserLanguage.CPP);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        this.assertNoProblemBindings(cPPNameCollector);
    }

    public void testBug84478_2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f(){                          \n");
        stringBuffer.append("   if( int x = 1 )  x++;           \n");
        stringBuffer.append("   else             x--;           \n");
        stringBuffer.append("   while( int y = 2 )              \n");
        stringBuffer.append("      y++;                         \n");
        stringBuffer.append("   for( int a = 1; int b = 2; b++){ \n");
        stringBuffer.append("      a++; b++;                    \n");
        stringBuffer.append("   }                               \n");
        stringBuffer.append("}                                  \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, true);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        this.assertNoProblemBindings(cPPNameCollector);
        IVariable iVariable = (IVariable)cPPNameCollector.getName(1).resolveBinding();
        Assert.assertSame((Object)iVariable, (Object)cPPNameCollector.getName(2).resolveBinding());
        Assert.assertSame((Object)iVariable, (Object)cPPNameCollector.getName(3).resolveBinding());
        IVariable iVariable2 = (IVariable)cPPNameCollector.getName(4).resolveBinding();
        Assert.assertSame((Object)iVariable2, (Object)cPPNameCollector.getName(5).resolveBinding());
        IVariable iVariable3 = (IVariable)cPPNameCollector.getName(6).resolveBinding();
        IVariable iVariable4 = (IVariable)cPPNameCollector.getName(7).resolveBinding();
        Assert.assertSame((Object)iVariable4, (Object)cPPNameCollector.getName(8).resolveBinding());
        Assert.assertSame((Object)iVariable3, (Object)cPPNameCollector.getName(9).resolveBinding());
        Assert.assertSame((Object)iVariable4, (Object)cPPNameCollector.getName(10).resolveBinding());
    }

    public void testBug100415() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void free( void * );         \n");
        stringBuffer.append("void f( char **p ){          \n");
        stringBuffer.append("   free( p );                \n");
        stringBuffer.append("}                            \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, true);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IFunction iFunction = (IFunction)cPPNameCollector.getName(0).resolveBinding();
        Assert.assertSame((Object)iFunction, (Object)cPPNameCollector.getName(4).resolveBinding());
    }

    public void testBug86688() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X;                 \n");
        stringBuffer.append("void f() {               \n");
        stringBuffer.append("   class A {             \n");
        stringBuffer.append("      friend class X;    \n");
        stringBuffer.append("   };                    \n");
        stringBuffer.append("}                        \n");
        stringBuffer.append("namespace B {            \n");
        stringBuffer.append("   class A {             \n");
        stringBuffer.append("      friend class X;    \n");
        stringBuffer.append("   };                    \n");
        stringBuffer.append("}                        \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, true);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPClassType iCPPClassType = (ICPPClassType)cPPNameCollector.getName(0).resolveBinding();
        Assert.assertNotSame((Object)iCPPClassType, (Object)cPPNameCollector.getName(3).resolveBinding());
        Assert.assertTrue((boolean)(cPPNameCollector.getName(3).resolveBinding() instanceof ICPPClassType));
        Assert.assertSame((Object)iCPPClassType, (Object)cPPNameCollector.getName(6).resolveBinding());
    }

    public void testBug100403() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class m {                  \n");
        stringBuffer.append("   int m::f();             \n");
        stringBuffer.append("};                         \n");
        stringBuffer.append("int m::f(){}               \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, true);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(3).resolveBinding();
        Assert.assertSame((Object)iCPPMethod, (Object)cPPNameCollector.getName(6).resolveBinding());
    }

    public void testBug90609() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {                      \n");
        stringBuffer.append("   typedef int AT;              \n");
        stringBuffer.append("   void f1(AT);                 \n");
        stringBuffer.append("   void f2(float);              \n");
        stringBuffer.append("};                              \n");
        stringBuffer.append("struct B {                      \n");
        stringBuffer.append("   typedef float BT;            \n");
        stringBuffer.append("   friend void A::f1(AT);       \n");
        stringBuffer.append("   friend void A::f2(BT);       \n");
        stringBuffer.append("};                              \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, true);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ITypedef iTypedef = (ITypedef)cPPNameCollector.getName(1).resolveBinding();
        ICPPMethod iCPPMethod = (ICPPMethod)cPPNameCollector.getName(2).resolveBinding();
        ICPPMethod iCPPMethod2 = (ICPPMethod)cPPNameCollector.getName(5).resolveBinding();
        ITypedef iTypedef2 = (ITypedef)cPPNameCollector.getName(8).resolveBinding();
        Assert.assertSame((Object)iCPPMethod, (Object)cPPNameCollector.getName(11).resolveBinding());
        Assert.assertSame((Object)iTypedef, (Object)cPPNameCollector.getName(12).resolveBinding());
        Assert.assertSame((Object)iCPPMethod2, (Object)cPPNameCollector.getName(16).resolveBinding());
        Assert.assertSame((Object)iTypedef2, (Object)cPPNameCollector.getName(17).resolveBinding());
    }

    public void testBug103281() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct Except { int blah; };       \n");
        stringBuffer.append("void f() {                         \n");
        stringBuffer.append("   try { }                         \n");
        stringBuffer.append("   catch ( Except * e ) {          \n");
        stringBuffer.append("      e->blah;                     \n");
        stringBuffer.append("   }                               \n");
        stringBuffer.append("}                                  \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, true);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        IField iField = (IField)cPPNameCollector.getName(1).resolveBinding();
        IVariable iVariable = (IVariable)cPPNameCollector.getName(4).resolveBinding();
        Assert.assertSame((Object)iVariable, (Object)cPPNameCollector.getName(5).resolveBinding());
        Assert.assertSame((Object)iField, (Object)cPPNameCollector.getName(6).resolveBinding());
    }

    public void testBug80171() throws Exception {
        this.parseAndCheckBindings("static var;");
    }

    public void testBug78800() throws Exception {
        this.parseAndCheckBindings("class Matrix {  public: Matrix & operator *(Matrix &); }; Matrix rotate, translate; Matrix transform = rotate * translate;");
    }

    public void test10_2s3b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct U { static int i; };      \n");
        stringBuffer.append("struct V : U { };                \n");
        stringBuffer.append("struct W : U { using U::i; };    \n");
        stringBuffer.append("struct X : V, W { void foo(); }; \n");
        stringBuffer.append("void X::foo() {                  \n");
        stringBuffer.append("   i;                            \n");
        stringBuffer.append("}                                \n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, true);
        AST2BaseTest.CPPNameCollector cPPNameCollector = new AST2BaseTest.CPPNameCollector();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameCollector);
        ICPPField iCPPField = (ICPPField)cPPNameCollector.getName(1).resolveBinding();
        ICPPUsingDeclaration iCPPUsingDeclaration = (ICPPUsingDeclaration)cPPNameCollector.getName(6).resolveBinding();
        ICPPDelegate[] iCPPDelegateArray = iCPPUsingDeclaration.getDelegates();
        Assert.assertEquals((int)iCPPDelegateArray.length, (int)1);
        Assert.assertSame((Object)iCPPField, (Object)iCPPDelegateArray[0].getBinding());
        Assert.assertSame((Object)iCPPField, (Object)cPPNameCollector.getName(16).resolveBinding());
    }

    public void test1043290() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("int f() { ");
        stringBuffer.append("int x = 4;  while( x < 10 ) blah: ++x; ");
        stringBuffer.append("}");
        IASTTranslationUnit iASTTranslationUnit = this.parseAndCheckBindings(stringBuffer.toString());
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0];
        IASTStatement[] iASTStatementArray = ((IASTCompoundStatement)iASTFunctionDefinition.getBody()).getStatements();
        IASTWhileStatement iASTWhileStatement = (IASTWhileStatement)iASTStatementArray[1];
        IASTLabelStatement iASTLabelStatement = (IASTLabelStatement)iASTWhileStatement.getBody();
        Assert.assertTrue((boolean)(iASTLabelStatement.getNestedStatement() instanceof IASTExpressionStatement));
        IASTExpressionStatement iASTExpressionStatement = (IASTExpressionStatement)iASTLabelStatement.getNestedStatement();
        Assert.assertTrue((boolean)(iASTExpressionStatement.getExpression() instanceof IASTUnaryExpression));
    }

    public void testBug104800() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("int f() { \n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("do { ++i; } while( i < 10 );\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parseAndCheckBindings(stringBuffer.toString());
        IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTTranslationUnit.getDeclarations()[0];
        IASTCompoundStatement iASTCompoundStatement = (IASTCompoundStatement)iASTFunctionDefinition.getBody();
        Assert.assertEquals((int)iASTCompoundStatement.getStatements().length, (int)3);
    }

    public void testBug107150() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define FUNC_PROTOTYPE_PARAMS(list)    list\r\n");
        stringBuffer.append("int func1 FUNC_PROTOTYPE_PARAMS((int arg1)){\r\n");
        stringBuffer.append("return 0;\r\n");
        stringBuffer.append("}\r\n");
        stringBuffer.append("int func2 FUNC_PROTOTYPE_PARAMS\r\n");
        stringBuffer.append("((int arg1)){\r\n");
        stringBuffer.append("return 0;\r\n");
        stringBuffer.append("}\r\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        Assert.assertFalse((boolean)(iASTTranslationUnit.getDeclarations()[1] instanceof IASTProblemDeclaration));
        stringBuffer = new StringBuffer();
        stringBuffer.append("#define FUNC_PROTOTYPE_PARAMS(list)    list\n");
        stringBuffer.append("int func1 FUNC_PROTOTYPE_PARAMS((int arg1)){\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("int func2 FUNC_PROTOTYPE_PARAMS\n");
        stringBuffer.append("((int arg1)){\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("}\n");
        iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.CPP);
        Assert.assertFalse((boolean)(iASTTranslationUnit.getDeclarations()[1] instanceof IASTProblemDeclaration));
    }

    public void testBug108202() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class __attribute__((visibility(\"default\"))) FooClass\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int foo();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int FooClass::foo() {\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, true);
    }
}

