/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Assert;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICASTPointer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.AST2SelectionParseBaseTest;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.core.resources.IFile;

public class AST2SelectionParseTest
extends AST2SelectionParseBaseTest {
    static /* synthetic */ Class class$0;

    public AST2SelectionParseTest(String string) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.parser.tests.ast2.AST2SelectionParseTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(string, clazz);
    }

    public void testBaseCase_VariableReference() throws Exception {
        String string = "void f() { int x; x=3; }";
        int n = string.indexOf("x=");
        int n2 = "x".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTIdExpression));
        Assert.assertEquals((String)((IASTIdExpression)iASTNode).getName().toString(), (String)"x");
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTIdExpression));
        Assert.assertEquals((String)((IASTIdExpression)iASTNode).getName().toString(), (String)"x");
        IASTName iASTName = ((IASTIdExpression)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IVariable));
        Assert.assertEquals((String)((IVariable)iASTName.resolveBinding()).getName(), (String)"x");
    }

    public void testBaseCase_FunctionReference() throws Exception {
        String string = "int x(){x( );}";
        int n = string.indexOf("x( ");
        int n2 = "x".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTIdExpression));
        Assert.assertEquals((String)((IASTIdExpression)iASTNode).getName().toString(), (String)"x");
        IASTName iASTName = ((IASTIdExpression)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IFunction)iASTName.resolveBinding()).getName(), (String)"x");
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTIdExpression));
        Assert.assertEquals((String)((IASTIdExpression)iASTNode).getName().toString(), (String)"x");
        iASTName = ((IASTIdExpression)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IFunction)iASTName.resolveBinding()).getName(), (String)"x");
    }

    public void testBaseCase_Error() throws Exception {
        String string = "int x() { y( ) }";
        int n = string.indexOf("y( ");
        int n2 = "y".length();
        Assert.assertNull((Object)this.parse(string, ParserLanguage.C, n, n2, false));
        Assert.assertNull((Object)this.parse(string, ParserLanguage.CPP, n, n2, false));
    }

    public void testBaseCase_FunctionDeclaration() throws Exception {
        String string = "int x(); x( );";
        int n = string.indexOf("x()");
        int n2 = "x".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"x");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IFunction)iASTName.resolveBinding()).getName(), (String)"x");
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"x");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IFunction)iASTName.resolveBinding()).getName(), (String)"x");
    }

    public void testBaseCase_FunctionDeclaration2() throws Exception {
        String string = "int printf( const char *, ... ); ";
        int n = string.indexOf("printf");
        int n2 = "printf".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"printf");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IFunction)iASTName.resolveBinding()).getName(), (String)"printf");
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"printf");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IFunction)iASTName.resolveBinding()).getName(), (String)"printf");
    }

    public void testBaseCase_VariableDeclaration() throws Exception {
        String string = "int x = 3;";
        int n = string.indexOf("x");
        int n2 = "x".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"x");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IVariable));
        Assert.assertEquals((String)((IVariable)iASTName.resolveBinding()).getName(), (String)"x");
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"x");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IVariable));
        Assert.assertEquals((String)((IVariable)iASTName.resolveBinding()).getName(), (String)"x");
    }

    public void testBaseCase_Parameter() throws Exception {
        String string = "int main( int argc ) { int x = argc; }";
        int n = string.indexOf("argc;");
        int n2 = "argc".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTInitializerExpression));
        Assert.assertEquals((String)((IASTIdExpression)((IASTInitializerExpression)iASTNode).getExpression()).getName().toString(), (String)"argc");
        IASTName iASTName = ((IASTIdExpression)((IASTInitializerExpression)iASTNode).getExpression()).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IParameter));
        Assert.assertEquals((String)((IParameter)iASTName.resolveBinding()).getName(), (String)"argc");
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTInitializerExpression));
        Assert.assertEquals((String)((IASTIdExpression)((IASTInitializerExpression)iASTNode).getExpression()).getName().toString(), (String)"argc");
        iASTName = ((IASTIdExpression)((IASTInitializerExpression)iASTNode).getExpression()).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IParameter));
        Assert.assertEquals((String)((IParameter)iASTName.resolveBinding()).getName(), (String)"argc");
    }

    public void testBug57898() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Gonzo {  public: void playHorn(); };\n");
        ((Writer)stringWriter).write("void Gonzo::playHorn() { return; }\n");
        ((Writer)stringWriter).write("int\tmain(int argc, char **argv) { Gonzo gonzo; gonzo.playHorn(); }\n");
        String string = ((Object)stringWriter).toString();
        int n = 0;
        while (n < 3) {
            int n2 = -1;
            int n3 = -1;
            switch (n) {
                case 0: {
                    n2 = string.indexOf("void playHorn") + 5;
                    break;
                }
                case 1: {
                    n2 = string.indexOf("::playHorn") + 2;
                    break;
                }
                case 2: {
                    n2 = string.indexOf(".playHorn") + 1;
                }
            }
            n3 = 8;
            IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, n2, n3);
            Assert.assertNotNull((Object)iASTNode);
            Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
            Assert.assertEquals((String)iASTNode.toString(), (String)"playHorn");
            IASTName iASTName = (IASTName)iASTNode;
            Assert.assertNotNull((Object)iASTName.resolveBinding());
            Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPMethod));
            Assert.assertEquals((String)((ICPPMethod)iASTName.resolveBinding()).getName(), (String)"playHorn");
            ++n;
        }
    }

    public void testConstructorDestructorDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Gonzo { Gonzo(); ~Gonzo(); };");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf(" Gonzo()") + 1;
        int n2 = "Gonzo".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"Gonzo");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPConstructor));
        Assert.assertEquals((String)((ICPPConstructor)iASTName.resolveBinding()).getName(), (String)"Gonzo");
        n = string.indexOf(" ~Gonzo") + 1;
        n2 = "~Gonzo".length();
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"~Gonzo");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPMethod));
        Assert.assertEquals((String)((ICPPMethod)iASTName.resolveBinding()).getName(), (String)"~Gonzo");
    }

    public void testBug60264() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace Muppets { int i;\t}\n");
        ((Writer)stringWriter).write("int\tmain(int argc, char **argv) {\tMuppets::i = 1; }\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("Muppets::");
        int n2 = "Muppets".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"Muppets");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPNamespace));
        Assert.assertEquals((String)((ICPPNamespace)iASTName.resolveBinding()).getName(), (String)"Muppets");
        n = string.indexOf("e Muppets") + 2;
        n2 = "Muppets".length();
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"Muppets");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPNamespace));
        Assert.assertEquals((String)((ICPPNamespace)iASTName.resolveBinding()).getName(), (String)"Muppets");
    }

    public void testBug61613() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Foo {  // ** (A) **\n");
        ((Writer)stringWriter).write("\tpublic:\n");
        ((Writer)stringWriter).write("Foo() {};\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("int \n");
        ((Writer)stringWriter).write("main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("Foo foo;  // ** (B) **\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("class Foo") + 6;
        int n2 = "Foo".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"Foo");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPClassType));
        Assert.assertEquals((String)((ICPPClassType)iASTName.resolveBinding()).getName(), (String)"Foo");
    }

    public void testBug60038() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Gonzo {\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("Gonzo( const Gonzo & other ){}\n");
        ((Writer)stringWriter).write("Gonzo()\t{}\n");
        ((Writer)stringWriter).write("~Gonzo(){}\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("int main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write(" Gonzo * g = new Gonzo();\n");
        ((Writer)stringWriter).write(" Gonzo * g2 = new Gonzo( *g );\n");
        ((Writer)stringWriter).write(" g->~Gonzo();\n");
        ((Writer)stringWriter).write(" return (int) g2;\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            int n3 = 0;
            switch (n) {
                case 0: {
                    n2 = string.indexOf("new Gonzo()") + 4;
                    n3 = 5;
                    break;
                }
                case 1: {
                    n2 = string.indexOf("new Gonzo( ") + 4;
                    n3 = 5;
                    break;
                }
                default: {
                    n2 = string.indexOf("->~") + 2;
                    n3 = 6;
                }
            }
            IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, n2, n3);
            Assert.assertNotNull((Object)iASTNode);
            IASTName iASTName = null;
            switch (n) {
                case 0: 
                case 1: {
                    Assert.assertTrue((boolean)(iASTNode instanceof IASTTypeId));
                    Assert.assertEquals((String)((IASTNamedTypeSpecifier)((IASTTypeId)iASTNode).getDeclSpecifier()).getName().toString(), (String)"Gonzo");
                    iASTName = ((IASTNamedTypeSpecifier)((IASTTypeId)iASTNode).getDeclSpecifier()).getName();
                    Assert.assertNotNull((Object)iASTName.resolveBinding());
                    Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPConstructor));
                    Assert.assertEquals((String)((ICPPConstructor)iASTName.resolveBinding()).getName(), (String)"Gonzo");
                    break;
                }
                default: {
                    Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
                    Assert.assertEquals((String)iASTNode.toString(), (String)"~Gonzo");
                    iASTName = (IASTName)iASTNode;
                    Assert.assertNotNull((Object)iASTName.resolveBinding());
                    Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPMethod));
                    Assert.assertEquals((String)((ICPPMethod)iASTName.resolveBinding()).getName(), (String)"~Gonzo");
                }
            }
            ++n;
        }
    }

    public void testMethodReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Sample { public:\n");
        ((Writer)stringWriter).write("  int getAnswer() const;\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("int main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write(" Sample * s = new Sample();\n");
        ((Writer)stringWriter).write(" return s->getAnswer();\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("->getAnswer") + 2;
        int n2 = "getAnswer".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"getAnswer");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPMethod));
        Assert.assertEquals((String)((ICPPMethod)iASTName.resolveBinding()).getName(), (String)"getAnswer");
    }

    public void testConstructorDefinition() throws Exception {
        String string = "class ABC { public: ABC(); }; ABC::ABC(){}";
        int n = string.indexOf("::ABC") + 2;
        int n2 = "ABC".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertEquals((String)iASTNode.toString(), (String)"ABC");
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPConstructor));
        Assert.assertEquals((String)((ICPPConstructor)iASTName.resolveBinding()).getName(), (String)"ABC");
    }

    public void testBug63966() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void foo(int a) {}\n");
        ((Writer)stringWriter).write("void foo(long a) {}\n");
        ((Writer)stringWriter).write("int main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("foo(1); \n }");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("foo(1)");
        int n2 = "foo".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTIdExpression));
        Assert.assertEquals((String)((IASTIdExpression)iASTNode).getName().toString(), (String)"foo");
        IASTName iASTName = ((IASTIdExpression)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IFunction)iASTName.resolveBinding()).getName(), (String)"foo");
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTIdExpression));
        Assert.assertEquals((String)((IASTIdExpression)iASTNode).getName().toString(), (String)"foo");
        iASTName = ((IASTIdExpression)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IFunction)iASTName.resolveBinding()).getName(), (String)"foo");
    }

    public void testBug66744() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("enum EColours { RED, GREEN, BLUE };      \n");
        ((Writer)stringWriter).write("void foo() {  EColours color = GREEN; }  \n");
        StringWriter stringWriter2 = new StringWriter();
        ((Writer)stringWriter2).write("enum EColours { RED, GREEN, BLUE };      \n");
        ((Writer)stringWriter2).write("void foo() { enum EColours color = GREEN; }  \n");
        String string = ((Object)stringWriter).toString();
        String string2 = ((Object)stringWriter2).toString();
        int n = string2.indexOf("EColours color");
        int n2 = "EColours".length();
        IASTNode iASTNode = this.parse(string2, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"EColours");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IEnumeration));
        Assert.assertEquals((String)((IEnumeration)iASTName.resolveBinding()).getName(), (String)"EColours");
        n = string.indexOf("EColours color");
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTNamedTypeSpecifier));
        Assert.assertEquals((String)((IASTNamedTypeSpecifier)iASTNode).getName().toString(), (String)"EColours");
        iASTName = ((IASTNamedTypeSpecifier)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IEnumeration));
        Assert.assertEquals((String)((IEnumeration)iASTName.resolveBinding()).getName(), (String)"EColours");
    }

    public void testBug68527() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct X;\n");
        ((Writer)stringWriter).write("struct X anA;");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("X anA");
        int n2 = "X".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"X");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICompositeType));
        Assert.assertEquals((String)((ICompositeType)iASTName.resolveBinding()).getName(), (String)"X");
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"X");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICompositeType));
        Assert.assertEquals((String)((ICompositeType)iASTName.resolveBinding()).getName(), (String)"X");
    }

    public void testBug60407() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct ZZZ { int x, y, z; };\n");
        ((Writer)stringWriter).write("typedef struct ZZZ _FILE;\n");
        ((Writer)stringWriter).write("typedef _FILE FILE;\n");
        ((Writer)stringWriter).write("static void static_function(FILE * lcd){}\n");
        ((Writer)stringWriter).write("int\tmain(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("FILE * file = 0;\n");
        ((Writer)stringWriter).write("static_function( file );\n");
        ((Writer)stringWriter).write("return 0;\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("static_function( file )");
        int n2 = "static_function".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTIdExpression));
        Assert.assertEquals((String)((IASTIdExpression)iASTNode).getName().toString(), (String)"static_function");
        IASTName iASTName = ((IASTIdExpression)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IFunction)iASTName.resolveBinding()).getName(), (String)"static_function");
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTIdExpression));
        Assert.assertEquals((String)((IASTIdExpression)iASTNode).getName().toString(), (String)"static_function");
        iASTName = ((IASTIdExpression)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IFunction)iASTName.resolveBinding()).getName(), (String)"static_function");
    }

    public void testBug61800() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class B {};\n");
        ((Writer)stringWriter).write("class ABCDEF {\n");
        ((Writer)stringWriter).write(" static B stInt; };\n");
        ((Writer)stringWriter).write("B ABCDEF::stInt = 5;\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("::stInt") + 2;
        int n2 = "stInt".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"stInt");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((ICPPField)iASTName.resolveBinding()).getName(), (String)"stInt");
    }

    public void testBug68739() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int fprintf( int *, const char *, ... );               \n");
        ((Writer)stringWriter).write("void boo( int * lcd ) {                                \n");
        ((Writer)stringWriter).write("  /**/fprintf( lcd, \"%c%s 0x%x\", ' ', \"bbb\", 2 );  \n");
        ((Writer)stringWriter).write("}                                                      \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("/**/fprintf") + 4;
        int n2 = "fprintf".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTIdExpression));
        Assert.assertEquals((String)((IASTIdExpression)iASTNode).getName().toString(), (String)"fprintf");
        IASTName iASTName = ((IASTIdExpression)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IFunction)iASTName.resolveBinding()).getName(), (String)"fprintf");
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTIdExpression));
        Assert.assertEquals((String)((IASTIdExpression)iASTNode).getName().toString(), (String)"fprintf");
        iASTName = ((IASTIdExpression)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IFunction)iASTName.resolveBinding()).getName(), (String)"fprintf");
    }

    public void testBug72818() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("union Squaw\t{\tint x;\tdouble u; };\n");
        ((Writer)stringWriter).write("int\tmain(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("return sizeof( Squaw );\n");
        ((Writer)stringWriter).write("}\n");
        StringWriter stringWriter2 = new StringWriter();
        ((Writer)stringWriter2).write("union Squaw\t{\tint x;\tdouble u; };\n");
        ((Writer)stringWriter2).write("int\tmain(int argc, char **argv) {\n");
        ((Writer)stringWriter2).write("return sizeof( union Squaw );\n");
        ((Writer)stringWriter2).write("}\n");
        String string = ((Object)stringWriter2).toString();
        String string2 = ((Object)stringWriter).toString();
        int n = string.indexOf("sizeof( union ") + "sizeof( union ".length();
        int n2 = "Squaw".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"Squaw");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICompositeType));
        Assert.assertEquals((String)((ICompositeType)iASTName.resolveBinding()).getName(), (String)"Squaw");
        n = string2.indexOf("sizeof( ") + "sizeof( ".length();
        iASTNode = this.parse(string2, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTTypeId));
        Assert.assertEquals((String)((IASTNamedTypeSpecifier)((IASTTypeId)iASTNode).getDeclSpecifier()).getName().toString(), (String)"Squaw");
        iASTName = ((IASTNamedTypeSpecifier)((IASTTypeId)iASTNode).getDeclSpecifier()).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPClassType));
        Assert.assertEquals((String)((ICPPClassType)iASTName.resolveBinding()).getName(), (String)"Squaw");
    }

    public void test72220() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("const int FOUND_ME = 1;\n");
        ((Writer)stringWriter).write("class Test{\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("const int findCode() const;\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("const int Test::findCode() const {\n");
        ((Writer)stringWriter).write("return FOUND_ME;\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("return ") + "return ".length();
        int n2 = "FOUND_ME".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTIdExpression));
        Assert.assertEquals((String)((IASTIdExpression)iASTNode).getName().toString(), (String)"FOUND_ME");
        IASTName iASTName = ((IASTIdExpression)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IVariable));
        Assert.assertEquals((String)((IVariable)iASTName.resolveBinding()).getName(), (String)"FOUND_ME");
    }

    public void testBug72721() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" class ABC { public: ABC(int); };   \n");
        ((Writer)stringWriter).write("void f() {                          \n");
        ((Writer)stringWriter).write("   int j = 1;                       \n");
        ((Writer)stringWriter).write("   new ABC( j + 1 );                \n");
        ((Writer)stringWriter).write("}                                   \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("ABC(");
        int n2 = "ABC".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"ABC");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPConstructor));
        Assert.assertEquals((String)((ICPPConstructor)iASTName.resolveBinding()).getName(), (String)"ABC");
    }

    public void testBug72372() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace B {                                   \n");
        ((Writer)stringWriter).write("   class SD_02 { void f_SD(); };                \n");
        ((Writer)stringWriter).write("}                                               \n");
        ((Writer)stringWriter).write("using namespace B;                              \n");
        ((Writer)stringWriter).write("void SD_02::f_SD(){}                            \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf(":f_SD") + 1;
        int n2 = "f_SD".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"f_SD");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPMethod));
        Assert.assertEquals((String)((ICPPMethod)iASTName.resolveBinding()).getName(), (String)"f_SD");
    }

    public void testBug72372_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace A {                                   \n");
        ((Writer)stringWriter).write("   namespace B {                                \n");
        ((Writer)stringWriter).write("      void f_SD();                              \n");
        ((Writer)stringWriter).write("   }                                            \n");
        ((Writer)stringWriter).write("}                                               \n");
        ((Writer)stringWriter).write("namespace C {                                   \n");
        ((Writer)stringWriter).write("   using namespace A;                           \n");
        ((Writer)stringWriter).write("}                                               \n");
        ((Writer)stringWriter).write("void C::B::f_SD(){}                             \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf(":f_SD") + 1;
        int n2 = "f_SD".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"f_SD");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IFunction)iASTName.resolveBinding()).getName(), (String)"f_SD");
    }

    public void testBug72713() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Deck{ void initialize(); };   \n");
        ((Writer)stringWriter).write("void Deck::initialize(){}           \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf(":initialize") + 1;
        int n2 = "initialize".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"initialize");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPMethod));
        Assert.assertEquals((String)((ICPPMethod)iASTName.resolveBinding()).getName(), (String)"initialize");
    }

    public void testBug72712() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class B{ public: B(); }; void f(){ B* b; b = new B(); }");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("new B") + 4;
        int n2 = "B".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTTypeId));
        Assert.assertEquals((String)((IASTNamedTypeSpecifier)((IASTTypeId)iASTNode).getDeclSpecifier()).getName().toString(), (String)"B");
        IASTName iASTName = ((IASTNamedTypeSpecifier)((IASTTypeId)iASTNode).getDeclSpecifier()).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPConstructor));
        Assert.assertEquals((String)((ICPPConstructor)iASTName.resolveBinding()).getName(), (String)"B");
    }

    public void testBug72712_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A {};                                        \n");
        ((Writer)stringWriter).write("class B{ public: B( A* ); };                       \n");
        ((Writer)stringWriter).write("void f(){ B* b; b = new B( (A*)0 ); }              \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("(A*)") + 1;
        int n2 = "A".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTNamedTypeSpecifier));
        Assert.assertEquals((String)((IASTNamedTypeSpecifier)iASTNode).getName().toString(), (String)"A");
        IASTName iASTName = ((IASTNamedTypeSpecifier)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPClassType));
        Assert.assertEquals((String)((ICPPClassType)iASTName.resolveBinding()).getName(), (String)"A");
    }

    public void testBug72710() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Card{\n");
        ((Writer)stringWriter).write("\tCard( int rank );\n");
        ((Writer)stringWriter).write(" int rank;\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("Card::Card( int rank ) {\n");
        ((Writer)stringWriter).write("this->rank = rank;\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("this->rank") + 6;
        int n2 = "rank".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"rank");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((ICPPField)iASTName.resolveBinding()).getName(), (String)"rank");
    }

    public void testBug75731() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int rank() {\n");
        ((Writer)stringWriter).write("return 5;\n}\n");
        ((Writer)stringWriter).write("class Card{\n");
        ((Writer)stringWriter).write("private:\n");
        ((Writer)stringWriter).write("Card( int rank );\n");
        ((Writer)stringWriter).write("int rank;\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("int getRank();\n};\n");
        ((Writer)stringWriter).write("Card::Card( int rank )\n{\n");
        ((Writer)stringWriter).write("this->rank = ::rank();\n");
        ((Writer)stringWriter).write("this->rank = this->rank;\n");
        ((Writer)stringWriter).write("this->rank = rank;\n");
        ((Writer)stringWriter).write("this->rank = Card::rank;\n");
        ((Writer)stringWriter).write("this->rank = getRank();\n}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("int rank() {") + 4;
        int n2 = "rank".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"rank");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IFunction)iASTName.resolveBinding()).getName(), (String)"rank");
        n = string.indexOf("class Card{") + 6;
        n2 = "Card".length();
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"Card");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPClassType));
        Assert.assertEquals((String)((ICPPClassType)iASTName.resolveBinding()).getName(), (String)"Card");
        n = string.indexOf("Card( int rank );");
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"Card");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPConstructor));
        Assert.assertEquals((String)((ICPPConstructor)iASTName.resolveBinding()).getName(), (String)"Card");
        n = string.indexOf("Card( int rank );") + 10;
        n2 = "rank".length();
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTDeclarator));
        Assert.assertEquals((String)((IASTDeclarator)iASTNode).getName().toString(), (String)"rank");
        iASTName = ((IASTDeclarator)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IVariable));
        Assert.assertEquals((String)((IVariable)iASTName.resolveBinding()).getName(), (String)"rank");
        n = string.indexOf("int rank;") + 4;
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTDeclarator));
        Assert.assertEquals((String)((IASTDeclarator)iASTNode).getName().toString(), (String)"rank");
        iASTName = ((IASTDeclarator)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((ICPPField)iASTName.resolveBinding()).getName(), (String)"rank");
        n = string.indexOf("int getRank();") + 4;
        n2 = "getRank".length();
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"getRank");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPMethod));
        Assert.assertEquals((String)((ICPPMethod)iASTName.resolveBinding()).getName(), (String)"getRank");
        n = string.indexOf("Card::Card( int rank )");
        n2 = "Card".length();
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"Card");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPClassType));
        Assert.assertEquals((String)((ICPPClassType)iASTName.resolveBinding()).getName(), (String)"Card");
        n = string.indexOf("Card::Card( int rank )") + 6;
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"Card");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPConstructor));
        Assert.assertEquals((String)((ICPPConstructor)iASTName.resolveBinding()).getName(), (String)"Card");
        n = string.indexOf("Card::Card( int rank )") + 16;
        n2 = "rank".length();
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTDeclarator));
        Assert.assertEquals((String)((IASTDeclarator)iASTNode).getName().toString(), (String)"rank");
        iASTName = ((IASTDeclarator)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IVariable));
        Assert.assertEquals((String)((IVariable)iASTName.resolveBinding()).getName(), (String)"rank");
        n = string.indexOf("this->rank = ::rank();") + 6;
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"rank");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((ICPPField)iASTName.resolveBinding()).getName(), (String)"rank");
        n = string.indexOf("this->rank = ::rank();") + 15;
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"rank");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IFunction));
        Assert.assertEquals((String)((IFunction)iASTName.resolveBinding()).getName(), (String)"rank");
        n = string.indexOf("this->rank = this->rank;") + 6;
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"rank");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((ICPPField)iASTName.resolveBinding()).getName(), (String)"rank");
        n = string.indexOf("this->rank = this->rank;") + 19;
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"rank");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((ICPPField)iASTName.resolveBinding()).getName(), (String)"rank");
        n = string.indexOf("this->rank = rank;") + 6;
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"rank");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((ICPPField)iASTName.resolveBinding()).getName(), (String)"rank");
        n = string.indexOf("this->rank = rank;") + 13;
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTIdExpression));
        Assert.assertEquals((String)((IASTIdExpression)iASTNode).getName().toString(), (String)"rank");
        iASTName = ((IASTIdExpression)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IVariable));
        Assert.assertEquals((String)((IVariable)iASTName.resolveBinding()).getName(), (String)"rank");
        n = string.indexOf("this->rank = Card::rank;") + 6;
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"rank");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((ICPPField)iASTName.resolveBinding()).getName(), (String)"rank");
        n = string.indexOf("this->rank = Card::rank;") + 19;
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"rank");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((ICPPField)iASTName.resolveBinding()).getName(), (String)"rank");
        n = string.indexOf("this->rank = getRank();") + 6;
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"rank");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPField));
        Assert.assertEquals((String)((ICPPField)iASTName.resolveBinding()).getName(), (String)"rank");
        n = string.indexOf("this->rank = getRank();") + 13;
        n2 = "getRank".length();
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTIdExpression));
        Assert.assertEquals((String)((IASTIdExpression)iASTNode).getName().toString(), (String)"getRank");
        iASTName = ((IASTIdExpression)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPMethod));
        Assert.assertEquals((String)((ICPPMethod)iASTName.resolveBinding()).getName(), (String)"getRank");
    }

    public void testBug77989() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N {        /* A */\n");
        ((Writer)stringWriter).write("class C{};\n}\n");
        ((Writer)stringWriter).write("using namespace N;   /* B */\n");
        ((Writer)stringWriter).write("N::C c;              /* C */\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("using namespace N;") + 16;
        int n2 = "N".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"N");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICPPNamespace));
        Assert.assertEquals((String)((ICPPNamespace)iASTName.resolveBinding()).getName(), (String)"N");
    }

    public void testBug78435() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int itself;          //A\n");
        ((Writer)stringWriter).write("void f(int itself){} //B\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("void f(int itself){}") + 11;
        int n2 = "itself".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTDeclarator));
        Assert.assertEquals((String)((IASTDeclarator)iASTNode).getName().toString(), (String)"itself");
        IASTName iASTName = ((IASTDeclarator)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IVariable));
        Assert.assertEquals((String)((IVariable)iASTName.resolveBinding()).getName(), (String)"itself");
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTDeclarator));
        Assert.assertEquals((String)((IASTDeclarator)iASTNode).getName().toString(), (String)"itself");
        iASTName = ((IASTDeclarator)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IVariable));
        Assert.assertEquals((String)((IVariable)iASTName.resolveBinding()).getName(), (String)"itself");
    }

    public void testBug78231A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct Base {\n");
        ((Writer)stringWriter).write("int Data; // 1\n");
        ((Writer)stringWriter).write("struct Data; // 2\n};\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("struct Data;") + 7;
        int n2 = "Data".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"Data");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICompositeType));
        Assert.assertEquals((String)((ICompositeType)iASTName.resolveBinding()).getName(), (String)"Data");
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"Data");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICompositeType));
        Assert.assertEquals((String)((ICompositeType)iASTName.resolveBinding()).getName(), (String)"Data");
    }

    public void testBug78231B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int Data;\n");
        ((Writer)stringWriter).write("struct Base {\n");
        ((Writer)stringWriter).write("int Data; // 1\n");
        ((Writer)stringWriter).write("struct Data; // 2\n};\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("struct Data;") + 7;
        int n2 = "Data".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"Data");
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICompositeType));
        Assert.assertEquals((String)((ICompositeType)iASTName.resolveBinding()).getName(), (String)"Data");
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)iASTNode.toString(), (String)"Data");
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ICompositeType));
        Assert.assertEquals((String)((ICompositeType)iASTName.resolveBinding()).getName(), (String)"Data");
    }

    public void testSimpleKRCTest1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f(char x);\n");
        stringBuffer.append("int f(x) char x;\n");
        stringBuffer.append("{ return x == 0; }\n");
        String string = stringBuffer.toString();
        int n = string.indexOf("x;");
        int n2 = "x".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, true, true, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTDeclarator));
        Assert.assertEquals((String)((IASTDeclarator)iASTNode).getName().toString(), (String)"x");
        IASTName iASTName = ((IASTDeclarator)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IParameter));
        Assert.assertEquals((String)((IParameter)iASTName.resolveBinding()).getName(), (String)"x");
    }

    public void testSimpleKRCTest2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f();\n");
        stringBuffer.append("int f(x) char x;\n");
        stringBuffer.append("{ return x == 0; }\n");
        String string = stringBuffer.toString();
        int n = string.indexOf("x;");
        int n2 = "x".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, true, true, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTDeclarator));
        Assert.assertEquals((String)((IASTDeclarator)iASTNode).getName().toString(), (String)"x");
        IASTName iASTName = ((IASTDeclarator)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IParameter));
        Assert.assertEquals((String)((IParameter)iASTName.resolveBinding()).getName(), (String)"x");
    }

    public void testSimpleKRCTest3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int const *f();\n");
        stringBuffer.append("int const *f(x) char x;\n");
        stringBuffer.append("{ return x == 0; }\n");
        String string = stringBuffer.toString();
        int n = string.indexOf("char x;");
        int n2 = "char x;".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, true, true, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTSimpleDeclaration));
        Assert.assertEquals((String)((IASTSimpleDeclaration)iASTNode).getDeclarators()[0].getName().toString(), (String)"x");
        IASTName iASTName = ((IASTSimpleDeclaration)iASTNode).getDeclarators()[0].getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IParameter));
        Assert.assertEquals((String)((IParameter)iASTName.resolveBinding()).getName(), (String)"x");
    }

    public void testKRC_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int isroot (x, y) /* comment */ \n");
        stringBuffer.append("int x;\n");
        stringBuffer.append("int y;\n");
        stringBuffer.append("{ return x == 0; }\n");
        String string = stringBuffer.toString();
        int n = string.indexOf("y;");
        int n2 = "y".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, true, true, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTDeclarator));
        Assert.assertEquals((String)((IASTDeclarator)iASTNode).getName().toString(), (String)"y");
        IASTName iASTName = ((IASTDeclarator)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IParameter));
        Assert.assertEquals((String)((IParameter)iASTName.resolveBinding()).getName(), (String)"y");
    }

    public void testKRCWithTypes() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef char c;\n");
        stringBuffer.append("int isroot (c);\n");
        stringBuffer.append("int isroot (x) \n");
        stringBuffer.append("c x;\n");
        stringBuffer.append("{ return x == 0; }\n");
        String string = stringBuffer.toString();
        int n = string.indexOf("c x;");
        int n2 = "c".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, true, true, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTNamedTypeSpecifier));
        Assert.assertEquals((String)((IASTNamedTypeSpecifier)iASTNode).getName().toString(), (String)"c");
        IASTName iASTName = ((IASTNamedTypeSpecifier)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof ITypedef));
        Assert.assertEquals((String)((ITypedef)iASTName.resolveBinding()).getName(), (String)"c");
        n = string.indexOf("x;");
        n2 = "x".length();
        iASTNode = this.parse(string, ParserLanguage.C, true, true, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTDeclarator));
        Assert.assertEquals((String)((IASTDeclarator)iASTNode).getName().toString(), (String)"x");
        iASTName = ((IASTDeclarator)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IParameter));
        Assert.assertEquals((String)((IParameter)iASTName.resolveBinding()).getName(), (String)"x");
    }

    public void testKRC_monop_cards1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#ifdef __STDC__\n");
        stringBuffer.append("#define __P(x) x\n");
        stringBuffer.append("#else\n");
        stringBuffer.append("#define __P(x) ()\n");
        stringBuffer.append("#endif\n");
        stringBuffer.append("struct A_struct {\n");
        stringBuffer.append("int a;\n");
        stringBuffer.append("long *c;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("typedef struct A_struct A;\n");
        stringBuffer.append("static void f __P((A *));\n");
        stringBuffer.append("static void\n");
        stringBuffer.append("f(x)\n");
        stringBuffer.append("A *x; {\n");
        stringBuffer.append("x->a = 0;\n");
        stringBuffer.append("x->c[1]=x->c[2];\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        int n = string.indexOf("*c;");
        int n2 = "*".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof ICASTPointer));
        n = string.indexOf("*c;") + 1;
        n2 = "c".length();
        iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IField));
        Assert.assertEquals((String)((IField)iASTName.resolveBinding()).getName(), (String)"c");
        n = string.indexOf("c[2]");
        n2 = "c".length();
        iASTNode = this.parse(string, ParserLanguage.C, true, true, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IField));
        Assert.assertEquals((String)((IField)iASTName.resolveBinding()).getName(), (String)"c");
    }

    public void testKRC_monop_cards2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int\n");
        stringBuffer.append("getinp(prompt, list)\n");
        stringBuffer.append("        const char *prompt, *const list[];\n");
        stringBuffer.append("{\n\t*list[1] = 'a';\n}\n");
        String string = stringBuffer.toString();
        int n = string.indexOf("list[]");
        int n2 = "list".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, true, true, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertEquals((String)iASTName.toString(), (String)"list");
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IParameter));
        Assert.assertEquals((String)((IParameter)iASTName.resolveBinding()).getName(), (String)"list");
        n = string.indexOf("[]");
        n2 = "[]".length();
        iASTNode = this.parse(string, ParserLanguage.C, true, true, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTArrayModifier));
        n = string.indexOf("*const list[]");
        n2 = "*const".length();
        iASTNode = this.parse(string, ParserLanguage.C, true, true, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTPointer));
    }

    public void testKRC_getParametersOrder() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f(a, b) int b,a;{}\n");
        String string = stringBuffer.toString();
        int n = string.indexOf("b,a");
        int n2 = "b".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, true, true, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTDeclarator));
        IASTName iASTName = ((IASTDeclarator)iASTNode).getName();
        Assert.assertEquals((String)iASTName.toString(), (String)"b");
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IParameter));
        Assert.assertEquals((String)((IParameter)iASTName.resolveBinding()).getName(), (String)"b");
    }

    public void testKRC_Ethereal_1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct symbol {\n");
        stringBuffer.append("int lambda;\n};\n");
        stringBuffer.append("struct lemon {\n");
        stringBuffer.append("struct symbol **symbols;\n");
        stringBuffer.append("int errorcnt;\n};\n");
        stringBuffer.append("void f(lemp)\n");
        stringBuffer.append("struct lemon *lemp;\n{\n");
        stringBuffer.append("lemp->symbols[1]->lambda = 1;\n");
        stringBuffer.append("lemp->errorcnt++;}\n");
        String string = stringBuffer.toString();
        int n = string.indexOf("**symbols");
        int n2 = "*".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTPointer));
        n = string.indexOf("**symbols") + 1;
        n2 = "*".length();
        iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTPointer));
        n = string.indexOf("**symbols") + 2;
        n2 = "symbols".length();
        iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IField));
        Assert.assertEquals((String)((IField)iASTName.resolveBinding()).getName(), (String)"symbols");
        n = string.indexOf("lemp->symbols") + 6;
        n2 = "symbols".length();
        iASTNode = this.parse(string, ParserLanguage.C, true, true, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IField));
        Assert.assertEquals((String)((IField)iASTName.resolveBinding()).getName(), (String)"symbols");
    }

    public void testBug86698() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct C;\n");
        stringBuffer.append("void no_opt(C*);\n");
        stringBuffer.append("struct C {\n");
        stringBuffer.append("int c;\n");
        stringBuffer.append("C() : c(0) { no_opt(this); }\n");
        stringBuffer.append("};\n");
        String string = stringBuffer.toString();
        int n = string.indexOf("c(0)");
        int n2 = "c".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        IASTName iASTName = (IASTName)iASTNode;
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IField));
        Assert.assertEquals((String)((IField)iASTName.resolveBinding()).getName(), (String)"c");
    }

    public void testLittleThings() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int a[3];\r\n");
        stringBuffer.append("int *b;\r\n");
        stringBuffer.append("int &c;\r\n");
        stringBuffer.append("char d='e';\r\n");
        String string = stringBuffer.toString();
        int n = 0;
        int n2 = 0;
        IASTNode iASTNode = null;
        ParserLanguage parserLanguage = null;
        int n3 = 0;
        while (n3 < 2) {
            parserLanguage = n3 == 0 ? ParserLanguage.C : ParserLanguage.CPP;
            n = string.indexOf("[3]");
            n2 = "[3]".length();
            iASTNode = this.parse(string, parserLanguage, n, n2);
            Assert.assertNotNull((Object)iASTNode);
            n = string.indexOf("3");
            n2 = "3".length();
            iASTNode = this.parse(string, parserLanguage, n, n2);
            Assert.assertNotNull((Object)iASTNode);
            n = string.indexOf("*");
            n2 = "*".length();
            iASTNode = this.parse(string, parserLanguage, n, n2);
            Assert.assertNotNull((Object)iASTNode);
            if (parserLanguage != ParserLanguage.C) {
                n = string.indexOf("&");
                n2 = "&".length();
                iASTNode = this.parse(string, parserLanguage, n, n2);
                Assert.assertNotNull((Object)iASTNode);
                n = string.indexOf("&c");
                n2 = "&c".length();
                iASTNode = this.parse(string, parserLanguage, n, n2);
                Assert.assertNotNull((Object)iASTNode);
            }
            n = string.indexOf("int a");
            n2 = "int".length();
            iASTNode = this.parse(string, parserLanguage, n, n2);
            Assert.assertNotNull((Object)iASTNode);
            n = string.indexOf("int a[3];");
            n2 = "int a[3];".length();
            iASTNode = this.parse(string, parserLanguage, n, n2);
            Assert.assertNotNull((Object)iASTNode);
            n = string.indexOf("a[3]");
            n2 = "a[3]".length();
            iASTNode = this.parse(string, parserLanguage, n, n2);
            Assert.assertNotNull((Object)iASTNode);
            n = string.indexOf("*b");
            n2 = "*b".length();
            iASTNode = this.parse(string, parserLanguage, n, n2);
            Assert.assertNotNull((Object)iASTNode);
            n = string.indexOf("'e'");
            n2 = "'e'".length();
            iASTNode = this.parse(string, parserLanguage, n, n2);
            Assert.assertNotNull((Object)iASTNode);
            ++n3;
        }
    }

    public void testSimpleWindowsPreprocessorSelections() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define ONE 1\r\n");
        stringBuffer.append("#ifdef ONE\r\n");
        stringBuffer.append("int x=0;\r\n");
        stringBuffer.append("#else\r\n");
        stringBuffer.append("char c='c';\r\n");
        stringBuffer.append("#endif\r\n");
        String string = stringBuffer.toString();
        int n = 0;
        int n2 = 0;
        IASTNode iASTNode = null;
        ParserLanguage parserLanguage = null;
        int n3 = 0;
        while (n3 < 2) {
            parserLanguage = n3 == 0 ? ParserLanguage.C : ParserLanguage.CPP;
            n = string.indexOf("#define ONE 1");
            n2 = "#define ONE 1".length();
            iASTNode = this.parse(string, parserLanguage, n, n2);
            Assert.assertNotNull((Object)iASTNode);
            n = string.indexOf("int x=0;");
            n2 = "int x=0;".length();
            iASTNode = this.parse(string, parserLanguage, n, n2);
            Assert.assertNotNull((Object)iASTNode);
            n = string.indexOf("#else");
            n2 = "#else".length();
            iASTNode = this.parse(string, parserLanguage, n, n2);
            Assert.assertNotNull((Object)iASTNode);
            n = string.indexOf("#endif");
            n2 = "#endif".length();
            iASTNode = this.parse(string, parserLanguage, n, n2);
            Assert.assertNotNull((Object)iASTNode);
            ++n3;
        }
    }

    public void testBug86993() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define _BEGIN_STD_C extern \"C\" {\r\n");
        stringBuffer.append("#define _END_STD_C  }\r\n");
        stringBuffer.append("_BEGIN_STD_C\r\n");
        stringBuffer.append("char c;\r\n");
        stringBuffer.append("_END_STD_C\r\n");
        String string = stringBuffer.toString();
        int n = 0;
        int n2 = 0;
        IASTNode iASTNode = null;
        n = string.indexOf("c;");
        n2 = "c".length();
        iASTNode = this.parse(string, ParserLanguage.CPP, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTDeclarator));
        Assert.assertEquals((String)((IASTDeclarator)iASTNode).getName().toString(), (String)"c");
        IASTName iASTName = ((IASTDeclarator)iASTNode).getName();
        Assert.assertNotNull((Object)iASTName.resolveBinding());
        Assert.assertTrue((boolean)(iASTName.resolveBinding() instanceof IVariable));
    }

    public void testBug86870() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#if VERSION == 1\r\n");
        stringBuffer.append("#define INCFILE \"vers1.h\"\r\n");
        stringBuffer.append("#elif VERSION == 2\r\n");
        stringBuffer.append("#define INCFILE \"vers2.h\" /* and so on */\r\n");
        stringBuffer.append("#else\r\n");
        stringBuffer.append("#define INCFILE \"versN.h\"\r\n");
        stringBuffer.append("#endif\r\n");
        String string = stringBuffer.toString();
        int n = string.indexOf("#if VERSION == 1");
        int n2 = "#if VERSION == 1".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)n2);
        n = string.indexOf("#elif VERSION == 2");
        n2 = "#elif VERSION == 2".length();
        iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)n2);
        n = string.indexOf("#else");
        n2 = "#else".length();
        iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)n2);
        n = string.indexOf("#define INCFILE \"versN.h\"");
        n2 = "#define INCFILE \"versN.h\"".length();
        iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)n2);
        n = string.indexOf("INCFILE \"versN.h\"");
        n2 = "INCFILE".length();
        iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)n2);
        n = string.indexOf("#endif");
        n2 = "#endif".length();
        iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)n2);
    }

    public void testBug87179() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define ONE 1\r\n");
        stringBuffer.append("#ifdef ONE\r\n");
        stringBuffer.append("int x=0;\r\n");
        stringBuffer.append("#else\r\n");
        stringBuffer.append("char c='c';\r\n");
        stringBuffer.append("#endif\r\n");
        String string = stringBuffer.toString();
        int n = string.indexOf("#ifdef ONE");
        int n2 = "#ifdef ONE".length();
        IASTNode iASTNode = this.parse(string, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
    }

    public void testBug96702() throws Exception {
        this.importFile("test.h", "int x;\n");
        String string = "#include \"test.h\"   // comment \nvoid f();   // comment \n";
        int n = string.indexOf("f()");
        IFile iFile = this.importFile("blah.c", string);
        IASTNode iASTNode = this.parse(iFile, ParserLanguage.C, n, 1);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)44);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
    }

    public void testBug97301() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#ifndef _WINGDI_H\r\n");
        stringBuffer.append("#define _WINGDI_H\r\n");
        stringBuffer.append("#define _WINGDI_\r\n");
        stringBuffer.append("#if __GNUC__ >= 3\r\n");
        stringBuffer.append("#pragma GCC system_header\r\n");
        stringBuffer.append("#endif\r\n");
        stringBuffer.append("#ifdef __cplusplus\r\n");
        stringBuffer.append("extern \"C\" {\r\n");
        stringBuffer.append("#endif\r\n");
        stringBuffer.append("#define WINGDIAPI\r\n");
        stringBuffer.append("#ifdef __cplusplus\r\n");
        stringBuffer.append("}\r\n");
        stringBuffer.append("#endif\r\n");
        String string = stringBuffer.toString();
        this.importFile("test2.h", string);
        stringBuffer = new StringBuffer();
        stringBuffer.append("#ifdef RC_INVOKED\r\n");
        stringBuffer.append("#else\r\n");
        stringBuffer.append("#if !(defined NOGDI || defined  _WINGDI_H)\r\n");
        stringBuffer.append("#include \"test2.h\"\r\n");
        stringBuffer.append("#endif\r\n");
        stringBuffer.append("#endif\r\n");
        this.importFile("test1.h", stringBuffer.toString());
        IFile iFile = this.importFile("test.c", "#include \"test1.h\"");
        IASTTranslationUnit iASTTranslationUnit = this.parse(iFile, ParserLanguage.CPP, false, true);
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = iASTTranslationUnit.getAllPreprocessorStatements();
        IASTFileLocation iASTFileLocation = iASTPreprocessorStatementArray[5].getFileLocation();
        int n = string.indexOf("#ifndef _WINGDI_H");
        int n2 = iASTFileLocation.getNodeOffset();
        Assert.assertEquals((int)n, (int)n2);
    }

    public void testBug86126() throws Exception {
        this.importFile("foo.h", "int x;\r\n");
        String string = "#include \"foo.h\"\r\n";
        IFile iFile = this.importFile("blah.c", string);
        int n = string.indexOf("#include \"foo.h\"");
        int n2 = "#include \"foo.h\"".length();
        IASTNode iASTNode = this.parse(iFile, ParserLanguage.C, n, n2);
        Assert.assertNotNull((Object)iASTNode);
    }

    public void testBug98806() throws Exception {
        String string = "template <class T> class A { typedef typename T::B _B;};";
        IASTNode iASTNode = this.parse(string, ParserLanguage.CPP, string.indexOf("T::B"), "T::B".length());
        Assert.assertNotNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
    }
}

