/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.AST2BaseTest;

public class AST2UtilOldTests
extends AST2BaseTest {
    public void testPrimaryEmpty() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = f();".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "f()");
    }

    public void testPrimaryIntegerLiteral() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = f(1, 2+3);".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "f(1, 2 + 3)");
    }

    public void testPrimaryCharLiteral() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = f('c');".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "f('c')");
    }

    public void testPrimaryFloatLiteral() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = f(1.13);".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "f(1.13)");
    }

    public void testPrimaryStringLiteral() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = f(\"str\");".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "f(\"str\")");
    }

    public void testPrimaryBooleanLiteral() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = f(true);".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "f(true)");
    }

    public void testPrimaryThis() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = f(this);".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "f(this)");
    }

    public void testPrimaryBracketedExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = f(1, (2+3));".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "f(1, (2 + 3))");
    }

    public void testIdExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = f(a);".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "f(a)");
    }

    public void testPostfixSubscript() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = f(pa[1]);".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "f(pa[1])");
    }

    public void testPostfixSubscriptA() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = f(pa[1][2]);".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "f(pa[1][2])");
    }

    public void testPostfixFunctioncallBug42822() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = bar( foo( 3.0 ), foo( 5.0 ) ) ;".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "bar(foo(3.0), foo(5.0))");
    }

    public void testPostfixSimpletypesBug42823() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int someInt = foo( int(3), short(4), double(3.0), float(4.0), char( 'a'), wchar_t( 'a' ), signed( 2 ), unsigned( 3 ), bool( false ), long( 3L ) );".toString(), ParserLanguage.CPP);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(int(3), short(4), double(3.0), float(4.0), char('a'), wchar_t('a'), signed(2), unsigned(3), bool(false), long(3L))");
    }

    public void testPostfixDotExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A {int m;}; \n A  a; \n int foo(char); int foo( int ); \n int x = foo( a.m );".toString(), ParserLanguage.CPP);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[4]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a.m)");
    }

    public void testPostfixArrowExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A {int m;}; \n A * a; \n int foo(char); int foo( int ); \n int x = foo( a->m );".toString(), ParserLanguage.CPP);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[4]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a->m)");
    }

    public void testPostfixIncrement() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int y = foo( x++ );".toString(), ParserLanguage.CPP);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(x++)");
    }

    public void testPostfixDecrement() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int y = foo( x-- );".toString(), ParserLanguage.CPP);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(x--)");
    }

    public void testPostfixDynamicCast() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( dynamic_cast<B*>(a) );".toString(), ParserLanguage.CPP);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(dynamic_cast<B *>(a))");
    }

    public void testPostfixReinterpretCast() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( reinterpret_cast<double *>(a) );".toString(), ParserLanguage.CPP);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(reinterpret_cast<double *>(a))");
    }

    public void testPostfixStaticCast() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( static_cast<char>(a) );".toString(), ParserLanguage.CPP);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(static_cast<char>(a))");
    }

    public void testPostfixConstCast() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( const_cast<int *>(&a) );".toString(), ParserLanguage.CPP);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(const_cast<int *>(&a))");
    }

    public void testPostfixTypeIdExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( typeid(5) );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(typeid(5))");
    }

    public void testPostfixTypeIdExpression2() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( typeid(a) );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(typeid(a))");
    }

    public void testPostfixTypeIdTypeId2() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("class A { }; int foo( int ); int x = foo( typeid(const A) );".toString(), ParserLanguage.CPP);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[2]).getDeclarators()[0].getInitializer()).getExpression(), "foo(typeid (const A))");
    }

    public void testUnaryIncrement() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int y = foo( ++x );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(++x)");
    }

    public void testUnaryDecrement() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int y = foo( --x );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(--x)");
    }

    public void testUnaryStarCastExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = f(*pa);".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "f(*pa)");
    }

    public void testUnaryAmpersandCastExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = f(&pa);".toString(), ParserLanguage.CPP);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "f(&pa)");
    }

    public void testUnaryPlusCastExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( +5 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(+5)");
    }

    public void testUnaryMinusCastExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( -5 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(-5)");
    }

    public void testUnaryNotCastExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( !b );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(!b)");
    }

    public void testTildeNotCastExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int y = foo( ~x );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(~x)");
    }

    public void testUnarySizeofUnaryExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int y = foo( sizeof(5) );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(sizeof (5))");
    }

    public void testUnarySizeofTypeId() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x, y = foo( sizeof(x) );".toString(), ParserLanguage.CPP);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        IASTExpression iASTExpression = ((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[1].getInitializer()).getExpression();
        this.isExpressionStringEqual(iASTExpression, "foo(sizeof (x))");
    }

    public void testNewTypeId() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( new A() );".toString(), ParserLanguage.CPP);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(new A())");
    }

    public void testCastExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( (A*)b );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo((A *)b)");
    }

    public void testMultiplicativeMultiply() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a * b );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a * b)");
    }

    public void testMultiplicativeDivide() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( b / a );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(b / a)");
    }

    public void testMultiplicativeModulus() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( b % a );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(b % a)");
    }

    public void testAdditivePlus() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( b + a );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(b + a)");
    }

    public void testAdditiveMinus() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( b - a );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(b - a)");
    }

    public void testShiftLeft() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a << 5 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a << 5)");
    }

    public void testShiftRight() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a >> 5 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a >> 5)");
    }

    public void testRelationalLessThan() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( b < 3 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(b < 3)");
    }

    public void testRelationalGreaterThan() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( b > 3 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(b > 3)");
    }

    public void testRelationalLessThanOrEqual() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( b <= 3 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(b <= 3)");
    }

    public void testRelationalGreaterThanOrEqual() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( b >= 3 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(b >= 3)");
    }

    public void testEqualityEquals() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( b == 3 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(b == 3)");
    }

    public void testEqualityNotEquals() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( b != 3 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(b != 3)");
    }

    public void testAndExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a & b );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a & b)");
    }

    public void testExclusiveOrExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a ^ b );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a ^ b)");
    }

    public void testInclusiveOrExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a | b );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a | b)");
    }

    public void testLogicalAndExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a && b );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a && b)");
    }

    public void testLogicalOrExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a || b );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a || b)");
    }

    public void testConditionalExpression() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a > 5 ? b : c );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a > 5 ? b : c)");
    }

    public void testAssignmentExpressionNormal() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a = 5 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a = 5)");
    }

    public void testAssignmentExpressionPlus() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a += 5 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a += 5)");
    }

    public void testAssignmentExpressionMinus() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a -= 5 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a -= 5)");
    }

    public void testAssignmentExpressionMulti() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a *= 5 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a *= 5)");
    }

    public void testAssignmentExpressionDiv() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a /= 5 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a /= 5)");
    }

    public void testAssignmentExpressionMod() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a %= 5 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a %= 5)");
    }

    public void testAssignmentExpressionLShift() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a >>= 5 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a >>= 5)");
    }

    public void testAssignmentExpressionRShift() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a <<= 5 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a <<= 5)");
    }

    public void testAssignmentExpressionAnd() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a &= 5 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a &= 5)");
    }

    public void testAssignmentExpressionOr() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a |= 5 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a |= 5)");
    }

    public void testAssignmentExpressionXOr() throws Exception {
        IASTTranslationUnit iASTTranslationUnit = this.parse("int x = foo( a ^= 5 );".toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression(), "foo(a ^= 5)");
    }
}

