/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.dom.CDOM;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.CodeReaderCache;
import org.eclipse.cdt.core.parser.ICodeReaderCache;
import org.eclipse.cdt.core.parser.tests.ast2.CDOMBaseTest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CodeReaderCacheTest
extends CDOMBaseTest {
    static /* synthetic */ Class class$0;

    public CodeReaderCacheTest(String string) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.parser.tests.ast2.CodeReaderCacheTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(string, clazz);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.parser.tests.ast2.CodeReaderCacheTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite((Class)clazz);
        testSuite.addTest((Test)new CodeReaderCacheTest("cleanupProject"));
        return testSuite;
    }

    public void testSetCacheSize() {
        ICodeReaderCache iCodeReaderCache = CDOM.getInstance().getCodeReaderFactory(0).getCodeReaderCache();
        Assert.assertTrue((boolean)(iCodeReaderCache instanceof CodeReaderCache));
        ((CodeReaderCache)iCodeReaderCache).setCacheSize(64);
    }

    public void testSimpleCacheFunctionality() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x;");
        IFile iFile = null;
        try {
            iFile = this.importFile("test.c", stringBuffer.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.parse(iFile);
        ICodeReaderCache iCodeReaderCache = CDOM.getInstance().getCodeReaderFactory(0).getCodeReaderCache();
        iCodeReaderCache.flush();
        CodeReader codeReader = iCodeReaderCache.get(iFile.getLocation().toOSString());
        Assert.assertNotNull((Object)codeReader);
        Assert.assertEquals((int)iCodeReaderCache.getCurrentSpace(), (int)1);
        Assert.assertEquals((String)String.valueOf(codeReader.filename), (String)iFile.getLocation().toOSString());
        iCodeReaderCache.remove(String.valueOf(codeReader.filename));
        Assert.assertEquals((int)iCodeReaderCache.getCurrentSpace(), (int)0);
    }

    public void testResourceChangedUpdate() {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x;");
        ICodeReaderCache iCodeReaderCache = CDOM.getInstance().getCodeReaderFactory(0).getCodeReaderCache();
        IFile iFile = null;
        try {
            iFile = this.importFile("test.c", stringBuffer.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        UpdateFileJob updateFileJob = new UpdateFileJob("updater", iFile, "test.c", stringBuffer.toString());
        updateFileJob.schedule();
        while (!bl) {
            if (iFile != null) {
                this.parse(iFile);
            }
            try {
                Thread.sleep(1000L);
                iFile = updateFileJob.getFile();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (iCodeReaderCache.getCurrentSpace() != 0) continue;
            bl = true;
        }
        updateFileJob.cancel();
    }

    public void testResourceChangedNestedPathUpdate() {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x;");
        ICodeReaderCache iCodeReaderCache = CDOM.getInstance().getCodeReaderFactory(0).getCodeReaderCache();
        IFile iFile = null;
        try {
            this.importFolder("test");
            iFile = this.importFile("test/test.c", stringBuffer.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        UpdateFileJob updateFileJob = new UpdateFileJob("updater", iFile, "test/test.c", stringBuffer.toString());
        updateFileJob.schedule();
        while (!bl) {
            if (iFile != null) {
                this.parse(iFile);
            }
            try {
                Thread.sleep(1000L);
                iFile = updateFileJob.getFile();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (iCodeReaderCache.getCurrentSpace() != 0) continue;
            bl = true;
        }
        updateFileJob.cancel();
    }

    public void testClearCache() {
        ICodeReaderCache iCodeReaderCache = CDOM.getInstance().getCodeReaderFactory(0).getCodeReaderCache();
        Assert.assertTrue((boolean)(iCodeReaderCache instanceof CodeReaderCache));
        ((CodeReaderCache)iCodeReaderCache).setCacheSize(0);
    }

    private class UpdateFileJob
    extends Job {
        private IFile file = null;
        private String fileName = null;
        private String code = null;

        public UpdateFileJob(String string, IFile iFile, String string2, String string3) {
            super(string);
            this.file = iFile;
            this.fileName = string2;
            this.code = string3;
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            while (!iProgressMonitor.isCanceled()) {
                try {
                    this.file = CodeReaderCacheTest.this.importFile(this.fileName, this.code);
                }
                catch (Exception exception) {}
            }
            return Status.OK_STATUS;
        }

        public IFile getFile() {
            return this.file;
        }
    }
}

