/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Assert;
import org.eclipse.cdt.core.dom.ast.ASTSignatureUtil;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.c.ICASTPointer;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPASTPointer;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.AST2BaseTest;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunction;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class GCCCompleteParseExtensionsTest
extends AST2BaseTest {
    private IASTTranslationUnit parseGCC(String string) throws ParserException {
        IASTTranslationUnit iASTTranslationUnit = this.parse(string, ParserLanguage.C, true, true);
        AST2BaseTest.CNameResolver cNameResolver = new AST2BaseTest.CNameResolver();
        iASTTranslationUnit.accept((ASTVisitor)cNameResolver);
        if (cNameResolver.numProblemBindings > 0) {
            throw new ParserException(" there are " + cNameResolver.numProblemBindings + " ProblemBindings on the tu");
        }
        if (cNameResolver.numNullBindings > 0) {
            throw new ParserException("Expected no null bindings, encountered " + cNameResolver.numNullBindings);
        }
        return iASTTranslationUnit;
    }

    private IASTTranslationUnit parseGPP(String string) throws ParserException {
        IASTTranslationUnit iASTTranslationUnit = this.parse(string, ParserLanguage.CPP, true, true);
        AST2BaseTest.CPPNameResolver cPPNameResolver = new AST2BaseTest.CPPNameResolver();
        iASTTranslationUnit.accept((ASTVisitor)cPPNameResolver);
        if (cPPNameResolver.numProblemBindings > 0) {
            throw new ParserException(" there are " + cPPNameResolver.numProblemBindings + " ProblemBindings on the tu");
        }
        if (cPPNameResolver.numNullBindings > 0) {
            throw new ParserException("Expected no null bindings, encountered " + cPPNameResolver.numNullBindings);
        }
        return iASTTranslationUnit;
    }

    public void testBug39695() throws Exception {
        this.parseGCC("int a = __alignof__ (int);").getDeclarations();
    }

    public void testBug39684() throws Exception {
        IASTDeclaration iASTDeclaration = this.parseGCC("typeof(foo(1)) bar () { return foo(1); }").getDeclarations()[0];
        Assert.assertTrue((boolean)(iASTDeclaration instanceof CASTFunctionDefinition));
        CFunction cFunction = (CFunction)((CASTFunctionDefinition)iASTDeclaration).getDeclarator().getName().resolveBinding();
        cFunction.getType();
    }

    public void testBug39698A() throws Exception {
        IASTDeclaration[] iASTDeclarationArray = this.parseGPP("int a=0; \n int b=1; \n int c = a <? b;").getDeclarations();
        Assert.assertEquals((String)ASTSignatureUtil.getExpressionString((IASTExpression)((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[2]).getDeclarators()[0].getInitializer()).getExpression()), (String)"a <? b");
    }

    public void testBug39698B() throws Exception {
        IASTDeclaration[] iASTDeclarationArray = this.parseGPP("int a=0; \n int b=1; \n int c = a >? b;").getDeclarations();
        Assert.assertEquals((String)ASTSignatureUtil.getExpressionString((IASTExpression)((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[2]).getDeclarators()[0].getInitializer()).getExpression()), (String)"a >? b");
    }

    public void testPredefinedSymbol_bug69791() throws Exception {
        this.parseGPP("typedef __builtin_va_list __gnuc_va_list; \n").getDeclarations();
        this.parseGCC("typedef __builtin_va_list __gnuc_va_list; \n").getDeclarations();
    }

    public void testBug39697() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("__asm__( \"CODE\" );\n");
        ((Writer)stringWriter).write("__inline__ int foo() { return 4; }\n");
        ((Writer)stringWriter).write("__const__ int constInt;\n");
        ((Writer)stringWriter).write("__volatile__ int volInt;\n");
        ((Writer)stringWriter).write("__signed__ int signedInt;\n");
        IASTDeclaration[] iASTDeclarationArray = this.parseGCC(((Object)stringWriter).toString()).getDeclarations();
        Assert.assertEquals((String)((IASTASMDeclaration)iASTDeclarationArray[0]).getAssembly(), (String)"CODE");
        Assert.assertTrue((boolean)((IASTFunctionDefinition)iASTDeclarationArray[1]).getDeclSpecifier().isInline());
        Assert.assertTrue((boolean)((IASTSimpleDeclaration)iASTDeclarationArray[2]).getDeclSpecifier().isConst());
        Assert.assertTrue((boolean)((IASTSimpleDeclaration)iASTDeclarationArray[3]).getDeclSpecifier().isVolatile());
        Assert.assertTrue((boolean)((ICASTSimpleDeclSpecifier)((IASTSimpleDeclaration)iASTDeclarationArray[4]).getDeclSpecifier()).isSigned());
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int * __restrict__ resPointer1;\n");
        ((Writer)stringWriter).write("int * __restrict resPointer2;\n");
        iASTDeclarationArray = this.parseGCC(((Object)stringWriter).toString()).getDeclarations();
        Assert.assertTrue((boolean)((ICASTPointer)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getPointerOperators()[0]).isRestrict());
        Assert.assertTrue((boolean)((ICASTPointer)((IASTSimpleDeclaration)iASTDeclarationArray[1]).getDeclarators()[0].getPointerOperators()[0]).isRestrict());
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int * __restrict__ resPointer1;\n");
        ((Writer)stringWriter).write("int * __restrict resPointer2;\n");
        iASTDeclarationArray = this.parseGPP(((Object)stringWriter).toString()).getDeclarations();
        Assert.assertTrue((boolean)((IGPPASTPointer)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getPointerOperators()[0]).isRestrict());
        Assert.assertTrue((boolean)((IGPPASTPointer)((IASTSimpleDeclaration)iASTDeclarationArray[1]).getDeclarators()[0].getPointerOperators()[0]).isRestrict());
    }

    public void testBug73954A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("void f(){\t\t\t\t\t\t\t\n");
        stringWriter.write("\t__builtin_expect( 23, 2); \t\t\n");
        stringWriter.write("\t__builtin_prefetch( (const void *)0, 1, 2);\t\t\t\t\n");
        stringWriter.write("\t__builtin_huge_val();\t\t\t\n");
        stringWriter.write("\t__builtin_huge_valf();\t\t\t\n");
        stringWriter.write("\t__builtin_huge_vall();\t\t\t\n");
        stringWriter.write("\t__builtin_inf();\t\t\t\t\n");
        stringWriter.write("\t__builtin_inff();\t\t\t\t\n");
        stringWriter.write("\t__builtin_infl();\t\t\t\t\n");
        stringWriter.write("\t__builtin_nan(\"\");\t\t\t\n");
        stringWriter.write("\t__builtin_nanf(\"\");\t\t\t\n");
        stringWriter.write("\t__builtin_nanl(\"\");\t\t\t\n");
        stringWriter.write("\t__builtin_nans(\"\");\t\t\t\n");
        stringWriter.write("\t__builtin_nansf(\"\");\t\t\t\n");
        stringWriter.write("\t__builtin_nansl(\"\");\t\t\t\n");
        stringWriter.write("\t__builtin_ffs (0);\t\t\t\t\n");
        stringWriter.write("\t__builtin_clz (0);\t\t\t\t\n");
        stringWriter.write("\t__builtin_ctz (0);\t\t\t\t\n");
        stringWriter.write("\t__builtin_popcount (0);\t\t\t\n");
        stringWriter.write("\t__builtin_parity (0);\t\t\t\n");
        stringWriter.write("\t__builtin_ffsl (0);\t\t\t\t\n");
        stringWriter.write("\t__builtin_clzl (0);\t\t\t\t\n");
        stringWriter.write("\t__builtin_ctzl (0);\t\t\t\t\n");
        stringWriter.write("\t__builtin_popcountl (0);\t\t\n");
        stringWriter.write("\t__builtin_parityl (0);\t\t\t\n");
        stringWriter.write("\t__builtin_ffsll (0);\t\t\t\n");
        stringWriter.write("\t__builtin_clzll (0);\t\t\t\n");
        stringWriter.write("\t__builtin_ctzll (0);\t\t\t\n");
        stringWriter.write("\t__builtin_popcountll (0);\t\t\n");
        stringWriter.write("\t__builtin_parityll (0); \t\t\n");
        stringWriter.write("\t__builtin_powi (0, 0); \t\t\t\n");
        stringWriter.write("\t__builtin_powif (0, 0);\t \t\t\n");
        stringWriter.write("\t__builtin_powil (0, 0);   \t\t\n");
        stringWriter.write("}                                 \n");
        this.parseGCC(stringWriter.toString());
    }

    public void testBug39686() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("__complex__ double x; // complex double\n");
        ((Writer)stringWriter).write("__complex__ short int a; // complex short int\n");
        ((Writer)stringWriter).write("__complex__ float y = 2.5fi; // 2.5 imaginary float literal\n");
        ((Writer)stringWriter).write("__complex__ int z = 3i; // imaginary intege r literal\n");
        ((Writer)stringWriter).write("double v = __real__ x; // real part of expression\n");
        ((Writer)stringWriter).write("double w = __imag__ x; // imaginary part of expression\n");
        this.parseGCC(((Object)stringWriter).toString());
    }

    public void testBug39551B() throws Exception {
        IASTDeclaration cfr_ignored_0 = this.parseGCC("_Imaginary double id = 99.99 * 1i;").getDeclarations()[0];
    }

    public void testBug39681() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("double\n");
        ((Writer)stringWriter).write("foo (double a, double b)\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("  double square (double z) { return z * z; }\n");
        ((Writer)stringWriter).write("  return square (a) + square (b);\n");
        ((Writer)stringWriter).write("}\n");
        this.parseGCC(((Object)stringWriter).toString());
    }

    public void testBug39677() throws Exception {
        this.parseGPP("class B { public: B(); int a;}; B::B() : a(({ 1; })) {}");
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("B::B() : a(( { int y = foo (); int z;\n");
        ((Writer)stringWriter).write("if (y > 0) z = y;\n");
        ((Writer)stringWriter).write("else z = - y;\n");
        ((Writer)stringWriter).write("z; }))\n");
        this.parseGPP(((Object)stringWriter).toString());
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int x = ({ int foo() { return 1; } int y = foo (); int z;\n");
        ((Writer)stringWriter).write("if (y > 0) z = y;\n");
        ((Writer)stringWriter).write("else z = - y;\n");
        ((Writer)stringWriter).write("z; });\n");
        this.parseGPP(((Object)stringWriter).toString());
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int foo();                       \n");
        ((Writer)stringWriter).write("typeof({ int y = foo ();         \n");
        ((Writer)stringWriter).write("         int z;                  \n");
        ((Writer)stringWriter).write("         if (y > 0) z = y;       \n");
        ((Writer)stringWriter).write("         else z = - y;           \n");
        ((Writer)stringWriter).write("         z;                      \n");
        ((Writer)stringWriter).write("       }) zoot;                  \n");
        this.parseGPP(((Object)stringWriter).toString());
    }

    public void testBug75401() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define va_arg __builtin_va_arg      \n");
        ((Writer)stringWriter).write("#define va_list __builtin_va_list    \n");
        ((Writer)stringWriter).write("void main( int argc, char** argv ) { \n");
        ((Writer)stringWriter).write("   va_list v;                        \n");
        ((Writer)stringWriter).write("   long l = va_arg( v, long );       \n");
        ((Writer)stringWriter).write("}                                    \n");
        this.parseGCC(((Object)stringWriter).toString());
    }

    public void testBug73954B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define foo(x)                                            \\\n");
        ((Writer)stringWriter).write("  __builtin_choose_expr( 1, foo_d(x), (void)0 )             \n");
        ((Writer)stringWriter).write("int foo_d( int x );                                         \n");
        ((Writer)stringWriter).write("int main() {                                                \n");
        ((Writer)stringWriter).write("   if( __builtin_constant_p(1) &&                           \n");
        ((Writer)stringWriter).write("      __builtin_types_compatible_p( 1, 'c') )               \n");
        ((Writer)stringWriter).write("          foo(1);                                           \n");
        ((Writer)stringWriter).write("}                                                           \n");
        this.parseGCC(((Object)stringWriter).toString());
    }

    public void testGNUExternalTemplate_bug71603() throws Exception {
        this.parseGPP("template <typename T> \n class A {}; \n extern template class A<int>; \n").getDeclarations();
    }

    public void testBug74190_g_assert_1() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void log( int );               \n");
        ((Writer)stringWriter).write("void f() {                     \n");
        ((Writer)stringWriter).write("    int a = 1;                 \n");
        ((Writer)stringWriter).write("    (void)({ if( a ){ }        \n");
        ((Writer)stringWriter).write("             else{ log( a ); } \n");
        ((Writer)stringWriter).write("           });                 \n");
        ((Writer)stringWriter).write("}                              \n");
        this.parseGCC(((Object)stringWriter).toString());
        this.parseGPP(((Object)stringWriter).toString());
    }

    public void testBug74190_g_return_if_fail() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void f() {                     \n");
        ((Writer)stringWriter).write("    (void)({ if( ( ({ 0; }) ) ) \n");
        ((Writer)stringWriter).write("            { }                \n");
        ((Writer)stringWriter).write("           });                 \n");
        ((Writer)stringWriter).write("}                              \n");
        this.parseGCC(((Object)stringWriter).toString());
        this.parseGPP(((Object)stringWriter).toString());
    }

    public void testBug95635() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("void f(){                         \n");
        stringWriter.write("    char a[10];                   \n");
        stringWriter.write("    __builtin_va_list b;          \n");
        stringWriter.write("    __builtin_abort();            \n");
        stringWriter.write("    __builtin_exit(1);            \n");
        stringWriter.write("    __builtin__Exit(1);           \n");
        stringWriter.write("    __builtin__exit(1);           \n");
        stringWriter.write("    __builtin_conj(1);            \n");
        stringWriter.write("    __builtin_conjf(1);           \n");
        stringWriter.write("    __builtin_conjl(1);           \n");
        stringWriter.write("    __builtin_creal(1);           \n");
        stringWriter.write("    __builtin_crealf(1);          \n");
        stringWriter.write("    __builtin_creall(1);          \n");
        stringWriter.write("    __builtin_cimag(1);           \n");
        stringWriter.write("    __builtin_cimagf(1);          \n");
        stringWriter.write("    __builtin_cimagl(1);          \n");
        stringWriter.write("    __builtin_imaxabs(1);         \n");
        stringWriter.write("    __builtin_llabs(1);           \n");
        stringWriter.write("    __builtin_vscanf(\"\",b);\n");
        stringWriter.write("    __builtin_vsnprintf(a, 1, \"\", b); \n");
        stringWriter.write("    __builtin_vsscanf(\"\", \"\", b);\n");
        stringWriter.write("    __builtin_cosf(1);            \n");
        stringWriter.write("    __builtin_cosl(1);            \n");
        stringWriter.write("    __builtin_expf(1);            \n");
        stringWriter.write("    __builtin_expl(1);            \n");
        stringWriter.write("    __builtin_fabsf(1);           \n");
        stringWriter.write("    __builtin_fabsl(1);           \n");
        stringWriter.write("    __builtin_logf(1);            \n");
        stringWriter.write("    __builtin_logl(1);            \n");
        stringWriter.write("    __builtin_sinf(1);            \n");
        stringWriter.write("    __builtin_sinl(1);            \n");
        stringWriter.write("    __builtin_sqrtf(1);           \n");
        stringWriter.write("    __builtin_sqrtl(1);           \n");
        stringWriter.write("    __builtin_abs(1);             \n");
        stringWriter.write("    __builtin_cos(1);             \n");
        stringWriter.write("    __builtin_exp(1);             \n");
        stringWriter.write("    __builtin_fabs(1);            \n");
        stringWriter.write("    __builtin_fprintf((void*)0, \"\");\n");
        stringWriter.write("    __builtin_fputs(\"\", (void*)0);\n");
        stringWriter.write("    __builtin_labs(1);            \n");
        stringWriter.write("    __builtin_log(1);             \n");
        stringWriter.write("    __builtin_memcmp((void*)0, (void*)0, 1);\n");
        stringWriter.write("    __builtin_memcpy((void*)0,(void*)0, 1);\n");
        stringWriter.write("    __builtin_memset((void*)0, 1, 1);\n");
        stringWriter.write("    __builtin_printf(\"\");       \n");
        stringWriter.write("    __builtin_putchar(1);         \n");
        stringWriter.write("    __builtin_puts(\"\");            \n");
        stringWriter.write("    __builtin_scanf(\"\");        \n");
        stringWriter.write("    __builtin_sin(1);             \n");
        stringWriter.write("    __builtin_snprintf(a, 1, \"\");\n");
        stringWriter.write("    __builtin_sprintf(a, \"\");\n");
        stringWriter.write("    __builtin_sqrt(1);            \n");
        stringWriter.write("    __builtin_sscanf(\"\", \"\"); \n");
        stringWriter.write("    __builtin_strcat(a, \"\"); \n");
        stringWriter.write("    __builtin_strchr(\"\", 1); \n");
        stringWriter.write("    __builtin_strcmp(\"\", \"\"); \n");
        stringWriter.write("    __builtin_strcpy(a, \"\"); \n");
        stringWriter.write("    __builtin_strcspn(\"\", \"\");\n");
        stringWriter.write("    __builtin_strlen(\"\");       \n");
        stringWriter.write("    __builtin_strncat(a, \"\", 1);\n");
        stringWriter.write("    __builtin_strncmp(\"\", \"\", 1);\n");
        stringWriter.write("    __builtin_strncpy(a, \"\", 1);\n");
        stringWriter.write("    __builtin_strpbrk(\"\", \"\");\n");
        stringWriter.write("    __builtin_strrchr(\"\", 1);   \n");
        stringWriter.write("    __builtin_strspn(\"\", \"\"); \n");
        stringWriter.write("    __builtin_strstr(\"\", \"\"); \n");
        stringWriter.write("    __builtin_strstr(\"\", \"\"); \n");
        stringWriter.write("    __builtin_vprintf(a, b);\n");
        stringWriter.write("    __builtin_vsprintf(a, 1, \"\", b);    \n");
        stringWriter.write("    __builtin_isgreater(1,1);      \n");
        stringWriter.write("    __builtin_isgreaterequal(1,1);\n");
        stringWriter.write("    __builtin_isless(1,1);        \n");
        stringWriter.write("    __builtin_islessequal(1,1);   \n");
        stringWriter.write("    __builtin_islessgreater(1,1); \n");
        stringWriter.write("    __builtin_isunordered(1,1);   \n");
        stringWriter.write("}                                 \n");
        this.parseGCC(stringWriter.toString());
        this.parseGPP(stringWriter.toString());
    }
}

