/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.dom.parser.c.ANSICParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.c.GCCParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.c.GNUCSourceParser;
import org.eclipse.cdt.internal.core.dom.parser.c.ICParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ANSICPPParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GNUCPPSourceParser;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GPPParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.ParserException;
import org.eclipse.cdt.internal.core.parser.scanner2.DOMScanner;
import org.eclipse.cdt.internal.core.parser.scanner2.FileCodeReaderFactory;
import org.eclipse.cdt.internal.core.parser.scanner2.GCCScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.GPPScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.IScannerExtensionConfiguration;

public class QuickParser2Tests
extends TestCase {
    private static final NullLogService NULL_LOG = new NullLogService();

    public QuickParser2Tests() {
    }

    public QuickParser2Tests(String string) {
        super(string);
    }

    public void testIntGlobal() throws Exception {
        this.parse("int x = 5;");
    }

    public void testEmptyClass() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A { } a;");
        this.parse(((Object)stringWriter).toString());
    }

    public void testSimpleClassMember() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A { public: int x; };");
        this.parse(((Object)stringWriter).toString());
    }

    protected void parse(String string, boolean bl, ParserLanguage parserLanguage) throws Exception {
        this.parse(string, bl, parserLanguage, false);
    }

    protected void parse(String string, boolean bl) throws Exception {
        this.parse(string, bl, ParserLanguage.CPP);
    }

    protected void parse(String string) throws Exception {
        this.parse(string, true, ParserLanguage.CPP);
    }

    public void testNamespaceDefinition() throws Exception {
        int n = 0;
        while (n < 2) {
            if (n == 0) {
                this.parse("namespace KingJohn { int x; }");
            } else {
                this.parse("namespace { int x; }");
            }
            ++n;
        }
    }

    public void testLinkageSpecification() throws Exception {
        int n = 0;
        while (n < 2) {
            if (n == 0) {
                this.parse("extern \"C\" { int x(void); }");
            } else {
                this.parse("extern \"ADA\" int x(void);");
            }
            ++n;
        }
    }

    public void testEnumSpecifier() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("enum { yo, go = 3, away };\n");
        ((Writer)stringWriter).write("enum hasAString { last = 666 };");
        this.parse(((Object)stringWriter).toString());
    }

    public void testTypedef() throws Exception {
        this.parse("typedef const struct A * const cpStructA;");
    }

    public void testUsingClauses() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("using namespace A::B::C;\n");
        ((Writer)stringWriter).write("using namespace C;\n");
        ((Writer)stringWriter).write("using B::f;\n");
        ((Writer)stringWriter).write("using ::f;\n");
        ((Writer)stringWriter).write("using typename crap::de::crap;");
        this.parse(((Object)stringWriter).toString());
    }

    public void testSimpleClassMembers() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A : public B, private C, virtual protected D { public: int x, y; float a,b,c; };");
        this.parse(((Object)stringWriter).toString());
    }

    public void testSimpleFunctionDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void myFunction( void );");
        this.parse(((Object)stringWriter).toString());
    }

    public void testFunctionDeclarationWithParameters() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("bool myFunction( int parm1 = 3 * 4, double parm2 );");
        this.parse(((Object)stringWriter).toString());
    }

    public void testAssignmentExpressions() throws Exception {
        this.parse("int x = y = z = 5;");
    }

    public void testBug39348() throws Exception {
        this.parse("unsigned char a[sizeof (struct sss)];");
    }

    public void testBug39501() throws Exception {
        this.parse("struct A { A() throw (int); };");
    }

    public void testBug39349() throws Exception {
        this.parse("enum foo {  foo1   = 0,  foo2   = 0xffffffffffffffffULL,  foo3   = 0xf0fffffffffffffeLLU };");
    }

    public void testBug39544() throws Exception {
        this.parse("wchar_t wc = L'X';");
    }

    public void testBug36290() throws Exception {
        this.parse("typedef void ( A:: * pMethod ) ( void ); ");
        this.parse("typedef void (boo) ( void ); ");
        this.parse("typedef void boo (void); ");
    }

    public void testBug36769B() throws Exception {
        this.parse("class X { operator int(); } \n");
        this.parse("class X { operator int*(); } \n");
        this.parse("class X { operator int&(); } \n");
        this.parse("class X { operator A(); } \n");
        this.parse("class X { operator A*(); } \n");
        this.parse("class X { operator A&(); } \n");
        this.parse("X::operator int() { } \n");
        this.parse("X::operator int*() { } \n");
        this.parse("X::operator int&() { } \n");
        this.parse("X::operator A() { } \n");
        this.parse("X::operator A*() { } \n");
        this.parse("X::operator A&() { } \n");
        this.parse("template <class A,B> class X<A,C> { operator int(); } \n");
        this.parse("template <class A,B> class X<A,C> { operator int*(); } \n");
        this.parse("template <class A,B> class X<A,C> { operator int&(); } \n");
        this.parse("template <class A,B> class X<A,C> { operator A(); } \n");
        this.parse("template <class A,B> class X<A,C> { operator A*(); } \n");
        this.parse("template <class A,B> class X<A,C> { operator A&(); } \n");
        this.parse("template <class A,B> X<A,C>::operator int() { } \n");
        this.parse("template <class A,B> X<A,C>::operator int*() { } \n");
        this.parse("template <class A,B> X<A,C>::operator int&() { } \n");
        this.parse("template <class A,B> X<A,C>::operator A() { } \n");
        this.parse("template <class A,B> X<A,C>::operator A*() { } \n");
        this.parse("template <class A,B> X<A,C>::operator A&() { } \n");
    }

    public void testBug36932C() throws Exception {
        this.parse("X::X( ) : var( new int ) {}");
        this.parse("X::X( ) : var( new int(5) ) {}");
        this.parse("X::X( ) : var( new int(B) ) {}");
        this.parse("X::X( ) : var( new int(B,C) ) {}");
        this.parse("X::X( ) : var( new int[5] ) {}");
        this.parse("X::X( ) : var( new int[5][10] ) {}");
        this.parse("X::X( ) : var( new int[B] ) {}");
        this.parse("X::X( ) : var( new int[B][C][D] ) {}");
        this.parse("X::X( ) : var( new A ) {}");
        this.parse("X::X( ) : var( new A(5) ) {}");
        this.parse("X::X( ) : var( new A(B) ) {}");
        this.parse("X::X( ) : var( new A(B,C) ) {}");
        this.parse("X::X( ) : var( new A[5] ) {}");
        this.parse("X::X( ) : var( new A[5][10] ) {}");
        this.parse("X::X( ) : var( new A[B] ) {}");
        this.parse("X::X( ) : var( new A[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (int) ) {}");
        this.parse("X::X( ) : var( new (int)(5) ) {}");
        this.parse("X::X( ) : var( new (int)(B) ) {}");
        this.parse("X::X( ) : var( new (int)(B,C) ) {}");
        this.parse("X::X( ) : var( new (int)[5] ) {}");
        this.parse("X::X( ) : var( new (int)[5][10] ) {}");
        this.parse("X::X( ) : var( new (int)[B] ) {}");
        this.parse("X::X( ) : var( new (int)[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (A) ) {}");
        this.parse("X::X( ) : var( new (A)(5) ) {}");
        this.parse("X::X( ) : var( new (A)(B) ) {}");
        this.parse("X::X( ) : var( new (A)(B,C) ) {}");
        this.parse("X::X( ) : var( new (A)[5] ) {}");
        this.parse("X::X( ) : var( new (A)[5][10] ) {}");
        this.parse("X::X( ) : var( new (A)[B] ) {}");
        this.parse("X::X( ) : var( new (A)[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (0) int ) {}");
        this.parse("X::X( ) : var( new (0) int(5) ) {}");
        this.parse("X::X( ) : var( new (0) int(B) ) {}");
        this.parse("X::X( ) : var( new (0) int(B,C) ) {}");
        this.parse("X::X( ) : var( new (0) int[5] ) {}");
        this.parse("X::X( ) : var( new (0) int[5][10] ) {}");
        this.parse("X::X( ) : var( new (0) int[B] ) {}");
        this.parse("X::X( ) : var( new (0) int[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (0) A ) {}");
        this.parse("X::X( ) : var( new (0) A(5) ) {}");
        this.parse("X::X( ) : var( new (0) A(B) ) {}");
        this.parse("X::X( ) : var( new (0) A(B,C) ) {}");
        this.parse("X::X( ) : var( new (0) A[5] ) {}");
        this.parse("X::X( ) : var( new (0) A[5][10] ) {}");
        this.parse("X::X( ) : var( new (0) A[B] ) {}");
        this.parse("X::X( ) : var( new (0) A[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (0) (int) ) {}");
        this.parse("X::X( ) : var( new (0) (int)(5) ) {}");
        this.parse("X::X( ) : var( new (0) (int)(B) ) {}");
        this.parse("X::X( ) : var( new (0) (int)(B,C) ) {}");
        this.parse("X::X( ) : var( new (0) (int)[5] ) {}");
        this.parse("X::X( ) : var( new (0) (int)[5][10] ) {}");
        this.parse("X::X( ) : var( new (0) (int)[B] ) {}");
        this.parse("X::X( ) : var( new (0) (int)[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (0) (A) ) {}");
        this.parse("X::X( ) : var( new (0) (A)(5) ) {}");
        this.parse("X::X( ) : var( new (0) (A)(B) ) {}");
        this.parse("X::X( ) : var( new (0) (A)(B,C) ) {}");
        this.parse("X::X( ) : var( new (0) (A)[5] ) {}");
        this.parse("X::X( ) : var( new (0) (A)[5][10] ) {}");
        this.parse("X::X( ) : var( new (0) (A)[B] ) {}");
        this.parse("X::X( ) : var( new (0) (A)[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (P) int ) {}");
        this.parse("X::X( ) : var( new (P) int(5) ) {}");
        this.parse("X::X( ) : var( new (P) int(B) ) {}");
        this.parse("X::X( ) : var( new (P) int(B,C) ) {}");
        this.parse("X::X( ) : var( new (P) int[5] ) {}");
        this.parse("X::X( ) : var( new (P) int[5][10] ) {}");
        this.parse("X::X( ) : var( new (P) int[B] ) {}");
        this.parse("X::X( ) : var( new (P) int[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (P) A ) {}");
        this.parse("X::X( ) : var( new (P) A(5) ) {}");
        this.parse("X::X( ) : var( new (P) A(B) ) {}");
        this.parse("X::X( ) : var( new (P) A(B,C) ) {}");
        this.parse("X::X( ) : var( new (P) A[5] ) {}");
        this.parse("X::X( ) : var( new (P) A[5][10] ) {}");
        this.parse("X::X( ) : var( new (P) A[B] ) {}");
        this.parse("X::X( ) : var( new (P) A[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (P) (int) ) {}");
        this.parse("X::X( ) : var( new (P) (int)(5) ) {}");
        this.parse("X::X( ) : var( new (P) (int)(B) ) {}");
        this.parse("X::X( ) : var( new (P) (int)(B,C) ) {}");
        this.parse("X::X( ) : var( new (P) (int)[5] ) {}");
        this.parse("X::X( ) : var( new (P) (int)[5][10] ) {}");
        this.parse("X::X( ) : var( new (P) (int)[B] ) {}");
        this.parse("X::X( ) : var( new (P) (int)[B][C][D] ) {}");
        this.parse("X::X( ) : var( new (P) (A) ) {}");
        this.parse("X::X( ) : var( new (P) (A)(5) ) {}");
        this.parse("X::X( ) : var( new (P) (A)(B) ) {}");
        this.parse("X::X( ) : var( new (P) (A)(B,C) ) {}");
        this.parse("X::X( ) : var( new (P) (A)[5] ) {}");
        this.parse("X::X( ) : var( new (P) (A)[5][10] ) {}");
        this.parse("X::X( ) : var( new (P) (A)[B] ) {}");
        this.parse("X::X( ) : var( new (P) (A)[B][C][D] ) {}");
    }

    public void testBugSingleton192() throws Exception {
        this.parse("int Test::* pMember_;");
    }

    public void testBug36931() throws Exception {
        this.parse("A::nested::nested(){}; ");
        this.parse("int A::nested::foo() {} ");
        this.parse("int A::nested::operator+() {} ");
        this.parse("A::nested::operator int() {} ");
        this.parse("static const int A::nested::i = 1; ");
        this.parse("template <class B,C> A<B>::nested::nested(){}; ");
        this.parse("template <class B,C> int A::nested<B,D>::foo() {} ");
        this.parse("template <class B,C> int A<B,C>::nested<C,B>::operator+() {} ");
        this.parse("template <class B,C> A::nested::operator int() {} ");
    }

    public void testBug37019() throws Exception {
        this.parse("static const A a( 1, 0 );");
    }

    public void testBug36766and36769A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <class _CharT, class _Alloc>\n");
        ((Writer)stringWriter).write("rope<_CharT, _Alloc>::rope(size_t __n, _CharT __c,\n");
        ((Writer)stringWriter).write("const allocator_type& __a): _Base(__a)\n");
        ((Writer)stringWriter).write("{}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36766and36769B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template<class _CharT>\n");
        ((Writer)stringWriter).write("bool _Rope_insert_char_consumer<_CharT>::operator()\n");
        ((Writer)stringWriter).write("(const _CharT* __leaf, size_t __n)\n");
        ((Writer)stringWriter).write("{}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36766and36769C() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <class _CharT, class _Alloc>\n");
        ((Writer)stringWriter).write("_Rope_char_ref_proxy<_CharT, _Alloc>&\n");
        ((Writer)stringWriter).write("_Rope_char_ref_proxy<_CharT, _Alloc>::operator= (_CharT __c)\n");
        ((Writer)stringWriter).write("{}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36766and36769D() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <class _CharT, class _Alloc>\n");
        ((Writer)stringWriter).write("rope<_CharT, _Alloc>::~rope()\n");
        ((Writer)stringWriter).write("{}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36932A() throws Exception {
        this.parse("A::A( ) : var( new char [ (unsigned)bufSize ] ) {}");
    }

    public void testBug36932B() throws Exception {
        this.parse(" p = new int; ");
        this.parse(" p = new int(5); ");
        this.parse(" p = new int(B); ");
        this.parse(" p = new int(B,C); ");
        this.parse(" p = new int[5]; ");
        this.parse(" p = new int[5][10]; ");
        this.parse(" p = new int[B]; ");
        this.parse(" p = new int[B][C][D]; ");
        this.parse(" p = new A; ");
        this.parse(" p = new A(5); ");
        this.parse(" p = new A(B); ");
        this.parse(" p = new A(B,C); ");
        this.parse(" p = new A[5]; ");
        this.parse(" p = new A[5][10]; ");
        this.parse(" p = new A[B]; ");
        this.parse(" p = new A[B][C][D]; ");
        this.parse(" p = new (int); ");
        this.parse(" p = new (int)(5); ");
        this.parse(" p = new (int)(B); ");
        this.parse(" p = new (int)(B,C); ");
        this.parse(" p = new (int)[5]; ");
        this.parse(" p = new (int)[5][10]; ");
        this.parse(" p = new (int)[B]; ");
        this.parse(" p = new (int)[B][C][D]; ");
        this.parse(" p = new (A); ");
        this.parse(" p = new (A)(5); ");
        this.parse(" p = new (A)(B); ");
        this.parse(" p = new (A)(B,C); ");
        this.parse(" p = new (A)[5]; ");
        this.parse(" p = new (A)[5][10]; ");
        this.parse(" p = new (A)[B]; ");
        this.parse(" p = new (A)[B][C][D]; ");
        this.parse(" p = new (0) int; ");
        this.parse(" p = new (0) int(5); ");
        this.parse(" p = new (0) int(B); ");
        this.parse(" p = new (0) int(B,C); ");
        this.parse(" p = new (0) int[5]; ");
        this.parse(" p = new (0) int[5][10]; ");
        this.parse(" p = new (0) int[B]; ");
        this.parse(" p = new (0) int[B][C][D]; ");
        this.parse(" p = new (0) A; ");
        this.parse(" p = new (0) A(5); ");
        this.parse(" p = new (0) A(B); ");
        this.parse(" p = new (0) A(B,C); ");
        this.parse(" p = new (0) A[5]; ");
        this.parse(" p = new (0) A[5][10]; ");
        this.parse(" p = new (0) A[B]; ");
        this.parse(" p = new (0) A[B][C][D]; ");
        this.parse(" p = new (0) (int); ");
        this.parse(" p = new (0) (int)(5); ");
        this.parse(" p = new (0) (int)(B); ");
        this.parse(" p = new (0) (int)(B,C); ");
        this.parse(" p = new (0) (int)[5]; ");
        this.parse(" p = new (0) (int)[5][10]; ");
        this.parse(" p = new (0) (int)[B]; ");
        this.parse(" p = new (0) (int)[B][C][D]; ");
        this.parse(" p = new (0) (A); ");
        this.parse(" p = new (0) (A)(5); ");
        this.parse(" p = new (0) (A)(B); ");
        this.parse(" p = new (0) (A)(B,C); ");
        this.parse(" p = new (0) (A)[5]; ");
        this.parse(" p = new (0) (A)[5][10]; ");
        this.parse(" p = new (0) (A)[B]; ");
        this.parse(" p = new (0) (A)[B][C][D]; ");
        this.parse(" p = new (P) int; ");
        this.parse(" p = new (P) int(5); ");
        this.parse(" p = new (P) int(B); ");
        this.parse(" p = new (P) int(B,C); ");
        this.parse(" p = new (P) int[5]; ");
        this.parse(" p = new (P) int[5][10]; ");
        this.parse(" p = new (P) int[B]; ");
        this.parse(" p = new (P) int[B][C][D]; ");
        this.parse(" p = new (P) A; ");
        this.parse(" p = new (P) A(5); ");
        this.parse(" p = new (P) A(B); ");
        this.parse(" p = new (P) A(B,C); ");
        this.parse(" p = new (P) A[5]; ");
        this.parse(" p = new (P) A[5][10]; ");
        this.parse(" p = new (P) A[B]; ");
        this.parse(" p = new (P) A[B][C][D]; ");
        this.parse(" p = new (P) (int); ");
        this.parse(" p = new (P) (int)(5); ");
        this.parse(" p = new (P) (int)(B); ");
        this.parse(" p = new (P) (int)(B,C); ");
        this.parse(" p = new (P) (int)[5]; ");
        this.parse(" p = new (P) (int)[5][10]; ");
        this.parse(" p = new (P) (int)[B]; ");
        this.parse(" p = new (P) (int)[B][C][D]; ");
        this.parse(" p = new (P) (A); ");
        this.parse(" p = new (P) (A)(5); ");
        this.parse(" p = new (P) (A)(B); ");
        this.parse(" p = new (P) (A)(B,C); ");
        this.parse(" p = new (P) (A)[5]; ");
        this.parse(" p = new (P) (A)[5][10]; ");
        this.parse(" p = new (P) (A)[B]; ");
        this.parse(" p = new (P) (A)[B][C][D]; ");
    }

    public void testBug36769A() throws Exception {
        this.parse("template <class A, B> cls<A, C>::operator  &() const {}\n");
        this.parse("template <class A, B> cls<A, C>::cls() {}\n");
        this.parse("template <class A, B> cls<A, C>::~cls() {}\n");
    }

    public void testBug36714() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("unsigned long a = 0UL;\n");
        ((Writer)stringWriter).write("unsigned long a2 = 0L; \n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBugFunctor758() throws Exception {
        this.parse("template <typename Fun> Functor(Fun fun) : spImpl_(new FunctorHandler<Functor, Fun>(fun)){}");
    }

    public void testBug36932() throws Exception {
        this.parse("A::A(): b( new int( 5 ) ), b( new B ), c( new int ) {}");
    }

    public void testBug36704() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <class T, class U>\n");
        ((Writer)stringWriter).write("struct Length< Typelist<T, U> >\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("enum { value = 1 + Length<U>::value };\n");
        ((Writer)stringWriter).write("};\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36699() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <\ttemplate <class> class ThreadingModel = DEFAULT_THREADING,\n");
        ((Writer)stringWriter).write("std::size_t chunkSize = DEFAULT_CHUNK_SIZE,\n");
        ((Writer)stringWriter).write("std::size_t maxSmallObjectSize = MAX_SMALL_OBJECT_SIZE\t>\n");
        ((Writer)stringWriter).write("class SmallObject : public ThreadingModel<\n");
        ((Writer)stringWriter).write("SmallObject<ThreadingModel, chunkSize, maxSmallObjectSize> >\n");
        ((Writer)stringWriter).write("{};\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36691() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <class T, class H>\n");
        ((Writer)stringWriter).write("typename H::template Rebind<T>::Result& Field(H& obj)\n");
        ((Writer)stringWriter).write("{\treturn obj;\t}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36702() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void mad_decoder_init(struct mad_decoder *, void *,\n");
        ((Writer)stringWriter).write("\t\t\t  enum mad_flow (*)(void *, struct mad_stream *),\n");
        ((Writer)stringWriter).write("\t\t\t  enum mad_flow (*)(void *, struct mad_header const *),\n");
        ((Writer)stringWriter).write("\t\t\t  enum mad_flow (*)(void *,\n");
        ((Writer)stringWriter).write("\t\t\t\t\tstruct mad_stream const *,\n");
        ((Writer)stringWriter).write("\t\t\t\t\tstruct mad_frame *),\n");
        ((Writer)stringWriter).write("\t\t\t  enum mad_flow (*)(void *,\n");
        ((Writer)stringWriter).write("\t\t\t\t\tstruct mad_header const *,\n");
        ((Writer)stringWriter).write("\t\t\t\t\tstruct mad_pcm *),\n");
        ((Writer)stringWriter).write("\t\t\t  enum mad_flow (*)(void *,\n");
        ((Writer)stringWriter).write("\t\t\t\t\tstruct mad_stream *,\n");
        ((Writer)stringWriter).write("\t\t\t\t\tstruct mad_frame *),\n");
        ((Writer)stringWriter).write("\t\t\t  enum mad_flow (*)(void *, void *, unsigned int *)\n");
        ((Writer)stringWriter).write(");\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36852() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int CBT::senseToAllRect( double id_standardQuot = DOSE, double id_minToleranz =15.0,\n");
        ((Writer)stringWriter).write("double id_maxToleranz = 15.0, unsigned int iui_minY = 0, \n");
        ((Writer)stringWriter).write("unsigned int iui_maxY = HEIGHT );\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36689() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template\n");
        ((Writer)stringWriter).write("<\n");
        ((Writer)stringWriter).write("class AbstractFact,\n");
        ((Writer)stringWriter).write("template <class, class> class Creator = OpNewFactoryUnit,\n");
        ((Writer)stringWriter).write("class TList = typename AbstractFact::ProductList\n");
        ((Writer)stringWriter).write(">\n");
        ((Writer)stringWriter).write("class ConcreteFactory\n");
        ((Writer)stringWriter).write(": public GenLinearHierarchy<\n");
        ((Writer)stringWriter).write("typename TL::Reverse<TList>::Result, Creator, AbstractFact>\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("typedef typename AbstractFact::ProductList ProductList;\n");
        ((Writer)stringWriter).write("typedef TList ConcreteProductList;\n");
        ((Writer)stringWriter).write("};\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36707() throws Exception {
        this.parse("enum { exists = sizeof(typename H::Small) == sizeof((H::Test(H::MakeT()))) };");
    }

    public void testBug36717() throws Exception {
        this.parse("enum { eA = A::b };");
    }

    public void testBug36693() throws Exception {
        this.parse("FixedAllocator::Chunk* FixedAllocator::VicinityFind(void* p){}");
    }

    public void testWeirdExpression() throws Exception {
        this.parse("int x = rhs.spImpl_.get();");
    }

    public void testBug36696() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <typename P1> RefCounted(const RefCounted<P1>& rhs)\n");
        ((Writer)stringWriter).write(": pCount_(reinterpret_cast<const RefCounted&>(rhs).pCount_) {}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testArrayOfPointerToFunctions() throws Exception {
        this.parse("unsigned char (*main_data)[MAD_BUFFER_MDLEN];");
    }

    public void testBug36073() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A{\n");
        stringWriter.write("int x;\n");
        stringWriter.write("public:\n");
        stringWriter.write("A(const A&);\n");
        stringWriter.write("};\n");
        stringWriter.write("A::A(const A&v) : x(v.x) { }\n");
        this.parse(stringWriter.toString());
    }

    public void testTemplateSpecialization() throws Exception {
        this.parse("template<> class stream<char> { /* ... */ };");
    }

    public void testTemplateInstantiation() throws Exception {
        this.parse("template class Array<char>;");
    }

    public void testMultipleDeclarators() throws Exception {
        this.parse("class A { int floor( double input ), someInt; };");
    }

    public void testFunctionModifiers() throws Exception {
        this.parse("class A {virtual void foo( void ) const throw ( yay, nay, we::dont::care ) = 0;};");
    }

    public void testArrays() throws Exception {
        this.parse("int x [5][];");
    }

    public void testElaboratedParms() throws Exception {
        this.parse("int x( struct A myA ) { /* junk */ }");
    }

    public void testMemberDeclarations() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A {\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write(" int is0;\n");
        ((Writer)stringWriter).write("private:\n");
        ((Writer)stringWriter).write(" int is1;\n");
        ((Writer)stringWriter).write("protected:\n");
        ((Writer)stringWriter).write(" int is2;\n");
        ((Writer)stringWriter).write("};");
        this.parse(((Object)stringWriter).toString());
    }

    public void testPointerOperators() throws Exception {
        this.parse("int * x = 0, & y, * const * volatile * z;");
    }

    public void testBug26467() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("struct foo { int fooInt; char fooChar;\t};\n");
        stringWriter.write("typedef struct foo fooStruct;\n");
        stringWriter.write("typedef struct { int anonInt; char anonChar; } anonStruct;\n");
        this.parse(stringWriter.toString());
    }

    public void testASMDefinition() throws Exception {
        this.parse("asm( \"mov ep1 ds2\");");
    }

    public void testConstructorChain() throws Exception {
        this.parse("TrafficLight_Actor::TrafficLight_Actor( RTController * rtg_rts, RTActorRef * rtg_ref )\t: RTActor( rtg_rts, rtg_ref ), myId( 0 ) {}");
    }

    public void testBug36237() throws Exception {
        this.parse("A::A():B( (char *)0 ){}");
    }

    public void testBug36532() throws Exception {
        try {
            this.parse("template<int f() {\n");
            Assert.fail((String)"We should not make it this far");
        }
        catch (ParserException parserException) {
        }
        catch (Exception exception) {
            Assert.fail((String)("We should have gotten a ParserException rather than" + exception));
        }
    }

    public void testPreprocessor() throws Exception {
        String string = "#include <stdio.h>\n#define DEF VALUE\n";
        this.parse(string.toString());
    }

    public void testTemplateDeclarationOfFunction() throws Exception {
        this.parse("template<class A, typename B=C> A aTemplatedFunction( B bInstance );");
    }

    public void testTemplateDeclarationOfClass() throws Exception {
        this.parse("template<class T, typename Tibor = junk, class, typename, int x, float y,template <class Y> class, template<class A> class AClass> class myarray { /* ... */ };");
    }

    public void testBug35906() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("void TTest::MTest() {}\n");
        stringWriter.write("struct TTest::STest *TTest::FTest (int i) {}\n");
        this.parse(stringWriter.toString());
    }

    public void testBug36288() throws Exception {
        this.parse("int foo() {}\nlong foo2(){}");
    }

    public void testBug36250() throws Exception {
        this.parse("int f( int = 0 );");
    }

    public void testBug36240() throws Exception {
        this.parse("A & A::operator=( A ){}");
    }

    public void testBug36254() throws Exception {
        this.parse("unsigned i;\nvoid f( unsigned p1 = 0 );");
    }

    public void testBug36432() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define CMD_GET\t\t\"g\"\n");
        ((Writer)stringWriter).write("#define CMD_ACTION   \t\"a\"\n");
        ((Writer)stringWriter).write("#define CMD_QUIT\t\t\"q\"\n");
        ((Writer)stringWriter).write("static const memevent_cmd_func memevent_cmd_funcs[sizeof memevent_cmds - 1] = {\n");
        ((Writer)stringWriter).write("memevent_get,\n");
        ((Writer)stringWriter).write("memevent_action,\n");
        ((Writer)stringWriter).write("memevent_quit,\n");
        ((Writer)stringWriter).write("};\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36594() throws Exception {
        this.parse("const int n = sizeof(A) / sizeof(B);");
    }

    public void testBug36794() throws Exception {
        this.parse("template<> class allocator<void> {};");
    }

    public void testBug36799() throws Exception {
        this.parse("static const int __WORD_BIT = int(CHAR_BIT*sizeof(unsigned int));");
    }

    public void testBug36764() throws Exception {
        this.parse("struct{ int x : 4; int y : 8; };");
    }

    public void testOrder() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define __SGI_STL_INTERNAL_ALGOBASE_H\n");
        ((Writer)stringWriter).write("#include <string.h>\n");
        ((Writer)stringWriter).write("template <class _Tp>\n");
        ((Writer)stringWriter).write("inline void swap(_Tp& __a, _Tp& __b) {\n");
        ((Writer)stringWriter).write("__STL_REQUIRES(_Tp, _Assignable);\n");
        ((Writer)stringWriter).write("_Tp __tmp = __a;\n");
        ((Writer)stringWriter).write("__a = __b;\n");
        ((Writer)stringWriter).write("__b = __tmp;\n");
        ((Writer)stringWriter).write("}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36771() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include /**/ \"foo.h\"\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36811() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("using namespace std;\n");
        ((Writer)stringWriter).write("class Test {};");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36708() throws Exception {
        this.parse("enum { isPointer = PointerTraits<T>::result };");
    }

    public void testBug36690() throws Exception {
        this.parse("Functor(const Functor& rhs) : spImpl_(Impl::Clone(rhs.spImpl_.get())){}");
    }

    public void testBug36703() throws Exception {
        this.parse("const std::type_info& Get() const;");
    }

    public void testBug36692() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <typename T, typename Destroyer>\n");
        ((Writer)stringWriter).write("void SetLongevity(T* pDynObject, unsigned int longevity,\n");
        ((Writer)stringWriter).write("Destroyer d = Private::Deleter<T>::Delete){}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36551() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class TextFrame {\n");
        ((Writer)stringWriter).write("BAD_MACRO()\n");
        ((Writer)stringWriter).write("};");
        this.parse(((Object)stringWriter).toString(), false);
    }

    public void testStruct() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("struct mad_bitptr { unsigned char const *byte;\n");
        stringWriter.write("unsigned short cache;\n unsigned short left;};");
        this.parse(stringWriter.toString());
    }

    public void testBug36559() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace myNameSpace {\n");
        ((Writer)stringWriter).write("template<typename T=short> class B {};\n");
        ((Writer)stringWriter).write("template<> class B<int> {};\n");
        ((Writer)stringWriter).write("}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testPointersToFunctions() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void (*name)( void );\n");
        ((Writer)stringWriter).write("static void * (* const orig_malloc_hook)(const char *file, int line, size_t size);\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug36600() throws Exception {
        this.parse("enum mad_flow (*input_func)(void *, struct mad_stream *);");
    }

    public void testBug36713() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("A ( * const fPtr) (void *); \n");
        ((Writer)stringWriter).write("A (* const fPtr2) ( A * ); \n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testPointersToMemberFunctions() throws Exception {
        this.parse("void (A::*name)(void);");
    }

    public void testBug39550() throws Exception {
        this.parse("double x = 0x1.fp1;");
    }

    public void testBug39552A(int n) throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("%:define glue(x, y) x %:%: y\t/* #define glue(x, y) x ## y. */\n");
        ((Writer)stringWriter).write("#ifndef glue\n");
        ((Writer)stringWriter).write("#error glue not defined!\n");
        ((Writer)stringWriter).write("#endif\n");
        ((Writer)stringWriter).write("%:define str(x) %:x\t\t/* #define str(x) #x */\n");
        ((Writer)stringWriter).write("int main (int argc, char *argv<::>) /* argv[] */\n");
        ((Writer)stringWriter).write("glue (<, %) /* { */\n");
        ((Writer)stringWriter).write("\t\t\t /* di_str[] = */\n");
        ((Writer)stringWriter).write("  const char di_str glue(<, :)glue(:, >) = str(%:%:<::><%%>%:);\n");
        ((Writer)stringWriter).write("  /* Check the glue macro actually pastes, and that the spelling of\n");
        ((Writer)stringWriter).write("\t all digraphs is preserved.  */\n");
        ((Writer)stringWriter).write("  if (glue(strc, mp) (di_str, \"%:%:<::><%%>%:\"))\n");
        ((Writer)stringWriter).write("\terr (\"Digraph spelling not preserved!\");\n");
        ((Writer)stringWriter).write("  return 0;\n");
        ((Writer)stringWriter).write("glue (%, >) /* } */\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug39552B(int n) throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("??=include <stdio.h>\n");
        ((Writer)stringWriter).write("??=define TWELVE 1??/\n");
        ((Writer)stringWriter).write("2\n");
        ((Writer)stringWriter).write("static const char str??(??) = \"0123456789??/n\";\n");
        ((Writer)stringWriter).write("int\n");
        ((Writer)stringWriter).write("main(void)\n");
        ((Writer)stringWriter).write("??<\n");
        ((Writer)stringWriter).write("  unsigned char x = 5;\n");
        ((Writer)stringWriter).write("  if (sizeof str != TWELVE)\n");
        ((Writer)stringWriter).write("\tabort ();\n");
        ((Writer)stringWriter).write("  /* Test ^=, the only multi-character token to come from trigraphs.  */\n");
        ((Writer)stringWriter).write("  x ??'= 3;\n");
        ((Writer)stringWriter).write("  if (x != 6)\n");
        ((Writer)stringWriter).write("\tabort ();\n");
        ((Writer)stringWriter).write("  if ((5 ??! 3) != 7)\n");
        ((Writer)stringWriter).write("\tabort ();\n");
        ((Writer)stringWriter).write("  return 0;\n");
        ((Writer)stringWriter).write("??>\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug39553() throws Exception {
        this.parse("#define COMP_INC \"foobar.h\"  \n#include COMP_INC\n");
    }

    public void testBug39537() throws Exception {
        this.parse("typedef foo<(U::id > 0)> foobar;");
    }

    public void testBug39546() throws Exception {
        this.parse("signed char c = (signed char) 0xffffffff;");
    }

    public void testIndirectDeclarators() throws Exception {
        this.parse("void (*x)( int );");
    }

    public void testBug39532() throws Exception {
        this.parse("class N1::N2::B : public A {};");
    }

    public void testBug39540() throws Exception {
        this.parse("class {} const null;");
    }

    public void testBug39530() throws Exception {
        this.parse("X sPassed(-1)");
    }

    public void testBug39526() throws Exception {
        this.parse("UnitList unit_list (String(\"keV\"));");
    }

    public void testBug39535() throws Exception {
        this.parse("namespace bar = foo;");
    }

    public void testBug39504B() throws Exception {
        this.parse("int y = sizeof (int*);");
    }

    public void testBug39505A() throws Exception {
        this.parse("int AD::* gp_down = static_cast<int AD::*>(gp_stat);");
    }

    public void testBug39505B() throws Exception {
        this.parse("int* gp_down = static_cast<int*>(gp_stat);");
    }

    public void testBug42985() throws Exception {
        this.parse("const int x = 4; int y = ::x;");
    }

    public void testBug40419() throws Exception {
        StringWriter stringWriter = new StringWriter();
        try {
            ((Writer)stringWriter).write("template <class T, class U>\tstruct SuperSubclass {\n");
            ((Writer)stringWriter).write("enum { value = (::Loki::Conversion<const volatile U*, const volatile T*>::exists && \n");
            ((Writer)stringWriter).write("!::Loki::Conversion<const volatile T*, const volatile void*>::sameType) };\t};");
        }
        catch (IOException iOException) {}
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug39556() throws Exception {
        this.parse("int *restrict ip_fn (void);", true, ParserLanguage.C);
    }

    public void testBug43371() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct Example { Example(); Example(int); ~Example();};");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug43644() throws Exception {
        this.parse("void foo();{ int x; }", false);
    }

    public void testBug43062() throws Exception {
        this.parse("class X { operator short  (); \toperator int unsigned(); operator int signed(); };");
    }

    public void testBug39531() throws Exception {
        this.parse("class AString { operator char const *() const; };");
    }

    public void testBug40007() throws Exception {
        this.parse("int y = #;", false);
    }

    public void testBug40759() throws Exception {
        this.parse("#define X SomeName \n class X {};");
    }

    public void testBug44633() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template <typename T> class A {};\n");
        ((Writer)stringWriter).write("class B {  template <typename T> friend class A;\n");
        ((Writer)stringWriter).write("void method();\n");
        ((Writer)stringWriter).write("};\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug39525() throws Exception {
        this.parse("C &(C::*DD)(const C &x) = &C::operator=;");
    }

    public void testBug41935() throws Exception {
        this.parse("namespace A\t{  int x; } namespace B = A;");
    }

    public void testBug39528() throws Exception {
        StringWriter stringWriter = new StringWriter();
        try {
            ((Writer)stringWriter).write("struct B: public A {\n");
            ((Writer)stringWriter).write("  A a;\n");
            ((Writer)stringWriter).write("  B() try : A(1), a(2)\n");
            ((Writer)stringWriter).write("\t{ throw 1; }\n");
            ((Writer)stringWriter).write("  catch (...)\n");
            ((Writer)stringWriter).write("\t{ if (c != 3) r |= 1; }\n");
            ((Writer)stringWriter).write("};\n");
        }
        catch (IOException iOException) {}
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug39538() throws Exception {
        this.parse("template C::operator int<float> ();");
    }

    public void testBug39536() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("template<class E>\n");
        ((Writer)stringWriter).write("class X {\n");
        ((Writer)stringWriter).write("X<E>();  // This fails \n");
        ((Writer)stringWriter).write("inline X<E>(int); // This also fails \n");
        ((Writer)stringWriter).write("inline ~X<E>(); // This works fine \n");
        ((Writer)stringWriter).write("};\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug39536A() throws Exception {
        this.parse("template<class E> class X { X<E>(); };");
    }

    public void testBug39536B() throws Exception {
        this.parse("template<class E> class X { inline X<E>(int); };");
    }

    public void testBug39542() throws Exception {
        this.parse("void f(int a, struct {int b[a];} c) {}");
    }

    public void testBug39549() throws Exception {
        this.parse("struct X x = { .b = 40, .z = { sizeof(X), 42 }, .t[3] = 2, .t.f[3].x = A * B };", true, ParserLanguage.C);
        this.parse("struct X x = { .b = 40, .z = { sizeof(X), 42,}, .t[3] = 2, .t.f[3].x = A * B  ,};", true, ParserLanguage.C);
    }

    public void testBug39551A() throws Exception {
        this.parse("extern float _Complex conjf (float _Complex);", true, ParserLanguage.C);
    }

    public void testBug39551B() throws Exception {
        this.parse("_Imaginary double id = 99.99 * __I__;", true, ParserLanguage.C);
    }

    public void testCBool() throws Exception {
        this.parse("_Bool x;", true, ParserLanguage.C);
    }

    public void testBug39678() throws Exception {
        this.parse("char *s = L\"a\" \"b\";");
    }

    public void testBug43110() throws Exception {
        this.parse("void x( int y, ... );");
    }

    public void testBug47752() throws Exception {
        this.parse("void func( cFoo bar ) try {\t} catch ( const char * error ){\t}");
    }

    public void testBug47628() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void h(char) { }\n");
        ((Writer)stringWriter).write("void h(unsigned char) { }\n");
        ((Writer)stringWriter).write("void h(signed char) { }  // not shown in outline, parsed as char\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug44336() throws Exception {
        this.parse("class A {};  typedef typename A foo;");
    }

    public void testBug39705() throws Exception {
        this.parse("#ident \"@(#)filename.c   1.3 90/02/12\"");
    }

    public void testBug45235() throws Exception {
        this.parse("class A { friend class B; friend void f(); }; ");
    }

    public void testBug59179() throws Exception {
        this.parse("class __decl  main{  int main; };", false);
    }

    public void testBug57652() throws Exception {
        this.parse("struct file_operations driver_fops = {  open: device_open, release: device_release\t};", true, ParserLanguage.C, true);
    }

    protected void parse(String string, boolean bl, ParserLanguage parserLanguage, boolean bl2) throws Exception {
        Object object;
        CodeReader codeReader = new CodeReader(string.toCharArray());
        ScannerInfo scannerInfo = new ScannerInfo();
        Object object2 = null;
        object2 = parserLanguage == ParserLanguage.C ? new GCCScannerExtensionConfiguration() : new GPPScannerExtensionConfiguration();
        DOMScanner dOMScanner = new DOMScanner(codeReader, (IScannerInfo)scannerInfo, ParserMode.COMPLETE_PARSE, parserLanguage, (IParserLogService)NULL_LOG, (IScannerExtensionConfiguration)object2, (ICodeReaderFactory)FileCodeReaderFactory.getInstance());
        GNUCPPSourceParser gNUCPPSourceParser = null;
        if (parserLanguage == ParserLanguage.CPP) {
            object = null;
            object = bl2 ? new GPPParserExtensionConfiguration() : new ANSICPPParserExtensionConfiguration();
            gNUCPPSourceParser = new GNUCPPSourceParser((IScanner)dOMScanner, ParserMode.QUICK_PARSE, (IParserLogService)NULL_LOG, (ICPPParserExtensionConfiguration)object);
        } else {
            object = null;
            object = bl2 ? new GCCParserExtensionConfiguration() : new ANSICParserExtensionConfiguration();
            gNUCPPSourceParser = new GNUCSourceParser((IScanner)dOMScanner, ParserMode.QUICK_PARSE, (IParserLogService)NULL_LOG, (ICParserExtensionConfiguration)object);
        }
        object = gNUCPPSourceParser.parse();
        if (gNUCPPSourceParser.encounteredError() && bl) {
            throw new ParserException("FAILURE");
        }
        if (bl) {
            if (parserLanguage == ParserLanguage.C) {
                IASTProblem[] iASTProblemArray = CVisitor.getProblems((IASTTranslationUnit)object);
                Assert.assertEquals((int)iASTProblemArray.length, (int)0);
            } else if (parserLanguage == ParserLanguage.CPP) {
                IASTProblem[] iASTProblemArray = CPPVisitor.getProblems((IASTTranslationUnit)object);
                Assert.assertEquals((int)iASTProblemArray.length, (int)0);
            }
        }
    }

    public void testBug60142() throws Exception {
        this.parse("unsigned long var;");
    }

    public void testBug61431() throws Exception {
        int n = 0;
        while (n < 2) {
            ParserLanguage parserLanguage = n == 0 ? ParserLanguage.C : ParserLanguage.CPP;
            this.parse("int k[][] = { {0, {1}, {2,3}};", false, parserLanguage);
            ++n;
        }
    }

    public void testBadIdentifier() throws Exception {
        this.parse("class 0302 { private: int stinks; };", false);
    }

    public void testBug67622() throws Exception {
        this.parse("const char * x = __FILE__;");
    }

    public void testBug68116() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("char dummy[] = \"0123456789");
        int n = 0;
        while (n < 5000) {
            stringBuffer.append("0123456789");
            ++n;
        }
        stringBuffer.append("\";");
        this.parse(stringBuffer.toString());
    }

    public void testBug69161() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define MACRO(s) s\n ");
        ((Writer)stringWriter).write("char *testQueries[] =\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("MACRO(\",\"),\n");
        ((Writer)stringWriter).write("MACRO(\"(\"),\n");
        ((Writer)stringWriter).write("MACRO(\")\")\n");
        ((Writer)stringWriter).write("};\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug73524() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("static char fmt_1002[] = \"(/,\\002At iterate\\002,i5,4x,\\002f= \\002,1p,d12\\\r\n");
        ((Writer)stringWriter).write(".5,4x,\\002|proj g|= \\002,1p,d12.5)\";");
        this.parse(((Object)stringWriter).toString(), true, ParserLanguage.C);
    }

    public void testBug39694() throws Exception {
        this.parse("int ab$cd = 1;");
    }

    public void testBug39704A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define __declspec(x) __attribute__((x))");
        stringWriter.write("__declspec (dllimport) int foo;");
        this.parse(stringWriter.toString());
    }

    public void testBug39704D() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define __declspec(x) __attribute__((x))");
        stringWriter.write("__declspec(dllexport) int func1 (int a) {}");
        this.parse(stringWriter.toString());
    }

    public void testBug39695() throws Exception {
        this.parse("int a = __alignof__ (int);", true, ParserLanguage.CPP, true);
    }

    public void testBug39684() throws Exception {
        this.parse("typeof(foo(1)) bar () { return foo(1); }", true, ParserLanguage.CPP, true);
    }

    public void testBug39703() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("/* __extension__ enables GNU C mode for the duration of the declaration.  */\n");
        ((Writer)stringWriter).write("__extension__ struct G {\n");
        ((Writer)stringWriter).write("  struct { char z; };\n");
        ((Writer)stringWriter).write("  char g;\n");
        ((Writer)stringWriter).write("};\n");
        this.parse(((Object)stringWriter).toString(), true, ParserLanguage.CPP, true);
    }

    public void testBug39698A() throws Exception {
        this.parse("int c = a <? b;", true, ParserLanguage.CPP, true);
    }

    public void testBug39698B() throws Exception {
        this.parse("int c = a >? b;", true, ParserLanguage.CPP, true);
    }

    public void testBug39554() throws Exception {
        this.parse("_Pragma(\"foobar\")", true, ParserLanguage.C);
    }

    public void testBug39704B() throws Exception {
        this.parse("extern int (* import) (void) __attribute__((dllimport));", true, ParserLanguage.CPP, true);
    }

    public void testBug39704C() throws Exception {
        this.parse("int func2 (void) __attribute__((dllexport));", true, ParserLanguage.CPP, true);
    }

    public void testBug39686() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("__complex__ double x; // complex double\n");
        ((Writer)stringWriter).write("__complex__ short int a; // complex short int\n");
        ((Writer)stringWriter).write("__complex__ float y = 2.5fi; // 2.5 imaginary float literal\n");
        ((Writer)stringWriter).write("__complex__ int a = 3i; // imaginary intege r literal\n");
        ((Writer)stringWriter).write("double v = __real__ x; // real part of expression\n");
        ((Writer)stringWriter).write("double w = __imag__ x; // imaginary part of expression\n");
        this.parse(((Object)stringWriter).toString(), true, ParserLanguage.C, true);
    }

    public void testBug39681() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("double\n");
        ((Writer)stringWriter).write("foo (double a, double b)\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("  double square (double z) { return z * z; }\n");
        ((Writer)stringWriter).write("  return square (a) + square (b);\n");
        ((Writer)stringWriter).write("}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug39677() throws Exception {
        this.parse("B::B() : a(({ 1; })) {}", true, ParserLanguage.CPP, true);
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("B::B() : a(( { int y = foo (); int z;\n");
        ((Writer)stringWriter).write("if (y > 0) z = y;\n");
        ((Writer)stringWriter).write("else z = - y;\n");
        ((Writer)stringWriter).write("z; }))\n");
        this.parse(((Object)stringWriter).toString(), true, ParserLanguage.CPP, true);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int x = ({ int y = foo (); int z;\n");
        ((Writer)stringWriter).write("if (y > 0) z = y;\n");
        ((Writer)stringWriter).write("else z = - y;\n");
        ((Writer)stringWriter).write("z; });\n");
        this.parse(((Object)stringWriter).toString(), true, ParserLanguage.CPP, true);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("typeof({ int y = foo (); int z;\n");
        ((Writer)stringWriter).write("if (y > 0) z = y;\n");
        ((Writer)stringWriter).write("else z = - y;\n");
        ((Writer)stringWriter).write("z; }) zoot;\n");
        this.parse(((Object)stringWriter).toString(), true, ParserLanguage.CPP, true);
    }

    public void testBug39701A() throws Exception {
        this.parse("extern template int max (int, int);", true, ParserLanguage.CPP, true);
    }

    public void testBug39701B() throws Exception {
        this.parse("inline template class Foo<int>;", true, ParserLanguage.CPP, true);
    }

    public void testBug39701C() throws Exception {
        this.parse("static template class Foo<int>;", true, ParserLanguage.CPP, true);
    }
}

