/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.prefix;

import java.util.Arrays;
import java.util.Comparator;
import junit.framework.TestCase;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.ASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.dom.parser.c.ANSICParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.c.GCCParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.c.GNUCSourceParser;
import org.eclipse.cdt.internal.core.dom.parser.c.ICParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ANSICPPParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GNUCPPSourceParser;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GPPParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.ParserException;
import org.eclipse.cdt.internal.core.parser.scanner2.DOMScanner;
import org.eclipse.cdt.internal.core.parser.scanner2.FileCodeReaderFactory;
import org.eclipse.cdt.internal.core.parser.scanner2.GCCScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.GPPScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.IScannerExtensionConfiguration;

public class CompletionTestBase
extends TestCase {
    private static final IParserLogService NULL_LOG = new NullLogService();
    private static BindingsComparator bindingsComparator = new BindingsComparator();

    protected ASTCompletionNode getCompletionNode(String string, ParserLanguage parserLanguage, boolean bl) throws ParserException {
        CodeReader codeReader = new CodeReader(string.toCharArray());
        ScannerInfo scannerInfo = new ScannerInfo();
        Object object = null;
        object = parserLanguage == ParserLanguage.C ? new GCCScannerExtensionConfiguration() : new GPPScannerExtensionConfiguration();
        DOMScanner dOMScanner = new DOMScanner(codeReader, (IScannerInfo)scannerInfo, ParserMode.COMPLETE_PARSE, parserLanguage, NULL_LOG, (IScannerExtensionConfiguration)object, (ICodeReaderFactory)FileCodeReaderFactory.getInstance());
        GNUCPPSourceParser gNUCPPSourceParser = null;
        if (parserLanguage == ParserLanguage.CPP) {
            Object object2 = null;
            object2 = bl ? new GPPParserExtensionConfiguration() : new ANSICPPParserExtensionConfiguration();
            gNUCPPSourceParser = new GNUCPPSourceParser((IScanner)dOMScanner, ParserMode.COMPLETE_PARSE, NULL_LOG, (ICPPParserExtensionConfiguration)object2);
        } else {
            Object object3 = null;
            object3 = bl ? new GCCParserExtensionConfiguration() : new ANSICParserExtensionConfiguration();
            gNUCPPSourceParser = new GNUCSourceParser((IScanner)dOMScanner, ParserMode.COMPLETE_PARSE, NULL_LOG, (ICParserExtensionConfiguration)object3);
        }
        dOMScanner.setContentAssistMode(string.length());
        gNUCPPSourceParser.parse();
        return gNUCPPSourceParser.getCompletionNode();
    }

    protected ASTCompletionNode getGPPCompletionNode(String string) throws ParserException {
        return this.getCompletionNode(string, ParserLanguage.CPP, true);
    }

    protected ASTCompletionNode getGCCCompletionNode(String string) throws ParserException {
        return this.getCompletionNode(string, ParserLanguage.C, true);
    }

    protected IBinding[] sortBindings(IBinding[] iBindingArray) {
        Arrays.sort(iBindingArray, bindingsComparator);
        return iBindingArray;
    }

    private static class BindingsComparator
    implements Comparator {
        BindingsComparator() {
        }

        public int compare(Object object, Object object2) {
            IBinding iBinding = (IBinding)object;
            IBinding iBinding2 = (IBinding)object2;
            return iBinding.getName().compareTo(iBinding2.getName());
        }
    }
}

