/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.search.tests;

import java.io.FileInputStream;
import java.io.InputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorOperation;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.core.testplugin.CTestPlugin;
import org.eclipse.cdt.core.testplugin.FileManager;
import org.eclipse.cdt.internal.core.index.cindexstorage.Index;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexer;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexerRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class BaseSearchTest
extends TestCase
implements ICSearchConstants {
    protected static ICSearchScope scope;
    protected static IFile file;
    protected static IProject testProject;
    protected static NullProgressMonitor monitor;
    protected static IWorkspace workspace;
    protected static BasicSearchResultCollector resultCollector;
    protected static SearchEngine searchEngine;
    protected static FileManager fileManager;
    static final String sourceIndexerID = "org.eclipse.cdt.core.originalsourceindexer";
    protected static DOMSourceIndexer sourceIndexer;

    public BaseSearchTest(String string) {
        super(string);
        monitor = new NullProgressMonitor();
        workspace = ResourcesPlugin.getWorkspace();
        CCorePlugin.getDefault().getPluginPreferences().setValue("indexer", "org.eclipse.cdt.core.domsourceindexer");
        try {
            testProject = this.createProject("SearchTestProject");
            testProject.setSessionProperty(DOMSourceIndexer.activationKey, (Object)new Boolean(true));
            sourceIndexer = (DOMSourceIndexer)CCorePlugin.getDefault().getCoreModel().getIndexManager().getIndexerForProject(testProject);
        }
        catch (CoreException coreException) {}
        this.resetIndexer("org.eclipse.cdt.core.domsourceindexer");
        DOMSourceIndexerRunner.setSkipScannerInfoTest((boolean)true);
        if (testProject == null) {
            Assert.fail((String)"Unable to create project");
        }
        fileManager = new FileManager();
        try {
            this.importFile("classDecl.cpp", "resources/search/classDecl.cpp");
            this.importFile("include.h", "resources/search/include.h");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        scope = SearchEngine.createWorkspaceScope();
        resultCollector = new BasicSearchResultCollector();
        searchEngine = new SearchEngine();
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() {
    }

    private IProject createProject(String string) throws CoreException {
        ICProject iCProject = CProjectHelper.createCCProject(string, "bin");
        return iCProject.getProject();
    }

    private void importFile(String string, String string2) throws Exception {
        file = testProject.getProject().getFile(string);
        if (!file.exists()) {
            file.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path(string2))), false, (IProgressMonitor)monitor);
            fileManager.addFile(file);
        }
    }

    protected char[] getSearchPattern(int n, int n2, int n3, String string) {
        return Index.encodeEntry((int)n, (int)n2, (int)n3, (String)string);
    }

    public void assertEquals(char[] cArray, char[] cArray2) {
        Assert.assertEquals((String)new String(cArray), (String)new String(cArray2));
    }

    protected void search(IWorkspace iWorkspace, ICSearchPattern iCSearchPattern, ICSearchScope iCSearchScope, ICSearchResultCollector iCSearchResultCollector) {
        try {
            searchEngine.search(iWorkspace, iCSearchPattern, iCSearchScope, iCSearchResultCollector, false);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void resetIndexer(final String string) {
        if (testProject != null) {
            ICDescriptorOperation iCDescriptorOperation = new ICDescriptorOperation(){

                public void execute(ICDescriptor iCDescriptor, IProgressMonitor iProgressMonitor) throws CoreException {
                    iCDescriptor.remove("org.eclipse.cdt.core.CIndexer");
                    iCDescriptor.create("org.eclipse.cdt.core.CIndexer", string);
                }
            };
            try {
                CCorePlugin.getDefault().getCDescriptorManager().runDescriptorOperation(testProject, iCDescriptorOperation, (IProgressMonitor)new NullProgressMonitor());
                CCorePlugin.getDefault().getCoreModel().getIndexManager().indexerChangeNotification(testProject);
            }
            catch (CoreException coreException) {}
        }
    }
}

