/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.search.tests;

import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.core.search.IOffsetLocatable;
import org.eclipse.cdt.core.search.OrPattern;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.core.search.tests.BaseSearchTest;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.search.matching.ClassDeclarationPattern;

public class ClassDeclarationPatternTests
extends BaseSearchTest
implements ICSearchConstants {
    public ClassDeclarationPatternTests(String string) {
        super(string);
    }

    public void testMatchSimpleDeclaration() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"A", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)false);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof ClassDeclarationPattern));
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)2, (int)set.size());
    }

    public void testMatchNamespaceNestedDeclaration() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"NS::B", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof ClassDeclarationPattern));
        ClassDeclarationPattern classDeclarationPattern = (ClassDeclarationPattern)iCSearchPattern;
        Assert.assertTrue((boolean)CharOperation.equals((char[])new char[]{'B'}, (char[])classDeclarationPattern.getName()));
        Assert.assertTrue((classDeclarationPattern.getContainingTypes().length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)CharOperation.equals((char[])new char[]{'N', 'S'}, (char[])classDeclarationPattern.getContainingTypes()[0]));
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)1, (int)set.size());
    }

    public void testBug39652() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"A::B", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertTrue((set != null ? 1 : 0) != 0);
        Assert.assertTrue((set.size() == 1 ? 1 : 0) != 0);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"NS::NS2::a", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertTrue((set != null ? 1 : 0) != 0);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"NS::B::AA", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertTrue((set != null ? 1 : 0) != 0);
    }

    public void testMatchStruct() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"AA", (ICSearchConstants.SearchFor)ICSearchConstants.STRUCT, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof ClassDeclarationPattern));
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"NS::B::AA", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set2 = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertTrue((set2 != null ? 1 : 0) != 0);
        Assert.assertEquals((int)set2.size(), (int)1);
        Iterator iterator = set.iterator();
        Iterator iterator2 = set2.iterator();
        IMatch iMatch = (IMatch)iterator.next();
        IMatch iMatch2 = (IMatch)iterator2.next();
        Assert.assertEquals((int)((IOffsetLocatable)iMatch.getLocatable()).getNameStartOffset(), (int)((IOffsetLocatable)iMatch2.getLocatable()).getNameStartOffset());
        Assert.assertEquals((int)((IOffsetLocatable)iMatch.getLocatable()).getNameEndOffset(), (int)((IOffsetLocatable)iMatch2.getLocatable()).getNameEndOffset());
    }

    public void testWildcardQualification() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"::*::A", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)0);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"NS::*::A", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)false);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
    }

    public void testElaboratedType() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"struct AA", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"union u", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)2);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"union ::*::u", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
    }

    public void testClassIndexPrefix() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"struct A::B::*::c", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof ClassDeclarationPattern));
        ClassDeclarationPattern classDeclarationPattern = (ClassDeclarationPattern)iCSearchPattern;
        this.assertEquals(this.getSearchPattern(1, 2, 1, "c/"), classDeclarationPattern.indexEntryPrefix());
        classDeclarationPattern = (ClassDeclarationPattern)SearchEngine.createSearchPattern((String)"class ::*::A::B::c", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.assertEquals(this.getSearchPattern(1, 1, 1, "c/B/A/"), classDeclarationPattern.indexEntryPrefix());
        classDeclarationPattern = (ClassDeclarationPattern)SearchEngine.createSearchPattern((String)"enum ::RT*::c", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.assertEquals(this.getSearchPattern(1, 4, 2, "c/RT"), classDeclarationPattern.indexEntryPrefix());
        classDeclarationPattern = (ClassDeclarationPattern)SearchEngine.createSearchPattern((String)"union A::B::c", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)false);
        this.assertEquals(this.getSearchPattern(1, 3, 2, ""), classDeclarationPattern.indexEntryPrefix());
    }

    public void testGloballyQualifiedItem() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"::A", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof ClassDeclarationPattern));
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"::u", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof ClassDeclarationPattern));
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
    }

    public void testClassReferences() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"::A", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)6, (int)set.size());
    }

    public void testClassReferenceInFieldType() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"::NS::B::AA", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
    }

    public void testTypeReferenceVisibleByUsingDirective() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"::NS::NS2::a", (ICSearchConstants.SearchFor)ICSearchConstants.STRUCT, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
    }

    public void testEnumerationReferenceVisibleByInheritance() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"::NS::B::e", (ICSearchConstants.SearchFor)ICSearchConstants.ENUM, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
    }

    public void testHeadersVisitedTwice() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"Hea*", (ICSearchConstants.SearchFor)ICSearchConstants.CLASS, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)2);
    }

    public void testAllOccurences() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"A", (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof OrPattern));
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)8, (int)set.size());
    }

    public void testReferencesInFunction() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"AClassForFoo", (ICSearchConstants.SearchFor)ICSearchConstants.CLASS, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)3);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IMatch iMatch = (IMatch)iterator.next();
            Assert.assertTrue((boolean)iMatch.getName().equals("AClassForFoo"));
        }
    }

    public void testbug42902_TypeDefs() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"NS_B", (ICSearchConstants.SearchFor)ICSearchConstants.TYPEDEF, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)2);
    }
}

