/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.search.tests;

import java.util.Set;
import junit.framework.Assert;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.core.search.IOffsetLocatable;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.core.search.tests.BaseSearchTest;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.search.matching.MethodDeclarationPattern;

public class FunctionMethodPatternTests
extends BaseSearchTest {
    public FunctionMethodPatternTests(String string) {
        super(string);
    }

    public void testFunctionIndexPrefix() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"c()", (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        MethodDeclarationPattern methodDeclarationPattern = (MethodDeclarationPattern)iCSearchPattern;
        this.assertEquals(this.getSearchPattern(2, 0, 1, "c"), methodDeclarationPattern.indexEntryPrefix());
        methodDeclarationPattern = (MethodDeclarationPattern)SearchEngine.createSearchPattern((String)"rt*()", (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.assertEquals(this.getSearchPattern(2, 0, 1, "rt"), methodDeclarationPattern.indexEntryPrefix());
        methodDeclarationPattern = (MethodDeclarationPattern)SearchEngine.createSearchPattern((String)"Ac", (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)false);
        this.assertEquals(this.getSearchPattern(2, 0, 2, ""), methodDeclarationPattern.indexEntryPrefix());
    }

    public void testMethodIndexPrefix() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"A::B::c", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof MethodDeclarationPattern));
        MethodDeclarationPattern methodDeclarationPattern = (MethodDeclarationPattern)iCSearchPattern;
        this.assertEquals(this.getSearchPattern(3, 0, 1, "c/B/A"), methodDeclarationPattern.indexEntryPrefix());
        methodDeclarationPattern = (MethodDeclarationPattern)SearchEngine.createSearchPattern((String)"::*::A::B::c", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.assertEquals(this.getSearchPattern(3, 0, 1, "c/B/A/"), methodDeclarationPattern.indexEntryPrefix());
        methodDeclarationPattern = (MethodDeclarationPattern)SearchEngine.createSearchPattern((String)"::RT*::c", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.assertEquals(this.getSearchPattern(3, 0, 2, "c/RT"), methodDeclarationPattern.indexEntryPrefix());
        methodDeclarationPattern = (MethodDeclarationPattern)SearchEngine.createSearchPattern((String)"A::B::c", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)false);
        this.assertEquals(this.getSearchPattern(3, 0, 2, ""), methodDeclarationPattern.indexEntryPrefix());
    }

    public void testMethodDeclaration() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"A::B::f", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)4);
    }

    public void testMethodDeclarationWithParams() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"A::B::f( A )", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)1, (int)set.size());
    }

    public void testMethodDeclarationParameterMatching() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"f( A & )", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)1, (int)set.size());
        iCSearchPattern = SearchEngine.createSearchPattern((String)"f( A * )", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)1, (int)set.size());
        iCSearchPattern = SearchEngine.createSearchPattern((String)"f( int &, const char  [],  A** )", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)1, (int)set.size());
    }

    public void testMethodWithNoParameters() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"turn( )", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)2, (int)set.size());
        iCSearchPattern = SearchEngine.createSearchPattern((String)"turn(void)", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS_DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)2, (int)set.size());
        iCSearchPattern = SearchEngine.createSearchPattern((String)"turnAgain()", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)1, (int)set.size());
    }

    public void testOperators_bug43063_bug42979() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"operator \\*", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS_DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        IMatch iMatch = (IMatch)set.iterator().next();
        iCSearchPattern = SearchEngine.createSearchPattern((String)"operator \\*", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        IMatch iMatch2 = (IMatch)set.iterator().next();
        Assert.assertTrue((((IOffsetLocatable)iMatch.getLocatable()).getNameStartOffset() == ((IOffsetLocatable)iMatch2.getLocatable()).getNameStartOffset() ? 1 : 0) != 0);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"operator \\*=", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iMatch = (IMatch)set.iterator().next();
        iCSearchPattern = SearchEngine.createSearchPattern((String)"operator \\*=", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iMatch2 = (IMatch)set.iterator().next();
        Assert.assertTrue((((IOffsetLocatable)iMatch.getLocatable()).getNameStartOffset() != ((IOffsetLocatable)iMatch2.getLocatable()).getNameStartOffset() ? 1 : 0) != 0);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"operator *", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)5);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"operator *", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS_DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)8);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"operator ->\\*", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof MethodDeclarationPattern));
        MethodDeclarationPattern methodDeclarationPattern = (MethodDeclarationPattern)iCSearchPattern;
        char[] cArray = new char[]{'o', 'p', 'e', 'r', 'a', 't', 'o', 'r', ' ', '-', '>', '\\', '*'};
        Assert.assertTrue((boolean)CharOperation.equals((char[])cArray, (char[])methodDeclarationPattern.getSimpleName()));
    }

    public void testBug43498() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"operator ?elete", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof MethodDeclarationPattern));
        MethodDeclarationPattern methodDeclarationPattern = (MethodDeclarationPattern)iCSearchPattern;
        char[] cArray = new char[]{'o', 'p', 'e', 'r', 'a', 't', 'o', 'r', ' ', '?', 'e', 'l', 'e', 't', 'e'};
        Assert.assertTrue((boolean)CharOperation.equals((char[])cArray, (char[])methodDeclarationPattern.getSimpleName()));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"operator delete", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof MethodDeclarationPattern));
        methodDeclarationPattern = (MethodDeclarationPattern)iCSearchPattern;
        cArray = new char[]{'o', 'p', 'e', 'r', 'a', 't', 'o', 'r', ' ', 'd', 'e', 'l', 'e', 't', 'e'};
        Assert.assertTrue((boolean)CharOperation.equals((char[])cArray, (char[])methodDeclarationPattern.getSimpleName()));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"word?word", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof MethodDeclarationPattern));
        methodDeclarationPattern = (MethodDeclarationPattern)iCSearchPattern;
        cArray = new char[]{'w', 'o', 'r', 'd', '?', 'w', 'o', 'r', 'd'};
        Assert.assertTrue((boolean)CharOperation.equals((char[])cArray, (char[])methodDeclarationPattern.getSimpleName()));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"operato? delete", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof MethodDeclarationPattern));
        methodDeclarationPattern = (MethodDeclarationPattern)iCSearchPattern;
        cArray = new char[]{'o', 'p', 'e', 'r', 'a', 't', 'o', '?', ' ', 'd', 'e', 'l', 'e', 't', 'e'};
        Assert.assertTrue((boolean)CharOperation.equals((char[])cArray, (char[])methodDeclarationPattern.getSimpleName()));
    }

    public void testBug43062() {
        MethodDeclarationPattern methodDeclarationPattern = (MethodDeclarationPattern)SearchEngine.createSearchPattern((String)"operator const short &", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        char[] cArray = new char[]{'o', 'p', 'e', 'r', 'a', 't', 'o', 'r', ' ', 'c', 'o', 'n', 's', 't', ' ', 's', 'h', 'o', 'r', 't', ' ', '&'};
        Assert.assertTrue((boolean)CharOperation.equals((char[])cArray, (char[])methodDeclarationPattern.getSimpleName()));
        methodDeclarationPattern = (MethodDeclarationPattern)SearchEngine.createSearchPattern((String)"operator short", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        cArray = new char[]{'o', 'p', 'e', 'r', 'a', 't', 'o', 'r', ' ', 's', 'h', 'o', 'r', 't'};
        Assert.assertTrue((boolean)CharOperation.equals((char[])cArray, (char[])methodDeclarationPattern.getSimpleName()));
        methodDeclarationPattern = (MethodDeclarationPattern)SearchEngine.createSearchPattern((String)"operator short int", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        cArray = new char[]{'o', 'p', 'e', 'r', 'a', 't', 'o', 'r', ' ', 's', 'h', 'o', 'r', 't', ' ', 'i', 'n', 't'};
        Assert.assertTrue((boolean)CharOperation.equals((char[])cArray, (char[])methodDeclarationPattern.getSimpleName()));
    }

    public void testConstructorDestructor() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"A", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS_DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"~A", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS_DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
    }

    public void testLookupForDefinition() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"turn", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS_DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)3);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"Direction::turn", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)0);
    }

    public void testBug63478() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"A::B::f(*)", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)4);
    }
}

