/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.search.tests;

import java.util.Set;
import junit.framework.Assert;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.core.search.tests.BaseSearchTest;
import org.eclipse.cdt.core.testplugin.CTestPlugin;
import org.eclipse.cdt.internal.core.search.matching.FieldDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.MatchLocator;
import org.eclipse.cdt.internal.core.search.matching.NamespaceDeclarationPattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class OtherPatternTests
extends BaseSearchTest {
    public OtherPatternTests(String string) {
        super(string);
    }

    public void testNamespaceIndexPrefix() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"A::B::c", (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof NamespaceDeclarationPattern));
        NamespaceDeclarationPattern namespaceDeclarationPattern = (NamespaceDeclarationPattern)iCSearchPattern;
        this.assertEquals(this.getSearchPattern(6, 0, 3, "c/B/A"), namespaceDeclarationPattern.indexEntryPrefix());
        namespaceDeclarationPattern = (NamespaceDeclarationPattern)SearchEngine.createSearchPattern((String)"::*::A::B::c", (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.assertEquals(this.getSearchPattern(6, 0, 3, "c/B/A/"), namespaceDeclarationPattern.indexEntryPrefix());
        namespaceDeclarationPattern = (NamespaceDeclarationPattern)SearchEngine.createSearchPattern((String)"::RT*::c", (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.assertEquals(this.getSearchPattern(6, 0, 2, "c/RT"), namespaceDeclarationPattern.indexEntryPrefix());
        namespaceDeclarationPattern = (NamespaceDeclarationPattern)SearchEngine.createSearchPattern((String)"A::B::c", (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)false);
        this.assertEquals(this.getSearchPattern(6, 0, 2, ""), namespaceDeclarationPattern.indexEntryPrefix());
    }

    public void testVariableIndexPrefix() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"c", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof FieldDeclarationPattern));
        FieldDeclarationPattern fieldDeclarationPattern = (FieldDeclarationPattern)iCSearchPattern;
        this.assertEquals(this.getSearchPattern(9, 0, 1, "c"), fieldDeclarationPattern.indexEntryPrefix());
        fieldDeclarationPattern = (FieldDeclarationPattern)SearchEngine.createSearchPattern((String)"rt*", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.assertEquals(this.getSearchPattern(9, 0, 1, "rt"), fieldDeclarationPattern.indexEntryPrefix());
        fieldDeclarationPattern = (FieldDeclarationPattern)SearchEngine.createSearchPattern((String)"Ac", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)false);
        this.assertEquals(this.getSearchPattern(9, 0, 2, ""), fieldDeclarationPattern.indexEntryPrefix());
        fieldDeclarationPattern = (FieldDeclarationPattern)SearchEngine.createSearchPattern((String)"A?c", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.assertEquals(this.getSearchPattern(9, 0, 2, "A"), fieldDeclarationPattern.indexEntryPrefix());
    }

    public void testFieldIndexPrefix() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"A::B::c", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof FieldDeclarationPattern));
        FieldDeclarationPattern fieldDeclarationPattern = (FieldDeclarationPattern)iCSearchPattern;
        this.assertEquals(this.getSearchPattern(4, 0, 1, "c/B/A"), fieldDeclarationPattern.indexEntryPrefix());
        fieldDeclarationPattern = (FieldDeclarationPattern)SearchEngine.createSearchPattern((String)"::*::A::B::c", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.assertEquals(this.getSearchPattern(4, 0, 1, "c/B/A/"), fieldDeclarationPattern.indexEntryPrefix());
        fieldDeclarationPattern = (FieldDeclarationPattern)SearchEngine.createSearchPattern((String)"::RT*::c", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.assertEquals(this.getSearchPattern(4, 0, 2, "c/RT"), fieldDeclarationPattern.indexEntryPrefix());
        fieldDeclarationPattern = (FieldDeclarationPattern)SearchEngine.createSearchPattern((String)"A::B::c", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)false);
        this.assertEquals(this.getSearchPattern(4, 0, 2, ""), fieldDeclarationPattern.indexEntryPrefix());
    }

    public void testNamespaceDeclaration() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"NS*", (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)3);
    }

    public void testNamespaceReferenceInUsingDirective() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"::NS::NS2", (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
    }

    public void testNamespaceReferenceInClassBaseClause() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"::NS", (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)2);
    }

    public void testFieldDeclaration() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"a*Struct", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
    }

    public void testVariableDeclaration() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"b?", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)2);
        IMatch iMatch = (IMatch)set.iterator().next();
        Assert.assertTrue((boolean)iMatch.getParentName().equals(""));
    }

    public void testMacroPattern() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"FOO", (ICSearchConstants.SearchFor)ICSearchConstants.MACRO, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        IMatch iMatch = (IMatch)set.iterator().next();
        Assert.assertTrue((boolean)iMatch.getName().equals("FOO"));
        Assert.assertTrue((boolean)iMatch.getParentName().equals(""));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"FOO", (ICSearchConstants.SearchFor)ICSearchConstants.MACRO, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
    }

    public void testDerived() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"A", (ICSearchConstants.SearchFor)ICSearchConstants.DERIVED, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        IMatch iMatch = (IMatch)set.iterator().next();
        Assert.assertTrue((boolean)iMatch.getName().equals("A"));
    }

    public void testEnumerators() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"One", (ICSearchConstants.SearchFor)ICSearchConstants.ENUMTOR, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        IMatch iMatch = (IMatch)set.iterator().next();
        Assert.assertTrue((boolean)iMatch.getName().equals("One"));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"NS::B::Two", (ICSearchConstants.SearchFor)ICSearchConstants.ENUMTOR, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iMatch = (IMatch)set.iterator().next();
        Assert.assertTrue((boolean)iMatch.getName().equals("Two"));
    }

    public void testEnumeratorReferences() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"One", (ICSearchConstants.SearchFor)ICSearchConstants.ENUMTOR, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        IMatch iMatch = (IMatch)set.iterator().next();
        Assert.assertTrue((boolean)iMatch.getName().equals("One"));
    }

    public void testNoResourceSearching() throws Exception {
        String string = CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/search/include.h")).getAbsolutePath();
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"Head", (ICSearchConstants.SearchFor)ICSearchConstants.CLASS, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        BaseSearchTest.resultCollector.aboutToStart();
        MatchLocator matchLocator = new MatchLocator(iCSearchPattern, (ICSearchResultCollector)BaseSearchTest.resultCollector, BaseSearchTest.scope);
        matchLocator.setProgressMonitor((IProgressMonitor)BaseSearchTest.monitor);
        try {
            matchLocator.locateMatches(new String[]{string}, BaseSearchTest.workspace, null);
        }
        catch (InterruptedException interruptedException) {}
        BaseSearchTest.resultCollector.done();
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)4);
    }

    public void testBug42911_43988() {
        BasicSearchMatch basicSearchMatch = new BasicSearchMatch();
        BasicSearchMatch basicSearchMatch2 = new BasicSearchMatch();
        Assert.assertTrue((boolean)basicSearchMatch.equals((Object)basicSearchMatch2));
        Assert.assertTrue((boolean)basicSearchMatch2.equals((Object)basicSearchMatch));
        basicSearchMatch.setName("IWasSaying");
        basicSearchMatch.setParentName("boo");
        basicSearchMatch.setReturnType("urns");
        Assert.assertFalse((boolean)basicSearchMatch.equals((Object)basicSearchMatch2));
        Assert.assertFalse((boolean)basicSearchMatch2.equals((Object)basicSearchMatch));
        basicSearchMatch2.setName("IWasSaying");
        basicSearchMatch2.setParentName("boo");
        basicSearchMatch2.setReturnType("urns");
        Assert.assertTrue((boolean)basicSearchMatch.equals((Object)basicSearchMatch2));
    }

    public void testBug68235() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"bug68235::xTag", (ICSearchConstants.SearchFor)ICSearchConstants.STRUCT, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        Set set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"bug68235::yTag", (ICSearchConstants.SearchFor)ICSearchConstants.STRUCT, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"bug68235::xType", (ICSearchConstants.SearchFor)ICSearchConstants.TYPEDEF, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"bug68235::yType", (ICSearchConstants.SearchFor)ICSearchConstants.TYPEDEF, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"bug68235::xType", (ICSearchConstants.SearchFor)ICSearchConstants.TYPEDEF, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"bug68235::yType", (ICSearchConstants.SearchFor)ICSearchConstants.TYPEDEF, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.search(BaseSearchTest.workspace, iCSearchPattern, BaseSearchTest.scope, (ICSearchResultCollector)BaseSearchTest.resultCollector);
        set = BaseSearchTest.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
    }
}

