/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.DOMAST;

import org.eclipse.cdt.core.browser.PathUtil;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.core.search.IMatchLocatable;
import org.eclipse.cdt.core.search.OffsetLocatable;
import org.eclipse.cdt.internal.ui.search.CSearchQuery;
import org.eclipse.cdt.internal.ui.search.CSearchResult;
import org.eclipse.cdt.internal.ui.search.NewSearchResultCollector;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class DOMDisplaySearchNames
extends CSearchQuery
implements ISearchQuery {
    private static final String BLANK_STRING = "";
    private CSearchResult _result;
    private IASTNode[] nodes = null;
    private String queryLabel = null;

    public DOMDisplaySearchNames(IASTNode[] iASTNodeArray, String string, String string2) {
        super(CUIPlugin.getWorkspace(), string2, false, null, null, null, string);
        this.nodes = iASTNodeArray;
        this.queryLabel = string;
    }

    public IStatus run(IProgressMonitor iProgressMonitor) throws OperationCanceledException {
        CSearchResult cSearchResult = (CSearchResult)this.getSearchResult();
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1000);
        NewSearchResultCollector newSearchResultCollector = new NewSearchResultCollector(cSearchResult, (IProgressMonitor)subProgressMonitor);
        newSearchResultCollector.aboutToStart();
        int n = 0;
        while (n < this.nodes.length) {
            try {
                String string = null;
                Path path = null;
                int n2 = 0;
                int n3 = 0;
                if (this.nodes[n] != null) {
                    IASTFileLocation iASTFileLocation = this.nodes[n].getFileLocation();
                    if (iASTFileLocation == null) {
                        return new Status(4, CUIPlugin.getPluginId(), 0, "Null Location associated with IASTFileLocation.", null);
                    }
                    string = iASTFileLocation.getFileName();
                    n2 = iASTFileLocation.getNodeOffset();
                    n3 = iASTFileLocation.getNodeOffset() + iASTFileLocation.getNodeLength();
                    path = new Path(string);
                    Object object = null;
                    IResource iResource = ParserUtil.getResourceForFilename((String)string);
                    object = iResource != null ? iResource : PathUtil.getWorkspaceRelativePath((String)string);
                    newSearchResultCollector.acceptMatch(this.createMatch(object, n2, n3, this.nodes[n], (IPath)path));
                }
            }
            catch (CoreException coreException) {}
            ++n;
        }
        subProgressMonitor.done();
        newSearchResultCollector.done();
        return new Status(0, CUIPlugin.getPluginId(), 0, BLANK_STRING, null);
    }

    public IMatch createMatch(Object object, int n, int n2, IASTNode iASTNode, IPath iPath) {
        BasicSearchMatch basicSearchMatch = new BasicSearchMatch();
        if (object instanceof IResource) {
            basicSearchMatch.setResource((IResource)object);
        } else if (object instanceof IPath) {
            basicSearchMatch.setPath((IPath)object);
        }
        OffsetLocatable offsetLocatable = new OffsetLocatable(n, n2);
        basicSearchMatch.setLocatable((IMatchLocatable)offsetLocatable);
        basicSearchMatch.setParentName(BLANK_STRING);
        basicSearchMatch.setReferringElement(iPath);
        if (iASTNode instanceof IASTName) {
            basicSearchMatch.setName(iASTNode.toString());
        } else if (iASTNode instanceof IASTProblem) {
            basicSearchMatch.setName(((IASTProblem)iASTNode).getMessage());
        } else {
            basicSearchMatch.setName(iASTNode.toString());
        }
        if (iASTNode instanceof IASTName) {
            IBinding iBinding = ((IASTName)iASTNode).resolveBinding();
            if (iBinding instanceof ICPPClassType) {
                basicSearchMatch.setType(65);
            } else if (iBinding instanceof ICompositeType) {
                int n3 = 1;
                try {
                    n3 = ((ICompositeType)iBinding).getKey();
                }
                catch (DOMException dOMException) {}
                switch (n3) {
                    case 1: {
                        basicSearchMatch.setType(67);
                        break;
                    }
                    case 2: {
                        basicSearchMatch.setType(69);
                    }
                }
            } else if (iBinding instanceof ICPPNamespace) {
                basicSearchMatch.setType(61);
            } else if (iBinding instanceof IEnumeration) {
                basicSearchMatch.setType(63);
            } else if (iBinding instanceof IMacroBinding) {
                basicSearchMatch.setType(79);
            } else if (iBinding instanceof IField) {
                basicSearchMatch.setType(72);
                try {
                    basicSearchMatch.setStatic(((IField)iBinding).isStatic());
                }
                catch (DOMException dOMException) {}
                if (iBinding instanceof ICPPMember) {
                    try {
                        switch (((ICPPMember)iBinding).getVisibility()) {
                            case 3: {
                                basicSearchMatch.setVisibility(4096);
                                break;
                            }
                            case 1: {
                                basicSearchMatch.setVisibility(8192);
                            }
                        }
                    }
                    catch (DOMException dOMException) {}
                }
                try {
                    basicSearchMatch.setConst(ASTTypeUtil.isConst((IType)((IField)iBinding).getType()));
                }
                catch (DOMException dOMException) {}
            } else if (iBinding instanceof IVariable) {
                basicSearchMatch.setType(76);
                try {
                    basicSearchMatch.setConst(ASTTypeUtil.isConst((IType)((IVariable)iBinding).getType()));
                }
                catch (DOMException dOMException) {}
            } else if (iBinding instanceof IEnumerator) {
                basicSearchMatch.setType(81);
            } else if (iBinding instanceof ICPPMethod) {
                basicSearchMatch.setType(70);
                if (iBinding instanceof ICPPMember) {
                    try {
                        switch (((ICPPMember)iBinding).getVisibility()) {
                            case 3: {
                                basicSearchMatch.setVisibility(4096);
                                break;
                            }
                            case 1: {
                                basicSearchMatch.setVisibility(8192);
                            }
                        }
                    }
                    catch (DOMException dOMException) {}
                }
                try {
                    basicSearchMatch.setConst(ASTTypeUtil.isConst((IType)((ICPPMethod)iBinding).getType()));
                }
                catch (DOMException dOMException) {}
            } else if (iBinding instanceof IFunction) {
                basicSearchMatch.setType(74);
                try {
                    basicSearchMatch.setStatic(((IFunction)iBinding).isStatic());
                }
                catch (DOMException dOMException) {}
            } else if (iBinding instanceof ITypedef) {
                basicSearchMatch.setType(80);
            }
        } else {
            basicSearchMatch.setType(93);
        }
        basicSearchMatch.setReturnType(BLANK_STRING);
        return basicSearchMatch;
    }

    public String getLabel() {
        return this.queryLabel;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this._result == null) {
            this._result = new CSearchResult((CSearchQuery)this);
        }
        return this._result;
    }
}

