/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.IndexerView;

import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.tests.IndexerView.IndexerFilterManager;
import org.eclipse.cdt.ui.tests.IndexerView.IndexerNodeParent;
import org.eclipse.cdt.ui.tests.IndexerView.IndexerViewPluginImages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FilterIndexerViewDialog
extends Dialog {
    private static final int DECL_BUTTON_ID = 3;
    private static final int REF_BUTTON_ID = 2;
    private static final int TYPE_BUTTON_ID = 1;
    private static final int ALL_BUTTON_ID = 0;
    private static final String GROUPED_SELECTIONS_LABEL = "Grouped Selections:";
    private static final String ALL_BUTTON = "All";
    private static final String TYPE_BUTTON = "type";
    private static final String DECL_BUTTON = "Decl";
    private static final String REF_BUTTON = "Ref";
    private static final String BLANK_STRING = "";
    private static final String PAGE_SIZE_ = "Page Size:";
    private static final String TYPESELECTIONDIALOG_DeclLABEL = "Declarations:";
    private static final String TYPESELECTIONDIALOG_RefLABEL = "References:";
    private static final String FILTER_INDEXER_RESULTS = "Filter Indexer Results";
    private static final String SETTINGS = "Settings";
    private static final String PAGE_SIZE = "PAGE_SIZE";
    private static final String FILTER_TEXT = "Filter";
    private String fFilter = "";
    Text filterText = null;
    private int pageSize = 40;
    Text pageSizeText = null;
    protected boolean[] fFilterMatcher = new boolean[iAllTypes.length];
    protected boolean[] groupedButtonSelections;
    private String message = "Filter Indexer Results (. = any character, .* = any string):";
    public static final int ENTRY_MACRO_DECL = 0;
    public static final int ENTRY_FUNCTION_DECL = 1;
    public static final int ENTRY_NAMESPACE_DECL = 2;
    public static final int ENTRY_FUNCTION_REF = 3;
    public static final int ENTRY_NAMESPACE_REF = 4;
    public static final int ENTRY_FIELD_DECL = 5;
    public static final int ENTRY_ENUMTOR_DECL = 6;
    public static final int ENTRY_METHOD_DECL = 7;
    public static final int ENTRY_FIELD_REF = 8;
    public static final int ENTRY_ENUMTOR_REF = 9;
    public static final int ENTRY_METHOD_REF = 10;
    public static final int ENTRY_TYPE_REF = 11;
    public static final int ENTRY_TYPE_DECL_TYPEDEF = 12;
    public static final int ENTRY_TYPE_DECL_CLASS = 13;
    public static final int ENTRY_TYPE_DECL_VAR = 14;
    public static final int ENTRY_TYPE_DECL_STRUCT = 15;
    public static final int ENTRY_TYPE_DECL_ENUM = 16;
    public static final int ENTRY_TYPE_DECL_UNION = 17;
    public static final int ENTRY_TYPE_DECL_DERIVED = 18;
    public static final int ENTRY_TYPE_DECL_FRIEND = 19;
    public static final int ENTRY_INCLUDE_REF = 20;
    private String fDialogSection;
    private static final String DIALOG_SETTINGS;
    private static final String SETTINGS_X_POS = "x";
    private static final String SETTINGS_Y_POS = "y";
    private static final String SETTINGS_WIDTH = "width";
    private static final String SETTINGS_HEIGHT = "height";
    private Point fLocation;
    private Point fSize;
    IndexerNodeParent root = null;
    private String projName = null;
    private static int[][] iAllTypes;
    private static String[] buttonNames;
    protected Button[] buttons = new Button[iAllTypes.length];
    protected Button allButton = null;
    protected Button typeButton = null;
    protected Button declButton = null;
    protected Button refButton = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.ui.tests.IndexerView.FilterIndexerViewDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DIALOG_SETTINGS = clazz.getName();
        int[][] nArrayArray = new int[21][];
        int[] nArray = new int[3];
        nArray[0] = 5;
        nArray[2] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 2;
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 6;
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = 2;
        nArray4[2] = 2;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 6;
        nArray5[2] = 2;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 4;
        nArray6[2] = 1;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[3];
        nArray7[0] = 7;
        nArray7[2] = 1;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[3];
        nArray8[0] = 3;
        nArray8[2] = 1;
        nArrayArray[7] = nArray8;
        int[] nArray9 = new int[3];
        nArray9[0] = 4;
        nArray9[2] = 2;
        nArrayArray[8] = nArray9;
        int[] nArray10 = new int[3];
        nArray10[0] = 7;
        nArray10[2] = 2;
        nArrayArray[9] = nArray10;
        int[] nArray11 = new int[3];
        nArray11[0] = 3;
        nArray11[2] = 2;
        nArrayArray[10] = nArray11;
        int[] nArray12 = new int[3];
        nArray12[0] = 1;
        nArray12[2] = 2;
        nArrayArray[11] = nArray12;
        nArrayArray[12] = new int[]{1, 5, 1};
        nArrayArray[13] = new int[]{1, 1, 1};
        int[] nArray13 = new int[3];
        nArray13[0] = 9;
        nArray13[2] = 1;
        nArrayArray[14] = nArray13;
        nArrayArray[15] = new int[]{1, 2, 1};
        nArrayArray[16] = new int[]{1, 4, 1};
        nArrayArray[17] = new int[]{1, 3, 1};
        nArrayArray[18] = new int[]{1, 6, 1};
        nArrayArray[19] = new int[]{1, 7, 1};
        int[] nArray14 = new int[3];
        nArray14[0] = 8;
        nArray14[2] = 2;
        nArrayArray[20] = nArray14;
        iAllTypes = nArrayArray;
        buttonNames = new String[]{"Macro", "Function", "Namepace", "Function", "Namespace", "Field", "Enumtor", "Method", "Field", "Enumtor", "Method", "Type", "Typedef", "Class", "Variable", "Struct", "Enum", "Union", "Derived", "Friend", "Include"};
    }

    private static String getStringDescription(int n) {
        return buttonNames[n];
    }

    private static String getUniqueStringDescription(int n) {
        return String.valueOf(n);
    }

    protected FilterIndexerViewDialog(Shell shell, IndexerNodeParent indexerNodeParent, String string) {
        super(shell);
        this.root = indexerNodeParent;
        this.projName = string;
        int n = 0;
        while (n < iAllTypes.length) {
            this.fFilterMatcher[n] = false;
            ++n;
        }
        this.groupedButtonSelections = new boolean[4];
        n = 0;
        while (n <= 3) {
            this.groupedButtonSelections[n] = false;
            ++n;
        }
        this.setDialogSettings(DIALOG_SETTINGS);
    }

    public void setDialogSettings(String string) {
        this.fDialogSection = String.valueOf(string) + SETTINGS + this.projName;
    }

    public boolean close() {
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(FILTER_INDEXER_RESULTS);
    }

    protected Control createDialogArea(Composite composite) {
        this.readSettings(this.getDialogSettings());
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)composite2);
        this.createMessageArea(composite2);
        this.createFilterText(composite2);
        this.createTypeFilterArea(composite2);
        this.createGroupedArea(composite2);
        this.createPageSizeArea(composite2);
        return composite2;
    }

    protected Label createLabel(Composite composite, String string) {
        if (string == null) {
            return null;
        }
        Label label = new Label(composite, 0);
        label.setText(string);
        label.setFont(composite.getFont());
        return label;
    }

    private void createTypeCheckbox(Composite composite, int n) {
        String string = FilterIndexerViewDialog.getStringDescription(n);
        Image image = IndexerViewPluginImages.get(n);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        final int n2 = n;
        Button button = new Button(composite2, 32);
        button.setFont(composite2.getFont());
        button.setText(string);
        button.setImage(image);
        button.setSelection(this.fFilterMatcher[n]);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.widget instanceof Button) {
                    Button button = (Button)selectionEvent.widget;
                    FilterIndexerViewDialog.this.fFilterMatcher[n2] = button.getSelection();
                }
            }
        });
        Label label = new Label(composite2, 16384);
        label.setFont(composite2.getFont());
        label.setText(string);
        this.buttons[n] = button;
    }

    private void createTypeFilterArea(Composite composite) {
        this.createLabel(composite, TYPESELECTIONDIALOG_DeclLABEL);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(3, true);
        gridLayout.verticalSpacing = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        int n = 0;
        while (n < iAllTypes.length) {
            if (iAllTypes[n][2] == 1) {
                this.createTypeCheckbox(composite2, n);
            }
            ++n;
        }
        this.createLabel(composite, TYPESELECTIONDIALOG_RefLABEL);
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout((Layout)gridLayout);
        int n2 = 0;
        while (n2 < iAllTypes.length) {
            if (iAllTypes[n2][2] == 2) {
                this.createTypeCheckbox(composite3, n2);
            }
            ++n2;
        }
    }

    private void createGroupedArea(Composite composite) {
        this.createLabel(composite, GROUPED_SELECTIONS_LABEL);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(8, true);
        gridLayout.verticalSpacing = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.allButton = new Button(composite2, 32);
        this.allButton.setFont(composite2.getFont());
        this.allButton.setText(ALL_BUTTON);
        this.allButton.setImage(IndexerViewPluginImages.get("org.eclipse.cdt.testplugin.CTestPlugin.grouped_all.gif"));
        this.allButton.setSelection(this.groupedButtonSelections[0]);
        this.allButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.widget instanceof Button) {
                    Button button = (Button)selectionEvent.widget;
                    boolean bl = button.getSelection();
                    Event event = new Event();
                    int n = 0;
                    while (n < FilterIndexerViewDialog.this.buttons.length) {
                        if (FilterIndexerViewDialog.this.buttons[n] != null) {
                            FilterIndexerViewDialog.this.buttons[n].setSelection(bl);
                            event.widget = FilterIndexerViewDialog.this.buttons[n];
                            FilterIndexerViewDialog.this.buttons[n].notifyListeners(13, event);
                        }
                        ++n;
                    }
                    FilterIndexerViewDialog.this.typeButton.setSelection(bl);
                    FilterIndexerViewDialog.this.groupedButtonSelections[1] = bl;
                    FilterIndexerViewDialog.this.declButton.setSelection(bl);
                    FilterIndexerViewDialog.this.groupedButtonSelections[3] = bl;
                    FilterIndexerViewDialog.this.refButton.setSelection(bl);
                    FilterIndexerViewDialog.this.groupedButtonSelections[2] = bl;
                    FilterIndexerViewDialog.this.groupedButtonSelections[0] = bl;
                }
            }
        });
        Label label = new Label(composite2, 16384);
        label.setFont(composite2.getFont());
        label.setText(ALL_BUTTON);
        this.typeButton = new Button(composite2, 32);
        this.typeButton.setFont(composite2.getFont());
        this.typeButton.setText(TYPE_BUTTON);
        this.typeButton.setImage(IndexerViewPluginImages.get("org.eclipse.cdt.testplugin.CTestPlugin.grouped_type.gif"));
        this.typeButton.setSelection(this.groupedButtonSelections[1]);
        this.typeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.widget instanceof Button) {
                    Button button = (Button)selectionEvent.widget;
                    boolean bl = button.getSelection();
                    Event event = new Event();
                    int n = 0;
                    while (n < FilterIndexerViewDialog.this.buttons.length) {
                        if (FilterIndexerViewDialog.this.buttons[n] != null && iAllTypes[n][0] == 1) {
                            FilterIndexerViewDialog.this.buttons[n].setSelection(bl);
                            event.widget = FilterIndexerViewDialog.this.buttons[n];
                            FilterIndexerViewDialog.this.buttons[n].notifyListeners(13, event);
                        }
                        ++n;
                    }
                    FilterIndexerViewDialog.this.groupedButtonSelections[1] = bl;
                    FilterIndexerViewDialog.this.checkAllButton();
                }
            }
        });
        label = new Label(composite2, 16384);
        label.setFont(composite2.getFont());
        label.setText(TYPE_BUTTON);
        this.declButton = new Button(composite2, 32);
        this.declButton.setFont(composite2.getFont());
        this.declButton.setText(DECL_BUTTON);
        this.declButton.setImage(IndexerViewPluginImages.get("org.eclipse.cdt.testplugin.CTestPlugin.grouped_decl.gif"));
        this.declButton.setSelection(this.groupedButtonSelections[3]);
        this.declButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.widget instanceof Button) {
                    Button button = (Button)selectionEvent.widget;
                    boolean bl = button.getSelection();
                    Event event = new Event();
                    int n = 0;
                    while (n < FilterIndexerViewDialog.this.buttons.length) {
                        if (FilterIndexerViewDialog.this.buttons[n] != null && iAllTypes[n][2] == 1) {
                            FilterIndexerViewDialog.this.buttons[n].setSelection(bl);
                            event.widget = FilterIndexerViewDialog.this.buttons[n];
                            FilterIndexerViewDialog.this.buttons[n].notifyListeners(13, event);
                        }
                        ++n;
                    }
                    FilterIndexerViewDialog.this.groupedButtonSelections[3] = bl;
                    FilterIndexerViewDialog.this.checkAllButton();
                }
            }
        });
        label = new Label(composite2, 16384);
        label.setFont(composite2.getFont());
        label.setText(DECL_BUTTON);
        this.refButton = new Button(composite2, 32);
        this.refButton.setFont(composite2.getFont());
        this.refButton.setText(REF_BUTTON);
        this.refButton.setImage(IndexerViewPluginImages.get("org.eclipse.cdt.testplugin.CTestPlugin.grouped_ref.gif"));
        this.refButton.setSelection(this.groupedButtonSelections[2]);
        this.refButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.widget instanceof Button) {
                    Button button = (Button)selectionEvent.widget;
                    boolean bl = button.getSelection();
                    Event event = new Event();
                    int n = 0;
                    while (n < FilterIndexerViewDialog.this.buttons.length) {
                        if (FilterIndexerViewDialog.this.buttons[n] != null && iAllTypes[n][2] == 2) {
                            FilterIndexerViewDialog.this.buttons[n].setSelection(bl);
                            event.widget = FilterIndexerViewDialog.this.buttons[n];
                            FilterIndexerViewDialog.this.buttons[n].notifyListeners(13, event);
                        }
                        ++n;
                    }
                    FilterIndexerViewDialog.this.groupedButtonSelections[2] = bl;
                    FilterIndexerViewDialog.this.checkAllButton();
                }
            }
        });
        label = new Label(composite2, 16384);
        label.setFont(composite2.getFont());
        label.setText(REF_BUTTON);
    }

    void checkAllButton() {
        boolean bl = true;
        int n = 0;
        while (n < this.buttons.length) {
            if (!this.buttons[n].getSelection()) {
                bl = false;
                break;
            }
            ++n;
        }
        this.allButton.setSelection(bl);
        this.groupedButtonSelections[0] = bl;
    }

    private void createPageSizeArea(Composite composite) {
        this.createLabel(composite, PAGE_SIZE_);
        this.pageSizeText = new Text(composite, 2048);
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.pageSizeText.setLayoutData((Object)gridData);
        this.pageSizeText.setFont(composite.getFont());
        this.pageSizeText.setText(String.valueOf(this.pageSize));
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 0);
        if (this.message != null) {
            label.setText(this.message);
        }
        label.setFont(composite.getFont());
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected Text createFilterText(Composite composite) {
        this.filterText = new Text(composite, 2048);
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.filterText.setLayoutData((Object)gridData);
        this.filterText.setFont(composite.getFont());
        this.filterText.setText(this.fFilter == null ? BLANK_STRING : this.fFilter);
        return this.filterText;
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.apply();
        }
        super.buttonPressed(n);
    }

    public IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = CUIPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(this.fDialogSection);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(this.fDialogSection);
            this.writeDefaultSettings(iDialogSettings2);
        }
        return iDialogSettings2;
    }

    protected void writeSettings(IDialogSettings iDialogSettings) {
        Point point = this.getShell().getLocation();
        iDialogSettings.put(SETTINGS_X_POS, point.x);
        iDialogSettings.put(SETTINGS_Y_POS, point.y);
        Point point2 = this.getShell().getSize();
        iDialogSettings.put(SETTINGS_WIDTH, point2.x);
        iDialogSettings.put(SETTINGS_HEIGHT, point2.y);
        int n = 0;
        while (n < iAllTypes.length) {
            iDialogSettings.put(FilterIndexerViewDialog.getUniqueStringDescription(n), this.fFilterMatcher[n]);
            ++n;
        }
        iDialogSettings.put(ALL_BUTTON, this.groupedButtonSelections[0]);
        iDialogSettings.put(TYPE_BUTTON, this.groupedButtonSelections[1]);
        iDialogSettings.put(REF_BUTTON, this.groupedButtonSelections[2]);
        iDialogSettings.put(DECL_BUTTON, this.groupedButtonSelections[3]);
        iDialogSettings.put(PAGE_SIZE, this.pageSize);
        iDialogSettings.put(FILTER_TEXT, this.fFilter);
    }

    protected void writeDefaultSettings(IDialogSettings iDialogSettings) {
        int n = 0;
        while (n < iAllTypes.length) {
            String string = FilterIndexerViewDialog.getUniqueStringDescription(n);
            iDialogSettings.put(string, true);
            ++n;
        }
        iDialogSettings.put(FILTER_TEXT, this.fFilter);
        iDialogSettings.put(PAGE_SIZE, 40);
    }

    protected Point getInitialLocation(Point point) {
        Point point2 = super.getInitialLocation(point);
        if (this.fLocation != null) {
            int n;
            point2.x = this.fLocation.x;
            point2.y = this.fLocation.y;
            Rectangle rectangle = this.getShell().getDisplay().getClientArea();
            int n2 = point2.x + point.x;
            if (n2 > rectangle.width) {
                point2.x -= n2 - rectangle.width;
            }
            if ((n = point2.y + point.y) > rectangle.height) {
                point2.y -= n - rectangle.height;
            }
        }
        return point2;
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        if (this.fSize != null) {
            point.x = Math.max(point.x, this.fSize.x);
            point.y = Math.max(point.y, this.fSize.y);
            Rectangle rectangle = this.getShell().getDisplay().getClientArea();
            point.x = Math.min(point.x, rectangle.width);
            point.y = Math.min(point.y, rectangle.height);
        }
        return point;
    }

    public void readSettings(IDialogSettings iDialogSettings) {
        int n;
        try {
            n = iDialogSettings.getInt(SETTINGS_X_POS);
            int n2 = iDialogSettings.getInt(SETTINGS_Y_POS);
            this.fLocation = new Point(n, n2);
            int n3 = iDialogSettings.getInt(SETTINGS_WIDTH);
            int n4 = iDialogSettings.getInt(SETTINGS_HEIGHT);
            this.fSize = new Point(n3, n4);
            this.pageSize = iDialogSettings.getInt(PAGE_SIZE);
        }
        catch (NumberFormatException numberFormatException) {
            this.fLocation = null;
            this.fSize = null;
        }
        n = 0;
        while (n < iAllTypes.length) {
            this.fFilterMatcher[n] = iDialogSettings.getBoolean(FilterIndexerViewDialog.getUniqueStringDescription(n));
            ++n;
        }
        this.groupedButtonSelections[0] = iDialogSettings.getBoolean(ALL_BUTTON);
        this.groupedButtonSelections[1] = iDialogSettings.getBoolean(TYPE_BUTTON);
        this.groupedButtonSelections[2] = iDialogSettings.getBoolean(REF_BUTTON);
        this.groupedButtonSelections[3] = iDialogSettings.getBoolean(DECL_BUTTON);
        this.fFilter = iDialogSettings.get(FILTER_TEXT);
        if (this.fFilter == null) {
            this.fFilter = BLANK_STRING;
        }
    }

    public IndexerFilterManager createFilterManager() {
        return new IndexerFilterManager(this.fFilterMatcher, this.fFilter);
    }

    private void apply() {
        this.fFilter = this.filterText.getText();
        this.pageSize = 40;
        try {
            this.pageSize = Integer.valueOf(this.pageSizeText.getText());
            if (this.pageSize <= 0) {
                this.pageSize = 40;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        this.root.setFilterManager(this.fFilterMatcher, this.fFilter);
        this.root.setPageSize(this.pageSize);
        this.root.reset();
        this.writeSettings(this.getDialogSettings());
    }

    public int getPageSize() {
        return this.pageSize;
    }
}

