/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.text.selectiontests;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.search.DOMSearchUtil;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.core.testplugin.FileManager;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.parser.ParserException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class CPPSelectionTestsNoIndexer
extends TestCase {
    private static final String INDEX_FILE_ID = "2946365241";
    static NullProgressMonitor monitor;
    static IWorkspace workspace;
    static IProject project;
    static ICProject cPrj;
    static FileManager fileManager;
    static boolean disabledHelpContributions;
    static /* synthetic */ Class class$0;

    static {
        disabledHelpContributions = false;
    }

    public CPPSelectionTestsNoIndexer() {
        monitor = new NullProgressMonitor();
        workspace = ResourcesPlugin.getWorkspace();
        try {
            cPrj = CProjectHelper.createCCProject((String)"CPPSelectionTestsNoIndexer", (String)"bin");
            project = cPrj.getProject();
            IPath iPath = CCorePlugin.getDefault().getStateLocation();
            File file = new File(iPath.append("2946365241.index").toOSString());
            if (file.exists()) {
                file.delete();
            }
        }
        catch (CoreException coreException) {}
        if (project == null) {
            Assert.fail((String)"Unable to create project");
        }
        fileManager = new FileManager();
    }

    public CPPSelectionTestsNoIndexer(String string) {
        super(string);
        monitor = new NullProgressMonitor();
        workspace = ResourcesPlugin.getWorkspace();
        try {
            cPrj = CProjectHelper.createCCProject((String)"CPPSelectionTestsNoIndexer", (String)"bin");
            project = cPrj.getProject();
            IPath iPath = CCorePlugin.getDefault().getStateLocation();
            File file = new File(iPath.append("2946365241.index").toOSString());
            if (file.exists()) {
                file.delete();
            }
        }
        catch (CoreException coreException) {}
        if (project == null) {
            Assert.fail((String)"Unable to create project");
        }
        fileManager = new FileManager();
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.ui.tests.text.selectiontests.CPPSelectionTestsNoIndexer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite((Class)clazz);
        testSuite.addTest((Test)new CPPSelectionTestsNoIndexer("cleanupProject"));
        return testSuite;
    }

    public void cleanupProject() throws Exception {
        try {
            project.delete(true, false, (IProgressMonitor)monitor);
            project = null;
        }
        catch (Throwable throwable) {}
    }

    protected void tearDown() throws Exception {
        if (project == null || !project.exists()) {
            return;
        }
        IResource[] iResourceArray = project.members();
        int n = 0;
        while (n < iResourceArray.length) {
            if (!iResourceArray[n].getName().equals(".project") && !iResourceArray[n].getName().equals(".cdtproject")) {
                try {
                    iResourceArray[n].delete(false, (IProgressMonitor)monitor);
                }
                catch (Throwable throwable) {}
            }
            ++n;
        }
    }

    protected IFile importFile(String string, String string2) throws Exception {
        IFile iFile = project.getProject().getFile(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        if (iFile.exists()) {
            iFile.setContents((InputStream)byteArrayInputStream, false, false, (IProgressMonitor)monitor);
        } else {
            iFile.create((InputStream)byteArrayInputStream, false, (IProgressMonitor)monitor);
        }
        fileManager.addFile(iFile);
        return iFile;
    }

    protected IFile importFileWithLink(String string, String string2) throws Exception {
        IFile iFile = project.getProject().getFile(string);
        Path path = new Path(String.valueOf(project.getLocation().removeLastSegments(1).toOSString()) + File.separator + string);
        File file = new File(path.toOSString());
        if (!file.exists()) {
            file.createNewFile();
        }
        iFile.createLink((IPath)path, 16, null);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        if (iFile.exists()) {
            iFile.setContents((InputStream)byteArrayInputStream, false, false, (IProgressMonitor)monitor);
        } else {
            iFile.create((InputStream)byteArrayInputStream, false, (IProgressMonitor)monitor);
        }
        fileManager.addFile(iFile);
        return iFile;
    }

    protected IFile importFileInsideLinkedFolder(String string, String string2, String string3) throws Exception {
        IFolder iFolder = project.getFolder(string3);
        Path path = new Path(String.valueOf(project.getLocation().toOSString()) + File.separator + string3 + "_this_is_linked");
        IFolder iFolder2 = project.getFolder(String.valueOf(string3) + "_this_is_linked");
        if (!iFolder2.exists()) {
            iFolder2.create(true, true, (IProgressMonitor)monitor);
        }
        iFolder.createLink((IPath)path, 0, (IProgressMonitor)monitor);
        iFolder2.delete(true, false, (IProgressMonitor)monitor);
        IFile iFile = iFolder.getFile(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        if (iFile.exists()) {
            iFile.setContents((InputStream)byteArrayInputStream, false, false, (IProgressMonitor)monitor);
        } else {
            iFile.create((InputStream)byteArrayInputStream, false, (IProgressMonitor)monitor);
        }
        fileManager.addFile(iFile);
        return iFile;
    }

    protected IASTNode testF3(IFile iFile, int n) throws ParserException {
        return this.testF3(iFile, n, 0);
    }

    protected IASTNode testF3(IFile iFile, int n, int n2) throws ParserException {
        this.disableIndex();
        if (n < 0) {
            throw new ParserException("offset can not be less than 0 and was " + n);
        }
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart iEditorPart = null;
        try {
            iEditorPart = iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), "org.eclipse.cdt.ui.editor.CEditor");
        }
        catch (PartInitException partInitException) {
            Assert.assertFalse((boolean)true);
        }
        if (iEditorPart instanceof AbstractTextEditor) {
            ((AbstractTextEditor)iEditorPart).getSelectionProvider().setSelection((ISelection)new TextSelection(n, n2));
            IAction iAction = ((AbstractTextEditor)iEditorPart).getAction("OpenDeclarations");
            iAction.run();
            ISelection iSelection = ((AbstractTextEditor)iEditorPart).getSelectionProvider().getSelection();
            if (iSelection instanceof TextSelection) {
                IASTName[] iASTNameArray = DOMSearchUtil.getSelectedNamesFrom((IFile)iFile, (int)((TextSelection)iSelection).getOffset(), (int)((TextSelection)iSelection).getLength());
                if (iASTNameArray.length == 0) {
                    Assert.assertFalse((boolean)true);
                } else {
                    return iASTNameArray[0];
                }
            }
        }
        return null;
    }

    protected IASTNode testCtrl_F3(IFile iFile, int n) throws ParserException {
        return this.testCtrl_F3(iFile, n, 0);
    }

    protected IASTNode testCtrl_F3(IFile iFile, int n, int n2) throws ParserException {
        this.disableIndex();
        if (n < 0) {
            throw new ParserException("offset can not be less than 0 and was " + n);
        }
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart iEditorPart = null;
        try {
            iEditorPart = iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), "org.eclipse.cdt.ui.editor.CEditor");
        }
        catch (PartInitException partInitException) {
            Assert.assertFalse((boolean)true);
        }
        if (iEditorPart instanceof AbstractTextEditor) {
            ((AbstractTextEditor)iEditorPart).getSelectionProvider().setSelection((ISelection)new TextSelection(n, n2));
            IAction iAction = ((AbstractTextEditor)iEditorPart).getAction("OpenDefinition");
            iAction.run();
            ISelection iSelection = ((AbstractTextEditor)iEditorPart).getSelectionProvider().getSelection();
            if (iSelection instanceof TextSelection) {
                IASTName[] iASTNameArray = DOMSearchUtil.getSelectedNamesFrom((IFile)iFile, (int)((TextSelection)iSelection).getOffset(), (int)((TextSelection)iSelection).getLength());
                if (iASTNameArray == null || iASTNameArray.length == 0) {
                    return null;
                }
                return iASTNameArray[0];
            }
        }
        return null;
    }

    private void disableIndex() {
        IPath iPath = CCorePlugin.getDefault().getStateLocation();
        File file = new File(iPath.append("2946365241.index").toOSString());
        if (file.exists()) {
            file.delete();
        }
    }

    public void testBug93281() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class Point{                         \n");
        stringBuffer.append("public:                              \n");
        stringBuffer.append("Point(): xCoord(0){}                 \n");
        stringBuffer.append("Point& operator=(const Point &rhs){return *this;}    // line A\n");
        stringBuffer.append("void* operator new [ ] (unsigned int);\n");
        stringBuffer.append("private:                             \n");
        stringBuffer.append("int xCoord;                          \n");
        stringBuffer.append("};                                   \n");
        stringBuffer.append("static const Point zero;\n");
        stringBuffer.append("int main(int argc, char **argv) {        \n");
        stringBuffer.append("Point *p2 = new Point();         \n");
        stringBuffer.append("p2->    operator // /* operator */ // F3 in the middle \n");
        stringBuffer.append("//of \"operator\" should work\n");
        stringBuffer.append("// \\n");
        stringBuffer.append("/* */\n");
        stringBuffer.append("=(zero);           // line B\n");
        stringBuffer.append("p2->operator /* oh yeah */ new // F3 in the middle of \"operator\"\n");
        stringBuffer.append("// should work\n");
        stringBuffer.append("//\n");
        stringBuffer.append("[ /* sweet */ ] //\n");
        stringBuffer.append("(2);\n");
        stringBuffer.append("return (0);                          \n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("test93281.cpp", string);
        int n = string.indexOf("p2->operator") + 6;
        IASTNode iASTNode = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"operator new[]");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)183);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)16);
        n = string.indexOf("p2->    operator") + 11;
        iASTNode = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"operator =");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)121);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)9);
    }

    public void testBasicDefinition() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern int MyInt;       // MyInt is in another file\n");
        stringBuffer.append("extern const int MyConst;   // MyConst is in another file\n");
        stringBuffer.append("void MyFunc(int);       // often used in header files\n");
        stringBuffer.append("struct MyStruct;        // often used in header files\n");
        stringBuffer.append("typedef int NewInt;     // a normal typedef statement\n");
        stringBuffer.append("class MyClass;          // often used in header files\n");
        stringBuffer.append("int MyInt;\n");
        stringBuffer.append("extern const int MyConst = 42;\n");
        stringBuffer.append("void MyFunc(int a) { cout << a << endl; }\n");
        stringBuffer.append("struct MyStruct { int Member1; int Member2; };\n");
        stringBuffer.append("class MyClass { int MemberVar; };\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBasicDefinition.cpp", string);
        int n = string.indexOf("MyInt;\n") + 2;
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyInt");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)11);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)5);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyInt");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)330);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)5);
        n = string.indexOf("MyConst = 42") + 2;
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyConst");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)69);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)7);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyConst");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)354);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)7);
        n = string.indexOf("MyFunc(int a)") + 2;
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyFunc");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)115);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)6);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyFunc");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)373);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)6);
        n = string.indexOf("MyStruct {") + 2;
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyStruct");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)171);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)8);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyStruct");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)417);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)8);
        n = string.indexOf("MyClass {") + 2;
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"MyClass");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)278);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)7);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"MyClass");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)463);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)7);
    }

    public void testBug95224() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A{\n");
        ((Writer)stringWriter).write("A();\n");
        ((Writer)stringWriter).write("A(const A&); // open definition on A finds class A\n");
        ((Writer)stringWriter).write("~A(); // open definition on A finds nothing\n");
        ((Writer)stringWriter).write("};\n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("testBug95224.cpp", string);
        int n = string.indexOf("A(); // open definition ");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"~A");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)65);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"A");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)6);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
    }

    public void testBasicTemplateInstance() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N{                               \n");
        ((Writer)stringWriter).write("   template < class T > class AAA { T _t; };\n");
        ((Writer)stringWriter).write("};                                         \n");
        ((Writer)stringWriter).write("N::AAA<int> a;                             \n");
        String string = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("testBasicTemplateInstance.cpp", string);
        int n = string.indexOf("AAA<int>");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n, 3);
        IASTNode iASTNode2 = this.testF3(iFile, n, 3);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"AAA");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)74);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)3);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"AAA");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)74);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)3);
        IASTNode iASTNode3 = this.testCtrl_F3(iFile, n, 8);
        IASTNode iASTNode4 = this.testF3(iFile, n, 8);
        Assert.assertTrue((boolean)(iASTNode3 instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode4 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode4).toString(), (String)"AAA");
        Assert.assertEquals((int)((ASTNode)iASTNode4).getOffset(), (int)74);
        Assert.assertEquals((int)((ASTNode)iASTNode4).getLength(), (int)3);
        Assert.assertEquals((String)((IASTName)iASTNode3).toString(), (String)"AAA");
        Assert.assertEquals((int)((ASTNode)iASTNode3).getOffset(), (int)74);
        Assert.assertEquals((int)((ASTNode)iASTNode3).getLength(), (int)3);
    }

    public void testBug86829A() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("X(int); // openReferences fails to find the constructor in g()\n");
        stringBuffer.append("};\n");
        stringBuffer.append("X f(X);\n");
        stringBuffer.append("void g()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("X b = f(X(2)); // openDeclarations on X(int) finds the class and not \n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBug86829A.cpp", string);
        int n = string.indexOf("X(2)");
        IASTNode iASTNode = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)18);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
    }

    public void testBug86829B() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("operator int();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class Y {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("operator X();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("Y a;\n");
        stringBuffer.append("int c = X(a); // OK: a.operator X().operator int()\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBug86829B.cpp", string);
        int n = string.indexOf("X(a);");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)6);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)6);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
    }

    public void testCPPSpecDeclsDefs() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int a; // defines a\n");
        stringBuffer.append("extern const int c = 1; // defines c\n");
        stringBuffer.append("int f(int x) { return x+a; } // defines f and defines x\n");
        stringBuffer.append("struct S { int a; int b; }; // defines S, S::a, and S::b\n");
        stringBuffer.append("struct X { // defines X\n");
        stringBuffer.append("int x; // defines nonstatic data member x\n");
        stringBuffer.append("static int y; // declares static data member y\n");
        stringBuffer.append("X(): x(0) { } // defines a constructor of X\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int X::y = 1; // defines X::y\n");
        stringBuffer.append("enum { up, down }; // defines up and down\n");
        stringBuffer.append("namespace N { int d; } // defines N and N::d\n");
        stringBuffer.append("namespace N1 = N; // defines N1\n");
        stringBuffer.append("X anX; // defines anX\n");
        stringBuffer.append("extern int a; // declares a\n");
        stringBuffer.append("extern const int c; // declares c\n");
        stringBuffer.append("int f(int); // declares f\n");
        stringBuffer.append("struct S; // declares S\n");
        stringBuffer.append("typedef int Int; // declares Int\n");
        stringBuffer.append("extern X anotherX; // declares anotherX\n");
        stringBuffer.append("using N::d; // declares N::d\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testCPPSpecDeclsDefs.cpp", string);
        int n = string.indexOf("a; // defines a");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("c = 1; // defines c");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"c");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)37);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"c");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)37);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("f(int x) { return x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"f");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)61);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"f");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)61);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x) { return x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)67);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)67);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)67);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)67);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x+a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)67);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)67);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("a; } // defines f and defines x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("S { int a; int b; }; // defines S, S::a, and S::b");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"S");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)120);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"S");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)120);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("a; int b; }; // defines S, S::a, and S::b");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)128);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)128);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("b; }; // defines S, S::a, and S::b");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"b");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)135);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"b");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)135);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("X { // defines X");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)177);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)177);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x; // defines nonstatic data member x");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)198);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)198);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("y; // declares static data member y");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"y");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)247);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"y");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)337);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("X(): x(0) { } // defines a constructor of X");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)283);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)283);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("x(0) { } // defines a constructor of X");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)198);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)198);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("X::y = 1; // defines X::y");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)177);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)177);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("y = 1; // defines X::y");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"y");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)247);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"y");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)337);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("up, down }; // defines up and down");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"up");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)367);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"up");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)367);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)2);
        n = string.indexOf("down }; // defines up and down");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"down");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)371);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)4);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"down");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)371);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)4);
        n = string.indexOf("N { int d; } // defines N and N::d");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"N");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)412);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"N");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)412);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("d; } // defines N and N::d");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"d");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)420);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"d");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)420);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("N1 = N; // defines N1");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"N1");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)457);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"N1");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)457);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)2);
        n = string.indexOf("N; // defines N1");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"N");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)412);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"N");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)412);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("X anX; // defines anX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)177);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)177);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("anX; // defines anX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"anX");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)481);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)3);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"anX");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)481);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)3);
        n = string.indexOf("a; // declares a");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"a");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("c; // declares c");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"c");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)37);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"c");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)37);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("f(int); // declares f");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"f");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)61);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"f");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)61);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("S; // declares S");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"S");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)120);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"S");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)120);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("Int; // declares Int");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"Int");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)625);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)3);
        n = string.indexOf("X anotherX; // declares anotherX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"X");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)177);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"X");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)177);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("anotherX; // declares anotherX");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"anotherX");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)655);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)8);
        n = string.indexOf("N::d; // declares N::d");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"N");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)412);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"N");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)412);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        n = string.indexOf("d; // declares N::d");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"d");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)420);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"d");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)420);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
    }

    public void testBug95225() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class Overflow {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("Overflow(char,double,double);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void f(double x)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("throw Overflow('+',x,3.45e107);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("try {\n");
        stringBuffer.append("f(1.2);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("catch(Overflow& oo) {\n");
        stringBuffer.append("\t\t\t\t// handle exceptions of type Overflow here\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBug95225.cpp", string);
        int n = string.indexOf("rflow('+',x,3.45e107);");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"Overflow");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)25);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)8);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"Overflow");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)6);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)8);
        n = string.indexOf("x,3.45e107);");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)72);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)72);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
    }

    public void testNoDefinitions() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern int a1; // declares a\n");
        stringBuffer.append("extern const int c1; // declares c\n");
        stringBuffer.append("int f1(int); // declares f\n");
        stringBuffer.append("struct S1; // declares S\n");
        stringBuffer.append("typedef int Int; // declares Int\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testNoDefinitions.cpp", string);
        int n = string.indexOf("a1; // declares a");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        Assert.assertNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"a1");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)11);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("c1; // declares c");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"c1");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)46);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("f1(int); // declares f");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"f1");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)68);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("S1; // declares S");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"S1");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)98);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)2);
        n = string.indexOf("Int; // declares Int");
        iASTNode = this.testCtrl_F3(iFile, n);
        iASTNode2 = this.testF3(iFile, n);
        Assert.assertNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"Int");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)128);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)3);
    }

    public void testBug95202() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A { }; // implicitlydeclared A::operator=\n");
        stringBuffer.append("struct B : A {\n");
        stringBuffer.append("B& operator=(const B &);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("B& B::operator=(const B& s) {\n");
        stringBuffer.append("this->B::operator=(s); // wellformed\n");
        stringBuffer.append("return *this;\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBug95202.cpp", string);
        int n = string.indexOf("s); // wellformed");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"s");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)117);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"s");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)117);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
    }

    public void testBug95229() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("operator short(); // F3 on operator causes an infinite loop\n");
        stringBuffer.append("} a;\n");
        stringBuffer.append("int f(int);\n");
        stringBuffer.append("int f(float);\n");
        stringBuffer.append("int i = f(a); // Calls f(int), because short -> int is\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFile("testBug95229.cpp", string);
        int n = string.indexOf("rator short(); // F3");
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        Assert.assertNull((Object)iASTNode);
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"operator short");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)11);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)14);
    }

    public void testBug78354() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int TestTypeOne;\n");
        stringBuffer.append("typedef int TestTypeTwo;\n");
        stringBuffer.append("main()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("TestTypeOne myFirstLink = 5;\n");
        stringBuffer.append("TestTypeTwo mySecondLink = 6;\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFileWithLink("testBug78354.cpp", string);
        int n = string.indexOf("TestTypeOne myFirstLink = 5;");
        IASTNode iASTNode = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"TestTypeOne");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)12);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)11);
    }

    public void testBug103697() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x;\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append(" return x;\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFileWithLink("testBug103697.cpp", string);
        int n = string.indexOf("return x;\n") + "return ".length();
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
    }

    public void testBug76043() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x;\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append(" return x;\n");
        stringBuffer.append("}\n");
        String string = stringBuffer.toString();
        IFile iFile = this.importFileInsideLinkedFolder("testBug76043.c", string, "folder");
        Assert.assertFalse((boolean)iFile.isLinked());
        int n = string.indexOf("return x;\n") + "return ".length();
        IASTNode iASTNode = this.testCtrl_F3(iFile, n);
        IASTNode iASTNode2 = this.testF3(iFile, n);
        Assert.assertTrue((boolean)(iASTNode instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode).toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNode).getOffset(), (int)4);
        Assert.assertEquals((int)((ASTNode)iASTNode).getLength(), (int)1);
        Assert.assertTrue((boolean)(iASTNode2 instanceof IASTName));
        Assert.assertEquals((String)((IASTName)iASTNode2).toString(), (String)"x");
        Assert.assertEquals((int)((ASTNode)iASTNode2).getOffset(), (int)4);
        Assert.assertEquals((int)((ASTNode)iASTNode2).getLength(), (int)1);
    }
}

