/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class LRUWorkingSets {
    ArrayList workingSetsCache = null;
    int size = 0;

    public LRUWorkingSets(int size) {
        this.workingSetsCache = new ArrayList(size);
        this.size = size;
    }

    public void add(IWorkingSet[] workingSet) {
        this.cleanUpCache();
        IWorkingSet[] existingWorkingSets = this.find(this.workingSetsCache, workingSet);
        if (existingWorkingSets != null) {
            this.workingSetsCache.remove(existingWorkingSets);
        } else if (this.workingSetsCache.size() == this.size) {
            this.workingSetsCache.remove(this.size - 1);
        }
        this.workingSetsCache.add(0, workingSet);
    }

    private IWorkingSet[] find(ArrayList list, IWorkingSet[] workingSet) {
        HashSet<IWorkingSet> workingSetList = new HashSet<IWorkingSet>(Arrays.asList(workingSet));
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            IWorkingSet[] lruWorkingSets = (IWorkingSet[])iter.next();
            HashSet<IWorkingSet> lruWorkingSetList = new HashSet<IWorkingSet>(Arrays.asList(lruWorkingSets));
            if (!lruWorkingSetList.equals(workingSetList)) continue;
            return lruWorkingSets;
        }
        return null;
    }

    private void cleanUpCache() {
        Iterator iter = this.workingSetsCache.iterator();
        block0: while (iter.hasNext()) {
            IWorkingSet[] workingSet = (IWorkingSet[])iter.next();
            int i = 0;
            while (i < workingSet.length) {
                if (PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(workingSet[i].getName()) == null) {
                    this.workingSetsCache.remove(workingSet);
                    continue block0;
                }
                ++i;
            }
        }
    }

    public Iterator iterator() {
        return this.workingSetsCache.iterator();
    }
}

