/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.AddWatchpointDialog;
import org.eclipse.cdt.debug.internal.ui.actions.WatchpointExpressionVerifier;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;

public class AddWatchpointActionDelegate
extends ActionDelegate
implements IWorkbenchWindowActionDelegate,
IPartListener {
    private boolean fInitialized = false;
    private IAction fAction = null;
    private ITextEditor fTextEditor = null;
    private IWorkbenchWindow fWorkbenchWindow = null;
    private IResource fResource = null;
    private String fSourceHandle = "";

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.setWorkbenchWindow(window);
        window.getPartService().addPartListener((IPartListener)this);
    }

    public void run(IAction action) {
        String expression = this.getSelectedExpression();
        AddWatchpointDialog dlg = new AddWatchpointDialog(CDebugUIPlugin.getActiveWorkbenchShell(), true, false, expression, true);
        if (dlg.open() != 0) {
            return;
        }
        if (this.getTextEditor() != null) {
            this.update();
            this.addWatchpoint(this.getTextEditor().getEditorInput(), dlg.getWriteAccess(), dlg.getReadAccess(), dlg.getExpression());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!this.fInitialized) {
            IEditorPart part;
            IWorkbenchPage page;
            this.setAction(action);
            if (this.getWorkbenchWindow() != null && (page = this.getWorkbenchWindow().getActivePage()) != null && (part = page.getActiveEditor()) instanceof ITextEditor) {
                this.setTextEditor((ITextEditor)part);
            }
            this.fInitialized = true;
        }
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        return this.fWorkbenchWindow;
    }

    protected void setWorkbenchWindow(IWorkbenchWindow workbenchWindow) {
        this.fWorkbenchWindow = workbenchWindow;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected void setTextEditor(ITextEditor editor) {
        this.fTextEditor = editor;
        if (this.fTextEditor != null) {
            IEditorInput input = this.fTextEditor.getEditorInput();
            this.setSourceHandle(input);
            this.setResource(input);
        }
        this.setEnabledState(editor);
    }

    protected String getSelectedExpression() {
        ISelection s;
        ISelectionProvider sp;
        if (this.getTextEditor() != null && (sp = this.getTextEditor().getSelectionProvider()) != null && (s = sp.getSelection()) instanceof ITextSelection) {
            return ((ITextSelection)s).getText().trim();
        }
        return "";
    }

    protected void update(ISelection selection) {
        this.setEnabledState(this.getTextEditor());
    }

    protected void update() {
        IAction action = this.getAction();
        if (action != null) {
            action.setEnabled(this.getTextEditor() != null);
        }
    }

    protected void setEnabledState(ITextEditor editor) {
        if (this.getAction() != null) {
            this.getAction().setEnabled(editor != null);
        }
    }

    protected IResource getResource() {
        return this.fResource;
    }

    protected void setResource(IEditorInput input) {
        this.fResource = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile().getProject() : ResourcesPlugin.getWorkspace().getRoot();
    }

    protected void addWatchpoint(IEditorInput editorInput, boolean write, boolean read, String expression) {
        if (this.getResource() == null) {
            return;
        }
        WatchpointExpressionVerifier wev = new WatchpointExpressionVerifier();
        IDocument document = this.getTextEditor().getDocumentProvider().getDocument((Object)editorInput);
        if (wev.isValidExpression(document, expression)) {
            try {
                CDIDebugModel.createWatchpoint((String)this.getSourceHandle(), (IResource)this.getResource(), (boolean)write, (boolean)read, (String)expression, (boolean)true, (int)0, (String)"", (boolean)true);
            }
            catch (CoreException ce) {
                CDebugUIPlugin.errorDialog(ActionMessages.getString("AddWatchpointActionDelegate.0"), ce);
            }
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            this.setTextEditor((ITextEditor)part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.getTextEditor()) {
            this.setTextEditor(null);
            if (this.getAction() != null) {
                this.getAction().setEnabled(false);
            }
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part instanceof ITextEditor && this.getTextEditor() == null) {
            this.setTextEditor((ITextEditor)part);
        }
    }

    private String getSourceHandle() {
        return this.fSourceHandle;
    }

    private void setSourceHandle(IEditorInput input) {
        this.fSourceHandle = "";
        if (input instanceof IFileEditorInput) {
            this.fSourceHandle = ((IFileEditorInput)input).getFile().getFullPath().toOSString();
        } else if (input instanceof IStorageEditorInput) {
            try {
                IPath path = ((IStorageEditorInput)input).getStorage().getFullPath();
                if (path != null) {
                    this.fSourceHandle = path.toOSString();
                }
            }
            catch (CoreException coreException) {}
        }
    }
}

