/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.modules;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.debug.core.model.ICDebugElement;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICModule;
import org.eclipse.cdt.debug.internal.ui.CDebugModelPresentation;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.IInternalCDebugUIConstants;
import org.eclipse.cdt.debug.internal.ui.actions.ToggleDetailPaneAction;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.cdt.debug.internal.ui.views.AbstractViewerState;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.internal.ui.views.modules.ModulesMessages;
import org.eclipse.cdt.debug.internal.ui.views.modules.ModulesViewContentProvider;
import org.eclipse.cdt.debug.internal.ui.views.modules.ModulesViewEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.modules.ModulesViewer;
import org.eclipse.cdt.debug.internal.ui.views.modules.ModulesViewerState;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.ICDebugUIConstants;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.texteditor.IUpdate;

public class ModulesView
extends AbstractDebugEventHandlerView
implements IDebugExceptionHandler,
IPropertyChangeListener,
ISelectionListener,
INullSelectionListener {
    private SashForm fSashForm;
    private ISourceViewer fDetailViewer;
    private IDocument fDetailDocument;
    private ModulesViewSelectionProvider fSelectionProvider = new ModulesViewSelectionProvider();
    private IDebugModelPresentation fModelPresentation;
    private Viewer fFocusViewer = null;
    private ISelectionChangedListener fTreeSelectionChangedListener;
    private ISelectionChangedListener fDetailSelectionChangedListener;
    private IDocumentListener fDetailDocumentListener;
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{13, 6};
    private int[] fLastSashWeights;
    private boolean fToggledDetailOnce;
    private ToggleDetailPaneAction[] fToggleDetailPaneActions;
    private String fCurrentDetailPaneOrientation = "Modules.detail.orientation.hidden";
    protected static final String SASH_WEIGHTS = String.valueOf(CDebugUIPlugin.getUniqueIdentifier()) + ".modulesView.SASH_WEIGHTS";
    private ICursorListener fCursorListener;
    private HashMap fSelectionStates = new HashMap(10);
    private AbstractViewerState fLastState = null;
    private HashMap fImageCache = new HashMap(10);

    protected Viewer createViewer(Composite parent) {
        TreeViewer viewer = this.createTreeViewer(parent);
        this.createDetailsViewer();
        this.getSashForm().setMaximizedControl(viewer.getControl());
        this.createOrientationActions();
        IPreferenceStore prefStore = CDebugUIPlugin.getDefault().getPreferenceStore();
        String orientation = prefStore.getString(this.getDetailPanePreferenceKey());
        int i = 0;
        while (i < this.fToggleDetailPaneActions.length) {
            this.fToggleDetailPaneActions[i].setChecked(this.fToggleDetailPaneActions[i].getOrientation().equals(orientation));
            ++i;
        }
        this.setDetailPaneOrientation(orientation);
        return viewer;
    }

    protected void createActions() {
        TextViewerAction textAction = new TextViewerAction((ITextViewer)this.getDetailViewer(), 7);
        textAction.configureAction(ModulesMessages.getString("ModulesView.13"), "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.setAction(ActionFactory.SELECT_ALL.getId(), (IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.getDetailViewer(), 4);
        textAction.configureAction(ModulesMessages.getString("ModulesView.16"), "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.setAction(ActionFactory.COPY.getId(), (IAction)textAction);
    }

    protected String getHelpContextId() {
        return ICDebugHelpContextIds.MODULES_VIEW;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyModulesGroup"));
        menu.add((IContributionItem)new Separator("modulesGroup"));
        menu.add((IContributionItem)new Separator("emptyRefreshGroup"));
        menu.add((IContributionItem)new Separator("refreshGroup"));
        menu.add((IContributionItem)new Separator("additions"));
        this.updateObjects();
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator("modulesGroup"));
        tbm.add((IContributionItem)new Separator("refreshGroup"));
    }

    public void handleException(DebugException e) {
        this.showMessage(e.getMessage());
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (propertyName.equals(IInternalCDebugUIConstants.DETAIL_PANE_FONT)) {
            this.getDetailViewer().getTextWidget().setFont(JFaceResources.getFont((String)IInternalCDebugUIConstants.DETAIL_PANE_FONT));
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (selection == null) {
            this.setViewerInput((IStructuredSelection)new StructuredSelection());
        } else if (selection instanceof IStructuredSelection) {
            this.setViewerInput((IStructuredSelection)selection);
        }
    }

    protected void setViewerInput(IStructuredSelection ssel) {
        Object current;
        Object input;
        ICDebugTarget target = null;
        if (ssel.size() == 1 && (input = ssel.getFirstElement()) instanceof ICDebugElement) {
            target = (ICDebugTarget)((ICDebugElement)input).getDebugTarget();
        }
        if ((current = this.getViewer().getInput()) == null && target == null) {
            return;
        }
        if (current != null && current.equals(target)) {
            return;
        }
        if (current != null) {
            this.fLastState = this.getViewerState();
            this.fSelectionStates.put(current, this.fLastState);
        }
        this.showViewer();
        this.getViewer().setInput((Object)target);
        if (target != null) {
            AbstractViewerState state = (AbstractViewerState)this.fSelectionStates.get(target);
            if (state == null) {
                state = this.fLastState;
            }
            if (state != null) {
                state.restoreState(this.getModulesViewer());
            }
        }
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        CDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        this.setSashForm(new SashForm(parent, 0));
        final ModulesViewer modulesViewer = new ModulesViewer((Composite)this.getSashForm(), 770);
        modulesViewer.setContentProvider(this.createContentProvider());
        modulesViewer.setLabelProvider(this.createLabelProvider((StructuredViewer)modulesViewer));
        modulesViewer.setUseHashlookup(true);
        modulesViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ModulesView.this.getModulesViewSelectionProvider().setUnderlyingSelectionProvider((ISelectionProvider)modulesViewer);
                ModulesView.this.setFocusViewer((Viewer)ModulesView.this.getModulesViewer());
            }
        });
        modulesViewer.addPostSelectionChangedListener(this.getTreeSelectionChangedListener());
        this.getModulesViewSelectionProvider().setUnderlyingSelectionProvider((ISelectionProvider)modulesViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.getModulesViewSelectionProvider());
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.setEventHandler(this.createEventHandler());
        return modulesViewer;
    }

    protected void createDetailsViewer() {
        SourceViewer detailsViewer = new SourceViewer((Composite)this.getSashForm(), null, 768);
        this.setDetailViewer((ISourceViewer)detailsViewer);
        detailsViewer.setDocument(this.getDetailDocument());
        detailsViewer.getTextWidget().setFont(JFaceResources.getFont((String)IInternalCDebugUIConstants.DETAIL_PANE_FONT));
        this.getDetailDocument().addDocumentListener(this.getDetailDocumentListener());
        detailsViewer.configure(new SourceViewerConfiguration());
        detailsViewer.setEditable(false);
        Control control = detailsViewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        detailsViewer.getSelectionProvider().addSelectionChangedListener(this.getDetailSelectionChangedListener());
        detailsViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ModulesView.this.getModulesViewSelectionProvider().setUnderlyingSelectionProvider(ModulesView.this.getDetailViewer().getSelectionProvider());
                ModulesView.this.setFocusViewer((Viewer)ModulesView.this.getDetailViewer());
            }
        });
        this.createDetailContextMenu((Control)detailsViewer.getTextWidget());
        detailsViewer.getTextWidget().addMouseListener((MouseListener)this.getCursorListener());
        detailsViewer.getTextWidget().addKeyListener((KeyListener)this.getCursorListener());
    }

    private void setDetailViewer(ISourceViewer viewer) {
        this.fDetailViewer = viewer;
    }

    protected ISourceViewer getDetailViewer() {
        return this.fDetailViewer;
    }

    protected SashForm getSashForm() {
        return this.fSashForm;
    }

    private void setSashForm(SashForm sashForm) {
        this.fSashForm = sashForm;
    }

    protected IContentProvider createContentProvider() {
        ModulesViewContentProvider cp = new ModulesViewContentProvider();
        cp.setExceptionHandler(this);
        return cp;
    }

    protected IBaseLabelProvider createLabelProvider(StructuredViewer viewer) {
        return this.getModelPresentation();
    }

    protected IDebugModelPresentation getModelPresentation() {
        if (this.fModelPresentation == null) {
            this.fModelPresentation = new ModulesViewModelPresentation();
        }
        return this.fModelPresentation;
    }

    protected ModulesViewSelectionProvider getModulesViewSelectionProvider() {
        return this.fSelectionProvider;
    }

    protected ModulesViewer getModulesViewer() {
        return (ModulesViewer)this.getViewer();
    }

    protected void setFocusViewer(Viewer viewer) {
        this.fFocusViewer = viewer;
    }

    protected Viewer getFocusViewer() {
        return this.fFocusViewer;
    }

    protected ISelectionChangedListener getTreeSelectionChangedListener() {
        if (this.fTreeSelectionChangedListener == null) {
            this.fTreeSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelectionProvider().equals((Object)ModulesView.this.getModulesViewer())) {
                        ModulesView.this.getModulesViewSelectionProvider().fireSelectionChanged(event);
                        if (ModulesView.this.getSashForm().getMaximizedControl() == ModulesView.this.getViewer().getControl()) {
                            return;
                        }
                        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                        ModulesView.this.populateDetailPaneFromSelection(selection);
                        ModulesView.this.treeSelectionChanged(event);
                    }
                }
            };
        }
        return this.fTreeSelectionChangedListener;
    }

    protected void treeSelectionChanged(SelectionChangedEvent event) {
    }

    public void populateDetailPane() {
        Viewer viewer;
        if (this.isDetailPaneVisible() && (viewer = this.getViewer()) != null) {
            IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
            this.populateDetailPaneFromSelection(selection);
        }
    }

    protected void populateDetailPaneFromSelection(IStructuredSelection selection) {
        this.getDetailDocument().set("");
        if (!selection.isEmpty()) {
            this.computeDetail(selection.getFirstElement());
        }
    }

    protected ISelectionChangedListener getDetailSelectionChangedListener() {
        if (this.fDetailSelectionChangedListener == null) {
            this.fDetailSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelectionProvider().equals(ModulesView.this.getModulesViewSelectionProvider().getUnderlyingSelectionProvider())) {
                        ModulesView.this.getModulesViewSelectionProvider().fireSelectionChanged(event);
                        ModulesView.this.updateSelectionDependentActions();
                    }
                }
            };
        }
        return this.fDetailSelectionChangedListener;
    }

    protected IDocumentListener getDetailDocumentListener() {
        if (this.fDetailDocumentListener == null) {
            this.fDetailDocumentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                }
            };
        }
        return this.fDetailDocumentListener;
    }

    protected IDocument getDetailDocument() {
        if (this.fDetailDocument == null) {
            this.fDetailDocument = new Document();
        }
        return this.fDetailDocument;
    }

    protected AbstractDebugEventHandler createEventHandler() {
        return new ModulesViewEventHandler(this);
    }

    protected void updateSelectionDependentActions() {
    }

    protected void updateAction(String actionId) {
        IAction action = this.getAction(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void createDetailContextMenu(Control menuControl) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ModulesView.this.fillDetailContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(menuControl);
        menuControl.setMenu(menu);
        this.getSite().registerContextMenu(ICDebugUIConstants.MODULES_VIEW_DETAIL_ID, menuMgr, this.getDetailViewer().getSelectionProvider());
        this.addContextMenuManager((IMenuManager)menuMgr);
    }

    protected void fillDetailContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("modulesGroup"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(ActionFactory.COPY.getId()));
        menu.add(this.getAction(ActionFactory.SELECT_ALL.getId()));
        menu.add((IContributionItem)new Separator("additions"));
        this.updateObjects();
    }

    private ICursorListener getCursorListener() {
        if (this.fCursorListener == null) {
            this.fCursorListener = new ICursorListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                }
            };
        }
        return this.fCursorListener;
    }

    public void setDetailPaneOrientation(String orientation) {
        if (orientation.equals(this.fCurrentDetailPaneOrientation)) {
            return;
        }
        if (orientation.equals("Modules.detail.orientation.hidden")) {
            this.hideDetailPane();
        } else {
            int vertOrHoriz = orientation.equals("Modules.detail.orientation.underneath") ? 512 : 256;
            this.getSashForm().setOrientation(vertOrHoriz);
            if ("Modules.detail.orientation.hidden".equals(this.fCurrentDetailPaneOrientation)) {
                this.showDetailPane();
            }
        }
        this.fCurrentDetailPaneOrientation = orientation;
        CDebugUIPlugin.getDefault().getPreferenceStore().setValue(this.getDetailPanePreferenceKey(), orientation);
    }

    private void hideDetailPane() {
        if (this.fToggledDetailOnce) {
            this.setLastSashWeights(this.getSashForm().getWeights());
        }
        this.getSashForm().setMaximizedControl(this.getViewer().getControl());
    }

    private void showDetailPane() {
        this.getSashForm().setMaximizedControl(null);
        this.getSashForm().setWeights(this.getLastSashWeights());
        this.populateDetailPane();
        this.revealTreeSelection();
        this.fToggledDetailOnce = true;
    }

    protected String getDetailPanePreferenceKey() {
        return "Modules.detail.orientation";
    }

    protected int[] getLastSashWeights() {
        if (this.fLastSashWeights == null) {
            this.fLastSashWeights = DEFAULT_SASH_WEIGHTS;
        }
        return this.fLastSashWeights;
    }

    protected void setLastSashWeights(int[] weights) {
        this.fLastSashWeights = weights;
    }

    private void createOrientationActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.fToggleDetailPaneActions = new ToggleDetailPaneAction[3];
        this.fToggleDetailPaneActions[0] = new ToggleDetailPaneAction(this, "Modules.detail.orientation.underneath", null);
        this.fToggleDetailPaneActions[1] = new ToggleDetailPaneAction(this, "Modules.detail.orientation.right", null);
        this.fToggleDetailPaneActions[2] = new ToggleDetailPaneAction(this, "Modules.detail.orientation.hidden", this.getToggleActionLabel());
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IAction)this.fToggleDetailPaneActions[0]);
        viewMenu.add((IAction)this.fToggleDetailPaneActions[1]);
        viewMenu.add((IAction)this.fToggleDetailPaneActions[2]);
        viewMenu.add((IContributionItem)new Separator());
    }

    protected String getToggleActionLabel() {
        return ModulesMessages.getString("ModulesView.0");
    }

    protected boolean isDetailPaneVisible() {
        return !this.fToggleDetailPaneActions[2].isChecked();
    }

    protected void revealTreeSelection() {
        Object selected;
        ISelection selection;
        ModulesViewer viewer = this.getModulesViewer();
        if (viewer != null && (selection = viewer.getSelection()) instanceof IStructuredSelection && (selected = ((IStructuredSelection)selection).getFirstElement()) != null) {
            viewer.reveal(selected);
        }
    }

    public void toggleDetailPaneWordWrap(boolean on) {
        this.fDetailViewer.getTextWidget().setWordWrap(on);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        SashForm sashForm = this.getSashForm();
        if (sashForm != null) {
            int[] weights = sashForm.getWeights();
            memento.putInteger(String.valueOf(SASH_WEIGHTS) + "-Length", weights.length);
            int i = 0;
            while (i < weights.length) {
                memento.putInteger(String.valueOf(SASH_WEIGHTS) + "-" + i, weights[i]);
                ++i;
            }
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            Integer bigI = memento.getInteger(String.valueOf(SASH_WEIGHTS) + "-Length");
            if (bigI == null) {
                return;
            }
            int numWeights = bigI;
            int[] weights = new int[numWeights];
            int i = 0;
            while (i < numWeights) {
                bigI = memento.getInteger(String.valueOf(SASH_WEIGHTS) + "-" + i);
                if (bigI == null) {
                    return;
                }
                weights[i] = bigI;
                ++i;
            }
            if (weights.length > 0) {
                this.setLastSashWeights(weights);
            }
        }
    }

    protected Control getDefaultControl() {
        return this.getSashForm();
    }

    protected void becomesHidden() {
        this.setViewerInput((IStructuredSelection)new StructuredSelection());
        super.becomesHidden();
    }

    protected void becomesVisible() {
        super.becomesVisible();
        IViewPart part = this.getSite().getPage().findView("org.eclipse.debug.ui.DebugView");
        if (part != null) {
            ISelection selection = this.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
            this.selectionChanged((IWorkbenchPart)part, selection);
        }
    }

    private void computeDetail(final Object element) {
        if (element != null) {
            DebugPlugin.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ModulesView.this.detailComputed(element, ModulesView.this.doComputeDetail(element));
                }
            });
        }
    }

    protected String doComputeDetail(Object element) {
        if (element instanceof ICModule) {
            return this.getModuleDetail((ICModule)element);
        }
        if (element instanceof ICElement) {
            return element.toString();
        }
        return "";
    }

    private String getModuleDetail(ICModule module) {
        long size;
        IAddress baseAddress;
        StringBuffer sb = new StringBuffer();
        String type = null;
        switch (module.getType()) {
            case 1: {
                type = ModulesMessages.getString("ModulesView.1");
                break;
            }
            case 2: {
                type = ModulesMessages.getString("ModulesView.2");
            }
        }
        if (type != null) {
            sb.append(ModulesMessages.getString("ModulesView.3"));
            sb.append(type);
            sb.append('\n');
        }
        sb.append(ModulesMessages.getString("ModulesView.4"));
        sb.append(module.areSymbolsLoaded() ? ModulesMessages.getString("ModulesView.5") : ModulesMessages.getString("ModulesView.6"));
        sb.append('\n');
        sb.append(ModulesMessages.getString("ModulesView.7"));
        sb.append(module.getSymbolsFileName().toOSString());
        sb.append('\n');
        String cpu = module.getCPU();
        if (cpu != null) {
            sb.append(ModulesMessages.getString("ModulesView.8"));
            sb.append(cpu);
            sb.append('\n');
        }
        if (!(baseAddress = module.getBaseAddress()).isZero()) {
            sb.append(ModulesMessages.getString("ModulesView.9"));
            sb.append(baseAddress.toHexAddressString());
            sb.append('\n');
        }
        if ((size = module.getSize()) > 0L) {
            sb.append(ModulesMessages.getString("ModulesView.10"));
            sb.append(size);
            sb.append('\n');
        }
        return sb.toString();
    }

    protected void detailComputed(Object element, final String result) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (ModulesView.this.isAvailable()) {
                    ModulesView.this.getDetailDocument().set(result);
                }
            }
        };
        this.asyncExec(runnable);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        CDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        Viewer viewer = this.getViewer();
        if (viewer != null) {
            this.getDetailDocument().removeDocumentListener(this.getDetailDocumentListener());
        }
        this.disposeImageCache();
        super.dispose();
    }

    private AbstractViewerState getViewerState() {
        return new ModulesViewerState(this.getModulesViewer());
    }

    protected Image getImage(ImageDescriptor desc) {
        Image image = (Image)this.fImageCache.get(desc);
        if (image == null) {
            image = desc.createImage();
            this.fImageCache.put(desc, image);
        }
        return image;
    }

    private void disposeImageCache() {
        Iterator it = this.fImageCache.values().iterator();
        while (it.hasNext()) {
            ((Image)it.next()).dispose();
        }
        this.fImageCache.clear();
    }

    class ModulesViewModelPresentation
    implements IDebugModelPresentation {
        private CDebugModelPresentation fDelegate;
        static /* synthetic */ Class class$0;

        ModulesViewModelPresentation() {
        }

        public void setAttribute(String attribute, Object value) {
            this.getModelPresentation().setAttribute(attribute, value);
        }

        public Image getImage(Object element) {
            Image image = this.getModelPresentation().getImage(element);
            if (image == null && element instanceof IAdaptable) {
                ImageDescriptor descriptor;
                IWorkbenchAdapter de;
                IAdaptable iAdaptable = (IAdaptable)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((de = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null && (descriptor = de.getImageDescriptor(element)) != null) {
                    image = ModulesView.this.getImage(descriptor);
                }
            }
            return image;
        }

        public String getText(Object element) {
            String text = this.getModelPresentation().getText(element);
            if (text == null && element instanceof IAdaptable) {
                IWorkbenchAdapter de;
                IAdaptable iAdaptable = (IAdaptable)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                text = (de = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null ? de.getLabel(element) : element.toString();
            }
            if (element instanceof ICModule) {
                ICModule module = (ICModule)element;
                text = String.valueOf(text) + (module.areSymbolsLoaded() ? ModulesMessages.getString("ModulesView.11") : ModulesMessages.getString("ModulesView.12"));
            }
            return text;
        }

        public void computeDetail(IValue value, IValueDetailListener listener) {
        }

        public IEditorInput getEditorInput(Object element) {
            return null;
        }

        public String getEditorId(IEditorInput input, Object element) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        private CDebugModelPresentation getModelPresentation() {
            if (this.fDelegate == null) {
                this.fDelegate = CDebugModelPresentation.getDefault();
            }
            return this.fDelegate;
        }
    }

    static interface ICursorListener
    extends MouseListener,
    KeyListener {
    }

    public class ModulesViewSelectionProvider
    implements ISelectionProvider {
        private ListenerList fListeners = new ListenerList();
        private ISelectionProvider fUnderlyingSelectionProvider;

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.add((Object)listener);
        }

        public ISelection getSelection() {
            return this.getUnderlyingSelectionProvider().getSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
            this.getUnderlyingSelectionProvider().setSelection(selection);
        }

        protected ISelectionProvider getUnderlyingSelectionProvider() {
            return this.fUnderlyingSelectionProvider;
        }

        protected void setUnderlyingSelectionProvider(ISelectionProvider underlyingSelectionProvider) {
            this.fUnderlyingSelectionProvider = underlyingSelectionProvider;
        }

        protected void fireSelectionChanged(SelectionChangedEvent event) {
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
                listener.selectionChanged(event);
                ++i;
            }
        }
    }
}

