/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisiblityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;

public class CPPMethod
extends CPPFunction
implements ICPPMethod {
    public CPPMethod(ICPPASTFunctionDeclarator declarator) {
        super(declarator);
    }

    public IASTDeclaration getPrimaryDeclaration() throws DOMException {
        if (this.declarations != null) {
            int i = 0;
            while (i < this.declarations.length) {
                IASTDeclarator dtor = this.declarations[i];
                while (dtor.getParent() instanceof IASTDeclarator) {
                    dtor = (IASTDeclarator)dtor.getParent();
                }
                IASTDeclaration decl = (IASTDeclaration)dtor.getParent();
                if (decl.getParent() instanceof ICPPASTCompositeTypeSpecifier) {
                    return decl;
                }
                ++i;
            }
        }
        char[] myName = this.getNameCharArray();
        ICPPClassScope scope = (ICPPClassScope)this.getScope();
        ICPPASTCompositeTypeSpecifier compSpec = (ICPPASTCompositeTypeSpecifier)scope.getPhysicalNode();
        IASTDeclaration[] members = compSpec.getMembers();
        int i = 0;
        while (i < members.length) {
            IASTName name;
            if (members[i] instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] dtors = ((IASTSimpleDeclaration)members[i]).getDeclarators();
                int j = 0;
                while (j < dtors.length) {
                    IASTName name2 = dtors[j].getName();
                    if (CharArrayUtils.equals(name2.toCharArray(), myName) && name2.resolveBinding() == this) {
                        return members[i];
                    }
                    ++j;
                }
            } else if (members[i] instanceof IASTFunctionDefinition && CharArrayUtils.equals((name = ((IASTFunctionDefinition)members[i]).getDeclarator().getName()).toCharArray(), myName) && name.resolveBinding() == this) {
                return members[i];
            }
            ++i;
        }
        return null;
    }

    public int getVisibility() throws DOMException {
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl == null) {
            ICPPClassType cls;
            IScope scope = this.getScope();
            if (scope instanceof ICPPClassScope && (cls = ((ICPPClassScope)scope).getClassType()) != null) {
                return cls.getKey() == 3 ? 3 : 1;
            }
            return 3;
        }
        IASTCompositeTypeSpecifier cls = (IASTCompositeTypeSpecifier)decl.getParent();
        IASTDeclaration[] members = cls.getMembers();
        ICPPASTVisiblityLabel vis = null;
        int i = 0;
        while (i < members.length) {
            if (members[i] instanceof ICPPASTVisiblityLabel) {
                vis = (ICPPASTVisiblityLabel)members[i];
            } else if (members[i] == decl) break;
            ++i;
        }
        if (vis != null) {
            return vis.getVisibility();
        }
        if (cls.getKey() == 3) {
            return 3;
        }
        return 1;
    }

    public IScope getScope() {
        ICPPASTFunctionDeclarator node;
        ICPPASTFunctionDeclarator iCPPASTFunctionDeclarator = node = this.declarations != null && this.declarations.length > 0 ? this.declarations[0] : this.definition;
        if (node instanceof IASTDeclarator) {
            IASTName name = ((IASTDeclarator)node).getName();
            if (name instanceof ICPPASTQualifiedName) {
                IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
                name = ns[ns.length - 1];
            }
            return CPPVisitor.getContainingScope(name);
        }
        return CPPVisitor.getContainingScope(node);
    }

    public String getName() {
        if (this.definition != null) {
            IASTName n = this.definition.getName();
            if (n instanceof ICPPASTQualifiedName) {
                IASTName[] ns = ((ICPPASTQualifiedName)n).getNames();
                return ns[ns.length - 1].toString();
            }
            return n.toString();
        }
        return this.declarations[0].getName().toString();
    }

    public char[] getNameCharArray() {
        if (this.definition != null) {
            IASTName n = this.definition.getName();
            if (n instanceof ICPPASTQualifiedName) {
                IASTName[] ns = ((ICPPASTQualifiedName)n).getNames();
                return ns[ns.length - 1].toCharArray();
            }
            return n.toCharArray();
        }
        return this.declarations[0].getName().toCharArray();
    }

    public ICPPDelegate createDelegate(IASTName name) {
        return new CPPMethodDelegate(name, this);
    }

    public boolean isVirtual() throws DOMException {
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl != null) {
            ICPPASTDeclSpecifier declSpec = null;
            if (decl instanceof IASTSimpleDeclaration) {
                declSpec = (ICPPASTDeclSpecifier)((IASTSimpleDeclaration)decl).getDeclSpecifier();
            } else if (decl instanceof IASTFunctionDefinition) {
                declSpec = (ICPPASTDeclSpecifier)((IASTFunctionDefinition)decl).getDeclSpecifier();
            }
            if (declSpec != null) {
                return declSpec.isVirtual();
            }
        }
        return false;
    }

    public boolean isInline() throws DOMException {
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl instanceof IASTFunctionDefinition) {
            return true;
        }
        if (decl == null) {
            return false;
        }
        IASTDeclSpecifier declSpec = ((IASTSimpleDeclaration)decl).getDeclSpecifier();
        return declSpec.isInline();
    }

    public boolean isMutable() {
        return CPPFunction.hasStorageClass(this, 6);
    }

    public boolean isDestructor() {
        char[] name = this.getNameCharArray();
        return name.length > 1 && name[0] == '~';
    }

    public static class CPPMethodDelegate
    extends CPPFunction.CPPFunctionDelegate
    implements ICPPMethod {
        public CPPMethodDelegate(IASTName name, ICPPMethod binding) {
            super(name, binding);
        }

        public int getVisibility() throws DOMException {
            return ((ICPPMethod)this.getBinding()).getVisibility();
        }

        public boolean isVirtual() throws DOMException {
            return ((ICPPMethod)this.getBinding()).isVirtual();
        }

        public boolean isDestructor() {
            char[] name = this.getNameCharArray();
            return name.length > 1 && name[0] == '~';
        }
    }

    public static class CPPMethodProblem
    extends CPPFunction.CPPFunctionProblem
    implements ICPPMethod {
        public CPPMethodProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public int getVisibility() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isStatic() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isVirtual() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isDestructor() {
            char[] name = this.getNameCharArray();
            return name.length > 1 && name[0] == '~';
        }
    }
}

