/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;

public class StreamMonitor
extends OutputStream {
    IProgressMonitor monitor;
    OutputStream console;
    public final int fTotalWork;
    private int halfWay;
    private int currentIncrement;
    private int nextProgress;
    private int worked;

    public StreamMonitor(IProgressMonitor mon, OutputStream cos, int totalWork) {
        this.nextProgress = this.currentIncrement = 2;
        this.worked = 0;
        this.monitor = mon;
        this.console = cos;
        this.fTotalWork = totalWork;
        this.halfWay = this.fTotalWork / 2;
        this.monitor.beginTask("", this.fTotalWork);
    }

    private void progressUpdate() {
        if (--this.nextProgress <= 0) {
            if (this.fTotalWork > this.worked) {
                this.monitor.worked(1);
            }
            ++this.worked;
            if (this.worked >= this.halfWay) {
                this.currentIncrement *= 2;
                this.halfWay += (this.fTotalWork - this.halfWay) / 2;
            }
            this.nextProgress = this.currentIncrement;
        }
    }

    public void close() throws IOException {
        if (this.console != null) {
            this.console.close();
        }
        this.monitor.done();
    }

    public void flush() throws IOException {
        if (this.console != null) {
            this.console.flush();
        }
    }

    public synchronized void write(int b) throws IOException {
        if (this.console != null) {
            this.console.write(b);
        }
        this.progressUpdate();
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off != 0 || len < 0 || len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.console != null) {
            this.console.write(b, off, len);
        }
        this.progressUpdate();
    }

    public int getWorkDone() {
        return this.worked;
    }
}

