/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.internal.core.model.CFloatingPointValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.w3c.dom.Document;

public class CDebugUtils {
    public static boolean question(IStatus status, Object source) {
        Boolean result = new Boolean(false);
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler != null) {
            try {
                result = (Boolean)handler.handleStatus(status, source);
            }
            catch (CoreException coreException) {}
        }
        return result;
    }

    public static void info(IStatus status, Object source) {
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler != null) {
            try {
                handler.handleStatus(status, source);
            }
            catch (CoreException coreException) {}
        }
    }

    public static void error(IStatus status, Object source) {
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler != null) {
            try {
                handler.handleStatus(status, source);
            }
            catch (CoreException coreException) {}
        }
    }

    public static char[] getByteText(byte b) {
        return new char[]{CDebugUtils.charFromByte((byte)(b >>> 4 & 0xF)), CDebugUtils.charFromByte((byte)(b & 0xF))};
    }

    public static byte textToByte(char[] text) {
        byte result = 0;
        if (text.length == 2) {
            byte[] bytes = new byte[]{CDebugUtils.charToByte(text[0]), CDebugUtils.charToByte(text[1])};
            result = (byte)((bytes[0] << 4) + bytes[1]);
        }
        return result;
    }

    public static char charFromByte(byte value) {
        if (value >= 0 && value <= 9) {
            return (char)(value + 48);
        }
        if (value >= 10 && value <= 15) {
            return (char)(value - 10 + 97);
        }
        return '0';
    }

    public static byte charToByte(char ch) {
        if (Character.isDigit(ch)) {
            return (byte)(ch - 48);
        }
        if (ch >= 'a' && ch <= 'f') {
            return (byte)(10 + ch - 97);
        }
        if (ch >= 'A' && ch <= 'F') {
            return (byte)(10 + ch - 65);
        }
        return 0;
    }

    public static char bytesToChar(byte[] bytes) {
        try {
            return (char)Short.parseShort(new String(bytes), 16);
        }
        catch (RuntimeException runtimeException) {
            return '\u0000';
        }
    }

    public static byte toByte(char[] bytes, boolean le) {
        if (bytes.length != 2) {
            return 0;
        }
        return (byte)Long.parseLong(CDebugUtils.bytesToString(bytes, le, true), 16);
    }

    public static short toUnsignedByte(char[] bytes, boolean le) {
        if (bytes.length != 2) {
            return 0;
        }
        return (short)Long.parseLong(CDebugUtils.bytesToString(bytes, le, false), 16);
    }

    public static short toShort(char[] bytes, boolean le) {
        if (bytes.length != 4) {
            return 0;
        }
        return (short)Long.parseLong(CDebugUtils.bytesToString(bytes, le, true), 16);
    }

    public static int toUnsignedShort(char[] bytes, boolean le) {
        if (bytes.length != 4) {
            return 0;
        }
        return (int)Long.parseLong(CDebugUtils.bytesToString(bytes, le, false), 16);
    }

    public static int toInt(char[] bytes, boolean le) {
        if (bytes.length != 8) {
            return 0;
        }
        return (int)Long.parseLong(CDebugUtils.bytesToString(bytes, le, true), 16);
    }

    public static long toUnsignedInt(char[] bytes, boolean le) {
        if (bytes.length != 8) {
            return 0L;
        }
        return Long.parseLong(CDebugUtils.bytesToString(bytes, le, false), 16);
    }

    private static String bytesToString(char[] bytes, boolean le, boolean signed) {
        char[] copy = new char[bytes.length];
        if (le) {
            int i = 0;
            while (i < bytes.length / 2) {
                copy[2 * i] = bytes[bytes.length - 2 * i - 2];
                copy[2 * i + 1] = bytes[bytes.length - 2 * i - 1];
                ++i;
            }
        } else {
            System.arraycopy(bytes, 0, copy, 0, copy.length);
        }
        return new String(copy);
    }

    public static String prependString(String text, int length, char ch) {
        StringBuffer sb = new StringBuffer(length);
        if (text.length() > length) {
            sb.append(text.substring(0, length));
        } else {
            char[] prefix = new char[length - text.length()];
            Arrays.fill(prefix, ch);
            sb.append(prefix);
            sb.append(text);
        }
        return sb.toString();
    }

    public static boolean isReferencedProject(IProject parent, IProject project) {
        if (parent != null && parent.exists()) {
            List projects = CDebugUtils.getReferencedProjects(project);
            Iterator it = projects.iterator();
            while (it.hasNext()) {
                IProject prj = (IProject)it.next();
                if (!prj.exists() || !prj.equals((Object)project)) continue;
                return true;
            }
        }
        return false;
    }

    public static String serializeDocument(Document doc) throws IOException, TransformerException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(s);
        transformer.transform(source, outputTarget);
        return s.toString("UTF8");
    }

    public static Number getFloatingPointValue(ICValue value) {
        if (value instanceof CFloatingPointValue) {
            try {
                return ((CFloatingPointValue)value).getFloatingPointValue();
            }
            catch (CDIException cDIException) {}
        }
        return null;
    }

    public static boolean isNaN(Number value) {
        if (value instanceof Double) {
            return ((Double)value).isNaN();
        }
        if (value instanceof Float) {
            return ((Float)value).isNaN();
        }
        return false;
    }

    public static boolean isPositiveInfinity(Number value) {
        if (value instanceof Double) {
            return ((Double)value).isInfinite() && value.doubleValue() == Double.POSITIVE_INFINITY;
        }
        if (value instanceof Float) {
            return ((Float)value).isInfinite() && value.floatValue() == Float.POSITIVE_INFINITY;
        }
        return false;
    }

    public static boolean isNegativeInfinity(Number value) {
        if (value instanceof Double) {
            return ((Double)value).isInfinite() && value.doubleValue() == Double.NEGATIVE_INFINITY;
        }
        if (value instanceof Float) {
            return ((Float)value).isInfinite() && value.floatValue() == Float.NEGATIVE_INFINITY;
        }
        return false;
    }

    public static List getReferencedProjects(IProject project) {
        ArrayList<IProject> list = new ArrayList<IProject>(10);
        if (project != null && project.exists() && project.isOpen()) {
            IProject[] refs = new IProject[]{};
            try {
                refs = project.getReferencedProjects();
            }
            catch (CoreException coreException) {}
            int i = 0;
            while (i < refs.length) {
                if (!project.equals((Object)refs[i]) && refs[i] != null && refs[i].exists() && refs[i].isOpen()) {
                    list.add(refs[i]);
                    CDebugUtils.getReferencedProjects(project, refs[i], list);
                }
                ++i;
            }
        }
        return list;
    }

    private static void getReferencedProjects(IProject root, IProject project, List list) {
        if (project != null && project.exists() && project.isOpen()) {
            IProject[] refs = new IProject[]{};
            try {
                refs = project.getReferencedProjects();
            }
            catch (CoreException coreException) {}
            int i = 0;
            while (i < refs.length) {
                if (!list.contains(refs[i]) && refs[i] != null && !refs[i].equals((Object)root) && refs[i].exists() && refs[i].isOpen()) {
                    list.add(refs[i]);
                    CDebugUtils.getReferencedProjects(root, refs[i], list);
                }
                ++i;
            }
        }
    }
}

