/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.cindexstorage;

import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.eclipse.cdt.internal.core.index.cindexstorage.IncludeEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexedFileEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.WordEntry;

public class Util {
    private Util() {
    }

    public static int compare(char[] str1, char[] str2) {
        int len1 = str1.length;
        int len2 = str2.length;
        int n = Math.min(len1, len2);
        int i = 0;
        while (n-- != 0) {
            char c2;
            char c1 = str1[i];
            if (c1 == (c2 = str2[i++])) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static int prefixLength(char[] s1, char[] s2) {
        int len = 0;
        int max = Math.min(s1.length, s2.length);
        int i = 0;
        while (i < max && s1[i] == s2[i]) {
            ++len;
            ++i;
        }
        return len;
    }

    public static int prefixLength(String s1, String s2) {
        int len = 0;
        int max = Math.min(s1.length(), s2.length());
        int i = 0;
        while (i < max && s1.charAt(i) == s2.charAt(i)) {
            ++len;
            ++i;
        }
        return len;
    }

    private static void quickSort(char[][] list, int left, int right) {
        int original_left = left;
        int original_right = right;
        char[] mid = list[(left + right) / 2];
        while (true) {
            if (Util.compare(list[left], mid) < 0) {
                ++left;
                continue;
            }
            while (Util.compare(mid, list[right]) < 0) {
                --right;
            }
            if (left <= right) {
                char[] tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(list, left, original_right);
        }
    }

    private static void quickSort(int[] list, int left, int right) {
        int original_left = left;
        int original_right = right;
        int mid = list[(left + right) / 2];
        while (true) {
            if (list[left] < mid) {
                ++left;
                continue;
            }
            while (mid < list[right]) {
                --right;
            }
            if (left <= right) {
                int tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(list, left, original_right);
        }
    }

    private static void quickSort(String[] list, int left, int right) {
        int original_left = left;
        int original_right = right;
        String mid = list[(left + right) / 2];
        while (true) {
            if (list[left].compareTo(mid) < 0) {
                ++left;
                continue;
            }
            while (mid.compareTo(list[right]) < 0) {
                --right;
            }
            if (left <= right) {
                String tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(list, left, original_right);
        }
    }

    private static void quickSort(IndexedFileEntry[] list, int left, int right) {
        int original_left = left;
        int original_right = right;
        String mid = list[(left + right) / 2].getPath();
        while (true) {
            if (list[left].getPath().compareTo(mid) < 0) {
                ++left;
                continue;
            }
            while (mid.compareTo(list[right].getPath()) < 0) {
                --right;
            }
            if (left <= right) {
                IndexedFileEntry tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(list, left, original_right);
        }
    }

    private static void quickSort(WordEntry[] list, int left, int right) {
        int original_left = left;
        int original_right = right;
        char[] mid = list[(left + right) / 2].getWord();
        while (true) {
            if (Util.compare(list[left].getWord(), mid) < 0) {
                ++left;
                continue;
            }
            while (Util.compare(mid, list[right].getWord()) < 0) {
                --right;
            }
            if (left <= right) {
                WordEntry tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(list, left, original_right);
        }
    }

    private static void quickSort(IncludeEntry[] list, int left, int right) {
        int original_left = left;
        int original_right = right;
        char[] mid = list[(left + right) / 2].fFile;
        while (true) {
            if (Util.compare(list[left].fFile, mid) < 0) {
                ++left;
                continue;
            }
            while (Util.compare(mid, list[right].fFile) < 0) {
                --right;
            }
            if (left <= right) {
                IncludeEntry tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(list, left, original_right);
        }
    }

    public static final char[] readUTF(DataInput in) throws IOException {
        int utflen = in.readUnsignedShort();
        char[] str = new char[utflen];
        int count = 0;
        int strlen = 0;
        while (count < utflen) {
            int c = in.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = in.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = in.readUnsignedByte();
                    int char3 = in.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        if (strlen < utflen) {
            char[] cArray = str;
            str = new char[strlen];
            System.arraycopy(cArray, 0, str, 0, strlen);
        }
        return str;
    }

    public static void sort(char[][] list) {
        if (list.length > 1) {
            Util.quickSort(list, 0, list.length - 1);
        }
    }

    public static void sort(int[] list) {
        if (list.length > 1) {
            Util.quickSort(list, 0, list.length - 1);
        }
    }

    public static void sort(String[] list) {
        if (list.length > 1) {
            Util.quickSort(list, 0, list.length - 1);
        }
    }

    public static void sort(IndexedFileEntry[] list) {
        if (list.length > 1) {
            Util.quickSort(list, 0, list.length - 1);
        }
    }

    public static void sort(WordEntry[] list) {
        if (list.length > 1) {
            Util.quickSort(list, 0, list.length - 1);
        }
    }

    public static void sort(IncludeEntry[] list) {
        if (list.length > 1) {
            Util.quickSort(list, 0, list.length - 1);
        }
    }

    public static void writeUTF(OutputStream out, char[] str) throws IOException {
        char c;
        int strlen = str.length;
        int utflen = 0;
        int i = 0;
        while (i < strlen) {
            c = str[i];
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        out.write(utflen >>> 8 & 0xFF);
        out.write(utflen >>> 0 & 0xFF);
        i = 0;
        while (i < strlen) {
            c = str[i];
            if (c >= '\u0001' && c <= '\u007f') {
                out.write(c);
            } else if (c > '\u07ff') {
                out.write(0xE0 | c >> 12 & 0xF);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c >> 0 & 0x3F);
            } else {
                out.write(0xC0 | c >> 6 & 0x1F);
                out.write(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
    }
}

