/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.model.IPathEntryContainerExtension;
import org.eclipse.cdt.core.model.PathEntryContainerChanged;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.PathEntryManager;

public class PathEntryContainerUpdatesOperation
extends CModelOperation {
    IPathEntryContainerExtension container;
    PathEntryContainerChanged[] events;

    public PathEntryContainerUpdatesOperation(IPathEntryContainerExtension container, PathEntryContainerChanged[] events) {
        super(CModelManager.getDefault().getCModel());
        this.container = container;
        this.events = events;
    }

    public boolean isReadOnly() {
        return true;
    }

    protected void executeOperation() throws CModelException {
        PathEntryManager pathEntryManager = PathEntryManager.getDefault();
        ArrayList<CElementDelta> list = new ArrayList<CElementDelta>(this.events.length);
        int i = 0;
        while (i < this.events.length) {
            PathEntryContainerChanged event = this.events[i];
            ICElement celement = CoreModel.getDefault().create(event.getPath());
            if (celement != null) {
                boolean foundContainer = false;
                IPathEntryContainer[] containers = pathEntryManager.getPathEntryContainers(celement.getCProject());
                int k = 0;
                while (k < containers.length) {
                    if (containers[k].getPath().equals((Object)this.container.getPath())) {
                        foundContainer = true;
                        break;
                    }
                    ++k;
                }
                if (foundContainer) {
                    if (celement instanceof IOpenable) {
                        try {
                            ((IOpenable)((Object)celement)).close();
                            if (!(celement instanceof ICProject)) {
                                celement.getCProject().close();
                            }
                        }
                        catch (CModelException cModelException) {}
                    }
                    int flag = 0;
                    if (event.isIncludeChange()) {
                        flag |= 0x800;
                    }
                    if (event.isMacroChange()) {
                        flag |= 0x400;
                    }
                    CElementDelta delta = new CElementDelta(celement.getCModel());
                    delta.changed(celement, flag);
                    list.add(delta);
                }
            }
            ++i;
        }
        if (list.size() > 0) {
            ICElementDelta[] deltas = new ICElementDelta[list.size()];
            list.toArray(deltas);
            CModelManager.getDefault();
            int i2 = 0;
            while (i2 < deltas.length) {
                this.addDelta(deltas[i2]);
                ++i2;
            }
        }
    }
}

