/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.processing;

import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMIndexRequest;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.search.processing.IIndexJob;
import org.eclipse.cdt.internal.core.search.processing.IndexingJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class JobManager
implements Runnable {
    protected IIndexJob[] awaitingJobs = new IIndexJob[10];
    protected int jobStart = 0;
    protected int jobEnd = -1;
    protected boolean executing = false;
    protected Thread thread;
    public static final int ENABLED = 1;
    public static final int DISABLED = 0;
    public static final int WAITING = 2;
    private int enabled = 1;
    public static boolean VERBOSE = false;
    public boolean activated = false;
    private int awaitingClients = 0;
    protected IndexingJob indexJob = null;
    private static final IStatus OK_STATUS = new Status(0, "org.eclipse.cdt.core", 0, "", null);
    private static final IStatus ERROR_STATUS = new Status(4, "org.eclipse.cdt.core", 4, "", null);

    public static void verbose(String log) {
        System.out.println("(" + Thread.currentThread() + ") " + log);
    }

    public IProgressMonitor getIndexJobProgressGroup() {
        if (this.indexJob == null) {
            return null;
        }
        return this.indexJob.getProgressGroup();
    }

    public void activateProcessing() {
        this.activated = true;
    }

    public synchronized int awaitingJobsCount() {
        if (!this.activated) {
            return 1;
        }
        return this.jobEnd - this.jobStart + 1;
    }

    public synchronized IIndexJob currentJob() {
        if (this.enabled != 1) {
            return null;
        }
        if (this.jobStart <= this.jobEnd) {
            return this.awaitingJobs[this.jobStart];
        }
        return null;
    }

    public synchronized void disable() {
        this.enabled = 0;
        if (VERBOSE) {
            JobManager.verbose("DISABLING background indexing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void discardJobs(String jobFamily) {
        if (VERBOSE) {
            JobManager.verbose("DISCARD   background job family - " + jobFamily);
        }
        int oldEnabledState = 0;
        try {
            IIndexJob currentJob;
            JobManager jobManager = this;
            synchronized (jobManager) {
                currentJob = this.currentJob();
                oldEnabledState = this.enabledState();
                this.disable();
            }
            if (currentJob != null && (jobFamily == null || currentJob.belongsTo(jobFamily))) {
                currentJob.cancel();
                while (this.thread != null && this.executing) {
                    try {
                        if (VERBOSE) {
                            JobManager.verbose("-> waiting end of current background job - " + currentJob);
                        }
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            int loc = -1;
            JobManager jobManager2 = this;
            synchronized (jobManager2) {
                int i = this.jobStart;
                while (true) {
                    block24: {
                        if (i <= this.jobEnd) break block24;
                        this.jobStart = 0;
                        this.jobEnd = loc;
                        break;
                    }
                    currentJob = this.awaitingJobs[i];
                    this.awaitingJobs[i] = null;
                    if (jobFamily != null && !currentJob.belongsTo(jobFamily)) {
                        this.awaitingJobs[++loc] = currentJob;
                    } else {
                        if (VERBOSE) {
                            JobManager.verbose("-> discarding background job  - " + currentJob);
                        }
                        currentJob.cancel();
                        if (this.indexJob != null && this.indexJob.tickDown(null) <= 0) {
                            this.indexJob.done(OK_STATUS);
                            this.indexJob = null;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (oldEnabledState == 1) {
                this.enable();
                throw throwable;
            }
            if (oldEnabledState != 2) throw throwable;
            this.pause();
            throw throwable;
        }
        {
            Object var7_10 = null;
            if (oldEnabledState == 1) {
                this.enable();
            } else if (oldEnabledState == 2) {
                this.pause();
            }
            if (!VERBOSE) return;
        }
        JobManager.verbose("DISCARD   DONE with background job family - " + jobFamily);
    }

    public synchronized void enable() {
        if (this.enabled == 2) {
            this.indexJob = new IndexingJob(this.thread, this);
            this.indexJob.setTicks(this.awaitingJobsCount());
        }
        this.enabled = 1;
        if (VERBOSE) {
            JobManager.verbose("ENABLING  background indexing");
        }
    }

    public synchronized int enabledState() {
        return this.enabled;
    }

    public synchronized void pause() {
        this.enabled = 2;
        if (VERBOSE) {
            JobManager.verbose("WAITING  pausing background indexing");
        }
    }

    protected synchronized void moveToNextJob() {
        if (this.jobStart <= this.jobEnd) {
            this.awaitingJobs[this.jobStart++] = null;
            if (this.jobStart > this.jobEnd) {
                this.jobStart = 0;
                this.jobEnd = -1;
            }
        }
        if (this.indexJob != null) {
            String progressString = null;
            IIndexJob job = this.currentJob();
            if (job instanceof DOMIndexRequest) {
                progressString = " (";
                progressString = String.valueOf(progressString) + job.toString();
                progressString = String.valueOf(progressString) + ")";
            }
            if (this.indexJob.tickDown(progressString) <= 0) {
                this.indexJob.done(OK_STATUS);
                this.indexJob = null;
            }
        }
    }

    protected void notifyIdle(long idlingTime) {
    }

    /*
     * Exception decompiling
     */
    public boolean performConcurrentJob(IIndexJob searchJob, int waitingPolicy, IProgressMonitor progress, IIndexJob jobToIgnore) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 235->238)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean jobShouldBeIgnored(IIndexJob jobToIgnore) {
        if (jobToIgnore == null) {
            return false;
        }
        return this.currentJob() == jobToIgnore;
    }

    public abstract String processName();

    public synchronized void request(IIndexJob job) {
        if (!job.isReadyToRun()) {
            if (VERBOSE) {
                JobManager.verbose("ABORTED request of background job - " + job);
            }
            return;
        }
        int size = this.awaitingJobs.length;
        if (++this.jobEnd == size) {
            this.jobEnd -= this.jobStart;
            this.awaitingJobs = new IIndexJob[size * 2];
            System.arraycopy(this.awaitingJobs, this.jobStart, this.awaitingJobs, 0, this.jobEnd);
            this.jobStart = 0;
        }
        this.awaitingJobs[this.jobEnd] = job;
        if (this.enabledState() == 2) {
            this.enable();
        } else if (this.enabledState() == 1) {
            if (this.indexJob == null) {
                this.indexJob = new IndexingJob(this.thread, this);
            } else {
                this.indexJob.tickUp();
            }
        }
        if (VERBOSE) {
            JobManager.verbose("REQUEST   background job - " + job);
        }
    }

    public void reset() {
        if (VERBOSE) {
            JobManager.verbose("Reset");
        }
        if (this.thread != null) {
            this.discardJobs(null);
        } else {
            this.thread = new Thread((Runnable)this, this.processName());
            this.thread.setDaemon(true);
            this.thread.setPriority(1);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        long idlingStart = -1L;
        this.activateProcessing();
        try {
            while (true) {
                if (this.thread == null) {
                    return;
                }
                try {
                    Object var4_5;
                    IIndexJob job = this.currentJob();
                    if (job == null) {
                        if (idlingStart < 0L) {
                            idlingStart = System.currentTimeMillis();
                        }
                        this.notifyIdle(System.currentTimeMillis() - idlingStart);
                        Thread.sleep(500L);
                        continue;
                    }
                    idlingStart = -1L;
                    if (VERBOSE) {
                        JobManager.verbose(String.valueOf(this.awaitingJobsCount()) + " awaiting jobs");
                        JobManager.verbose("STARTING background job - " + job);
                    }
                    try {
                        this.executing = true;
                        job.execute(null);
                    }
                    catch (Throwable throwable) {
                        var4_5 = null;
                        this.executing = false;
                        this.jobFinishedNotification(this.awaitingJobs[this.jobStart]);
                        if (VERBOSE) {
                            JobManager.verbose("FINISHED background job - " + job);
                        }
                        this.moveToNextJob();
                        if (this.awaitingClients != 0) throw throwable;
                        Thread.sleep(50L);
                        throw throwable;
                    }
                    {
                        var4_5 = null;
                        this.executing = false;
                        this.jobFinishedNotification(this.awaitingJobs[this.jobStart]);
                        if (VERBOSE) {
                            JobManager.verbose("FINISHED background job - " + job);
                        }
                        this.moveToNextJob();
                        if (this.awaitingClients != 0) continue;
                        Thread.sleep(50L);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (RuntimeException e) {
            if (this.indexJob != null) {
                this.indexJob.done(ERROR_STATUS);
                this.indexJob = null;
            }
            if (this.thread == null) throw e;
            Util.log(e, "Background Indexer Crash Recovery", ICLogConstants.PDE);
            this.discardJobs(null);
            this.thread = null;
            this.reset();
            throw e;
        }
        catch (Error e) {
            if (this.indexJob != null) {
                this.indexJob.done(ERROR_STATUS);
                this.indexJob = null;
            }
            if (this.thread == null) throw e;
            if (e instanceof ThreadDeath) throw e;
            Util.log(e, "Background Indexer Crash Recovery", ICLogConstants.PDE);
            this.discardJobs(null);
            this.thread = null;
            this.reset();
            throw e;
        }
    }

    public void shutdown() {
        this.disable();
        this.discardJobs(null);
        Thread thread = this.thread;
        this.thread = null;
        try {
            if (thread != null) {
                thread.join();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append("Enabled:").append(this.enabled).append('\n');
        int numJobs = this.jobEnd - this.jobStart + 1;
        buffer.append("Jobs in queue:").append(numJobs).append('\n');
        int i = 0;
        while (i < numJobs && i < 15) {
            buffer.append(i).append(" - job[" + i + "]: ").append(this.awaitingJobs[this.jobStart + i]).append('\n');
            ++i;
        }
        return buffer.toString();
    }

    protected abstract void jobFinishedNotification(IIndexJob var1);
}

