/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.disassembly;

import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyAnnotationModel;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyEditorInput;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;

public class DisassemblyDocumentProvider
implements IDocumentProvider,
IBreakpointsListener {
    private IDocument fDocument = new Document();
    private DisassemblyAnnotationModel fAnnotationModel = new DisassemblyAnnotationModel();

    public DisassemblyDocumentProvider() {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
    }

    public void connect(Object element) throws CoreException {
        if (element instanceof DisassemblyEditorInput) {
            String contents = ((DisassemblyEditorInput)element).getContents();
            this.fDocument.set(contents);
        } else {
            this.fDocument.set("");
        }
        this.fAnnotationModel.setInput(element instanceof DisassemblyEditorInput ? (DisassemblyEditorInput)element : null, this.fDocument);
    }

    public void disconnect(Object element) {
        this.fDocument.set("");
        this.fAnnotationModel.setInput(null, this.fDocument);
    }

    public IDocument getDocument(Object element) {
        return this.fDocument;
    }

    public void resetDocument(Object element) throws CoreException {
    }

    public void saveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
    }

    public long getModificationStamp(Object element) {
        return 0L;
    }

    public long getSynchronizationStamp(Object element) {
        return 0L;
    }

    public boolean isDeleted(Object element) {
        return false;
    }

    public boolean mustSaveDocument(Object element) {
        return false;
    }

    public boolean canSaveDocument(Object element) {
        return false;
    }

    public IAnnotationModel getAnnotationModel(Object element) {
        return this.fAnnotationModel;
    }

    public void aboutToChange(Object element) {
    }

    public void changed(Object element) {
    }

    public void addElementStateListener(IElementStateListener listener) {
    }

    public void removeElementStateListener(IElementStateListener listener) {
    }

    protected void dispose() {
        this.fDocument = null;
        if (this.fAnnotationModel != null) {
            this.fAnnotationModel.dispose();
            this.fAnnotationModel = null;
        }
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        this.fAnnotationModel.breakpointsAdded(breakpoints, this.fDocument);
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        this.fAnnotationModel.breakpointsChanged(breakpoints, this.fDocument);
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        this.fAnnotationModel.breakpointsRemoved(breakpoints, this.fDocument);
    }
}

