/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.OptionCategory;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HoldsOptions
extends BuildObject
implements IHoldsOptions {
    private static final IOptionCategory[] EMPTY_CATEGORIES = new IOptionCategory[0];
    protected IHoldsOptions superClass;
    private boolean resolved;
    private Vector categoryIds;
    private Map categoryMap;
    private List childOptionCategories;
    private Vector optionList;
    private Map optionMap;
    private boolean isDirty = false;

    private HoldsOptions() {
    }

    protected HoldsOptions(boolean resolved) {
        this.resolved = resolved;
    }

    protected void copyChildren(HoldsOptions source) {
        if (source.optionList != null) {
            ListIterator iter = source.getOptionList().listIterator();
            while (iter.hasNext()) {
                String subName;
                String subId;
                Option option = (Option)iter.next();
                int nnn = ManagedBuildManager.getRandomNumber();
                if (option.getSuperClass() != null) {
                    subId = String.valueOf(option.getSuperClass().getId()) + "." + nnn;
                    subName = option.getSuperClass().getName();
                } else {
                    subId = String.valueOf(option.getId()) + "." + nnn;
                    subName = option.getName();
                }
                Option newOption = new Option(this, subId, subName, option);
                this.addOption(newOption);
            }
        }
    }

    protected boolean loadChild(Node element) {
        if (element.getNodeName().equals("option")) {
            Option option = new Option((IHoldsOptions)this, (Element)element);
            this.addOption(option);
            return true;
        }
        if (element.getNodeName().equals("optionCategory")) {
            new OptionCategory((IHoldsOptions)this, (Element)element);
            return true;
        }
        return false;
    }

    protected boolean loadChild(IManagedConfigElement element) {
        if (element.getName().equals("option")) {
            Option option = new Option((IHoldsOptions)this, element);
            this.addOption(option);
            return true;
        }
        if (element.getName().equals("optionCategory")) {
            new OptionCategory((IHoldsOptions)this, element);
            return true;
        }
        return false;
    }

    protected void serialize(Document doc, Element element) throws BuildException {
        ListIterator iter;
        if (this.childOptionCategories != null) {
            iter = this.childOptionCategories.listIterator();
            while (iter.hasNext()) {
                OptionCategory optCat = (OptionCategory)iter.next();
                Element optCatElement = doc.createElement("option");
                element.appendChild(optCatElement);
                optCat.serialize(doc, optCatElement);
            }
        }
        Vector optionElements = this.getOptionList();
        iter = optionElements.listIterator();
        while (iter.hasNext()) {
            Option option = (Option)iter.next();
            Element optionElement = doc.createElement("option");
            element.appendChild(optionElement);
            option.serialize(doc, optionElement);
        }
    }

    public IOption createOption(IOption superClass, String Id, String name, boolean isExtensionElement) {
        Option option = new Option(this, superClass, Id, name, isExtensionElement);
        this.addOption(option);
        if (!isExtensionElement) {
            this.setDirty(true);
        }
        return option;
    }

    public void createOptions(IHoldsOptions superClass) {
        ListIterator iter = ((HoldsOptions)superClass).getOptionList().listIterator();
        while (iter.hasNext()) {
            Option optionChild = (Option)iter.next();
            int nnn = ManagedBuildManager.getRandomNumber();
            String subId = String.valueOf(optionChild.getId()) + "." + nnn;
            this.createOption(optionChild, subId, optionChild.getName(), false);
        }
    }

    public void removeOption(IOption option) {
        this.getOptionList().remove(option);
        this.getOptionMap().remove(option.getId());
        this.setDirty(true);
    }

    public IOption[] getOptions() {
        IOption[] newOptions;
        IOption[] options = null;
        if (this.superClass != null) {
            options = this.superClass.getOptions();
        }
        Vector ourOpts = this.getOptionList();
        if (options != null) {
            int i = 0;
            while (i < ourOpts.size()) {
                int j = options.length;
                IOption ourOpt = (IOption)ourOpts.get(i);
                if (ourOpt.getSuperClass() != null) {
                    String matchId = ourOpt.getSuperClass().getId();
                    j = 0;
                    block1: while (j < options.length) {
                        IOption superHolderOption = options[j];
                        if (((Option)superHolderOption).wasOptRef()) {
                            superHolderOption = superHolderOption.getSuperClass();
                        }
                        while (superHolderOption != null) {
                            if (matchId.equals(superHolderOption.getId())) {
                                options[j] = ourOpt;
                                break block1;
                            }
                            superHolderOption = superHolderOption.getSuperClass();
                        }
                        ++j;
                    }
                }
                if (j == options.length) {
                    newOptions = new IOption[options.length + 1];
                    int k = 0;
                    while (k < options.length) {
                        newOptions[k] = options[k];
                        ++k;
                    }
                    newOptions[j] = ourOpt;
                    options = newOptions;
                }
                ++i;
            }
        } else {
            options = ourOpts.toArray(new IOption[ourOpts.size()]);
        }
        int numInvalidOptions = 0;
        int i = 0;
        while (i < options.length) {
            if (!options[i].isValid()) {
                ++numInvalidOptions;
            }
            ++i;
        }
        if (numInvalidOptions > 0) {
            int j = 0;
            newOptions = new IOption[options.length - numInvalidOptions];
            i = 0;
            while (i < options.length) {
                if (options[i].isValid()) {
                    newOptions[j] = options[i];
                    ++j;
                }
                ++i;
            }
            options = newOptions;
        }
        return options;
    }

    public IOption getOption(String id) {
        return this.getOptionById(id);
    }

    public IOption getOptionById(String id) {
        IOption opt = (IOption)this.getOptionMap().get(id);
        if (opt == null && this.superClass != null) {
            return this.superClass.getOptionById(id);
        }
        if (opt == null) {
            return null;
        }
        return opt.isValid() ? opt : null;
    }

    public IOption getOptionBySuperClassId(String optionId) {
        if (optionId == null) {
            return null;
        }
        IOption[] options = this.getOptions();
        int i = 0;
        while (i < options.length) {
            IOption targetOption;
            IOption option = targetOption = options[i];
            do {
                if (!optionId.equals(option.getId())) continue;
                return targetOption.isValid() ? targetOption : null;
            } while ((option = option.getSuperClass()) != null);
            ++i;
        }
        return null;
    }

    public IOptionCategory[] getChildCategories() {
        IOptionCategory[] superCats = EMPTY_CATEGORIES;
        IOptionCategory[] ourCats = EMPTY_CATEGORIES;
        if (this.superClass != null) {
            superCats = this.superClass.getChildCategories();
        }
        if (this.childOptionCategories != null) {
            ourCats = this.childOptionCategories.toArray(new IOptionCategory[this.childOptionCategories.size()]);
        }
        if (superCats.length > 0 || ourCats.length > 0) {
            IOptionCategory[] allCats = new IOptionCategory[superCats.length + ourCats.length];
            int j = 0;
            while (j < superCats.length) {
                allCats[j] = superCats[j];
                ++j;
            }
            j = 0;
            while (j < ourCats.length) {
                allCats[j + superCats.length] = ourCats[j];
                ++j;
            }
            return allCats;
        }
        return EMPTY_CATEGORIES;
    }

    private Vector getCategoryIds() {
        if (this.categoryIds == null) {
            this.categoryIds = new Vector();
        }
        return this.categoryIds;
    }

    public void addChildCategory(IOptionCategory category) {
        if (this.childOptionCategories == null) {
            this.childOptionCategories = new ArrayList();
        }
        this.childOptionCategories.add(category);
    }

    public void addOption(Option option) {
        this.getOptionList().add(option);
        this.getOptionMap().put(option.getId(), option);
    }

    private Map getCategoryMap() {
        if (this.categoryMap == null) {
            this.categoryMap = new HashMap();
        }
        return this.categoryMap;
    }

    private Vector getOptionList() {
        if (this.optionList == null) {
            this.optionList = new Vector();
        }
        return this.optionList;
    }

    private Map getOptionMap() {
        if (this.optionMap == null) {
            this.optionMap = new HashMap();
        }
        return this.optionMap;
    }

    public void addOptionCategory(IOptionCategory category) {
        this.getCategoryIds().add(category.getId());
        this.getCategoryMap().put(category.getId(), category);
    }

    public IOptionCategory getOptionCategory(String id) {
        IOptionCategory cat = (IOptionCategory)this.getCategoryMap().get(id);
        if (cat == null && this.superClass != null) {
            return this.superClass.getOptionCategory(id);
        }
        return cat;
    }

    protected boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        Vector optionElements = this.getOptionList();
        ListIterator iter = optionElements.listIterator();
        while (iter.hasNext()) {
            Option option = (Option)iter.next();
            if (!option.isDirty()) continue;
            return true;
        }
        return this.isDirty;
    }

    protected void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        if (!isDirty) {
            Vector optionElements = this.getOptionList();
            ListIterator iter = optionElements.listIterator();
            while (iter.hasNext()) {
                Option option = (Option)iter.next();
                if (option.isExtensionElement()) continue;
                option.setDirty(false);
            }
        }
    }

    protected void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            Iterator optionIter = this.getOptionList().iterator();
            while (optionIter.hasNext()) {
                Option current = (Option)optionIter.next();
                current.resolveReferences();
            }
            Iterator catIter = this.getCategoryIds().iterator();
            while (catIter.hasNext()) {
                String id = (String)catIter.next();
                IOptionCategory current = (IOptionCategory)this.getCategoryMap().get(id);
                if (current instanceof Tool) {
                    ((Tool)current).resolveReferences();
                    continue;
                }
                if (current instanceof ToolChain) {
                    ((ToolChain)((Object)current)).resolveReferences();
                    continue;
                }
                if (!(current instanceof OptionCategory)) continue;
                ((OptionCategory)current).resolveReferences();
            }
        }
    }

    public IOption getOptionToSet(IOption option, boolean adjustExtension) throws BuildException {
        IOption setOption = null;
        if (option.getOptionHolder() != this) {
            option = this.getOptionBySuperClassId(option.getId());
        }
        if (adjustExtension) {
            while (option != null && !option.isExtensionElement()) {
                option = option.getSuperClass();
            }
            if (option != null) {
                IHoldsOptions holder = option.getOptionHolder();
                if (holder == this) {
                    setOption = option;
                } else {
                    IOption newSuperClass = option;
                    if (((Option)option).wasOptRef()) {
                        newSuperClass = option.getSuperClass();
                    }
                    String subId = String.valueOf(newSuperClass.getId()) + ".adjusted." + new Integer(ManagedBuildManager.getRandomNumber());
                    setOption = this.createOption(newSuperClass, subId, null, true);
                    ((Option)setOption).setAdjusted(true);
                    setOption.setValueType(option.getValueType());
                }
            }
        } else if (option.getOptionHolder() == this && !option.isExtensionElement()) {
            setOption = option;
        } else {
            IOption newSuperClass = option;
            while (newSuperClass != null && !newSuperClass.isExtensionElement()) {
                newSuperClass = newSuperClass.getSuperClass();
            }
            if (((Option)newSuperClass).wasOptRef()) {
                newSuperClass = newSuperClass.getSuperClass();
            }
            if (((Option)newSuperClass).isAdjustedExtension()) {
                newSuperClass = newSuperClass.getSuperClass();
            }
            int nnn = ManagedBuildManager.getRandomNumber();
            String subId = String.valueOf(newSuperClass.getId()) + "." + nnn;
            setOption = this.createOption(newSuperClass, subId, null, false);
            setOption.setValueType(option.getValueType());
        }
        return setOption;
    }
}

