/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTBaseSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.internal.core.parser.ast.quick.ASTScopedTypeSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.quick.IASTQClassSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.quick.IASTQScope;

public class ASTClassSpecifier
extends ASTScopedTypeSpecifier
implements IASTQClassSpecifier,
IASTQScope {
    private final char[] name;
    private List declarations = new ArrayList();
    private List baseClauses = new ArrayList();
    private List friends = new ArrayList();
    private ASTAccessVisibility access;
    private final IASTClassSpecifier.ClassNameType classNameType;
    private final ASTClassKind classKind;
    private final char[] fn;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;

    public ASTClassSpecifier(IASTScope scope, char[] name, ASTClassKind kind, IASTClassSpecifier.ClassNameType type, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLineNumber, ASTAccessVisibility access, char[] filename) {
        super(scope, name);
        this.classNameType = type;
        this.classKind = kind;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameLineNumber);
        this.access = access;
        this.name = name;
        this.fn = filename;
    }

    public char[] getFilename() {
        return this.fn;
    }

    public IASTClassSpecifier.ClassNameType getClassNameType() {
        return this.classNameType;
    }

    public ASTClassKind getClassKind() {
        return this.classKind;
    }

    public Iterator getBaseClauses() {
        return this.baseClauses.iterator();
    }

    public ASTAccessVisibility getCurrentVisibilityMode() {
        return this.access;
    }

    public Iterator getDeclarations() {
        return this.declarations.iterator();
    }

    public String getName() {
        return String.valueOf(this.name);
    }

    public void addDeclaration(IASTDeclaration declaration) {
        this.declarations.add(declaration);
    }

    public void addBaseClass(IASTBaseSpecifier baseSpecifier) {
        this.baseClauses.add(baseSpecifier);
    }

    public void setCurrentVisibility(ASTAccessVisibility visibility) {
        this.access = visibility;
    }

    public void acceptElement(ISourceElementRequestor requestor) {
    }

    public void enterScope(ISourceElementRequestor requestor) {
        try {
            requestor.enterClassSpecifier(this);
        }
        catch (Exception exception) {}
    }

    public void exitScope(ISourceElementRequestor requestor) {
        try {
            requestor.exitClassSpecifier(this);
        }
        catch (Exception exception) {}
    }

    public Iterator getFriends() {
        return this.friends.iterator();
    }

    public void addFriendDeclaration(IASTDeclaration decl) {
        this.friends.add(decl);
    }

    public final int getStartingLine() {
        return this.startingLineNumber;
    }

    public final int getEndingLine() {
        return this.endingLineNumber;
    }

    public final int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public final void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public final void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public final int getStartingOffset() {
        return this.startingOffset;
    }

    public final int getEndingOffset() {
        return this.endingOffset;
    }

    public final int getNameOffset() {
        return this.nameStartOffset;
    }

    public final void setNameOffset(int o) {
        this.nameStartOffset = o;
    }

    public final int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public final void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.nameEndOffset = offset;
        this.nameLineNumber = lineNumber;
    }

    public char[] getNameCharArray() {
        return this.name;
    }
}

