/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.parser.pst.BasicSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfoProvider;

public class ParameterizedSymbol
extends ContainerSymbol
implements IParameterizedSymbol {
    private List _parameterList = Collections.EMPTY_LIST;
    private CharArrayObjectMap _parameterMap = CharArrayObjectMap.EMPTY_MAP;
    private ISymbol _returnType;
    private boolean _hasVarArgs = false;

    protected ParameterizedSymbol(ParserSymbolTable table, char[] name) {
        super(table, name);
    }

    protected ParameterizedSymbol(ParserSymbolTable table, char[] name, ITypeInfo.eType typeInfo) {
        super(table, name, typeInfo);
    }

    public Object clone() {
        ParameterizedSymbol copy = (ParameterizedSymbol)super.clone();
        copy._parameterList = this._parameterList != Collections.EMPTY_LIST ? (List)((ArrayList)this._parameterList).clone() : this._parameterList;
        copy._parameterMap = this._parameterMap != CharArrayObjectMap.EMPTY_MAP ? (CharArrayObjectMap)this._parameterMap.clone() : this._parameterMap;
        return copy;
    }

    public ISymbol instantiate(ITemplateSymbol template, ObjectMap argMap) throws ParserSymbolTableException {
        if (!this.isTemplateMember()) {
            return null;
        }
        ParameterizedSymbol newParameterized = (ParameterizedSymbol)super.instantiate(template, argMap);
        if (this._returnType != null) {
            if (this._returnType.isType(ITypeInfo.t_templateParameter)) {
                if (argMap.containsKey(this._returnType)) {
                    newParameterized.setReturnType(this.getSymbolTable().newSymbol(ParserSymbolTable.EMPTY_NAME_ARRAY));
                    newParameterized.getReturnType().setTypeInfo((ITypeInfo)argMap.get(this._returnType));
                    newParameterized.getReturnType().setInstantiatedSymbol(this._returnType);
                }
            } else if (this._returnType instanceof IDeferredTemplateInstance) {
                template.registerDeferredInstatiation(newParameterized, this._returnType, ITemplateSymbol.DeferredKind.RETURN_TYPE, argMap);
            } else {
                newParameterized.setReturnType(this._returnType.instantiate(template, argMap));
            }
        }
        if (!this.isType(ITypeInfo.t_template)) {
            List params = this.getParameterList();
            int size = params.size();
            newParameterized.getParameterList().clear();
            newParameterized.getParameterMap().clear();
            ISymbol param = null;
            ISymbol newParam = null;
            int i = 0;
            while (i < size) {
                param = (ISymbol)params.get(i);
                newParam = param.instantiate(template, argMap);
                newParameterized.addParameter(newParam);
                ++i;
            }
        }
        return newParameterized;
    }

    public void instantiateDeferredReturnType(ISymbol returnType, ITemplateSymbol template, ObjectMap argMap) throws ParserSymbolTableException {
        this.setReturnType(returnType.instantiate(template, argMap));
    }

    public void discardDeferredReturnType(ISymbol oldReturnType, ITemplateSymbol template, ObjectMap map) {
        ISymbol returnType = this.getReturnType();
        this.setReturnType(null);
        template.removeInstantiation((IContainerSymbol)returnType);
    }

    public void prepareForParameters(int numParams) {
        if (this._parameterList == Collections.EMPTY_LIST) {
            this._parameterList = new ArrayList(numParams);
        } else {
            ((ArrayList)this._parameterList).ensureCapacity(numParams);
        }
    }

    public void addParameter(ISymbol param) {
        if (this._parameterList == Collections.EMPTY_LIST) {
            this._parameterList = new ArrayList(8);
        }
        this._parameterList.add(param);
        char[] name = param.getName();
        if (name != null && !name.equals(ParserSymbolTable.EMPTY_NAME_ARRAY)) {
            if (this._parameterMap == CharArrayObjectMap.EMPTY_MAP) {
                this._parameterMap = new CharArrayObjectMap(2);
            }
            if (!this._parameterMap.containsKey(name)) {
                this._parameterMap.put(name, param);
            }
        }
        param.setContainingSymbol(this);
        param.setIsTemplateMember(this.isTemplateMember() || this.getType() == ITypeInfo.t_template);
    }

    public void addParameter(ITypeInfo.eType type, int info, ITypeInfo.PtrOp ptrOp, boolean hasDefault) {
        BasicSymbol param = new BasicSymbol(this.getSymbolTable(), ParserSymbolTable.EMPTY_NAME_ARRAY);
        ITypeInfo t = TypeInfoProvider.newTypeInfo(type, info, ptrOp, hasDefault);
        param.setTypeInfo(t);
        this.addParameter(param);
    }

    public void addParameter(ISymbol typeSymbol, int info, ITypeInfo.PtrOp ptrOp, boolean hasDefault) {
        BasicSymbol param = new BasicSymbol(this.getSymbolTable(), ParserSymbolTable.EMPTY_NAME_ARRAY);
        ITypeInfo nfo = TypeInfoProvider.newTypeInfo(ITypeInfo.t_type, info, typeSymbol, ptrOp, hasDefault);
        param.setTypeInfo(nfo);
        this.addParameter(param);
    }

    public CharArrayObjectMap getParameterMap() {
        return this._parameterMap;
    }

    public List getParameterList() {
        return this._parameterList;
    }

    public boolean hasSameParameters(IParameterizedSymbol function) {
        int fsize;
        if (function.getType() != this.getType()) {
            return false;
        }
        int size = this.getParameterList() == null ? 0 : this.getParameterList().size();
        int n = fsize = function.getParameterList() == null ? 0 : function.getParameterList().size();
        if (fsize != size) {
            return false;
        }
        if (fsize == 0) {
            return true;
        }
        List params = this.getParameterList();
        List functionParams = function.getParameterList();
        ITypeInfo info = null;
        ITypeInfo fInfo = null;
        TypeInfoProvider provider = this.getSymbolTable().getTypeInfoProvider();
        int i = 0;
        while (i < size) {
            ISymbol p = (ISymbol)params.get(i);
            ISymbol pf = (ISymbol)functionParams.get(i);
            info = p.getTypeInfo();
            fInfo = pf.getTypeInfo();
            info = ParserSymbolTable.getFlatTypeInfo(info, provider);
            fInfo = ParserSymbolTable.getFlatTypeInfo(fInfo, provider);
            ITypeInfo nfo = info;
            while (nfo != null) {
                ITypeInfo.PtrOp op;
                List ptrs = nfo.getPtrOperators();
                if (ptrs.size() > 0 && (op = (ITypeInfo.PtrOp)ptrs.get(0)).getType() == ITypeInfo.PtrOp.t_array) {
                    ptrs.set(0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer, op.isConst(), op.isVolatile()));
                }
                if (nfo.isType(ITypeInfo.t_type) && nfo.getTypeSymbol() != null && nfo.getTypeSymbol().isType(ITypeInfo.t_function) && nfo.getPtrOperators().size() == 0) {
                    nfo.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer));
                }
                if (nfo.getPtrOperators().size() == 0) {
                    nfo.setBit(false, 1024);
                    nfo.setBit(false, 2048);
                } else {
                    op = (ITypeInfo.PtrOp)nfo.getPtrOperators().get(nfo.getPtrOperators().size() - 1);
                    op.setConst(false);
                    op.setVolatile(false);
                }
                if (nfo == fInfo) break;
                nfo = fInfo;
            }
            boolean equals = info.equals(fInfo);
            provider.returnTypeInfo(info);
            provider.returnTypeInfo(fInfo);
            if (!equals) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setReturnType(ISymbol type) {
        this._returnType = type;
        this._returnType.setContainingSymbol(this);
        this._returnType.setIsTemplateMember(this.isTemplateMember() || this.getType() == ITypeInfo.t_template);
    }

    public ISymbol getReturnType() {
        return this._returnType;
    }

    public void setHasVariableArgs(boolean var) {
        this._hasVarArgs = var;
    }

    public boolean hasVariableArgs() {
        return this._hasVarArgs;
    }
}

