/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.model.ICModule;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CModule;
import org.eclipse.cdt.debug.internal.core.model.CoreModelMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;

public class CModuleManager {
    private CDebugTarget fDebugTarget;
    private ArrayList fModules;

    public CModuleManager(CDebugTarget target) {
        this.fDebugTarget = target;
        this.fModules = new ArrayList(5);
    }

    public boolean hasModules() {
        return !this.fModules.isEmpty();
    }

    public ICModule[] getModules() {
        return this.fModules.toArray(new ICModule[this.fModules.size()]);
    }

    public void loadSymbolsForAll() throws DebugException {
        MultiStatus ms = new MultiStatus(CDIDebugModel.getPluginIdentifier(), 10002, CoreModelMessages.getString("CModuleManager.0"), null);
        Iterator it = this.fModules.iterator();
        while (it.hasNext()) {
            ICModule module = (ICModule)it.next();
            try {
                module.loadSymbols();
            }
            catch (DebugException e) {
                ms.add((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 10002, e.getMessage(), (Throwable)e));
            }
        }
        if (!ms.isOK()) {
            throw new DebugException((IStatus)ms);
        }
    }

    public void loadSymbols(ICModule[] modules) throws DebugException {
        MultiStatus ms = new MultiStatus(CDIDebugModel.getPluginIdentifier(), 10002, CoreModelMessages.getString("CModuleManager.1"), null);
        int i = 0;
        while (i < modules.length) {
            try {
                modules[i].loadSymbols();
            }
            catch (DebugException e) {
                ms.add((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 10002, e.getMessage(), (Throwable)e));
            }
            ++i;
        }
        if (!ms.isOK()) {
            throw new DebugException((IStatus)ms);
        }
    }

    public void dispose() {
        Iterator it = this.fModules.iterator();
        while (it.hasNext()) {
            ((CModule)it.next()).dispose();
        }
        this.fModules.clear();
    }

    protected CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    protected void addModules(ICModule[] modules) {
        this.fModules.addAll(Arrays.asList(modules));
    }

    protected void removeModules(ICModule[] modules) {
        this.fModules.removeAll(Arrays.asList(modules));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sharedLibraryLoaded(ICDISharedLibrary cdiLibrary) {
        CModule library = null;
        ArrayList arrayList = this.fModules;
        synchronized (arrayList) {
            if (this.find(cdiLibrary) == null) {
                library = CModule.createSharedLibrary(this.getDebugTarget(), cdiLibrary);
                this.fModules.add(library);
            }
        }
        if (library != null) {
            library.fireCreationEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sharedLibraryUnloaded(ICDISharedLibrary cdiLibrary) {
        CModule library = null;
        ArrayList arrayList = this.fModules;
        synchronized (arrayList) {
            library = this.find(cdiLibrary);
            if (library != null) {
                this.fModules.remove(library);
            }
        }
        if (library != null) {
            library.dispose();
            library.fireTerminateEvent();
        }
    }

    public void symbolsLoaded(ICDIObject cdiObject) {
        CModule module = this.find(cdiObject);
        if (module != null) {
            module.fireChangeEvent(256);
        }
    }

    private CModule find(ICDIObject cdiObject) {
        Iterator it = this.fModules.iterator();
        while (it.hasNext()) {
            CModule module = (CModule)it.next();
            if (!module.equals(cdiObject)) continue;
            return module;
        }
        return null;
    }
}

