/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.ConsoleOutputSniffer;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.StreamMonitor;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerInfoConsoleParserFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class MakeBuilder
extends ACBuilder {
    public static final String BUILDER_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".makeBuilder";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        boolean isClean;
        boolean bPerformBuild = true;
        IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(args, BUILDER_ID);
        if (!this.shouldBuild(kind, info)) {
            return new IProject[0];
        }
        if (kind == 9) {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta != null) {
                IResource res = delta.getResource();
                if (res != null) {
                    bPerformBuild = res.getProject().equals((Object)this.getProject());
                }
            } else {
                bPerformBuild = false;
            }
        }
        if (bPerformBuild && (isClean = this.invokeMake(kind, info, monitor))) {
            this.forgetLastBuiltState();
        }
        this.checkCancel(monitor);
        return this.getProject().getReferencedProjects();
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        final IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(this.getProject(), BUILDER_ID);
        if (this.shouldBuild(15, info)) {
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            final ISchedulingRule rule = ruleFactory.modifyRule((IResource)this.getProject());
            Job backgroundJob = new Job("Standard Make Builder"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(this, info){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ IMakeBuilderInfo val$info;
                            {
                                this.this$1 = var1_1;
                                this.val$info = iMakeBuilderInfo;
                            }

                            public void run(IProgressMonitor monitor) {
                                1.access$0(this.this$1).invokeMake(15, this.val$info, monitor);
                            }
                        }, rule, 1, monitor);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    IStatus returnStatus = Status.OK_STATUS;
                    return returnStatus;
                }

                static /* synthetic */ MakeBuilder access$0(1 var0) {
                    return var0.MakeBuilder.this;
                }
            };
            backgroundJob.setRule(rule);
            backgroundJob.schedule();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean invokeMake(int kind, IMakeBuilderInfo info, IProgressMonitor monitor) {
        boolean isClean = false;
        IProject currProject = this.getProject();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(String.valueOf(MakeMessages.getString("MakeBuilder.Invoking_Make_Builder")) + currProject.getName(), 100);
        try {
            try {
                IPath buildCommand = info.getBuildCommand();
                if (buildCommand != null) {
                    String[] buildArguments;
                    String[] env;
                    CommandLauncher launcher;
                    String errMsg;
                    IPath workingDirectory;
                    ConsoleOutputStream cos;
                    block26: {
                        String[] targets;
                        IResource res;
                        IConsole console = CCorePlugin.getDefault().getConsole();
                        console.start(currProject);
                        cos = console.getOutputStream();
                        this.removeAllMarkers(currProject);
                        workingDirectory = null;
                        if (!info.getBuildLocation().isEmpty() && (res = currProject.getParent().findMember(info.getBuildLocation())) instanceof IContainer && res.exists()) {
                            workingDirectory = res.getLocation();
                        }
                        if (workingDirectory == null) {
                            workingDirectory = currProject.getLocation();
                        }
                        if ((targets = this.getTargets(kind, info)).length != 0 && targets[targets.length - 1].equals(info.getCleanBuildTarget())) {
                            isClean = true;
                        }
                        errMsg = null;
                        launcher = new CommandLauncher();
                        launcher.showCommand(true);
                        HashMap<Object, Object> envMap = new HashMap<Object, Object>();
                        if (info.appendEnvironment()) {
                            envMap.putAll(launcher.getEnvironment());
                        }
                        envMap.put("CWD", workingDirectory.toOSString());
                        envMap.put("PWD", workingDirectory.toOSString());
                        envMap.putAll(info.getExpandedEnvironment());
                        Iterator iter = envMap.entrySet().iterator();
                        ArrayList<String> strings = new ArrayList<String>(envMap.size());
                        while (true) {
                            if (!iter.hasNext()) {
                                env = strings.toArray(new String[strings.size()]);
                                buildArguments = targets;
                                if (!info.isDefaultBuildCmd()) break;
                                if (!info.isStopOnError()) {
                                    buildArguments = new String[targets.length + 1];
                                    buildArguments[0] = "-k";
                                    System.arraycopy(targets, 0, buildArguments, 1, targets.length);
                                }
                                break block26;
                            }
                            Map.Entry entry = iter.next();
                            StringBuffer buffer = new StringBuffer((String)entry.getKey());
                            buffer.append('=').append((String)entry.getValue());
                            strings.add(buffer.toString());
                        }
                        String args = info.getBuildArguments();
                        if (args != null && !args.equals("")) {
                            String[] newArgs = this.makeArray(args);
                            buildArguments = new String[targets.length + newArgs.length];
                            System.arraycopy(newArgs, 0, buildArguments, 0, newArgs.length);
                            System.arraycopy(targets, 0, buildArguments, newArgs.length, targets.length);
                        }
                    }
                    QualifiedName qName = new QualifiedName(MakeCorePlugin.getUniqueIdentifier(), "progressMonitor");
                    Integer last = (Integer)this.getProject().getSessionProperty(qName);
                    if (last == null) {
                        last = new Integer(100);
                    }
                    StreamMonitor streamMon = new StreamMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 100), (OutputStream)cos, last);
                    ErrorParserManager epm = new ErrorParserManager(this.getProject(), workingDirectory, (IMarkerGenerator)this, info.getErrorParsers());
                    epm.setOutputStream((OutputStream)streamMon);
                    OutputStream stdout = epm.getOutputStream();
                    OutputStream stderr = epm.getOutputStream();
                    ConsoleOutputSniffer sniffer = ScannerInfoConsoleParserFactory.getMakeBuilderOutputSniffer(stdout, stderr, this.getProject(), workingDirectory, null, (IMarkerGenerator)this, null);
                    OutputStream consoleOut = sniffer == null ? stdout : sniffer.getOutputStream();
                    OutputStream consoleErr = sniffer == null ? stderr : sniffer.getErrorStream();
                    Process p = launcher.execute(buildCommand, buildArguments, env, workingDirectory);
                    if (p != null) {
                        try {
                            p.getOutputStream().close();
                        }
                        catch (IOException iOException) {}
                        monitor.subTask(String.valueOf(MakeMessages.getString("MakeBuilder.Invoking_Command")) + launcher.getCommandLine());
                        if (launcher.waitAndRead(consoleOut, consoleErr, (IProgressMonitor)new SubProgressMonitor(monitor, 0)) != 0) {
                            errMsg = launcher.getErrorMessage();
                        }
                        monitor.subTask(MakeMessages.getString("MakeBuilder.Updating_project"));
                        try {
                            currProject.refreshLocal(2, null);
                        }
                        catch (CoreException coreException) {}
                    } else {
                        errMsg = launcher.getErrorMessage();
                    }
                    this.getProject().setSessionProperty(qName, !monitor.isCanceled() && !isClean ? new Integer(streamMon.getWorkDone()) : null);
                    if (errMsg != null) {
                        StringBuffer buf = new StringBuffer(String.valueOf(buildCommand.toString()) + " ");
                        int i = 0;
                        while (true) {
                            if (i >= buildArguments.length) {
                                String errorDesc = MakeMessages.getFormattedString("MakeBuilder.buildError", buf.toString());
                                buf = new StringBuffer(errorDesc);
                                buf.append(System.getProperty("line.separator", "\n"));
                                buf.append("(").append(errMsg).append(")");
                                cos.write(buf.toString().getBytes());
                                cos.flush();
                                break;
                            }
                            buf.append(buildArguments[i]);
                            buf.append(' ');
                            ++i;
                        }
                    }
                    stdout.close();
                    stderr.close();
                    monitor.subTask(MakeMessages.getString("MakeBuilder.Creating_Markers"));
                    consoleOut.close();
                    consoleErr.close();
                    epm.reportProblems();
                    cos.close();
                }
            }
            catch (Exception e) {
                CCorePlugin.log((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var30_33 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var30_34 = null;
        }
        monitor.done();
        return isClean;
    }

    public void checkCancel(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected boolean shouldBuild(int kind, IMakeBuilderInfo info) {
        switch (kind) {
            case 9: {
                return info.isAutoBuildEnable();
            }
            case 10: {
                return info.isIncrementalBuildEnabled();
            }
            case 6: {
                return info.isFullBuildEnabled();
            }
            case 15: {
                return info.isCleanBuildEnabled();
            }
        }
        return true;
    }

    protected String[] getTargets(int kind, IMakeBuilderInfo info) {
        String targets = "";
        switch (kind) {
            case 9: {
                targets = info.getAutoBuildTarget();
                break;
            }
            case 10: {
                targets = info.getIncrementalBuildTarget();
                break;
            }
            case 6: {
                targets = info.getFullBuildTarget();
                break;
            }
            case 15: {
                targets = info.getCleanBuildTarget();
            }
        }
        return this.makeArray(targets);
    }

    String[] makeArray(String string) {
        string.trim();
        char[] array = string.toCharArray();
        ArrayList<String> aList = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        boolean inComment = false;
        int i = 0;
        while (i < array.length) {
            char c = array[i];
            if (array[i] == '\"' || array[i] == '\'') {
                if (i > 0 && array[i - 1] == '\\') {
                    inComment = false;
                } else {
                    boolean bl = inComment = !inComment;
                }
            }
            if (c == ' ' && !inComment) {
                aList.add(buffer.toString());
                buffer = new StringBuffer();
            } else {
                buffer.append(c);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            aList.add(buffer.toString());
        }
        return aList.toArray(new String[aList.size()]);
    }

    private void removeAllMarkers(IProject currProject) throws CoreException {
        IWorkspace workspace = currProject.getWorkspace();
        IMarker[] markers = currProject.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        if (markers != null) {
            workspace.deleteMarkers(markers);
        }
    }
}

