/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.internal.core.model.ArchiveContainer;
import org.eclipse.cdt.internal.core.model.BinaryContainer;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModel;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.Job;

public class BinaryRunner {
    ICProject cproject;
    Job runner;

    public BinaryRunner(IProject prj) {
        this.cproject = CModelManager.getDefault().create(prj);
    }

    public void start() {
        String taskName = CCorePlugin.getResourceString("CoreModel.BinaryRunner.Binary_Search_Thread");
        this.runner = new Job(taskName){

            protected IStatus run(IProgressMonitor monitor) {
                if (BinaryRunner.this.cproject == null || monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    monitor.beginTask(this.getName(), -1);
                    BinaryContainer vbin = (BinaryContainer)BinaryRunner.this.cproject.getBinaryContainer();
                    ArchiveContainer vlib = (ArchiveContainer)BinaryRunner.this.cproject.getArchiveContainer();
                    vlib.removeChildren();
                    vbin.removeChildren();
                    BinaryRunner.this.cproject.getProject().accept((IResourceProxyVisitor)new Visitor(monitor), 1);
                    BinaryRunnerOperation op = new BinaryRunnerOperation(BinaryRunner.this.cproject);
                    op.runOperation(monitor);
                    monitor.done();
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        this.runner.schedule();
    }

    public void waitIfRunning() {
        if (this.runner != null) {
            try {
                this.runner.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stop() {
        if (this.runner != null && this.runner.getState() == 4) {
            this.runner.cancel();
        }
    }

    class BinaryRunnerOperation
    extends CModelOperation {
        BinaryRunnerOperation(ICProject cproj) {
            super(cproj);
        }

        public boolean isReadOnly() {
            return true;
        }

        protected void executeOperation() throws CModelException {
            ICProject cproj = (ICProject)this.getElementsToProcess()[0];
            IParent[] containers = new IParent[]{cproj.getBinaryContainer(), cproj.getArchiveContainer()};
            CModelManager factory = CModelManager.getDefault();
            CModel root = factory.getCModel();
            CElementDelta cdelta = new CElementDelta(root);
            cdelta.changed(cproj, 1);
            int j = 0;
            while (j < containers.length) {
                IParent container = containers[j];
                ICElement[] children = container.getChildren();
                if (children.length > 0) {
                    cdelta.added((ICElement)((Object)container));
                    int i = 0;
                    while (i < children.length) {
                        cdelta.added(children[i]);
                        ++i;
                    }
                }
                ++j;
            }
            this.addDelta(cdelta);
        }
    }

    private class Visitor
    implements IResourceProxyVisitor {
        private IProgressMonitor vMonitor;
        private IProject project;
        private IOutputEntry[] entries = new IOutputEntry[0];
        private IContentType textContentType;

        public Visitor(IProgressMonitor monitor) {
            this.vMonitor = monitor;
            this.project = BinaryRunner.this.cproject.getProject();
            try {
                this.entries = BinaryRunner.this.cproject.getOutputEntries();
            }
            catch (CModelException cModelException) {}
            IContentTypeManager mgr = Platform.getContentTypeManager();
            this.textContentType = mgr.getContentType("org.eclipse.core.runtime.text");
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            IPath path;
            if (this.vMonitor.isCanceled()) {
                return false;
            }
            this.vMonitor.worked(1);
            if (proxy.getType() != 1) {
                return true;
            }
            String name = proxy.getName();
            IContentType contentType = CCorePlugin.getContentType(this.project, name);
            if (contentType != null && this.textContentType != null) {
                if (contentType != null && contentType.isKindOf(this.textContentType)) {
                    return true;
                }
                if (this.textContentType.isAssociatedWith(name)) {
                    return true;
                }
            }
            if ((path = proxy.requestFullPath()) != null) {
                int i = 0;
                while (i < this.entries.length) {
                    if (this.isOnOutputEntry(this.entries[i], path)) {
                        IFile file = (IFile)proxy.requestResource();
                        CModelManager factory = CModelManager.getDefault();
                        IBinaryParser.IBinaryFile bin = factory.createBinaryFile(file);
                        if (bin != null) {
                            factory.create(file, bin, BinaryRunner.this.cproject);
                            return true;
                        }
                    }
                    ++i;
                }
            }
            return true;
        }

        private boolean isOnOutputEntry(IOutputEntry entry, IPath path) {
            return entry.getPath().isPrefixOf(path) && !CoreModelUtil.isExcluded(path, entry.fullExclusionPatternChars());
        }
    }
}

