/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.domsourceindexer;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexedFileEntry;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexer;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexerRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class IndexEncoderUtil {
    private static boolean visitedExternalHeader = false;
    private static String lastVisitedFile = null;

    public static int calculateIndexFlags(DOMSourceIndexerRunner indexer, IASTFileLocation loc) {
        String fileName;
        int fileNum = 0;
        String fullPath = indexer.getResourceFile().getFullPath().toString();
        IndexedFileEntry mainIndexFile = indexer.getOutput().getIndexedFile(fullPath);
        if (mainIndexFile != null) {
            fileNum = mainIndexFile.getFileID();
        }
        if ((fileName = loc.getFileName()) != null) {
            IFile tempFile = CCorePlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName));
            String filePath = "";
            filePath = tempFile != null ? tempFile.getFullPath().toString() : fileName;
            if (!filePath.equals(fullPath)) {
                IndexedFileEntry indFile = indexer.getOutput().getIndexedFile(filePath);
                if (indFile != null) {
                    fileNum = indFile.getFileID();
                } else {
                    indFile = indexer.getOutput().addIndexedFile(filePath);
                    if (indFile != null) {
                        fileNum = indFile.getFileID();
                    }
                }
            }
        }
        return fileNum;
    }

    public static IASTFileLocation getFileLocation(IASTNode node) {
        return node.getFileLocation();
    }

    public static boolean nodeInExternalHeader(IASTNode node) {
        String fileName = node.getContainingFilename();
        return CCorePlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName)) == null;
    }

    public static boolean nodeInVisitedExternalHeader(IASTNode node, DOMSourceIndexer indexer) {
        String fileName = node.getContainingFilename();
        if (fileName.equals(lastVisitedFile)) {
            return visitedExternalHeader;
        }
        lastVisitedFile = fileName;
        Path filePath = new Path(fileName);
        IPath projectPath = indexer.getProject().getFullPath();
        visitedExternalHeader = CCorePlugin.getWorkspace().getRoot().getFileForLocation((IPath)filePath) == null && indexer.haveEncounteredHeader(projectPath, (IPath)filePath, false);
        return visitedExternalHeader;
    }
}

