/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.ast;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICArrayType;
import org.eclipse.cdt.core.dom.ast.c.ICBasicType;
import org.eclipse.cdt.core.dom.ast.c.ICPointerType;
import org.eclipse.cdt.core.dom.ast.c.ICQualifierType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPBasicType;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPPointerType;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPQualifierType;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTTypeId;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTypeId;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;

public class ASTTypeUtil {
    private static final String COMMA_SPACE = ", ";
    private static final String EMPTY_STRING = "";
    private static final String SPACE = " ";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final int DEAULT_ITYPE_SIZE = 2;
    static /* synthetic */ Class class$0;

    public static String getParameterTypeString(IFunctionType type) {
        StringBuffer result = new StringBuffer();
        String[] parms = ASTTypeUtil.getParameterTypeStringArray(type);
        result.append(Keywords.cpLPAREN);
        int i = 0;
        while (i < parms.length) {
            if (parms[i] != null) {
                result.append(parms[i]);
                if (i < parms.length - 1) {
                    result.append(COMMA_SPACE);
                }
            }
            ++i;
        }
        result.append(Keywords.cpRPAREN);
        return result.toString();
    }

    public static String[] getParameterTypeStringArray(IFunctionType type) {
        IType[] parms = null;
        try {
            parms = type.getParameterTypes();
        }
        catch (DOMException dOMException) {
            return EMPTY_STRING_ARRAY;
        }
        String[] result = new String[parms.length];
        int i = 0;
        while (i < parms.length) {
            if (parms[i] != null) {
                result[i] = ASTTypeUtil.getType(parms[i]);
            }
            ++i;
        }
        return result;
    }

    private static String getTypeString(IType type) {
        StringBuffer result = new StringBuffer();
        boolean needSpace = false;
        if (type instanceof IArrayType) {
            result.append(Keywords.cpLBRACKET);
            if (type instanceof ICArrayType) {
                try {
                    if (((ICArrayType)type).isConst()) {
                        result.append("const");
                        needSpace = true;
                    }
                    if (((ICArrayType)type).isRestrict()) {
                        if (needSpace) {
                            result.append(SPACE);
                            needSpace = false;
                        }
                        result.append("restrict");
                        needSpace = true;
                    }
                    if (((ICArrayType)type).isStatic()) {
                        if (needSpace) {
                            result.append(SPACE);
                            needSpace = false;
                        }
                        result.append("static");
                        needSpace = true;
                    }
                    if (((ICArrayType)type).isVolatile()) {
                        if (needSpace) {
                            result.append(SPACE);
                            needSpace = false;
                        }
                        result.append("volatile");
                    }
                }
                catch (DOMException dOMException) {}
            }
            result.append(Keywords.cpRBRACKET);
        } else if (type instanceof IBasicType) {
            try {
                if (((IBasicType)type).isSigned()) {
                    result.append("signed");
                    needSpace = true;
                } else if (((IBasicType)type).isUnsigned()) {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("unsigned");
                    needSpace = true;
                }
                if (((IBasicType)type).isLong()) {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("long");
                    needSpace = true;
                } else if (((IBasicType)type).isShort()) {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("short");
                    needSpace = true;
                }
            }
            catch (DOMException dOMException) {}
            if (type instanceof IGPPBasicType) {
                try {
                    if (((IGPPBasicType)type).isLongLong()) {
                        if (needSpace) {
                            result.append(SPACE);
                            needSpace = false;
                        }
                        result.append("long long");
                        needSpace = true;
                    }
                    if (((IGPPBasicType)type).isComplex()) {
                        if (needSpace) {
                            result.append(SPACE);
                            needSpace = false;
                        }
                        result.append(Keywords.c_COMPLEX);
                        needSpace = true;
                    }
                    if (((IGPPBasicType)type).isImaginary()) {
                        if (needSpace) {
                            result.append(SPACE);
                            needSpace = false;
                        }
                        result.append(Keywords.c_IMAGINARY);
                        needSpace = true;
                    }
                    switch (((IGPPBasicType)type).getType()) {
                        case 8: {
                            result.append("typeof");
                        }
                    }
                }
                catch (DOMException dOMException) {}
            } else if (type instanceof ICPPBasicType) {
                try {
                    switch (((ICPPBasicType)type).getType()) {
                        case 6: {
                            result.append("bool");
                            break;
                        }
                        case 7: {
                            result.append("wchar_t");
                        }
                    }
                }
                catch (DOMException dOMException) {}
            } else if (type instanceof ICBasicType) {
                try {
                    if (((ICBasicType)type).isComplex()) {
                        if (needSpace) {
                            result.append(SPACE);
                            needSpace = false;
                        }
                        result.append(Keywords.c_COMPLEX);
                        needSpace = true;
                    }
                    if (((ICBasicType)type).isImaginary()) {
                        if (needSpace) {
                            result.append(SPACE);
                            needSpace = false;
                        }
                        result.append(Keywords.c_IMAGINARY);
                        needSpace = true;
                    }
                    switch (((ICBasicType)type).getType()) {
                        case 6: {
                            result.append(Keywords.c_BOOL);
                        }
                    }
                }
                catch (DOMException dOMException) {}
            }
            try {
                if (needSpace) {
                    result.append(SPACE);
                }
                switch (((IBasicType)type).getType()) {
                    case 2: {
                        result.append("char");
                        break;
                    }
                    case 5: {
                        result.append("double");
                        break;
                    }
                    case 4: {
                        result.append("float");
                        break;
                    }
                    case 3: {
                        result.append("int");
                        break;
                    }
                    case 1: {
                        result.append("void");
                    }
                }
            }
            catch (DOMException dOMException) {}
        } else if (type instanceof ICompositeType) {
            result.append(((ICompositeType)type).getName());
        } else if (type instanceof ICPPReferenceType) {
            result.append(Keywords.cpAMPER);
        } else if (type instanceof ICPPTemplateTypeParameter) {
            result.append(((ICPPTemplateTypeParameter)type).getName());
        } else if (type instanceof ICPPTemplateTemplateParameter) {
            result.append(((ICPPTemplateTemplateParameter)((Object)type)).getName());
        } else if (type instanceof IEnumeration) {
            result.append("enum");
            result.append(SPACE);
            result.append(((IEnumeration)type).getName());
        } else if (type instanceof IFunctionType) {
            try {
                String temp = ASTTypeUtil.getType(((IFunctionType)type).getReturnType());
                if (temp != null && !temp.equals(EMPTY_STRING)) {
                    result.append(temp);
                    needSpace = true;
                }
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                if ((temp = ASTTypeUtil.getParameterTypeString((IFunctionType)type)) != null && !temp.equals(EMPTY_STRING)) {
                    result.append(temp);
                    needSpace = false;
                }
            }
            catch (DOMException dOMException) {}
        } else if (type instanceof IPointerType) {
            result.append(Keywords.cpSTAR);
            needSpace = true;
            if (type instanceof IGPPPointerType) {
                if (((IGPPPointerType)type).isRestrict()) {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("restrict");
                    needSpace = true;
                }
            } else if (type instanceof ICPointerType && ((ICPointerType)type).isRestrict()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("restrict");
                needSpace = true;
            }
            try {
                if (((IPointerType)type).isConst()) {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("const");
                    needSpace = true;
                }
                if (((IPointerType)type).isVolatile()) {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("volatile");
                    needSpace = true;
                }
            }
            catch (DOMException dOMException) {}
        } else if (type instanceof IQualifierType) {
            if (type instanceof ICQualifierType) {
                if (((ICQualifierType)type).isRestrict()) {
                    result.append("restrict");
                    needSpace = true;
                }
            } else if (type instanceof IGPPQualifierType && ((IGPPQualifierType)type).isRestrict()) {
                result.append("restrict");
                needSpace = true;
            }
            try {
                if (((IQualifierType)type).isConst()) {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("const");
                    needSpace = true;
                }
                if (((IQualifierType)type).isVolatile()) {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("volatile");
                    needSpace = true;
                }
            }
            catch (DOMException dOMException) {}
        }
        return result.toString();
    }

    public static String getType(IType type) {
        StringBuffer result = new StringBuffer();
        Object[] types = new IType[2];
        while (type != null && type instanceof ITypeContainer) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.cdt.core.dom.ast.IType");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            types = (IType[])ArrayUtil.append(clazz, types, type);
            try {
                type = ((ITypeContainer)type).getType();
            }
            catch (DOMException dOMException) {}
        }
        if (type != null && !(type instanceof ITypeContainer)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IType");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            types = (IType[])ArrayUtil.append(clazz, types, type);
        }
        int j = types.length - 1;
        while (j >= 0) {
            if (!(types[j] instanceof ITypedef)) {
                if (types[j] != null && result.length() > 0) {
                    result.append(SPACE);
                }
                if (types[j] != null) {
                    if (j > 0 && types[j - 1] instanceof IQualifierType) {
                        result.append(ASTTypeUtil.getTypeString((IType)types[j - 1]));
                        result.append(SPACE);
                        result.append(ASTTypeUtil.getTypeString((IType)types[j]));
                        --j;
                    } else {
                        result.append(ASTTypeUtil.getTypeString((IType)types[j]));
                    }
                }
            }
            --j;
        }
        return result.toString();
    }

    public static String getType(IASTDeclarator decltor) {
        while (decltor.getNestedDeclarator() != null) {
            decltor = decltor.getNestedDeclarator();
        }
        IBinding binding = decltor.getName().resolveBinding();
        IType type = null;
        try {
            if (binding instanceof IEnumerator) {
                type = ((IEnumerator)binding).getType();
            } else if (binding instanceof IFunction) {
                type = ((IFunction)binding).getType();
            } else if (binding instanceof ITypedef) {
                type = ((ITypedef)binding).getType();
            } else if (binding instanceof IVariable) {
                type = ((IVariable)binding).getType();
            }
        }
        catch (DOMException dOMException) {
            return EMPTY_STRING;
        }
        if (type != null) {
            return ASTTypeUtil.getType(type);
        }
        return EMPTY_STRING;
    }

    public static String getNodeType(IASTNode node) {
        try {
            if (node instanceof IASTDeclarator) {
                return ASTTypeUtil.getType((IASTDeclarator)node);
            }
            if (node instanceof IASTName && ((IASTName)node).resolveBinding() instanceof IVariable) {
                return ASTTypeUtil.getType(((IVariable)((IASTName)node).resolveBinding()).getType());
            }
            if (node instanceof IASTName && ((IASTName)node).resolveBinding() instanceof IFunction) {
                return ASTTypeUtil.getType(((IFunction)((IASTName)node).resolveBinding()).getType());
            }
            if (node instanceof IASTName && ((IASTName)node).resolveBinding() instanceof IType) {
                return ASTTypeUtil.getType((IType)((Object)((IASTName)node).resolveBinding()));
            }
            if (node instanceof IASTTypeId) {
                return ASTTypeUtil.getType((IASTTypeId)node);
            }
        }
        catch (DOMException dOMException) {
            return EMPTY_STRING;
        }
        return EMPTY_STRING;
    }

    public static String getType(IASTTypeId typeId) {
        if (typeId instanceof CASTTypeId) {
            return ASTTypeUtil.createCType(typeId.getAbstractDeclarator());
        }
        if (typeId instanceof CPPASTTypeId) {
            return ASTTypeUtil.createCPPType(typeId.getAbstractDeclarator());
        }
        return EMPTY_STRING;
    }

    private static String createCType(IASTDeclarator declarator) {
        IType type = CVisitor.createType(declarator);
        return ASTTypeUtil.getType(type);
    }

    private static String createCPPType(IASTDeclarator declarator) {
        IType type = CPPVisitor.createType(declarator);
        return ASTTypeUtil.getType(type);
    }

    public static boolean isConst(IType type) {
        if (type instanceof IQualifierType) {
            try {
                return ((IQualifierType)type).isConst();
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        if (type instanceof ITypeContainer) {
            try {
                return ASTTypeUtil.isConst(((ITypeContainer)type).getType());
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        if (type instanceof IArrayType) {
            try {
                return ASTTypeUtil.isConst(((IArrayType)type).getType());
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        if (type instanceof ICPPReferenceType) {
            try {
                return ASTTypeUtil.isConst(((ICPPReferenceType)type).getType());
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        if (type instanceof IFunctionType) {
            try {
                return ASTTypeUtil.isConst(((IFunctionType)type).getReturnType());
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        if (type instanceof IPointerType) {
            try {
                return ASTTypeUtil.isConst(((IPointerType)type).getType());
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        if (type instanceof ITypedef) {
            try {
                return ASTTypeUtil.isConst(((ITypedef)type).getType());
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        return false;
    }
}

