/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.OrPattern;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.corext.template.c.CContextType;
import org.eclipse.cdt.internal.ui.CHelpProviderManager;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.CParameterListValidator;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposalComparator;
import org.eclipse.cdt.internal.ui.text.contentassist.CompletionEngine;
import org.eclipse.cdt.internal.ui.text.contentassist.ResultCollector;
import org.eclipse.cdt.internal.ui.text.template.TemplateEngine;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;

public class CCompletionProcessor
implements IContentAssistProcessor {
    protected IWorkingCopyManager fManager;
    private CEditor fEditor;
    private char[] fProposalAutoActivationSet;
    private CCompletionProposalComparator fComparator;
    private IContextInformationValidator fValidator;
    private TemplateEngine fTemplateEngine;
    private boolean fAllowAddIncludes;
    private BasicSearchResultCollector searchResultCollector = null;
    private ResultCollector resultCollector = null;
    private CompletionEngine completionEngine = null;
    private SearchEngine searchEngine = null;
    IWorkingCopy fCurrentSourceUnit = null;
    private int fCurrentOffset = 0;
    private IASTCompletionNode fCurrentCompletionNode = null;
    private int fNumberOfComputedResults = 0;
    private ITextViewer fTextViewer;

    public CCompletionProcessor(IEditorPart editor) {
        this.fEditor = (CEditor)editor;
        this.fManager = CUIPlugin.getDefault().getWorkingCopyManager();
        this.searchResultCollector = new BasicSearchResultCollector();
        this.resultCollector = new ResultCollector();
        this.completionEngine = new CompletionEngine(this.resultCollector);
        this.searchEngine = new SearchEngine();
        this.searchEngine.setWaitingPolicy(1);
        this.setupTemplateEngine();
        this.fAllowAddIncludes = true;
        this.fComparator = new CCompletionProposalComparator();
    }

    private void setupTemplateEngine() {
        TemplateContextType contextType = CUIPlugin.getDefault().getTemplateContextRegistry().getContextType("org.eclipse.cdt.ui.text.templates.c");
        if (contextType == null) {
            contextType = new CContextType();
            CUIPlugin.getDefault().getTemplateContextRegistry().addContextType(contextType);
        }
        if (contextType != null) {
            this.fTemplateEngine = new TemplateEngine(contextType);
        }
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator.setOrderAlphabetically(order);
    }

    public String getErrorMessage() {
        if (this.fNumberOfComputedResults == 0) {
            String errorMsg = this.resultCollector.getErrorMessage();
            if (errorMsg == null || errorMsg.length() == 0) {
                errorMsg = CUIMessages.getString("CEditor.contentassist.noCompletions");
            }
            return errorMsg;
        }
        return this.resultCollector.getErrorMessage();
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new CParameterListValidator();
        }
        return this.fValidator;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        List result = this.addContextInformations(viewer, offset);
        return result.toArray(new IContextInformation[result.size()]);
    }

    private List addContextInformations(ITextViewer viewer, int offset) {
        ICompletionProposal[] proposals = this.internalComputeCompletionProposals(viewer, offset);
        ArrayList<ContextInformationWrapper> result = new ArrayList<ContextInformationWrapper>();
        int i = 0;
        while (i < proposals.length) {
            IContextInformation contextInformation = proposals[i].getContextInformation();
            if (contextInformation != null) {
                ContextInformationWrapper wrapper = new ContextInformationWrapper(contextInformation);
                wrapper.setContextInformationPosition(offset);
                result.add(wrapper);
            }
            ++i;
        }
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    public void restrictProposalsToMatchingCases(boolean restrict) {
    }

    public void allowAddingIncludes(boolean allowAddingIncludes) {
        this.fAllowAddIncludes = allowAddingIncludes;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        return this.internalComputeCompletionProposals(viewer, offset);
    }

    private ICompletionProposal[] internalComputeCompletionProposals(ITextViewer viewer, int offset) {
        IWorkingCopy unit = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
        IDocument document = viewer.getDocument();
        int pos = offset - 1;
        if (pos >= 0) {
            try {
                if (document.getChar(pos) == ':' && document.getChar(pos - 1) != ':') {
                    return null;
                }
                if (document.getChar(pos) == '>' && document.getChar(pos - 1) != '-') {
                    return null;
                }
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        ICompletionProposal[] results = null;
        try {
            results = this.evalProposals(document, offset, unit, viewer);
        }
        catch (Exception e) {
            CUIPlugin.getDefault().log(e);
        }
        int n = this.fNumberOfComputedResults = results == null ? 0 : results.length;
        if (results == null) {
            results = new ICCompletionProposal[]{};
        }
        this.order((ICCompletionProposal[])results);
        return results;
    }

    private ICCompletionProposal[] order(ICCompletionProposal[] proposals) {
        if (proposals != null) {
            Arrays.sort(proposals, this.fComparator);
        }
        return proposals;
    }

    public ICCompletionProposal[] evalProposals(IDocument document, int documentOffset, IWorkingCopy unit, ITextViewer viewer) {
        this.fCurrentOffset = documentOffset;
        this.fCurrentSourceUnit = unit;
        this.fTextViewer = viewer;
        Vector completions = new Vector();
        if (this.fCurrentSourceUnit == null) {
            return null;
        }
        this.resultCollector.reset(viewer);
        this.fCurrentCompletionNode = this.addProposalsFromModel(completions);
        if (this.fCurrentCompletionNode != null) {
            this.addProposalsFromSearch(this.fCurrentCompletionNode, completions);
            this.addProposalsFromCompletionContributors(this.fCurrentCompletionNode, completions);
            this.addProposalsFromTemplates(viewer, this.fCurrentCompletionNode, completions);
            this.removeRepeatedProposals(completions);
            return this.order(completions.toArray(new ICCompletionProposal[0]));
        }
        return null;
    }

    private void removeRepeatedProposals(List completions) {
        int size = completions.size();
        ICCompletionProposal[] proposalsToCheck = completions.toArray(new ICCompletionProposal[size]);
        int i = 0;
        while (i < size) {
            int j = i + 1;
            while (j < size) {
                if (proposalsToCheck[i].equals(proposalsToCheck[j])) {
                    completions.remove(proposalsToCheck[j]);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private void addProposalsFromTemplates(ITextViewer viewer, IASTCompletionNode completionNode, List completions) {
        if (completionNode == null) {
            return;
        }
        if (viewer == null) {
            return;
        }
        completionNode.getCompletionKind();
        this.addProposalsFromTemplateEngine(viewer, this.fTemplateEngine, completions);
    }

    private void addProposalsFromTemplateEngine(ITextViewer viewer, TemplateEngine fTemplateEngine, List completions) {
        if (fTemplateEngine != null) {
            try {
                fTemplateEngine.reset();
                fTemplateEngine.complete(viewer, this.fCurrentOffset, (ITranslationUnit)this.fCurrentSourceUnit);
            }
            catch (Exception x) {
                CUIPlugin.getDefault().log(x);
            }
            completions.addAll(fTemplateEngine.getResults());
        }
    }

    private void addProposalsFromCompletionContributors(IASTCompletionNode completionNode, List completions) {
        if (completionNode == null) {
            return;
        }
        String prefix = completionNode.getCompletionPrefix();
        int offset = this.fCurrentOffset - prefix.length();
        int length = prefix.length();
        if (completionNode.getCompletionContext() != null) {
            return;
        }
        ICHelpInvocationContext context = new ICHelpInvocationContext(){

            public IProject getProject() {
                return CCompletionProcessor.this.fCurrentSourceUnit.getCProject().getProject();
            }

            public ITranslationUnit getTranslationUnit() {
                return CCompletionProcessor.this.fCurrentSourceUnit;
            }
        };
        IFunctionSummary[] summary = CHelpProviderManager.getDefault().getMatchingFunctions(context, prefix);
        if (summary == null) {
            return;
        }
        int i = 0;
        while (i < summary.length) {
            String fname = String.valueOf(summary[i].getName()) + "()";
            String fdesc = summary[i].getDescription();
            IFunctionSummary.IFunctionPrototypeSummary fproto = summary[i].getPrototype();
            String fargs = fproto.getArguments();
            CCompletionProposal proposal = new CCompletionProposal(fname, offset, length, CPluginImages.get("org.eclipse.cdt.ui.function_obj.gif"), fproto.getPrototypeString(true), 2, this.fTextViewer);
            if (fdesc != null) {
                proposal.setAdditionalProposalInfo(fdesc);
            }
            if (fargs != null && fargs.length() > 0) {
                proposal.setContextInformation((IContextInformation)new ContextInformation(fname, fargs));
                proposal.setCursorPosition(fname.length() - 1);
            }
            completions.add(proposal);
            ++i;
        }
    }

    private IASTCompletionNode addProposalsFromModel(List completions) {
        IASTCompletionNode completionNode = this.completionEngine.complete(this.fCurrentSourceUnit, this.fCurrentOffset);
        return completionNode;
    }

    private void addProposalsFromSearch(IASTCompletionNode completionNode, List completions) {
        if (completionNode == null) {
            return;
        }
        String prefix = completionNode.getCompletionPrefix();
        int offset = this.fCurrentOffset - prefix.length();
        int length = prefix.length();
        String searchPrefix = String.valueOf(prefix) + "*";
        IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
        boolean projectScope = store.getBoolean("content_assist_project_search_scope");
        ICSearchScope scope = null;
        if (projectScope && (completionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE || completionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE || completionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.VARIABLE_TYPE || completionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.FIELD_TYPE) && prefix.length() > 0) {
            LinkedList elementsFound = new LinkedList();
            ICElement[] projectScopeElement = new ICElement[]{this.fCurrentSourceUnit.getCProject()};
            scope = SearchEngine.createCSearchScope((ICElement[])projectScopeElement, (boolean)true);
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.ENUM, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.MACRO, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)false));
            if (completionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE || completionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)false));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)searchPrefix, (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            }
            try {
                this.searchEngine.search(CUIPlugin.getWorkspace(), (ICSearchPattern)orPattern, scope, (ICSearchResultCollector)this.searchResultCollector, true);
            }
            catch (InterruptedException interruptedException) {}
            elementsFound.addAll(this.searchResultCollector.getSearchResults());
            this.sendResultsToCollector(elementsFound.iterator(), offset, length, prefix);
        }
        completions.addAll(this.resultCollector.getCompletions());
    }

    private void sendResultsToCollector(Iterator results, int completionStart, int completionLength, String prefix) {
        while (results.hasNext()) {
            BasicSearchMatch match = (BasicSearchMatch)results.next();
            int type = match.getElementType();
            int relevance = this.completionEngine.computeRelevance(type, prefix, match.getName());
            switch (type) {
                case 72: {
                    ASTAccessVisibility visibility;
                    switch (match.getVisibility()) {
                        case 8192: {
                            visibility = ASTAccessVisibility.PUBLIC;
                            break;
                        }
                        case 16384: {
                            visibility = ASTAccessVisibility.PROTECTED;
                            break;
                        }
                        default: {
                            visibility = ASTAccessVisibility.PRIVATE;
                        }
                    }
                    this.resultCollector.acceptField(match.getName(), match.getReturnType(), visibility, completionStart, completionLength, relevance);
                    break;
                }
                case 76: 
                case 77: {
                    this.resultCollector.acceptVariable(match.getName(), match.getReturnType(), completionStart, completionLength, relevance);
                    break;
                }
                case 70: 
                case 71: {
                    ASTAccessVisibility visibility;
                    switch (match.getVisibility()) {
                        case 8192: {
                            visibility = ASTAccessVisibility.PUBLIC;
                            break;
                        }
                        case 16384: {
                            visibility = ASTAccessVisibility.PROTECTED;
                            break;
                        }
                        default: {
                            visibility = ASTAccessVisibility.PRIVATE;
                        }
                    }
                    this.resultCollector.acceptMethod(match.getName(), null, match.getReturnType(), visibility, completionStart, completionLength, relevance, true, completionStart);
                    break;
                }
                case 73: 
                case 74: {
                    this.resultCollector.acceptFunction(match.getName(), null, match.getReturnType(), completionStart, completionLength, relevance, true, completionStart);
                    break;
                }
                case 65: {
                    this.resultCollector.acceptClass(match.getName(), completionStart, completionLength, relevance);
                    break;
                }
                case 67: {
                    this.resultCollector.acceptStruct(match.getName(), completionStart, completionLength, relevance);
                    break;
                }
                case 69: {
                    this.resultCollector.acceptUnion(match.getName(), completionStart, completionLength, relevance);
                    break;
                }
                case 61: {
                    this.resultCollector.acceptNamespace(match.getName(), completionStart, completionLength, relevance);
                    break;
                }
                case 79: {
                    this.resultCollector.acceptMacro(match.getName(), completionStart, completionLength, relevance, completionStart);
                    break;
                }
                case 63: {
                    this.resultCollector.acceptEnumeration(match.getName(), completionStart, completionLength, relevance);
                    break;
                }
                case 81: {
                    this.resultCollector.acceptEnumerator(match.getName(), completionStart, completionLength, relevance);
                    break;
                }
            }
        }
    }

    public IASTCompletionNode getCurrentCompletionNode() {
        return this.fCurrentCompletionNode;
    }

    private static class ContextInformationWrapper
    implements IContextInformation,
    IContextInformationExtension {
        private final IContextInformation fContextInformation;
        private int fPosition;

        public ContextInformationWrapper(IContextInformation contextInformation) {
            this.fContextInformation = contextInformation;
        }

        public String getContextDisplayString() {
            return this.fContextInformation.getContextDisplayString();
        }

        public Image getImage() {
            return this.fContextInformation.getImage();
        }

        public String getInformationDisplayString() {
            return this.fContextInformation.getInformationDisplayString();
        }

        public int getContextInformationPosition() {
            return this.fPosition;
        }

        public void setContextInformationPosition(int position) {
            this.fPosition = position;
        }
    }
}

