/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.ui.index.AbstractIndexerPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class CTagsIndexerBlock
extends AbstractIndexerPage {
    protected boolean internalTagsFile = true;
    protected boolean externalTagsFile = false;
    protected Button internalCTagsFile;
    protected Button externalCTagsFile;
    protected Button indexIncludePaths;
    protected Button browseButton;
    protected Text cTagsFile;
    protected boolean useDefaultCTags = true;
    protected boolean useSpecifiedCTagsExecutable = false;
    protected Button useCTagsPath;
    protected Button useCTagsExecutable;
    protected Button browseButtonCTagsExec;
    protected Text cTagsExecutable;
    public static final String PREF_INTOREXT_CTAGS = "org.eclipse.cdt.ui.intorextctags";
    public static final String PREF_CTAGS_FILE_LOCATION_CTAGS = "org.eclipse.cdt.ui.ctagsfilelocation";
    public static final String PREF_CTAGS_INDEXINCLUDEFILES = "org.eclipse.cdt.ui.ctagsindexincludes";
    public static final String PREF_CTAGS_LOCATION_TYPE = "org.eclipse.cdt.ui.ctagslocationtype";
    public static final String PREF_CTAGS_LOCATION = "org.eclipse.cdt.ui.ctagslocation";

    public void initialize(IProject project) {
        this.currentProject = project;
        try {
            this.loadPersistedValues(project);
        }
        catch (CoreException coreException) {}
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(CUIMessages.getString("IndexerOptiosn.task.savingAttributes "), 1);
        ICOptionContainer container = this.getContainer();
        IProject proj = null;
        String internalExternalCTagsString = this.internalTagsFile ? "ctags_internal" : "ctags_external";
        String cTagsFileLocation = "";
        if (!this.internalTagsFile) {
            cTagsFileLocation = this.cTagsFile.getText();
        }
        String indexIncludeFiles = new Boolean(this.indexIncludePaths.getSelection()).toString();
        String cTagsLocationType = this.useDefaultCTags ? "ctags_path_default" : "ctags_path_specified";
        String cTagsLocation = "";
        if (!this.useDefaultCTags) {
            cTagsLocation = this.cTagsExecutable.getText();
        }
        if (internalExternalCTagsString.equals("ctags_external") && cTagsFileLocation.equals("")) {
            internalExternalCTagsString = "ctags_internal";
        }
        if (cTagsLocationType.equals("ctags_path_specified") && cTagsLocation.equals("")) {
            cTagsLocationType = "ctags_path_default";
        }
        if ((proj = container != null ? container.getProject() : this.currentProject) != null) {
            ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(proj, false);
            ICExtensionReference[] cext = cdesc.get("org.eclipse.cdt.core.CIndexer");
            if (cext.length > 0) {
                int i = 0;
                while (i < cext.length) {
                    String orig = cext[i].getExtensionData("ctagfiletype");
                    if (orig == null || !orig.equals(internalExternalCTagsString)) {
                        cext[i].setExtensionData("ctagfiletype", internalExternalCTagsString);
                    }
                    if ((orig = cext[i].getExtensionData("ctagfilelocation")) == null || !orig.equals(cTagsFileLocation)) {
                        cext[i].setExtensionData("ctagfilelocation", cTagsFileLocation);
                    }
                    if ((orig = cext[i].getExtensionData("ctagsindexincludes")) == null || !orig.equals(indexIncludeFiles)) {
                        cext[i].setExtensionData("ctagsindexincludes", indexIncludeFiles);
                        if (indexIncludeFiles.equals("true")) {
                            CCorePlugin.getDefault().getCoreModel().getIndexManager().addResource(proj, (IResource)proj);
                        }
                    }
                    if ((orig = cext[i].getExtensionData("ctagslocationtype")) == null || !orig.equals(cTagsLocationType)) {
                        cext[i].setExtensionData("ctagslocationtype", cTagsLocationType);
                    }
                    if ((orig = cext[i].getExtensionData("ctagslocation")) == null || !orig.equals(cTagsLocation)) {
                        cext[i].setExtensionData("ctagslocation", cTagsLocation);
                    }
                    ++i;
                }
            }
        } else if (this.prefStore != null) {
            this.prefStore.setValue(PREF_INTOREXT_CTAGS, internalExternalCTagsString);
            this.prefStore.setValue(PREF_CTAGS_FILE_LOCATION_CTAGS, cTagsFileLocation);
            this.prefStore.setValue(PREF_CTAGS_INDEXINCLUDEFILES, indexIncludeFiles);
            this.prefStore.setValue(PREF_CTAGS_LOCATION_TYPE, cTagsLocationType);
            this.prefStore.setValue(PREF_CTAGS_LOCATION, cTagsLocation);
        }
    }

    public void performDefaults() {
        this.internalTagsFile = true;
        this.externalTagsFile = false;
        this.internalCTagsFile.setSelection(true);
        this.externalCTagsFile.setSelection(false);
        this.cTagsFile.setText("");
        this.browseButton.setEnabled(false);
        this.useDefaultCTags = true;
        this.useSpecifiedCTagsExecutable = false;
        this.useCTagsPath.setSelection(true);
        this.useCTagsExecutable.setSelection(false);
        this.cTagsExecutable.setText("");
        this.browseButtonCTagsExec.setEnabled(false);
        this.indexIncludePaths.setSelection(false);
    }

    public void createControl(Composite parent) {
        Composite page = ControlFactory.createComposite(parent, 1);
        Group cTagsExecutableGroup = ControlFactory.createGroup(page, CUIMessages.getString("CTagsIndexerBlock.ctagsLocation"), 3);
        GridData gd3 = (GridData)cTagsExecutableGroup.getLayoutData();
        gd3.grabExcessHorizontalSpace = true;
        gd3.horizontalAlignment = 4;
        SelectionAdapter cTagsListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTagsIndexerBlock.this.useDefaultCTags = CTagsIndexerBlock.this.useCTagsPath.getSelection();
                CTagsIndexerBlock.this.useSpecifiedCTagsExecutable = CTagsIndexerBlock.this.useCTagsExecutable.getSelection();
                if (CTagsIndexerBlock.this.useDefaultCTags) {
                    CTagsIndexerBlock.this.setButtonState("ctags_path_default");
                }
                if (CTagsIndexerBlock.this.useSpecifiedCTagsExecutable) {
                    CTagsIndexerBlock.this.setButtonState("ctags_path_specified");
                }
            }
        };
        this.useCTagsPath = ControlFactory.createRadioButton((Composite)cTagsExecutableGroup, CUIMessages.getString("CTagsIndexerBlock.radioButtonCTagsDefault"), "CTagsDefault", (SelectionListener)cTagsListener);
        ((GridData)this.useCTagsPath.getLayoutData()).horizontalSpan = 3;
        ((GridData)this.useCTagsPath.getLayoutData()).grabExcessHorizontalSpace = true;
        this.useCTagsPath.setSelection(this.internalTagsFile);
        this.useCTagsExecutable = ControlFactory.createRadioButton((Composite)cTagsExecutableGroup, CUIMessages.getString("CTagsIndexerBlock.radioButtonCTagsSpecified"), "CTafsSpecified", (SelectionListener)cTagsListener);
        ((GridData)this.useCTagsExecutable.getLayoutData()).horizontalSpan = 3;
        ((GridData)this.useCTagsExecutable.getLayoutData()).grabExcessHorizontalSpace = true;
        this.cTagsExecutable = ControlFactory.createTextField((Composite)cTagsExecutableGroup);
        ((GridData)this.cTagsExecutable.getLayoutData()).horizontalSpan = 2;
        ((GridData)this.cTagsExecutable.getLayoutData()).grabExcessHorizontalSpace = true;
        this.browseButtonCTagsExec = ControlFactory.createPushButton((Composite)cTagsExecutableGroup, CUIMessages.getString("CTagsIndexerBlock.browseButton"));
        ((GridData)this.browseButtonCTagsExec.getLayoutData()).widthHint = SWTUtil.getButtonWidthHint(this.browseButtonCTagsExec);
        this.browseButtonCTagsExec.setEnabled(false);
        this.browseButtonCTagsExec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                this.handleBrowseButtonSelected();
            }

            void handleBrowseButtonSelected() {
                CTagsIndexerBlock.this.cTagsExecutable.setText(CTagsIndexerBlock.this.openFileBrowser());
            }
        });
        Group includeGroup = ControlFactory.createGroup(page, CUIMessages.getString("CTagsIndexerBlock.includeGroup"), 1);
        GridData gd2 = (GridData)includeGroup.getLayoutData();
        gd2.grabExcessHorizontalSpace = true;
        gd2.horizontalAlignment = 4;
        this.indexIncludePaths = ControlFactory.createCheckBox((Composite)includeGroup, CUIMessages.getString("CTagsIndexerBlock.indexIncludes"));
        ((GridData)this.indexIncludePaths.getLayoutData()).horizontalSpan = 1;
        ((GridData)this.indexIncludePaths.getLayoutData()).grabExcessHorizontalSpace = true;
        Group group = ControlFactory.createGroup(page, CUIMessages.getString("CTagsIndexerBlock.blockName"), 3);
        GridData gd = (GridData)group.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        SelectionAdapter cListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTagsIndexerBlock.this.internalTagsFile = CTagsIndexerBlock.this.internalCTagsFile.getSelection();
                CTagsIndexerBlock.this.externalTagsFile = CTagsIndexerBlock.this.externalCTagsFile.getSelection();
                if (CTagsIndexerBlock.this.externalTagsFile) {
                    CTagsIndexerBlock.this.setButtonState("ctags_external");
                }
                if (CTagsIndexerBlock.this.internalTagsFile) {
                    CTagsIndexerBlock.this.setButtonState("ctags_internal");
                }
            }
        };
        this.internalCTagsFile = ControlFactory.createRadioButton((Composite)group, CUIMessages.getString("CTagsIndexerBlock.radioButtonInternal"), "Internal", (SelectionListener)cListener);
        ((GridData)this.internalCTagsFile.getLayoutData()).horizontalSpan = 3;
        ((GridData)this.internalCTagsFile.getLayoutData()).grabExcessHorizontalSpace = true;
        this.internalCTagsFile.setSelection(this.internalTagsFile);
        this.externalCTagsFile = ControlFactory.createRadioButton((Composite)group, CUIMessages.getString("CTagsIndexerBlock.radioButtonExternal"), "External", (SelectionListener)cListener);
        ((GridData)this.externalCTagsFile.getLayoutData()).horizontalSpan = 3;
        ((GridData)this.externalCTagsFile.getLayoutData()).grabExcessHorizontalSpace = true;
        this.cTagsFile = ControlFactory.createTextField((Composite)group);
        ((GridData)this.cTagsFile.getLayoutData()).horizontalSpan = 2;
        ((GridData)this.cTagsFile.getLayoutData()).grabExcessHorizontalSpace = true;
        this.browseButton = ControlFactory.createPushButton((Composite)group, CUIMessages.getString("CTagsIndexerBlock.browseButton"));
        ((GridData)this.browseButton.getLayoutData()).widthHint = SWTUtil.getButtonWidthHint(this.browseButton);
        this.browseButton.setEnabled(false);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                this.handleBrowseButtonSelected();
            }

            private void handleBrowseButtonSelected() {
                CTagsIndexerBlock.this.cTagsFile.setText(CTagsIndexerBlock.this.openFileBrowser());
            }
        });
        this.setControl((Control)page);
    }

    String openFileBrowser() {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(CUIMessages.getString("CTagsIndexerBlock.fileBrowser"));
        String fileName = dialog.open();
        if (fileName == null) {
            return "";
        }
        return fileName;
    }

    public void loadPersistedValues(IProject project) throws CoreException {
        ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(project, false);
        ICExtensionReference[] cext = cdesc.get("org.eclipse.cdt.core.CIndexer");
        if (cext.length > 0) {
            int i = 0;
            while (i < cext.length) {
                String orig = cext[i].getExtensionData("ctagfiletype");
                if (orig != null) {
                    this.setButtonState(orig);
                }
                if ((orig = cext[i].getExtensionData("ctagfilelocation")) != null) {
                    this.cTagsFile.setText(orig);
                }
                if ((orig = cext[i].getExtensionData("ctagsindexincludes")) != null) {
                    if (new Boolean(orig).booleanValue()) {
                        this.indexIncludePaths.setSelection(true);
                    } else {
                        this.indexIncludePaths.setSelection(false);
                    }
                }
                if ((orig = cext[i].getExtensionData("ctagslocationtype")) != null) {
                    this.setButtonState(orig);
                }
                if ((orig = cext[i].getExtensionData("ctagslocation")) != null) {
                    this.cTagsExecutable.setText(orig);
                }
                ++i;
            }
        }
    }

    private void setButtonState(String orig) {
        if (orig.equals("ctags_internal")) {
            this.internalTagsFile = true;
            this.externalTagsFile = false;
            this.internalCTagsFile.setSelection(true);
            this.externalCTagsFile.setSelection(false);
            this.browseButton.setEnabled(false);
        } else if (orig.equals("ctags_external")) {
            this.externalTagsFile = true;
            this.internalTagsFile = false;
            this.externalCTagsFile.setSelection(true);
            this.internalCTagsFile.setSelection(false);
            this.browseButton.setEnabled(true);
        } else if (orig.equals("ctags_path_default")) {
            this.useDefaultCTags = true;
            this.useSpecifiedCTagsExecutable = false;
            this.useCTagsPath.setSelection(true);
            this.useCTagsExecutable.setSelection(false);
            this.browseButtonCTagsExec.setEnabled(false);
        } else if (orig.equals("ctags_path_specified")) {
            this.useDefaultCTags = false;
            this.useSpecifiedCTagsExecutable = true;
            this.useCTagsPath.setSelection(false);
            this.useCTagsExecutable.setSelection(true);
            this.browseButtonCTagsExec.setEnabled(true);
        }
    }

    public void loadPreferences() {
        String indexerId = this.prefStore.getString(PREF_INTOREXT_CTAGS);
        if (!indexerId.equals("")) {
            this.setButtonState(indexerId);
        }
        if (!(indexerId = this.prefStore.getString(PREF_CTAGS_FILE_LOCATION_CTAGS)).equals("")) {
            this.cTagsFile.setText(indexerId);
        }
    }

    public void removePreferences() {
        this.prefStore.setToDefault(PREF_CTAGS_FILE_LOCATION_CTAGS);
        this.prefStore.setToDefault(PREF_INTOREXT_CTAGS);
    }
}

