/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.cache;

import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.core.index.ICDTIndexer;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexer;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.IIndexJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public abstract class IndexerJob
implements IIndexJob {
    private IndexManager fIndexManager;
    private IProject fProject;
    private IIndex fProjectIndex = null;
    private DOMSourceIndexer fSourceIndexer = null;
    public static final String FAMILY = "BasicTypeIndexerJob";

    public IndexerJob(IndexManager indexManager, IProject project) {
        this.fIndexManager = indexManager;
        this.fProject = project;
        ICDTIndexer indexer = indexManager.getIndexerForProject(project);
        if (indexer instanceof DOMSourceIndexer) {
            this.fSourceIndexer = (DOMSourceIndexer)indexer;
        }
    }

    public boolean belongsTo(String family) {
        return family == FAMILY;
    }

    public void cancel() {
    }

    public boolean isReadyToRun() {
        if (this.fProjectIndex == null) {
            this.getIndexForProject(this.fProject);
        }
        return true;
    }

    public String toString() {
        return FAMILY;
    }

    protected abstract boolean processIndex(IIndex var1, IProject var2, IProgressMonitor var3) throws InterruptedException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        boolean bl;
        block9: {
            block8: {
                boolean success = false;
                try {
                    try {
                        this.fProjectIndex = this.getIndexForProject(this.fProject);
                        if (this.fProjectIndex == null) {
                            Object var3_3 = null;
                            break block8;
                        }
                        if (progressMonitor == null) {
                            progressMonitor = new NullProgressMonitor();
                        }
                        if (progressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        progressMonitor.beginTask("", 1);
                        success = this.prepareIndex(this.fProjectIndex, this.fProject, progressMonitor);
                        if (progressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        progressMonitor.worked(1);
                        bl = success;
                        break block9;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new OperationCanceledException();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    progressMonitor.done();
                    throw throwable;
                }
            }
            progressMonitor.done();
            return false;
        }
        Object var3_4 = null;
        progressMonitor.done();
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean prepareIndex(IIndex index, IProject project, IProgressMonitor progressMonitor) throws InterruptedException {
        if (progressMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        if (index == null) {
            return true;
        }
        if (this.fSourceIndexer == null) {
            return false;
        }
        ReadWriteMonitor monitor = this.fSourceIndexer.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            block12: {
                monitor.enterRead();
                if (!index.hasChanged()) break block12;
                try {
                    try {
                        monitor.exitRead();
                        monitor.enterWrite();
                        this.fSourceIndexer.saveIndex(index);
                    }
                    catch (IOException iOException) {
                        Object var5_5 = null;
                        monitor.exitWriteEnterRead();
                        Object var7_8 = null;
                        monitor.exitRead();
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    monitor.exitWriteEnterRead();
                    throw throwable;
                }
                {
                    Object var5_7 = null;
                    monitor.exitWriteEnterRead();
                }
            }
            if (progressMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            boolean bl = this.processIndex(index, project, progressMonitor);
            Object var7_9 = null;
            monitor.exitRead();
            return bl;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            monitor.exitRead();
            throw throwable;
        }
    }

    private IIndex getIndexForProject(IProject project) {
        IPath location;
        IPath path;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (!(root.getProject((path = project.getFullPath()).lastSegment()).exists() || path.segmentCount() <= 1 || (location = root.getFile(path).getLocation()) != null && new File(location.toOSString()).exists() || new File(path.toOSString()).exists())) {
            return null;
        }
        if (this.fSourceIndexer != null) {
            return this.fSourceIndexer.getIndex(path, true, false);
        }
        return null;
    }
}

